<?php

include_once '../../model/modelMantenedores/ModeloCronogramaPago.php';
include_once '../../util/ClassUtil.php';

class NegocioCronogramaPago {

    public function obtenerConfiguracionesInicialesForm() {
        $result->dataClientes = $this->obtenerClientes();
        return $result;
    }

    public function obtenerClientes() {
        $data = new ModeloCronogramaPago();
        return $data->obtenerClientes();
    }

    public function guardarCronograma($paramEnviar) {
        $fechaInstalacion = $paramEnviar['fechaInstalacion'];
        $fechaPago = $paramEnviar['fechaPago'];
        $arrClientes = $paramEnviar['arrClientes'];
        $monto = $paramEnviar['monto'];
        foreach ($arrClientes as $key => $value) {
            $result = $this->guardarFilaCronograma($value, $fechaInstalacion, $fechaPago, $monto);
        }
        return $result;
    }

    public function guardarFilaCronograma($id, $fechaInstalacion, $fechaPago, $monto) {
        $fechaInstalacion = ClassUtil::formatearCadenaACadenaBD($fechaInstalacion);
        $fechaPago = ClassUtil::formatearCadenaACadenaBD($fechaPago);
        $data = new ModeloCronogramaPago();
        return $data->guardarFilaCronograma($id, $fechaInstalacion, $fechaPago, $monto);
    }

    public function listarCronogramas() {
        $data = new ModeloCronogramaPago();
        $arrCronogramas = $data->listarCronogramas();

        $tabla = "";
        $activarAlarma = 0;
        foreach ($arrCronogramas as $key => $value) {
            $fechaActual = Date('Y-m-d');
            $diferenciaDias = ClassUtil::restarFechasDias($value["fecha_pago"], $fechaActual);
            if ($fechaActual > $value["fecha_pago"]) {
                $diferenciaDias = $diferenciaDias * -1;
            }

            $fechaPago = ClassUtil::formatearFechaACadenaVw($value["fecha_pago"]);
            $fechaInstalacion = ClassUtil::formatearFechaACadenaVw($value["fecha_instalacion"]);
            $descripcionPeriodo = $this->obtenerNombrePeriodo($value["periodo"], $value["anio"]);

            $color = '';
            if ($diferenciaDias <= 3) {
                $color = '#ef9a9a';
                $activarAlarma = 1;
            }

            $monto = number_format($value["monto"], 2, ".", ",");

            $tabla .= "<tr style='background: " . $color . ";'>";
            $tabla .= "<td>" . $value["codigoCliente"] . "</td>";
            $tabla .= "<td>" . $value["nombre"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $descripcionPeriodo . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaInstalacion . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaPago . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $diferenciaDias . "</td>";
            $tabla .= "<td style='text-align: right;'>" . $monto . "</td>";
            $tabla .= "<td style='text-align: center;'><a title='Editar' onclick='editarCliente(" . $value["idCliente"] . ",\"" . $fechaInstalacion . "\",\"" . $fechaPago . "\",\"" . $monto . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #ffea00;'>edit</i></a>";
            $tabla .= "<a title='Eliminar' onclick='abrirAlerta(" . $value["idCliente"] . ",\"" . $value["codigoCliente"] . "\",\"" . $value["periodo"] . "\",\"" . $value["anio"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a></td>";
            $tabla .= "</tr>";
        }

        $respuesta->tabla = $tabla;
        $respuesta->activarAlarma = $activarAlarma;
        return $respuesta;
    }

    public function obtenerNombrePeriodo($periodo, $anio) {
        $nombre = '';
        switch ($periodo * 1) {
            case 1:
                $nombre = 'Ene-' . $anio;
                break;
            case 2:
                $nombre = 'Feb-' . $anio;
                break;
            case 3:
                $nombre = 'Mar-' . $anio;
                break;
            case 4:
                $nombre = 'Abr-' . $anio;
                break;
            case 5:
                $nombre = 'May-' . $anio;
                break;
            case 6:
                $nombre = 'Jun-' . $anio;
                break;
            case 7:
                $nombre = 'Jul-' . $anio;
                break;
            case 8:
                $nombre = 'Ago-' . $anio;
                break;
            case 9:
                $nombre = 'Sep-' . $anio;
                break;
            case 10:
                $nombre = 'Oct-' . $anio;
                break;
            case 11:
                $nombre = 'Nov-' . $anio;
                break;
            case 12:
                $nombre = 'Dic-' . $anio;
                break;
        }
        return $nombre;
    }

    public function eliminarCronograma($paramEnviar) {
        $mes = $paramEnviar['mes'];
        $anio = $paramEnviar['anio'];
        $idCliente = $paramEnviar['idCliente'];
        $data = new ModeloCronogramaPago();
        return $data->eliminarCronograma($mes, $anio, $idCliente);
    }

}
