<?php

include_once '../../model/modelProcesos/ModeloControlPago.php';
include_once '../../util/ClassUtil.php';

class NegocioControlPago {

    public function obtenerConfiguracionesForm($paramEnviar) {
        $idPago = $paramEnviar['id'];

        if (!ClassUtil::isEmpty($idPago)) {
            $respuesta->dataPago = $this->obtenerDatosPago($idPago);
        }
        $respuesta->dataCliente = $this->obtenerDatosCliente();
        $respuesta->dataBancos = $this->obtenerBancos();
        return $respuesta;
    }

    public function obtenerDatosPago($idPago) {
        $data = new ModeloControlPago();
        return $data->obtenerDatosPago($idPago);
    }

    public function obtenerBancos() {
        $data = new ModeloControlPago();
        return $data->obtenerBancos();
    }

    public function obtenerDatosCliente() {
        $data = new ModeloControlPago();
        return $data->obtenerDatosCliente();
    }

    public function guardarPago($paramEnviar) {
        $idPago = $paramEnviar['id'];
        $fechaPago = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaPago']);
        $nroOperacion = $paramEnviar['nroOperacion'];
        $monto = $paramEnviar['monto'];
        $comentario = $paramEnviar['comentario'];
        $idCliente = $paramEnviar['idCliente'];
        $mes = $paramEnviar['mes'];
        $anio = $paramEnviar['anio'];
        $banco = $paramEnviar['banco'];
        $inicio = $paramEnviar['inicio'];
        $fin = $paramEnviar['fin'];
        $data = new ModeloControlPago();
        $result = $data->guardarPago($idPago, $fechaPago, $nroOperacion, $monto, $comentario, $idCliente, $mes, $anio, $banco, $inicio, $fin);

        $idPagoR = $result['idPago'];

        if (!ClassUtil::isEmpty($idPagoR)) {
            $res = $this->actualizarCronogramaPago($idPagoR);
        }

        if ($res['success'] * 1 != 1) {
            $result = array('success' => 0, 'mensaje' => 'No se encontro deuda para el mes !');
        }
        return $result;
    }

    public function actualizarCronogramaPago($idPagoR) {
        $data = new ModeloControlPago();
        $result = $data->actualizarCronogramaPago($idPagoR);
        return $result;
    }

    public function listarPagos() {
        $data = new ModeloControlPago();
        $arrCronogramas = $data->listarPagos();

        $tabla = "";
        foreach ($arrCronogramas as $key => $value) {
            $fechaPago = ClassUtil::formatearFechaACadenaVw($value["fecha_pago"]);
            $descripcionPeriodo = $this->obtenerNombrePeriodo($value["periodo"], $value["anio"]);
            $tabla .= "<tr>";
            $tabla .= "<td>" . $value["nombre"] . "</td>";
            $tabla .= "<td>" . $value["banco"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaPago . "</td>";
            $tabla .= "<td>" . $value["numero_operacion"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $descripcionPeriodo . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["monto"], 2, ".", ",") . "</td>";
            $tabla .= "<td>" . $value["comentario"] . "</td>";
            $tabla .= "<td style='text-align: center;'><a title='Recibo' onclick='imprimirRecibo(" . $value["id"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #3d5afe;'>receipt</i></a>";
//            $tabla .= "<a title='Editar' onclick='editarPago(" . $value["id"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #ffea00;'>edit</i></a>";
            $tabla .= "<a title='Eliminar' onclick='abrirAlertaEliminar(" . $value["id"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a></td>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    public function obtenerNombrePeriodo($periodo, $anio) {
        $nombre = '';
        switch ($periodo * 1) {
            case 1:
                $nombre = 'Ene-' . $anio;
                break;
            case 2:
                $nombre = 'Feb-' . $anio;
                break;
            case 3:
                $nombre = 'Mar-' . $anio;
                break;
            case 4:
                $nombre = 'Abr-' . $anio;
                break;
            case 5:
                $nombre = 'May-' . $anio;
                break;
            case 6:
                $nombre = 'Jun-' . $anio;
                break;
            case 7:
                $nombre = 'Jul-' . $anio;
                break;
            case 8:
                $nombre = 'Ago-' . $anio;
                break;
            case 9:
                $nombre = 'Sep-' . $anio;
                break;
            case 10:
                $nombre = 'Oct-' . $anio;
                break;
            case 11:
                $nombre = 'Nov-' . $anio;
                break;
            case 12:
                $nombre = 'Dic-' . $anio;
                break;
        }
        return $nombre;
    }

    public function eliminarPago($paramEnviar) {
        $idPago = $paramEnviar['idPago'];
        $data = new ModeloControlPago();
        return $data->eliminarPago($idPago);
    }

}
