<?php

include_once '../../model/modelReportes/ModeloReportePagos.php';
include_once '../../util/ClassUtil.php';
include_once '../../app-assets/mpdf/mpdf.php';

class NegocioReportePagos {

    public function listarReportePagos($paramEnviar) {

        $fechaInicio = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaInicio']);
        $fechaFin = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaFin']);
        $data = new ModeloReportePagos();
        $arrCronogramas = $data->listarReportePagos($fechaInicio, $fechaFin);

        $tabla = "";
        foreach ($arrCronogramas as $key => $value) {
            $fechaPagoVoucher = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_voucher"]);
            $fechaPagoCronograma = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_cronograma"]);
            $fechaPagoInicio = ClassUtil::formatearFechaACadenaVw($value["fecha_inicio"]);
            $fechaPagoFin = ClassUtil::formatearFechaACadenaVw($value["fecha_fin"]);
            $descripcionPeriodo = $fechaPagoInicio . '-' . $fechaPagoFin;
            $tabla .= "<tr>";
            $tabla .= "<td>" . $value["codigoCliente"] . "</td>";
            $tabla .= "<td>" . $value["nombre"] . "</td>";
            $tabla .= "<td>" . $value["banco"] . "</td>";
            $tabla .= "<td>" . $value["numero_operacion"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaPagoVoucher . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["monto"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["monto_crono"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $descripcionPeriodo . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaPagoCronograma . "</td>";
            $tabla .= "<td>" . $value["comentario"] . "</td>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    public function exportarPDF($paramEnviar) {

        $fechaInicio = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaInicio']);
        $fechaFin = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaFin']);
        $objData = new ModeloReportePagos();
        $arrData = $objData->listarReportePagos($fechaInicio, $fechaFin);

        //PDP PARA MANDAR EN EL CORREO
        $hoy = date("Y_m_d_H_i_s");
        $pdf = 'documento_' . $hoy . '.pdf';
        $url = __DIR__ . '/../../view/Reportes/formatosPDF/' . $pdf;

        $result->nombre = $pdf;
        $result->url = $url;

        //$data = new NegocioReportePagosPDF();
        $nombreArchivo = $this->generarReportePagosPdf($url, $arrData, $paramEnviar['fechaInicio'], $paramEnviar['fechaFin']);

        if (ClassUtil::isEmpty($nombreArchivo)) {
            $result = 0;
        }

        return $result;
    }

    public function generarReportePagosPdf($url, $dataExportar, $fechaInicio, $fechaFin) {

        $hoy = date("d/m/Y");
        if (!ClassUtil::isEmpty($fechaInicio) && !ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Desde ' . $fechaInicio . ' hasta ' . $fechaFin;
        } elseif (!ClassUtil::isEmpty($fechaInicio) && ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Desde ' . $fechaInicio . ' hasta ' . $hoy;
        } elseif (ClassUtil::isEmpty($fechaInicio) && !ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Hasta ' . $fechaFin;
        }


        $html = '<body>
            <main>
                <h3 class="alinearCentro">REPORTE DE PAGOS</h3>
                <h4 class="alinearIzquierda">' . $subtitulo . '</h4>
                <table style="width: 100%">
                    <thead>
                        <tr>
                            <th  class="tamanio10">CÓD. CLIE.</th>
                            <th  class="tamanio25">CLIENTE</th>
                            <th  class="tamanio15">BANCO</th>
                            <th  class="tamanio10">N°. OPERA.</th>
                            <th  class="tamanio10">F. PAGO VOUCH.</th>
                            <th  class="tamanio10">MONTO PAG.</th>
                            <th  class="tamanio10">MONTO CRO.</th>
                            <th  class="tamanio10">PERIODO</th>
                            <th  class="tamanio10">F. LIMITE</th>
                            <th  class="tamanio30">COMENTARIO</th>
                        </tr>
                    </thead>
                <tbody>';
        $montoTotal = 0;
        foreach ($dataExportar as $key => $value) {

            $fechaPagoVoucher = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_voucher"]);
            $fechaPagoCronograma = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_cronograma"]);
            $fechaPagoInicio = ClassUtil::formatearFechaACadenaVw($value["fecha_inicio"]);
            $fechaPagoFin = ClassUtil::formatearFechaACadenaVw($value["fecha_fin"]);
            $descripcionPeriodo = $fechaPagoInicio . '-' . $fechaPagoFin;

            $html .= '	<tr>
                    <td class="alinearCentro">' . $value["codigoCliente"] . '</td>
                    <td class="alinearIzquierda">' . $value["nombre"] . '</td>
                    <td class="alinearIzquierda">' . $value["banco"] . '</td>
                    <td class="alinearIzquierda">' . $value["numero_operacion"] . '</td>
                    <td class="alinearCentro">' . $fechaPagoVoucher . '</td>
                    <td class="alinearDerecha">' . number_format($value["monto"], 2, ".", ",") . '</td>
                    <td class="alinearDerecha">' . number_format($value["monto_crono"], 2, ".", ",") . '</td>
                    <td class="alinearCentro">' . $descripcionPeriodo . '</td>
                    <td class="alinearCentro">' . $fechaPagoCronograma . '</td>
                    <td class="alinearIzquierda">' . $value["comentario"] . '</td>
                </tr>';
            $montoTotal = $montoTotal + ($value["monto"] * 1);
        }
        $html .= '</tbody>
                <tfoot>
                    <tr>
                        <td class="alinearCentro" colspan="5">MONTO TOTAL</td>
                        <td class="alinearDerecha">' . number_format($montoTotal, 2, ".", ",") . '</td>
                        <td colspan="4"></th>
                        </tr>
                    </tfoot>
                </table>            
            </main> 
        </body>';

        $mpdf = new mPDF('c', 'A4');

        $css = file_get_contents('../../view/css/Procesos/imprimirOrdenCompra.css');
        $mpdf->writeHTML($css, 1);
        $mpdf->writeHTML($html, 2);
        $mpdf->Output($url, 'F');

        $nombrePdf = 'Reporte pago';

        return $nombrePdf;
    }

//    public function obtenerNombrePeriodo($periodo, $anio) {
//        $nombre = '';
//        switch ($periodo * 1) {
//            case 1:
//                $nombre = 'Ene-' . $anio;
//                break;
//            case 2:
//                $nombre = 'Feb-' . $anio;
//                break;
//            case 3:
//                $nombre = 'Mar-' . $anio;
//                break;
//            case 4:
//                $nombre = 'Abr-' . $anio;
//                break;
//            case 5:
//                $nombre = 'May-' . $anio;
//                break;
//            case 6:
//                $nombre = 'Jun-' . $anio;
//                break;
//            case 7:
//                $nombre = 'Jul-' . $anio;
//                break;
//            case 8:
//                $nombre = 'Ago-' . $anio;
//                break;
//            case 9:
//                $nombre = 'Sep-' . $anio;
//                break;
//            case 10:
//                $nombre = 'Oct-' . $anio;
//                break;
//            case 11:
//                $nombre = 'Nov-' . $anio;
//                break;
//            case 12:
//                $nombre = 'Dic-' . $anio;
//                break;
//        }
//        return $nombre;
//    }

    public function eliminarPdf($paramEnviar) {
        $url = $paramEnviar['url'];
        unlink($url);
        return 1;
    }

}
