<?php

require_once 'config.php';

class Conexion {

    private $datos = array(
        "host" => SERVER,
        "user" => USER,
        "pass" => PASS,
        "db" => DB
    );
    private $con;

    public function __construct() {
        $this->con = new mysqli(
                $this->datos['host'], $this->datos['user'], $this->datos['pass'], $this->datos['db']);
    }

    public function consultaSimple($sql) {
        $this->con->query("SET CHARACTER SET UTF8");
        $this->con->query($sql);
    }

    public function consultaRetorno($sql) {
        $this->con->query("SET CHARACTER SET UTF8");
        $datos = $this->con->query($sql);
        return $datos;
    }

    public function cerrarAbrir() {
        mysqli_close($this->con);
        $this->con = new mysqli(
                $this->datos['host'], $this->datos['user'], $this->datos['pass'], $this->datos['db']);
    }

    public function cerrar() {
        mysqli_close($this->con);
    }

    public function error() {
        return $this->con->error;
    }

    public function beginTransaction() {
        $this->con->autocommit(FALSE);
        $this->con->begin_transaction(MYSQLI_TRANS_START_WITH_CONSISTENT_SNAPSHOT);
    }

    public function commit() {
        $this->con->commit();
    }

    public function rollback() {
        $this->con->rollback();
    }

}

?>