<?php 
	include_once '../../model/conexion.php';

	class Oficina_model{
		private $param = array();
	    private $con;

	    public function __construct(){
	    	$this->con = new Conexion();
	    }	


	    public function gestionar($param){
	    	$this->param = $param;
	    	switch ($this->param['param_opcion'])
			{
				case 'mostrarOficinas':
					echo $this->mostrarOficinas();
					break;
				case 'guardarOficina':
					echo $this->guardarOficina();
					break;
				case 'obtenerOficina':
					echo $this->obtenerOficina();
					break;
				case 'editarOficina':
					echo $this->editarOficina();
					break;
				case 'eliminarOficina':
					echo $this->eliminarOficina();
					break;
				case 'comboOficina':
					echo $this->comboOficina();
					break;
			}
	    }
		
		private function mostrarOficinas(){
			$this->con->cerrarAbrir();
			$sql = "call sp_mostrarOficina(";
			$sql .= "0, ";
	    	$sql .= "1)";

	    	$tabla = "";
	    	$cont = 0;
			$datos = $this->con->consultaRetorno($sql);           
           	while($fila = mysqli_fetch_array($datos)){
           		$cont = $cont + 1;
            	$tabla .= "<tr>";
                    $tabla .= "<td>".$cont."</td>";
                    $tabla .= "<td>".$fila["nombre"]."</td>";
                    $tabla .= "<td>".$fila["direccion"]."</td>";
                    $tabla .= "<td class='alinearCentro'>".$fila["principal"]."</td>";
                    $tabla .= "<td class='alinearCentro'>".$fila["activo"]."</td>";
                    $tabla .= "<td class='alinearCentro'>
                    			<a href='#modalEditar' data-toggle='modal' class='btn btn-success btn-xs' onclick='obtenerOficina(".$fila["idOficina"].")'><i class='fa fa-pencil'></i>  </a>
                    			<a href='#modalEliminar' data-toggle='modal' class='btn btn-danger btn-xs' onclick='obtenerIdOficina(".$fila["idOficina"].")'><i class='fa fa-trash-o'></i> </a>                    			
                    		</td>";                    
                $tabla .= "</tr>";
            }      

        	return $tabla;       
		}

	    private function guardarOficina(){
	    	$this->con->cerrarAbrir();
			$sql = "call sp_insertUpdateOficina(";
			$sql .= "0,";
			$sql .= "'".$this->param['param_nombre']."', ";
			$sql .= "'".$this->param['param_direccion']."', ";
			$sql .= "".$this->param['param_principal'].", ";
			$sql .= "'".$_SESSION['usuario']."',";
			$sql .= "'".$_SESSION['usuario']."',";
			$sql .= "1, ";
			$sql .= "1) ";
			
			$tipoRespuesta = 0;
			$respuesta = "";
			try{
				 $datos = $this->con->consultaRetorno($sql);
				 $error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos)){
						$tipoRespuesta = $fila["tipoRespuesta"];
						$respuesta = $fila["respuesta"];
					}

					$resp = array(
						'success' => $tipoRespuesta,
						'mensaje' => $respuesta
					);
				}else{
					$resp = array(
						'success' => 0,
						'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql
					);
				}
			}
			catch(Exception $e){
				$resp = array(
					'success' => 0,
					'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

        	return json_encode($resp);
	    }

		private function obtenerOficina(){
			$this->con->cerrarAbrir();
			$sql = "call sp_mostrarOficina(";
			$sql .= "".$this->param['param_idOficina'].", ";
	    	$sql .= "3)";

			$datos = $this->con->consultaRetorno($sql);
           	while($fila = mysqli_fetch_array($datos)){
            	return json_encode($fila);
            } 
		}  
		
	    private function editarOficina(){
	    	$this->con->cerrarAbrir();
			$sql = "call sp_insertUpdateOficina(";
			$sql .= "".$this->param['param_idOficina'].", ";
			$sql .= "'".$this->param['param_nombre']."', ";
			$sql .= "'".$this->param['param_direccion']."', ";
			$sql .= "".$this->param['param_principal'].", ";
			$sql .= "'".$_SESSION['usuario']."',";
			$sql .= "'".$_SESSION['usuario']."',";
			$sql .= "".$this->param['param_activo'].", ";
			$sql .= "2) ";
			
			$tipoRespuesta = 0;
			$respuesta = "";
			try{
				 $datos = $this->con->consultaRetorno($sql);
				 $error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos)){
						$tipoRespuesta = $fila["tipoRespuesta"];
						$respuesta = $fila["respuesta"];
					}

					$resp = array(
						'success' => $tipoRespuesta,
						'mensaje' => $respuesta
					);
				}else{
					$resp = array(
						'success' => 0,
						'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql
					);
				}
			}
			catch(Exception $e){
				$resp = array(
					'success' => 0,
					'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

        	return json_encode($resp);
	    }

		private function eliminarOficina(){
			$this->con->cerrarAbrir();
			$sql = "call sp_eliminarOficina(";
			$sql .= "".$this->param['param_idOficina'].", ";
	    	$sql .= "1)";
			
			$tipoRespuesta = 0;
			$respuesta = "";
			try{
				 $datos = $this->con->consultaRetorno($sql);
				 $error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos)){
						$tipoRespuesta = $fila["tipoRespuesta"];
						$respuesta = $fila["respuesta"];
					}

					$resp = array(
						'success' => $tipoRespuesta,
						'mensaje' => $respuesta
					);
				}else{
					$resp = array(
						'success' => 0,
						'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql
					);
				}
			}
			catch(Exception $e){
				$resp = array(
					'success' => 0,
					'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

        	return json_encode($resp);
		}		

		private function comboOficina(){
			$this->con->cerrarAbrir();
			$sql = "call sp_mostrarOficina(";
			$sql .= "0, ";
	    	$sql .= "2)";

	    	$combo = "<option value=''>Seleccionar Oficina...</option>";

			$datos = $this->con->consultaRetorno($sql);           
           	while($fila = mysqli_fetch_array($datos)){
            	$combo .= "<option value='".$fila["idOficina"]."'>".$fila["direccion"]."</option>";                  
            }      
        	return $combo;
		}
	}
?>