<?php 
	include_once '../../model/conexion.php';

	class Dashboard_model{
		private $param = array();
	    private $con;

	    public function __construct(){
	    	$this->con = new Conexion();
	    }	


	    public function gestionar($param){
	    	$this->param = $param;
	    	switch ($this->param['param_opcion'])
			{
				case 'getGraficaMontosMes':
					echo $this->getGraficaMontosMes();
					break;
				case 'getGraficaInventario':
					echo $this->getGraficaInventario();
					break;
				case 'getGraficaCompras':
					echo $this->getGraficaCompras();
					break;
				default:
					echo "La opción no existe.";
					break;
			}
		}

		private function getGraficaMontosMes(){
			$this->con->cerrarAbrir();
			$sql = "call sp_getGraficaMontosMes(";
			$sql .= "".$this->param['param_anio']." ";
	    	$sql .= ")";

			$data = array();
			
			try{
				$datos = $this->con->consultaRetorno($sql);
				$error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos, MYSQL_ASSOC)){
						$data[] = $fila;
					}

					$resp = array( 'success' => 1, 'mensaje' => "Se realizó correctamente.", 'data' => $data);
				}else{
					$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'.');
					//$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql );
				}
			}
			catch(Exception $e){
				$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

			return json_encode($resp);
		}
		

		private function getGraficaInventario(){
			$this->con->cerrarAbrir();
			$sql = "call sp_getGraficaInventario(";
			$sql .= "'".$this->param['param_fechaCorteInventario']."', ";
			$sql .= "".$this->param['param_isCategoria'].", ";
			$sql .= "".$this->param['param_isSubategoria'].", ";
			$sql .= "".$this->param['param_isClase']." ";
	    	$sql .= ")";

			$data = array();
			
			try{
				$datos = $this->con->consultaRetorno($sql);
				$error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos, MYSQL_ASSOC)){
						$data[] = $fila;
					}

					$resp = array( 'success' => 1, 'mensaje' => "Se realizó correctamente.", 'data' => $data);
				}else{
					$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'.');
					//$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql );
				}
			}
			catch(Exception $e){
				$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

			return json_encode($resp);
		}

	    private function getGraficaCompras(){
			$this->con->cerrarAbrir();
			$sql = "call sp_getGraficaCompras(";
			$sql .= "'".$this->param['param_fechaDesde']."', ";
			$sql .= "'".$this->param['param_fechaHasta']."', ";
			$sql .= "".$this->param['param_isCategoria'].", ";
			$sql .= "".$this->param['param_isSubategoria'].", ";
			$sql .= "".$this->param['param_isClase']." ";
	    	$sql .= ")";

			$data = array();

			try{
				$datos = $this->con->consultaRetorno($sql);
				$error = $this->con->error();
				if ( $error == "" ){
					while($fila = mysqli_fetch_array($datos, MYSQL_ASSOC)){
						$data[] = $fila;
					}

					$resp = array( 'success' => 1, 'mensaje' => "Se realizó correctamente.", 'data' => $data);
				}else{
					$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'.');
					//$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$error.'. CONSULTA: '.$sql );
				}
			}
			catch(Exception $e){
				$resp = array( 'success' => 0, 'mensaje' => 'ERROR: '.$e->getMessage()//$this->con->error
				);
			}

			return json_encode($resp);
		}	
	}
?>