<?php

include_once '../../model/conexion.php';

class ModelCliente {

    private $param = array();
    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function obtenerComboMultitabla($depIdCliente) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarMultitablas(";
        $sql .= "0, ";
        $sql .= "" . $depIdCliente . ", ";
        $sql .= "5)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function listarClientes() {
        $idCliente = 0;
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarClientes(";
        $sql .= "" . $idCliente . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function registrarCliente($idCliente, $tipoCliente, $razonSocial, $nombre, $apePaterno, $apeMaterno, $tipoDoc, $nroDoc, $direccion, $referencia, $email) {

        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateCliente(";
        $sql .= "" . $idCliente . ", ";
        $sql .= "" . $tipoCliente . ", ";
        $sql .= "'" . $razonSocial . "', ";
        $sql .= "'" . $nombre . "', ";
        $sql .= "'" . $apePaterno . "', ";
        $sql .= "'" . $apeMaterno . "', ";
        $sql .= "" . $tipoDoc . ", ";
        $sql .= "'" . $nroDoc . "', ";
        $sql .= "'" . $direccion . "', ";
        $sql .= "'" . $referencia . "', ";
        $sql .= "'" . $email . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";

        try {
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $tipoRespuesta = $fila["tipoRespuesta"];
                    $respuesta = $fila["respuesta"];
                    $idCliente = $fila["idCliente"];
                }

                $resp = array('success' => $tipoRespuesta, 'mensaje' => $respuesta, 'idCliente' => $idCliente);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }

        return $resp;
    }

    public function obtenerDatosCliente($idCliente) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarClientes(";
        $sql .= "" . $idCliente . ", ";
        $sql .= "2)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function eliminarCliente($idCliente) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarCliente(";
        $sql .= "" . $idCliente . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

}
