<?php

include_once '../../model/conexion.php';

class ModeloCronogramaPago {

    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function obtenerClientes() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarClientes(";
        $sql .= "0, ";
        $sql .= "3)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function guardarFilaCronograma($id, $fechaInstalacion, $fechaPago, $monto) {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateCronogramaPago(";
        $sql .= "" . $id . ", ";
        $sql .= "'" . $fechaInstalacion . "', ";
        $sql .= "'" . $fechaPago . "', ";
        $sql .= "'" . $monto . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $mensaje = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function listarCronogramas() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarCronogramaPago()";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function eliminarCronograma($mes, $anio, $idCliente) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarCronogramaPago(";
        $sql .= "'" . $mes . "', ";
        $sql .= "'" . $anio . "', ";
        $sql .= "" . $idCliente . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

}
