<?php

include_once '../../model/conexion.php';

class ModeloControlPago {

    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function obtenerDatosCliente() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarUsuarioCliente(";
        $sql .= "" . $_SESSION['usuario_id_cp'] . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        $respuesta = "";
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }
        return $respuesta;
    }

    public function obtenerBancos() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarBancos(";
        $sql .= "1)";
        $arrDatos = array();
        $datos = $this->con->consultaRetorno($sql);
        $respuesta = "";
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function obtenerDatosPago($idPago) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarPagos(";
        $sql .= "" . $idPago . ", ";
        $sql .= "'" . $_SESSION['usuario'] . "', ";
        $sql .= "2)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function guardarPago($idPago, $fechaPago, $nroOperacion, $monto, $comentario, $idCliente, $mes, $anio, $banco, $inicio, $fin) {

        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdatePago(";
        $sql .= "" . $idPago . ", ";
        $sql .= "'" . $fechaPago . "', ";
        $sql .= "'" . $nroOperacion . "', ";
        $sql .= "'" . $monto . "', ";
        $sql .= "'" . $comentario . "', ";
        $sql .= "" . $idCliente . ", ";
        $sql .= "'" . $mes . "', ";
        $sql .= "'" . $anio . "', ";
        $sql .= "'" . $banco . "', ";
        $sql .= "'" . $inicio . "', ";
        $sql .= "'" . $fin . "', ";
        $sql .= "'" . $_SESSION['usuario_id_cp'] . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $id = $fila["id"];
                    $mensaje = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje, 'idPago' => $id);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function listarPagos() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarPagos(";
        $sql .= "0, ";
        $sql .= "'" . $_SESSION['usuario_id_cp'] . "', ";
        $sql .= "1)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function eliminarPago($idPago) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarPago(";
        $sql .= "" . $idPago . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

    public function actualizarCronogramaPago($idPagoR) {

        $this->con->cerrarAbrir();
        $sql = "call sp_updateCronogramaPago(";
        $sql .= "" . $idPagoR . ")";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                }

                $resp = array('success' => $respuesta);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

}
