-- phpMyAdmin SQL Dump
-- version 4.5.5.1
-- http://www.phpmyadmin.net
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 26-04-2020 a las 02:59:29
-- Versión del servidor: 5.7.11
-- Versión de PHP: 5.6.19

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `erp_targox`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_arreglarEntradas` (IN `p_idNotaAlmacen` INT, IN `p_idCompra` INT, IN `p_tipoOperacion` INT)  BEGIN     
	DECLARE v_total		decimal(18,2);    
    DECLARE nFilasProducto int;
    IF p_tipoOperacion = 1 THEN 
		
        CREATE TEMPORARY TABLE notas_temp as (
		SELECT NA.idNotaAlmacen, NA.idCompra, count(DNA.idDetaNota)
        FROM NOTA_ALMACEN NA
        LEFT JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
        WHERE NA.idCompra is not null
        GROUP BY NA.idNotaAlmacen
        HAVING count(DNA.idDetaNota) = 0);
        
		SET @nFilasProducto = (SELECT count(idNotaAlmacen) FROM notas_temp);
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
		
        WHILE @nFilasProducto > 0 DO
			SELECT idNotaAlmacen, idCompra 
			INTO p_idNotaAlmacen, p_idCompra
            FROM notas_temp order by idNotaAlmacen asc limit 1;
        
			INSERT INTO DETALLE_NOTA_ALMACEN ( 
				idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorPresentacion,
				precioPresentacion,
				valorUnitario,
				precioUnitario, 
				cantidad,
				valorVenta,
				monto, 
				cantidadTotal, cantidadUsada, cantidadSaldo, idUnidadMedida, unidadMedida, estado, 
				registro_fecha_add, registro_user_add, registro_pc_add,
				registro_fecha_update, registro_user_update, registro_pc_update, activo)
			SELECT p_idNotaAlmacen, DC.idProducto, DC.nombreProducto, DC.idPresentacion, DC.nombrePresentacion,
				DC.valorUnitario * C.tasaCambio as valorPresentacion,
				DC.precioUnitario * C.tasaCambio as precioPresentacion,    
				ROUND(  (DC.valorUnitario/ ifnull(PR.cantidad, 1) ) * C.tasaCambio, 2) as valorUnitario, 
				ROUND(  (DC.precioUnitario/ ifnull( PR.cantidad, 1)  ) * C.tasaCambio, 2) as precioUnitario, 
				DC.cantidad,
				ROUND(DC.valorVenta * C.tasaCambio, 2)  as valorVenta,
				ROUND(DC.monto * C.tasaCambio, 2)  as monto,
				DC.cantidadTotal, 0.00, DC.cantidadTotal, DC.idUnidadMedida, DC.unidadMedida, 'C', 
				now(), 'admin',  '-', 
				now(), 'admin', '-', 1		
			FROM DETALLE_COMPRA DC
			INNER JOIN COMPRA C ON C.idCompra = DC.idCompra
			LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
			WHERE DC.idCompra = p_idCompra;
			
			
			SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
			
			UPDATE NOTA_ALMACEN
				SET subTotal = @v_total - igv2,
					total = @v_total
			WHERE idNotaAlmacen = p_idNotaAlmacen;
			
			UPDATE PRODUCTO P, (SELECT idProducto, SUM(cantidadTotal) as cantidadTotal 
									FROM DETALLE_NOTA_ALMACEN 
									WHERE idNotaAlmacen = p_idNotaAlmacen GROUP BY idProducto)  S
			SET P.stockActual = P.stockActual + S.cantidadTotal
			WHERE S.idProducto = P.idProducto;	
			
            DELETE FROM notas_temp WHERE idNotaAlmacen = p_idNotaAlmacen;
            SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;
	END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_arreglarOTM` (IN `p_idOrdenMantenimiento` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE v_id INT;
	IF p_tipoOperacion = 1 THEN 
		INSERT INTO ORDEN_MANTENIMIENTO(
						idTrabajador, idUnidad, correlativo,
                        fechaEmision, fechaInicio, fechaFin, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
		)    
		VALUES (null,null, null,
			NULL,NULL, NULL, 'SN',
			now(), 'admin', "-", 
			now(), "-", "-", 1);     
		
        SET @v_id = (SELECT idOrdenMantenimiento FROM ORDEN_MANTENIMIENTO ORDER BY idOrdenMantenimiento DESC LIMIT 1);
        
        UPDATE ORDEN_SERVICIO SET idOrdenMantenimiento = @v_id WHERE idOrdenServicio = 113;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_buscarProducto` (IN `p_idProducto` INT, IN `p_busqueda` VARCHAR(50), IN `p_tipo` INT, IN `p_tipoOperacion` INT)  BEGIN   
	IF p_tipoOperacion = 1 THEN 	  		
		SELECT 
			P.idProducto, -- P.codigo, 
            CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria, CA.nombre as 'categoria', S.idSubCategoria, S.nombre as 'subcategoria',
			P.idClase,  C.nombre as 'clase',
            P.marca, P.modelo, P.medida, P.cod_fab, P.stockActual, P.unidad_medida,
            P.tipo_existencia, P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria       
        WHERE (S.idSubCategoria = p_tipo OR p_tipo = 0) 
			AND ( (P.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR ( CONCAT(C.abreviatura, P.codigo) LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.marca LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.modelo LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.cod_fab LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (S.nombre like concat('%', p_busqueda, '%') OR p_busqueda = ''))
            and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre asc;
	END IF;     
    IF p_tipoOperacion = 2 THEN  				
		SELECT  
			DC.idPresentacion,              
            P.cantidad,
            M.abrev,
			P.nombre, 
			C.idProveedor, 
            PR.nombreEmpresa,
			DC.precioUnitario, 
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaCompra'
		FROM COMPRA C
		INNER JOIN DETALLE_COMPRA DC ON DC.idCompra = C.idCompra
		INNER JOIN PRESENTACION P ON P.idPresentacion = DC.idPresentacion
        INNER JOIN PROVEEDOR PR ON PR.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = P.idUnidadMedida
		WHERE DC.idProducto = p_idProducto and M.dep_id = 3 
        ORDER BY idPresentacion desc;
    END	IF;
    IF p_tipoOperacion = 3 THEN 	  -- BUSCAR PRODUCTO EN crearOrdenMantenimiento.php
		SELECT 
			P.idProducto, -- P.codigo, 
            CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria, CA.nombre as 'categoria', S.idSubCategoria, S.nombre as 'subcategoria',
			P.idClase,  C.nombre as 'clase',
            P.marca, P.modelo, P.medida, P.cod_fab, P.stockActual, 
            P.unidad_medida as idUnidadMedida,  M.descripcion as unidadMedida,
            P.tipo_existencia, P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria     
        INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
        WHERE (S.idSubCategoria = p_tipo OR p_tipo = 0) 
			AND ( (P.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR ( CONCAT(C.abreviatura, P.codigo) LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.marca LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.modelo LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.cod_fab LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (S.nombre like concat('%', p_busqueda, '%') OR p_busqueda = ''))
            and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre asc;
	END IF;     
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_controlUsuario` (IN `p_login` VARCHAR(50), IN `p_pass` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN
	DECLARE restringido int;
	DECLARE correcto int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @restringido = (SELECT COUNT(*) 
							FROM USUARIO usu 
							WHERE usu.login = p_login AND usu.pass = MD5(p_pass) AND usu.activo=0);
		
		IF (@restringido) > 0 THEN
			SELECT 'Usuario Restringido' AS 'respuesta';
		ELSE
			SET @correcto = (SELECT COUNT(*) FROM USUARIO usu 
									WHERE usu.login = p_login AND 
											usu.pass = MD5(p_pass) AND
											usu.activo=1);
			
			IF (@correcto) > 0 THEN
				SELECT '1' AS 'respuesta';
			ELSE
				SELECT 'Usuario o clave incorrectos' AS 'respuesta';    
			END	IF;
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			U.idUsuario,
                       			T.nombre,
			T.apePaterno,
			U.login,
           			U.pass
		FROM USUARIO U
		INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
		WHERE U.login = p_login AND U.pass = MD5(p_pass)         AND U.activo=1;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarCategoria` (IN `p_idCategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN	
		IF EXISTS(SELECT DNA.idDetaNota, DNA.idProducto, P.idProducto, C.idClase
					FROM DETALLE_NOTA_ALMACEN DNA
					INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
					INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
					INNER JOIN CLASE C ON C.idClase = P.idClase
					INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
					INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS(SELECT DC.idDetalleCompra, DC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_COMPRA DC
						INNER JOIN COMPRA COM ON COM.idCompra = DC.idCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase
						INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
						INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
						LIMIT 1)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
            ELSE
				IF EXISTS (SELECT DOC.idDetalleOrden, DOC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_ORDEN DOC
						INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase
						INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
						INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
						LIMIT 1) THEN
					SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
                ELSE
					IF EXISTS(SELECT DC.idDetalleCotizacion, DC.idProducto, P.idProducto, C.idClase
								FROM DETALLE_COTIZACION DC
								INNER JOIN COTIZACION COT ON COT.idCotizacion= DC.idCotizacion
								INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
								INNER JOIN CLASE C ON C.idClase = P.idClase
								INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
								INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
								LIMIT 1) THEN
						SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
                    ELSE
						IF EXISTS(SELECT DGC.idDetalleGrupo, DGC.idProducto, P.idProducto, C.idClase
									FROM DETALLE_GRUPOCOTIZACION DGC
									INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DGC.idGrupoCotizacion
									INNER JOIN PRODUCTO P ON P.idProducto = DGC.idProducto
									INNER JOIN CLASE C ON C.idClase = P.idClase
									INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
									INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
									LIMIT 1) THEN
							SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
                        ELSE
							IF EXISTS(SELECT DOM.idDetaOrden, DOM.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_MANTENIMIENTO DOM
										INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
										INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase
										INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
										INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
										LIMIT 1) 
								OR EXISTS (SELECT DOS.idDetaOrden, DOS.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_SERVICIO DOS
										INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
										INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase
										INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
										INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria and CA.idCategoria = p_idCategoria
										LIMIT 1) THEN
								SELECT 0 as tipoRespuesta, 'Esta Categoría ya ha tenido movimientos.' as respuesta;
                            ELSE
								DELETE FROM PRODUCTO
                                WHERE idClase IN (SELECT idClase FROM CLASE 
													WHERE idSubcategoria IN (SELECT idSubcategoria FROM SUBCATEGORIA 
																				WHERE idCategoria = p_idCategoria));
                                
								DELETE FROM CLASE 
                                WHERE idSubcategoria IN (SELECT idSubcategoria FROM SUBCATEGORIA WHERE idCategoria = p_idCategoria);
                                
                                DELETE FROM SUBCATEGORIA WHERE idCategoria = p_idCategoria;
								DELETE FROM CATEGORIA WHERE idCategoria = p_idCategoria;
                                
                                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
                            END IF;
                        END IF;
                    END IF;
                END IF;
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarClase` (IN `p_idClase` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN
		IF EXISTS(SELECT DNA.idDetaNota, DNA.idProducto, P.idProducto, C.idClase
					FROM DETALLE_NOTA_ALMACEN DNA
					INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
					INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
					INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS(SELECT DC.idDetalleCompra, DC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_COMPRA DC
						INNER JOIN COMPRA COM ON COM.idCompra = DC.idCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase						
						LIMIT 1)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
            ELSE
				IF EXISTS (SELECT DOC.idDetalleOrden, DOC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_ORDEN DOC
						INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
						LIMIT 1) THEN
					SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
                ELSE
					IF EXISTS(SELECT DC.idDetalleCotizacion, DC.idProducto, P.idProducto, C.idClase
								FROM DETALLE_COTIZACION DC
								INNER JOIN COTIZACION COT ON COT.idCotizacion= DC.idCotizacion
								INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
								INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
								LIMIT 1) THEN
						SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
                    ELSE
						IF EXISTS(SELECT DGC.idDetalleGrupo, DGC.idProducto, P.idProducto, C.idClase
									FROM DETALLE_GRUPOCOTIZACION DGC
									INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DGC.idGrupoCotizacion
									INNER JOIN PRODUCTO P ON P.idProducto = DGC.idProducto
									INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
									LIMIT 1) THEN
							SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
                        ELSE
							IF EXISTS(SELECT DOM.idDetaOrden, DOM.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_MANTENIMIENTO DOM
										INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
										INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
										LIMIT 1) 
								OR EXISTS (SELECT DOS.idDetaOrden, DOS.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_SERVICIO DOS
										INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
										INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase and C.idClase = p_idClase
										LIMIT 1) THEN
								SELECT 0 as tipoRespuesta, 'Esta Clase ya ha tenido movimientos.' as respuesta;
                            ELSE
								DELETE FROM PRODUCTO WHERE idClase = p_idClase;
                                
								DELETE FROM CLASE WHERE idClase = p_idClase;
                                
                                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
                            END IF;
                        END IF;
                    END IF;
                END IF;
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarCliente` (IN `p_idCliente` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1
		THEN
        
        UPDATE 	CLIENTE
		SET		activo = 3
        WHERE	idCliente = p_idCliente;
        
        SELECT	1 AS tipoRespuesta,
				'El cliente se eliminó correctamente' AS respuesta;
	
		END IF;
        
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarCompra` (IN `p_idCompra` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE V_estado char(2);
    DECLARE nDetalle int;
	IF p_tipoOperacion = 1 THEN 
		
		SET @V_estado = (SELECT estado FROM COMPRA WHERE idCompra = p_idCompra);
        
        IF @V_estado = 'SN' THEN
			DELETE FROM DETALLE_COMPRA WHERE idCompra = p_idCompra;
			DELETE FROM COMPRA WHERE idCompra = p_idCompra;
		ELSE
			UPDATE COMPRA SET 
				estado = 'AN',                
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update, 
				registro_pc_update = '-'
			WHERE idCompra = p_idCompra;
        END IF;	
    END	IF; 
    
	IF p_tipoOperacion = 2 THEN  
        IF EXISTS(  SELECT DOM.idCompra FROM DETALLE_ORDEN_MANTENIMIENTO DOM
					INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
                    WHERE DOM.idCompra = p_idCompra and OM.estado != 'AN' LIMIT 1) THEN
			SELECT 0 as tipoRespuesta, 'Esta Compra ya tiene un Orden de Mantenimiento generada.' as respuesta;
        ELSE
			IF EXISTS (SELECT DOS.idCompra FROM DETALLE_ORDEN_SERVICIO DOS
					INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio 
                    WHERE DOS.idCompra = p_idCompra and OS.estado != 'AN' LIMIT 1) THEN
				SELECT 0 as tipoRespuesta, 'Esta Compra ya tiene un Orden de Servicio generada.' as respuesta;
            ELSE
				
				UPDATE COMPRA SET
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idCompra = p_idCompra;                
                
				UPDATE NOTA_ALMACEN SET
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idCompra = p_idCompra;
                
                UPDATE ORDEN_COMPRA SET
					estadoRecepcion = 'AN', 
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idOrdenCompra = (SELECT idOrdenCompra FROM COMPRA WHERE idCompra = p_idCompra);
                
                
				UPDATE PRODUCTO P, (SELECT DNA.idProducto, sum(cantidadTotal) as cantidadTotal FROM DETALLE_NOTA_ALMACEN DNA
									INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and idCompra = p_idCompra
									GROUP BY DNA.idProducto) S
				SET P.stockActual = (P.stockActual - S.cantidadTotal)
				WHERE P.idProducto = S.idProducto;
				
				SELECT 1 as tipoRespuesta, 'Se anuló correctamente.' as respuesta;
            END IF;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN  
        IF EXISTS(  SELECT DOM.idCompra FROM DETALLE_ORDEN_MANTENIMIENTO DOM
					INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
                    WHERE DOM.idCompra = p_idCompra and OM.estado != 'AN' LIMIT 1) THEN
			SELECT 0 as tipoRespuesta, 'Esta Compra ya tiene un Orden de Mantenimiento generada.' as respuesta;
        ELSE
			IF EXISTS (SELECT DOS.idCompra FROM DETALLE_ORDEN_SERVICIO DOS
					INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio 
                    WHERE DOS.idCompra = p_idCompra and OS.estado != 'AN' LIMIT 1) THEN
				SELECT 0 as tipoRespuesta, 'Esta Compra ya tiene un Orden de Servicio generada.' as respuesta;
            ELSE
				
				UPDATE COMPRA SET
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idCompra = p_idCompra;
				
				SELECT 1 as tipoRespuesta, 'Se anuló correctamente.' as respuesta;
            END IF;
        END IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaCotizacion` (IN `p_idDetalleCotizacion` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id	int;
	IF p_tipoOperacion = 1 THEN 
		SET @v_id = (SELECT idCotizacion FROM DETALLE_COTIZACION WHERE idDetalleCotizacion = p_idDetalleCotizacion);
        
		DELETE FROM DETALLE_COTIZACION WHERE idDetalleCotizacion = p_idDetalleCotizacion;
        
        
        SET @subtotal = (SELECT SUM(monto) FROM DETALLE_COTIZACION WHERE idCotizacion = @v_id);
        IF(@subtotal is null) then
			SET @subtotal = 0.00;
		END IF;
        
		SET @d_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = @v_id);
		SET @total = @subtotal + @subtotal * (@d_igv/100);
			
		UPDATE COTIZACION SET 
			subtotal = @subtotal,
			total = CONVERT(@total, DECIMAL(18,2))
		WHERE idCotizacion = @v_id; 
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaGrupoCotizacion` (IN `p_idDetalleGrupo` INT, IN `p_tipoOperacion` INT)  BEGIN   
	DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id	int;
	IF p_tipoOperacion = 1 THEN 
		SET @v_id = (SELECT idGrupoCotizacion FROM DETALLE_GRUPOCOTIZACION WHERE idDetalleGrupo = p_idDetalleGrupo);
        
		DELETE FROM DETALLE_GRUPOCOTIZACION WHERE idDetalleGrupo = p_idDetalleGrupo;
        
        
        SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = @v_id);
        IF(@total is null) then
			SET @total = 0.00;
		END IF;
        
		SET @d_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = @v_id);
		SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
		UPDATE GRUPO_COTIZACION SET 
			total = @total,
			subtotal = @subtotal,
            igv2 = @total - @subtotal
		WHERE idGrupoCotizacion = @v_id; 
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaGrupoOrden` (IN `p_idDetalleGrupo` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id	int;
	IF p_tipoOperacion = 1 THEN 
		SET @v_id = (SELECT idGrupoOrden FROM DETALLE_GRUPO WHERE idDetalleGrupo = p_idDetalleGrupo);
        
		DELETE FROM DETALLE_GRUPO WHERE idDetalleGrupo = p_idDetalleGrupo;
        
        
        SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPO WHERE idGrupoOrden = @v_id);
        IF(@total is null) then
			SET @total = 0.00;
		END IF;
        
		SET @d_igv = (SELECT igv FROM GRUPO_ORDENCOMPRA WHERE idGrupoOrden = @v_id);
		SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
		UPDATE GRUPO_ORDENCOMPRA SET 
			total = @total,
			subtotal = @subtotal,
            igv2 = @total - @subtotal
		WHERE idGrupoOrden = @v_id; 
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaNotaAlmacen` (IN `p_idDetaNotaAlmacen` INT, IN `p_idNotaAlmacen` INT, IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN 
	DECLARE v_cantidad decimal(18,2);
    IF p_tipoOperacion = 1 THEN  		
        				        				        
		DELETE FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and idProducto = p_idProducto;        
	END IF; 
    
    
    IF p_tipoOperacion = 2 THEN          
		DELETE FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and idProducto = p_idProducto;        
	END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaOrden` (IN `p_idDetalleOrden` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE subtotal	decimal(18,2);
	DECLARE descuento	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id	int;
	IF p_tipoOperacion = 1 THEN 
		SET @v_id = (SELECT idOrdenCompra FROM DETALLE_ORDEN WHERE idDetalleOrden = p_idDetalleOrden);
        
		DELETE FROM DETALLE_ORDEN WHERE idDetalleOrden = p_idDetalleOrden;
        
        SET @subTotal = IFNULL( ( SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id ), 0.00);
		SET @descuento = IFNULL( (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id), 0.00);
		SET @total = IFNULL( (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id), 0.00);
            
        UPDATE ORDEN_COMPRA SET 
			subtotal = @subtotal,
            descuento = @descuento,
            igv2 = @total - @subtotal + @descuento,
            total = CONVERT(@total, DECIMAL(18,2))
		WHERE idOrdenCompra = @v_id;
        
                					        
				    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaOrdenMantenimiento` (IN `p_idOrdenMantenimiento` INT, IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN
        
	IF p_tipoOperacion = 1 THEN
		  
																
		DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and idProducto = p_idProducto and fechaSalida is null;
	END IF;
        
	IF p_tipoOperacion = 2 THEN
		UPDATE DETALLE_NOTA_ALMACEN DNA, ( SELECT DOM.idNotaAlmacen, DOM.idProducto, sum(cantidad) as cantidad, DOM.fechaSalida 
												FROM DETALLE_ORDEN_MANTENIMIENTO DOM 
											   WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.idProducto = p_idProducto
                                               and DOM.idNotaAlmacen is not null and DOM.fechaSalida is null
												GROUP BY DOM.idNotaAlmacen, DOM.idProducto) DOM
		SET DNA.cantidadUsada = DNA.cantidadUsada - DOM.cantidad,
				 DNA.cantidadSaldo = DNA.cantidadSaldo + DOM.cantidad,
				 DNA.estado = 'A'
		WHERE DNA.idNotaAlmacen = DOM.idNotaAlmacen and DNA.idProducto = DOM.idProducto and DOM.fechaSalida is null;
		  
       UPDATE PRODUCTO P, ( SELECT DOM.idProducto, sum(cantidad) as cantidad, DOM.fechaSalida
												FROM DETALLE_ORDEN_MANTENIMIENTO DOM 
											   WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.idProducto = p_idProducto
													and DOM.idNotaAlmacen is not null and DOM.fechaSalida is null
                                                GROUP BY DOM.idProducto) DOM
		SET P.stockActual = P.stockActual + DOM.cantidad
		WHERE P.idProducto = DOM.idProducto and DOM.fechaSalida is null; 
		
	   DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and idProducto = p_idProducto and fechaSalida is null;
   END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDetaOrdenServicio` (IN `p_idOrdenServicio` INT, IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN
        
	IF p_tipoOperacion = 1 THEN
		  
								        						
		DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and idProducto = p_idProducto and fechaSalida is null;
	END IF;
        
	IF p_tipoOperacion = 2 THEN
		UPDATE DETALLE_NOTA_ALMACEN DNA, ( SELECT DOS.idNotaAlmacen, DOS.idProducto, sum(cantidad) as cantidad, DOS.fechaSalida 
											FROM DETALLE_ORDEN_SERVICIO DOS 
											WHERE DOS.idOrdenServicio = p_idOrdenServicio and DOS.idProducto = p_idProducto
													AND DOS.idNotaAlmacen is not null and DOS.fechaSalida is null
											GROUP BY DOS.idNotaAlmacen, DOS.idProducto) DOS
		SET DNA.cantidadUsada = DNA.cantidadUsada - DOS.cantidad,
			DNA.cantidadSaldo = DNA.cantidadSaldo + DOS.cantidad,
			DNA.estado = 'A'
		WHERE DNA.idNotaAlmacen = DOS.idNotaAlmacen and DNA.idProducto = DOS.idProducto and DOS.fechaSalida is null;
		  
      UPDATE PRODUCTO P, ( SELECT DOS.idProducto, sum(cantidad) as cantidad, DOS.fechaSalida
												FROM DETALLE_ORDEN_SERVICIO DOS 
											   WHERE DOS.idOrdenServicio = p_idOrdenServicio and DOS.idProducto = p_idProducto
													and DOS.idNotaAlmacen is not null and DOS.fechaSalida is null
                                                GROUP BY DOS.idProducto) DOS
		SET P.stockActual = P.stockActual + DOS.cantidad
		WHERE P.idProducto = DOS.idProducto and DOS.fechaSalida is null; 
		
	   DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and idProducto = p_idProducto and fechaSalida is null;
   END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarDocumentoVenta` (IN `p_idDocVenta` INT)  BEGIN    

	UPDATE 	DOCUMENTO_VENTA 
	SET		activo = 0
    WHERE	id = p_idDocVenta; 
    
    SELECT 	1 AS 'tipoRespuesta',
			'Se eliminó correctamente' as respuesta;
                        
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarEmpaque` (IN `p_idEmpaque` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN		
		DELETE FROM EMPAQUE WHERE idEmpaque = p_idEmpaque;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarFilaDetalleDocumentoVenta` (IN `p_idVenta` INT, IN `p_idDetalleDocVenta` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 
		THEN        
			UPDATE	DETALLE_DOCUMENTO_VENTA
            SET		activo = 0
            where	id = p_idDetalleDocVenta;
            
            SELECT 1 AS respuesta;
    END	IF; 
    
    IF p_tipoOperacion = 2 
		THEN  
			UPDATE	CRONOGRAMA_PAGO_VENTA
			SET		activo = 0
            WHERE	documento_venta_id = p_idVenta;
            
            SELECT 1 AS respuesta;
    END	IF; 
   
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarFormaPago` (IN `p_idFormaPago` INT)  BEGIN    

	UPDATE 	FORMA_PAGO 
	SET		activo = 2
    WHERE	id = p_idFormaPago;
    
    SELECT 	1 AS 'tipoRespuesta',
			'Se eliminó correctamente' as respuesta;
                        
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarGrupo` (IN `p_idGrupo` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM GRUPO WHERE idGrupo = p_idGrupo;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarGrupoCotizacion` (IN `p_idGrupoCotizacion` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE V_estado char(2);
    DECLARE nDetalle int;
	IF p_tipoOperacion = 1 THEN 
		
		SET @V_estado = (SELECT estado FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
        
        IF @V_estado = 'SN' THEN
			DELETE FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion;
			DELETE FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion;
		ELSE
			UPDATE GRUPO_COTIZACION SET 
				estado = 'AN',
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update, 
				registro_pc_update = '-'
			WHERE idGrupoCotizacion = p_idGrupoCotizacion;
        END IF;
    END	IF; 
    
	IF p_tipoOperacion = 2 THEN  		DELETE FROM GRUPO_COTIZACION WHERE idGrupoCotizacion in (
			SELECT idGrupoCotizacion FROM (
				SELECT GC.idGrupoCotizacion, GC.correlativo, count(DGC.idDetalleGrupo) as cantidadProductos
				FROM GRUPO_COTIZACION GC
				LEFT JOIN DETALLE_GRUPOCOTIZACION DGC ON DGC.idGrupoCotizacion = GC.idGrupoCotizacion
				GROUP BY GC.idGrupoCotizacion, GC.correlativo
				HAVING cantidadProductos <= 0 and (correlativo is null or correlativo = '') 
			) X 
		);        
        
        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarMultitabla` (IN `p_idMultitabla` INT, IN `p_valor` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM MULTITABLA WHERE dep_id = p_valor;
		DELETE FROM MULTITABLA WHERE valor = p_valor and dep_id is null;
    END	IF; 
    IF p_tipoOperacion = 2 THEN 
		DELETE FROM MULTITABLA WHERE idMultitabla = p_idMultitabla;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarNotaAlmacen` (IN `p_idNotaAlmacen` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
    
    IF p_tipoOperacion = 3 THEN 
		DELETE FROM NOTA_ALMACEN WHERE idNotaAlmacen in (
			SELECT idNotaAlmacen FROM (
				SELECT NA.idNotaAlmacen, NA.correlativo, count(DNA.idDetaNota) as cantidadProductos
				FROM NOTA_ALMACEN NA
				LEFT JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen
				GROUP BY NA.idNotaAlmacen, NA.correlativo
				HAVING cantidadProductos <= 0 and (correlativo is null or correlativo = '')
			) X 
		);
        
        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarOficina` (IN `p_idOficina` INT, IN `p_tipoOperacion` INT)  BEGIN 
    IF p_tipoOperacion = 1 then
		
		IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOficina = p_idOficina) THEN
			SELECT 0 as tipoRespuesta, 'Esta Oficina ya ha tenido movimientos.' as respuesta;
		ELSE
			IF EXISTS (SELECT * FROM COMPRA WHERE idOficina = p_idOficina) THEN
				SELECT 0 as tipoRespuesta, 'Esta Oficina ya ha tenido movimientos.' as respuesta;
			ELSE				
				DELETE FROM OFICINA WHERE idOficina = p_idOficina;
						
				SELECT 1 AS 'tipoRespuesta', 'Se eliminió correctamente la Oficina.' as respuesta;
			END IF;
		END IF;
	END IF;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarOrdenCompra` (IN `p_idOrdenCompra` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE v_estado char(2);
    DECLARE v_idCotizacion int;
    DECLARE nDetalle int;
	IF p_tipoOperacion = 1 THEN 
		
		(SELECT idCotizacion, estadoRecepcion INTO @v_idCotizacion, @v_estado
         FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra);
        
        IF @v_estado = 'SN' THEN
			DELETE FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra;
			DELETE FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra;
		ELSE
			UPDATE ORDEN_COMPRA SET 
				estadoRecepcion = 'AN',                
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update, 
				registro_pc_update = '-'
			WHERE idOrdenCompra = p_idOrdenCompra;
        END IF;	
    END	IF; 
    
	IF p_tipoOperacion = 2 THEN  
        IF EXISTS(SELECT idCompra FROM COMPRA WHERE idOrdenCompra = p_idOrdenCompra and estado != 'AN')  THEN
			SELECT 0 as tipoRespuesta, 'Esta Orden de Compra ya tiene una Compra generada.' as respuesta;
        ELSE
			IF EXISTS(SELECT idNotaAlmacen FROM NOTA_ALMACEN WHERE idOrdenCompra = p_idOrdenCompra and estado != 'AN' and anulado = 0)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Orden de Compra ya tiene movimientos.' as respuesta;
			ELSE
				UPDATE ORDEN_COMPRA SET 
					estadoRecepcion = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				 WHERE idOrdenCompra = p_idOrdenCompra;
				
				SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
            END IF;	
        END IF;	
    END	IF;
    
    IF p_tipoOperacion = 3 THEN  
        DELETE FROM ORDEN_COMPRA
        WHERE idOrdenCompra IN (
			SELECT idOrdenCompra FROM (
				SELECT OC.idOrdenCompra, OC.correlativo, count(DOC.idDetalleOrden) as cantidadProductos
				FROM ORDEN_COMPRA OC 
				LEFT JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
				GROUP BY OC.idOrdenCompra, OC.correlativo
				HAVING cantidadProductos <= 0 AND (correlativo IS NULL OR correlativo = '') 
			) X 
		);
        
        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarOrdenMantenimiento` (IN `p_idOrdenMantenimiento` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE v_estado char(2);
    DECLARE nDetalle int;
	IF p_tipoOperacion = 1 THEN 
		SET @v_estado = (SELECT estado FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento);
        
        IF @v_estado = 'SN' THEN
            UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
								FROM DETALLE_ORDEN_MANTENIMIENTO 
								WHERE idOrdenMantenimiento  = p_idOrdenMantenimiento
								GROUP BY idProducto) S 
			SET P.stockActual = P.stockActual + S.cantidad
			WHERE P.idProducto = S.idProducto;
                
			DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
			DELETE FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
                
			SELECT 1 AS tipoRespuesta, 'Se eliminó correctamente.' AS 'respuesta';
		ELSE
			SELECT 0 AS tipoRespuesta, 'No se pudo eliminar la Orden de Mantenimiento.' AS 'respuesta';			
        END IF;	
    END	IF;
    
    IF p_tipoOperacion = 2 THEN 	        
		SET @v_estado = (SELECT estado FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento);
        
        IF @v_estado = 'C' THEN
			UPDATE ORDEN_MANTENIMIENTO SET
				estado = 'AN',
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update,
				registro_pc_update = '-'
			WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;            
            
			UPDATE NOTA_ALMACEN SET
				estado = 'AN',
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update,
				registro_pc_update = '-'
			WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
            
			UPDATE DETALLE_NOTA_ALMACEN DNA, (SELECT idNotaAlmacen, idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_MANTENIMIENTO 
												WHERE idOrdenMantenimiento  = p_idOrdenMantenimiento
												GROUP BY idNotaAlmacen, idProducto) S 
			SET DNA.cantidadUsada = DNA.cantidadUsada - S.cantidad,
				DNA.cantidadSaldo = DNA.cantidadSaldo + S.cantidad
			WHERE DNA.idNotaAlmacen = S.idNotaAlmacen and DNA.idProducto = S.idProducto;

			UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_MANTENIMIENTO 
												WHERE idOrdenMantenimiento  = p_idOrdenMantenimiento
												GROUP BY idProducto) S 
			SET P.stockActual = P.stockActual + S.cantidad	
			WHERE P.idProducto = S.idProducto;
            
            SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
		ELSE 
			IF @v_estado = 'A' THEN
				UPDATE ORDEN_MANTENIMIENTO SET
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
                
                UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_MANTENIMIENTO 
												WHERE idOrdenMantenimiento  = p_idOrdenMantenimiento
												GROUP BY idProducto) S 
				SET P.stockActual = P.stockActual + S.cantidad	
				WHERE P.idProducto = S.idProducto;
                
                SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
			ELSE
				SELECT 0 AS tipoRespuesta, 'No se pudo anular la Orden de Mantenimiento.' AS 'respuesta';
            END IF;            
        END IF;	
    END	IF;
    
    IF p_tipoOperacion = 3 THEN 
		DELETE FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento in (
			SELECT idOrdenMantenimiento FROM (
                
                SELECT OTM.idOrdenMantenimiento, OTM.correlativo,  OS.idOrdenMantenimiento AS idOrdenMantenimientoOS, count(DOM.idDetaOrden) as cantidadProductos
				FROM ORDEN_MANTENIMIENTO OTM
				LEFT JOIN DETALLE_ORDEN_MANTENIMIENTO DOM ON DOM.idOrdenMantenimiento = OTM.idOrdenMantenimiento
                LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenMantenimiento = OTM.idOrdenMantenimiento                
				GROUP BY OTM.idOrdenMantenimiento, OTM.correlativo, OS.idOrdenMantenimiento
				HAVING cantidadProductos <= 0 and (correlativo is null or correlativo = '') and idOrdenMantenimientoOS is null
			) X 
		);
                
        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
    END	IF;
    
    IF p_tipoOperacion = 4 THEN  
       
			IF EXISTS(SELECT idNotaAlmacen FROM NOTA_ALMACEN WHERE idOrdenMantenimiento = p_idOrdenMantenimiento 
							and estado != 'AN' and anulado = 0)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Orden de Mantenimiento ya tiene movimientos.' as respuesta;
			ELSE
				UPDATE ORDEN_MANTENIMIENTO SET 
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				 WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
				
				SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
            END IF;	
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarOrdenServicio` (IN `p_idOrdenServicio` INT, IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE v_estado char(2);
    DECLARE nDetalle int;
	IF p_tipoOperacion = 1 THEN
        
		SET @v_estado = (SELECT estado FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio);
        
        IF @v_estado = 'SN' THEN
            
            UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
								FROM DETALLE_ORDEN_SERVICIO 
								WHERE idOrdenServicio  = p_idOrdenServicio
								GROUP BY idProducto) S 
			SET P.stockActual = P.stockActual + S.cantidad	
			WHERE P.idProducto = S.idProducto;
            
			DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio;
			DELETE FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio;
                
			SELECT 1 AS tipoRespuesta, 'Se eliminó correctamente.' AS 'respuesta';
		ELSE
			SELECT 0 AS tipoRespuesta, 'No se pudo eliminar la Orden de Servicio.' AS 'respuesta';			
        END IF;
    END	IF;
    
	IF p_tipoOperacion = 2 THEN 	
        
		SET @v_estado = (SELECT estado FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio);
        
        IF @v_estado = 'C' THEN
			UPDATE ORDEN_SERVICIO SET
				estado = 'AN',
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update,
				registro_pc_update = '-'
			WHERE idOrdenServicio = p_idOrdenServicio;            
            
			UPDATE NOTA_ALMACEN SET
				estado = 'AN',
				registro_fecha_update = now(),
				registro_user_update = p_registro_user_update,
				registro_pc_update = '-'
			WHERE idOrdenServicio = p_idOrdenServicio;
            
			UPDATE DETALLE_NOTA_ALMACEN DNA, (SELECT idNotaAlmacen, idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_SERVICIO 
												WHERE idOrdenServicio  = p_idOrdenServicio
												GROUP BY idNotaAlmacen, idProducto) S 
			SET DNA.cantidadUsada = DNA.cantidadUsada - S.cantidad,
				DNA.cantidadSaldo = DNA.cantidadSaldo + S.cantidad
			WHERE DNA.idNotaAlmacen = S.idNotaAlmacen and DNA.idProducto = S.idProducto;

			UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_SERVICIO 
												WHERE idOrdenServicio  = p_idOrdenServicio
												GROUP BY idProducto) S 
			SET P.stockActual = P.stockActual + S.cantidad	
			WHERE P.idProducto = S.idProducto;
            
            SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
		ELSE
			IF @v_estado = 'A' THEN
				UPDATE ORDEN_SERVICIO SET
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = '-'
				WHERE idOrdenServicio = p_idOrdenServicio;
                
                UPDATE PRODUCTO P, (SELECT idProducto, sum(cantidad ) as cantidad
												FROM DETALLE_ORDEN_SERVICIO
												WHERE idOrdenServicio  = p_idOrdenServicio
												GROUP BY idProducto) S 
				SET P.stockActual = P.stockActual + S.cantidad	
				WHERE P.idProducto = S.idProducto;
                
                SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
			ELSE
				SELECT 0 AS tipoRespuesta, 'No se pudo anular la Orden de Servicio.' AS 'respuesta';
            END IF; 
        END IF;	
    END	IF;
    
    IF p_tipoOperacion = 3 THEN 
		DELETE FROM ORDEN_SERVICIO WHERE idOrdenServicio in (
			SELECT idOrdenServicio FROM (
				SELECT OS.idOrdenServicio, OS.correlativo, count(DOS.idDetaOrden) as cantidadProductos
				FROM ORDEN_SERVICIO OS
				LEFT JOIN DETALLE_ORDEN_SERVICIO DOS ON DOS.idOrdenServicio = OS.idOrdenServicio
				GROUP BY OS.idOrdenServicio, OS.correlativo
				HAVING cantidadProductos <= 0 and (correlativo is null or correlativo = '') 
			) X 
		);
        
        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
    END	IF;
    
    IF p_tipoOperacion = 4 THEN  
       
			IF EXISTS(SELECT idNotaAlmacen FROM NOTA_ALMACEN WHERE idOrdenServicio = p_idOrdenServicio
							and estado != 'AN' and anulado = 0)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Orden de Servicio ya tiene movimientos.' as respuesta;
			ELSE
				UPDATE ORDEN_SERVICIO SET 
					estado = 'AN',
					registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				 WHERE idOrdenServicio = p_idOrdenServicio;
				
				SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
            END IF;	
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarPresentacion` (IN `p_idPresentacion` INT, IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN		
		DELETE FROM PRESENTACION WHERE idPresentacion = p_idPresentacion;
    END	IF; 
    
    
	IF p_tipoOperacion = 2 THEN
		DELETE FROM PRESENTACION WHERE idProducto = p_idProducto;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarProducto` (IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN
		
		IF EXISTS(SELECT DNA.idDetaNota, DNA.idProducto, P.idProducto
					FROM DETALLE_NOTA_ALMACEN DNA
					INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
					INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto and P.idProducto = p_idProducto
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS(SELECT DC.idDetalleCompra, DC.idProducto, P.idProducto
						FROM DETALLE_COMPRA DC
						INNER JOIN COMPRA COM ON COM.idCompra = DC.idCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto and P.idProducto = p_idProducto					
						LIMIT 1)  THEN
				SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
            ELSE
				IF EXISTS (SELECT DOC.idDetalleOrden, DOC.idProducto, P.idProducto
						FROM DETALLE_ORDEN DOC
						INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto and P.idProducto = p_idProducto
						LIMIT 1) THEN
					SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
                ELSE
					IF EXISTS(SELECT DC.idDetalleCotizacion, DC.idProducto, P.idProducto
								FROM DETALLE_COTIZACION DC
								INNER JOIN COTIZACION COT ON COT.idCotizacion= DC.idCotizacion
								INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto and P.idProducto = p_idProducto
								LIMIT 1) THEN
						SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
                    ELSE
						IF EXISTS(SELECT DGC.idDetalleGrupo, DGC.idProducto, P.idProducto
									FROM DETALLE_GRUPOCOTIZACION DGC
									INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DGC.idGrupoCotizacion
									INNER JOIN PRODUCTO P ON P.idProducto = DGC.idProducto and P.idProducto = p_idProducto
									LIMIT 1) THEN
							SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
                        ELSE
							IF EXISTS(SELECT DOM.idDetaOrden, DOM.idProducto, P.idProducto
										FROM DETALLE_ORDEN_MANTENIMIENTO DOM
										INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
										INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto and P.idProducto = p_idProducto
										LIMIT 1) 
								OR EXISTS (SELECT DOS.idDetaOrden, DOS.idProducto, P.idProducto
										FROM DETALLE_ORDEN_SERVICIO DOS
										INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
										INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto and P.idProducto = p_idProducto
										LIMIT 1) THEN
								SELECT 0 as tipoRespuesta, 'Este Producto ya ha tenido movimientos.' as respuesta;
                            ELSE
								DELETE FROM PRESENTACION WHERE idProducto = p_idProducto;
                                DELETE FROM PRODUCTO WHERE idProducto = p_idProducto;
                                
                                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
                            END IF;
                        END IF;
                    END IF;
                END IF;
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarProveedor` (IN `p_idProveedor` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN 
		IF EXISTS(SELECT DC.idDetalleCompra, DC.idProducto, P.idProveedor
					FROM DETALLE_COMPRA DC
					INNER JOIN COMPRA COM ON COM.idCompra = DC.idCompra
					INNER JOIN PROVEEDOR P ON P.idProveedor = COM.idProveedor and P.idProveedor = p_idProveedor					
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Este Proveedor ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS (SELECT DOC.idDetalleOrden, DOC.idProducto, P.idProveedor
					FROM DETALLE_ORDEN DOC
					INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
					INNER JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor and P.idProveedor = p_idProveedor
					LIMIT 1) THEN
				SELECT 0 as tipoRespuesta, 'Este Proveedor ya ha tenido movimientos.' as respuesta;
            ELSE
				IF EXISTS(SELECT DC.idDetalleCotizacion, DC.idProducto, P.idProveedor
						FROM DETALLE_COTIZACION DC
						INNER JOIN COTIZACION COT ON COT.idCotizacion= DC.idCotizacion
						INNER JOIN PROVEEDOR P ON P.idProveedor = COT.idProveedor and P.idProveedor = p_idProveedor
						LIMIT 1) THEN
					SELECT 0 as tipoRespuesta, 'Este Proveedor ya ha tenido movimientos.' as respuesta;
				ELSE
					IF EXISTS(SELECT DGC.idDetalleGrupo, DGC.idProducto, P.idProveedor
							FROM DETALLE_GRUPOCOTIZACION DGC
							INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DGC.idGrupoCotizacion
							INNER JOIN PROVEEDOR P ON (P.idProveedor = DGC.idProveedorR or P.idProveedor = DGC.idProveedorC) and P.idProveedor = p_idProveedor
							LIMIT 1) THEN
						SELECT 0 as tipoRespuesta, 'Este Proveedor ya ha tenido movimientos.' as respuesta;
					ELSE
						set @id = (SELECT idContacto FROM PROVEEDOR WHERE idProveedor = P_idProveedor);
                                                
                        DELETE FROM CONTACTO WHERE idContacto = @id;
                        DELETE FROM PROVEEDOR WHERE idProveedor = p_idProveedor;
                                
                        SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
                    END IF;
                END IF;
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarRol` (IN `p_idRol` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM ROL WHERE idRol = p_idRol;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarRolTarea` (IN `p_idRolTarea` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM ROL_TAREA WHERE idRolTarea = p_idRolTarea;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarSubcategoria` (IN `p_idSubcategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	DECLARE id int;
	IF p_tipoOperacion = 1 THEN
		IF EXISTS(SELECT DNA.idDetaNota, DNA.idProducto, P.idProducto, C.idClase
					FROM DETALLE_NOTA_ALMACEN DNA
					INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
					INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
					INNER JOIN CLASE C ON C.idClase = P.idClase
					INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS(SELECT DC.idDetalleCompra, DC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_COMPRA DC
						INNER JOIN COMPRA COM ON COM.idCompra = DC.idCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase
						INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
						LIMIT 1)  THEN
				SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
            ELSE
				IF EXISTS (SELECT DOC.idDetalleOrden, DOC.idProducto, P.idProducto, C.idClase
						FROM DETALLE_ORDEN DOC
						INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
						INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
						INNER JOIN CLASE C ON C.idClase = P.idClase
						INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
						LIMIT 1) THEN
					SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
                ELSE
					IF EXISTS(SELECT DC.idDetalleCotizacion, DC.idProducto, P.idProducto, C.idClase
								FROM DETALLE_COTIZACION DC
								INNER JOIN COTIZACION COT ON COT.idCotizacion= DC.idCotizacion
								INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
								INNER JOIN CLASE C ON C.idClase = P.idClase
								INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
								LIMIT 1) THEN
						SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
                    ELSE
						IF EXISTS(SELECT DGC.idDetalleGrupo, DGC.idProducto, P.idProducto, C.idClase
									FROM DETALLE_GRUPOCOTIZACION DGC
									INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DGC.idGrupoCotizacion
									INNER JOIN PRODUCTO P ON P.idProducto = DGC.idProducto
									INNER JOIN CLASE C ON C.idClase = P.idClase
									INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
									LIMIT 1) THEN
							SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
                        ELSE
							IF EXISTS(SELECT DOM.idDetaOrden, DOM.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_MANTENIMIENTO DOM
										INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
										INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase
										INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
										LIMIT 1) 
								OR EXISTS (SELECT DOS.idDetaOrden, DOS.idProducto, P.idProducto, C.idClase
										FROM DETALLE_ORDEN_SERVICIO DOS
										INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
										INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
										INNER JOIN CLASE C ON C.idClase = P.idClase
										INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and S.idSubcategoria = p_idSubcategoria
										LIMIT 1) THEN
								SELECT 0 as tipoRespuesta, 'Esta Subcategoría ya ha tenido movimientos.' as respuesta;
                            ELSE
								DELETE FROM PRODUCTO
                                WHERE idClase IN (SELECT idClase FROM CLASE
													WHERE idSubcategoria = p_idSubcategoria);                                
								DELETE FROM CLASE 
                                WHERE idSubcategoria = p_idSubcategoria;
                                
                                DELETE FROM SUBCATEGORIA WHERE idSubcategoria = p_idSubcategoria;
                                
                                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;
                            END IF;
                        END IF;
                    END IF;
                END IF;
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarTarea` (IN `p_idTarea` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM TAREA WHERE idTarea = p_idTarea;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarTasaCambio` (IN `p_idTasaCambio` INT, IN `p_tipoOperacion` INT)  BEGIN
	IF p_tipoOperacion = 1 THEN
        DELETE FROM TASA_CAMBIO WHERE idTasaCambio = p_idTasaCambio;
        SELECT 1 as tipoRespuesta, 'La Tasa de Cambio se eliminó correctamente.' as respuesta;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarTrabajador` (IN `p_idTrabajador` INT, IN `p_tipoOperacion` INT)  BEGIN    
    DECLARE id int;
    IF p_tipoOperacion = 1 THEN 
		IF EXISTS(SELECT U.idUsuario
					FROM  USUARIO U 
					INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador AND T.idTrabajador = p_idTrabajador
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Este Trabajador ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS (SELECT OM.idOrdenMantenimiento
								FROM  ORDEN_MANTENIMIENTO OM 							
								INNER JOIN TRABAJADOR T ON T.idTrabajador = OM.idTrabajador and T.idTrabajador = p_idTrabajador
								LIMIT 1)  THEN
				SELECT 0 as tipoRespuesta, 'Este Trabajador ya ha tenido movimientos.' as respuesta;
            ELSE
				DELETE FROM TRABAJADOR WHERE idTrabajador = p_idTrabajador;
                                
                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;                               
            END IF;			
		END IF;
    END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarUsuario` (IN `p_idUsuario` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		DELETE FROM USUARIO WHERE idUsuario = p_idUsuario;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_eliminarVehiculo` (IN `p_idUnidad` INT, IN `p_tipoOperacion` INT)  BEGIN     
        
	IF p_tipoOperacion = 1 THEN
		IF EXISTS(SELECT NA.idNotaAlmacen
					FROM  NOTA_ALMACEN NA 
					INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad and UM.idUnidad = p_idUnidad
					LIMIT 1)  THEN
			SELECT 0 as tipoRespuesta, 'Este Vehículo ya ha tenido movimientos.' as respuesta;
        ELSE
			IF EXISTS (SELECT OM.idOrdenMantenimiento
								FROM  ORDEN_MANTENIMIENTO OM 							
								INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OM.idUnidad and UM.idUnidad = p_idUnidad
								LIMIT 1) 
					OR EXISTS (SELECT OS.idOrdenServicio
								FROM ORDEN_SERVICIO OS 						
								INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OS.idUnidad and UM.idUnidad = p_idUnidad
								LIMIT 1) THEN
				SELECT 0 as tipoRespuesta, 'Este Vehículo ya ha tenido movimientos.' as respuesta;
            ELSE
			
				DELETE FROM UNIDAD_MOVIL WHERE idUnidad = p_idUnidad;
                                
                SELECT 1 as tipoRespuesta, 'Se eliminó correctamente.' as respuesta;                               
            END IF;			
		END IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetClientes` (IN `p_idCliente` INT, IN `p_tipo` INT)  BEGIN

IF p_tipo = 1 
	THEN 
		SELECT   
			C.idCliente, 
			C.codigoCliente,  
			C.idCategoria,  
			C.idPais, 
			P.pais, 
			C.idCiudad, 
			CASE WHEN C.idCiudad = 0
					THEN 
						''
					ELSE
						(SELECT ciudad FROM CIUDADES where idCiudades = C.idCiudad)
			END AS Ciudad,
			CASE WHEN C.idTipoCliente = 2
					THEN
						C.razonSocial
					ELSE
						concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
			END AS razonSocial,  
			C.nombreComercial, 
			C.documento,
			C.direccion, 
			C.fechaNacimiento, 
			C.telefono1, 
			C.telefono2, 
			C.telefono3, 
			C.email,
			C.referencia, 
			C.cuentaFacebook, 
			C.cuentaInstagram, 
			C.ocupacion, 
			C.lugarOcupacion,
			C.comentario, 
			C.calificacion, 
			C.activo, 
			M.descripcion AS tipo_documento_descripcion,
			M1.descripcion AS tipo_cliente_descripcion,
			M2.descripcion AS categoria_descripcion,
			CASE 
				WHEN C.activo = 1 
					THEN 'SÍ' 
					ELSE 'NO' 
			END as desActivo
		FROM CLIENTE C
			INNER JOIN PAIS P ON P.idPais = C.idPais
			INNER JOIN MULTITABLA M ON M.valor = C.idTipoDocumento AND M.dep_id = 29
			INNER JOIN MULTITABLA M1 ON M1.valor = C.idTipoCliente AND M1.dep_id = 28
			INNER JOIN MULTITABLA M2 ON M2.valor = C.idCategoria AND M2.dep_id = 30
		WHERE C.activo IN (0, 1)
        ORDER BY C.codigoCliente DESC;
END IF;

IF p_tipo = 2
	THEN
		SELECT 
				idCliente, 
                idCategoria,
                idTipoCliente,
                idPais,  
				idCiudad,
				codigoCliente,
				razonSocial,
				nombreComercial,
                nombres,
                apellidoPaterno,
                apellidoMaterno,
                idTipoDocumento,
				documento,
				direccion, 
				fechaNacimiento, 
				telefono1, 
				telefono2, 
				email,
				referencia, 
				cuentaFacebook, 
				cuentaInstagram, 
				ocupacion, 
				lugarOcupacion,
				calificacion, 
				activo				
		FROM	CLIENTE
		WHERE	idCliente = p_idCliente;
END IF;

IF p_tipo = 3
	THEN
		SELECT 
				idClienteContacto,
				nombre,
                apePaterno,
                apeMaterno,
                cargo,
                dni,
                telefono,
                email,
                activo
		FROM	CLIENTE_CONTACTO
		WHERE	idCliente = p_idCliente;
END IF;

-- Combo listado de clientes
IF p_tipo = 4
	THEN
		SELECT 
				idCliente, 
                CASE WHEN idTipoCliente = 2
					THEN
						concat(documento, ' | ', razonSocial)
					ELSE
						concat(documento, ' | ' ,nombres, ' ', apellidoPaterno, ' ', apellidoMaterno) 
				END AS descripcion	
		FROM	CLIENTE
		WHERE	activo = 1;
END IF;

-- Datos clinete venta
IF p_tipo = 5
	THEN
		SELECT 
				C.idCliente, 
                C.idCategoria,
                C.documento,
                M2.descripcion AS categoria_descripcion,
                SUM(DV.monto_total_interes) AS monto_historico_venta,
                MAX(DATE(DV.fecha_emision)) AS fecha_ultima_venta
		FROM	CLIENTE C
				INNER JOIN MULTITABLA M2 
					ON M2.valor = C.idCategoria 
                    AND M2.dep_id = 30
				LEFT JOIN DOCUMENTO_VENTA DV
					ON DV.idCliente = C.idCliente 
                    AND C.activo = 1
		WHERE	C.idCliente = p_idCliente;
    END IF;

IF p_tipo = 6
	THEN
		SELECT
					DV.id,
                    DV.correlativo,
                    M.descripcion AS tipo_documento_descripcion,	
                    DV.serie,
                    DV.numero,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
                    DATE(DV.fecha_emision) AS fecha_emision,
					DV.monto_total,
                    P.codigo AS producto_codigo,
                    DDV.cantidad,
                    DDV.precio_unitario,
                    DDV.descuento,
                    DDV.precio_total,
					DV.estado,
					M3.descripcion AS estado_descripcion
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN MULTITABLA M3
						ON M3.abrev = DV.estado 
						AND M3.dep_id = 25
						AND M3.activo = 1
					INNER JOIN DETALLE_DOCUMENTO_VENTA DDV
						ON DDV.documento_venta_id = DV.id
                        AND DDV.activo = 1
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id
			WHERE	DV.idCliente = p_idCliente
			ORDER BY DV.correlativo DESC;
    
    END IF;

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getGraficaCompras` (IN `p_fechaDesde` DATE, IN `p_fechaHasta` DATE, IN `p_isCategoria` INT, IN `p_isSubategoria` INT, IN `p_isClase` INT)  BEGIN
	IF p_isCategoria = 1 THEN
		SELECT  -- C.idClase, C.nombre, 
			CAT.idCategoria, CAT.nombre,
			SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		INNER JOIN CATEGORIA CAT ON CAT.idCategoria = S.idCategoria
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY CAT.idCategoria, CAT.nombre
		ORDER BY monto DESC, CAT.nombre ASC;
    END IF;
        
	IF p_isSubategoria = 1 THEN
		SELECT
			S.idSubcategoria, S.nombre,
			SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY S.idSubcategoria, S.nombre
		ORDER BY monto DESC, S.nombre ASC;
    END IF;
        
	IF p_isClase = 1 THEN
		SELECT 
			C.idClase, C.nombre, SUM(DOC.monto) AS monto
		FROM ORDEN_COMPRA OC
		INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
		INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE C ON C.idClase = P.idClase
		WHERE OC.estadoRecepcion IN ('EN', 'A') AND CAST(OC.fechaEnvio AS DATE) between p_fechaDesde AND p_fechaHasta
		GROUP BY C.idClase, C.nombre
		ORDER BY monto DESC, C.nombre ASC;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getGraficaInventario` (IN `p_fechaCorte` DATE, IN `p_isCategoria` INT, IN `p_isSubategoria` INT, IN `p_isClase` INT)  BEGIN
	IF p_isCategoria = 1 THEN
		SELECT 
			CAT.idCategoria, CAT.nombre, 
            SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		INNER JOIN CATEGORIA CAT ON CAT.idCategoria = S.idCategoria
		WHERE P.activo = 1
		GROUP BY CAT.idCategoria, CAT.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, CAT.nombre ASC;
    END IF;
        
	IF p_isSubategoria = 1 THEN
		SELECT 
			S.idSubcategoria, S.nombre,
			SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		WHERE P.activo = 1
		GROUP BY S.idSubcategoria, S.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, S.nombre ASC;
    END IF;
        
	IF p_isClase = 1 THEN
		SELECT 
			C.idClase, C.nombre,
			SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) AS costoTotal
		FROM PRODUCTO P
		INNER JOIN CLASE C ON C.idClase = P.idClase
		WHERE P.activo = 1
		GROUP BY C.idClase, C.nombre
        HAVING SUM(IFNULL( fnGetCostoTotal(idProducto, p_fechaCorte), 0)) > 0
		ORDER BY costoTotal DESC, C.nombre ASC;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getNotaAlmacenById` (IN `p_idNotaAlmacen` INT)  BEGIN   
	SELECT NA.idNotaAlmacen, NA.idAlmacen, NA.correlativo, 
		NA.tipoOperacion, NA.idTipoDocumento, 
        NA.fechaEmision, NA.fechaContable, 
        DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") as fechaEmisionFormato, 
        DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") as fechaContableFormato,  NA.estado,
		NA.idOrdenCompra, NA.idOrdenMantenimiento, NA.idOrdenServicio,
        CASE WHEN NA.idOrdenCompra is not null THEN CONCAT('OC-', OC.correlativo)
			WHEN NA.idOrdenMantenimiento is not null THEN CONCAT('OTM-', OTM.correlativo)
            WHEN NA.idOrdenServicio is not null THEN CONCAT('OS-', OS.correlativo)
		END AS correlativoDocumento,
        M4.abrev as tipoDocumento, M4.descripcion as desTipoDocumento, 
        CASE WHEN OC.idOrdenCompra is not null THEN NA.serieDocumento
			WHEN OTM.idOrdenMantenimiento is not null THEN ''
            WHEN OS.idOrdenServicio is not null THEN OS.serieDocumento
		END AS serieDocumento, 
        CASE WHEN OC.idOrdenCompra is not null THEN NA.serieDocumento
			WHEN OTM.idOrdenMantenimiento is not null THEN ''
            WHEN OS.idOrdenServicio is not null THEN OS.serieDocumento
		END AS numeroDocumento,
        IFNULL(T.idTrabajador, 0) AS idTrabajador, IFNULL(CONCAT(T.nombre, ' ' , T.apePaterno, ' ', T.apeMaterno), '') as trabajador,
        IFNULL(PR.idProveedor, 0) AS idProveedor, IFNULL(PR.nombreEmpresa, '') as nombreProveedor,
		IFNULL(M2.descripcion, '') as 'formaPago', IFNULL(M3.descripcion, '') as 'tipoMoneda',
        IFNULL(M5.valor, 0) as idDestino,
         IFNULL(M5.descripcion, '') as destino, 
         ifnull(UM.idUnidad, '') as idUnidad,
         ifnull(UM.placa, '-') as placa,
         CASE WHEN NA.idOrdenMantenimiento is not null THEN OTM.componente
             ELSE ''
		END AS componente,
        CASE WHEN NA.idOrdenMantenimiento is not null THEN OTM.kilometraje
			 WHEN NA.idOrdenServicio is not null THEN OS.kilometraje
             ELSE ''
		END AS kilometraje,
		DNA.idDetaNota, DNA.idProducto, DNA.nombreProducto, P.codigo as codigoProducto,
        DNA.idPresentacion, DNA.nombrePresentacion, DNA.valorPresentacion, DNA.precioPresentacion, 
		DNA.valorUnitario, DNA.precioUnitario, DNA.cantidad, DNA.valorVenta, DNA.monto, 
		DNA.idUnidadMedida, DNA.unidadMedida, ifnull(DNA.observacion, '') as observacion
	FROM NOTA_ALMACEN NA
	INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen
	INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
    LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = NA.idOrdenCompra
    LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = NA.idOrdenMantenimiento
    LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
    LEFT JOIN PROVEEDOR PR ON (PR.idProveedor = OC.idProveedor OR PR.idProveedor = OS.idProveedor)
    LEFT JOIN TRABAJADOR T ON (T.idTrabajador = OTM.idTrabajador OR T.idTrabajador = NA.idTrabajador)
	LEFT JOIN MULTITABLA M2 ON (M2.abrev = OC.formaPago AND M2.dep_id = 8)
	LEFT JOIN MULTITABLA M3 ON M3.dep_id = 20 AND (M3.valor = OC.idTipoMoneda OR M3.valor = OS.idTipoMoneda)
	LEFT JOIN MULTITABLA M4 ON M4.dep_id = 15 AND (M4.abrev = OC.tipoDocumento OR M4.abrev = OS.tipoDocumento)
	LEFT JOIN MULTITABLA M5 ON M5.dep_id = 21 AND (M5.valor = OC.idDestino OR M5.valor = NA.idDestino)  
	LEFT JOIN UNIDAD_MOVIL UM ON (UM.idUnidad = OC.idUnidad or UM.idUnidad = OTM.idUnidad 
								or UM.idUnidad = OS.idUnidad or UM.idUnidad = NA.idUnidad )
	WHERE NA.idNotaAlmacen = p_idNotaAlmacen; -- and DNA.activo = 1 and DNA.anulado = 0;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getOrdenCompraByCorrelativo` (IN `p_correlativo` CHAR(8))  BEGIN   
	SELECT
			OC.idOrdenCompra,
			CASE WHEN OC.correlativo = '' THEN '' 
				ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.correlativo as correlativo2,
            OC.idOrdenMantenimiento,
            CASE WHEN OTM.correlativo is null THEN '-'
				ELSE CONCAT('OTM-', OTM.correlativo)
			END as correlativoOTM,
            OC.idOrdenServicio,
            CASE WHEN OS.correlativo is null THEN '-'
				ELSE CONCAT('OS-', OS.correlativo)
			END as correlativoOS,
            CASE 
                WHEN OC.idUnidad is not null then UM3.placa
				WHEN OTM.idUnidad is not null then UM1.placa
				WHEN OS.idUnidad is not null then UM2.placa
				ELSE '-'
            END as placa,
            CASE WHEN OC.idDestino is null THEN  CASE WHEN OTM.idUnidad is not null then UM1.placa
													  WHEN OS.idUnidad is not null then UM2.placa
													  ELSE '-'
												 END
				 ELSE M5.descripcion END as destino,
            OC.codCotizacion,
            OC.idProveedor, OC.nombreProveedor, OC.rucProveedor, OC.direccionProveedor, 
            OC.telefonoProveedor, OC.emailProveedor,
            OC.lugarAtencion, OC.tipoDocumento, M4.descripcion as desTipoDocumento,
            ifnull(OC.serieDocumento, '') as serieDocumento,
            ifnull(OC.numeroDocumento, '') as numeroDocumento,
            ifnull( CONCAT(C.serieDocumento, '-', C.numeroDocumento ) , '') as documento,
            OC.subTotal, OC.descuento, OC.igv, OC.igv2, OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') as 'fechaEntrega',
            OC.estadoRecepcion, M.descripcion as desEstado,
            M2.descripcion as 'formaPago', M3.descripcion as 'tipoMoneda',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado',
            DOC.idDetalleOrden, DOC.idProducto, CONCAT(CL.abreviatura, '-', P.codigo) as codigoProducto, DOC.nombreProducto, 
            DOC.idPresentacion, DOC.nombrePresentacion,
            DOC.valorUnitario, DOC.descuentoUnitario, DOC.precioUnitario, DOC.cantidad, DOC.cantidadAceptada,
            DOC.valorVenta, DOC.monto, DOC.cantidadTotal, CONCAT( DOC.cantidadTotal, ' ', DOC.unidadMedida) as cantidadTotal2,
            DOC.idUnidadMedida, DOC.unidadMedida, DOC.urgencia
		FROM ORDEN_COMPRA OC
        LEFT JOIN UNIDAD_MOVIL UM3 ON UM3.idUnidad = OC.idUnidad
        LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = OC.idOrdenMantenimiento
        LEFT JOIN UNIDAD_MOVIL UM1 ON UM1.idUnidad = OTM.idUnidad
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = OC.idOrdenServicio
        LEFT JOIN UNIDAD_MOVIL UM2 ON UM2.idUnidad = OS.idUnidad     
        LEFT JOIN COMPRA C ON C.idOrdenCompra = OC.idOrdenCompra
        INNER JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        INNER JOIN MULTITABLA M2 ON (M2.abrev = OC.formaPago AND M2.dep_id = 8)
        INNER JOIN MULTITABLA M3 ON (M3.valor = OC.idTipoMoneda AND M3.dep_id = 20)
        INNER JOIN MULTITABLA M4 ON (M4.abrev = OC.tipoDocumento AND M4.dep_id = 15)
        LEFT JOIN MULTITABLA M5 ON (M5.valor = OC.idDestino AND M5.dep_id = 21)
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        INNER JOIN DETALLE_ORDEN DOC ON DOC.idOrdenCompra = OC.idOrdenCompra
        INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
		INNER JOIN CLASE CL ON CL.idClase = P.idClase
        WHERE OC.correlativo = LPAD(p_correlativo, 6, '0') and DOC.activo = 1;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getOrdenMantenimientoByCorrelativo` (IN `p_correlativo` CHAR(8))  BEGIN   
	SELECT OTM.idOrdenMantenimiento, CONCAT('OTM-', OTM.correlativo) as correlativoOTM,  
		OTM.idTrabajador, CONCAT(T.Nombre, ' ', T.apePaterno, ' ', T.apeMaterno) as trabajador,
		OTM.idUnidad, UM.placa, 
		IFNULL(OTM.kilometraje, '') AS kilometraje, IFNULL(OTM.componente, '') AS componente,
		DATE_FORMAT(OTM.fechaInicio, '%d/%m/%Y') as 'fechaInicio', DATE_FORMAT(OTM.fechaFin, '%d/%m/%Y') as 'fechaFin',
		OTM.estado, M.descripcion as desEstado,
		DOTM.idDetaOrden, DOTM.idProducto, CONCAT(C.abreviatura, '-', P.codigo) as codigoProducto, P.nombre as nombreProducto, 
        P.unidad_medida as idUnidadMedida, M2.descripcion as unidadMedida,
		DOTM.cantidad, DOTM.cantidadConsumida, IFNULL(DOTM.observacion, '') AS observacion
	FROM ORDEN_MANTENIMIENTO OTM
	INNER JOIN TRABAJADOR T ON T.idTrabajador = OTM.idTrabajador
	INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OTM.idUnidad
	INNER JOIN MULTITABLA M ON M.abrev = OTM.estado and M.dep_id = 10
	INNER JOIN DETALLE_ORDEN_MANTENIMIENTO DOTM ON DOTM.idOrdenMantenimiento = OTM.idOrdenMantenimiento
	INNER JOIN PRODUCTO P ON P.idProducto = DOTM.idProducto
	INNER JOIN CLASE C ON C.idClase = P.idClase
	INNER JOIN MULTITABLA M2 ON M2.abrev = P.unidad_medida and M2.dep_id = 3
	WHERE OTM.correlativo = LPAD(p_correlativo, 6, '0') and OTM.activo = 1 and DOTM.activo = 1; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_getOrdenServicioByCorrelativo` (IN `p_correlativo` CHAR(8))  BEGIN   
	SELECT OS.idOrdenServicio, OS.correlativo as correlativoOS,  OS.idProveedor, PR.nombreEmpresa as nombreProveedor,
		OS.idUnidad, UM.placa, 
		IFNULL(OS.kilometraje, '') AS kilometraje, 
		DATE_FORMAT(OS.fechaInicio, '%d/%m/%Y') as 'fechaInicio', DATE_FORMAT(OS.fechaFin, '%d/%m/%Y') as 'fechaFin',
		OS.tipoDocumento as idTipoDocumento, M3.descripcion as tipoDocumento, OS.serieDocumento, OS.numeroDocumento,
		OS.idTipoMoneda, M4.descripcion as tipoMoneda,
		OS.estado, M.descripcion as desEstado,
		DOS.idDetaOrden, DOS.idProducto, CONCAT(C.abreviatura, '-', P.codigo) as codigoProducto, P.nombre as nombreProducto,
		P.unidad_medida as idUnidadMedida, M2.descripcion as unidadMedida,
		DOS.cantidad, DOS.cantidadConsumida, IFNULL(DOS.observacion, '') AS observacion
	FROM ORDEN_SERVICIO OS
	INNER JOIN PROVEEDOR PR ON PR.idProveedor = OS.idProveedor
	INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OS.idUnidad
	INNER JOIN MULTITABLA M ON M.abrev = OS.estado and M.dep_id = 10
	INNER JOIN DETALLE_ORDEN_SERVICIO DOS ON DOS.idOrdenServicio = OS.idOrdenServicio
	INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
	INNER JOIN CLASE C ON C.idClase = P.idClase
	INNER JOIN MULTITABLA M2 ON M2.abrev = P.unidad_medida and M2.dep_id = 3
	INNER JOIN MULTITABLA M3 ON M3.abrev = OS.tipoDocumento and M3.dep_id = 15
	INNER JOIN MULTITABLA M4 ON M4.valor = OS.idTipoMoneda and M4.dep_id = 20
	WHERE OS.correlativo = LPAD(p_correlativo, 6, '0') and OS.activo = 1 and DOS.activo = 1; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCatalogo` (IN `p_idCatalogo` INT, IN `p_idProducto` INT, IN `p_idProveedor` INT, IN `p_nombre` VARCHAR(150), IN `p_codigo` VARCHAR(50), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN     
		INSERT INTO CATALOGO_PROVEEDOR (idProducto, idProveedor, nombre, codigo, 
			registro_fecha_add, registro_user_add, registro_pc_add,
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		VALUES (p_idProducto, p_idProveedor, p_nombre, p_codigo, 
				now(), p_registro_user_add, '-',
                now(), p_registro_user_update, '-', 1);
                
		select 1 as respuesta;
    END	IF;  
    
    IF p_tipoOperacion = 2 THEN    		
                
		INSERT INTO CATALOGO_PROVEEDOR (idProducto, idProveedor, nombre, codigo, 
			registro_fecha_add, registro_user_add, registro_pc_add,
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		VALUES (p_idProducto, p_idProveedor, p_nombre, p_codigo, 
				now(), p_registro_user_add, '-',
                now(), p_registro_user_update, '-', 1);
                
		select 1 as respuesta;
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN    		
        DELETE FROM CATALOGO_PROVEEDOR WHERE idProducto = p_idProducto;
                
		select 1 as respuesta;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCategoria` (IN `p_idCategoria` INT, IN `p_nombre` VARCHAR(150), IN `p_descripcion` VARCHAR(250), IN `p_abreviatura` CHAR(5), IN `p_codigo` VARCHAR(45), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM CATEGORIA WHERE nombre = p_nombre OR abreviatura = p_abreviatura OR codigo = p_codigo);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			INSERT INTO `CATEGORIA`(
							`nombre`, 
                            `descripcion`, 
                            `abreviatura`,
                            codigo,
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	
						p_nombre,
						p_descripcion,
						p_abreviatura,
                        p_codigo,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);           
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM CATEGORIA WHERE (nombre = p_nombre OR abreviatura = p_abreviatura OR codigo = p_codigo) and idCategoria != p_idCategoria);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			UPDATE `CATEGORIA` SET
							`nombre` = p_nombre, 
							`descripcion` = p_descripcion, 
							`abreviatura` = p_abreviatura, 							                            
                            `codigo` = p_codigo,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idCategoria = p_idCategoria;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateClase` (IN `p_idClase` INT, IN `p_idSubcategoria` INT, IN `p_nombre` VARCHAR(150), IN `p_descripcion` VARCHAR(250), IN `p_abreviatura` CHAR(3), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;    
    DECLARE cod_subcategoria varchar(50);
    DECLARE cod_clase varchar(50);
    
	IF p_tipoOperacion = 1 THEN       	
	    IF EXISTS (SELECT * FROM CLASE WHERE nombre = p_nombre and idSubcategoria = p_idSubcategoria) THEN
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Clase con este nombre.' as respuesta;
		ELSE
			IF EXISTS (SELECT * FROM CLASE WHERE abreviatura = p_abreviatura) THEN
					SELECT 0 AS 'tipoRespuesta', 'Ya existe una Clase con esta abreviatura.' as respuesta;
			ELSE  
				SET @cod_subcategoria = (SELECT codigo FROM SUBCATEGORIA WHERE idSubcategoria = p_idSubcategoria);
	            
				SET @cod_clase = (	SELECT 
										CASE WHEN length( cast(codigo as UNSIGNED)  + 1) = 1 then concat('0000', cast(codigo as UNSIGNED)  + 1)
											WHEN length( cast(codigo as UNSIGNED)  + 1) = 2 then concat('000', cast(codigo as UNSIGNED)  + 1)
											WHEN length( cast(codigo as UNSIGNED)  + 1) = 3 then concat('00', cast(codigo as UNSIGNED)  + 1)
											WHEN length( cast(codigo as UNSIGNED)  + 1) = 4 then concat('0', cast(codigo as UNSIGNED)  + 1)
											WHEN length( cast(codigo as UNSIGNED)  + 1) = 5 then  cast(codigo as UNSIGNED)  + 1
										END
                                    FROM CLASE 
									WHERE substring(codigo, 1, 3) = @cod_subcategoria
									ORDER BY codigo DESC LIMIT 1);
	            
	            IF @cod_clase is null THEN
					SET @cod_clase = (SELECT CONCAT(@cod_subcategoria, '01') );
	            END IF;
	            
				INSERT INTO `CLASE`( `idSubcategoria`, `nombre`, `descripcion`, `abreviatura`, codigo,
								`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
								`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo` ) 
				VALUES (  p_idSubcategoria, p_nombre, p_descripcion, p_abreviatura, @cod_clase, 
							now(), p_registro_user_add, "-", now(), "-", "-", 1 );	            
	            
		        SELECT 1 AS 'tipoRespuesta', 'Se guardó correctamente esta Clase.' as respuesta;
			END	IF;
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
	    IF EXISTS (SELECT * FROM CLASE WHERE nombre = p_nombre and idSubcategoria = p_idSubcategoria and idClase != p_idClase) THEN
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Clase con este nombre.' as respuesta;
		ELSE
			IF EXISTS (SELECT * FROM CLASE WHERE abreviatura = p_abreviatura and idClase != p_idClase) THEN
					SELECT 0 AS 'tipoRespuesta', 'Ya existe una Clase con esta abreviatura.' as respuesta;
			ELSE
				UPDATE `CLASE` SET
								`idSubcategoria` = p_idSubcategoria,
								`nombre` = p_nombre, 
								`descripcion` = p_descripcion, 
								`abreviatura` = p_abreviatura, 							                            
								`registro_fecha_update` = now(),
								`registro_user_update` = p_registro_user_update, 
								`registro_pc_update` = '-',
	                            `activo` = p_activo
				WHERE idClase = p_idClase;
					           			
				SELECT 1 AS 'tipoRespuesta', 'Se editó correctamente esta Clase.' as respuesta;
			END	IF;
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCliente` (IN `p_idCliente` INT, IN `p_idTipoCliente` INT, IN `p_idCategoria` INT, IN `p_idPais` VARCHAR(5), IN `p_idCiudad` INT, IN `p_razonSocial` VARCHAR(300), IN `p_nombreComercial` VARCHAR(300), IN `p_nombres` VARCHAR(300), IN `p_apellidoPaterno` VARCHAR(300), IN `p_apellidoMaterno` VARCHAR(300), IN `p_direccion` VARCHAR(300), IN `p_referencia` VARCHAR(50), IN `p_idTipoDocumento` INT, IN `p_documento` VARCHAR(20), IN `p_fechaNacimiento` DATE, IN `p_email` VARCHAR(50), IN `p_telefono1` VARCHAR(20), IN `p_telefono2` VARCHAR(20), IN `p_cuentaInstagram` VARCHAR(50), IN `p_cuentaFacebook` VARCHAR(50), IN `p_ocupacion` VARCHAR(50), IN `p_lugarOcupacion` VARCHAR(50), IN `p_calificacion` VARCHAR(300), IN `p_usuarioRegistro` VARCHAR(50), IN `p_activo` INT)  BEGIN 

	DECLARE	tam int;
	DECLARE cuerpo varchar(6);
	DECLARE cuerpoFinal varchar(6);
	DECLARE aux varchar(6);
	DECLARE aux1 int;
	DECLARE aux2 int;
	DECLARE b int default 1;
	DECLARE _codigo varchar(9);
	
    IF p_idCliente IS NULL OR p_idCliente = 0 OR p_idCliente = ''
		THEN
			
            SET cuerpo = (SELECT Max(SUBSTRING(codigoCliente,4,9)) FROM CLIENTE);
			
			SET tam = length(cuerpo);
			
			
			IF (tam = 6) then
				set aux = cuerpo;
				set aux1 = cast(aux as UNSIGNED); 
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6));
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while; 
				
				set cuerpoFinal = aux;
				
			ELSE
				set aux = '0';
				set aux1 = cast(aux as UNSIGNED);
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6)); 
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while;
				
				set cuerpoFinal = aux;         
				 
			END IF;
			
			SET _codigo = concat('CL-',cuerpoFinal);

			INSERT INTO CLIENTE(idCategoria,
								idTipoCliente,
								idPais,
								idCiudad,
								codigoCliente,
								razonSocial,
								nombreComercial,
								nombres,
								apellidoPaterno,
								apellidoMaterno,
								idTipoDocumento,
								documento,
								direccion,
								fechaNacimiento,
								telefono1,
								telefono2,
								-- telefono3,
								email,
								referencia,
								cuentaFacebook ,
								cuentaInstagram,
								ocupacion,
								lugarOcupacion,
								-- comentario,
								calificacion,
								fechaRegistro ,
								usuarioRegistro,
								pcRegistro,
								fechaEdicion,
								usuarioEdicion,
								pcEdicion,
								activo)
						VALUES(	p_idCategoria,
								p_idTipoCliente,
								p_idPais,
								p_idCiudad,
								_codigo,
								p_razonSocial,
								p_nombreComercial,
								p_nombres,
								p_apellidoPaterno,
								p_apellidoMaterno,
								p_idTipoDocumento,
								p_documento,
								p_direccion,
								p_fechaNacimiento,
								p_telefono1,
								p_telefono2,
								p_email,
								p_referencia,
								p_cuentaFacebook,
								p_cuentaInstagram,
								p_ocupacion,
								p_lugarOcupacion,
								p_calificacion,
								NOW(),
								p_usuarioRegistro,
								@@hostname,
								NOW(),
								p_usuarioRegistro,
								@@hostname,
								p_activo);
			SELECT	1 AS tipoRespuesta,
					p_idTipoCliente AS tipoCliente,
					'El cliente de registró correctamente' AS respuesta,
					last_insert_id() AS idCliente;
							
	ELSE
		UPDATE 	CLIENTE
        SET		idCategoria = p_idCategoria,
				idTipoCliente = p_idTipoCliente,				
				idPais = p_idPais,	
				idCiudad = p_idCiudad,
				razonSocial = p_razonSocial,								
				nombreComercial = p_nombreComercial,
				nombres = p_nombres,
				apellidoPaterno = p_apellidoPaterno,
				apellidoMaterno = p_apellidoMaterno,
				idTipoDocumento = p_idTipoDocumento,
				documento = p_documento,
				direccion = p_direccion,
				fechaNacimiento = p_fechaNacimiento,
				telefono1 = p_telefono1,
				telefono2 = p_telefono2,
				email = p_email,
				referencia = p_referencia,
				cuentaFacebook = p_cuentaFacebook,
				cuentaInstagram = p_cuentaInstagram,
				ocupacion = p_ocupacion,
				lugarOcupacion = p_lugarOcupacion,
				calificacion = p_calificacion,
				fechaEdicion = 	NOW(),
				usuarioEdicion = p_usuarioRegistro,
				pcEdicion = @@hostname,
				activo = p_activo
		WHERE	idCliente = p_idCliente;
        
        SELECT	1 AS tipoRespuesta,
				p_idCliente AS idCliente,
				p_idTipoCliente AS tipoCliente,
				'El cliente de editó correctamente' AS respuesta;
    
    END IF;
    
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCompra` (IN `p_idCompra` INT, IN `p_idGrupoCotizacion` INT, IN `p_idCotizacion` INT, IN `p_idOrdenCompra` INT, IN `p_codCotizacion` VARCHAR(50), IN `p_serieDocumento` VARCHAR(50), IN `p_numeroDocumento` VARCHAR(50), IN `p_tipoDocumento` CHAR(5), IN `p_formaPago` CHAR(5), IN `p_idOficina` INT, IN `p_idTipoMoneda` INT, IN `p_idDestino` INT, IN `p_idUnidad` INT, IN `p_fechaEntrega` DATETIME, IN `p_fechaEmision` DATETIME, IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);
    
	DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    DECLARE v_nombreProveedor varchar(300);
    DECLARE v_rucProveedor char(11);
    DECLARE v_direccionProveedor varchar(250);
    DECLARE v_telefonoProveedor varchar(12);
    DECLARE v_emailProveedor varchar(50);
    
    DECLARE v_idOficina int;
    DECLARE v_lugarAtencion varchar(400);
    DECLARE v_idTipoMoneda int;
    DECLARE v_idDestino int;
    DECLARE v_tasaCambio decimal(18,3);
    
    
    DECLARE subtotal	decimal(18,2);
    DECLARE v_descuento	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_idCot 	INT;
    DECLARE v_idOC 		INT;
    DECLARE v_idOrdenMantenimiento	INT;
    DECLARE v_idOrdenServicio	INT;
    DECLARE v_cor 		char(8);    
    
    IF p_tipoOperacion = 1 THEN				
        DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
		SELECT *
		FROM DETALLE_ORDEN
		WHERE idOrdenCompra = p_idOrdenCompra
		ORDER BY idDetalleOrden ASC;
           
		IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            SET @v_lugarAtencion = ifnull( (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina), 1);
            
            SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio, igv
			INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio, @v_igv
			FROM ORDEN_COMPRA 
			WHERE idOrdenCompra = p_idOrdenCompra;
			
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = @v_idProveedor;
            
            SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
			
			SET @v_id = IFNULL((SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1), 0) + 1;
			
			INSERT INTO `COMPRA`(
				idOrdenCompra, idOrdenMantenimiento, idOrdenServicio,						
				idProveedor, nombreProveedor, rucProveedor, direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago,
				idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
				subTotal, descuento, igv, igv2,	total, 
				fechaEnvio, fechaEntrega, fechaAceptada, estado,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)   		
			VALUES (p_idOrdenCompra, @v_idOrdenMantenimiento, @v_idOrdenServicio,
					@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor,
					@v_telefonoProveedor, @v_emailProveedor,
					@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
					p_idOficina, @v_lugarAtencion, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
					                    0.00, 0.00, @v_igv, 0.00, 0.00, 
					p_fechaEmision, p_fechaEntrega, null, 'A', 
					now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
            
            SET @v_id = IFNULL((SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1), 1);
            
            INSERT INTO `DETALLE_COMPRA`(
				idCompra, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
				`cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`,
                valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, monto, montoA,
				cantidadTotal, cantidadTotalA,
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, `registro_user_add`, `registro_pc_add`, 
				registro_fecha_update, `registro_user_update`,`registro_pc_update`, `activo`
			)  
			SELECT  @v_id, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitarioA, 0.00, descuentoUnitarioA, 0.00, precioUnitarioA, 0.00,
                cantidadAceptada, 0.00, 0.00, 0.00, 
				valorVentaA, 0.00, descuentoTotalA, 0.00, montoA, 0.00,
                cantidadTotalA, 0.00,
				idUnidadMedida, unidadMedida,
				'A', urgencia,  
				now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL;
            
            
            UPDATE ORDEN_COMPRA SET 
					estadoRecepcion = 'A'
			WHERE idOrdenCompra = p_idOrdenCompra;
			
            SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
            SET @v_descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
            SET @total = (SELECT SUM(monto) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
            
            UPDATE COMPRA SET 
				total = @total,
				igv2 = @total - @subtotal + @v_descuento,
                subtotal = @subtotal
            WHERE idCompra = @v_id;            
			
			SELECT 1 as tipoRespuesta, CONCAT('CM-', @v_cor) AS 'respuesta', @v_id as 'idCompra';
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta,
                p_idOrdenCompra as idOrdenCompra;
        END IF;
    END	IF; 

	IF p_tipoOperacion = 2 THEN        
		SET @v_id = (SELECT count(*) + 1 FROM GRUPO_COTIZACION WHERE correlativo != '');
        
		SET @v_cor = CONCAT('GC-', CONVERT(@v_id, CHAR(5)));
		      
		UPDATE `GRUPO_COTIZACION` SET 
							`estado` = 'P',
							`correlativo` = @v_cor,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
		WHERE idGrupoCotizacion = p_idGrupoCotizacion; 
	
        
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_GRUPOCOTIZACION
		WHERE idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleGrupo ASC;
        
		SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedorC)) FROM TEMPORAL );
        
        IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
	
		WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedorC FROM TEMPORAL LIMIT 1);	            
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedorC = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('C-', CONVERT(@v_id, CHAR(5)));
			INSERT INTO `COMPRA`(  
							`idOrdenCompra`, 
							`idProveedor`, 
							`correlativo`, 
							`subTotal`,
							`igv`,
							`igv2`,
							`total`,
							`fechaEnvio`,
							`fechaAceptada`,
							`estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (null, @v_idProveedor, @v_cor, @subtotal, @v_igv, @total - @subtotal, @total, 
					now(), null, 'EN', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
            			
			INSERT INTO `DETALLE_COMPRA`(  								
								`idProducto`, 
								`idCompra`,
								`idPresentacion`,
								`idProveedor`,
								`precioUnitario`, 
                                `precioUnitarioA`, 
								`cantidad`,
								`cantidadAceptada`,
                                `cantidadRechazada`,
                                `cantidadReenviada`,
								`monto`,    
								`montoA`,    
								`cantidadTotal`,
								`cantidadTotalA`,
								`urgencia`, 
								`estado`, 
								`registro_fecha_add`, 
								`registro_user_add`, 
								`registro_pc_add`, 
								`registro_fecha_update`,
								`registro_user_update`, 
								`registro_pc_update`,
								`activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedorC, precioUnitario, 0.00,
					cantidad, 0, 0, 0, monto, 0.00, cantidadTotal, 0, urgencia, 'EN', 
                    now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL
			WHERE idProveedorC = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedorC = @v_idProveedor;
            
            SET @nProveedor = @nProveedor - 1;
        END WHILE;  
        
         UPDATE GRUPO_COTIZACION SET 
		 	fechaEnvio = now(),
			estado = 'EN'
		 WHERE idGrupoCotizacion = p_idGrupoCotizacion;
         
         SELECT 1 AS 'respuesta';
    
    END	IF;

	IF p_tipoOperacion = 3 THEN  		
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_COTIZACION
		WHERE idCotizacion = p_idCotizacion
		ORDER BY idDetalleCotizacion ASC;
		
        SET @v_tasaCambio = (	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision);
        SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
        
        SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio
		INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio
		FROM COTIZACION 
		WHERE idCotizacion = p_idCotizacion;
        
        SELECT nombreEmpresa, ruc, direccion, telefono1, email 
        INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
		FROM PROVEEDOR 
        WHERE idProveedor = @v_idProveedor;
            
		
		SET @v_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);		
            
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
				
        
		SET @v_tasaCambio = ifnull((	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda), 1);
		SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
		INSERT INTO `COMPRA`(
			idOrdenCompra, idOrdenMantenimiento, idOrdenServicio,
            idProveedor, nombreProveedor, rucProveedor, direccionProveedor,telefonoProveedor, emailProveedor,
			correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago,
			idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
			`subTotal`,	descuento, `igv`, `igv2`,	`total`, 
			`fechaEnvio`, fechaEntrega,	`fechaAceptada`,`estado`,
			registro_fecha_add, registro_user_add, registro_pc_add, 
			registro_fecha_update, registro_user_update, registro_pc_update, activo
		)   
		VALUES (p_idOrdenCompra, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor,
				@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
				p_idOficina, @v_domicilioFiscal, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
				0.00, 0.00, @v_igv, 0.00, 0.00, 
				p_fechaEmision, p_fechaEntrega, null, 'A', 
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
                		
		SET @v_id = IFNULL((SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1), 1);
		INSERT INTO DETALLE_COMPRA(
			idCompra, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
            valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA,
			cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
			valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, monto, montoA,  
			cantidadTotal, cantidadTotalA, 
			idUnidadMedida, unidadMedida,
			estado, urgencia,
			registro_fecha_add, registro_user_add, registro_pc_add, 
			registro_fecha_update, registro_user_update, registro_pc_update, activo
		)         
		SELECT @v_id, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			valorUnitarioA, 0.00, descuentoUnitarioA, 0.00, precioUnitarioA, 0.00,
			cantidadAceptada, 0, 0, 0, 
            valorVentaA, 0.00, descuentoTotalA, 0.00, montoA, 0.00, 
            cantidadTotalA, 0,
            idUnidadMedida, unidadMedida,
            'EN', urgencia,  
            now(), p_registro_user_add, "-", now(), "-", "-", 1
		FROM TEMPORAL;
        
        SET @total = (SELECT SUM(monto) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
        SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
        SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_COMPRA WHERE idCompra = @v_id);
		SET @v_igv = (@total - @subtotal + @descuento);
            
		UPDATE COMPRA SET 
			subtotal = @subtotal,
			descuento = @descuento,
			igv2 = @v_igv,
			total = @total
		WHERE idCompra = @v_id;
        
        UPDATE COTIZACION SET 
			estado = 'A'
		WHERE idCotizacion = p_idCotizacion;
        
        SELECT 1 as tipoRespuesta, CONCAT('CM-', @v_cor) AS 'respuesta', @v_id as 'idCompra';
	END	IF;

	IF p_tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_GRUPOCOTIZACION
		WHERE idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleGrupo ASC;
        
		SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedorC)) FROM TEMPORAL );
        
		IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
	
		WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedorC FROM TEMPORAL LIMIT 1);	            
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedorC = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idCotizacion FROM COTIZACION ORDER BY idCotizacion DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('CT-', CONVERT(@v_id, CHAR(5)));
			INSERT INTO `COTIZACION`(
							`idProveedor`, 
							`idGrupoCotizacion`, 
							`correlativo`, 
							`subTotal`,
							`igv`,
							`igv2`,
							`total`,
							`fechaEnvio`,
							`fechaAceptada`,
							`estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (@v_idProveedor, p_idGrupoCotizacion, @v_cor, @subtotal, @v_igv, @total - @subtotal, @total, 
					now(), null, 'EN', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
            			
			INSERT INTO `DETALLE_COTIZACION`(
								`idProducto`, `idCotizacion`, `idPresentacion`, `idProveedor`,
								`precioUnitario`, `precioUnitarioA`, `cantidad`, `cantidadAceptada`,
                                `cantidadRechazada`, `cantidadReenviada`,
								`monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`, `urgencia`, `estado`, 
								`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
								`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedorC, 
					precioUnitario, precioUnitario, cantidad, cantidad, 
                    0, 0, 
                    monto, monto, cantidadTotal, cantidadTotal, urgencia, 'A', 
                    now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL
			WHERE idProveedorC = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedorC = @v_idProveedor;
            
            SET @nProveedor = @nProveedor - 1;
        END WHILE;  
        
        UPDATE GRUPO_COTIZACION SET 
		 	fechaEnvio = now(),
			estado = 'EN'
		WHERE idGrupoCotizacion = p_idGrupoCotizacion;
        
        
        DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT DC.*
		FROM DETALLE_COTIZACION DC
        INNER JOIN COTIZACION C ON C.idCotizacion = DC.idCotizacion
		WHERE C.idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleCotizacion ASC;
                       
        SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedor)) FROM TEMPORAL);
        
		IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
                
        WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedor FROM TEMPORAL LIMIT 1);	            
            SET @v_idCot = ( SELECT idCotizacion FROM TEMPORAL where idProveedor = @v_idProveedor LIMIT 1);	 
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedor = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('OC-', CONVERT(@v_id, CHAR(5)));
			                       
			INSERT INTO `ORDEN_COMPRA`(
							`idCotizacion`, `idProveedor`, `idGrupoOrden`,  `correlativo`, 
                            `fechaEntrega`, `formaPago`, `codFactura`, `codCotizacion`, 
                            `subTotal`, `igv`, `igv2`, `total`,
							`fechaEnvio`, `fechaAceptada`, `estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (@v_idCot, @v_idProveedor, p_idGrupoCotizacion, @v_cor, 
					now(), 1, 'aaa', 'aaa',
                    @subtotal, @v_igv, @total - @subtotal, @total, 
					now(), null, 'A', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
			
			INSERT INTO `DETALLE_ORDEN`(
								`idProducto`, `idOrdenCompra`, `idPresentacion`, `idProveedor`,
								`precioUnitario`, `precioUnitarioA`, 
								`cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`,
								`monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`,
								`urgencia`, `estado`, 
                                `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 	
                                `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedor, 
					precioUnitario, precioUnitario,
					cantidad, cantidad, 0, 0, 
                    monto, monto, cantidadTotal, cantidadTotal, urgencia, 'A', 
                    now(), p_registro_user_add, "-", now(), "-
					", "-", 1
			FROM TEMPORAL
			WHERE idProveedor = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedor = @v_idProveedor;
            
            UPDATE COTIZACION SET 
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = @v_idCot;
            
			SET @nProveedor = @nProveedor - 1;            
        END WHILE;  
                       
        DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT OD.*
		FROM DETALLE_ORDEN OD
        INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
        INNER JOIN COTIZACION C ON C.idCotizacion = OC.idCotizacion
		WHERE C.idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleOrden ASC;
                       
        SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedor)) FROM TEMPORAL);
        
		IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
                
        WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedor FROM TEMPORAL LIMIT 1);	            
            SET @v_idOC = ( SELECT idOrdenCompra FROM TEMPORAL where idProveedor = @v_idProveedor LIMIT 1);	 
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedor = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('CM-', CONVERT(@v_id, CHAR(5)));
			     SELECT * FROM COMPRA;
			INSERT INTO `COMPRA`(
							`idOrdenCompra`, `idProveedor`,  `correlativo`, 
							`fechaEntrega`, `formaPago`, `codFactura`, `codCotizacion`, 
                            `subTotal`, `igv`, `igv2`, `total`,
							`fechaEnvio`, `fechaAceptada`, `estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (@v_idOC, @v_idProveedor, @v_cor, 
					now(), 1, 'aaa', 'aaa',
                    @subtotal, @v_igv, @total - @subtotal, @total, 
					now(), now(), 'A', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
			
			INSERT INTO `DETALLE_COMPRA`(
								`idProducto`, `idCompra`, `idPresentacion`, `idProveedor`,
								`precioUnitario`, `precioUnitarioA`, 
								`cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`,
								`monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`,
								`urgencia`, `estado`, 
                                `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 	
                                `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedor, 
					precioUnitario, precioUnitario,
					cantidad, cantidad, 0, 0, 
                    monto, monto, cantidadTotal, cantidadTotal, urgencia, 'A', 
                    now(), p_registro_user_add, "-", now(), "-
					", "-", 1
			FROM TEMPORAL
			WHERE idProveedor = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedor = @v_idProveedor;
            
            UPDATE 	ORDEN_COMPRA SET 
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = @v_idCot;
            
			SET @nProveedor = @nProveedor - 1;            
        END WHILE;  
                                
        SELECT 1 as 'respuesta';
	END	IF;

	IF p_tipoOperacion = 5 THEN    
    
		SET @v_cor = (SELECT correlativo FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
        
        IF @v_cor = '' THEN
			SET @v_cor = CONCAT('GC-', CONVERT(p_idGrupoCotizacion, CHAR(5)));
            
            UPDATE GRUPO_COTIZACION SET correlativo = @v_cor WHERE idGrupoCotizacion = p_idGrupoCotizacion;
        END IF;
		
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_GRUPOCOTIZACION
		WHERE idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleGrupo ASC;
        
		SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedorC)) FROM TEMPORAL );
        
		IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
	
		WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedorC FROM TEMPORAL LIMIT 1);	            
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedorC = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idCotizacion FROM COTIZACION ORDER BY idCotizacion DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('CT-', CONVERT(@v_id, CHAR(5)));
			INSERT INTO `COTIZACION`(
							`idProveedor`, 
							`idGrupoCotizacion`, 
							`correlativo`, 
							`subTotal`,
							`igv`,
							`igv2`,
							`total`,
							`fechaEnvio`,
							`fechaAceptada`,
							`estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (@v_idProveedor, p_idGrupoCotizacion, @v_cor, @subtotal, @v_igv, @total - @subtotal, @total, 
					now(), null, 'EN', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
            			
			INSERT INTO `DETALLE_COTIZACION`(
								`idProducto`, `idCotizacion`, `idPresentacion`, `idProveedor`,
								`precioUnitario`, `precioUnitarioA`, `cantidad`, `cantidadAceptada`,
                                `cantidadRechazada`, `cantidadReenviada`,
								`monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`, `urgencia`, `estado`, 
								`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
								`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedorC, 
					precioUnitario, precioUnitario, cantidad, cantidad, 
                    0, 0, 
                    monto, monto, cantidadTotal, cantidadTotal, urgencia, 'A', 
                    now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL
			WHERE idProveedorC = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedorC = @v_idProveedor;
            
            SET @nProveedor = @nProveedor - 1;
        END WHILE;  
        
        UPDATE GRUPO_COTIZACION SET 
		 	fechaEnvio = now(),
			estado = 'EN'
		WHERE idGrupoCotizacion = p_idGrupoCotizacion;
        
        
        DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT DC.*
		FROM DETALLE_COTIZACION DC
        INNER JOIN COTIZACION C ON C.idCotizacion = DC.idCotizacion
		WHERE C.idGrupoCotizacion = p_idGrupoCotizacion
		ORDER BY idDetalleCotizacion ASC;
                       
        SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedor)) FROM TEMPORAL);
        
		IF @nProveedor = null THEN
			SET @nProveedor = 0;
		END IF;
                
        WHILE @nProveedor > 0 DO
			SET @v_idProveedor = ( SELECT idProveedor FROM TEMPORAL LIMIT 1);	            
            SET @v_idCot = ( SELECT idCotizacion FROM TEMPORAL where idProveedor = @v_idProveedor LIMIT 1);	 
            
			SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedor = @v_idProveedor);
            SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@v_igv/100)), DECIMAL(18,2));
            SET @v_id = (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1);	    
            
            IF(@v_id is null) THEN
				set @v_id = 0;
            END IF;
            
            SET @v_id = @v_id + 1;
            SET @v_cor = CONCAT('OC-', CONVERT(@v_id, CHAR(5)));
			                       
			INSERT INTO `ORDEN_COMPRA`(
							`idCotizacion`, `idProveedor`, `idGrupoOrden`,  `correlativo`, 
                            `fechaEntrega`, `formaPago`, `codFactura`, `codCotizacion`, 
                            `subTotal`, `igv`, `igv2`, `total`,
							`fechaEnvio`, `fechaAceptada`, `estado`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
							`activo`
			)   
            VALUES (@v_idCot, @v_idProveedor, p_idGrupoCotizacion, @v_cor, 
					now(), 1, '', '',
                    @subtotal, @v_igv, @total - @subtotal, @total, 
					p_fechaEmision, null, 'EN', now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);
				
			
			INSERT INTO `DETALLE_ORDEN`(
								`idProducto`, `idOrdenCompra`, `idPresentacion`, `idProveedor`,
								`precioUnitario`, `precioUnitarioA`, 
								`cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`,
								`monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`,
								`urgencia`, `estado`, 
                                `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 	
                                `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			)         
			SELECT idProducto, @v_id, idPresentacion, idProveedor, 
					precioUnitario, 0.00,
					cantidad, 0, 0, 0, 
                    monto, 0.00, cantidadTotal, 0, urgencia, 'EN', 
                    now(), p_registro_user_add, "-", now(), "-
					", "-", 1
			FROM TEMPORAL
			WHERE idProveedor = @v_idProveedor;    
			   
				
			DELETE FROM TEMPORAL WHERE idProveedor = @v_idProveedor;
            
            UPDATE COTIZACION SET 
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = @v_idCot;
            
			SET @nProveedor = @nProveedor - 1;            
        END WHILE;  
        
        select 1 as 'respuesta';
	END	IF;
    
    IF p_tipoOperacion = 6 THEN  		
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_ORDEN
		WHERE idOrdenCompra = p_idOrdenCompra
		ORDER BY idDetalleOrden ASC;
                    
        SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio, 
			idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio
        INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio, 
			@v_idOficina, @v_lugarAtencion, @v_idTipoMoneda, @v_idDestino, @v_idUnidad, @v_tasaCambio
        FROM ORDEN_COMPRA 
        WHERE idOrdenCompra = p_idOrdenCompra;
        
        SELECT nombreEmpresa, ruc, direccion, telefono1, email 
        INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
		FROM PROVEEDOR 
        WHERE idProveedor = @v_idProveedor;
            
		SET @total = (SELECT SUM(montoA) FROM TEMPORAL);
        SET @v_descuento = (SELECT SUM(descuentoTotalA) FROM TEMPORAL);
        SET @subtotal = (SELECT SUM(valorVentaA) FROM TEMPORAL);        
		SET @v_igv = (SELECT igv FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra);
            
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
				
        INSERT INTO `COMPRA`(
			idOrdenCompra, idOrdenMantenimiento, idOrdenServicio,
            idProveedor, nombreProveedor, rucProveedor, direccionProveedor,telefonoProveedor, emailProveedor,
			correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago,
			idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
			`subTotal`,	descuento, `igv`, `igv2`,	`total`, 
			`fechaEnvio`, fechaEntrega,	`fechaAceptada`,`estado`,
			`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
			`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
			`activo`
		)   
		VALUES (p_idOrdenCompra, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor,
				@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
                @v_idOficina, @v_lugarAtencion, @v_idTipoMoneda, @v_idDestino, @v_idUnidad, @v_tasaCambio,
				@subtotal, @v_descuento, @v_igv, @total - @subtotal + @v_descuento, @total, 
				p_fechaEmision, p_fechaEntrega, null, 'A', 
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
				
		SET @v_id = IFNULL((SELECT idCompra FROM COMPRA ORDER BY idCompra DESC LIMIT 1), 1);
		INSERT INTO DETALLE_COMPRA(
			idCompra, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
            valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA,
			cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
			valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, monto, montoA,  
			cantidadTotal, cantidadTotalA, 
			idUnidadMedida, unidadMedida,
			`estado`, `urgencia`,
			`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
			`registro_fecha_update`, `registro_user_update`,`registro_pc_update`,
			`activo`
		)         
		SELECT  @v_id, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			valorUnitarioA, 0.00, descuentoUnitarioA, 0.00, precioUnitarioA, 0.00,
			cantidadAceptada, 0, 0, 0, 
            valorVentaA, 0.00, descuentoTotalA, 0.00, montoA, 0.00, 
            cantidadTotalA, 0,
            idUnidadMedida, unidadMedida,
            'EN', urgencia,  
            now(), p_registro_user_add, "-", now(), "-", "-", 1
		FROM TEMPORAL;   				
        
        UPDATE ORDEN_COMPRA SET 
			estadoRecepcion = 'EN'
		WHERE idOrdenCompra = p_idOrdenCompra;
        
        SELECT CONCAT('CM-', @v_cor) AS 'respuesta', @v_id as 'idCompra';
	END	IF;
    
    IF p_tipoOperacion = 7 THEN  		 
		UPDATE COMPRA SET 
			serieDocumento = p_serieDocumento,
            numeroDocumento = p_numeroDocumento,
            fechaEnvio = p_fechaEmision
		WHERE idCompra = p_idCompra;
        
        UPDATE NOTA_ALMACEN SET fechaEmision = p_fechaEmision, fechaEmisionReal = p_fechaEmision  
        WHERE idCompra = p_idCompra;
        
        SELECT 1 as tipoRespuesta, 'Se editó correctamente la Compra.' AS 'respuesta';
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateContacto` (IN `p_idContacto` INT, IN `p_idProveedor` INT, IN `p_nombre` VARCHAR(300), IN `p_apePaterno` VARCHAR(300), IN `p_apeMaterno` VARCHAR(300), IN `p_celular` VARCHAR(12), IN `p_email` VARCHAR(300), IN `p_cargo` VARCHAR(50), IN `p_comentario` VARCHAR(300), IN `p_calificacion` VARCHAR(300), IN `p_usuario` VARCHAR(50), IN `p_activo` INT)  BEGIN
	IF p_idContacto = 0 THEN
		INSERT INTO CONTACTO (idProveedor,nombre,apePaterno, apeMaterno, cargo, dni, telefono, comentario, calificacion,
			email, fechaRegistro, usuarioRegistro, pcRegistro, activo)
		VALUES ( p_idProveedor, p_nombre, p_apePaterno, p_apeMaterno, p_cargo, '', p_celular, p_comentario, p_calificacion,
			p_email, 
            NOW(), p_usuario, '', 1);
            
		SELECT 1 as tipoRespuesta, 'El contacto se registró correctamente' as respuesta, last_insert_id() as idContacto;
    ELSE
		UPDATE CONTACTO
        SET 
			idProveedor = p_idProveedor, nombre = p_nombre, apePaterno = p_apePaterno, apeMaterno = p_apeMaterno, 
            cargo = p_cargo, telefono = p_celular, comentario = p_comentario, calificacion = p_calificacion, 
			email = p_email, 
            usuarioEdicion = p_usuario, fechaEdicion = NOW(), pcEdicion = '-',
            activo = p_activo
		WHERE idContacto = p_idContacto;
            
        SELECT 1 as tipoRespuesta, 'El contacto se editó correctamente' as respuesta, p_idContacto as idContacto;
	END IF;   
    
    
    -- SELECT  CONCAT(COLUMN_NAME, ','), COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, IS_NULLABLE, COLUMN_DEFAULT
	-- FROM INFORMATION_SCHEMA.COLUMNS	  WHERE table_name = 'contacto'  AND table_schema = 'erp_targox';
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateContactoCliente` (IN `p_idContacto` INT, IN `p_idCliente` INT, IN `p_dni` VARCHAR(300), IN `p_nombre` VARCHAR(300), IN `p_apepaterno` VARCHAR(300), IN `p_apematerno` VARCHAR(300), IN `p_cargo` VARCHAR(50), IN `p_celular` VARCHAR(12), IN `p_email` VARCHAR(300), IN `p_usuario` VARCHAR(50), IN `p_activo` INT)  BEGIN

IF p_idContacto = 0 or p_idContacto is null or p_idContacto = '' then 
  INSERT INTO CLIENTE_CONTACTO
              ( 
                          idCliente, 
                          nombre, 
                          apepaterno, 
                          apematerno, 
                          cargo, 
                          dni, 
                          telefono, 
                          email,
                          fecharegistro, 
                          usuarioregistro, 
                          pcregistro, 
                          fechaEdicion,
                          usuarioEdicion,
                          pcEdicion,
                          activo 
              ) 
              VALUES 
              ( 
                          p_idCliente, 
                          p_nombre, 
                          p_apepaterno, 
                          p_apematerno, 
                          p_cargo, 
                          p_dni, 
                          p_celular, 
                          p_email, 
                          now(), 
                          p_usuario, 
                          @@hostname,
                          now(), 
                          p_usuario, 
                          @@hostname,
                          p_activo
              );
		SELECT 	1                                        AS tipoRespuesta, 
				'El contacto se registró correctamente' AS respuesta, 
				Last_insert_id()                         AS idContacto;
ELSE
	UPDATE 	CLIENTE_CONTACTO 
	SET    	nombre = p_nombre, 
			apepaterno = p_apepaterno, 
			apematerno = p_apematerno, 
			cargo = p_cargo, 
			dni = p_dni, 
			telefono = p_celular, 
			email = p_email,
			fechaEdicion = NOW(),
			usuarioEdicion = p_usuario,
			pcEdicion = @@hostname,
			activo = p_activo
  WHERE  	idClienteContacto = p_idContacto;
	
    SELECT 	1                                     AS tipoRespuesta,
			'El contacto se editó correctamente' AS respuesta, 
			p_idcontacto                          AS idContacto;
END IF; 

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCotizacion` (IN `p_idCotizacion` INT, IN `p_idGrupoCotizacion` INT, IN `p_codCotizacion` VARCHAR(50), IN `p_fechaAceptada` DATETIME, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);    
    
    DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    DECLARE v_nombreProveedor varchar(300);
    DECLARE v_rucProveedor char(11);
    DECLARE v_direccionProveedor varchar(250);
    DECLARE v_telefonoProveedor varchar(12);
    DECLARE v_emailProveedor varchar(50);
    
    DECLARE subtotal	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_cor 		char(8);
    DECLARE v_idOrdenMantenimiento	INT;
    DECLARE v_idOrdenServicio 		INT;
    
	IF p_tipoOperacion = 1 THEN  		IF EXISTS (SELECT * FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion
								AND idProveedorC = 0) THEN
			SELECT 0 AS 'respuesta';
        ELSE
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT DG.*, GC.idOrdenMantenimiento, GC.idOrdenServicio
			FROM DETALLE_GRUPOCOTIZACION DG
            INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DG.idGrupoCotizacion
			WHERE GC.idGrupoCotizacion = p_idGrupoCotizacion
			ORDER BY idDetalleGrupo ASC;
			
			SET @nProveedor = (SELECT COUNT( DISTINCT( idProveedorC)) FROM TEMPORAL );
			
			IF @nProveedor = null THEN
				SET @nProveedor = 0;
			END IF;
		
			WHILE @nProveedor > 0 DO
				SET @v_idProveedor = ( SELECT idProveedorC FROM TEMPORAL LIMIT 1);
                SET @v_idOrdenMantenimiento = ( SELECT idOrdenMantenimiento FROM TEMPORAL LIMIT 1);
                SET @v_idOrdenServicio = ( SELECT idOrdenServicio FROM TEMPORAL LIMIT 1);
				SET @v_nombreProveedor = (SELECT nombreEmpresa FROM PROVEEDOR WHERE idProveedor = @v_idProveedor);
				SET @v_rucProveedor = (SELECT ruc FROM PROVEEDOR WHERE idProveedor = @v_idProveedor);
				SET @v_direccionProveedor = (SELECT direccion FROM PROVEEDOR WHERE idProveedor = @v_idProveedor);
				SET @v_telefonoProveedor = (SELECT telefono1 FROM PROVEEDOR WHERE idProveedor = @v_idProveedor);
				SET @v_emailProveedor = (SELECT email FROM PROVEEDOR WHERE idProveedor = @v_idProveedor);
				
				SET @total = (SELECT SUM(monto) FROM TEMPORAL WHERE idProveedorC = @v_idProveedor);
				SET @v_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
				SET @subtotal = CONVERT(@total/(1 + (@v_igv/100)), DECIMAL(18,2));
				
				
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM COTIZACION WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);                
                
                SET @v_id = (IFNULL((SELECT idCotizacion FROM COTIZACION ORDER BY idCotizacion DESC LIMIT 1), 0) + 1);
								INSERT INTO `COTIZACION`(
						 idGrupoCotizacion, idOrdenMantenimiento, idOrdenServicio, 
                         idProveedor, nombreProveedor, rucProveedor,
						 direccionProveedor, telefonoProveedor, emailProveedor, 
						 correlativo, codCotizacion,
						subTotal, descuento, igv, igv2, total,
						fechaEnvio, fechaAceptada, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)   
				VALUES ( p_idGrupoCotizacion, @v_idOrdenMantenimiento, @v_idOrdenServicio, 
						@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, 
						@v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor,
						@v_cor, '',
						@subtotal, 0.00, @v_igv, @total - @subtotal, @total, 
						now(), null, 'EN', now(), p_registro_user_add, "-", 
						now(), "-", "-", 1);
					
							
				INSERT INTO `DETALLE_COTIZACION`(
					idCotizacion,  idProducto, nombreProducto, idPresentacion, nombrePresentacion,
					valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
					`cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`, 
					valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, `monto`, `montoA`, 
                    cantidadTotal, cantidadTotalA, 
					idUnidadMedida, unidadMedida, urgencia, estado,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
				)         
				SELECT @v_id, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
						0.00, 0.00, 0.00, 0.00, precioUnitario, 0.00, 
						cantidad, 0, 0, 0, 
                        0.00, 0.00, 0.00, 0.00, monto, 0.00, 
                        cantidadTotal, 0, 
						idUnidadMedida, unidadMedida, urgencia, 'EN', 
						now(), p_registro_user_add, "-", now(), "-", "-", 1
				FROM TEMPORAL
				WHERE idProveedorC = @v_idProveedor;    
				   
					
				DELETE FROM TEMPORAL WHERE idProveedorC = @v_idProveedor;
				
				SET @nProveedor = @nProveedor - 1;
			END WHILE;  
			
			
			SET @v_cor = (SELECT correlativo FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
			
			IF @v_cor = '' THEN
                
                SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM GRUPO_COTIZACION WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
			  
				UPDATE `GRUPO_COTIZACION` SET 
									`correlativo` = @v_cor,
									`registro_fecha_update` = now(),
									`registro_user_update` = p_registro_user_update, 
									`registro_pc_update` = '-'
				WHERE idGrupoCotizacion = p_idGrupoCotizacion;
			END IF;		
			
			UPDATE GRUPO_COTIZACION SET 
				fechaEnvio = now(),
				estado = 'EN'
			WHERE idGrupoCotizacion = p_idGrupoCotizacion;
			
			SELECT @v_cor AS 'respuesta';
		END	IF;
        
    END	IF; 
        
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM COTIZACION WHERE correlativo = p_correlativo and idCotizacion != p_idCotizacion);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			UPDATE `COTIZACION` SET 
							`idProveedor` = p_idProveedor, 
														`subTotal` = p_subTotal,
							`igv` = p_igv,
							`total` = p_total,
							`fechaEnvio` = STR_TO_DATE(p_fechaEnvio, '%c/%e/%Y'),
							`fechaAceptada` = STR_TO_DATE(fechaAceptada, '%c/%e/%Y'),
							`estado` = p_estado,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idCotizacion = p_idCotizacion;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 		 
		UPDATE `COTIZACION` SET 
			`fechaAceptada` = now(), codCotizacion = p_codCotizacion, `estado` = 'AR',
			`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
			`registro_pc_update` = '-'
		WHERE idCotizacion = p_idCotizacion;	            
			           
		SELECT 'Se archivó correctamente.' AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 4 THEN	 		
		IF EXISTS(SELECT idOrdenCompra FROM ORDEN_COMPRA WHERE idCotizacion = p_idCotizacion)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Cotización ya tiene una Orden de Compra generada.' as respuesta;
        ELSE	 
			UPDATE `COTIZACION` SET 
				`fechaAceptada` = now(), codCotizacion = p_codCotizacion, estado = 'AN',
				`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-'
			WHERE idCotizacion = p_idCotizacion;	            
						   
			SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';            
        END IF;
	END IF;
    
    IF p_tipoOperacion = 5 THEN  	
		IF EXISTS(SELECT idOrdenCompra FROM ORDEN_COMPRA WHERE idCotizacion = p_idCotizacion)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Cotización ya tiene una Orden de Compra generada.' as respuesta;
        ELSE
			UPDATE `COTIZACION` SET 
				estado = 'AN',
				`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-'
			WHERE idCotizacion = p_idCotizacion;	            
						   
			SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
		END IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCronogramaPago` (IN `p_idCronograma` INT, IN `p_idDocumentoVenta` INT, IN `p_cuota` INT, IN `p_capital_cuota` DECIMAL(18,6), IN `p_interes_cuota` DECIMAL(18,6), IN `p_importe_cuota` DECIMAL(18,6), IN `p_fecha_pago_cuota` TIMESTAMP, IN `p_usuarioRegistro` VARCHAR(50))  BEGIN 

	IF p_idCronograma IS NULL OR p_idCronograma = 0
		THEN
        
			INSERT INTO CRONOGRAMA_PAGO_VENTA(	
												documento_venta_id,
                                                cuota,
                                                capital_cuota,
                                                interes_cuota,
                                                importe_cuota,
                                                fecha_pago_cuota,
                                                fecha_registro,
                                                usuario_registro,
                                                pc_registro,
                                                fecha_edicion,
                                                usuario_edicion,
                                                pc_edicion,
                                                activo
												)
										VALUES	(
												p_idDocumentoVenta,
                                                p_cuota,
                                                p_capital_cuota,
                                                p_interes_cuota,
                                                p_importe_cuota,
                                                p_fecha_pago_cuota,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												1
												);
			SELECT	1 AS tipoRespuesta,
					'EL cronograma se regitró correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
        
        END IF;
    
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaCotizacion` (IN `p_idDetalleCotizacion` INT, IN `p_idProducto` INT, IN `p_idCotizacion` INT, IN `p_idPresentacion` INT, IN `p_idProveedor` INT, IN `p_valorUnitario` DECIMAL(18,2), IN `p_descuentoUnitario` DECIMAL(18,2), IN `p_precioUnitario` DECIMAL(18,2), IN `p_cantidad` DECIMAL(18,2), IN `p_valorVenta` DECIMAL(18,2), IN `p_descuentoTotal` DECIMAL(18,2), IN `p_monto` DECIMAL(18,2), IN `p_cantidadTotal` DECIMAL(18,2), IN `p_estado` CHAR(5), IN `p_urgencia` CHAR(5), IN `p_activo` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert 		int;  
    DECLARE contadorUpdate 		int;
    DECLARE subtotal			decimal(18,2);
    DECLARE descuento			decimal(18,2);
	DECLARE d_igv				decimal(18,2);    
    DECLARE TOTAL				decimal(18,2);
    DECLARE d_cantidad	int;
    DECLARE v_tasaCambio	    decimal(18,3);
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM DETALLE_OFERTA WHERE idOferta = p_idOferta
										AND idProducto = p_idProducto);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `DETALLE_OFERTA`(
							`idOferta`,
							`idProducto`, 
                            `precio`, 
                            `precioUnitario`, 
                            `cantidad`, 
                            `monto`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`
			) 
			VALUES (	
						p_idOferta,
						p_idProducto,
                        p_precio,
                        p_precioUnitario,
                        p_cantidad,
                        p_monto,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-"
			);
            
            SET @subtotal = (SELECT SUM(monto) FROM detalle_oferta WHERE idOferta = p_idOferta);
            SET @d_igv = (SELECT igv FROM OFERTA WHERE idOferta = p_idOferta);
            SET @total = @subtotal + @subtotal * (@d_igv/100);
			
			UPDATE oferta SET 
				subtotal = @subtotal,
                total = CONVERT(@total, DECIMAL(18,2))
			WHERE idOferta = p_idOferta;     
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN    		
		SET @d_cantidad = ( SELECT cantidad FROM PRESENTACION WHERE idPresentacion = (
								SELECT idPresentacion FROM DETALLE_COTIZACION 	
									WHERE idDetalleCotizacion = p_idDetalleCotizacion ));
                                    
		SET @v_tasaCambio = (	SELECT precioVenta FROM TASA_CAMBIO 
                                    WHERE FECHA = str_to_date ((SELECT case when fechaEnvio = '1900-01-01' then curdate() 
														else fechaEnvio  end
													FROM COTIZACION WHERE idCotizacion = p_idCotizacion), '%Y-%m-%d') LIMIT 1
		);        
        
        
		UPDATE `DETALLE_COTIZACION` SET
			dolar = p_dolar,                        
            precioDolar = (case when p_dolar = 1 then p_precioUnitario else null end),
						precioUnitarioA = (case when p_dolar = 1 then p_precioUnitario*@v_tasaCambio else p_precioUnitario end),
            `cantidadAceptada` = cantidadAceptada + p_cantidad, 
            `montoA` = cantidadAceptada * (case when p_dolar = 1 then p_precioUnitario*@v_tasaCambio else p_precioUnitario end),
			`cantidadTotalA` = (cantidadAceptada) * @d_cantidad, 
			`estado` = p_estado,
			`registro_fecha_update` = now(),
			`registro_user_update` = p_registro_user_update, 
			`registro_pc_update` = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;	
            
		SET @total = (SELECT SUM(montoA) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
		SET @d_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
		
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
                                    
					
		UPDATE COTIZACION SET 
			subtotal = @subtotal,
			igv2 = @total - @subtotal,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
            
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 3 THEN    				UPDATE `DETALLE_COTIZACION` SET
			dolar = p_dolar,                        
            precioDolar = (case when p_dolar = 1 then p_precioUnitario else null end),
            			precioUnitarioA = (case when p_dolar = 1 then p_precioUnitario*@v_tasaCambio else p_precioUnitario end),
            `cantidadRechazada` = cantidadRechazada + p_cantidad, 
            `montoA` = cantidad * (case when p_dolar = 1 then p_precioUnitario*@v_tasaCambio else p_precioUnitario end),
			          
            
		                            `estado` = p_estado,
			registro_fecha_update = now(),
			`registro_user_update` = p_registro_user_update, 
			`registro_pc_update` = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;
        
        SET @total = (SELECT SUM(montoA) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
		SET @d_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
		
        UPDATE COTIZACION SET 
			subtotal = @subtotal,
			igv2 = @total - @subtotal,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
	IF p_tipoOperacion = 4 THEN    		
		UPDATE `DETALLE_COTIZACION` SET
                        `cantidadRechazada` = cantidadRechazada + p_cantidad, 
                        `estado` = p_estado,
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;	
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
		
        SET @total = (SELECT SUM(montoA) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
		SET @d_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
		
        UPDATE COTIZACION SET 
			subtotal = @subtotal,
			igv2 = @total - @subtotal,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
	IF p_tipoOperacion = 5 THEN    			UPDATE `DETALLE_COTIZACION` SET
						valorUnitarioA = 0.00,
						descuentoUnitarioA = 0.00,
						precioUnitarioA = 0.00,
						cantidadAceptada = 0,
						cantidadReenviada = 0,
						cantidadRechazada = 0,
                        valorVentaA = 0.00,
                        descuentoTotalA = 0.00,
                        montoA = 0.00, 
                        montoR = 0.00,
                        `cantidadTotalA` = 0,
                        `estado` = 'EN',
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;	
                        
        SET @total = (SELECT SUM(montoA + montoR) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = (SELECT SUM(valorUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @descuento = (SELECT SUM(descuentoUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
		
        UPDATE COTIZACION SET 
			subtotal = @subtotal,
            descuento = @descuento,
			igv2 = @total - @subtotal + @descuento,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 6 THEN    			SET @d_cantidad = ( SELECT cantidad FROM PRESENTACION WHERE idPresentacion = (
								SELECT idPresentacion FROM DETALLE_COTIZACION 	
									WHERE idDetalleCotizacion = p_idDetalleCotizacion ));
               
        
        
		UPDATE `DETALLE_COTIZACION` SET
			valorUnitarioA = p_valorUnitario,
            descuentoUnitarioA = p_descuentoUnitario,
            precioUnitarioA = p_precioUnitario,            
            cantidadAceptada = p_cantidad,
            cantidadRechazada = cantidad - p_cantidad,
            valorVentaA = p_valorVenta,
            descuentoTotalA = p_descuentoTotal,
            montoA = cantidadAceptada * p_precioUnitario,
            montoR = cantidadRechazada *  p_precioUnitario,
			cantidadTotalA = (cantidadAceptada) * @d_cantidad,
			`estado` = 'C',
			`registro_fecha_update` = now(),
			`registro_user_update` = p_registro_user_update, 
			`registro_pc_update` = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;
        
        SET @total = (SELECT SUM(montoA + montoR) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = (SELECT SUM(valorUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @descuento = (SELECT SUM(descuentoUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
		                
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
		
        UPDATE COTIZACION SET 
			subtotal = @subtotal,
            descuento = @descuento,
			igv2 = @total - @subtotal + @descuento,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 7 THEN    			SET @d_cantidad = ( SELECT cantidad FROM PRESENTACION WHERE idPresentacion = (
								SELECT idPresentacion FROM DETALLE_COTIZACION 	
									WHERE idDetalleCotizacion = p_idDetalleCotizacion ));
             
		UPDATE DETALLE_COTIZACION SET
			valorUnitarioA = p_valorUnitario,
            descuentoUnitarioA = p_descuentoUnitario,
            precioUnitarioA = p_precioUnitario,
            cantidadAceptada = cantidad - p_cantidad,
            cantidadRechazada = p_cantidad,
            valorVentaA = p_valorVenta,
            descuentoTotalA = p_descuentoTotal,
            montoA = cantidadAceptada * p_precioUnitario,
            montoR = cantidadRechazada * p_precioUnitario,
			cantidadTotalA = (cantidadAceptada) * @d_cantidad,
					
			estado = 'C',
			registro_fecha_update = now(),
			registro_user_update = p_registro_user_update, 
			registro_pc_update = '-'
		WHERE idDetalleCotizacion = p_idDetalleCotizacion;
        
        		                
        SET @total = (SELECT SUM(montoA + montoR) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @subtotal = (SELECT SUM(valorUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
        SET @descuento = (SELECT SUM(descuentoUnitarioA * cantidad) FROM DETALLE_COTIZACION WHERE idCotizacion = p_idCotizacion);
		
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleCotizacion) FROM DETALLE_COTIZACION WHERE
									idCotizacion = p_idCotizacion AND estado != 'C');
		
        UPDATE COTIZACION SET 
			subtotal = @subtotal,
            descuento = @descuento,
			igv2 = @total - @subtotal + @descuento,
			total = CONVERT(@total, DECIMAL(18,2)),
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idCotizacion = p_idCotizacion;
        
		SELECT 1 AS 'respuesta';
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaGrupoCotizacion` (IN `p_idDetalleGrupo` INT, IN `p_idGrupoCotizacion` INT, IN `p_idProducto` INT, IN `p_nombreProducto` VARCHAR(300), IN `p_idPresentacion` INT, IN `p_nombrePresentacion` VARCHAR(400), IN `p_idProveedorR` INT, IN `p_nombreProveedorR` VARCHAR(300), IN `p_idProveedorC` INT, IN `p_nombreProveedorC` VARCHAR(300), IN `p_precioUnitario` DECIMAL(18,2), IN `p_cantidad` DECIMAL(18,2), IN `p_monto` DECIMAL(18,2), IN `p_cantidadTotal` DECIMAL(18,2), IN `p_idUnidadMedida` CHAR(5), IN `p_unidadMedida` VARCHAR(300), IN `p_urgencia` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE TOTAL		decimal(18,2);
    DECLARE v_id 		INT;
    
	IF p_tipoOperacion = 1 THEN 
		IF EXISTS (SELECT * FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion
								AND idProducto = p_idProducto AND idPresentacion = p_idPresentacion) THEN
			SELECT 0 AS 'respuesta';
		ELSE             
			SET p_unidadMedida = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 3 and abrev = p_idUnidadMedida);
                        
			INSERT INTO `DETALLE_GRUPOCOTIZACION`(
				`idGrupoCotizacion`, `idProducto`, nombreProducto, `idPresentacion`, nombrePresentacion,
                `idProveedorR`, nombreProveedorR, `idProveedorC`, nombreProveedorC,
				`precioUnitario`, `cantidad`, `monto`, `cantidadTotal`, 
                idUnidadMedida, unidadMedida, `urgencia`, 
				`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
                `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (	
				p_idGrupoCotizacion, p_idProducto, p_nombreProducto, p_idPresentacion, p_nombrePresentacion,
                p_idProveedorR, p_nombreProveedorR, p_idProveedorC, p_nombreProveedorC,
				p_precioUnitario, p_cantidad, p_monto, p_cantidadTotal, 
                p_idUnidadMedida, p_unidadMedida, p_urgencia,
				now(), p_registro_user_add, "-",
				now(), "-", "-", 1
			);
            
            SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @d_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
			UPDATE GRUPO_COTIZACION SET
                subtotal = @subtotal,
				total = @total,
                igv2 = @total - @subtotal
			WHERE idGrupoCotizacion = p_idGrupoCotizacion;     
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion 
										AND idProducto = p_idProducto and idDetalleGrupo != p_idDetalleGrupo);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `DETALLE_GRUPOCOTIZACION` SET
                            `idProveedorC` = p_idProveedorC,
                            `nombreProveedorC` = p_nombreProveedorC,
                            `cantidad` = p_cantidad, 
                            `monto` = p_monto,
                            `cantidadTotal` = p_cantidadTotal,
                            `urgencia` = p_urgencia,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-'
			WHERE idDetalleGrupo = p_idDetalleGrupo;	
            
			SET @v_id = (SELECT idGrupoCotizacion FROM DETALLE_GRUPOCOTIZACION WHERE idDetalleGrupo = p_idDetalleGrupo);
            SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = @v_id);
            SET @d_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = @v_id);
            SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
			UPDATE GRUPO_COTIZACION SET
                subtotal = @subtotal,
				total = @total,
                igv2 = @total - @subtotal
			WHERE idGrupoCotizacion = @v_id;
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
        
		IF EXISTS (SELECT * FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion
								AND idProducto = p_idProducto AND idPresentacion = p_idPresentacion) THEN
			SELECT 0 AS 'respuesta';
		ELSE               
			
            SET p_unidadMedida = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 3 and abrev = p_idUnidadMedida);
            SET p_cantidadTotal = p_cantidad * (SELECT cantidad FROM PRESENTACION WHERE idPresentacion = p_idPresentacion);
            
			INSERT INTO `DETALLE_GRUPOCOTIZACION`(
				`idGrupoCotizacion`, `idProducto`, nombreProducto, `idPresentacion`, nombrePresentacion,
                `idProveedorR`, nombreProveedorR, `idProveedorC`, nombreProveedorC,
				`precioUnitario`, `cantidad`, `monto`, `cantidadTotal`, 
                idUnidadMedida, unidadMedida, `urgencia`, 
				`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
                `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (	
				p_idGrupoCotizacion, p_idProducto, p_nombreProducto, p_idPresentacion, p_nombrePresentacion,
                p_idProveedorR, p_nombreProveedorR, p_idProveedorC, p_nombreProveedorC,
				p_precioUnitario, p_cantidad, p_monto, p_cantidadTotal, 
                p_idUnidadMedida, p_unidadMedida, p_urgencia,
				now(), p_registro_user_add, "-",
				now(), "-", "-", 1
			);
            
            SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @d_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = p_idGrupoCotizacion);
            SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
			UPDATE GRUPO_COTIZACION SET
                subtotal = @subtotal,
				total = @total,
                igv2 = @total - @subtotal
			WHERE idGrupoCotizacion = p_idGrupoCotizacion;     
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaGrupoOrden` (IN `p_idDetalleGrupo` INT, IN `p_idProducto` INT, IN `p_idGrupoOrden` INT, IN `p_idPresentacion` INT, IN `p_idProveedorR` INT, IN `p_idProveedorC` INT, IN `p_precioUnitario` DECIMAL(18,2), IN `p_cantidad` DECIMAL(18,2), IN `p_monto` DECIMAL(18,2), IN `p_cantidadTotal` DECIMAL(18,2), IN `p_urgencia` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE TOTAL		decimal(18,2);
    DECLARE v_id 		INT;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM DETALLE_GRUPO WHERE idGrupoOrden = p_idGrupoOrden
										AND idProducto = p_idProducto AND idPresentacion = p_idPresentacion);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `DETALLE_GRUPO`(
							`idProducto`, 
                            `idGrupoOrden`,
                            `idPresentacion`,
                            `idProveedorR`,
                            `idProveedorC`,
                            `precioUnitario`, 
                            `cantidad`,
                            `monto`,                             
                            `cantidadTotal`,
                            `urgencia`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
                            `activo`
			) 
			VALUES (	
						p_idProducto,
                        p_idGrupoOrden,
                        p_idPresentacion,
                        p_idProveedorR,
                        p_idProveedorC,
                        p_precioUnitario,
                        p_cantidad,
                        p_monto,
                        p_cantidadTotal,
                        p_urgencia,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
                        1
			);
            
            SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPO WHERE idGrupoOrden = p_idGrupoOrden);
            SET @d_igv = (SELECT igv FROM GRUPO_ORDENCOMPRA WHERE idGrupoOrden = p_idGrupoOrden);
            SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
			UPDATE GRUPO_ORDENCOMPRA SET
                subtotal = @subtotal,
				total = @total,
                igv2 = @total - @subtotal
			WHERE idGrupoOrden = p_idGrupoOrden;     
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM DETALLE_GRUPO WHERE idGrupoOrden = p_idGrupoOrden 
										AND idProducto = p_idProducto and idDetalleGrupo != p_idDetalleGrupo);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `DETALLE_GRUPO` SET
                            `idProveedorC` = p_idProveedorC,
                            `cantidad` = p_cantidad, 
                            `monto` = p_monto,
                            `cantidadTotal` = p_cantidadTotal,
                            `urgencia` = p_urgencia,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-'
			WHERE idDetalleGrupo = p_idDetalleGrupo;	
            
			SET @v_id = (SELECT idGrupoOrden FROM DETALLE_GRUPO WHERE idDetalleGrupo = p_idDetalleGrupo);
            SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPO WHERE idGrupoOrden = @v_id);
            SET @d_igv = (SELECT igv FROM GRUPO_ORDENCOMPRA WHERE idGrupoOrden = @v_id);
            SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
			UPDATE GRUPO_ORDENCOMPRA SET
                subtotal = @subtotal,
				total = @total,
                igv2 = @total - @subtotal
			WHERE idGrupoOrden = @v_id;
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetalleNotaEntrada` (IN `p_idDetalleNotaAlmacen` INT, IN `p_idNotaAlmacen` INT, IN `p_idDetalleOrden` INT, IN `p_idProducto` INT, IN `p_nombreProducto` VARCHAR(300), IN `p_idPresentacion` INT, IN `p_nombrePresentacion` VARCHAR(300), IN `p_valorPresentacion` DECIMAL(18,2), `p_precioPresentacion` DECIMAL(18,2), IN `p_valorUnitario` DECIMAL(18,2), `p_precioUnitario` DECIMAL(18,2), IN `p_cantidad` DECIMAL(18,2), `p_valorVenta` DECIMAL(18,2), `p_monto` DECIMAL(18,2), IN `p_idUnidadMedida` CHAR(5), `p_unidadMedida` VARCHAR(300), `p_estado` CHAR(5), IN `p_usuario` VARCHAR(50), `p_activo` INT)  BEGIN
    DECLARE v_cor char(8);
    DECLARE v_id int;
    DECLARE cantidadPresentacion decimal(18,2);
    DECLARE tasaCambio decimal(18,3);
	SET @cantidadPresentacion = IFNULL( (SELECT cantidad FROM PRESENTACION WHERE idPresentacion = p_idPresentacion), 1);
	SET @tasaCambio = IFNULL( (SELECT OC.tasaCambio FROM ORDEN_COMPRA OC WHERE OC.idOrdenCompra = (SELECT idOrdenCompra FROM DETALLE_ORDEN WHERE idDetalleOrden = p_idDetalleOrden)), 1);
    
    IF p_idDetalleNotaAlmacen = 0 THEN
    
		INSERT INTO DETALLE_NOTA_ALMACEN (
			idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			valorPresentacion, precioPresentacion, 
            valorUnitario, precioUnitario, cantidad, 
			valorVenta, monto, 
            cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add, activo)
		VALUES(
			p_idNotaAlmacen, p_idProducto, p_nombreProducto, case when p_idPresentacion = 0 then null else p_idPresentacion end, p_nombrePresentacion, 
			-- p_valorPresentacion, p_precioPresentacion, p_valorUnitario, p_precioUnitario, p_cantidad,
			p_valorUnitario * @tasaCambio, p_precioUnitario * @tasaCambio, 
            (CASE WHEN p_nombrePresentacion = '-' OR p_nombrePresentacion = '' THEN p_valorUnitario
				ELSE CAST(round(p_valorUnitario/@cantidadPresentacion, 2) AS decimal(18,2))
			END) * @tasaCambio, 
            (CASE WHEN p_nombrePresentacion = '-' THEN p_precioUnitario
				ELSE CAST(round(p_precioUnitario/@cantidadPresentacion, 2) AS decimal(18,2))
			END)* @tasaCambio, 
            p_cantidad,
            p_valorVenta * @tasaCambio, p_monto * @tasaCambio,
            p_cantidad*@cantidadPresentacion, 0.00, p_cantidad*@cantidadPresentacion,
            p_idUnidadMedida, p_unidadMedida, 'A',
            NOW(), p_usuario, '-', 1);
            
		UPDATE DETALLE_ORDEN 
		SET	
			cantidadAceptada = cantidadAceptada + p_cantidad,
            registro_fecha_update = now(),
            registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idDetalleOrden = p_idDetalleOrden;
            
		SELECT 1 as tipoRespuesta, 
			concat('Se registró correctamente el detalle') as 'respuesta';
	ELSE
		UPDATE DETALLE_NOTA_ALMACEN
        SET
			valorUnitario = p_valorUnitario, 
            precioUnitario = p_precioUnitario, 
            cantidad = p_cantidad,
            valorVenta = p_valorVenta, 
            monto = p_monto,
            cantidadTotal = p_cantidad,
			registro_fecha_update = now(),
			registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idDetaNota = p_idDetalleNotaAlmacen;
    
		SELECT 1 as tipoRespuesta, 
			concat('Se registró correctamente el detalle') as 'respuesta';
	END IF;
    
    IF p_estado = 'C' THEN
		UPDATE PRODUCTO  
        SET 
			stockActual = stockActual + (p_cantidad * @cantidadPresentacion),
			registro_fecha_update = now(),
			registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idProducto = p_idProducto;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetalleNotaSalida` (IN `p_idDetalleNotaAlmacen` INT, IN `p_idNotaAlmacen` INT, IN `p_idDetalleOrden` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_idProducto` INT, IN `p_nombreProducto` VARCHAR(300), IN `p_cantidad` DECIMAL(18,2), IN `p_idUnidadMedida` CHAR(5), `p_unidadMedida` VARCHAR(300), `p_estado` CHAR(5), IN `p_usuario` VARCHAR(50), `p_activo` INT)  BEGIN
    DECLARE v_cor char(8);
    DECLARE v_id int;
    
    IF p_idDetalleNotaAlmacen = 0 THEN
    
		INSERT INTO DETALLE_NOTA_ALMACEN (
			idNotaAlmacen, idProducto, nombreProducto, 
			valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
			valorVenta, monto, 
            cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add, activo)
		VALUES(
			p_idNotaAlmacen, p_idProducto, p_nombreProducto,
			0.00, 0.00, 0.00, 0.00, p_cantidad,
            0.00, 0.00,
            p_cantidad, 0.00, 0.00, 
            p_idUnidadMedida, p_unidadMedida, 'A',
            NOW(), p_usuario, '-', 1);
            
		UPDATE DETALLE_ORDEN_MANTENIMIENTO 
		SET	
			cantidadConsumida = cantidadConsumida + p_cantidad,
            registro_fecha_update = now(),
            registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idDetaOrden = p_idDetalleOrden and idOrdenMantenimiento = p_idOrdenMantenimiento;
        
        UPDATE DETALLE_ORDEN_SERVICIO 
		SET	
			cantidadConsumida = cantidadConsumida + p_cantidad,
            registro_fecha_update = now(),
            registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idDetaOrden = p_idDetalleOrden and idOrdenServicio = p_idOrdenServicio;
            
		SELECT 1 as tipoRespuesta, 
			concat('Se registró correctamente el detalle') as 'respuesta';
	ELSE
		UPDATE DETALLE_NOTA_ALMACEN
        SET
			valorUnitario = p_valorUnitario, 
            precioUnitario = p_precioUnitario, 
            cantidad = p_cantidad,
            valorVenta = p_valorVenta, 
            monto = p_monto,
            cantidadTotal = p_cantidad,
			registro_fecha_update = now(),
			registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idDetaNota = p_idDetalleNotaAlmacen;
    
		SELECT 1 as tipoRespuesta, 
			concat('Se registró correctamente el detalle') as 'respuesta';
	END IF;
    
    IF p_estado = 'C' THEN
		UPDATE PRODUCTO  
        SET 
			stockActual = stockActual - p_cantidad,
			registro_fecha_update = now(),
			registro_user_update = p_usuario, 
			registro_pc_add = '-' 
        WHERE idProducto = p_idProducto;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetalleVenta` (IN `p_idDetalle` INT, IN `p_idDocumentoVenta` INT, IN `p_idProducto` INT, IN `p_cantidad` DECIMAL(18,6), IN `p_descuento` DECIMAL(18,6), IN `p_valorUnitario` DECIMAL(18,6), IN `p_precioUnitario` DECIMAL(18,6), IN `p_igv` DECIMAL(18,6), IN `p_valorTotal` DECIMAL(18,6), IN `p_precioTotal` DECIMAL(18,6), IN `p_usuarioRegistro` VARCHAR(50))  BEGIN 

	IF p_idDetalle IS NULL OR p_idDetalle = 0
		THEN
        
			INSERT INTO DETALLE_DOCUMENTO_VENTA(
												documento_venta_id,
                                                producto_id,
                                                cantidad,
                                                descuento,
                                                valor_unitario,
                                                precio_unitario,
                                                igv_unitario,
                                                valor_total,
                                                precio_total,
                                                fecha_registro,
                                                usuario_registro,
                                                pc_registro,
                                                fecha_edicion,
                                                usuario_edicion,
                                                pc_edicion,
                                                activo
												)
										VALUES	(
												p_idDocumentoVenta,
                                                p_idProducto,
                                                p_cantidad,
                                                p_descuento,
                                                p_valorUnitario,
                                                p_precioUnitario,
                                                p_igv,
                                                p_valorTotal,
                                                p_precioTotal,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												NOW(),
												p_usuarioRegistro,
												@@hostname,
												1
												);
			SELECT	1 AS tipoRespuesta,
					'EL detalle se regitró correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
        ELSE
			UPDATE	DETALLE_DOCUMENTO_VENTA
            SET		producto_id = p_idProducto,
					cantidad = p_cantidad,
					descuento = p_descuento,
					valor_unitario = p_valorUnitario,                                                
					precio_unitario = p_precioUnitario,
					igv_unitario = p_igv,
					valor_total = p_valorTotal,
					precio_total = p_precioTotal,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE	id = p_idDetalle;
            
            SELECT	1 AS tipoRespuesta,
					'EL detalle se editó correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
        END IF;
    
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaNotaAlmacen` (IN `p_idDetaNota` INT, IN `p_idNotaAlmacen` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_idDetaOrden` INT, IN `p_idProducto` INT, IN `p_idPresentacion` INT, IN `p_cantidad` DECIMAL(18,2), IN `p_observacion` VARCHAR(50), IN `p_idUnidadMedida` CHAR(5), IN `p_unidadMedida` VARCHAR(300), IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);    
    
    DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    
    DECLARE v_nombreProducto	varchar(300);
    DECLARE v_stockActual 		decimal(18,2);
    
    DECLARE subtotal	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE v_total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_cor 		char(8);
    
    DECLARE v_idDetaNota int;
    DECLARE v_cantidad decimal(18,2);
    
	IF p_tipoOperacion = 1 THEN   		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
        
		INSERT INTO DETALLE_NOTA_ALMACEN ( 
			idNotaAlmacen, idProducto, nombreProducto, 
			valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
			valorVenta, monto, 
            cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT p_idNotaAlmacen, DOM.idProducto, P.nombre, 
			0.00, 0.00, DOM.valorUnitario, DOM.precioUnitario, DOM.cantidad, 
			DOM.valorUnitario * DOM.cantidad, DOM.precioUnitario * DOM.cantidad, 
            DOM.cantidad, 0.00, DOM.cantidad, 
            DOM.idUnidadMedida, DOM.unidadMedida, 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM DETALLE_ORDEN_MANTENIMIENTO DOM 
        INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        where DOM.estado = 'NS' and DOM.idOrdenMantenimiento = p_idOrdenMantenimiento;
                
        SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
        SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
        
        UPDATE PRODUCTO P, DETALLE_NOTA_ALMACEN DNA
		SET P.stockActual = P.stockActual - DNA.cantidadTotal 
		WHERE P.idProducto = DNA.idProducto AND DNA.idNotaAlmacen = p_idNotaAlmacen;

        UPDATE NOTA_ALMACEN
			SET correlativo = @v_cor,
				igv2 = @v_total - @subtotal,
				subTotal = @subtotal,
				total = @v_total
        WHERE idNotaAlmacen = p_idNotaAlmacen;
        
        UPDATE DETALLE_ORDEN_MANTENIMIENTO
			SET estado = 'C'
        WHERE estado = 'NS';

        SELECT 1 AS tipoRespuesta, 'Se creó correctamente la Nota de Salida.' as 'respuesta';
    END	IF;  
    
	IF p_tipoOperacion = 2 THEN 
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
                    
        INSERT INTO DETALLE_NOTA_ALMACEN ( 
			idNotaAlmacen, idProducto, nombreProducto, 
			valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
			valorVenta, monto, 
            cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT p_idNotaAlmacen, DOS.idProducto, P.nombre, 
			0.00, 0.00, DOS.valorUnitario, DOS.precioUnitario, DOS.cantidad, 
			DOS.valorUnitario * DOS.cantidad, DOS.precioUnitario * DOS.cantidad, DOS.cantidad, 0.00, DOS.cantidad, 
            DOS.idUnidadMedida, DOS.unidadMedida, 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM DETALLE_ORDEN_SERVICIO DOS
        INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
        where DOS.estado = 'NS' and DOS.idOrdenServicio = p_idOrdenServicio;
                
                SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
        SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
        
        UPDATE PRODUCTO P, DETALLE_NOTA_ALMACEN DNA
		SET P.stockActual = P.stockActual - DNA.cantidadTotal 
		WHERE P.idProducto = DNA.idProducto AND DNA.idNotaAlmacen = p_idNotaAlmacen;
        
        UPDATE NOTA_ALMACEN
			SET correlativo = @v_cor,
				igv2 = @v_total - @subtotal,
				subTotal = @subtotal,
				total = @v_total
        WHERE idNotaAlmacen = p_idNotaAlmacen;
        
        UPDATE DETALLE_ORDEN_SERVICIO
			SET estado = 'C'
        WHERE estado = 'NS';

        SELECT 1 AS tipoRespuesta, 'Se creó correctamente la Nota de Salida.' as 'respuesta';
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   		
        IF EXISTS(SELECT idProducto FROM DETALLE_NOTA_ALMACEN 
					WHERE idProducto = p_idProducto and idNotaAlmacen = p_idNotaAlmacen) THEN
			
			SELECT 0 AS tipoRespuesta, 'Ya ha seleccionado este producto.' as respuesta;
        ELSE            
            SELECT nombre, stockActual 
			INTO @v_nombreProducto, @v_stockActual
            FROM PRODUCTO WHERE idProducto = p_idProducto;
		            
            IF p_cantidad <= @v_stockActual  THEN
				INSERT INTO DETALLE_NOTA_ALMACEN ( 
					idNotaAlmacen, idProducto, nombreProducto, 
					valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
					valorVenta, monto, 
					cantidadTotal, cantidadUsada, cantidadSaldo, 
					idUnidadMedida, unidadMedida, estado, observacion,
					registro_fecha_add, registro_user_add, registro_pc_add,
					registro_fecha_update, registro_user_update, registro_pc_update, activo)
				values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
				0.00, 0.00,0.00, 0.00, p_cantidad,
				0.00, 0.00,
				p_cantidad, 0.00, p_cantidad,
				p_idUnidadMedida, p_unidadMedida, 'A', p_observacion,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1);
			
				            ELSE
				IF @v_stockActual = 0 THEN
					INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, p_cantidad,
					0.00, 0.00,
					p_cantidad, 0.00, p_cantidad,
					p_idUnidadMedida, p_unidadMedida, 'PC', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);                
                ELSE
					INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, @v_stockActual,
					0.00, 0.00,
					@v_stockActual, 0.00, @v_stockActual,
					p_idUnidadMedida, p_unidadMedida, 'A', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);  
                    
                    INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, p_cantidad - @v_stockActual,
					0.00, 0.00,
					p_cantidad - @v_stockActual, 0.00, p_cantidad - @v_stockActual,
					p_idUnidadMedida, p_unidadMedida, 'PC', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);  
					
                
                END IF;
                
                            END IF;
            
						SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
			SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen);
			
			UPDATE NOTA_ALMACEN
				SET correlativo = @v_cor,
					igv2 = @v_total - @subtotal,
					subTotal = @subtotal,
					total = @v_total
			WHERE idNotaAlmacen = p_idNotaAlmacen;
            
			SELECT 1 AS tipoRespuesta, 'El producto se añadió correctamente.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 4 THEN   		
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
		CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO
		SELECT DNA.idProducto, 	DNA.observacion, DNA.nombreProducto,
			SUM(case when DNA.estado = 'PC' then DNA.cantidad else 0.00 end) as cantidadPC,
			SUM(case when DNA.estado = 'A' then DNA.cantidad else 0.00 end) as cantidadA, 
		    DNA.idUnidadMedida, DNA.unidadMedida
        FROM DETALLE_NOTA_ALMACEN DNA
        WHERE DNA.idNotaAlmacen = p_idNotaAlmacen
        GROUP BY DNA.idProducto
        ORDER BY DNA.idProducto ASC;
        
        SET @nFilasProducto = (SELECT count(idProducto) FROM TEMPORAL_PRODUCTO);
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
                
        WHILE @nFilasProducto > 0 DO
			
            SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET @v_nombreProducto = (SELECT nombreProducto FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
			SET p_cantidad = (SELECT cantidadPC FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET @v_cantidad = (SELECT cantidadA FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET p_observacion = (SELECT observacion FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET p_idUnidadMedida = (SELECT idUnidadMedida FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET p_unidadMedida = (SELECT unidadMedida FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            
            SET @cantidadProducto = (SELECT stockActual FROM PRODUCTO WHERE idProducto = p_idProducto);
            
                        
			IF	p_cantidad <= @cantidadProducto THEN
				IF p_cantidad > 0 THEN
					DELETE FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and idProducto = p_idProducto;
					
					INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, @v_cantidad + p_cantidad,
					0.00, 0.00,
					@v_cantidad + p_cantidad, 0.00, @v_cantidad + p_cantidad,
					p_idUnidadMedida, p_unidadMedida, 'A', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);
					
			END IF;
			ELSE
				IF @cantidadProducto > 0 THEN					
					DELETE FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and idProducto = p_idProducto;
                    
                    INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, @v_cantidad + @cantidadProducto,
					0.00, 0.00,
					@v_cantidad + @cantidadProducto, 0.00, @v_cantidad + @cantidadProducto,
					p_idUnidadMedida, p_unidadMedida, 'A', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);


                    INSERT INTO DETALLE_NOTA_ALMACEN ( 
						idNotaAlmacen, idProducto, nombreProducto, 
						valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
						valorVenta, monto, 
						cantidadTotal, cantidadUsada, cantidadSaldo, 
						idUnidadMedida, unidadMedida, estado, observacion,
						registro_fecha_add, registro_user_add, registro_pc_add,
						registro_fecha_update, registro_user_update, registro_pc_update, activo)
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, p_cantidad - @cantidadProducto,
					0.00, 0.00,
					p_cantidad - @cantidadProducto, 0.00, p_cantidad - @cantidadProducto,
					p_idUnidadMedida, p_unidadMedida, 'PC', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);
				END IF;
			END IF;
            
            DELETE FROM TEMPORAL_PRODUCTO WHERE idProducto = p_idProducto;
            
			SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;
		
        SELECT 1 AS tipoRespuesta, '1' AS 'respuesta', p_cantidad;
    END	IF;
    
    IF p_tipoOperacion = 5 THEN   		
		IF EXISTS (SELECT * FROM DETALLE_NOTA_ALMACEN 
				WHERE idNotaAlmacen = p_idNotaAlmacen and estado = 'PC') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Nota de Salida.' as respuesta;
		ELSE
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
			CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO
			SELECT DNA.idDetaNota, DNA.idProducto, DNA.nombreProducto, DNA.cantidadTotal, DNA.observacion
			FROM DETALLE_NOTA_ALMACEN DNA
			WHERE DNA.idNotaAlmacen = p_idNotaAlmacen and DNA.estado = 'A'
			ORDER BY DNA.idDetaNota ASC;
            
			SET @nFilasProducto = (SELECT count(idDetaNota) FROM TEMPORAL_PRODUCTO);        
			
			IF @nFilasProducto = null THEN
					SET @nFilasProducto = 0;
			END IF;
            
			WHILE @nFilasProducto > 0 DO
				SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaNota ASC LIMIT 1);
				SET @v_nombreProducto = (SELECT nombreProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaNota ASC LIMIT 1);
				SET p_cantidad = (SELECT cantidadTotal FROM TEMPORAL_PRODUCTO ORDER BY idDetaNota ASC LIMIT 1);
				SET p_idDetaNota = (SELECT idDetaNota FROM TEMPORAL_PRODUCTO ORDER BY idDetaNota ASC LIMIT 1);
				SET p_observacion = (SELECT observacion FROM TEMPORAL_PRODUCTO ORDER BY idDetaNota ASC LIMIT 1);
                
                DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
				CREATE TEMPORARY TABLE TEMPORAL
				SELECT
					DN.idDetaNota, DN.idNotaAlmacen,
					NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
					 DN.idProducto, DN.nombreProducto,
					DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
					DN.idUnidadMedida, DN.unidadMedida, DN.observacion
				FROM detalle_nota_almacen DN 
				INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
				INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
				LEFT JOIN COMPRA C ON C.idCompra = NA.idCompra
				where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
				ORDER BY NA.fechaEmision ASC;
                
				SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
				
				IF @nFilas = null THEN
					SET @nFilas = 0;
				END IF;
				
				WHILE @nFilas > 0 and p_cantidad > 0 DO
					SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
					SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
                                        
                    IF p_cantidad >= @v_cantidad THEN
						 INSERT INTO DETALLE_NOTA_ALMACEN ( 
							idNotaAlmacen, idProducto, nombreProducto, 
							valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
							valorVenta, monto, 
							cantidadTotal, cantidadUsada, cantidadSaldo, 
							idUnidadMedida, unidadMedida, estado, observacion,
							registro_fecha_add, registro_user_add, registro_pc_add,
							registro_fecha_update, registro_user_update, registro_pc_update, activo)                        
                        SELECT p_idNotaAlmacen, idProducto, nombreProducto, 
							0.00, 0.00, valorUnitario, precioUnitario, cantidadSaldo, 
                            cantidadSaldo * valorUnitario, cantidadSaldo * precioUnitario,
                            cantidadSaldo, 0.00, cantidadSaldo,
                            idUnidadMedida, unidadMedida, 'C', p_observacion,
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						SET p_cantidad = p_cantidad - @v_cantidad;
						
                        UPDATE PRODUCTO SET stockActual = stockActual - @v_cantidad WHERE idProducto = p_idProducto;
                        
						UPDATE DETALLE_NOTA_ALMACEN SET
							cantidadUsada = cantidadUsada + @v_cantidad, 
							cantidadSaldo = cantidadSaldo - @v_cantidad
						WHERE idDetaNota = @v_idDetaNota;
					ELSE
						 INSERT INTO DETALLE_NOTA_ALMACEN ( 
							idNotaAlmacen, idProducto, nombreProducto, 
							valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
							valorVenta, monto, 
							cantidadTotal, cantidadUsada, cantidadSaldo, 
							idUnidadMedida, unidadMedida, estado, observacion,
							registro_fecha_add, registro_user_add, registro_pc_add,
							registro_fecha_update, registro_user_update, registro_pc_update, activo)                        
                        SELECT p_idNotaAlmacen, idProducto, nombreProducto, 
							0.00, 0.00, valorUnitario, precioUnitario, p_cantidad, 
                            p_cantidad * valorUnitario, p_cantidad * precioUnitario,
                            p_cantidad, 0.00, p_cantidad,
                            idUnidadMedida, unidadMedida, 'C', p_observacion,
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						UPDATE DETALLE_NOTA_ALMACEN SET 
							cantidadUsada = cantidadUsada + p_cantidad, 
							cantidadSaldo = cantidadSaldo - p_cantidad
						WHERE idDetaNota = @v_idDetaNota;
							
						UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

						SET p_cantidad = 0;
                    END IF;
                    
                    DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
					SET @nFilas = @nFilas - 1;
                    
				END WHILE;  
				
				IF	p_cantidad > 0 THEN
					INSERT INTO DETALLE_NOTA_ALMACEN ( 
							idNotaAlmacen, idProducto, nombreProducto, 
							valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
							valorVenta, monto, 
							cantidadTotal, cantidadUsada, cantidadSaldo, 
							idUnidadMedida, unidadMedida, estado, observacion,
							registro_fecha_add, registro_user_add, registro_pc_add,
							registro_fecha_update, registro_user_update, registro_pc_update, activo)					
					values(p_idNotaAlmacen, p_idProducto, @v_nombreProducto,
					0.00, 0.00,0.00, 0.00, p_cantidad,
					0.00, 0.00,
					p_cantidad, 0.00, p_cantidad,
					p_idUnidadMedida, p_unidadMedida, 'PC', p_observacion,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);                                        
				END IF;
                                
				DELETE FROM DETALLE_NOTA_ALMACEN WHERE idDetaNota = p_idDetaNota;
				DELETE FROM TEMPORAL_PRODUCTO WHERE idDetaNota = p_idDetaNota;				
				SET @nFilasProducto = @nFilasProducto - 1;
			END WHILE;
            

			SELECT  1 as tipoRespuesta, 
					'Se asignaron correctamente los precios.' as respuesta;	
		END	IF;	
    END	IF;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaNotaEntrada` (IN `p_idDetaNota` INT, IN `p_idNotaAlmacen` INT, IN `p_idProducto` INT, IN `p_idPresentacion` INT, IN `p_cantidad` DECIMAL(18,2), IN `p_valorUnitario` DECIMAL(18,2), IN `p_valorVenta` DECIMAL(18,2), IN `p_observacion` VARCHAR(400), IN `p_idUnidadMedida` CHAR(5), IN `p_unidadMedida` VARCHAR(300), IN `p_estado` CHAR(2), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN
		IF EXISTS(SELECT idProducto FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and idProducto = p_idProducto) THEN
			SELECT 0 AS tipoRespuesta, 'El Producto ya ha sido añadido.' as respuesta;
        ELSE
			INSERT INTO DETALLE_NOTA_ALMACEN ( 
				idNotaAlmacen, idProducto, nombreProducto, 
				valorPresentacion, precioPresentacion, valorUnitario, precioUnitario, cantidad, 
				valorVenta, monto, 
				cantidadTotal, cantidadUsada, cantidadSaldo, 
				idUnidadMedida, unidadMedida, observacion, estado,
				registro_fecha_add, registro_user_add, registro_pc_add,
				registro_fecha_update, registro_user_update, registro_pc_update, activo)
			VALUES(
				p_idNotaAlmacen, p_idProducto, (SELECT nombre FROM PRODUCTO WHERE idProducto = p_idProducto),
				0.00, 0.00, p_valorUnitario, 0.00, p_cantidad,
				p_valorVenta, 0.00,
				p_cantidad, 0.00, p_cantidad,
				p_idUnidadMedida, p_unidadMedida, p_observacion, 'A', 
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1);
				
			SELECT 1 AS tipoRespuesta, 'El Producto se añadió correctamente.' as respuesta;
		END IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaOrden` (IN `p_idDetalleOrden` INT, IN `p_idOrdenCompra` INT, IN `p_idProducto` INT, IN `p_nombreProducto` VARCHAR(300), IN `p_idPresentacion` INT, IN `p_nombrePresentacion` VARCHAR(400), IN `p_valorUnitario` DECIMAL(18,2), IN `p_descuentoUnitario` DECIMAL(18,2), IN `p_precioUnitario` DECIMAL(18,2), IN `p_cantidad` DECIMAL(18,2), IN `p_valorVenta` DECIMAL(18,2), IN `p_descuentoTotal` DECIMAL(18,2), IN `p_monto` DECIMAL(18,2), IN `p_cantidadTotal` DECIMAL(18,2), IN `p_idUnidadMedida` CHAR(5), IN `p_unidadMedida` VARCHAR(300), IN `p_estado` CHAR(5), IN `p_urgencia` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert 		int;  
    DECLARE contadorUpdate 		int;
    DECLARE v_idOrdenCompra		int;
    DECLARE subtotal			decimal(18,2);
    DECLARE descuento			decimal(18,2);
	DECLARE d_igv				decimal(18,2);    
    DECLARE TOTAL				decimal(18,2);
    DECLARE v_tasaCambio	    decimal(18,3);
    DECLARE d_cantidad	int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra
										AND idProducto = p_idProducto and idPresentacion = p_idPresentacion);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'tipoRespuesta', 'Ya existe un producto con ese nombre y esa presentación.' as respuesta;
		ELSE                     
			SET p_unidadMedida = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 3 and abrev = p_idUnidadMedida);
            SET p_cantidadTotal = p_cantidad * (SELECT cantidad FROM PRESENTACION WHERE idPresentacion = p_idPresentacion);
                       
			INSERT INTO DETALLE_ORDEN(
				idOrdenCompra, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA,
                cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA, descuentoTotal, descuentoTotalA,  monto, montoA, 
                cantidadTotal, cantidadTotalA, idUnidadMedida, unidadMedida, estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update,  registro_pc_update, activo
			) 
			VALUES (	
				p_idOrdenCompra, p_idProducto, p_nombreProducto, p_idPresentacion, p_nombrePresentacion,
                p_valorUnitario, 0.00, p_descuentoUnitario, 0.00, p_precioUnitario, 0.00,
                p_cantidad, 0.00,0.00, 0.00,
				p_valorVenta, 0.00, p_descuentoTotal, 0.00, p_monto, 0.00,
                p_cantidadTotal, 0.00, p_idUnidadMedida, p_unidadMedida, 'EN', p_urgencia,
				now(), p_registro_user_add,  "-", now(), "-", "-", 1
			);
            
                                    			
            
            												
            SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
            UPDATE ORDEN_COMPRA SET 
				subtotal = @subtotal,
                descuento = @descuento,
                igv2 = @total - @subtotal + @descuento,
                total = CONVERT(@total, DECIMAL(18,2))
			WHERE idOrdenCompra = p_idOrdenCompra;
            
            SELECT 1 AS 'tipoRespuesta', 'Se añadió correctamente el producto.' as respuesta;
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN    		
		SET @d_cantidad = ( SELECT cantidad FROM PRESENTACION WHERE idPresentacion = (
								SELECT idPresentacion FROM DETALLE_ORDEN 	
									WHERE idDetalleOrden = p_idDetalleOrden )
							);
        
		UPDATE `DETALLE_ORDEN` SET
						valorUnitarioA = p_valorUnitario,
                        descuentoUnitarioA = p_descuentoUnitario,
						precioUnitarioA = p_precioUnitario,
                        cantidadAceptada = p_cantidad,
                        cantidadRechazada = cantidad - p_cantidad,
                        valorVentaA = p_valorVenta,
                        descuentoTotalA = p_descuentoTotal,
                        montoA = p_monto,
                        cantidadTotalA = (cantidadAceptada) * @d_cantidad, 
                                                estado = 'C',
						registro_fecha_update = now(),
						registro_user_update = p_registro_user_update,
						registro_pc_update = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;
		
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');                                    
					
		UPDATE ORDEN_COMPRA SET 
            estadoRecepcion = (CASE WHEN @contadorUpdate > 0 then 'P'
						ELSE 'EN'
					END)
		WHERE idOrdenCompra = p_idOrdenCompra;
            
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SET @d_cantidad = ( SELECT cantidad FROM PRESENTACION WHERE idPresentacion = (
								SELECT idPresentacion FROM DETALLE_ORDEN 	
									WHERE idDetalleOrden = p_idDetalleOrden )
							);
        
		UPDATE `DETALLE_ORDEN` SET
						
                        valorUnitarioA = p_valorUnitario,
                        descuentoUnitarioA = p_descuentoUnitario,
						precioUnitarioA = p_precioUnitario,
						cantidadAceptada = cantidad - p_cantidad,
                        cantidadRechazada = p_cantidad,
                        valorVentaA = p_valorVenta,
                        descuentoTotalA = p_descuentoTotal,
                        montoA = p_monto,                       
                        cantidadTotalA = (cantidadAceptada) * @d_cantidad,                         
                        estado = 'C',                        
                                                						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;	
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');
		
        UPDATE ORDEN_COMPRA SET 
            estadoRecepcion = (CASE WHEN @contadorUpdate > 0 then 'P'
						ELSE 'EN'
					END)
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 4 THEN    		
		UPDATE `DETALLE_ORDEN` SET
                        `cantidadRechazada` = cantidadRechazada + p_cantidad, 
                        `estado` = p_estado,
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');
		
        UPDATE ORDEN_COMPRA SET 
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
	IF p_tipoOperacion = 5 THEN    		
		UPDATE `DETALLE_ORDEN` SET						
						`precioUnitarioA` = 0.00,                        
						`cantidadAceptada` = 0,
						`cantidadReenviada` = 0,
						`cantidadRechazada` = 0,
                        `montoA` = 0.00, 
                        `cantidadTotalA` = 0,
                        `estado` = 'EN',
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');
		
        UPDATE ORDEN_COMPRA SET 
            estadoRecepcion = (CASE WHEN @contadorUpdate > 0 then 'P'
							ELSE 'EN'
					  END)
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
        IF p_tipoOperacion = 6 THEN
    
		SET p_unidadMedida = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 3 and abrev = p_idUnidadMedida);
                    
		UPDATE `DETALLE_ORDEN` SET		
			nombreProducto = p_nombreProducto, nombrePresentacion = p_nombrePresentacion,
            valorUnitario = p_valorUnitario, descuentoUnitario = p_descuentoUnitario, precioUnitario = p_precioUnitario, 
            cantidad = p_cantidad, 
            valorVenta = p_valorVenta, descuentoTotal = p_descuentoTotal, monto = p_monto,
            cantidadTotal = p_cantidadTotal,
            idUnidadMedida = p_idUnidadMedida, unidadMedida = p_unidadMedida,
            urgencia = p_urgencia,
			registro_fecha_update = now(), registro_user_update = p_registro_user_update, 
            registro_pc_update = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;        
		        
        SET @v_idOrdenCompra = (SELECT idOrdenCompra FROM DETALLE_ORDEN WHERE idDetalleOrden = p_idDetalleOrden);
        		                
        							
		SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
        SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
        SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
		UPDATE ORDEN_COMPRA SET 
			subtotal = @subtotal,
            descuento = @descuento,
            igv2 = @total - @subtotal + @descuento,
            total = CONVERT(@total, DECIMAL(18,2))
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'tipoRespuesta', 'Se editó correctamente el producto.' as respuesta;
	END IF;	
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaOrdenMantenimiento` (IN `p_idDetaOrdenMantenimiento` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenCompra` INT, IN `p_idCompra` INT, IN `p_idProveedor` INT, IN `p_idProducto` INT, IN `p_cantidad` DECIMAL(18,2), IN `p_observacion` VARCHAR(500), IN `p_fechaSalida` DATETIME, IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
    
    DECLARE cor char(7);
    DECLARE v_id int;
    DECLARE nFilas int;
    DECLARE nFilasProducto int;
    DECLARE v_idOrdenMantenimiento int;
    DECLARE v_idDetaOrden int;
    DECLARE v_idProducto int;
    DECLARE v_cantidadProducto decimal(18,2);
    
    DECLARE v_idDetaNota int;
    DECLARE v_cantidad decimal(18,2);
    
    IF p_tipoOperacion = 1 THEN  -- AÑADIR PRODUCTO EN crearOrdenMantenimiento.php
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
								AND idProducto = p_idProducto AND fechaSalida is null) THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @cantidadProducto = (SELECT stockActual FROM PRODUCTO WHERE idProducto = p_idProducto);
            
			IF	p_cantidad <= @cantidadProducto THEN
				INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)
				VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
				
                -- UPDATE PRODUCTO SET stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;
			ELSE
				IF @cantidadProducto <= 0 THEN
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
				ELSE
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, @cantidadProducto, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
					
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad - @cantidadProducto, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
                END IF;				
				
				-- UPDATE PRODUCTO SET stockActual = 0.00 WHERE idProducto = p_idProducto;                      
			END IF;
			
			SELECT  1 as respuesta;
		END	IF; 
    END	IF;
    
	IF p_tipoOperacion = 2 THEN   -- ACTUALIZAR DETALLE DE OTM EN crearOrdenMantenimiento.php
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
		CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO
		SELECT DOM.idProducto, 	DOM.observacion,
			SUM(case when DOM.estado = 'C' then DOM.cantidad else 0.00 end) as cantidadC,
			SUM(case when DOM.estado = 'A' then DOM.cantidad else 0.00 end) as cantidadA
        FROM DETALLE_ORDEN_MANTENIMIENTO DOM
        WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.fechaSalida is null
        GROUP BY DOM.idProducto
        ORDER BY DOM.idProducto ASC;
        
        SET @nFilasProducto = (SELECT count(idProducto) FROM TEMPORAL_PRODUCTO);
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
                
        WHILE @nFilasProducto > 0 DO
			
            SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
			SET p_cantidad = (SELECT cantidadA FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET @v_cantidad = (SELECT cantidadC FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET p_observacion = (SELECT observacion FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            
            SET @cantidadProducto = (SELECT stockActual FROM PRODUCTO WHERE idProducto = p_idProducto);
            
			IF	p_cantidad <= @cantidadProducto THEN
				IF p_cantidad > 0 THEN
					DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and idProducto = p_idProducto and fechaSalida is null;
					
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, @v_cantidad + p_cantidad, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
					
					-- UPDATE PRODUCTO SET stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto; 
                END IF;
			ELSE
				IF @cantidadProducto > 0 THEN					
					DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and idProducto = p_idProducto and fechaSalida is null;
                    
                    INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, @v_cantidad + @cantidadProducto, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
					
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad - @cantidadProducto, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
					
                    -- UPDATE PRODUCTO SET stockActual = 0.00 WHERE idProducto = p_idProducto;                      
                END IF;
			END IF;
                        
            DELETE FROM TEMPORAL_PRODUCTO WHERE idProducto = p_idProducto;
            
			SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;	
		
        SELECT '1' AS 'respuesta', p_cantidad;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   -- ASIGNAR OC A LOS PRODUCTOS
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Mantenimiento.' as respuesta;
		ELSE		
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
			CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO
			SELECT DOM.idDetaOrden, DOM.idProducto, DOM.cantidad
			FROM DETALLE_ORDEN_MANTENIMIENTO DOM
			WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.estado = 'C'
			ORDER BY DOM.idDetaOrden ASC;
			
			SET @nFilasProducto = (SELECT count(idDetaOrden) FROM TEMPORAL_PRODUCTO);        
			
			IF @nFilasProducto = null THEN
					SET @nFilasProducto = 0;
			END IF;
					
			WHILE @nFilasProducto > 0 DO
				SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
				SET p_cantidad = (SELECT cantidad FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
				SET @v_idDetaOrden = (SELECT idDetaOrden FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			
				DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
				CREATE TEMPORARY TABLE TEMPORAL
				SELECT
					DN.idDetaNota, DN.idNotaAlmacen,
					NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
					 DN.idProducto,
					DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
					DN.idUnidadMedida, DN.unidadMedida
				FROM detalle_nota_almacen DN 
				INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
				INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
				INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
				where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
				ORDER BY NA.fechaEmision ASC;
				
				SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
				
				IF @nFilas = null THEN
					SET @nFilas = 0;
				END IF;
				
				WHILE @nFilas > 0 and p_cantidad > 0 DO
					SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
					SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
					 
					IF p_cantidad >= @v_cantidad THEN					
						INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
						)    
						SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
								valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
								now(), p_registro_user_add, '-',
								now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						SET p_cantidad = p_cantidad - @v_cantidad;
						
						UPDATE DETALLE_NOTA_ALMACEN SET
							cantidadUsada = cantidadUsada + @v_cantidad, 
							cantidadSaldo = cantidadSaldo - @v_cantidad
						WHERE idDetaNota = @v_idDetaNota;
						
						-- UPDATE PRODUCTO set stockActual = stockActual  - @v_cantidad WHERE idProducto = p_idProducto;
					ELSE 				
						INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
						)    
						SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							   valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, p_observacion, 'C',
								now(), p_registro_user_add, '-',
								now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						UPDATE DETALLE_NOTA_ALMACEN SET 
							cantidadUsada = cantidadUsada + p_cantidad, 
							cantidadSaldo = cantidadSaldo - p_cantidad
						WHERE idDetaNota = @v_idDetaNota;
						
						-- UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

						SET p_cantidad = 0;
					END IF;
					
					DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
					SET @nFilas = @nFilas - 1;
				END WHILE;  
				
				IF	p_cantidad > 0 THEN
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
							idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad, '', '', '', 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
				END IF;
				
				DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = @v_idDetaOrden;
				DELETE FROM TEMPORAL_PRODUCTO WHERE idDetaOrden = @v_idDetaOrden;
				
				SET @nFilasProducto = @nFilasProducto - 1;
			END WHILE;
        
			SELECT  1 as tipoRespuesta, 
					'Se asignaron correctamente la OC.' as respuesta;	
		END	IF;
    END	IF;
    
    IF p_tipoOperacion = 4 THEN
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
								AND idProducto = p_idProducto) THEN
			SELECT 0 AS 'respuesta';
		ELSE         
        
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT -- DN.*, 
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				 DN.idProducto, -- P.codigo,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
                DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
			where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC;
			
			-- Select * FROM TEMPORAL;
			
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
			
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
			
			WHILE @nFilas > 0 and p_cantidad > 0 DO		
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				 
				IF p_cantidad >= @v_cantidad THEN
				
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					SET p_cantidad = p_cantidad - @v_cantidad;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual  - @v_cantidad WHERE idProducto = p_idProducto;
				ELSE 				
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						   valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

					SET p_cantidad = 0;
				END IF;
				
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
			
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				values (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', p_observacion, 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
			END IF;
			
			SELECT '1' AS 'respuesta', p_cantidad;
		END	IF; 
    END	IF;
    
    IF p_tipoOperacion = 5 THEN   
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
		CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO            
		SELECT DOM.idDetaOrden, DOM.idProducto, DOM.cantidad
        FROM DETALLE_ORDEN_MANTENIMIENTO DOM
        WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.idOrdenCompra is null
        ORDER BY DOM.idDetaOrden ASC;
        
        SET @nFilasProducto = (SELECT count(idDetaOrden) FROM TEMPORAL_PRODUCTO);        
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
                
        WHILE @nFilasProducto > 0 DO		
			SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			SET p_cantidad = (SELECT cantidad FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			SET @v_idDetaOrden = (SELECT idDetaOrden FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
        
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT -- DN.*, 
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				 DN.idProducto, -- P.codigo,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
                DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
			where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC;
			
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
			
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
			
			WHILE @nFilas > 0 and p_cantidad > 0 DO		
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				 
				IF p_cantidad >= @v_cantidad THEN
				
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					SET p_cantidad = p_cantidad - @v_cantidad;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual  - @v_cantidad WHERE idProducto = p_idProducto;
				ELSE 				
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						   valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

					SET p_cantidad = 0;
				END IF;
				
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
			
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				values (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', '', 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
			END IF;
			
            DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = @v_idDetaOrden;
            DELETE FROM TEMPORAL_PRODUCTO WHERE idDetaOrden = @v_idDetaOrden;
            
			SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;	
		
        SELECT '1' AS 'respuesta', p_cantidad;		
    END	IF;
    
	IF p_tipoOperacion = 6 THEN   -- ASIGNAR OC A LOS PRODUCTOS (NUEVO)
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar.' as respuesta;
		ELSE
			SET p_idProducto = (SELECT idProducto FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento);
			SET p_cantidad = (SELECT cantidad FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento);
			SET p_idOrdenMantenimiento = (SELECT idOrdenMantenimiento FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento limit 1);
            SET p_observacion = (SELECT observacion FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento limit 1);
			            
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL
			SELECT
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				DN.idProducto,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
				DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			LEFT JOIN COMPRA C ON C.idCompra = NA.idCompra
			WHERE DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC, DN.idDetaNota ASC;
				
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
				
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
				
			WHILE @nFilas > 0 and p_cantidad > 0 DO
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC, idDetaNota ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC, idDetaNota ASC LIMIT 1 );
					 
				IF p_cantidad >= @v_cantidad THEN					
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, 
                        fechaSalida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, 
                            p_fechaSalida, p_observacion, 'NS',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
						
					SET p_cantidad = p_cantidad - @v_cantidad;
						
					UPDATE DETALLE_NOTA_ALMACEN SET
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;
				ELSE 				
					INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, 
                        fechaSalida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						   valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, 
                           p_fechaSalida, p_observacion, 'NS',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
						
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;

					SET p_cantidad = 0;
				END IF;
					
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
				
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_MANTENIMIENTO(
						idOrdenMantenimiento, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				VALUES (p_idOrdenMantenimiento, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', '', 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
			END IF;
				
			
            SET @v_idDetaOrden = (SELECT idDetaOrden FROM DETALLE_ORDEN_MANTENIMIENTO ORDER BY idDetaOrden desc limit 1);
            DELETE FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idDetaOrden = p_idDetaOrdenMantenimiento;
			       
			SELECT  1 as tipoRespuesta, 
					'Se asignó correctamente la OC.' as respuesta,
                    @v_idDetaOrden as idDetaOrden;
		END	IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDetaOrdenServicio` (IN `p_idDetaOrdenServicio` INT, IN `p_idOrdenServicio` INT, IN `p_idOrdenCompra` INT, IN `p_idCompra` INT, IN `p_idProveedor` INT, IN `p_idProducto` INT, IN `p_cantidad` DECIMAL(18,2), IN `p_observacion` VARCHAR(500), IN `p_fechaSalida` DATETIME, IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN      
    DECLARE cor char(7);
    DECLARE v_id int;
    DECLARE nFilas int;
    DECLARE nFilasProducto int;
    DECLARE v_idDetaOrden int;
    DECLARE v_idProducto int;
    DECLARE v_cantidadProducto decimal(18,2);
    
    DECLARE v_idDetaNota int;
    DECLARE v_cantidad decimal(18,2);
    
    IF p_tipoOperacion = 1 THEN  -- AÑADIR PRODUCTO EN crearOrdenServicio.php
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
								AND idProducto = p_idProducto AND fechaSalida is null) THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @cantidadProducto = (SELECT stockActual FROM PRODUCTO WHERE idProducto = p_idProducto);
            
			IF	p_cantidad <= @cantidadProducto THEN
				INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)
				VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
				
                -- UPDATE PRODUCTO SET stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;
			ELSE
				IF @cantidadProducto <= 0 THEN
					INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
				ELSE
					INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, @cantidadProducto, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
					
					INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad - @cantidadProducto, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
                END IF;				
				
				-- UPDATE PRODUCTO SET stockActual = 0.00 WHERE idProducto = p_idProducto;                      
			END IF;
			
			SELECT  1 as respuesta;
		END	IF; 
    END	IF;
    
    IF p_tipoOperacion = 2 THEN   -- ACTUALIZAR DETALLE DE OS EN crearOrdenServicio.php
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
		CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO
		SELECT DOS.idProducto, DOS.observacion,	
			SUM(case when DOS.estado = 'C' then DOS.cantidad else 0.00 end) as cantidadC,
			SUM(case when DOS.estado = 'A' then DOS.cantidad else 0.00 end) as cantidadA
        FROM DETALLE_ORDEN_SERVICIO DOS
        WHERE DOS.idOrdenServicio = p_idOrdenServicio  and DOS.fechaSalida is null
        GROUP BY DOS.idProducto
        ORDER BY DOS.idProducto ASC;
        
        SET @nFilasProducto = (SELECT count(idProducto) FROM TEMPORAL_PRODUCTO);
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
                
        WHILE @nFilasProducto > 0 DO
			
            SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
			SET p_cantidad = (SELECT cantidadA FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET @v_cantidad = (SELECT cantidadC FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            SET p_observacion = (SELECT observacion FROM TEMPORAL_PRODUCTO ORDER BY idProducto ASC LIMIT 1);
            
            SET @cantidadProducto = (SELECT stockActual FROM PRODUCTO WHERE idProducto = p_idProducto);
            
			IF	p_cantidad <= @cantidadProducto THEN
				IF p_cantidad > 0 THEN
					DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and idProducto = p_idProducto and fechaSalida is null;
					
					INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, @v_cantidad + p_cantidad, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
					
					-- UPDATE PRODUCTO SET stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto; 
                END IF;
			ELSE
				IF @cantidadProducto > 0 THEN
					DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and idProducto = p_idProducto and fechaSalida is null;
                     
                    INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, @v_cantidad + @cantidadProducto, '', '', p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
                            
					
					INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
							0.00, 0.00, p_cantidad - @cantidadProducto, '', '', p_observacion, 'A',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1);
					
                    -- UPDATE PRODUCTO SET stockActual = 0.00 WHERE idProducto = p_idProducto;                      
                END IF;
			END IF;
                        
            DELETE FROM TEMPORAL_PRODUCTO WHERE idProducto = p_idProducto;
            
			SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;	
		
        SELECT '1' AS 'respuesta', p_cantidad;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   -- ASIGNAR OC A LOS PRODUCTOS
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Servicio.' as respuesta;
		ELSE			
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
			CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO            
			SELECT DOS.idDetaOrden, DOS.idProducto, DOS.cantidad
			FROM DETALLE_ORDEN_SERVICIO DOS
			WHERE DOS.idOrdenServicio = p_idOrdenServicio and DOS.idOrdenCompra is null
			ORDER BY DOS.idDetaOrden ASC;
			
			SET @nFilasProducto = (SELECT count(idDetaOrden) FROM TEMPORAL_PRODUCTO);        
			
			IF @nFilasProducto = null THEN
					SET @nFilasProducto = 0;
			END IF;
					
			WHILE @nFilasProducto > 0 DO		
				SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
				SET p_cantidad = (SELECT cantidad FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
				SET @v_idDetaOrden = (SELECT idDetaOrden FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			
				DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
				CREATE TEMPORARY TABLE TEMPORAL 		
				SELECT -- DN.*, 
					DN.idDetaNota, DN.idNotaAlmacen,
					NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
					 DN.idProducto, -- P.codigo,
					DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
					DN.idUnidadMedida, DN.unidadMedida
				FROM detalle_nota_almacen DN 
				INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
				INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
				INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
				where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
				ORDER BY NA.fechaEmision ASC;
				
				SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
				
				IF @nFilas = null THEN
					SET @nFilas = 0;
				END IF;
				
				WHILE @nFilas > 0 and p_cantidad > 0 DO		
					SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
					SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
					 
					IF p_cantidad >= @v_cantidad THEN
					
						INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
						)    
						SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						SET p_cantidad = p_cantidad - @v_cantidad;
						
						UPDATE DETALLE_NOTA_ALMACEN SET 
							cantidadUsada = cantidadUsada + @v_cantidad, 
							cantidadSaldo = cantidadSaldo - @v_cantidad
						WHERE idDetaNota = @v_idDetaNota;												
					ELSE 				
						INSERT INTO DETALLE_ORDEN_SERVICIO(
							idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
							valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
							registro_fecha_add, registro_user_add, registro_pc_add, 
							registro_fecha_update, registro_user_update, registro_pc_update, activo
						)    
						SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
							valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, p_observacion, 'C',
							now(), p_registro_user_add, '-',
							now(), p_registro_user_update, '-', 1
						FROM TEMPORAL
						WHERE idDetaNota = @v_idDetaNota;
						
						UPDATE DETALLE_NOTA_ALMACEN SET 
							cantidadUsada = cantidadUsada + p_cantidad, 
							cantidadSaldo = cantidadSaldo - p_cantidad
						WHERE idDetaNota = @v_idDetaNota;
						
						SET p_cantidad = 0;
					END IF;
					
					DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
					SET @nFilas = @nFilas - 1;
				END WHILE;  
				
				IF	p_cantidad > 0 THEN
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					values (p_idOrdenServicio, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', '', 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
				END IF;
				
				DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = @v_idDetaOrden;
				DELETE FROM TEMPORAL_PRODUCTO WHERE idDetaOrden = @v_idDetaOrden;
				
				SET @nFilasProducto = @nFilasProducto - 1;
			END WHILE;	
			
			SELECT  1 as tipoRespuesta, 'Se asignaron correctamente la OC.' as respuesta;
		END	IF;
    END	IF;
    
	IF p_tipoOperacion = 4 THEN
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
								AND idProducto = p_idProducto) THEN
			SELECT 0 AS 'respuesta';
		ELSE  
        
        
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT 
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				DN.idProducto, -- P.codigo,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
                DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
			where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC;
			
			-- Select * FROM TEMPORAL;
			
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
			
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
			
			WHILE @nFilas > 0 and p_cantidad > 0 DO		
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				 
				IF p_cantidad >= @v_cantidad THEN
				
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					SET p_cantidad = p_cantidad - @v_cantidad;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual  - @v_cantidad WHERE idProducto = p_idProducto;
				ELSE 				
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida,  p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

					SET p_cantidad = 0;
				END IF;
				
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
			
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				values (p_idOrdenServicio, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', p_observacion, 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
			END IF;
			
			SELECT '1' AS 'respuesta', p_cantidad;
		END	IF; 
    END	IF;
    
    IF p_tipoOperacion = 5 THEN   
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL_PRODUCTO;
		CREATE TEMPORARY TABLE TEMPORAL_PRODUCTO            
		SELECT DOS.idDetaOrden, DOS.idProducto, DOS.cantidad
        FROM DETALLE_ORDEN_SERVICIO DOS
        WHERE DOS.idOrdenServicio = p_idOrdenServicio and DOS.idOrdenCompra is null
        ORDER BY DOS.idDetaOrden ASC;
        
        SET @nFilasProducto = (SELECT count(idDetaOrden) FROM TEMPORAL_PRODUCTO);        
        
        IF @nFilasProducto = null THEN
				SET @nFilasProducto = 0;
		END IF;
                
        WHILE @nFilasProducto > 0 DO		
			SET p_idProducto = (SELECT idProducto FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			SET p_cantidad = (SELECT cantidad FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
			SET @v_idDetaOrden = (SELECT idDetaOrden FROM TEMPORAL_PRODUCTO ORDER BY idDetaOrden ASC LIMIT 1);
        
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT -- DN.*, 
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				DN.idProducto, -- P.codigo,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
                DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			INNER JOIN COMPRA C ON C.idCompra = NA.idCompra
			where DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC;
			
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
			
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
			
			WHILE @nFilas > 0 and p_cantidad > 0 DO		
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC LIMIT 1 );
				 
				IF p_cantidad >= @v_cantidad THEN
				
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					SET p_cantidad = p_cantidad - @v_cantidad;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual  - @v_cantidad WHERE idProducto = p_idProducto;
				ELSE 				
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, p_observacion, 'C',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;
					
					UPDATE PRODUCTO set stockActual = stockActual - p_cantidad WHERE idProducto = p_idProducto;

					SET p_cantidad = 0;
				END IF;
				
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
			
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_SERVICIO(
					idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
					valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, 
					registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				values (p_idOrdenServicio, null, null, null, null, p_idProducto,
					0.00, 0.00, p_cantidad, '', '', '', 'A',
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);
			END IF;
			
            DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = @v_idDetaOrden;
            DELETE FROM TEMPORAL_PRODUCTO WHERE idDetaOrden = @v_idDetaOrden;
            
			SET @nFilasProducto = @nFilasProducto - 1;
        END WHILE;	
		
        SELECT '1' AS 'respuesta', p_cantidad;		
    END	IF;
    
    IF p_tipoOperacion = 6 THEN   -- ASIGNAR OC A LOS PRODUCTOS (NUEVO)
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Servicio.' as respuesta;
		ELSE			
            SET p_idProducto = (SELECT idProducto FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = p_idDetaOrdenServicio);
			SET p_cantidad = (SELECT cantidad FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = p_idDetaOrdenServicio);
			SET p_observacion = (SELECT observacion FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = p_idDetaOrdenServicio);
			SET p_idOrdenServicio = (SELECT idOrdenServicio FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = p_idDetaOrdenServicio limit 1);
			            
			DROP TEMPORARY TABLE IF EXISTS TEMPORAL;
			CREATE TEMPORARY TABLE TEMPORAL 		
			SELECT -- DN.*, 
				DN.idDetaNota, DN.idNotaAlmacen,
				NA.fechaEmision, C.idOrdenCompra, NA.idCompra,  C.idProveedor,
				DN.idProducto, -- P.codigo,
				DN.valorUnitario, DN.precioUnitario, DN.cantidadTotal, DN.cantidadUsada, DN.cantidadSaldo, 
				DN.idUnidadMedida, DN.unidadMedida
			FROM detalle_nota_almacen DN 
			INNER JOIN PRODUCTO P ON P.idProducto = DN.idProducto
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DN.idNotaAlmacen and NA.tipoNota = 'E'
			LEFT JOIN COMPRA C ON C.idCompra = NA.idCompra
			WHERE DN.idProducto = p_idProducto and DN.cantidadSaldo > 0 
			ORDER BY NA.fechaEmision ASC, DN.idDetaNota ASC;
			
            
			SET @nFilas = (SELECT count(idDetaNota) FROM TEMPORAL );
				
			IF @nFilas = null THEN
				SET @nFilas = 0;
			END IF;
				
			WHILE @nFilas > 0 and p_cantidad > 0 DO		
				SET @v_idDetaNota = ( SELECT idDetaNota FROM TEMPORAL ORDER BY fechaEmision ASC, idDetaNota ASC LIMIT 1 );
				SET @v_cantidad = ( SELECT cantidadSaldo FROM TEMPORAL ORDER BY fechaEmision ASC, idDetaNota ASC LIMIT 1 );
				
                
				IF p_cantidad >= @v_cantidad THEN
					
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, 
                        fechaSalida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
						valorUnitario, precioUnitario, cantidadSaldo, idUnidadMedida, unidadMedida, 
                        p_fechaSalida, p_observacion, 'NS',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
						
					SET p_cantidad = p_cantidad - @v_cantidad;
						
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + @v_cantidad, 
						cantidadSaldo = cantidadSaldo - @v_cantidad
					WHERE idDetaNota = @v_idDetaNota;												
				ELSE 				
					INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, 
                        fechaSalida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
					)    
					SELECT p_idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, p_idProducto,
				        valorUnitario, precioUnitario, p_cantidad, idUnidadMedida, unidadMedida, 
                        p_fechaSalida, p_observacion, 'NS',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1
					FROM TEMPORAL
					WHERE idDetaNota = @v_idDetaNota;
						
					UPDATE DETALLE_NOTA_ALMACEN SET 
						cantidadUsada = cantidadUsada + p_cantidad, 
						cantidadSaldo = cantidadSaldo - p_cantidad
					WHERE idDetaNota = @v_idDetaNota;
						
					SET p_cantidad = 0;
				END IF;
					
				DELETE FROM TEMPORAL WHERE idDetaNota = @v_idDetaNota;
				SET @nFilas = @nFilas - 1;
			END WHILE;  
				
			IF	p_cantidad > 0 THEN
				INSERT INTO DETALLE_ORDEN_SERVICIO(
						idOrdenServicio, idOrdenCompra, idCompra, idNotaAlmacen, idProveedor, idProducto,
						valorUnitario, precioUnitario, cantidad, idUnidadMedida, unidadMedida, observacion, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
				)    
				VALUES (p_idOrdenServicio, null, null, null, null, p_idProducto,
						0.00, 0.00, p_cantidad, '', '', '', 'A',
						now(), p_registro_user_add, '-',
						now(), p_registro_user_update, '-', 1);
			END IF;
			
			SET @v_idDetaOrden = (SELECT idDetaOrden FROM DETALLE_ORDEN_SERVICIO ORDER BY idDetaOrden desc limit 1);
            DELETE FROM DETALLE_ORDEN_SERVICIO WHERE idDetaOrden = p_idDetaOrdenServicio;
			
			SELECT  1 as tipoRespuesta, 
					'Se asignaron correctamente la OC.' as respuesta,
                    @v_idDetaOrden as idDetaOrden;
		END	IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDocumentoVenta` (IN `p_idVenta` INT, IN `p_idCliente` INT, IN `p_idTipoDocumento` INT, IN `p_idMoneda` INT, IN `p_idFormaPago` INT, IN `p_idMedioPago` INT, IN `p_idCanal` INT, IN `p_fechaEmision` TIMESTAMP, IN `p_serie` VARCHAR(50), IN `p_numero` VARCHAR(50), IN `p_tipoCambio` DECIMAL(18,3), IN `p_igv` DECIMAL(18,3), IN `p_monto_subtotal` DECIMAL(18,6), IN `p_monto_descuento_total` DECIMAL(18,6), IN `p_monto_igv_total` DECIMAL(18,6), IN `p_monto_total` DECIMAL(18,6), IN `p_monto_interes` DECIMAL(18,6), IN `p_monto_total_interes` DECIMAL(18,6), IN `p_usuarioRegistro` VARCHAR(50))  BEGIN 
	
    DECLARE	tam int;
	DECLARE cuerpo varchar(6);
	DECLARE cuerpoFinal varchar(6);
	DECLARE aux varchar(6);
	DECLARE aux1 int;
	DECLARE aux2 int;
	DECLARE b int default 1;
	DECLARE _codigo varchar(9);

	IF p_idVenta IS NULL OR p_idVenta = 0
		THEN
        
			SET cuerpo = (SELECT Max(SUBSTRING(correlativo,4,9)) FROM DOCUMENTO_VENTA);
			
			SET tam = length(cuerpo);
			
			
			IF (tam = 6) then
				set aux = cuerpo;
				set aux1 = cast(aux as UNSIGNED); 
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6));
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while; 
				
				set cuerpoFinal = aux;
				
			ELSE
				set aux = '0';
				set aux1 = cast(aux as UNSIGNED);
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6)); 
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while;
				
				set cuerpoFinal = aux;         
				 
			END IF;
			
			SET _codigo = concat('DV-',cuerpoFinal);
        
			INSERT INTO DOCUMENTO_VENTA(
										idCliente,
										idTipoDocumento,
										idMoneda,
                                        idFormaPago,
                                        idMedioPago,
                                        idCanal,
                                        correlativo,
                                        fecha_emision,
                                        serie,
                                        numero,
                                        tasa_cambio,
                                        igv,
                                        monto_subtotal,
                                        monto_descuento_total,
                                        monto_igv_total,
                                        monto_total,
                                        monto_interes,
                                        monto_total_interes,
                                        estado,
                                        fecha_registro,
                                        usuario_registro,
                                        pc_registro,
                                        fecha_edicion,
                                        usuario_edicion,
                                        pc_edicion,
                                        activo
										)
								VALUES	(
										p_idCliente,
										p_idTipoDocumento,
										p_idMoneda,
										p_idFormaPago,
										p_idMedioPago,
										p_idCanal,
                                        _codigo,
                                        p_fechaEmision,
										p_serie,
										p_numero,
                                        p_tipoCambio,
                                        p_igv,
										p_monto_subtotal,
										p_monto_descuento_total,
										p_monto_igv_total,
										p_monto_total,
										p_monto_interes,
										p_monto_total_interes,
                                        'A',
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
										1
										);
			SELECT	1 AS tipoRespuesta,
					'EL documento se regitró correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
		ELSE    
			UPDATE	DOCUMENTO_VENTA
            SET		idCliente = p_idCliente,
					idTipoDocumento = p_idTipoDocumento,
					idMoneda = p_idMoneda,
					idFormaPago = p_idFormaPago,
					idMedioPago = p_idMedioPago,
					idCanal = p_idCanal,
					fecha_emision = p_fechaEmision,
					serie = p_serie,
					numero = p_numero,
                    tasa_cambio = p_tipoCambio,
                    igv = p_igv,
					monto_subtotal = p_monto_subtotal,
					monto_descuento_total = p_monto_descuento_total,
					monto_igv_total = p_monto_igv_total,
					monto_total = p_monto_total,
					monto_interes = p_monto_interes,
					monto_total_interes = p_monto_total_interes,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE	id = p_idVenta;
            
			SELECT	1 AS tipoRespuesta,
					'EL documento se editó correctamente !' AS respuesta,
					p_idVenta AS id;
		END IF;
    
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateEmpaque` (IN `p_idEmpaque` INT, IN `p_idClase` INT, IN `p_idEmpaqueM` INT, IN `p_cantidad` INT, IN `p_nombre` VARCHAR(250), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE unidad int;
    DECLARE empaque int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM EMPAQUE WHERE cantidad = p_cantidad and idClase = p_idClase);
        
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE 			
            SET @empaque = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 4 AND valor = p_idEmpaqueM);
			SET p_nombre = (SELECT CONCAT(@empaque, ' de ', CONVERT(p_cantidad, CHAR(50)), ' unidades.'));
            
			INSERT INTO `EMPAQUE`(
							`idClase`, 	
                            `idEmpaqueM`, 						
                            `cantidad`, 
                            `nombre`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	
						p_idClase, 	
                        p_idEmpaqueM,
						p_cantidad, 
                        p_nombre, 
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);           
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM EMPAQUE WHERE cantidad = p_cantidad and idClase = p_idClase and idEmpaque != p_idEmpaque);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
            SET @empaque = (SELECT descripcion FROM MULTITABLA WHERE dep_id = 4 AND valor = p_idEmpaqueM);
			SET p_nombre = (SELECT CONCAT(@empaque, ' de ', CONVERT(p_cantidad, CHAR(50)), ' unidades.'));
            
			UPDATE `EMPAQUE` SET
							`idClase` = p_idClase,                            
                            `idEmpaqueM` = p_idEmpaqueM, 
							`cantidad` = p_cantidad,  
                            `nombre` = p_nombre, 
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idEmpaque = p_idEmpaque;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateEmpresa` (IN `p_idEmpresa` INT, IN `p_ruc` CHAR(11), IN `p_razonSocial` VARCHAR(400), IN `p_nombreComercial` VARCHAR(400), IN `p_domicilioFiscal` VARCHAR(400), IN `p_correo` VARCHAR(400), IN `p_telefono` VARCHAR(400), IN `p_correoEnvio` VARCHAR(100), IN `p_passCorreo` VARCHAR(100), IN `p_cuerpoCT` VARCHAR(2000), IN `p_cuerpoOC` VARCHAR(2000), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN
		UPDATE EMPRESA
        SET ruc = p_ruc, razonSocial = p_razonSocial, nombreComercial = p_nombreComercial,
			domicilioFiscal = p_domicilioFiscal, correo = p_correo, telefono = p_telefono,
			registro_fecha_update = now(), registro_user_update = p_registro_user_update
        WHERE idEmpresa = 1;
		        
		SELECT 1 AS respuesta;
	END IF;
    
    IF p_tipoOperacion = 2 THEN
		UPDATE EMPRESA
        SET correoEnvio = p_correoEnvio, passCorreo = p_passCorreo,
			cuerpoCT = p_cuerpoCT, cuerpoOC = p_cuerpoOC,
			registro_fecha_update = now(), registro_user_update = p_registro_user_update
        WHERE idEmpresa = 1;
		        
		SELECT 1 AS respuesta;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateFormaPago` (IN `p_idFormaPago` INT, IN `p_nombre` VARCHAR(200), IN `p_numero_cuotas` INT, IN `p_frecuencia` INT, IN `p_tipo_frecuencia` INT, IN `p_interes` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT)  BEGIN  
	DECLARE contadorInsert int;   
    DECLARE contadorUpdate int;    
    DECLARE cod_subcategoria varchar(50); 
    DECLARE cod_clase varchar(50); 
    
	IF p_idFormaPago IS NULL OR p_idFormaPago = ''
		THEN       	
			IF EXISTS (SELECT id FROM FORMA_PAGO WHERE trim(nombre) = trim(p_nombre) and activo <> 2) 
				THEN
					SELECT	0 AS 'tipoRespuesta', 
							'Ya existe una forma de pago con este nombre.' AS respuesta;
			ELSE
				INSERT INTO FORMA_pago(	tipo_frecuencia_id,
										nombre,
										numero_cuotas,
										frecuencia,
										interes,
										activo,
										registro_fecha_add,
										registro_user_add,
										registro_pc_add,
										registro_fecha_update,
										registro_user_update,
										registro_pc_update
										)
								VALUES(	p_tipo_frecuencia,
										p_nombre,
										p_numero_cuotas,
										p_frecuencia,
										p_interes,
										p_activo,
										NOW(),
										p_registro_user_add, 
										@@hostname,
										NOW(),
										p_registro_user_update,
										@@hostname                                    
										);
				
				SELECT 	1 AS 'tipoRespuesta', 
						'Se guardó correctamente la forma de pago.' as respuesta;
			END	IF;
	ELSE
			UPDATE 	FORMA_PAGO
			SET		tipo_frecuencia_id = p_tipo_frecuencia,
					nombre = p_nombre,
					numero_cuotas = p_numero_cuotas,
					frecuencia = p_frecuencia,
					interes = p_interes,
					activo = p_activo,
					registro_fecha_update = NOW(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = @@hostname
			WHERE	id = p_idFormaPago;
			
			SELECT 	1 AS 'tipoRespuesta', 
					'Se editó correctamente la forma de pago.' as respuesta;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateGrupoCotizacion` (IN `p_idGrupoCotizacion` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_correlativo` CHAR(8), IN `p_subTotal` DECIMAL(18,2), IN `p_igv` DECIMAL(18,2), IN `p_total` DECIMAL(18,2), IN `p_estado` CHAR(2), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);
    
    DECLARE respuesta varchar(100);
    DECLARE id int;
    
    DECLARE subtotal	decimal(18,2);
	DECLARE d_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    
    SET @respuesta = '1';
    
	IF p_tipoOperacion = 1 THEN  		
        IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
			
			INSERT INTO `GRUPO_COTIZACION`(
					correlativo, subTotal, igv, igv2, total, fechaEnvio, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, 
					registro_fecha_update, registro_user_update, registro_pc_update, activo
			) 
			VALUES (					
					'', p_subTotal, p_igv, 0.00, p_total, null, 'SN',
					now(), p_registro_user_add, "-",
					now(), "-", "-", 1
			);
        
			SELECT idGrupoCotizacion, 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta
			FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1;
		ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM GRUPO_COTIZACION WHERE correlativo = p_correlativo and idGrupoCotizacion != p_idGrupoCotizacion);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  			
			UPDATE `GRUPO_COTIZACION` SET 
							`estado` = p_estado,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idGrupoCotizacion = p_idGrupoCotizacion;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM GRUPO_COTIZACION WHERE correlativo = p_correlativo);
        
        IF (@contadorInsert) > 0 THEN
			SET correlativoA = p_correlativo;
            
            SET @id = (SELECT idGrupoCotizacion FROM GRUPO_COTIZACION ORDER BY p_idGrupoCotizacion DESC LIMIT 1);
        			
			SET @id = @id + 1;
			SET p_correlativo = CONCAT('GC-', CONVERT(@id, CHAR(5)));
            SET @respuesta = CONCAT('El grupo de cotización se guardó con el siguiente código: ', p_correlativo, '.');
		END IF;        
			
		INSERT INTO `GRUPO_COTIZACION`(
					`idGrupoCotizacion`, 
					`correlativo`, 
					`subTotal`,
                    `igv`,
                    `total`,
                    `fechaEnvio`,
                    `estado`,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
					`activo`
		) 
		VALUES (	
					p_idGrupoCotizacion,
					p_idProveedor, 
					p_correlativo, 
					p_subTotal, 						
                    p_igv,
                    p_total,
                    null,
                    'P',
					now(),
					p_registro_user_add, 
					"-",
					now(),
					"-",
					"-",
					1
		);        
		SELECT @respuesta AS 'respuesta';
    END	IF;
    
    IF p_tipoOperacion = 4 THEN         
		        
        SET @id = IFNULL((SELECT cast(correlativo as unsigned) FROM GRUPO_COTIZACION WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET p_correlativo = (CASE WHEN (cast(@id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@id as UNSIGNED) + 1) )
							WHEN (cast(@id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@id as UNSIGNED) + 1) )
							WHEN (cast(@id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@id as UNSIGNED) + 1) )
							WHEN (cast(@id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@id as UNSIGNED) + 1) )
							WHEN (cast(@id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@id as UNSIGNED) + 1) )
							WHEN (cast(@id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@id as UNSIGNED) + 1)
						END);
                        
		        SET @respuesta = p_correlativo;
		      
		UPDATE `GRUPO_COTIZACION` SET 
							`estado` = 'P',
							`correlativo` = p_correlativo,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
		WHERE idGrupoCotizacion = p_idGrupoCotizacion;      
		
        SELECT @respuesta AS 'respuesta';
    END	IF;
    
    IF p_tipoOperacion = 5 THEN   		SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
		
        INSERT INTO `GRUPO_COTIZACION`(
					`correlativo`, `subTotal`, `igv`, `igv2`, `total`, `fechaEnvio`, `estado`,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
					`activo`
		) 
		VALUES (					
					'', p_subTotal, p_igv, 0.00, p_total, null, 'SN',
					now(), p_registro_user_add, "-", 
                    now(), "-", "-", 1
		);        
		
        
        SET id = (SELECT idGrupoCotizacion FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1);
		
        INSERT INTO DETALLE_GRUPOCOTIZACION (
		idGrupoCotizacion, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
        idProveedorR, nombreProveedorR, idProveedorC, nombreProveedorC,
		precioUnitario, cantidad, monto, cantidadTotal, idUnidadMedida, unidadMedida, urgencia, 
        registro_fecha_add, registro_user_add, registro_pc_add,
		registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT  id as idGrupoCotizacion, DC.idProducto, DC.nombreProducto, DC.idPresentacion, DC.nombrePresentacion,
			(CASE WHEN DC.precioUnitarioA = 00 THEN DGC.idProveedorR
				ELSE C.idProveedor
			END) AS  idProveedorR,
            (CASE WHEN DC.precioUnitarioA = 00 THEN DGC.nombreProveedorR
				ELSE C.nombreProveedor
			END) AS  nombreProveedorR,
			C.idProveedor as idProveedorC, C.nombreProveedor as nombreProveedorC,            
			(CASE WHEN DC.precioUnitarioA = 00 THEN DC.precioUnitario
				ELSE DC.precioUnitarioA
			END) AS precioUnitario, 			(CASE WHEN DC.cantidadAceptada = 00 THEN DC.cantidad
				ELSE DC.cantidadAceptada 
			END) AS cantidad,    
			(CASE WHEN DC.montoA = 00 THEN DC.monto
				ELSE DC.montoA 
			END) AS monto,    
			(CASE WHEN DC.cantidadTotalA = 00 THEN DC.cantidadTotal
				ELSE DC.cantidadTotalA 
			END) AS cantidadTotal,
            DC.idUnidadMedida, DC.unidadMedida,
			DC.urgencia,
			now(), 'admin', '-',
			now(), '-', '-', 1
		FROM COTIZACION C
		INNER JOIN DETALLE_COTIZACION DC ON DC.idCotizacion = C.idCotizacion AND C.idCotizacion = p_idGrupoCotizacion
		INNER JOIN DETALLE_GRUPOCOTIZACION DGC ON DGC.idGrupoCotizacion = C.idGrupoCotizacion and DGC.idProveedorC = C.idProveedor
								and DGC.idProducto = DC.idProducto and DGC.idPresentacion = DC.idPresentacion;
                                
		SET @total = (SELECT SUM(monto) FROM DETALLE_GRUPOCOTIZACION WHERE idGrupoCotizacion = id);
		SET @d_igv = (SELECT igv FROM GRUPO_COTIZACION WHERE idGrupoCotizacion = id);
        SET @subtotal = CONVERT (@total/(1 + (@d_igv/100)), DECIMAL(18,2));
			
		UPDATE GRUPO_COTIZACION SET
			subtotal = @subtotal,
			total = @total,
            igv2 = @total - @subtotal
		WHERE idGrupoCotizacion = id;
                                
		SELECT id as respuesta;
       
    END	IF;
    
    IF p_tipoOperacion = 6 THEN  		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
			
			INSERT INTO `GRUPO_COTIZACION`(
						idOrdenMantenimiento, `correlativo`, `subTotal`, `igv`, `igv2`, `total`, `fechaEnvio`, `estado`,
						`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
						`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (					
						p_idOrdenMantenimiento, '', p_subTotal, p_igv, 0.00, p_total, null, 'SN',
						now(), p_registro_user_add, "-",
						now(), "-", "-", 1
			);        
			
			SET @id = (SELECT idGrupoCotizacion FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1);
			
			INSERT INTO DETALLE_GRUPOCOTIZACION (
			idGrupoCotizacion, idProducto, nombreProducto, 
			idPresentacion, nombrePresentacion,
			idProveedorR, nombreProveedorR, idProveedorC, nombreProveedorC,
			precioUnitario, cantidad, monto, cantidadTotal, idUnidadMedida, unidadMedida, urgencia, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
			SELECT @id as idGrupoCotizacion, DOM.idProducto, P.nombre as nombreProducto, 
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
				0 as idProveedorR, '-' as nombreProveedorR, 0 as idProveedorC, '-' as nombreProveedorC, 
				0.00 as precioUnitario, sum(DOM.cantidad) as cantidad, 0.00 as monto, sum(DOM.cantidad) as cantidadTotal, 
				P.unidad_medida, M.descripcion, 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_MANTENIMIENTO DOM
			INNER JOIN PRODUCTO P ON DOM.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.estado = 'A'
			GROUP BY DOM.idProducto;
			
			
			            SELECT idGrupoCotizacion, 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta
			FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1;
		ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 7 THEN  		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
			
			INSERT INTO `GRUPO_COTIZACION`(
						idOrdenServicio, `correlativo`, `subTotal`, `igv`, `igv2`, `total`, `fechaEnvio`, `estado`,
						`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
						`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (					
						p_idOrdenServicio, '', p_subTotal, p_igv, 0.00, p_total, null, 'SN',
						now(), p_registro_user_add, "-",
						now(), "-", "-", 1
			);        
			
			SET @id = (SELECT idGrupoCotizacion FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1);
			
			INSERT INTO DETALLE_GRUPOCOTIZACION (
			idGrupoCotizacion, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			idProveedorR, nombreProveedorR, idProveedorC, nombreProveedorC,
			precioUnitario, cantidad, monto, cantidadTotal, idUnidadMedida, unidadMedida, urgencia, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
			SELECT @id as idGrupoCotizacion, DOS.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
				0 as idProveedorR, '-' as nombreProveedorR, 0 as idProveedorC, '-' as nombreProveedorC, 
				0.00 as precioUnitario, sum(DOS.cantidad) as cantidad, 0.00 as monto, sum(DOS.cantidad) as cantidadTotal, 
				P.unidad_medida, M.descripcion, 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_SERVICIO DOS
			INNER JOIN PRODUCTO P ON DOS.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOS.idOrdenServicio = p_idOrdenServicio and DOS.estado = 'A'
			GROUP BY DOS.idProducto;
			
			
			            SELECT idGrupoCotizacion, 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta
			FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1;
		ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 8 THEN  		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
			
			INSERT INTO `GRUPO_COTIZACION`(
						idOrdenServicio, `correlativo`, `subTotal`, `igv`, `igv2`, `total`, `fechaEnvio`, `estado`,
						`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
						`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (					
						null, '', p_subTotal, p_igv, 0.00, p_total, null, 'SN',
						now(), p_registro_user_add, "-",
						now(), "-", "-", 1
			);        
			
			SET @id = (SELECT idGrupoCotizacion FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1);
			
			INSERT INTO DETALLE_GRUPOCOTIZACION (
			idGrupoCotizacion, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			idProveedorR, nombreProveedorR, idProveedorC, nombreProveedorC,
			precioUnitario, cantidad, monto, cantidadTotal, idUnidadMedida, unidadMedida, urgencia, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
			SELECT @id as idGrupoCotizacion, DNA.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
				0 as idProveedorR, '-' as nombreProveedorR, 0 as idProveedorC, '-' as nombreProveedorC, 
				0.00 as precioUnitario, sum(DNA.cantidad) as cantidad, 0.00 as monto, sum(DNA.cantidad) as cantidadTotal, 
				P.unidad_medida, M.descripcion, 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_NOTA_ALMACEN DNA
			INNER JOIN PRODUCTO P ON DNA.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DNA.idNotaAlmacen = p_idOrdenServicio and DNA.estado = 'PC'
			GROUP BY DNA.idProducto;
			
			            SELECT idGrupoCotizacion, 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta
			FROM GRUPO_COTIZACION ORDER BY idGrupoCotizacion DESC LIMIT 1;
		ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateGrupoOrdenCompra` (IN `p_idGrupoOrden` INT, IN `p_correlativo` CHAR(8), IN `p_subTotal` DECIMAL(18,2), IN `p_igv` DECIMAL(18,2), IN `p_total` DECIMAL(18,2), IN `p_estado` CHAR(2), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);
    
    DECLARE respuesta varchar(100);
    DECLARE id int;
    SET @respuesta = '1';
    
	IF p_tipoOperacion = 1 THEN 
		SET p_igv = (SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()));
		INSERT INTO `GRUPO_ORDENCOMPRA`(
					`correlativo`, 
					`subTotal`,
                    `igv`,
                    `igv2`,
                    `total`,
                    `fechaEnvio`,
                    `estado`,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
					`activo`
		) 
		VALUES (					
					'', 
					p_subTotal, 						
                    p_igv,
                    0.00,
                    p_total,
                    null,
                    'SN',
					now(),
					p_registro_user_add, 
					"-",
					now(),
					"-",
					"-",
					1
		);        
		
        
        SELECT idGrupoOrden FROM GRUPO_ORDENCOMPRA ORDER BY idGrupoOrden DESC LIMIT 1;
    END	IF;
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM GRUPO_ORDENCOMPRA WHERE correlativo = p_correlativo and idGrupoOrden != p_idGrupoOrden);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  			
			UPDATE `GRUPO_ORDENCOMPRA` SET 
							`estado` = p_estado,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idGrupoOrden = p_idGrupoOrden;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM GRUPO_ORDENCOMPRA WHERE correlativo = p_correlativo);
        
        IF (@contadorInsert) > 0 THEN
			SET correlativoA = p_correlativo;
            
            SET @id = (SELECT idGrupoOrden FROM GRUPO_ORDENCOMPRA ORDER BY p_idGrupoOrden DESC LIMIT 1);
        			
			SET @id = @id + 1;
			SET p_correlativo = CONCAT('GOC-', CONVERT(@id, CHAR(5)));
            SET @respuesta = CONCAT('El grupo de orden de compra se guardó con el siguiente código: ', p_correlativo, '.');
		END IF;        
			
		INSERT INTO `GRUPO_ORDENCOMPRA`(
					`idGrupoOrden`, 
					`correlativo`, 
					`subTotal`,
                    `igv`,
                    `total`,
                    `fechaEnvio`,
                    `estado`,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`,
					`activo`
		) 
		VALUES (	
					p_idOrdenCompra,
					p_idProveedor, 
					p_correlativo, 
					p_subTotal, 						
                    p_igv,
                    p_total,
                    null,
                    'P',
					now(),
					p_registro_user_add, 
					"-",
					now(),
					"-",
					"-",
					1
		);        
		SELECT @respuesta AS 'respuesta';
    END	IF;
    
    IF p_tipoOperacion = 4 THEN         SET @id = (SELECT count(*) + 1 FROM GRUPO_ORDENCOMPRA WHERE correlativo != '');
        
		SET p_correlativo = CONCAT('GOC-', CONVERT(@id, CHAR(5)));
        SET @respuesta = p_correlativo;
		      
		UPDATE `GRUPO_ORDENCOMPRA` SET 
							`estado` = 'P',
							`correlativo` = p_correlativo,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
		WHERE idGrupoOrden = p_idGrupoOrden;      
		
        SELECT @respuesta AS 'respuesta';
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateGrupos` (IN `p_idGrupo` INT, IN `p_nombre` VARCHAR(50), IN `p_descripcion` VARCHAR(250), IN `p_icono` VARCHAR(50), IN `p_orden` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM GRUPO WHERE nombre = p_nombre );
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `GRUPO`(
							`nombre`, 
							`descripcion`, 
							`icono`, 
							`orden`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	p_nombre, 
						p_descripcion, 
						p_icono, 
						p_orden,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM GRUPO WHERE nombre = p_nombre and idGrupo != p_idGrupo);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `GRUPO` SET
							`nombre` = p_nombre, 
							`descripcion` = p_descripcion, 
																					`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idGrupo = p_idGrupo;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateIgv` (IN `p_idIgv` INT, IN `p_anio` INT, IN `p_porcentaje` DECIMAL(18,2), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM IGV WHERE anio = p_anio and activo = 1 );
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `IGV`(
							`anio`, 
							`porcentaje`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	p_anio, 
						p_porcentaje,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM IGV WHERE anio = p_anio and idIgv != p_idIgv);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `IGV` SET
							`anio` = p_anio, 
							`porcentaje` = p_porcentaje, 
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idIgv = p_idIgv;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateMultitabla` (IN `p_idMultitabla` INT, IN `p_valor` INT, IN `p_dep_id` INT, IN `p_descripcion` VARCHAR(50), IN `p_abreviatura` VARCHAR(50), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE va INT;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM MULTITABLA WHERE (descripcion = p_descripcion or abrev = p_abreviatura) and dep_id is null);
        
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			SET @va = (SELECT valor FROM MULTITABLA 
							WHERE dep_id is null AND activo = 1 
                            ORDER BY idMultitabla DESC
                            LIMIT 1);
			IF @va is null then
				set @va = 0;
			END IF;
            
			SET @va = @va + 1;
            
			INSERT INTO `MULTITABLA`(
							`valor`, 							
                            `dep_id`, 
                            `descripcion`, 
                            `abrev`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	@va, 
						null,
                        p_descripcion,
                        p_abreviatura,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM MULTITABLA 
								WHERE (descripcion = p_descripcion OR abrev = p_abreviatura) 
										AND idMultitabla != p_idMultitabla AND dep_id is null);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `MULTITABLA` SET
                            `descripcion` = p_descripcion,
							`abrev` = p_abreviatura, 
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idMultitabla = p_idMultitabla;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM MULTITABLA WHERE (descripcion = p_descripcion or abrev = p_abreviatura) and dep_id = p_dep_id);
        
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			SET @va = (SELECT COUNT(*) FROM MULTITABLA WHERE dep_id = p_dep_id AND activo = 1);
			SET @va = @va + 1;
            
			INSERT INTO `MULTITABLA`(
							`valor`, 							
                            `dep_id`, 
                            `descripcion`, 
                            `abrev`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	@va, 
						p_dep_id,
                        p_descripcion,
                        p_abreviatura,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM MULTITABLA 
								WHERE (descripcion = p_descripcion OR abrev = p_abreviatura) 
										AND dep_id = p_dep_id and valor != p_valor);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    		
            
			UPDATE `MULTITABLA` SET
                            `descripcion` = p_descripcion,
							`abrev` = p_abreviatura, 
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-'
			WHERE dep_id = p_dep_id and valor = p_valor;	
            
           
            
			SELECT 1 as 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateNotaAlmacen` (IN `p_idNotaAlmacen` INT, IN `p_idCompra` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_idTrabajador` INT, IN `p_idUnidad` INT, IN `p_idDestino` INT, IN `p_idTipoOperacion` CHAR(5), IN `p_fechaEmision` DATETIME, IN `p_observaciones` VARCHAR(500), IN `p_tipoNota` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);    
    
    DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    
    DECLARE subtotal	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE v_total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_cor 		char(8);
    
    IF p_tipoOperacion = 1 THEN  		    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
		        
        INSERT INTO NOTA_ALMACEN (idAlmacen, idCompra, correlativo, 
			tipoDocumento, serieDocumento, numeroDocumento, tipoOperacion, 
            tasaCambio,
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT 1, idCompra, @v_cor, 
			tipoDocumento, serieDocumento, numeroDocumento, '02',
            tasaCambio,
			'0.00', igv, igv2, '0.00', 
            fechaEnvio, fechaEnvio, '', 1, 'E', 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM COMPRA
		WHERE idCompra = p_idCompra;
        
        SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
        INSERT INTO DETALLE_NOTA_ALMACEN ( 
			idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
            valorPresentacion,
			precioPresentacion,
            valorUnitario,
            precioUnitario, 
            cantidad,
            valorVenta,
			monto, 
            cantidadTotal, cantidadUsada, cantidadSaldo, idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT @v_id, DC.idProducto, DC.nombreProducto, DC.idPresentacion, DC.nombrePresentacion,
			            DC.valorUnitario * C.tasaCambio as valorPresentacion,
			DC.precioUnitario * C.tasaCambio as precioPresentacion,    
                        ROUND(  (DC.valorUnitario/PR.cantidad) * C.tasaCambio, 2) as valorUnitario, 
            ROUND(  (DC.precioUnitario/PR.cantidad) * C.tasaCambio, 2) as precioUnitario, 
            DC.cantidad,
            			ROUND(DC.valorVenta * C.tasaCambio, 2)  as valorVenta,
			ROUND(DC.monto * C.tasaCambio, 2)  as monto,
            DC.cantidadTotal, 0.00, DC.cantidadTotal, DC.idUnidadMedida, DC.unidadMedida, 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1		
		FROM DETALLE_COMPRA DC
        INNER JOIN COMPRA C ON C.idCompra = DC.idCompra
        INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        WHERE DC.idCompra = p_idCompra;
		
        SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = @v_id);
        
        UPDATE NOTA_ALMACEN
			SET subTotal = @v_total - igv2,
				total = @v_total
        WHERE idNotaAlmacen = @v_id;
        
        UPDATE PRODUCTO P, (SELECT idProducto, SUM(cantidadTotal) as cantidadTotal 
								FROM DETALLE_NOTA_ALMACEN 
								WHERE idNotaAlmacen = @v_id GROUP BY idProducto)  S
		SET P.stockActual = P.stockActual + S.cantidadTotal
		WHERE S.idProducto = P.idProducto;

        SELECT CONCAT('NA-', @v_cor) AS respuesta;        
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN
		    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
		        
        INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenMantenimiento, idUnidad, correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT 1, idOrdenMantenimiento, idUnidad, @v_cor, 
			'10',
			'0.00', 0.00, 0.00, '0.00', 
            now(), now(),'', 1, 'S', 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM ORDEN_MANTENIMIENTO
		WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;
        
        SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
        INSERT INTO DETALLE_NOTA_ALMACEN ( 
			idNotaAlmacen, idProducto, nombreProducto, 
			precioPresentacion, precioUnitario, cantidad, 
			monto, cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT @v_id, DOM.idProducto, P.nombre, 
			0.00, DOM.precioUnitario, DOM.cantidad, 
			DOM.precioUnitario * DOM.cantidad, DOM.cantidad, 0.00, DOM.cantidad, 
            DOM.idUnidadMedida, DOM.unidadMedida, 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM DETALLE_ORDEN_MANTENIMIENTO DOM 
        INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        where DOM.idOrdenMantenimiento = p_idOrdenMantenimiento;
		
        SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = @v_id);
        
        UPDATE NOTA_ALMACEN
			SET subTotal = @v_total - igv2,
				total = @v_total
        WHERE idNotaAlmacen = @v_id;

        SELECT CONCAT('NA-', @v_cor) AS respuesta;        
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN   
		    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
		        
        INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenServicio, idUnidad, correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision,fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT 1, idOrdenServicio, idUnidad, @v_cor, 
			'10',
			'0.00', 0.00, 0.00, '0.00', 
            now(), now(), '', 1, 'S', 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM ORDEN_SERVICIO
		WHERE idOrdenServicio = p_idOrdenServicio;
        
        SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
        INSERT INTO DETALLE_NOTA_ALMACEN ( 
			idNotaAlmacen, idProducto, nombreProducto, 
			precioPresentacion, precioUnitario, cantidad, 
			monto, cantidadTotal, cantidadUsada, cantidadSaldo, 
            idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add,
			registro_fecha_update, registro_user_update, registro_pc_update, activo)
		SELECT @v_id, DOM.idProducto, P.nombre, 
			0.00, DOM.precioUnitario, DOM.cantidad, 
			DOM.precioUnitario * DOM.cantidad, DOM.cantidad, 0.00, DOM.cantidad, 
            DOM.idUnidadMedida, DOM.unidadMedida, 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1
		FROM DETALLE_ORDEN_SERVICIO DOM 
        INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        where DOM.idOrdenServicio = p_idOrdenServicio;
		
        SET @v_total = (SELECT SUM(monto) FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = @v_id);
        
        UPDATE NOTA_ALMACEN
			SET subTotal = @v_total - igv2,
				total = @v_total
        WHERE idNotaAlmacen = @v_id;

        SELECT CONCAT('NA-', @v_cor) AS respuesta;        
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN     		    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);		
        
		        
        INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenMantenimiento, idTrabajador, idUnidad, idDestino, correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		values (1, p_idOrdenMantenimiento, p_idTrabajador, p_idUnidad, p_idDestino, null, 
			p_idTipoOperacion,
			0.00, 0.00, 0.00, 0.00, 
            p_fechaEmision, p_fechaEmision, p_observaciones, 1, 'S', 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1);
		
        SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
		SELECT 1 as tipoRespuesta, @v_id as idNotaAlmacen, 
			concat('Se registró correctamente la Nota de Almacen NA-', @v_cor) as 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 5 THEN   		    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
						WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
        
		        
        INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenServicio, idUnidad, idDestino, correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		values (1, p_idOrdenServicio, p_idUnidad, p_idDestino, null, 
			p_idTipoOperacion,
			0.00, 0.00, 0.00, 0.00,
            p_fechaEmision, p_fechaEmision, p_observaciones, 1, 'S', 'C', 
			now(), p_registro_user_add,  '-', 
            now(), p_registro_user_update, '-', 1);
		
        SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
		SELECT 1 as tipoRespuesta, @v_id as idNotaAlmacen, 
			concat('Se registró correctamente la Nota de Almacen NA-', @v_cor) as 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 6 THEN 		        
        INSERT INTO NOTA_ALMACEN (idAlmacen,  correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		values (1, null, 
			null,
			0.00, 0.00, 0.00, 0.00, 
            null, null, '', null, 'S', 'A', 
			now(), p_registro_user_add,  '-',
            now(), p_registro_user_update, '-', 1);
            
		SELECT 1 as tipoRespuesta, idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen desc limit 1;
	END IF;
    
    IF p_tipoOperacion = 7 THEN 		        
        INSERT INTO NOTA_ALMACEN (idAlmacen,  correlativo, 
			tipoOperacion, 
            subTotal, igv, igv2, total, 
            fechaEmision, fechaEmisionReal, observaciones, motivo, tipoNota, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
            registro_fecha_update, registro_user_update, registro_pc_update, activo)
		values (1, null, 
			null,
			0.00, 0.00, 0.00, 0.00, 
            null, null, '', null, 'E', 'A', 
			now(), p_registro_user_add,  '-',
            now(), p_registro_user_update, '-', 1);
            
		SELECT 1 as tipoRespuesta, idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen desc limit 1;
	END IF;
    
    IF p_tipoOperacion = 8 THEN 		
		IF EXISTS (SELECT * FROM NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen
								AND correlativo is null) THEN
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
					
			UPDATE NOTA_ALMACEN 
				SET correlativo = @v_cor,
					tipoOperacion = p_idTipoOperacion,
					observaciones = p_observaciones,				
					fechaEmision = p_fechaEmision,
                    fechaEmisionReal = p_fechaEmision
			WHERE idNotaAlmacen = p_idNotaAlmacen;
			
			SELECT 1 as tipoRespuesta, concat('Se guardó correctamente la Nota de Entrada: NA-', @v_cor, '.') as respuesta;
        ELSE
			UPDATE NOTA_ALMACEN 
				SET 
					tipoOperacion = p_idTipoOperacion,
					observaciones = p_observaciones,				
					fechaEmision = p_fechaEmision,
                    fechaEmisionReal = p_fechaEmision
			WHERE idNotaAlmacen = p_idNotaAlmacen;
            
            SELECT 1 as tipoRespuesta, 'Se actualizaron correctamente los datos.' as respuesta;
        END IF;		
	END IF;
    
    IF p_tipoOperacion = 9 THEN 		
		IF EXISTS (SELECT * FROM NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen
								AND correlativo is null) THEN
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
					
			UPDATE NOTA_ALMACEN 
				SET correlativo = @v_cor,
					tipoOperacion = p_idTipoOperacion,
					observaciones = p_observaciones,				
					fechaEmision = p_fechaEmision,
                    fechaEmisionReal = p_fechaEmision,
                    estado = 'C'
			WHERE idNotaAlmacen = p_idNotaAlmacen;
            
            UPDATE PRODUCTO P, (SELECT idProducto, SUM(cantidadTotal) as cantidadTotal 
								FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and estado = 'A'
								GROUP BY idNotaAlmacen, idProducto) DNA
			SET P.stockActual = DNA.cantidadTotal
			WHERE P.idProducto = DNA.idProducto;
			
            UPDATE DETALLE_NOTA_ALMACEN SET estado = 'C' WHERE idNotaAlmacen = p_idNotaAlmacen;
            
			SELECT 1 as tipoRespuesta, concat('Se guardó correctamente la Nota de Entrada: NA-', @v_cor, '.') as respuesta;
        ELSE
			UPDATE NOTA_ALMACEN 
				SET 
					tipoOperacion = p_idTipoOperacion,
					observaciones = p_observaciones,				
					fechaEmision = p_fechaEmision,
                    fechaEmisionReal = p_fechaEmision,
                    estado = 'C'
			WHERE idNotaAlmacen = p_idNotaAlmacen;
            
            UPDATE PRODUCTO P, (SELECT idProducto, SUM(cantidadTotal) as cantidadTotal 
								FROM DETALLE_NOTA_ALMACEN WHERE idNotaAlmacen = p_idNotaAlmacen and estado = 'A'
								GROUP BY idNotaAlmacen, idProducto) DNA
			SET P.stockActual = DNA.cantidadTotal
			WHERE P.idProducto = DNA.idProducto;
            
            UPDATE DETALLE_NOTA_ALMACEN SET estado = 'C' WHERE idNotaAlmacen = p_idNotaAlmacen;
            
            SELECT 1 as tipoRespuesta, 'Se actualizaron correctamente los datos.' as respuesta;
        END IF;		
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateNotaEntrada` (IN `p_idNotaAlmacen` INT, IN `p_idOrdenCompra` INT, IN `p_idTipoOperacion` CHAR(5), IN `p_idTipoDocumento` CHAR(5), IN `p_tipoDocumento` CHAR(5), `p_serieDocumento` VARCHAR(50), `p_numeroDocumento` VARCHAR(50), IN `p_fechaEmision` DATETIME, IN `p_fechaContable` DATETIME, IN `p_observacion` VARCHAR(500), IN `p_estado` CHAR(5), IN `p_usuario` VARCHAR(50), `p_activo` INT)  BEGIN
    DECLARE v_cor char(8);
    DECLARE v_id int;
    
    IF p_idNotaAlmacen = 0 THEN
    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
                        
		INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenCompra, correlativo, tipoDocumento, serieDocumento, numeroDocumento,
			tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, tipoNota, estado,
            registro_fecha_add, registro_user_add, registro_pc_add, activo)
		VALUES(1, p_idOrdenCompra, @v_cor, 
			CASE WHEN p_tipoDocumento = '' THEN NULL ELSE p_tipoDocumento END, 
            CASE WHEN p_serieDocumento = '' THEN NULL ELSE p_serieDocumento END, 
            CASE WHEN p_numeroDocumento = '' THEN NULL ELSE p_numeroDocumento END,
			p_idTipoOperacion, p_idTipoDocumento, 0.00, 0.00, 0.00, 0.00, p_fechaEmision, p_fechaContable, p_observacion, 'E', 
            p_estado,
            NOW(), p_usuario, '-', 1);
            
		SET @v_id = IFNULL( (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1), 1);
        
		SELECT 1 as tipoRespuesta, @v_id as idNotaAlmacen, 
			concat('Se registró correctamente la Nota de Almacen NA-', @v_cor) as 'respuesta';
	ELSE
		UPDATE NOTA_ALMACEN
			SET serieDocumento = p_serieDocumento,
				numeroDocumento = p_numeroDocumento,
                fechaEmision = p_fechaEmision,
                fechaContable = p_fechaContable,
                estado = p_estado,
                registro_fecha_update = now(),
                registro_user_update = p_usuario, 
                registro_pc_add = '-' 
        WHERE idNotaAlmacen = p_idNotaAlmacen;
        
		SELECT 1 as tipoRespuesta, p_idNotaAlmacen as idNotaAlmacen, 
			concat('Se editó correctamente la Nota de Almacen.') as 'respuesta';
	END IF;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateNotaSalida` (IN `p_idNotaAlmacen` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_idTipoOperacion` CHAR(5), IN `p_idTipoDocumento` CHAR(5), IN `p_idTrabajador` INT, IN `p_idDestino` INT, IN `p_idVehiculo` INT, IN `p_fechaEmision` DATETIME, IN `p_fechaContable` DATETIME, IN `p_observacion` VARCHAR(500), IN `p_estado` CHAR(5), IN `p_usuario` VARCHAR(50), `p_activo` INT)  BEGIN 
    DECLARE v_cor char(8);
    DECLARE v_id int;
    
    IF p_idNotaAlmacen = 0 THEN    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null 
								ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
        
		INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenMantenimiento, idOrdenServicio, idTrabajador, idUnidad, idDestino, 
			correlativo,  tipoOperacion, idTipoDocumento, 
            subTotal, igv, igv2, total,  fechaEmision, fechaContable, observaciones, tipoNota, estado,
            registro_fecha_add, registro_user_add, registro_pc_add, activo)
		VALUES(1, 
			CASE WHEN p_idOrdenMantenimiento = 0 THEN null ELSE p_idOrdenMantenimiento END, 
			CASE WHEN p_idOrdenServicio = 0 THEN null ELSE p_idOrdenServicio END, 
			CASE WHEN p_idTrabajador = 0 THEN null ELSE p_idTrabajador END, 
            CASE WHEN p_idVehiculo = 0 THEN null ELSE p_idVehiculo END, 
            CASE WHEN p_idDestino = 0 THEN null ELSE p_idDestino END,
			@v_cor, p_idTipoOperacion, p_idTipoDocumento,
			 0.00, 0.00, 0.00, 0.00, p_fechaEmision, p_fechaContable, p_observacion, 'S', 
            p_estado,
            NOW(), p_usuario, '-', 1);
            
		SET @v_id = (SELECT idNotaAlmacen FROM NOTA_ALMACEN ORDER BY idNotaAlmacen DESC LIMIT 1);
        
		SELECT 1 as tipoRespuesta, @v_id as idNotaAlmacen, 
			concat('Se registró correctamente la Nota de Almacen NA-', @v_cor) as 'respuesta';
	ELSE
		UPDATE NOTA_ALMACEN
			SET 
				idTrabajador = p_idTrabajador, 
                idUnidad = p_idVehiculo, 
                idDestino = p_idDestino,
                fechaEmision = p_fechaEmision,
                fechaContable = p_fechaContable,
                estado = p_estado,
                registro_fecha_update = now(),
                registro_user_update = p_usuario, 
                registro_pc_add = '-' 
        WHERE idNotaAlmacen = p_idNotaAlmacen;
        
		SELECT 1 as tipoRespuesta, p_idNotaAlmacen as idNotaAlmacen, 
			concat('Se editó correctamente la Nota de Almacen.') as 'respuesta';
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateOficina` (IN `p_idOficina` INT, IN `p_nombre` VARCHAR(50), IN `p_direccion` VARCHAR(400), IN `p_principal` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN 
    IF p_tipoOperacion = 1 then
		
		IF EXISTS (SELECT * FROM OFICINA WHERE nombre = p_nombre) THEN
			SELECT 0 AS 'tipoRespuesta', 'Ya existe una Oficina con este nombre' as respuesta;
		ELSE
			IF EXISTS (SELECT * FROM OFICINA WHERE direccion = p_direccion) THEN
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Oficina con esta dirección' as respuesta;
			ELSE
				IF p_principal = 1 then
					UPDATE OFICINA SET principal = 0;
                END IF;
                
				INSERT INTO OFICINA (nombre, direccion, principal, 
					registro_fecha_add, registro_user_add, registro_pc_add,
					registro_fecha_update, registro_user_update, registro_pc_update,
					activo)
				VALUES (p_nombre, p_direccion, p_principal,
					now(), p_registro_user_add, '-',
					now(), p_registro_user_update, '-', 1);
						
				SELECT 1 AS 'tipoRespuesta', 'Se guardó correctamente la Oficina.' as respuesta;
			END IF;
		END IF;
	END IF;
    IF p_tipoOperacion = 2 THEN
		IF EXISTS (SELECT * FROM OFICINA WHERE nombre = p_nombre and idOficina != p_idOficina) THEN
			SELECT 0 AS 'tipoRespuesta', 'Ya existe una Oficina con este nombre' as respuesta;
		ELSE
			IF EXISTS (SELECT * FROM OFICINA WHERE direccion = p_direccion and idOficina != p_idOficina) THEN
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Oficina con esta dirección' as respuesta;
			ELSE
				IF p_principal = 1 then
					UPDATE OFICINA SET principal = 0;
                END IF;
                
				UPDATE OFICINA
				SET nombre = p_nombre, direccion = p_direccion, principal = p_principal,
					registro_fecha_update = now(), registro_user_update = p_registro_user_update,
                    activo = p_activo
				WHERE idOficina = p_idOficina;
						
				SELECT 1 AS 'tipoRespuesta', 'Se editó correctamente la Oficina.' as respuesta;
			END IF;
		END IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateOrdenCompra` (IN `p_idOrdenCompra` INT, IN `p_idCotizacion` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idOrdenServicio` INT, IN `p_idProveedor` INT, IN `p_codCotizacion` VARCHAR(50), IN `p_serieDocumento` VARCHAR(50), IN `p_numeroDocumento` VARCHAR(50), IN `p_tipoDocumento` CHAR(5), IN `p_formaPago` CHAR(5), IN `p_idOficina` INT, IN `p_idTipoMoneda` INT, IN `p_idDestino` INT, IN `p_idUnidad` INT, IN `p_fechaEntrega` DATETIME, IN `p_fechaEmision` DATETIME, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);    
    
    DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    DECLARE v_nombreProveedor varchar(300);
    DECLARE v_rucProveedor char(11);
    DECLARE v_direccionProveedor varchar(250);
    DECLARE v_telefonoProveedor varchar(12);
    DECLARE v_emailProveedor varchar(50);
    
    DECLARE subtotal	decimal(18,2);
    DECLARE descuento	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_cor 		char(8);
    DECLARE v_bandera 	INT;
    
    DECLARE v_domicilioFiscal			VARCHAR(400);
    DECLARE v_tasaCambio	    		decimal(18,3);
    DECLARE v_idOrdenMantenimiento		INT;
    DECLARE v_idOrdenServicio			INT;
    
    IF p_tipoOperacion = 1 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO ORDEN_COMPRA(
				idCotizacion, idProveedor, nombreProveedor, rucProveedor, 
                direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (null, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN', now(), p_registro_user_add, "-", 
					NULL, NULL, NULL, 1);			
			
			SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN
		IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'SE',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
				SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se guardó correctamente la Orden de Compra: OC-', @v_cor, '.') as respuesta;                   
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'SE',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se actualizó correctamente la Orden de Compra.') as respuesta;            
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta;
        END IF;
	END IF;
    
	IF p_tipoOperacion = 3 THEN
		IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
					   
                
                INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenCompra, correlativo, tipoDocumento, serieDocumento, numeroDocumento,
					tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, tipoNota, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT 1, idOrdenCompra, @v_cor, tipoDocumento, serieDocumento, numeroDocumento,
					'02', '01', OC.subTotal, OC.igv, OC.igv2, OC.total, now(), now(), '', 'E', 'C',
                    now(), p_registro_user_update, '-', 1
                FROM ORDEN_COMPRA OC
                WHERE OC.idOrdenCompra = p_idOrdenCompra;
                
                INSERT INTO DETALLE_NOTA_ALMACEN (					
					idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
					valorPresentacion, precioPresentacion, 
					valorUnitario, precioUnitario, cantidad, 
					valorVenta, monto, 
					cantidadTotal, cantidadUsada, cantidadSaldo, 
					idUnidadMedida, unidadMedida, estado, 
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT LAST_INSERT_ID(), DOC.idProducto, DOC.nombreProducto, 					
					CASE WHEN DOC.idPresentacion = 0 THEN NULL ELSE DOC.idPresentacion END,  DOC.nombrePresentacion,
					DOC.valorUnitario * OC.tasaCambio,  DOC.precioUnitario * OC.tasaCambio,
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.valorUnitario
						ELSE CAST(round(DOC.valorUnitario/PR.cantidad, 2) AS decimal(18,2))
					END) * OC.tasaCambio, 
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.precioUnitario
						ELSE CAST(round(DOC.precioUnitario/PR.cantidad, 2) AS decimal(18,2))
					END) * OC.tasaCambio,
                    DOC.cantidad, 
					DOC.valorVenta * OC.tasaCambio, DOC.monto * OC.tasaCambio,
					DOC.cantidad*PR.cantidad, 0.00, DOC.cantidad*PR.cantidad,
                    M.abrev, M.descripcion, 'C',
                    now(), 'ADMIN', '-', 1
				FROM DETALLE_ORDEN DOC
                INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
                INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
                INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
                LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
				WHERE DOC.idOrdenCompra = p_idOrdenCompra;
                
                -- SELECT * FROM DETALLE_ORDEN;
                -- SELECT * FROM PRODUCTO;
                -- select * from multitabla where dep_id = 3;
				                    
				IF @v_emailProveedor = '' or @v_emailProveedor is null then
					SELECT 2 AS 'tipoRespuesta', 						
						CONCAT('Se cerró correctamente la Orden de Compra: OC-', @v_cor, '. Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta;
                ELSE
					SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se cerró correctamente la Orden de Compra: OC-', @v_cor, '.' ) as respuesta;
				END IF;
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
				
                INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenCompra, correlativo, tipoDocumento, serieDocumento, numeroDocumento,
					tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, tipoNota, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT 1, idOrdenCompra, @v_cor, tipoDocumento, serieDocumento, numeroDocumento,
					'02', '01', OC.subTotal, OC.igv, OC.igv2, OC.total, now(), now(), '', 'E', 'C',
                    now(), p_registro_user_update, '-', 1
                FROM ORDEN_COMPRA OC
                WHERE OC.idOrdenCompra = p_idOrdenCompra;
                
                INSERT INTO DETALLE_NOTA_ALMACEN (					
					idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
					valorPresentacion, precioPresentacion, 
					valorUnitario, precioUnitario, cantidad, 
					valorVenta, monto, 
					cantidadTotal, cantidadUsada, cantidadSaldo, 
					idUnidadMedida, unidadMedida, estado, 
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT LAST_INSERT_ID(), DOC.idProducto, DOC.nombreProducto, 					
					CASE WHEN DOC.idPresentacion = 0 THEN NULL ELSE DOC.idPresentacion END,  DOC.nombrePresentacion,
					DOC.valorUnitario * OC.tasaCambio,  DOC.precioUnitario * OC.tasaCambio,
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.valorUnitario
						ELSE CAST(round(DOC.valorUnitario/PR.cantidad, 2) AS decimal(18,2))
					END) * OC.tasaCambio, 
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.precioUnitario
						ELSE CAST(round(DOC.precioUnitario/PR.cantidad, 2) AS decimal(18,2))
					END) * OC.tasaCambio,
                    DOC.cantidad, 
					DOC.valorVenta * OC.tasaCambio, DOC.monto * OC.tasaCambio,
					DOC.cantidad * PR.cantidad, 0.00, DOC.cantidad * PR.cantidad,
                    M.abrev, M.descripcion, 'C',
                    now(), 'ADMIN', '-', 1
				FROM DETALLE_ORDEN DOC
                INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
                INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
                INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
                LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
				WHERE DOC.idOrdenCompra = p_idOrdenCompra;
                
				IF @v_emailProveedor = '' or @v_emailProveedor is null then
					SELECT 2 AS 'tipoRespuesta', 
						CONCAT('Se cerró correctamente la Orden de Compra. Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta;
                ELSE
					SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se cerró correctamente la Orden de Compra.') as respuesta;
				END IF;
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta;
        END IF;
	END IF;         
    
	IF p_tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_COTIZACION
		WHERE idCotizacion = p_idCotizacion
		ORDER BY idDetalleCotizacion ASC;
                        
        IF p_idTipoMoneda != 1 THEN
			IF EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO 
						WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda) THEN
				SET @v_bandera = 2;
			ELSE
				SET @v_bandera = 0;
			END IF;
		ELSE 
			SET @v_bandera = 1;
        END IF;
		
        IF @v_bandera != 0 THEN
			SET @v_tasaCambio = ifnull((	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda ), 1);
            SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
			            
            SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio
			INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio
			FROM COTIZACION 
            WHERE idCotizacion = p_idCotizacion;
			
			
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = @v_idProveedor;
            
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);		
			
            SET @v_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
						
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idOrdenServicio,
				idProveedor, nombreProveedor, rucProveedor, direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, `fechaEntrega`, `estadoEmision`, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (p_idCotizacion, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, 
				@v_direccionProveedor,@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
                p_idOficina, @v_domicilioFiscal, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
				0.00, 0.00, @v_igv, 0.00, 0.00,
				p_fechaEmision, p_fechaEntrega, 'A', 'EN',
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
					
			SET @v_id = IFNULL( (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1),  1);
			
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, `monto`, `montoA`,  
                cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT  @v_id, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitarioA, 0.00, descuentoUnitarioA, 0.00,  precioUnitarioA, 0.00,
				cantidadAceptada, 0, 0, 0, 
				valorVentaA, 0.00, descuentoTotalA, 0.00, montoA, 0.00, 
                cantidadTotalA, 0,
                idUnidadMedida, unidadMedida,
				'EN', urgencia,  
				now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL;
                       
		
			SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
            SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @v_igv = @total - @subtotal + @descuento;
            
			UPDATE ORDEN_COMPRA SET 
				total = @total,
				descuento = @descuento,
				igv2 = @v_igv,
                subtotal = @subtotal
            WHERE idOrdenCompra = @v_id;
        
			UPDATE COTIZACION SET 
				codCotizacion = p_codCotizacion,
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = p_idCotizacion;
			
            IF @v_emailProveedor = '' or @v_emailProveedor is null then
				SELECT 2 AS 'tipoRespuesta', 
						CONCAT('Se registró correctamente la Orden de Compra: OC-', @v_cor, ' . Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta,
						@v_id as 'idOrdenCompra';
            ELSE
				SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se generó correctamente la Orden de Compra: OC-', @v_cor) AS 'respuesta', 
                        @v_id as 'idOrdenCompra';
			END IF;
		ELSE
			SELECT 0 as tipoRespuesta, 'No se ha ingresado la Tasa de Cambio para la fecha de emisión.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN
		UPDATE `DETALLE_ORDEN` SET						
						`precioUnitarioA` = 0.00,                        
						`cantidadAceptada` = 0,
						`cantidadReenviada` = 0,
						`cantidadRechazada` = 0,
                        `montoA` = 0.00, 
                        `cantidadTotalA` = 0,
                        `estado` = 'EN',
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;	
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');
		
        UPDATE ORDEN_COMPRA SET 
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
											  END)
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 6 THEN
        IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
					registro_user_update = p_registro_user_update, 
                    registro_fecha_update = now(),
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                UPDATE DETALLE_ORDEN 
                SET 
					-- valorUnitarioA = valorUnitario,
                    -- descuentoUnitarioA = descuentoUnitario,
                    -- precioUnitarioA = precioUnitario, cantidadAceptada = cantidad,
                    -- valorVentaA = valorVenta,
                    -- descuentoTotalA = descuentoTotal,
					-- montoA = monto, cantidadTotalA = cantidadTotal, 
					estado = 'EN',
					registro_user_update = p_registro_user_update, 
                    registro_fecha_update = now(),
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
				SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se guardó correctamente la Orden de Compra: OC-', @v_cor, '.') as respuesta,
                    p_idOrdenCompra as 'idOrdenCompra';                   
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                UPDATE DETALLE_ORDEN SET 
					-- valorUnitarioA = valorUnitario,
                    -- descuentoUnitarioA = descuentoUnitario,
					-- precioUnitarioA = precioUnitario, cantidadAceptada = cantidad,
                    -- valorVentaA = valorVenta,
                    -- descuentoTotalA = descuentoTotal,
					-- montoA = monto, cantidadTotalA = cantidadTotal, 
                    estado = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
            
                SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se actualizó correctamente la Orden de Compra.') as respuesta,
                    p_idOrdenCompra as idOrdenCompra; 
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta,
                p_idOrdenCompra as idOrdenCompra;
        END IF;
	END IF; 
    
    IF p_tipoOperacion = 7 THEN
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_COTIZACION
		WHERE idCotizacion = p_idCotizacion
		ORDER BY idDetalleCotizacion ASC;
        
        IF p_idTipoMoneda != 1 THEN
			IF EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO 
						WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda) THEN
				SET @v_bandera = 2;
			ELSE
				SET @v_bandera = 0;
			END IF;
		ELSE 
			SET @v_bandera = 1;
        END IF;
		
        IF @v_bandera != 0 THEN
            SET @v_tasaCambio = ifnull((	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda), 1);
			SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
            
            SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio
			INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio
			FROM COTIZACION 
            WHERE idCotizacion = p_idCotizacion;
			
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = @v_idProveedor;
						
			SET @v_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
            
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
							
								  
            INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idOrdenServicio,
				idProveedor, nombreProveedor, rucProveedor, direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, `fechaEntrega`, `estadoEmision`, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)  
			VALUES (p_idCotizacion, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor,@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
                p_idOficina, @v_domicilioFiscal, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
				0.00, 0.00, @v_igv, 0.00,0.00,
				p_fechaEmision, p_fechaEntrega, 'A', 'A',
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
					
			SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
			INSERT INTO `DETALLE_ORDEN`(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, `monto`, `montoA`,  
                cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT  @v_id, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitarioA, valorUnitarioA, descuentoUnitarioA, descuentoUnitarioA,  precioUnitarioA, precioUnitarioA,
				cantidadAceptada, cantidadAceptada, 0, 0, 
				valorVentaA, valorVentaA, descuentoTotalA, descuentoTotalA, montoA, montoA, 
                cantidadTotalA, cantidadTotalA,
                idUnidadMedida, unidadMedida,
				'EN', urgencia,  
				now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL;   				
		    
			SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
            SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @v_igv = @total - @subtotal + @descuento;
            
			UPDATE ORDEN_COMPRA SET 
                subtotal = @subtotal,
                descuento = @descuento,
				igv2 = @v_igv,
				total = @total
            WHERE idOrdenCompra = @v_id;
        
			UPDATE COTIZACION SET 
				codCotizacion = p_codCotizacion,
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = p_idCotizacion;
			
            SELECT 1 as tipoRespuesta,  CONCAT('OC-', @v_cor) AS 'respuesta', @v_id as 'idOrdenCompra';
		ELSE
			SELECT 0 as tipoRespuesta, 'No se ha ingresado la Tasa de Cambio para la fecha de emisión.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 8 THEN
		IF EXISTS(SELECT idCompra FROM COMPRA WHERE idOrdenCompra = p_idOrdenCompra)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Orden de Compra ya tiene una Compra generada.' as respuesta;
        ELSE	
			UPDATE `ORDEN_COMPRA` SET 
				codCotizacion = p_codCotizacion,
                serieDocumento = p_serieDocumento,
                numeroDocumento = p_numeroDocumento,
                tipoDocumento = p_tipoDocumento,
                formaPago = p_formaPago,
                idOficina = p_idOficina,
                lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                idTipoMoneda = p_idTipoMoneda,
                idDestino = p_idDestino,
                idUnidad = p_idUnidad,
                tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = idTipoMoneda limit 1), 1),
				estadoRecepcion = 'AN',
				`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-'
			WHERE idOrdenCompra = p_idOrdenCompra;	            
			           
			SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
		END IF;
	END IF;
    
    IF p_tipoOperacion = 9 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (null, p_idOrdenMantenimiento, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					
                    now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);     
			
						SET @v_id = IFNULL( (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);            
            
			INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT @v_id as idOrdenCompra, 
				DOM.idProducto, P.nombre as nombreProducto, 
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DOM.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA, 
				0.00 as descuentoTotal, 0.00 as descuentoTotalA, 
				0.00 as monto, 0.00 as montoA, 
                sum(DOM.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_MANTENIMIENTO DOM
			INNER JOIN PRODUCTO P ON DOM.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.estado = 'A'
			GROUP BY DOM.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 10 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenServicio, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)
			VALUES (null, p_idOrdenServicio, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					now(), p_registro_user_add, "-", 
					now(), "-", "-", 1); 
			
			SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)       
			SELECT @v_id as idOrdenCompra, 
				DOS.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DOS.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA,
				0.00 as descuentoTotal, 0.00 as descuentoTotalA,
				0.00 as monto, 0.00 as montoA, 
                sum(DOS.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_SERVICIO DOS
			INNER JOIN PRODUCTO P ON DOS.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOS.idOrdenServicio = p_idCotizacion and DOS.estado = 'A'
			GROUP BY DOS.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 11 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenServicio, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)
			VALUES (null, null, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					now(), p_registro_user_add, "-", 
					now(), "-", "-", 1); 
			
						SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)       
			SELECT @v_id as idOrdenCompra, 
				DNA.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DNA.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA,
				0.00 as descuentoTotal, 0.00 as descuentoTotalA,
				0.00 as monto, 0.00 as montoA, 
                sum(DNA.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_NOTA_ALMACEN DNA
			INNER JOIN PRODUCTO P ON DNA.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DNA.idNotaAlmacen = p_idCotizacion and DNA.estado = 'PC'
			GROUP BY DNA.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateOrdenMantenimiento` (IN `p_idOrdenMantenimiento` INT, IN `p_idTrabajador` INT, IN `p_idUnidad` INT, IN `p_kilometraje` DECIMAL(18,2), IN `p_componente` VARCHAR(100), IN `p_descripcion` VARCHAR(500), IN `p_observaciones` VARCHAR(500), IN `p_fechaEmision` DATETIME, IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
    
    DECLARE v_cor char(8);    
    DECLARE v_id int;
    
	IF p_tipoOperacion = 1 THEN   -- INSERTAR ORDEN_MANTENIMIENTO
		INSERT INTO ORDEN_MANTENIMIENTO(
						idTrabajador, idUnidad, correlativo,
                        fechaEmision, fechaInicio, fechaFin, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
		)    
		VALUES (null,null, null,
			NULL,NULL, NULL, 'SN',
			now(), p_registro_user_add, "-", 
			now(), "-", "-", 1);     
		
        SET @v_id = (SELECT idOrdenMantenimiento FROM ORDEN_MANTENIMIENTO ORDER BY idOrdenMantenimiento DESC LIMIT 1);
        SELECT @v_id AS 'idOrdenMatenimiento';
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  -- GUARDAR ORDEN MANTENIMIENTO
		IF EXISTS (SELECT * FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
								AND correlativo is null) THEN
			
            SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_MANTENIMIENTO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
			
			UPDATE ORDEN_MANTENIMIENTO 
				SET idTrabajador = p_idTrabajador,
					idUnidad = p_idUnidad,
					correlativo = @v_cor, kilometraje = p_kilometraje, componente = p_componente,
					descripcion = p_descripcion,
					observaciones = p_observaciones,
                    fechaEmision = p_fechaEmision,
                    fechaInicio = p_fechaInicio,
                    fechaFin = p_fechaFin,
                    estado = 'A'
			WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;        
            
            SELECT CONCAT('Se guardó con el código: OTM-', @v_cor) as respuesta;
		ELSE                  
			UPDATE ORDEN_MANTENIMIENTO 
				SET idTrabajador = p_idTrabajador,
					idUnidad = p_idUnidad, kilometraje = p_kilometraje, componente = p_componente,
					descripcion = p_descripcion,
					observaciones = p_observaciones,
                    fechaEmision = p_fechaEmision,
                    fechaInicio = p_fechaInicio,
                    fechaFin = p_fechaFin,
                    estado = 'A'
			WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;            
            
            SELECT 'Se actualizaron correctamente los datos.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN  -- CERRAR ORDEN_MANTENIMIENTO
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Mantenimiento.' as respuesta,
                    p_idOrdenMantenimiento as idOrdenMantenimiento;
		ELSE 
			IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
				SELECT  0 as tipoRespuesta, 
						'Existen órdenes de servicio abiertas. No se cerró la Orden de Mantenimiento.' as respuesta,
						p_idOrdenMantenimiento as idOrdenMantenimiento;
			ELSE
				IF EXISTS (SELECT * FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
									AND correlativo is null) THEN
				
					SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_MANTENIMIENTO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
					SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
				
					UPDATE ORDEN_MANTENIMIENTO 
						SET idTrabajador = p_idTrabajador,
							idUnidad = p_idUnidad,
							correlativo = @v_cor, kilometraje = p_kilometraje, componente = p_componente,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;        
					
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
							p_idOrdenMantenimiento as idOrdenMantenimiento;
				ELSE                  
					UPDATE ORDEN_MANTENIMIENTO 
						SET idTrabajador = p_idTrabajador,
							idUnidad = p_idUnidad, kilometraje = p_kilometraje, componente = p_componente,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;            
					
					SET @v_cor = (SELECT correlativo FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento);
					
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
							p_idOrdenMantenimiento as idOrdenMantenimiento;
				END IF;
			END IF;
		END	IF; 
	END IF;		
    
    IF p_tipoOperacion = 4 THEN  -- CERRAR ORDEN_MANTENIMIENTO (NUEVO)
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Mantenimiento.' as respuesta,
                    p_idOrdenMantenimiento as idOrdenMantenimiento;
		ELSE
			IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and idNotaAlmacen is null) THEN
				SELECT  0 as tipoRespuesta, 
						'Existen productos sin nota de salida. No se cerró la Orden de Mantenimiento.' as respuesta,
						p_idOrdenMantenimiento as idOrdenMantenimiento;
			ELSE 
				IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
					SELECT  0 as tipoRespuesta, 
							'Existen órdenes de servicio abiertas. No se cerró la Orden de Mantenimiento.' as respuesta,
							p_idOrdenMantenimiento as idOrdenMantenimiento;
				ELSE
					IF EXISTS (SELECT * FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
										AND correlativo is null) THEN
					
						SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_MANTENIMIENTO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
				
						SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);
					
						UPDATE ORDEN_MANTENIMIENTO 
							SET idTrabajador = p_idTrabajador,
								idUnidad = p_idUnidad,
								correlativo = @v_cor, kilometraje = p_kilometraje, componente = p_componente,
								descripcion = p_descripcion,
								observaciones = p_observaciones,
								fechaEmision = p_fechaEmision,
								fechaInicio = p_fechaInicio,
								fechaFin = p_fechaFin,
								estado = 'C'
						WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;        
						
						SELECT  1 as tipoRespuesta, 
								CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
								p_idOrdenMantenimiento as idOrdenMantenimiento;
					ELSE                  
						UPDATE ORDEN_MANTENIMIENTO 
							SET idTrabajador = p_idTrabajador,
								idUnidad = p_idUnidad, kilometraje = p_kilometraje, componente = p_componente,
								descripcion = p_descripcion,                                
								observaciones = p_observaciones,
								fechaEmision = p_fechaEmision,
								fechaInicio = p_fechaInicio,
								fechaFin = p_fechaFin,
								estado = 'C'
						WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;            
						
						SET @v_cor = (SELECT correlativo FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento);
						
						SELECT  1 as tipoRespuesta, 
								CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
								p_idOrdenMantenimiento as idOrdenMantenimiento;
					END IF;
				END IF;
			END	IF; 
		END IF;
	END IF;	
    
    IF p_tipoOperacion = 5 THEN  -- CERRAR ORDEN_MANTENIMIENTO (NUEVO2)
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Mantenimiento.' as respuesta,
                    p_idOrdenMantenimiento as idOrdenMantenimiento;
		ELSE
			
				IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento and estado = 'A') THEN
					SELECT  0 as tipoRespuesta, 
							'Existen órdenes de servicio abiertas. No se cerró la Orden de Mantenimiento.' as respuesta,
							p_idOrdenMantenimiento as idOrdenMantenimiento;
				ELSE
					IF EXISTS (SELECT * FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento
										AND correlativo is null) THEN
					
						SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_MANTENIMIENTO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
				
						SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);
					
						UPDATE ORDEN_MANTENIMIENTO 
							SET idTrabajador = p_idTrabajador,
								idUnidad = p_idUnidad,
								correlativo = @v_cor, kilometraje = p_kilometraje, componente = p_componente,
								descripcion = p_descripcion,
								observaciones = p_observaciones,
								fechaEmision = p_fechaEmision,
								fechaInicio = p_fechaInicio,
								fechaFin = p_fechaFin,
								estado = 'C'
						WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;        
						
						SELECT  1 as tipoRespuesta, 
								CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
								p_idOrdenMantenimiento as idOrdenMantenimiento;
					ELSE                  
						UPDATE ORDEN_MANTENIMIENTO 
							SET idTrabajador = p_idTrabajador,
								idUnidad = p_idUnidad, kilometraje = p_kilometraje, componente = p_componente,
								descripcion = p_descripcion,                                
								observaciones = p_observaciones,
								fechaEmision = p_fechaEmision,
								fechaInicio = p_fechaInicio,
								fechaFin = p_fechaFin,
								estado = 'C'
						WHERE idOrdenMantenimiento = p_idOrdenMantenimiento;            
						
						SET @v_cor = (SELECT correlativo FROM ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento);
						
						SELECT  1 as tipoRespuesta, 
								CONCAT('Se cerró correctamente la orden de mantenimiento: OTM-', @v_cor) as respuesta, 
								p_idOrdenMantenimiento as idOrdenMantenimiento;
					END IF;
				END IF;
			
		END IF;
	END IF;	
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateOrdenServicio` (IN `p_idOrdenServicio` INT, IN `p_idOrdenMantenimiento` INT, IN `p_idProveedor` INT, IN `p_idUnidad` INT, IN `p_kilometraje` DECIMAL(18,2), IN `p_tipoDocumento` CHAR(5), IN `p_serieDocumento` VARCHAR(50), IN `p_numeroDocumento` VARCHAR(50), IN `p_idTipoMoneda` INT, IN `p_descripcion` VARCHAR(500), IN `p_observaciones` VARCHAR(500), IN `p_fechaEmision` DATETIME, IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_estado` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN  
    
    DECLARE cor char(7);
    DECLARE v_id int;
    
	IF p_tipoOperacion = 1 THEN
		INSERT INTO ORDEN_SERVICIO(
			idProveedor, idUnidad, correlativo, kilometraje,
            tipoDocumento, serieDocumento, numeroDocumento, idTipoMoneda,
            fechaEmision, fechaInicio, fechaFin, estado,
			registro_fecha_add, registro_user_add, registro_pc_add, 
			registro_fecha_update, registro_user_update, registro_pc_update, activo
		)    
		VALUES (null,null, null, null,
			'','','', null,
			null, null, null, 'SN',
			now(), p_registro_user_add, "-", 
			now(), "-", "-", 1);     
		
        SET @v_id = (SELECT idOrdenServicio FROM ORDEN_SERVICIO ORDER BY idOrdenServicio DESC LIMIT 1);
        SELECT @v_id AS 'idOrdenServicio';
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN
		INSERT INTO ORDEN_SERVICIO(
						idOrdenMantenimiento, idProveedor, idUnidad, correlativo, kilometraje,
						tipoDocumento, serieDocumento, numeroDocumento, idTipoMoneda,
                        fechaEmision, fechaInicio, fechaFin, estado,
						registro_fecha_add, registro_user_add, registro_pc_add, 
						registro_fecha_update, registro_user_update, registro_pc_update, activo
		)    
		VALUES (p_idOrdenMantenimiento, null,null, null, null,
			'','','', null,
			null, null, null, 'SN',
			now(), p_registro_user_add, "-", 
			now(), "-", "-", 1);     
		
        SET @v_id = (SELECT idOrdenServicio FROM ORDEN_SERVICIO ORDER BY idOrdenServicio DESC LIMIT 1);
        SELECT @v_id AS 'idOrdenServicio';
    END	IF;
    
    IF p_tipoOperacion = 3 THEN  		
			IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
								AND correlativo is null) THEN
			
            SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_SERVICIO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
						END);
			
			UPDATE ORDEN_SERVICIO 
				SET idProveedor = p_idProveedor,
					idUnidad = p_idUnidad,
					correlativo = @v_cor, kilometraje = p_kilometraje,
                    tipoDocumento = p_tipoDocumento,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
                    idTipoMoneda = p_idTipoMoneda,
					descripcion = p_descripcion,
					observaciones = p_observaciones,
                    fechaEmision = p_fechaEmision,
                    fechaInicio = p_fechaInicio,
                    fechaFin = p_fechaFin,
                    estado = 'A'
			WHERE idOrdenServicio = p_idOrdenServicio;
            
            SELECT CONCAT('Se guardó con el código: OS-', @v_cor) as respuesta;
		ELSE                  
			UPDATE ORDEN_SERVICIO 
				SET idProveedor = p_idProveedor,
					idUnidad = p_idUnidad, kilometraje = p_kilometraje,
                    tipoDocumento = p_tipoDocumento,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
                    idTipoMoneda = p_idTipoMoneda,
					descripcion = p_descripcion,
					observaciones = p_observaciones,
                    fechaEmision = p_fechaEmision,
                    fechaInicio = p_fechaInicio,
                    fechaFin = p_fechaFin,
                    estado = 'A'
			WHERE idOrdenServicio = p_idOrdenServicio;            
            
            SELECT 'Se actualizaron correctamente los datos.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN  		
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Servicio.' as respuesta,
                    p_idOrdenServicio as idOrdenServicio;
		ELSE         
			IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
									AND correlativo is null) THEN
				
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_SERVICIO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
				
				UPDATE ORDEN_SERVICIO 
					SET idProveedor = p_idProveedor,
						idUnidad = p_idUnidad,
						correlativo = @v_cor, kilometraje = p_kilometraje, 
						tipoDocumento = p_tipoDocumento,
						serieDocumento = p_serieDocumento,
						numeroDocumento = p_numeroDocumento,
                        idTipoMoneda = p_idTipoMoneda,
						descripcion = p_descripcion,
						observaciones = p_observaciones,
						fechaEmision = p_fechaEmision,
						fechaInicio = p_fechaInicio,
						fechaFin = p_fechaFin,
						estado = 'C'
				WHERE idOrdenServicio = p_idOrdenServicio;      
					
				SELECT  1 as tipoRespuesta, 
						CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
						p_idOrdenServicio as idOrdenServicio;
			ELSE                  
				UPDATE ORDEN_SERVICIO 
					SET idProveedor = p_idProveedor,
						idUnidad = p_idUnidad, kilometraje = p_kilometraje, 
						tipoDocumento = p_tipoDocumento,
						serieDocumento = p_serieDocumento,
						numeroDocumento = p_numeroDocumento,
                        idTipoMoneda = p_idTipoMoneda,
						descripcion = p_descripcion,
						observaciones = p_observaciones,
						fechaEmision = p_fechaEmision,
						fechaInicio = p_fechaInicio,
						fechaFin = p_fechaFin,
						estado = 'C'
				WHERE idOrdenServicio = p_idOrdenServicio;				
				
				SET @v_cor = (SELECT correlativo FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio);
				SELECT  1 as tipoRespuesta, 
						CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
						p_idOrdenServicio as idOrdenServicio;
			END IF;			
        END	IF; 
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN  		
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Servicio.' as respuesta,
                    p_idOrdenServicio as idOrdenServicio;
		ELSE  
			IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and idNotaAlmacen is null) THEN
				SELECT  0 as tipoRespuesta, 
						'Existen productos sin nota de salida. No se cerró la Orden de Servicio.' as respuesta,
						p_idOrdenServicio as idOrdenServicio;
			ELSE       
				IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
										AND correlativo is null) THEN
					
					SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_SERVICIO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
				
					SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);
					
					UPDATE ORDEN_SERVICIO 
						SET idProveedor = p_idProveedor,
							idUnidad = p_idUnidad,
							correlativo = @v_cor, kilometraje = p_kilometraje, 
							tipoDocumento = p_tipoDocumento,
							serieDocumento = p_serieDocumento,
							numeroDocumento = p_numeroDocumento,
                            idTipoMoneda = p_idTipoMoneda,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenServicio = p_idOrdenServicio;      
						
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
							p_idOrdenServicio as idOrdenServicio;
				ELSE                  
					UPDATE ORDEN_SERVICIO 
						SET idProveedor = p_idProveedor,
							idUnidad = p_idUnidad, kilometraje = p_kilometraje,
							tipoDocumento = p_tipoDocumento,
							serieDocumento = p_serieDocumento,
							numeroDocumento = p_numeroDocumento, 
                            idTipoMoneda = p_idTipoMoneda,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenServicio = p_idOrdenServicio;				
					
					SET @v_cor = (SELECT correlativo FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio);
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
							p_idOrdenServicio as idOrdenServicio;
				END IF;
			END IF;
        END	IF; 
    END	IF;
    
    IF p_tipoOperacion = 6 THEN    -- CERRAR ORDEN DE SERVICIO NUEVO
		IF EXISTS (SELECT * FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio and estado = 'A') THEN
			SELECT  0 as tipoRespuesta, 
					'Existen productos por comprar. No se cerró la Orden de Servicio.' as respuesta,
                    p_idOrdenServicio as idOrdenServicio;
		ELSE       
				IF EXISTS (SELECT * FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio
										AND correlativo is null) THEN
					
					SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_SERVICIO WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
				
					SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);
					
					UPDATE ORDEN_SERVICIO 
						SET idProveedor = p_idProveedor,
							idUnidad = p_idUnidad,
							correlativo = @v_cor, kilometraje = p_kilometraje, 
							tipoDocumento = p_tipoDocumento,
							serieDocumento = p_serieDocumento,
							numeroDocumento = p_numeroDocumento,
                            idTipoMoneda = p_idTipoMoneda,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenServicio = p_idOrdenServicio;      
						
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
							p_idOrdenServicio as idOrdenServicio;
				ELSE                  
					UPDATE ORDEN_SERVICIO 
						SET idProveedor = p_idProveedor,
							idUnidad = p_idUnidad, kilometraje = p_kilometraje,
							tipoDocumento = p_tipoDocumento,
							serieDocumento = p_serieDocumento,
							numeroDocumento = p_numeroDocumento, 
                            idTipoMoneda = p_idTipoMoneda,
							descripcion = p_descripcion,
							observaciones = p_observaciones,
							fechaEmision = p_fechaEmision,
							fechaInicio = p_fechaInicio,
							fechaFin = p_fechaFin,
							estado = 'C'
					WHERE idOrdenServicio = p_idOrdenServicio;				
					
					SET @v_cor = (SELECT correlativo FROM ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio);
					SELECT  1 as tipoRespuesta, 
							CONCAT('Se cerró correctamente la Orden de Servicio: OS-', @v_cor) as respuesta, 
							p_idOrdenServicio as idOrdenServicio;
				END IF;
			
        END	IF; 
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdatePresentacion` (IN `p_idPresentacion` INT, IN `p_idProducto` INT, IN `p_nombre` VARCHAR(250), IN `p_cantidad` DECIMAL(10,2), IN `p_idUnidadMedida` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN     
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE unidad int;
    DECLARE empaque int;
    
	IF p_tipoOperacion = 1 THEN 
		
        IF( EXISTS (SELECT * FROM PRESENTACION WHERE idPresentacion = p_idPresentacion) ) THEN
			SET @contadorInsert = (SELECT COUNT(*) FROM PRESENTACION WHERE nombre = p_nombre AND idProducto = p_idProducto and idPresentacion != p_idPresentacion);
                
			IF (@contadorInsert) > 0 THEN
				SELECT 0 AS 'respuesta';
			ELSE                     
				UPDATE PRESENTACION 
					SET nombre = p_nombre, cantidad = p_cantidad, idUnidadMedida = p_idUnidadMedida						
                WHERE idPresentacion = p_idPresentacion;
            
				SELECT 1 AS 'respuesta';
			END	IF;
		ELSE 
			SET @contadorInsert = (SELECT COUNT(*) FROM PRESENTACION WHERE nombre = p_nombre AND idProducto = p_idProducto);
                
			IF (@contadorInsert) > 0 THEN
				SELECT 0 AS 'respuesta';
			ELSE 
				INSERT INTO `PRESENTACION`(
					`idProducto`, nombre, `cantidad`, `idUnidadMedida`, 
					`registro_fecha_add`, `registro_user_add`, registro_pc_add,
					`registro_fecha_update`, `registro_user_update`, registro_pc_update,
					`activo`) 
				VALUES (	
					p_idProducto, p_nombre, p_cantidad, p_idUnidadMedida,
					now(), p_registro_user_add,  "-",
					now(), "-", "-", 1);
            
				SELECT 1 AS 'respuesta';
			END	IF;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM PRESENTACION WHERE nonbre = p_nombre AND idProducto = p_idProducto and idPresentacion != p_idPresentacion);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			            			            
			UPDATE `PRESENTACION` SET
							`nombre` = p_nombre,
							`cantidad` = p_cantidad,                               
                            `idUnidadMedida` = p_idUnidadMedida,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
                            `activo` = p_activo
			WHERE idPresentacion = p_idPresentacion;	            
			           
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM PRESENTACION WHERE nombre = p_nombre AND idProducto = p_idProducto);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE 
			
			            		                
			INSERT INTO `PRESENTACION`(
							`idProducto`,
							`nombre`,
                            `cantidad`,
                            `idUnidadMedida`,
							`registro_fecha_add`,
							`registro_user_add`,
							`registro_pc_add`,
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	
						p_idProducto,
						p_nombre, 
						p_cantidad,  	
                        p_idUnidadMedida,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);           
            
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateProducto` (IN `p_idProducto` INT, IN `p_idClase` INT, IN `p_codigo` VARCHAR(10), IN `p_codigoContable` VARCHAR(8), IN `p_nombre` VARCHAR(50), IN `p_marca` VARCHAR(50), IN `p_modelo` VARCHAR(50), IN `p_medida` VARCHAR(50), IN `p_cod_fab` VARCHAR(50), IN `p_stockMin` DECIMAL(10,2), IN `p_unidad_medida` CHAR(5), IN `p_tipo_existencia` CHAR(5), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int; 
    DECLARE contadorUpdate int;
    DECLARE correlativo int;
    DECLARE cod_clase varchar(50);
    DECLARE abrev_clase char(3);
    DECLARE v_unidadMedida char(5);
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM PRODUCTO WHERE nombre = p_nombre);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @correlativo = (SELECT COUNT(*) FROM PRODUCTO WHERE idClase = p_idClase);
            SET @correlativo = @correlativo + 1;
            
            SET @cod_clase = (SELECT codigo FROM CLASE WHERE idClase = p_idClase);
            
            
            SET p_codigoContable = (
								SELECT cast(codigoContable as UNSIGNED)  + 1 FROM PRODUCTO 
								WHERE substring(codigoContable, 1, 5) = @cod_clase
								ORDER BY codigoContable DESC LIMIT 1);			
            
            SET p_codigo = (	SELECT (CASE WHEN (cast(codigo as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(codigo as UNSIGNED) + 1) )
											 WHEN (cast(codigo as UNSIGNED)  + 1) < 1000000 THEN  (CAST(codigo as UNSIGNED) + 1)
										END)
								FROM PRODUCTO 
								WHERE idClase = p_idClase
								ORDER BY codigo DESC LIMIT 1);
            
            IF p_codigoContable is null THEN
				SET p_codigoContable = (SELECT CONCAT(codigo, '01') FROM CLASE WHERE idClase = p_idClase);
            END IF;
            
            IF p_codigo is null THEN
				SET p_codigo = '000001';
            END IF;
            
			INSERT INTO `PRODUCTO`(
							`idClase`, `codigo`, `codigoContable`,
							`nombre`, `marca`, `modelo`, `medida`, `cod_fab`, `stockMin`, stockActual,
                            `unidad_medida`, `tipo_existencia`,
							`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
							`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
			) 
			VALUES (	
						p_idClase,
                        p_codigo,
                        p_codigoContable,
						p_nombre,
						p_marca,
                        p_modelo,
                        p_medida,
                        p_cod_fab,
                        p_stockMin,
                        0.00,
                        p_unidad_medida,
                        p_tipo_existencia,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);           
            
            SELECT idProducto AS 'respuesta' FROM PRODUCTO ORDER BY idProducto DESC LIMIT 1;
            		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM PRODUCTO WHERE nombre = p_nombre and idProducto != p_idProducto);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE  
			SET @contadorUpdate = (SELECT COUNT(*) FROM PRODUCTO WHERE codigo = p_codigo and idClase = p_idClase and idProducto != p_idProducto);
			IF (@contadorUpdate) > 0 THEN
				SELECT '-1' AS 'respuesta';
			ELSE
				set @v_unidadMedida = (SELECT unidad_medida FROM PRODUCTO WHERE idProducto = p_idProducto);
				IF EXISTS(SELECT idProducto FROM DETALLE_NOTA_ALMACEN 
					WHERE idProducto = p_idProducto) and @v_unidadMedida != p_unidad_medida then					
                    SELECT '-2' AS 'respuesta';					
				ELSE
					UPDATE `PRODUCTO` SET
						`idClase` = p_idClase, `codigo` = p_codigo,  codigoContable = p_codigoContable, 
						`nombre` = p_nombre, marca = p_marca,
						`modelo` = p_modelo, medida = p_medida, cod_fab = p_cod_fab,
						`stockMin` = p_stockMin,
						`unidad_medida` = p_unidad_medida,
						`tipo_existencia` = p_tipo_existencia,
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-',
						`activo` = p_activo
					WHERE idProducto = p_idProducto;	            
						   
					SELECT p_idProducto AS 'respuesta';
					
				END IF;
            END IF;
		END	IF;
	END IF;
END$$

CREATE DEFINER=`targoxco`@`localhost` PROCEDURE `sp_insertUpdateProveedor` (IN `p_idProveedor` INT, IN `p_idRubro` INT, IN `p_idEstado` INT, IN `p_idPais` VARCHAR(2), IN `p_idCiudad` INT, IN `p_nombreEmpresa` VARCHAR(300), IN `p_nombreComercial` VARCHAR(300), IN `p_ruc` VARCHAR(11), IN `p_direccion` VARCHAR(300), IN `p_referencia` VARCHAR(300), IN `p_cuentaInstagram` VARCHAR(300), IN `p_cuentaFacebook` VARCHAR(300), IN `p_telefono1` VARCHAR(12), IN `p_telefono2` VARCHAR(12), IN `p_telefono3` VARCHAR(12), IN `p_email` VARCHAR(50), IN `p_usuario` VARCHAR(50), IN `p_activo` INT)  BEGIN      
    IF EXISTS(SELECT idProveedor FROM PROVEEDOR WHERE ruc = p_ruc and idProveedor != p_idProveedor) THEN
		SELECT 0 as tipoRespuesta, 'Ya existe un proveedor con este ruc.' as respuesta, 0 as idProveedor;
    ELSE
		IF p_idProveedor = 0 THEN
			INSERT INTO PROVEEDOR (idRubro, idEstado, idPais, idCiudad, nombreEmpresa, nombreComercial, ruc, direccion, 
					referencia, cuentaInstagram, cuentaFacebook,
					telefono1, telefono2, telefono3, email,
					usuarioRegistro, fechaRegistro, pcRegistro,  activo )
			VALUES ( p_idRubro, p_idEstado, p_idPais, p_idCiudad, p_nombreEmpresa, p_nombreComercial, p_ruc, p_direccion,
				p_referencia, p_cuentaInstagram, p_cuentaFacebook,
                p_telefono1, p_telefono2, p_telefono3, p_email,
                NOW(), p_usuario, '', 1);
            
			SELECT 1 as tipoRespuesta, 'El proveedor se registró correctamente' as respuesta, last_insert_id() as idProveedor;
        ELSE
			UPDATE PROVEEDOR
            SET 
				idRubro = p_idRubro, idEstado = p_idEstado, idPais = p_idPais, idCiudad = p_idCiudad, 
                nombreEmpresa = p_nombreEmpresa, nombreComercial = p_nombreComercial, ruc = p_ruc, direccion = p_direccion, 
				referencia = p_referencia, cuentaInstagram = p_cuentaInstagram, cuentaFacebook = p_cuentaFacebook,
                telefono1 = p_telefono1, telefono2 = p_telefono2, telefono3 = p_telefono3, 
                email = p_email, usuarioEdicion = p_usuario, fechaEdicion = NOW(), pcEdicion = '-',
                activo = p_activo
            WHERE idProveedor = p_idProveedor;
            
            UPDATE CONTACTO
            SET Activo = 0
            WHERE idProveedor = p_idProveedor;
            
            SELECT 1 as tipoRespuesta, 'El proveedor se editó correctamente' as respuesta, p_idProveedor as idProveedor;
        END IF;
    END IF;
    
    
    -- SELECT  CONCAT(COLUMN_NAME, ','), COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, IS_NULLABLE, COLUMN_DEFAULT
	-- FROM INFORMATION_SCHEMA.COLUMNS	  WHERE table_name = 'PROVEEDOR'  AND table_schema = 'erp_targox';
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateRoles` (IN `p_idRol` INT, IN `p_nombre` VARCHAR(50), IN `p_descripcion` VARCHAR(250), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM ROL WHERE nombre = p_nombre );
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `ROL`(
							`nombre`, 
							`descripcion`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	
						p_nombre, 
						p_descripcion, 
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM ROL WHERE nombre = p_nombre and idRol != p_idRol);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `ROL` SET
							`nombre` = p_nombre, 
							`descripcion` = p_descripcion,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idRol = p_idRol;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateRol_Tarea` (IN `p_idRolTarea` INT, IN `p_idRol` INT, IN `p_idTarea` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM ROL_TAREA WHERE idRol = p_idRol AND idTarea = p_idTarea);
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `ROL_TAREA`(
							`idRol`, 
							`idTarea`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	
						p_idRol, 
						p_idTarea, 
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM ROL_TAREA WHERE idRol = p_idRol AND idTarea = p_idTarea  AND idRolTarea != p_idRolTarea);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `ROL_TAREA` SET
							`idRol` = p_idRol, 
							`idTarea` = p_idTarea,
							`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idRolTarea = p_idRolTarea;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateSubcategoria` (IN `p_idSubcategoria` INT, IN `p_idCategoria` INT, IN `p_nombre` VARCHAR(150), IN `p_descripcion` VARCHAR(250), IN `p_abreviatura` CHAR(5), IN `p_codigo` VARCHAR(50), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
      IF EXISTS (SELECT * FROM SUBCATEGORIA WHERE codigo = p_codigo) THEN
			SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con este código contable.' as respuesta;
		ELSE
	      IF EXISTS (SELECT * FROM SUBCATEGORIA WHERE nombre = p_nombre and idCategoria = p_idCategoria) THEN
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con este nombre.' as respuesta;
			ELSE 
		      IF EXISTS (SELECT * FROM SUBCATEGORIA WHERE abreviatura = p_abreviatura and idCategoria = p_idCategoria) THEN
					SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con esta abreviatura.' as respuesta;
				ELSE  
					INSERT INTO `SUBCATEGORIA`(
									`idCategoria`, `nombre`, `descripcion`, `abreviatura`, codigo,
									`registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
									`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) 
					VALUES (	
								p_idCategoria, p_nombre, p_descripcion, p_abreviatura, p_codigo,
								now(), p_registro_user_add, "-",
								now(), "-", "-", 1 );           
		            
		            SELECT 1 AS 'tipoRespuesta', 'Se guardó correctamente esta Subcategoría.' as respuesta;
				END	IF;
			END	IF;
		END	IF;
    END	IF; 
    
    
    IF p_tipoOperacion = 2 THEN 
		IF EXISTS ( SELECT * FROM SUBCATEGORIA WHERE codigo = p_codigo and idSubcategoria != p_idSubcategoria ) THEN			
			SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con este código contable.' as respuesta;
		ELSE  		
	      IF EXISTS ( SELECT * FROM SUBCATEGORIA WHERE nombre = p_nombre and idSubcategoria != p_idSubcategoria 
																				and idCategoria = p_idCategoria) THEN			
				SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con este nombre.' as respuesta;
			ELSE  		
		      IF EXISTS ( SELECT * FROM SUBCATEGORIA WHERE abreviatura = p_abreviatura and idSubcategoria != p_idSubcategoria 
																			and idCategoria = p_idCategoria) THEN		
					SELECT 0 AS 'tipoRespuesta', 'Ya existe una Subcategoría con esta abreviatura.' as respuesta;
				ELSE  
					UPDATE `SUBCATEGORIA` SET
									`idCategoria` = p_idCategoria, `nombre` = p_nombre, `descripcion` = p_descripcion, 
									`abreviatura` = p_abreviatura, `codigo` = p_codigo,
									`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
									`registro_pc_update` = '-', `activo` = p_activo
					WHERE idSubcategoria = p_idSubcategoria;	            
					           			
					SELECT 1 AS 'tipoRespuesta', 'Se editó correctamente esta Subcategoría.' as respuesta;
				END	IF;
			END	IF;
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateSubservicio` (IN `p_idSubservicio` INT, IN `p_idOrdenServicio` INT, IN `p_trabajo` VARCHAR(300), IN `p_descripcion` VARCHAR(400), IN `p_cantidad` DECIMAL(18,2), IN `p_costoUnitario` DECIMAL(18,2), IN `p_costoTotal` DECIMAL(18,2), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN
            INSERT INTO SUBSERVICIO(
				idOrdenServicio, trabajo, descripcion, cantidad, costoUnitario, costoTotal,
				registro_fecha_add, `registro_user_add`, `registro_pc_add`, 
				registro_fecha_update, `registro_user_update`, `registro_pc_update`,
				activo
			)   
			VALUES (
				p_idOrdenServicio, p_trabajo, p_descripcion, p_cantidad, p_costoUnitario, p_costoTotal,
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);	
			
            SELECT 1 AS respuesta;
	END IF; 
    IF p_tipoOperacion = 2 THEN
			UPDATE SUBSERVICIO
            SET trabajo = p_trabajo, descripcion = p_descripcion, cantidad = p_cantidad, 
				costoUnitario = p_costoUnitario, costoTotal = p_costoTotal,
				registro_fecha_update = now(), registro_user_update = p_registro_user_update
            WHERE idSubservicio = p_idSubservicio;
			
            SELECT 1 AS respuesta;
	END IF;
    IF p_tipoOperacion = 3 THEN
			SELECT SS.idSubservicio, SS.idOrdenServicio, SS.trabajo, SS.descripcion, 
					SS.cantidad, SS.costoUnitario, SS.costoTotal, OS.estado
			FROM SUBSERVICIO SS
            INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = SS.idOrdenServicio 
            WHERE SS.idOrdenServicio = p_idOrdenServicio;            
	END IF;
    IF p_tipoOperacion = 4 THEN
			SELECT idSubservicio, idOrdenServicio, trabajo, descripcion, cantidad, costoUnitario, costoTotal
			FROM SUBSERVICIO WHERE idSubservicio = p_idSubservicio;            
	END IF;
    IF p_tipoOperacion = 5 THEN
			DELETE FROM SUBSERVICIO WHERE idSubservicio = p_idSubservicio;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateTareas` (IN `p_idTarea` INT, IN `p_idGrupo` INT, IN `p_nombre` VARCHAR(50), IN `p_descripcion` VARCHAR(250), IN `p_url` VARCHAR(150), IN `p_icono` VARCHAR(50), IN `p_orden` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
	IF p_tipoOperacion = 1 THEN 
		SET @contadorInsert = (SELECT COUNT(*) FROM TAREA WHERE nombre = p_nombre );
        IF (@contadorInsert) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE                            
			INSERT INTO `TAREA`(
							`idGrupo`,
							`nombre`, 
							`descripcion`, 
                            `url`, 
							`icono`, 
							`orden`, 
							`registro_fecha_add`, 
							`registro_user_add`, 
							`registro_pc_add`, 
							`registro_fecha_update`,
							`registro_user_update`, 
							`registro_pc_update`,
							`activo`
			) 
			VALUES (	p_idGrupo,
						p_nombre, 
						p_descripcion, 
                        p_url,
						p_icono, 
						p_orden,
						now(),
						p_registro_user_add, 
						"-",
						now(),
						"-",
						"-",
						1
			);
            SELECT 1 AS 'respuesta';
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdate = (SELECT COUNT(*) FROM TAREA WHERE nombre = p_nombre and idTarea != p_idTarea);
        IF (@contadorUpdate) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE    
			UPDATE `TAREA` SET
							`idGrupo` = p_idGrupo,
							`nombre` = p_nombre, 
							`descripcion` = p_descripcion, 
                            `url` = p_url, 
							`icono` = p_icono, 
														`registro_fecha_update` = now(),
							`registro_user_update` = p_registro_user_update, 
							`registro_pc_update` = '-',
							`activo` = p_activo
			WHERE idTarea = p_idTarea;	
            
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateTasaCambio` (IN `p_idTasaCambio` INT, IN `p_fecha` DATE, IN `p_tipoMoneda` INT, IN `p_precioCompra` DECIMAL(18,3), IN `p_precioVenta` DECIMAL(18,3), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN
	IF p_tipoOperacion = 1 THEN
        IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fecha and tipoMoneda = p_tipoMoneda) THEN
            SELECT 0 AS 'tipoRespuesta', 'Ya se ha registrado una Tasa de Cambio para esta fecha.' as 'respuesta';
        ELSE                          
            INSERT INTO TASA_CAMBIO(
				fecha, tipoMoneda, precioCompra, precioVenta, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `activo`
            ) 
            VALUES (    
				p_fecha, p_tipoMoneda, p_precioCompra, p_precioVenta, now(), p_registro_user_add, "-", 1
            );           
            
            SELECT 1 AS 'tipoRespuesta', 'La Tasa de Cambio se registró correctamente.' as 'respuesta';
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 2 THEN
        IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO 
					WHERE fecha = p_fecha  and tipoMoneda = p_tipoMoneda 
							and idTasaCambio != p_idTasaCambio) THEN
            SELECT 0 AS 'tipoRespuesta', 'Ya se ha registrado una Tasa de Cambio para esta fecha.' as 'respuesta';
        ELSE                          
            UPDATE TASA_CAMBIO 
			SET fecha = p_fecha,
				tipoMoneda = p_tipoMoneda,
				precioCompra = p_precioCompra, precioVenta = p_precioVenta,
				registro_user_update = p_registro_user_update, registro_fecha_update = now(),
                registro_pc_update = '-', activo = p_activo
			WHERE idTasaCambio = p_idTasaCambio;
            
            SELECT 1 AS 'tipoRespuesta', 'La Tasa de Cambio se registró correctamente.' as 'respuesta';
        END IF;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateTrabajador` (IN `p_idTrabajador` INT, IN `p_nombre` VARCHAR(50), IN `p_dni` CHAR(8), IN `p_apePaterno` VARCHAR(50), IN `p_apeMaterno` VARCHAR(50), IN `p_fechaNacimiento` DATE, IN `p_sexo` CHAR(1), IN `p_direccion` VARCHAR(250), IN `p_telefono` VARCHAR(12), IN `p_celular` VARCHAR(9), IN `p_email` VARCHAR(50), IN `p_idTipo` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
    DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    
    IF p_tipoOperacion = 1 THEN 
        SET @contadorInsert = (SELECT COUNT(*) FROM trabajador WHERE dni = p_dni);
        IF (@contadorInsert) > 0 THEN
            SELECT 0 AS 'respuesta';
        ELSE  
            INSERT INTO `trabajador`(
                            `idEmpresa`, 
                            `idOficina`, 
                            `nombre`,
                            `dni`,  
                            `apePaterno`,
                            `apeMaterno`,
                            `fechaNacimiento`,
                            `sexo`,
                            `direccion`,
                            `telefono`,
                            `celular`,
                            `email`,
                            `idTipo`,
                            `registro_fecha_add`, 
                            `registro_user_add`, 
                            `registro_pc_add`, 
                            `registro_fecha_update`,
                            `registro_user_update`, 
                            `registro_pc_update`,
                            `activo`
            ) 
            VALUES (    
                        1,
                        1,
                        p_nombre,
                        p_dni,
                        p_apePaterno,
                        p_apeMaterno,
                        p_fechaNacimiento,
                        p_sexo,
                        p_direccion,
                        p_telefono,
                        p_celular,
                        p_email,
                        p_idTipo,                    
                        now(),
                        p_registro_user_add, 
                        "-",
                        now(),
                        "-",
                        "-",
                        1
            );           
            
            SELECT 1 AS 'respuesta';
        END IF;
    END IF; 
    
    IF p_tipoOperacion = 2 THEN 
        SET @contadorUpdate = (SELECT COUNT(*) FROM trabajador WHERE dni = p_dni and idTrabajador != p_idTrabajador );
        IF (@contadorUpdate) > 0 THEN
            SELECT 0 AS 'respuesta';
        ELSE  
            UPDATE TRABAJADOR SET
                            `dni` =  p_dni,  
                            `nombre` = p_nombre, 
                            `apePaterno` = p_apePaterno, 
                            `apeMaterno` = p_apeMaterno,
                            `fechaNacimiento` = p_fechaNacimiento,
                            `sexo` =  p_sexo,
                            `direccion` = p_direccion,
                            `telefono` = p_telefono,
                            `celular` = p_celular,
                            `email` = p_email,
                            `idTipo` = p_idTipo,                                                     
                            `registro_fecha_update` = now(),
                            `registro_user_update` = p_registro_user_update, 
                            `registro_pc_update` = '-',
                            `activo` = p_activo
            WHERE idTrabajador = p_idTrabajador;              
                       
            SELECT 1 AS 'respuesta';
        END IF;
    END IF;
    IF p_tipoOperacion = 3 THEN 
			set p_idTrabajador = (SELECT idTrabajador FROM USUARIO WHERE idUsuario = p_idTrabajador);
			
            UPDATE TRABAJADOR SET
                            `dni` =  p_dni,  
                            `nombre` = p_nombre, 
                            `apePaterno` = p_apePaterno, 
                            `apeMaterno` = p_apeMaterno,
                            `direccion` = p_direccion,
                            `telefono` = p_telefono,
                            `email` = p_email,                                                   
                            `registro_fecha_update` = now(),
                            `registro_user_update` = p_registro_user_update, 
                            `registro_pc_update` = '-'
            WHERE idTrabajador = p_idTrabajador;              
                       
            SELECT 1 AS 'respuesta';
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateUsuario` (IN `p_idUsuario` INT, IN `p_idTrabajador` INT, IN `p_idRol` INT, IN `p_login` VARCHAR(50), IN `p_pass` VARCHAR(50), IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN  
	DECLARE contadorInsertP int;  
    DECLARE contadorUpdateP int;
    DECLARE contadorInsertU int;  
    DECLARE contadorUpdateU int;
    DECLARE per_id int;
    
	    
	IF p_tipoOperacion = 1 THEN   
		SET @contadorInsertU = (SELECT COUNT(*) FROM USUARIO WHERE login = p_login);
        IF (@contadorInsertU) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE
			    
            INSERT INTO `USUARIO`(
					idTrabajador, `idRol`, `login`, `pass`,
					`registro_fecha_add`, `registro_user_add`, `registro_pc_add`,
					`registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) 
			VALUES  (
					p_idTrabajador, p_idRol, p_login, MD5(p_pass),
					NOW(), 'admin', '', 
					NOW(), '', '', p_activo
			);
                
				SELECT 1 AS 'respuesta';					
		END	IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 
		SET @contadorUpdateU = (SELECT COUNT(*) FROM USUARIO WHERE login = p_login and idUsuario != p_idUsuario);
        IF (@contadorUpdateU) > 0 THEN
			SELECT 0 AS 'respuesta';
		ELSE
			UPDATE `USUARIO` SET
				`idTrabajador` = p_idTrabajador, 
				`idRol` = p_idRol, 
				`login` = p_login, 
								`registro_fecha_update` = now(),
				`registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-',
				`activo` = p_activo
			WHERE idUsuario = p_idUsuario;
            
                
			SELECT 1 AS 'respuesta';
		END	IF;
	END IF;
    
	IF p_tipoOperacion = 3 THEN 
		IF EXISTS(SELECT idUsuario FROM USUARIO WHERE idUsuario = p_idUsuario and pass = MD5(p_login)) THEN
			UPDATE `USUARIO` SET
				pass = md5(p_pass),
				`registro_fecha_update` = now(),
				`registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-'
			WHERE idUsuario = p_idUsuario;            
                
			SELECT 1 AS 'tipoRespuesta', 'Se cambió la contraseña exitosamente.' as respuesta;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 'No se pudo cambiar la contraseña.' as respuesta;
        END IF;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 
		UPDATE USUARIO U, TRABAJADOR T SET
			U.pass = md5(T.dni)
		WHERE U.idUsuario = p_idUsuario AND U.idTrabajador = T.idTrabajador;
                
		SELECT 1 AS 'tipoRespuesta', 'Se reseteó la contraseña correctamente.' as respuesta;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateVehiculo` (IN `p_idUnidad` INT, IN `p_placa` VARCHAR(20), IN `p_descripcion` VARCHAR(300), IN `p_idTipo` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN     
        
	IF p_tipoOperacion = 1 THEN
        SET @contadorInsert = (SELECT COUNT(*) FROM UNIDAD_MOVIL WHERE placa = p_placa);
        IF (@contadorInsert) > 0 THEN
            SELECT 0 AS 'respuesta';
        ELSE  
                        
            INSERT INTO `UNIDAD_MOVIL`(
                            `placa`, `descripcion`, `tipo`,
                            `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, 
                            `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`
            ) 
            VALUES (    
                        p_placa, p_descripcion, p_idTipo,
                        now(), p_registro_user_add, "-",
                        now(), "-", "-", 1
            );           
            
            SELECT 1 AS 'respuesta';
        END IF;
    END	IF; 
        
    IF p_tipoOperacion = 2 THEN
        SET @contadorInsert = (SELECT COUNT(*) FROM UNIDAD_MOVIL WHERE placa = p_placa and idUnidad != p_idUnidad);
        IF (@contadorInsert) > 0 THEN
            SELECT 0 AS 'respuesta';
        ELSE  
            UPDATE `UNIDAD_MOVIL` SET
                placa = p_placa, descripcion = p_descripcion, tipo = p_idTipo, 
                registro_fecha_update = now(), registro_user_update = p_registro_user_update, 
                registro_pc_update = '-', activo = p_activo
            WHERE idUnidad = p_idUnidad;                  
            
            SELECT 1 AS 'respuesta';
        END IF;
    END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_invalidateNotaAlmacen` (IN `p_idNotaAlmacen` INT, IN `p_usuario` VARCHAR(50))  BEGIN 
	-- UPDATE PRODUCTO P, (SELECT NA.tipoNota, DNA.idProducto, SUM(cantidadTotal) cantidad
		-- FROM NOTA_ALMACEN NA 
		-- INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
		-- WHERE NA.idNotaAlmacen = p_idNotaAlmacen AND NA.estado = 'C'
		-- GROUP BY NA.tipoNota, DNA.idProducto) DNA
    -- SET
		-- P.stockActual = CASE WHEN P.stockActual + (CASE WHEN DNA.tipoNota = 'E' THEN -1 ELSE 1 END)*DNA.Cantidad < 0 THEN 0
			-- ELSE P.stockActual + (CASE WHEN DNA.tipoNota = 'E' THEN -1 ELSE 1 END)*DNA.Cantidad END,		
        -- P.registro_fecha_update = now(),
        -- P.registro_user_update = 'ADMIN',
       -- P.registro_pc_update = '' 
    -- WHERE P.idProducto = DNA.idProducto;
    
    UPDATE PRODUCTO P, (SELECT NA.tipoNota, DNA.idProducto, SUM(cantidadTotal) cantidad
		FROM NOTA_ALMACEN NA 
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
		WHERE NA.idNotaAlmacen = p_idNotaAlmacen AND NA.estado = 'C' and NA.activo = 1 and NA.anulado = 0
		GROUP BY NA.tipoNota, DNA.idProducto) DNA
    SET
		P.stockActual = CASE WHEN P.stockActual + (CASE WHEN DNA.tipoNota = 'E' THEN -1 ELSE 1 END)*DNA.Cantidad < 0 THEN 0
			ELSE P.stockActual + (CASE WHEN DNA.tipoNota = 'E' THEN -1 ELSE 1 END)*DNA.Cantidad END,		
        P.registro_fecha_update = now(),
        P.registro_user_update = 'ADMIN',
        P.registro_pc_update = '' 
    WHERE P.idProducto = DNA.idProducto;
    
    /* ------------------------------------------------------------------------------------------------------------
	   ------------------------      AUMENTAR LA CANTIDAD ACEPTADA DE UNA OC     ----------------------------------
       ------------------------------------------------------------------------------------------------------------
    */
    UPDATE DETALLE_ORDEN DOC, (SELECT NA.tipoNota, NA.idOrdenCompra, DNA.idProducto, SUM(cantidad) cantidad
		FROM NOTA_ALMACEN NA 
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
		WHERE NA.idNotaAlmacen = p_idNotaAlmacen AND NA.estado in ('A', 'C') and NA.activo = 1 and NA.anulado = 0
		GROUP BY NA.tipoNota, NA.idOrdenCompra, DNA.idProducto) DNA
    SET
		DOC.cantidadAceptada = 
			CASE 
				WHEN DOC.cantidadAceptada - DNA.Cantidad < 0 THEN 0
				ELSE DOC.cantidadAceptada - DNA.Cantidad 
			END,		
        DOC.registro_fecha_update = now(),
        DOC.registro_user_update = 'ADMIN',
        DOC.registro_pc_update = ''
    WHERE DOC.idOrdenCompra = DNA.idOrdenCompra and DOC.idProducto = DNA.idProducto;
    
    
    /* ------------------------------------------------------------------------------------------------------------
	   ------------------------      AUMENTAR LA CANTIDAD ACEPTADA DE UNA OTM     ---------------------------------
       ------------------------------------------------------------------------------------------------------------
    */
    
    UPDATE DETALLE_ORDEN_MANTENIMIENTO DOM, (SELECT NA.tipoNota, NA.idOrdenMantenimiento, DNA.idProducto, SUM(cantidad) cantidad
											FROM NOTA_ALMACEN NA 
											INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
											WHERE NA.idNotaAlmacen = p_idNotaAlmacen AND NA.estado in ('A', 'C') 
												and NA.activo = 1 and NA.anulado = 0 AND DNA.activo = 1 AND DNA.anulado = 0
											GROUP BY NA.tipoNota, NA.idOrdenMantenimiento, DNA.idProducto) DNA
    SET
		DOM.cantidadConsumida = 
			CASE 
				WHEN DOM.cantidadConsumida - DNA.Cantidad < 0 THEN 0
				ELSE DOM.cantidadConsumida - DNA.Cantidad 
			END,		
        DOM.registro_fecha_update = now(),
        DOM.registro_user_update = 'ADMIN',
        DOM.registro_pc_update = ''
    WHERE DOM.idOrdenMantenimiento = DNA.idOrdenMantenimiento and DOM.idProducto = DNA.idProducto;
	
    
    /* ------------------------------------------------------------------------------------------------------------
	   ------------------------      AUMENTAR LA CANTIDAD ACEPTADA DE UNA OS     ----------------------------------
       ------------------------------------------------------------------------------------------------------------
    */
    
    UPDATE DETALLE_ORDEN_SERVICIO DOS, (SELECT NA.tipoNota, NA.idOrdenServicio, DNA.idProducto, SUM(cantidad) cantidad
										FROM NOTA_ALMACEN NA 
										INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
										WHERE NA.idNotaAlmacen = p_idNotaAlmacen AND NA.estado in ('A', 'C') 
											AND NA.activo = 1 and NA.anulado = 0 AND DNA.activo = 1 AND DNA.anulado = 0
										GROUP BY NA.tipoNota, NA.idOrdenServicio, DNA.idProducto) DNA
    SET
		DOS.cantidadConsumida = 
			CASE 
				WHEN DOS.cantidadConsumida - DNA.Cantidad < 0 THEN 0
				ELSE DOS.cantidadConsumida - DNA.Cantidad 
			END,		
        DOS.registro_fecha_update = now(),
        DOS.registro_user_update = 'ADMIN',
        DOS.registro_pc_update = ''
    WHERE DOS.idOrdenServicio = DNA.idOrdenServicio and DOS.idProducto = DNA.idProducto;
    
    UPDATE DETALLE_NOTA_ALMACEN
	SET 
		activo = 0,
		anulado = 1,
		estado = 'AN',
        registro_fecha_update = now(),
        registro_user_update = 'ADMIN',
        registro_pc_update = ''     
    WHERE idNotaAlmacen = p_idNotaAlmacen and activo = 1 and anulado = 0;
    
    UPDATE NOTA_ALMACEN
	SET 
		activo = 0,
		anulado = 1,
		estado = 'AN',
        registro_fecha_update = now(),
        registro_user_update = 'ADMIN',
        registro_pc_update = ''     
    WHERE idNotaAlmacen = p_idNotaAlmacen and activo = 1 and anulado = 0;    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarDocumentosVenta` (IN `p_idDocumentoVenta` INT, IN `p_fechaInicio` DATE, IN `p_fechaFin` DATE, IN `p_estado` VARCHAR(2), IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 
		THEN         
			SELECT
					DV.id,
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
					DATE(DV.fecha_registro) AS fecha_registro,
					DATE(DV.fecha_emision) AS fecha_emision,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes,
					DV.monto_total_interes,
					DV.estado,
					M3.descripcion AS estado_descripcion
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN MULTITABLA M3
						ON M3.abrev = DV.estado 
						AND M3.dep_id = 25
						AND M3.activo = 1
			WHERE	(p_estado = '0' OR p_estado = DV.estado)
					AND (p_fechaInicio = '' OR p_fechaInicio <= DATE(DV.fecha_registro))
					AND (p_fechaFin = '' OR p_fechaFin >= DATE(DV.fecha_registro))
                    AND DV.activo = 1
			ORDER BY DV.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 
		THEN  
			SELECT
					id,
					idCliente,
					idTipoDocumento,
					idMoneda,
					idFormaPago,
					idMedioPago,
					idCanal,
					correlativo,
					DATE(fecha_emision) AS fecha_emision,
					serie,
					numero,
                    tasa_cambio,
                    igv,
					monto_subtotal,
					monto_igv_total,
					monto_total,
					monto_interes,
					monto_total_interes,
					DATE(fecha_registro) AS fecha_registro,
					estado
			FROM 	DOCUMENTO_VENTA
			WHERE 	id = p_idDocumentoVenta;
    END	IF; 
    
    IF p_tipoOperacion = 3 
		THEN  
			SELECT
					DDV.id,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
    
    IF p_tipoOperacion = 4
		THEN  
			SELECT
					CPV.id,
					CPV.capital_cuota AS capitalCuota,
                    CPV.cuota,
                    DATE(CPV.fecha_pago_cuota) AS fechaPago,
                    CPV.importe_cuota AS importeCuota,
                    CPV.interes_cuota AS interesCuota,
                    FP.interes
			FROM	CRONOGRAMA_PAGO_VENTA CPV
					INNER JOIN DOCUMENTO_VENTA DV
						ON DV.id = CPV.documento_venta_id AND DV.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago AND FP.activo = 1
            WHERE	CPV.documento_venta_id = p_idDocumentoVenta
					AND CPV.activo = 1;
    END	IF;
    
    IF p_tipoOperacion = 5
		THEN  
			SELECT
					DV.id,
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
                    C.documento AS documento_cliente,
                    C.direccion,
                    C.telefono1,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
					DATE_FORMAT(DV.fecha_registro, '%d/%m/%Y') AS fecha_registro,
                    DATE_FORMAT(DV.fecha_emision, '%d/%m/%Y') AS fecha_emision,
                    DV.tasa_cambio,
                    DV.igv,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes,
					DV.monto_total_interes,
					DV.estado,
                    FP.nombre AS forma_pago_descripcion,
                    DV.serie,
                    DV.numero
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago
                        AND FP.activo = 1
			WHERE	DV.id = p_idDocumentoVenta;
    END	IF;
    
    IF p_tipoOperacion = 6
		THEN  
			SELECT
					DDV.id,
                    P.codigo AS codigoProducto,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
   
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarProductos` (IN `p_idProducto` INT, IN `p_idCategoria` INT, IN `p_idSubcategoria` INT, IN `p_idClase` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN    
    
		SELECT  
				P.idProducto,            
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase',
                P.stockActual as stock,
                P.valor_unitario,
                P.precio_unitario,
                P.igv_unitario,
				P.marca,
				P.modelo,
				P.cod_fab,
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
                M.descripcion AS unidad_medida_descripcion
		FROM 	PRODUCTO P
				INNER JOIN CLASE C 
					ON C.idClase = P.idClase 
                    and (C.idClase = p_idClase or '0' = p_idClase)
				INNER JOIN SUBCATEGORIA S 
					ON S.idSubcategoria = C.idSubcategoria 
                    and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
				INNER JOIN CATEGORIA CA 
					ON CA.idCategoria = S.idCategoria and ( CA.idCategoria = p_idCategoria or'0' = p_idCategoria)
				INNER JOIN MULTITABLA M 
					ON M.dep_id = 3 AND P.unidad_medida = M.abrev
        WHERE 	P.anulado = 0
				and P.activo = 1
		ORDER BY P.nombre;
        
    END	IF; 
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarCategorias` (IN `p_idCategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idCategoria,
            nombre,
            descripcion,
            abreviatura,
            codigo,
            (CASE WHEN activo = 1 THEN 'SI'
				WHEN activo = 0 THEN 'NO'
			END) AS activo
		FROM CATEGORIA
		ORDER BY nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idCategoria,
            nombre,
            descripcion,
            abreviatura,
            codigo,
            activo
		FROM CATEGORIA
        WHERE activo = 1
		ORDER BY nombre;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idCategoria,
            nombre,
            descripcion,            
            abreviatura,
            codigo,
            activo
		FROM CATEGORIA
        WHERE idCategoria = p_idCategoria;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarClases` (IN `p_idClase` INT, IN `p_idSubcategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			C.idClase,            
			C.idSubcategoria,
            S.nombre as 'subcategoria',
            C.nombre,
            C.descripcion,
            C.abreviatura,
            C.codigo,
            (CASE WHEN C.activo = 1 THEN 'SI'
				WHEN C.activo = 0 THEN 'NO'
			END) AS activo
		FROM CLASE C
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
		ORDER BY C.nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			C.idClase,            
			C.idSubcategoria,
            S.nombre as 'subcategoria',
            C.nombre,
            C.descripcion,
            C.abreviatura,
            C.codigo,
            C.activo
		FROM CLASE C
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        WHERE C.activo = 1
		ORDER BY C.nombre;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			C.idClase,            
			C.idSubcategoria,
            S.idCategoria,
                       C.nombre,
            C.descripcion,
            C.abreviatura,
            C.codigo,
            C.activo
		FROM CLASE C
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        WHERE C.idClase = p_idClase;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		SELECT 
			C.idClase,    
            CA.idCategoria,
			C.idSubcategoria,
            S.nombre as 'subcategoria',            
            C.nombre,
            C.descripcion,
            C.abreviatura,
            C.codigo,
            C.activo
		FROM CLASE C
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
        WHERE C.idSubcategoria = p_idSubcategoria and C.activo = 1;
	END IF;
    
    
    
    IF p_tipoOperacion = 5 THEN 	  		SELECT 
			C.idClase,    
            CA.idCategoria,
			C.idSubcategoria,
            S.nombre as 'subcategoria',            
            C.nombre,
            C.descripcion,
            C.abreviatura,
            C.codigo,
            C.activo
		FROM CLASE C
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria OR '0' = p_idSubcategoria)
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
        WHERE C.activo = 1;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarCompra` (IN `p_idCompra` INT, IN `p_idOrdenCompra` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN   
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN
		SELECT
			C.idCompra,            
            CONCAT('CM-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.igv2,
            C.total,            
            C.fechaEnvio as 'fechaEnvio',
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvioFormato',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COMPRA C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
		ORDER BY C.correlativo ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  		
		SELECT
			C.idCompra,            
            CONCAT('CM-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,            
            C.igv2,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%m/%d/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%m/%d/%Y') as 'fechaAceptada',            
            C.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COMPRA C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE C.activo = 1
		ORDER BY C.correlativo ASC;
	END IF;
       
    IF p_tipoOperacion = 3 THEN  			
		SELECT
			C.idCompra,                
            CONCAT('CM-', C.correlativo) as correlativo,
            C.idProveedor,    			
            P.nombreEmpresa,               
            C.subTotal,
            C.igv,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%m/%d/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%m/%d/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion
		FROM COMPRA C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = C.estado
        WHERE C.idCompra = p_idCompra;
	END IF;
        
    IF p_tipoOperacion = 4 THEN     		
		SELECT
			C.idCompra,            
            CONCAT('CM-', C.correlativo) as correlativo,
            C.idProveedor,
			P.nombreEmpresa,
            P.direccion,
            P.email,
            C.subTotal,
            C.igv,
            C.igv2,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion,
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COMPRA C
		INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON ( M.abrev = C.estado and M.dep_id = 5)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE C.idCompra = p_idCompra;
	END IF;
    
    IF p_tipoOperacion = 5 THEN  			
		SELECT
			C.idCompra,
            CONCAT('CM-', C.correlativo) as correlativo,
            CONCAT(C.serieDocumento, '-', C.numeroDocumento) as documento,
            C.serieDocumento as serieDocumento,
            C.numeroDocumento as numeroDocumento,
            C.idProveedor,
            PV.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.igv2,
            C.total,
            C.fechaEnvio,
            date(C.fechaEnvio) as fechaEnvioDate,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvioFormato',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COMPRA C
        INNER JOIN DETALLE_COMPRA DC ON DC.idCompra = C.idCompra
        INNER JOIN PRODUCTO PR ON PR.idProducto = DC.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = C.estado
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 
			AND (C.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%')
                OR PV.nombreEmpresa LIKE concat('%', p_busqueda, '%')
                OR CONCAT(C.serieDocumento, '-', C.numeroDocumento) LIKE concat('%', p_busqueda, '%'))
			AND (C.estado = p_estado or p_estado = '0') 
            AND C.fechaEnvio BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP BY C.idCompra
        ORDER BY C.estado DESC, C.correlativo DESC;  
	END IF;
    
    IF p_tipoOperacion = 6 THEN
		 SELECT
			C.idCompra,			
			CASE WHEN C.correlativo = '' THEN '' 
				ELSE CONCAT('CM-', C.correlativo)
			END AS correlativo,
            C.correlativo as correlativo2,
            C.idOrdenMantenimiento,
            CASE WHEN OTM.correlativo is null THEN '-'
				ELSE CONCAT('OTM-', OTM.correlativo)
			END as correlativoOTM,
            C.idOrdenServicio,
            CASE WHEN OS.correlativo is null THEN '-'
				ELSE CONCAT('OS-', OS.correlativo)
			END as correlativoOS,
            CASE WHEN OTM.idUnidad is not null then UM1.placa
				WHEN OS.idUnidad is not null then UM2.placa
				ELSE '-' 
            END as placa,
            CASE WHEN C.idDestino is null THEN  CASE WHEN OTM.idUnidad is not null then UM1.placa
													WHEN OS.idUnidad is not null then UM2.placa
													ELSE '-' 
												END
				WHEN C.idDestino = 2 THEN UM3.placa ELSE M5.descripcion END as destino,
            C.codCotizacion,
            C.idProveedor,
			C.nombreProveedor,
            C.rucProveedor,
            C.direccionProveedor,
            C.telefonoProveedor,
            C.emailProveedor,
            C.lugarAtencion,
            M4.descripcion as desTipoDocumento,
            CONCAT(C.serieDocumento, '-', C.numeroDocumento) as documento,
            C.subTotal,
            C.descuento,
            C.igv,
            C.igv2,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaEntrega, '%d/%m/%Y') as 'fechaEntrega',
            C.estado,
            M.descripcion,
            M2.descripcion as 'formaPago',
            M3.descripcion as 'moneda',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COMPRA C
        LEFT JOIN UNIDAD_MOVIL UM3 ON UM3.idUnidad = C.idUnidad
        LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = C.idOrdenMantenimiento
        LEFT JOIN UNIDAD_MOVIL UM1 ON UM1.idUnidad = OTM.idUnidad
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = C.idOrdenServicio
        LEFT JOIN UNIDAD_MOVIL UM2 ON UM2.idUnidad = OS.idUnidad        
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado AND M.dep_id = 17)
        INNER JOIN MULTITABLA M2 ON (M2.abrev = C.formaPago AND M2.dep_id = 8)
        INNER JOIN MULTITABLA M3 ON (M3.valor = C.idTipoMoneda AND M3.dep_id = 20)
        INNER JOIN MULTITABLA M4 ON (M4.abrev = C.tipoDocumento AND M4.dep_id = 15)
        LEFT JOIN MULTITABLA M5 ON (M5.valor = C.idDestino AND M5.dep_id = 21)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE C.idCompra = p_idCompra;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarCotizacion` (IN `p_idCotizacion` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN 
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN  		
		SELECT
			C.idCotizacion,            
            CONCAT('CT-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
		ORDER BY C.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  
		SELECT
			C.idCotizacion,            
            CONCAT('CT-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        WHERE C.activo = 1
		ORDER BY C.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN  		
		SELECT
			C.idCotizacion,  
			C.idGrupoCotizacion, 
            PV.nombreEmpresa, 
            CONCAT('CT-', C.correlativo) as correlativo,
            C.subTotal,
            C.igv2,
            C.total,
            (CASE WHEN C.fechaEnvio IS NULL THEN '-' 
				ELSE DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvioFormato',
            C.fechaEnvio as 'fechaEnvio',
            (CASE WHEN C.fechaAceptada IS NULL THEN '-' 
				ELSE DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') 
			END )as 'fechaAceptada',
            C.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COTIZACION C
        INNER JOIN DETALLE_COTIZACION DC ON DC.idCotizacion = C.idCotizacion
        INNER JOIN PRODUCTO PR ON PR.idProducto = DC.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = C.estado
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 
			AND (C.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%')
                OR PV.nombreEmpresa LIKE concat('%', p_busqueda, '%'))
			AND (C.estado = p_estado or p_estado = '0') 
            AND C.fechaEnvio BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP BY C.idCotizacion
        ORDER BY FIELD(C.estado, 'AN') ASC, C.estado DESC, C.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 4 THEN  		
		SELECT
			C.idCotizacion,                      CONCAT('CT-', C.correlativo) as correlativo,
            C.idProveedor,                
            P.nombreEmpresa,              
            C.subTotal,                
            C.igv2,                    C.total,                       
            DATE_FORMAT(C.fechaEnvio, '%m/%d/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%m/%d/%Y') as 'fechaAceptada',             C.estado,
            M.descripcion,
            C.codCotizacion,             round(SUM( DC.valorVentaA), 2) as 'subTotalOC',              round(SUM( DC.descuentoTotalA), 2) as 'descuentoOC',              round(SUM( DC.montoA - DC.valorVentaA + DC.descuentoTotalA ), 2) as 'igvOC',             SUM( DC.montoA) as 'totalOC',             C.igv as 'igvPorcentaje'
		FROM COTIZACION C
        INNER JOIN DETALLE_COTIZACION DC ON DC.idCotizacion = C.idCotizacion
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        WHERE C.idCotizacion = p_idCotizacion
        GROUP BY C.idCotizacion;
	END IF;
    
	IF p_tipoOperacion = 5 THEN  		
		SET @id = (SELECT idCotizacion FROM COTIZACION ORDER BY idCotizacion DESC LIMIT 1);
        
        IF @id is null then
			SET @id = 0;
		END IF;
            
		SET @id = @id + 1;
        SET @cor = CONCAT('C-', CONVERT(@id, CHAR(5)));
        
		SELECT @cor AS 'respuesta';    
	END IF;
    
    IF p_tipoOperacion = 6 THEN        		SELECT
			C.idCotizacion,            
            CONCAT('CT-', C.correlativo) as correlativo,
            ifnull(C.correlativo, '-') as correlativo2,
            C.codCotizacion,
            C.idProveedor,
			C.nombreProveedor,
            C.rucProveedor,
            C.direccionProveedor,
            C.telefonoProveedor,
            C.emailProveedor,
            C.subTotal,
            C.descuento,
            C.igv,
            C.igv2,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion,
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE C.idCotizacion = p_idCotizacion;
	END IF;
    
    IF p_tipoOperacion = 7 THEN          
		SELECT
			C.idCotizacion,            
            CONCAT('CT-', C.correlativo) as correlativo,
            ifnull(C.correlativo, '-') as correlativo2,
            C.codCotizacion,
            C.idProveedor,
			C.nombreProveedor,
            C.rucProveedor,
            C.direccionProveedor,
            C.telefonoProveedor,
            C.emailProveedor,
            C.subTotal,
            C.descuento,
            C.igv,
            C.igv2,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion,
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador        
        WHERE C.idGrupoCotizacion = p_idCotizacion;
	END IF;
		
	IF p_tipoOperacion = 8 THEN  		
		SELECT
			C.idCotizacion,  
			C.idGrupoCotizacion, 
            PV.nombreEmpresa, 
            CONCAT('CT-', C.correlativo) as correlativo,
            C.subTotal,
            C.igv2,
            C.total,
            (CASE WHEN C.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            (CASE WHEN C.fechaAceptada IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') 
			END )as 'fechaAceptada',
            C.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM COTIZACION C
        INNER JOIN MULTITABLA M ON M.abrev = C.estado
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN USUARIO U ON U.login = C.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 
			AND ( (C.correlativo LIKE concat('%', p_busqueda, '%'))
					OR (PV.nombreEmpresa LIKE concat('%', p_busqueda, '%')) 
                    OR (CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')) 
			)
            AND C.estado = 'EN'            
		ORDER BY C.correlativo DESC;   
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaCompra` (IN `p_idDetalleCompra` INT, IN `p_idCompra` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN   				
		SELECT 
			DC.idDetalleCompra,
			DC.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			C.idCompra,
			C.correlativo,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
			DC.idProveedor,
			PV.nombreEmpresa,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
            DC.cantidadRechazada,
            DC.cantidadReenviada,
			DC.monto,
            DC.montoA,
			DC.cantidadTotal,         
            DC.cantidadTotalA,   
			DC.urgencia,
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COMPRA DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN COMPRA C ON C.idCompra = DC.idCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = DC.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = DC.urgencia AND M.dep_id = 6)
		WHERE DC.idCompra = p_idCompra AND DC.estado in ('P', 'EN')
			AND DC.cantidad>(DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada)
		ORDER BY DC.idDetalleCompra ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   		
		SELECT 
			DC.idDetalleCompra,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada'  
		FROM DETALLE_COMPRA DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		WHERE DC.idCompra = p_idCompra AND DC.estado in ('P', 'EN')
			AND DC.cantidad>(DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada)
		ORDER BY DC.idDetalleCompra ASC;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   		
		SELECT 
			DC.idDetalleCompra,
			DC.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			C.idCompra,
			C.correlativo,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
			DC.idProveedor,
			PV.nombreEmpresa,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
            DC.cantidadRechazada,
            DC.cantidadReenviada,
			DC.monto,
            DC.montoA,
			DC.cantidadTotal,         
            DC.cantidadTotalA,   
			DC.urgencia,
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COMPRA DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN COMPRA C ON C.idCompra = DC.idCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = DC.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = DC.urgencia AND M.dep_id = 6)
		WHERE DC.idCompra = p_idCompra and OD.estado in ('P','C')
				AND OD.cantidadAceptada > 0
		ORDER BY OD.idDetalleCompra ASC;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN   		
		SELECT 
			DC.idDetalleCompra,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            DC.cantidadAceptada,
            DC.cantidadRechazada,
            DC.cantidadReenviada,
            M.descripcion AS 'descripEstado'
		FROM DETALLE_COMPRA DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = DC.estado AND M.dep_id = 7)
		WHERE DC.idCompra = p_idCompra and DC.estado in ('P','C')
		ORDER BY DC.idDetalleCompra ASC;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN   			-- IMPRIMIR DETALLE DE LA COMPRA
		SELECT 
			DC.idDetalleCompra,
			C.idCompra,
			C.correlativo,
			DC.idProducto,
			CONCAT(CL.abreviatura, '-', P.codigo) AS 'codigoProducto',
			DC.nombreProducto,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
            DC.valorUnitario,
            DC.valorUnitarioA,
            DC.descuentoUnitario,
            DC.descuentoUnitarioA,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
			DC.valorVenta,
            DC.valorVentaA,
            DC.descuentoTotal,
            DC.descuentoTotalA,
            DC.monto,
            DC.montoA,
			DC.cantidadTotal,         
            DC.cantidadTotalA,   
			DC.urgencia,
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadOrdenada' ,
            -- DC.unidadMedida,
            
            CASE WHEN PR.nombre = '-' then DC.unidadMedida
				else PR.nombre end as unidadMedida,
			DC.urgencia,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COMPRA DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN COMPRA C ON C.idCompra = DC.idCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        INNER JOIN MULTITABLA M ON M.abrev = DC.urgencia
		WHERE DC.idCompra = p_idCompra AND M.dep_id = 6 
		ORDER BY DC.idDetalleCompra ASC;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaCotizacion` (IN `p_idDetalleCotizacion` INT, IN `p_idCotizacion` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN   		
		SELECT 
			DC.idDetalleCotizacion,
			DC.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			C.idCotizacion,
			C.correlativo,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
			C.idProveedor,
			PV.nombreEmpresa,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
			DC.monto,
            DC.montoA,
			DC.cantidadTotal,         
            DC.cantidadTotalA,   
			DC.urgencia,
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COTIZACION DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN COTIZACION C ON C.idCotizacion = DC.idCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = DC.urgencia
		WHERE DC.idCotizacion = p_idCotizacion AND M.dep_id = 6 AND DC.estado in ('P', 'EN')
			AND DC.cantidad>(DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada)
		ORDER BY DC.idDetalleCotizacion ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   		
		SELECT 
			DC.idDetalleCotizacion,
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada' 
		FROM DETALLE_COTIZACION DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		WHERE DC.idCotizacion = p_idCotizacion AND DC.estado in ('P', 'EN')
			AND DC.cantidad>(DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada)
		ORDER BY DC.idDetalleCotizacion ASC;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   		
		SELECT 
			DC.idDetalleCotizacion,
			DC.idProducto,
            CONCAT(CL.abreviatura, P.codigo) AS 'codigoProducto',
			P.nombre AS 'producto',
			C.idCotizacion,
			C.correlativo,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
			C.idProveedor,
			PV.nombreEmpresa,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
			DC.monto,
            DC.montoA,
			DC.cantidadTotal,         
            DC.cantidadTotalA,
            CONCAT( DC.cantidadTotal, ' ', DC.unidadMedida) as cantidadTotalA2,
			DC.urgencia,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COTIZACION DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN COTIZACION C ON C.idCotizacion = DC.idCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = DC.urgencia
		WHERE DC.idCotizacion = p_idCotizacion AND M.dep_id = 6  and DC.estado in ('P','C')
				AND DC.cantidadAceptada > 0
		ORDER BY DC.idDetalleCotizacion ASC;
    END	IF;
    
    IF p_tipoOperacion = 4 THEN   		
		SELECT 
			DC.idDetalleCotizacion,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            DC.cantidadAceptada,
            DC.cantidadRechazada,
            DC.cantidadReenviada,
            M.descripcion AS 'descripEstado'
		FROM DETALLE_COTIZACION DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        INNER JOIN MULTITABLA M ON M.abrev = DC.estado
		WHERE DC.idCotizacion = p_idCotizacion AND M.dep_id = 7 AND DC.estado in ('P', 'C')
		ORDER BY DC.idDetalleCotizacion ASC;
    END	IF;
    
    IF p_tipoOperacion = 5 THEN   		 -- IMPRIMIR COTIZACION
		SELECT 
			DC.idDetalleCotizacion,
			DC.idProducto,
			CONCAT(CL.abreviatura, '-', P.codigo) AS 'codigoProducto',
			P.nombre AS 'nombreProducto',
			C.idCotizacion,
			C.correlativo,
			DC.idPresentacion,
			PR.nombre AS 'presentacion',
			C.idProveedor,
			PV.nombreEmpresa,
			DC.valorUnitario,
            DC.valorUnitarioA,
			DC.descuentoUnitario,
            DC.descuentoUnitarioA,
			DC.precioUnitario,
            DC.precioUnitarioA,
			DC.cantidad,
            DC.cantidadAceptada,
			DC.valorVenta,
            DC.valorVentaA,
			DC.descuentoTotal,
            DC.descuentoTotalA,
			DC.monto,
            DC.montoA,
            DC.montoR,
			ROUND(	(DC.valorUnitarioA)*DC.cantidad,2 ) as valorTotal,            
            DC.montoA + DC.montoR as montoTotal,
			DC.cantidadTotal,         
            DC.cantidadTotalA,   
            -- DC.unidadMedida,
            
            CASE WHEN PR.nombre = '-' then DC.unidadMedida
				else PR.nombre end as unidadMedida,
			DC.urgencia,
            DC.cantidad - (DC.cantidadAceptada + DC.cantidadRechazada + DC.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_COTIZACION DC
		INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN COTIZACION C ON C.idCotizacion = DC.idCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = DC.urgencia
		WHERE DC.idCotizacion = p_idCotizacion AND M.dep_id = 6
		ORDER BY DC.idDetalleCotizacion ASC;
    END	IF; 
    
    IF p_tipoOperacion = 6 THEN   -- Traer Estado de Cotizacion 		
		SELECT 
			estado
		FROM COTIZACION 
        WHERE idCotizacion = p_idCotizacion;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaGrupoCotizacion` (IN `p_idDetalleGrupo` INT, IN `p_idGrupoCotizacion` INT, IN `p_tipoOperacion` INT)  BEGIN
	IF p_tipoOperacion = 1 THEN   		
		SELECT 
			DG.idDetalleGrupo,
			DG.idProducto,
            P.codigo,
			P.nombre AS 'producto',
			DG.idGrupoCotizacion,
			GC.correlativo AS 'grupoCotizacion',
			DG.idPresentacion,
			PR.nombre AS 'presentacion',
			DG.idProveedorR,
			PVR.nombreEmpresa AS 'proveedorR',
            DG.idProveedorC,
			PVC.nombreEmpresa AS 'proveedorC',
			DG.precioUnitario,
			DG.cantidad,
			DG.monto,
			DG.cantidadTotal,            
			DG.urgencia,
            M.descripcion
		FROM DETALLE_GRUPOCOTIZACION DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DG.idGrupoCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		INNER JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        INNER JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE GC.idGrupoCotizacion = p_idGrupoCotizacion AND M.dep_id = 6
		ORDER BY DG.idDetalleGrupo ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre,
			OD.idProveedor,
			PV.nombreEmpresa,
			OD.precioUnitario,
			OD.cantidad,
			OD.monto,
			OD.urgencia,
			OD.cantidadTotal
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = OD.idProveedor
		WHERE OD.idDetalleOrden = P_idDetalleOrden
		ORDER BY OD.idDetalleOrden ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN
		SELECT 
			DG.idDetalleGrupo, DG.idProducto, P.codigo, P.nombre AS 'producto',
            DG.idGrupoCotizacion, GC.correlativo AS 'grupoOrden', 
            DG.idPresentacion, PR.nombre AS 'presentacion', 
            DG.idProveedorR, (CASE WHEN PVR.nombreEmpresa IS NULL THEN '' ELSE PVR.nombreEmpresa END) AS 'proveedorR',
            DG.idProveedorC, PVC.nombreEmpresa AS 'proveedorC', 
            DG.precioUnitario, DG.cantidad, DG.monto, DG.cantidadTotal, DG.urgencia, M.descripcion,
            PR.cantidad as 'cantidadUnidades'
		FROM DETALLE_GRUPOCOTIZACION DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DG.idGrupoCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		LEFT JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        LEFT JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE DG.idDetalleGrupo = p_idDetalleGrupo AND M.dep_id = 6;
	END IF;
    
    IF p_tipoOperacion = 4 THEN   		
		SELECT 
			DG.idDetalleGrupo,
			DG.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			DG.idGrupoCotizacion,
			GC.correlativo AS 'grupoOrden',
			DG.idPresentacion,
			PR.nombre AS 'presentacion',
			DG.idProveedorR,
			PVR.nombreEmpresa AS 'proveedorR',
            DG.idProveedorC,
			PVC.nombreEmpresa AS 'proveedorC',
			DG.precioUnitario,
			DG.cantidad,
			DG.monto,
			DG.cantidadTotal,            
			DG.urgencia,
            M.descripcion
		FROM DETALLE_GRUPOCOTIZACION DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_COTIZACION GC ON GC.idGrupoCotizacion = DG.idGrupoCotizacion
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		INNER JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        INNER JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE GC.idGrupoCotizacion = p_idGrupoCotizacion AND M.dep_id = 6
		ORDER BY DG.idDetalleGrupo ASC;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN   		
		SELECT DG.idDetalleGrupo, DG.idGrupoCotizacion, DG.idProducto, 
			CONCAT(CL.abreviatura, P.codigo) as codigo, DG.nombreProducto, 
			DG.idPresentacion, DG.nombrePresentacion,
			DG.idProveedorR, DG.nombreProveedorR, DG.idProveedorC, DG.nombreProveedorC,
            DG.precioUnitario, DG.cantidad, DG.monto, DG.cantidadTotal, CONCAT( DG.cantidadTotal, ' ', DG.unidadMedida) as cantidadTotal2,
            DG.idUnidadMedida, DG.unidadMedida,
            DG.urgencia as idUrgencia, M.descripcion as 'urgencia'
        FROM DETALLE_GRUPOCOTIZACION DG
        INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto and DG.idGrupoCotizacion = p_idGrupoCotizacion
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia and M.dep_id = 6        
        ORDER BY DG.idDetalleGrupo ASC;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaGrupoOrden` (IN `p_idDetalleGrupo` INT, IN `p_idGrupoOrden` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN   		SELECT 
			DG.idDetalleGrupo,
			DG.idProducto,
            P.codigo,
			P.nombre AS 'producto',
			DG.idGrupoOrden,
			GO.correlativo AS 'grupoOrden',
			DG.idPresentacion,
			PR.nombre AS 'presentacion',
			DG.idProveedorR,
			PVR.nombreEmpresa AS 'proveedorR',
            DG.idProveedorC,
			PVC.nombreEmpresa AS 'proveedorC',
			DG.precioUnitario,
			DG.cantidad,
			DG.monto,
			DG.cantidadTotal,            
			DG.urgencia,
            M.descripcion
		FROM DETALLE_GRUPO DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_ORDENCOMPRA GO ON GO.idGrupoOrden = DG.idGrupoOrden
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		INNER JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        INNER JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE GO.idGrupoOrden = p_idGrupoOrden AND M.dep_id = 6
		ORDER BY DG.idDetalleGrupo ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre,
			OD.idProveedor,
			PV.nombreEmpresa,
			OD.precioUnitario,
			OD.cantidad,
			OD.monto,
			OD.urgencia,
			OD.cantidadTotal
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
		INNER JOIN PROVEEDOR PV ON PV.idProveedor = OD.idProveedor
		WHERE OD.idDetalleOrden = P_idDetalleOrden
		ORDER BY OD.idDetalleOrden ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 			SELECT 
			DG.idDetalleGrupo,   				DG.idProducto,		 	            P.codigo,			 				P.nombre AS 'producto', 			DG.idGrupoOrden, 					GO.correlativo AS 'grupoOrden', 			DG.idPresentacion,  						PR.nombre AS 'presentacion',  				DG.idProveedorR,    						PVR.nombreEmpresa AS 'proveedorR',              DG.idProveedorC,								PVC.nombreEmpresa AS 'proveedorC',  			DG.precioUnitario,   							DG.cantidad,									DG.monto,										DG.cantidadTotal,            					DG.urgencia,                                    M.descripcion,						            PR.cantidad as 'cantidadUnidades'									FROM DETALLE_GRUPO DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_ORDENCOMPRA GO ON GO.idGrupoOrden = DG.idGrupoOrden
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		INNER JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        INNER JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE DG.idDetalleGrupo = p_idDetalleGrupo AND M.dep_id = 6;
	END IF;
    
    IF p_tipoOperacion = 4 THEN   		SELECT 
			DG.idDetalleGrupo,
			DG.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			DG.idGrupoOrden,
			GO.correlativo AS 'grupoOrden',
			DG.idPresentacion,
			PR.nombre AS 'presentacion',
			DG.idProveedorR,
			PVR.nombreEmpresa AS 'proveedorR',
            DG.idProveedorC,
			PVC.nombreEmpresa AS 'proveedorC',
			DG.precioUnitario,
			DG.cantidad,
			DG.monto,
			DG.cantidadTotal,            
			DG.urgencia,
            M.descripcion
		FROM DETALLE_GRUPO DG
		INNER JOIN PRODUCTO P ON P.idProducto = DG.idProducto
		INNER JOIN GRUPO_ORDENCOMPRA GO ON GO.idGrupoOrden = DG.idGrupoOrden
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = DG.idPresentacion
		INNER JOIN PROVEEDOR PVR ON PVR.idProveedor = DG.idProveedorR
        INNER JOIN PROVEEDOR PVC ON PVC.idProveedor = DG.idProveedorC
        INNER JOIN MULTITABLA M ON M.abrev = DG.urgencia
		WHERE GO.idGrupoOrden = p_idGrupoOrden AND M.dep_id = 6
		ORDER BY DG.idDetalleGrupo ASC;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaNotaAlmacen` (IN `p_idDetaNotaAlmacen` INT, IN `p_idNotaAlmacen` INT, IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN
		SELECT DNA.idProducto, DNA.nombreProducto, 
			concat(C.abreviatura, '-', P.codigo) as codigo, DNA.idUnidadMedida, DNA.unidadMedida,
            SUM(DNA.cantidad) AS cantidad,
            SUM(DNA.cantidadTotal) AS cantidadTotal,
			ifnull( DNA.observacion, '') as observacion, 
            DNA.estado,
            CASE WHEN DNA.estado = 'A' THEN 'ABIERTO'
				WHEN DNA.estado = 'C' THEN 'CERRADO'
                WHEN DNA.estado = 'PC' THEN 'POR COMPRAR'
			END AS estadoDNA, 
            NA.estado as estadoNA
        FROM DETALLE_NOTA_ALMACEN DNA
        INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
        INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
        INNER JOIN CLASE C ON C.idClase = P.idClase
        WHERE NA.idNotaAlmacen = p_idNotaAlmacen
        GROUP BY DNA.idProducto, DNA.nombreProducto;
	END IF; 
    IF p_tipoOperacion = 2 THEN
		SELECT DNA.idProducto, DNA.nombreProducto, 
			concat(C.abreviatura, '-', P.codigo) as codigo, DNA.idUnidadMedida, DNA.unidadMedida, 
            DNA.cantidad, DNA.valorUnitario, DNA.valorVenta,
			ifnull( DNA.observacion, '') as observacion, 
            DNA.estado,
            CASE WHEN DNA.estado = 'A' THEN 'ABIERTO'
				WHEN DNA.estado = 'C' THEN 'CERRADO'
                WHEN DNA.estado = 'PC' THEN 'POR COMPRAR'
			END AS estadoDNA, 
            NA.estado as estadoNA
        FROM DETALLE_NOTA_ALMACEN DNA
        INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen
        INNER JOIN PRODUCTO P ON P.idProducto = DNA.idProducto
        INNER JOIN CLASE C ON C.idClase = P.idClase
        WHERE NA.idNotaAlmacen = p_idNotaAlmacen
        ORDER BY DNA.idDetaNota;
	END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaOrden` (IN `p_idDetalleOrden` INT, IN `p_idOrdenCompra` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN   				
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
			OD.precioUnitario,
            OD.precioUnitarioA,
			OD.cantidad,
            OD.cantidadAceptada,
            OD.cantidadRechazada,
            OD.cantidadReenviada,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,   
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.urgencia AND M.dep_id = 6)
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND OD.estado in ('P', 'EN')
			AND OD.cantidad>(OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   		
		SELECT 
			OD.idDetalleOrden,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadOrdenada',
            OD.valorUnitario,
            OD.descuentoUnitario,
            OD.precioUnitario ,
            (OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)) * OD.precioUnitario as precioTotal
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND OD.estado in ('P', 'EN')
			AND OD.cantidad>(OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)
		ORDER BY OD.idDetalleOrden ASC;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   		
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
            CONCAT(CL.abreviatura, P.codigo) AS 'codigoProducto',
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
			OD.precioUnitario,
            OD.precioUnitarioA,
			OD.cantidad,
            OD.cantidadAceptada,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,
            CONCAT( OD.cantidadTotal, ' ', OD.unidadMedida) as cantidadTotalA2,
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.urgencia AND M.dep_id = 6)
		WHERE OD.idOrdenCompra = p_idOrdenCompra and OD.estado in ('P','C')
				AND OD.cantidadAceptada > 0
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN   		
		SELECT 
			OD.idDetalleOrden,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            OD.cantidadAceptada,
            OD.cantidadRechazada,
            OD.cantidadReenviada,
            M.descripcion AS 'descripEstado'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.estado AND M.dep_id = 7)
		WHERE OD.idOrdenCompra = p_idOrdenCompra and OD.estado in ('P','C')
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN   		
		SELECT 
			OD.idDetalleOrden,
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idProducto,
			CONCAT(CL.abreviatura, P.codigo) AS 'codigoProducto',
			OD.nombreProducto,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
            OD.valorUnitario,
            OD.valorUnitarioA,
            OD.descuentoUnitario,
            OD.descuentoUnitarioA,
			OD.precioUnitario,
            OD.precioUnitarioA,
			OD.cantidad,
            OD.cantidadAceptada,
            OD.valorVenta,
            OD.valorVentaA,
            OD.descuentoTotal,
            OD.descuentoTotalA,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,   
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadOrdenada' ,
                        CASE WHEN PR.nombre = '-' then OD.unidadMedida
				else PR.nombre end as unidadMedida,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON M.abrev = OD.urgencia
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND M.dep_id = 6 
		ORDER BY OD.idOrdenCompra ASC;
    END	IF;
    
    IF p_tipoOperacion = 6 THEN   		SELECT 
			estadoRecepcion
		FROM ORDEN_COMPRA 
        WHERE idOrdenCompra = p_idOrdenCompra;
    END	IF;
    
    IF p_tipoOperacion = 7 THEN   		SELECT 
			DC.idDetalleOrden, DC.idOrdenCompra, DC.idProducto, P.codigo as codigoProducto, DC.nombreProducto, 
            DC.idPresentacion, DC.nombrePresentacion,
            DC.precioUnitario, DC.cantidad, DC.monto, cantidadTotal, CONCAT( DC.cantidadTotal, ' ', DC.unidadMedida) as cantidadTotal2,
            idUnidadMedida, unidadMedida, urgencia
		FROM DETALLE_ORDEN DC
        INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
        WHERE idOrdenCompra = p_idOrdenCompra;	
    END	IF;
    
    IF p_tipoOperacion = 8 THEN   		SELECT 
			DC.idDetalleOrden, DC.idOrdenCompra, DC.idProducto, P.nombre as 'nombreProducto',  
            DC.idPresentacion, PR.nombre as 'nombrePresentacion',             DC.valorUnitario, DC.descuentoUnitario, DC.precioUnitario, DC.cantidad, DC.monto, cantidadTotal,               PR.idUnidadMedida as 'idUnidadMedida', PR.cantidad as 'cantidad_unidades', 
            DC.unidadMedida, DC.urgencia
		FROM DETALLE_ORDEN DC
        INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto	
        INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        WHERE idDetalleOrden = p_idDetalleOrden;		
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaOrdenMantenimiento` (IN `p_idDetaOrdenMantenimiento` INT, IN `p_idOrdenMantenimiento` INT, IN `p_tipoOperacion` INT)  BEGIN 
	DECLARE nFilas int;
	DECLARE v_idDetaNota int;
	DECLARE v_idProducto int;
	DECLARE v_fechaContable datetime;
	DECLARE v_cantidadTotal decimal(18,2);
          
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
	DECLARE v_idNota2 int;
	DECLARE v_idOrdenCompra2 int;
	DECLARE v_fechaContable2 datetime;
	DECLARE v_cantidadTotal2 decimal(18,2);
	
	IF p_tipoOperacion = 1 THEN  		
		SELECT '-' as inventario, DOM.idDetaOrden, DOM.idOrdenMantenimiento, OM.estado as estadoOTM,
            ifnull(date_format(DOM.fechaSalida, '%d/%m/%Y'), '-') as fechaSalida,
			DOM.idOrdenCompra, 
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(concat('OC-', OC.correlativo), '-') END as correlativoOC, 
            DOM.idCompra, 
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				 WHEN DOM.idCompra is not null THEN ifnull(concat('CM-', C.correlativo), '-')
				 ELSE ifnull(concat('NA-', NA.correlativo), '-') END as correlativoC,
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') END as nombreProveedor,
            P.idProducto, P.nombre as descripcion,
			CONCAT(CL.abreviatura, P.codigo) as codigoProducto, DOM.cantidad, DOM.observacion,DOM.estado as estadoDetalle
		FROM DETALLE_ORDEN_MANTENIMIENTO DOM
		INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
		INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOM.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOM.idCompra
        LEFT JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DOM.idNotaAlmacen
		WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento
        ORDER BY DOM.fechaSalida ASC,  DOM.idDetaOrden ASC;
    END	IF; 
    
	IF p_tipoOperacion = 2 THEN
		SELECT '-' as inventario, DOM.idDetaOrden, DOM.idOrdenMantenimiento, OM.estado as estadoOTM,
			DOM.idOrdenCompra, ifnull(OC.correlativo, '-') as correlativoOC, 
            DOM.idCompra, ifnull(C.correlativo, '-') as correlativoC, ifnull(C.nombreProveedor, '-') as nombreProveedor,
            P.idProducto, P.nombre as descripcion,
			P.codigo as codigoProducto, DOM.cantidad, DOM.observacion
		FROM DETALLE_ORDEN_MANTENIMIENTO DOM
		INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
		INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOM.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOM.idCompra
		WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento
        ORDER BY idDetaOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN  		
		SELECT '-' as inventario, DOM.idDetaOrden, DOM.idOrdenMantenimiento, OM.estado as estadoOTM,        
            ifnull(date_format(DOM.fechaSalida, '%d/%m/%Y'), '-') as fechaSalida,
			DOM.idOrdenCompra, ifnull(OC.correlativo, '-') as correlativoOC, 
            DOM.idCompra, 
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				 WHEN DOM.idCompra is not null THEN ifnull(concat('CM-', C.correlativo), '-')
				 ELSE ifnull(concat('NA-', NA.correlativo), '-') END as correlativoC,
            CONCAT(C.serieDocumento, '-', C.numeroDocumento) as comprobante,            
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(C.nombreProveedor, '-') END as nombreProveedor,
            P.idProducto,  P.nombre as nombreProducto,
			CONCAT(CL.abreviatura, P.codigo) as codigoProducto, DOM.cantidad, DOM.observacion
		FROM DETALLE_ORDEN_MANTENIMIENTO DOM
		INNER JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = DOM.idOrdenMantenimiento
		INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOM.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOM.idCompra
        LEFT JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DOM.idNotaAlmacen
		WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento
        ORDER BY DOM.fechaSalida ASC,  DOM.idDetaOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
            
        CREATE TEMPORARY TABLE kardex_temp(            
        SELECT DNA.idDetaNota, DNA.idNotaAlmacen, NA.idOrdenCompra, NA.idOrdenMantenimiento, NA.idOrdenServicio,
				DNA.idProducto, date(NA.fechaContable) as fechaContable,
				DNA.cantidadTotal, 
				0 cantidadUsada,
				NA.tipoNota,
                CASE WHEN NA.tipoNota = 'E' THEN 1 ELSE -1 END AS factor,
                1 as activo, 0 as idNotaUsada, 0 as idOrdenCompraUsada
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
		WHERE  
			-- DNA.idProducto in (32,503, 490) -- 32,503,490,494,3
			DNA.idProducto in (SELECT idProducto FROM DETALLE_ORDEN_MANTENIMIENTO WHERE idOrdenMantenimiento = p_idOrdenMantenimiento)
			and DNA.activo = 1 and DNA.anulado = 0 and NA.activo = 1 and NA.anulado = 0
			and year(NA.fechaContable) = 2020
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc);
        
        CREATE TEMPORARY TABLE kardex_temp2 (
        SELECT * FROM kardex_temp);
                       
		-- select * from kardex_temp;
        
		SET @nFilas = (SELECT count(*) FROM kardex_temp WHERE tipoNota = 'S');
		
        WHILE @nFilas > 0 DO
			SELECT idDetaNota, fechaContable, cantidadTotal, idProducto
			INTO @v_idDetaNota, @v_fechaContable, @v_cantidadTotal, @v_idProducto
			FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
            
			-- SELECT * FROM kardex_temp where idDetaNota = @v_idDetaNota;

            DROP TEMPORARY TABLE IF EXISTS temp_entradas;
            
            CREATE TEMPORARY TABLE temp_entradas (
				SELECT * FROM kardex_temp 
				WHERE fechaContable <= @v_fechaContable and idProducto = @v_idProducto -- AND idDetaNota < @v_idDetaNota
					AND activo = 1 AND tipoNota = 'E'
			);
            
            SET @nFilas2 = (SELECT count(*) FROM temp_entradas WHERE tipoNota = 'E');
            
            -- select * from kardex_temp;
			-- select @v_idDetaNota as idDetaNota, @v_fechaContable as fechaContable, @v_cantidadTotal as cantidadTotal, @v_idProducto, @nFilas2;
            -- SELECT * FROM temp_entradas;
		
			WHILE @nFilas2 > 0 and @v_cantidadTotal > 0 DO                
                SELECT idDetaNota, idNotaAlmacen, idOrdenCompra, fechaContable, cantidadTotal - cantidadUsada
				INTO @v_idDetaNota2, @v_idNota2, @v_idOrdenCompra2, @v_fechaContable2, @v_cantidadTotal2
				FROM kardex_temp WHERE tipoNota = 'E' and activo = 1 and idProducto = @v_idProducto
				ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                                
                -- SELECT @v_idDetaNota2, @v_fechaContable2, @v_cantidadTotal, @v_cantidadTotal2;
                
                IF @v_cantidadTotal <= @v_cantidadTotal2 THEN
					UPDATE kardex_temp SET cantidadUsada = cantidadUsada + @v_cantidadTotal, 
						activo = ( CASE WHEN  @v_cantidadTotal = @v_cantidadTotal2 THEN 0 ELSE 1 END)
					WHERE idDetaNota = @v_idDetaNota2;
                    
                    UPDATE kardex_temp2	
						SET idNotaUsada = @v_idNota2, idOrdenCompraUsada = @v_idOrdenCompra2, activo = 0
					WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    set @v_cantidadTotal = 0;
				ELSE
                    UPDATE kardex_temp2	
						SET idNotaUsada = @v_idNota2, cantidadTotal = @v_cantidadTotal2, idOrdenCompraUsada = @v_idOrdenCompra2, activo = 0
					WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idOrdenCompra, idOrdenMantenimiento, idOrdenServicio, idProducto, 
						fechaContable, cantidadTotal, cantidadUsada, tipoNota, factor, activo, idNotaUsada, idOrdenCompraUsada)                        
                    SELECT idDetaNota, idNotaAlmacen, idOrdenCompra, idOrdenMantenimiento, idOrdenServicio, idProducto,
						fechaContable, @v_cantidadTotal - @v_cantidadTotal2, 0, tipoNota, factor, activo, idNotaUsada, idOrdenCompraUsada
                    FROM kardex_temp
                    WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    
                    UPDATE kardex_temp SET cantidadUsada = cantidadUsada + cantidadTotal , 
						activo = 0
					WHERE idDetaNota = @v_idDetaNota2;
                    
                    set @v_cantidadTotal =  @v_cantidadTotal - @v_cantidadTotal2;
                    -- select * from kardex_temp;
                    -- select * from kardex_temp2;
                    
                END IF;
                
				SET @nFilas2 = @nFilas2 - 1;
            END WHILE;
             
            SET @nFilas = @nFilas - 1;
            UPDATE kardex_temp SET activo = 0 where idDetaNota = @v_idDetaNota;
        END WHILE;
        
        -- select * from kardex_temp;
        -- select * from kardex_temp2; -- where idOrdenMantenimiento = 889;
        
        SELECT OM.idOrdenMantenimiento, 
            P.idProducto,  P.nombre as nombreProducto, CONCAT(CL.abreviatura, P.codigo) as codigoProducto, 
            DOM.cantidad, DOM.observacion, ifnull(KT.cantidadTotal, 0) as cantidadSalida, -- KT.idNotaUsada, KT.idOrdenCompraUsada,
            CASE
				WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				WHEN KT.idNotaAlmacen is null THEN '-'
                ELSE date_format(KT.fechaContable, '%d/%m/%Y')
			END AS fechaSalida,
            CASE
				WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				WHEN NA.idNotaAlmacen is null THEN '-'
				WHEN OC.idOrdenCompra is null  THEN CONCAT('NA-', NA.correlativo)
                WHEN C.idCompra is null  THEN CONCAT('OC-' +  OC.correlativo)
                ELSE CONCAT( C.serieDocumento, '-', C.numeroDocumento)
			END AS correlativoC,
            CASE WHEN DOM.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') 
			END as nombreProveedor,
			C.idCompra, OC.idOrdenCompra, NA.idNotaAlmacen
        FROM ORDEN_MANTENIMIENTO OM
        INNER JOIN DETALLE_ORDEN_MANTENIMIENTO DOM ON DOM.idOrdenMantenimiento = OM.idOrdenMantenimiento
		INNER JOIN PRODUCTO P ON P.idProducto = DOM.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
        LEFT JOIN kardex_temp2 KT ON KT.idOrdenMantenimiento = OM.idOrdenMantenimiento and KT.idProducto = DOM.idProducto
        LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = KT.idOrdenCompraUsada
        LEFT JOIN COMPRA C ON C.idOrdenCompra = OC.idOrdenCompra
        LEFT JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = KT.idNotaUsada
		WHERE OM.idOrdenMantenimiento = p_idOrdenMantenimiento;
        
       -- select * from kardex_temp2;
    END	IF;     
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaOrdenServicio` (IN `p_idDetaOrdenServicio` INT, IN `p_idOrdenServicio` INT, IN `p_tipoOperacion` INT)  BEGIN
	DECLARE nFilas int;
	DECLARE v_idDetaNota int;
	DECLARE v_idProducto int;
	DECLARE v_fechaContable datetime;
	DECLARE v_cantidadTotal decimal(18,2);
            
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
	DECLARE v_idNota2 int;
	DECLARE v_idOrdenCompra2 int;
	DECLARE v_fechaContable2 datetime;
	DECLARE v_cantidadTotal2 decimal(18,2);
            
	IF p_tipoOperacion = 1 THEN
		SELECT '-' as inventario, DOS.idDetaOrden, DOS.idOrdenServicio, OS.estado as estadoOS,
            ifnull(date_format(DOS.fechaSalida, '%d/%m/%Y'), '-') as fechaSalida,
			DOS.idOrdenCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(concat('OC-', OC.correlativo), '-') END as correlativoOC, 
            DOS.idCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(concat('CM-', C.correlativo), '-') END as correlativoC, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') END as nombreProveedor,
            P.idProducto, P.nombre as descripcion,
			CONCAT(CL.abreviatura, P.codigo) as codigoProducto, DOS.cantidad, DOS.observacion, DOS.estado as estadoDetalle
		FROM DETALLE_ORDEN_SERVICIO DOS
		INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
		INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOS.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOS.idCompra
		WHERE DOS.idOrdenServicio = p_idOrdenServicio
        ORDER BY DOS.fechaSalida ASC,  DOS.idDetaOrden ASC;
    END	IF;  
    
	IF p_tipoOperacion = 2 THEN
		SELECT '-' as inventario, DOS.idDetaOrden, DOS.idOrdenServicio, OS.estado as estadoOS,        
            ifnull(date_format(DOS.fechaSalida, '%d/%m/%Y'), '-') as fechaSalida,
				DOS.idOrdenCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.correlativo, '-') END as correlativoOC,
            DOS.idCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE concat( 'CM-', ifnull(C.correlativo, '-')) END as correlativoC, 
                concat( C.serieDocumento,'-',  C.numeroDocumento) as comprobante,
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') END as nombreProveedor,
            P.idProducto,  P.nombre as nombreProducto,
				concat( CL.abreviatura, P.codigo) as codigoProducto, DOS.cantidad, DOS.observacion, DOS.estado as estadoDetalle
		FROM DETALLE_ORDEN_SERVICIO DOS
		INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
		INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
		INNER JOIN CLASE CL ON CL.idClase = P.idClase
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOS.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOS.idCompra
		WHERE DOS.idOrdenServicio = p_idOrdenServicio
        ORDER BY DOS.fechaSalida ASC,  DOS.idDetaOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN   		
		SELECT '-' as inventario, DOS.idDetaOrden, DOS.idOrdenServicio, 
			ifnull(OS.correlativo, '') as correlativoOS,
            OS.estado as estadoOS,   
            ifnull(date_format(DOS.fechaSalida, '%d/%m/%Y'), '-') as fechaSalida,
			PV.nombreEmpresa as nombreProveedorOS,
            IFNULL( DATE_FORMAT(OS.fechaEmision, '%d/%m/%Y'), '-') as fechaEmisionOS, 
				DOS.idOrdenCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.correlativo, '-') END as correlativoOC,
            DOS.idCompra, 
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE concat( 'CM-', ifnull(C.correlativo, '-')) END as correlativoC, concat( C.numeroDocumento,'-',  C.serieDocumento) as comprobante,
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') END as nombreProveedor,
            P.idProducto,  P.nombre as nombreProducto,
				concat( CL.abreviatura, P.codigo) as codigoProducto, DOS.cantidad, DOS.observacion, DOS.estado as estadoDetalle
		FROM DETALLE_ORDEN_SERVICIO DOS
		INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = DOS.idOrdenServicio
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = OS.idProveedor
		INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
		INNER JOIN CLASE CL ON CL.idClase = P.idClase
		LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOS.idOrdenCompra
		LEFT JOIN COMPRA C ON C.idCompra = DOS.idCompra
		WHERE OS.idOrdenMantenimiento = p_idOrdenServicio
        ORDER BY DOS.fechaSalida ASC,  DOS.idDetaOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
            
		CREATE TEMPORARY TABLE kardex_temp(            
            SELECT DNA.idDetaNota, DNA.idNotaAlmacen, NA.idOrdenCompra, NA.idOrdenMantenimiento, NA.idOrdenServicio,
				DNA.idProducto, date(NA.fechaContable) as fechaContable,
				DNA.cantidadTotal, 
				0 cantidadUsada,
				NA.tipoNota,
                CASE WHEN NA.tipoNota = 'E' THEN 1 ELSE -1 END AS factor,
                1 as activo, 0 as idNotaUsada, 0 as idOrdenCompraUsada
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
		WHERE  
			DNA.idProducto in (SELECT idProducto FROM DETALLE_ORDEN_SERVICIO WHERE idOrdenServicio = p_idOrdenServicio)
			and DNA.activo = 1 and DNA.anulado = 0 and NA.activo = 1 and NA.anulado = 0
			and year(NA.fechaContable) = 2020
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc); -- DNA.idDetaNota asc);
        
        CREATE TEMPORARY TABLE kardex_temp2 (
        SELECT * FROM kardex_temp);
        
		SET @nFilas = (SELECT count(*) FROM kardex_temp WHERE tipoNota = 'S');
		
        WHILE @nFilas > 0 DO
			SELECT idDetaNota, fechaContable, cantidadTotal, idProducto
			INTO @v_idDetaNota, @v_fechaContable, @v_cantidadTotal, @v_idProducto
			FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
            
            DROP TEMPORARY TABLE IF EXISTS temp_entradas;
            
            CREATE TEMPORARY TABLE temp_entradas (
				SELECT * FROM kardex_temp 
				WHERE fechaContable <= @v_fechaContable and idProducto = @v_idProducto -- AND idDetaNota < @v_idDetaNota 
					AND activo = 1 AND tipoNota = 'E'
			);
            
            SET @nFilas2 = (SELECT count(*) FROM temp_entradas WHERE tipoNota = 'E');
            
			WHILE @nFilas2 > 0 and @v_cantidadTotal > 0 DO
            
                SELECT idDetaNota, idNotaAlmacen, idOrdenCompra, fechaContable, cantidadTotal - cantidadUsada
				INTO @v_idDetaNota2, @v_idNota2, @v_idOrdenCompra2, @v_fechaContable2, @v_cantidadTotal2
				FROM kardex_temp WHERE tipoNota = 'E' and activo = 1 and idProducto = @v_idProducto
				ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                
                IF @v_cantidadTotal <= @v_cantidadTotal2 THEN
					UPDATE kardex_temp SET cantidadUsada = cantidadUsada + @v_cantidadTotal, 
						activo = ( CASE WHEN  @v_cantidadTotal = @v_cantidadTotal2 THEN 0 ELSE 1 END)
					WHERE idDetaNota = @v_idDetaNota2;
                    
                    UPDATE kardex_temp2	
						SET idNotaUsada = @v_idNota2, idOrdenCompraUsada = @v_idOrdenCompra2, activo = 0
					WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    set @v_cantidadTotal = 0;
				ELSE
                    UPDATE kardex_temp2	
						SET idNotaUsada = @v_idNota2, cantidadTotal = @v_cantidadTotal2, idOrdenCompraUsada = @v_idOrdenCompra2, activo = 0
					WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idOrdenCompra, idOrdenMantenimiento, idOrdenServicio, idProducto, 
						fechaContable, cantidadTotal, cantidadUsada, tipoNota, factor, activo, idNotaUsada, idOrdenCompraUsada)                        
                    SELECT idDetaNota, idNotaAlmacen, idOrdenCompra, idOrdenMantenimiento, idOrdenServicio, idProducto,
						fechaContable, @v_cantidadTotal - @v_cantidadTotal2, 0, tipoNota, factor, activo, idNotaUsada, idOrdenCompraUsada
                    FROM kardex_temp
                    WHERE idDetaNota = @v_idDetaNota and activo = 1;
                    
                    UPDATE kardex_temp SET cantidadUsada = cantidadUsada + cantidadTotal , 
						activo = 0
					WHERE idDetaNota = @v_idDetaNota2;
                    
                    set @v_cantidadTotal =  @v_cantidadTotal - @v_cantidadTotal2;                    
                END IF;
                
				SET @nFilas2 = @nFilas2 - 1;
            END WHILE;
             
            SET @nFilas = @nFilas - 1;
            UPDATE kardex_temp SET activo = 0 where idDetaNota = @v_idDetaNota;
        END WHILE;
        
        SELECT OS.idOrdenServicio, 
            P.idProducto,  P.nombre as nombreProducto, CONCAT(CL.abreviatura, P.codigo) as codigoProducto, 
            DOS.cantidad, DOS.observacion, ifnull(KT.cantidadTotal, 0) as cantidadSalida, -- KT.idNotaUsada, KT.idOrdenCompraUsada,
            CASE
				WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				WHEN KT.idNotaAlmacen is null THEN '-'
                ELSE date_format(KT.fechaContable, '%d/%m/%Y')
			END AS fechaSalida,
            CASE
				WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				WHEN NA.idNotaAlmacen is null THEN '-'
				WHEN OC.idOrdenCompra is null  THEN CONCAT('NA-', NA.correlativo)
                WHEN C.idCompra is null  THEN CONCAT('OC-' +  OC.correlativo)
                ELSE CONCAT( C.serieDocumento, '-', C.numeroDocumento)
			END AS correlativoC,
            CASE WHEN DOS.estado = 'A' THEN 'POR COMPRAR'
				ELSE ifnull(OC.nombreProveedor, '-') END as nombreProveedor,
			C.idCompra, OC.idOrdenCompra, NA.idNotaAlmacen
        FROM ORDEN_SERVICIO OS
        INNER JOIN DETALLE_ORDEN_SERVICIO DOS ON DOS.idOrdenServicio = OS.idOrdenServicio
		INNER JOIN PRODUCTO P ON P.idProducto = DOS.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
        LEFT JOIN kardex_temp2 KT ON KT.idOrdenServicio = OS.idOrdenServicio and KT.idProducto = DOS.idProducto
        LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = KT.idOrdenCompraUsada
        LEFT JOIN COMPRA C ON C.idOrdenCompra = OC.idOrdenCompra
        LEFT JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = KT.idNotaUsada
		WHERE OS.idOrdenServicio = p_idOrdenServicio;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarEmpaque` (IN `p_idEmpaque` INT, IN `p_idProducto` INT, IN `p_idClase` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN  			SELECT 
			E.idEmpaque,            
			E.idClase,
            C.nombre as 'clase',
            E.idEmpaqueM as 'idEmpaqueM',
            M.descripcion as 'empaque',
            E.cantidad,
            E.nombre,
            E.activo
		FROM EMPAQUE E
        INNER JOIN CLASE C ON C.idClase = E.idClase
        INNER JOIN MULTITABLA M ON M.valor = E.idEmpaqueM
        WHERE M.dep_id = 4
		ORDER BY E.cantidad;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 			SELECT 
			E.idEmpaque,            
			E.idClase,
            C.nombre as 'clase',
            E.idEmpaqueM as 'idEmpaqueM',
            M.descripcion as 'empaque',
            E.cantidad,
            E.nombre,
            E.activo
		FROM EMPAQUE E
        INNER JOIN CLASE C ON C.idClase = E.idClase
        INNER JOIN MULTITABLA M ON M.valor = E.idEmpaqueM
        WHERE M.dep_id = 4 and E.activo = 1
		ORDER BY E.cantidad;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 			SELECT 
			E.idEmpaque,            
			E.idClase,
            C.nombre as 'clase',
            E.idEmpaqueM as 'idEmpaqueM',
            M.descripcion as 'empaque',
            E.cantidad,
            E.nombre,            
            (CASE WHEN E.activo = 1 THEN 'SI'
				WHEN E.activo = 0 THEN 'NO'
			END) AS activo
		FROM EMPAQUE E
        INNER JOIN CLASE C ON C.idClase = E.idClase
        INNER JOIN MULTITABLA M ON M.valor = E.idEmpaqueM
        WHERE E.idEmpaque = p_idEmpaque and M.dep_id = 4;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 			SELECT 
			E.idEmpaque,            
			E.idClase,
            C.nombre as 'clase',
            E.idEmpaqueM as 'idEmpaqueM',
            M.descripcion as 'empaque',
            E.cantidad,
            E.nombre,            
            (CASE WHEN E.activo = 1 THEN 'SI'
				WHEN E.activo = 0 THEN 'NO'
			END) AS activo
		FROM EMPAQUE E
        INNER JOIN CLASE C ON C.idClase = E.idClase
        INNER JOIN MULTITABLA M ON M.valor = E.idEmpaqueM
        WHERE E.idClase = p_idClase AND M.dep_id = 4
		ORDER BY E.cantidad;
	END IF;
    
    IF p_tipoOperacion = 5 THEN 			SELECT 
			E.idEmpaque,            
			E.idClase,
            C.nombre as 'clase',
            E.idEmpaqueM as 'idEmpaqueM',
            M.descripcion as 'empaque',
            E.cantidad,
            E.nombre,            
            (CASE WHEN E.activo = 1 THEN 'SI'
				WHEN E.activo = 0 THEN 'NO'
			END) AS activo
		FROM EMPAQUE E
        INNER JOIN CLASE C ON C.idClase = E.idClase
        INNER JOIN MULTITABLA M ON M.valor = E.idEmpaqueM
        WHERE E.activo = 1 AND E.idClase = p_idClase AND M.dep_id = 4       
		ORDER BY E.cantidad;
	END IF;
    
    IF p_tipoOperacion = 6 THEN 			 SELECT 
            PR.idPresentacion,
            PR.nombre
        FROM PRODUCTO P
        INNER JOIN CLASE C ON (C.idClase = P.idClase and C.activo = 1)
        INNER JOIN PRESENTACION PR ON (PR.idClase = C.idClase and PR.activo = 1)
        WHERE P.idProducto = p_idClase;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarFormaPago` (IN `p_idFormaPago` INT, IN `p_activo` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN       
		SELECT 
				FP.id,  
				FP.nombre,
				FP.numero_cuotas,
				FP.tipo_frecuencia_id,
				CONCAT(FP.frecuencia, ' ', MT.descripcion) AS frecuencia,            
				FP.interes,
				FP.activo,
				(CASE WHEN FP.activo = 1 THEN 'SI'
					WHEN FP.activo = 0 THEN 'NO'
				END) AS estado_descripcion,
				FP.registro_fecha_add,
				FP.registro_user_add
		FROM 	FORMA_PAGO FP
				INNER JOIN MULTITABLA MT
					ON MT.dep_id = 24 
                    AND MT.valor = FP.tipo_frecuencia_id 
                    AND MT.activo = 1
                    AND FP.activo in (1, 0)
		WHERE	p_activo = 3 OR p_activo = FP.activo
		ORDER BY FP.id;
    END	IF;  
    
    IF p_tipoOperacion = 2 THEN  
		SELECT 
				id, 
				nombre,
				numero_cuotas,
                frecuencia,
				tipo_frecuencia_id,   
				interes,
				activo
		FROM 	FORMA_PAGO
        WHERE 	id = p_idFormaPago;
    END	IF; 
   
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarGrupoCotizacion` (IN `p_idGrupoCotizacion` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN   
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN  		
		SELECT
			GC.idGrupoCotizacion,  
            (CASE WHEN GC.correlativo = '' THEN ' - ' 
				ELSE CONCAT('GC-', GC.correlativo)
			END )as 'correlativo',
            GC.subTotal,
            GC.igv2,
            GC.total,
            (CASE WHEN GC.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GC.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_COTIZACION GC
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        INNER JOIN USUARIO U ON U.login = GC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5
		ORDER BY GC.correlativo desc;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  		
		SELECT
			GC.idGrupoCotizacion,  
            (CASE WHEN GC.correlativo = '' THEN ' - ' 
				ELSE CONCAT('GC-', GC.correlativo)
			END )as 'correlativo',
            GC.subTotal,
            GC.igv2,
            GC.total,
            (CASE WHEN GC.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GC.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_COTIZACION GC
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        INNER JOIN USUARIO U ON U.login = GC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GC.activo = 1
		ORDER BY GC.correlativo desc;
	END IF;
    
    IF p_tipoOperacion = 3 THEN  		
		SELECT
			GC.idGrupoCotizacion,  
            (CASE WHEN GC.correlativo = '' THEN '-' 
				ELSE CONCAT('GC-', GC.correlativo)
			END )as 'correlativo',
            GC.subTotal,
            GC.igv2,
            GC.total,
            (CASE WHEN GC.fechaEnvio IS NULL THEN '-' 
				ELSE GC.fechaEnvio
			END )as 'fechaEnvio',
            (CASE WHEN GC.fechaEnvio IS NULL THEN '-' 
				ELSE DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvioFormato',
            GC.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_COTIZACION GC
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        INNER JOIN DETALLE_GRUPOCOTIZACION DG ON DG.idGrupoCotizacion = GC.idGrupoCotizacion
        INNER JOIN PRODUCTO PR ON PR.idProducto = DG.idProducto
        INNER JOIN USUARIO U ON U.login = GC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GC.estado IN ('A', 'AN', 'EN', 'P') 
			AND (GC.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%'))
			AND (GC.estado = p_estado or p_estado = '0') 
            AND GC.registro_fecha_add BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP by GC.idGrupoCotizacion
        ORDER BY GC.estado DESC, GC.correlativo DESC;        
	END IF;
    
    IF p_tipoOperacion = 4 THEN  		
		SELECT
			GC.idGrupoCotizacion,             
            (CASE WHEN GC.correlativo = '' THEN '' 
				ELSE CONCAT('GC-', GC.correlativo)
			END )as 'correlativo',
            GC.subTotal,
            GC.igv2,
            GC.total,
            DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            GC.estado,
            M.descripcion             		
		FROM GRUPO_COTIZACION GC
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        WHERE GC.idGrupoCotizacion = p_idGrupoCotizacion and M.dep_id = 5;
	END IF;
    
	IF p_tipoOperacion = 5 THEN  				SELECT
			GC.idGrupoCotizacion,  
            (CASE WHEN GC.correlativo = '' THEN '-' 
				ELSE CONCAT('GC-', GC.correlativo)
			END )as 'correlativo',
            GC.subTotal,
            GC.igv2,
            GC.total,
            (CASE WHEN GC.fechaEnvio IS NULL THEN '-' 
				ELSE GC.fechaEnvio
			END )as 'fechaEnvio',
            (CASE WHEN GC.fechaEnvio IS NULL THEN '-' 
				ELSE DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvioFormato',
            GC.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_COTIZACION GC
        LEFT JOIN DETALLE_GRUPOCOTIZACION DGC ON DGC.idGrupoCotizacion = GC.idGrupoCotizacion
        LEFT JOIN PRODUCTO PR ON PR.idProducto = DGC.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        INNER JOIN USUARIO U ON U.login = GC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GC.estado IN ('SN') 
			AND (GC.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%'))          
			AND (GC.estado = p_estado or p_estado = '') 
            AND GC.registro_fecha_add BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP by GC.idGrupoCotizacion
        ORDER BY GC.estado DESC, GC.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 6 THEN
		SELECT
			GC.idGrupoCotizacion,
            (CASE WHEN GC.correlativo = '' THEN 'Orden sin guardar.' 
				ELSE CONCAT('GC-', GC.correlativo)
			END ) AS 'correlativo',
            GC.subTotal,
            GC.igv,
            GC.igv2,
            GC.total,
            (CASE WHEN GC.fechaEnvio IS NULL THEN 'Orden sin enviar.' 
				ELSE DATE_FORMAT(GC.fechaEnvio, '%d/%m/%Y') 
			END ) AS 'fechaEnvio',
            GC.estado,
            M.descripcion
		FROM GRUPO_COTIZACION GC
        INNER JOIN MULTITABLA M ON M.abrev = GC.estado
        WHERE GC.idGrupoCotizacion = p_idGrupoCotizacion and M.dep_id = 5;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarGrupoOrdenCompra` (IN `p_idGrupoOrden` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN   
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN  		SELECT
			GO.idGrupoOrden,  
            (CASE WHEN GO.correlativo = '' THEN ' - ' 
				ELSE GO.correlativo 
			END )as 'correlativo',
            GO.subTotal,
            GO.igv2,
            GO.total,
            (CASE WHEN GO.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GO.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        INNER JOIN USUARIO U ON U.login = GO.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5
		ORDER BY GO.correlativo;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  		SELECT
			GO.idGrupoOrden,  
            (CASE WHEN GO.correlativo = '' THEN ' - ' 
				ELSE GO.correlativo 
			END )as 'correlativo',
            GO.subTotal,
            GO.igv2,
            GO.total,
            (CASE WHEN GO.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GO.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        INNER JOIN USUARIO U ON U.login = GO.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GO.activo = 1
		ORDER BY GO.correlativo;
	END IF;
    
    IF p_tipoOperacion = 3 THEN  		SELECT
			GO.idGrupoOrden,  
            (CASE WHEN GO.correlativo = '' THEN ' - ' 
				ELSE GO.correlativo 
			END )as 'correlativo',
            GO.subTotal,
            GO.igv2,
            GO.total,
            (CASE WHEN GO.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GO.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        INNER JOIN DETALLE_GRUPO DG ON DG.idGrupoOrden = GO.idGrupoOrden
        INNER JOIN PRODUCTO PR ON PR.idProducto = DG.idProducto
        INNER JOIN USUARIO U ON U.login = GO.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GO.estado IN ('A', 'AN', 'EN', 'P') 
			AND (GO.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%'))
			AND (GO.estado = p_estado or p_estado = '0') 
            AND GO.registro_fecha_add BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP by GO.idGrupoOrden
        ORDER BY GO.estado DESC, go.correlativo asc;        
	END IF;
    
    IF p_tipoOperacion = 4 THEN  		SELECT
			GO.idGrupoOrden,                      GO.correlativo,				            GO.subTotal, 				            GO.igv2,   					            GO.total,						            DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',              GO.estado,                             M.descripcion             		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        WHERE GO.idGrupoOrden = p_idGrupoOrden and M.dep_id = 5;
	END IF;
    
	IF p_tipoOperacion = 5 THEN  		SELECT
			GO.idGrupoOrden,  
            (CASE WHEN GO.correlativo = '' THEN ' - ' 
				ELSE GO.correlativo 
			END )as 'correlativo',
            GO.subTotal,
            GO.igv2,
            GO.total,
            (CASE WHEN GO.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            GO.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN DETALLE_GRUPO DG ON DG.idGrupoOrden = GO.idGrupoOrden
        INNER JOIN PRODUCTO PR ON PR.idProducto = DG.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        INNER JOIN USUARIO U ON U.login = GO.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 5 AND GO.estado IN ('SN') 
			AND (GO.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%'))          
			AND (GO.estado = p_estado or p_estado = '') 
            AND GO.registro_fecha_add BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
		GROUP by GO.idGrupoOrden
        ORDER BY GO.estado DESC, GO.correlativo ASC;
	END IF;
    
    IF p_tipoOperacion = 6 THEN  		SELECT
			GO.idGrupoOrden,
            (CASE WHEN GO.correlativo = '' THEN 'Orden sin guardar.' 
				ELSE GO.correlativo 
			END ) AS 'correlativo',
            GO.subTotal,
            GO.igv,
            GO.igv2,
            GO.total,
            (CASE WHEN GO.fechaEnvio IS NULL THEN 'Orden sin enviar.' 
				ELSE DATE_FORMAT(GO.fechaEnvio, '%d/%m/%Y') 
			END ) AS 'fechaEnvio',
            GO.estado,
            M.descripcion
		FROM GRUPO_ORDENCOMPRA GO
        INNER JOIN MULTITABLA M ON M.abrev = GO.estado
        WHERE GO.idGrupoOrden = p_idGrupoOrden and M.dep_id = 5;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarGrupos` (IN `p_idGrupo` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idGrupo,
            nombre,
            descripcion,
            CASE WHEN activo = 1 THEN 'SI'
				ELSE 'NO'
			END AS 'activo'
        FROM GRUPO
        ORDER BY nombre ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idGrupo,
            nombre,
            descripcion,
            activo
        FROM GRUPO
        WHERE activo = 1
        ORDER BY nombre ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idGrupo,
            nombre,
            descripcion,
            activo
        FROM GRUPO
        WHERE idGrupo = p_idGrupo;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarIgv` (IN `p_anio` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idIgv,
            anio,
            porcentaje,
            (CASE WHEN activo = 1 THEN 'SI'
				WHEN activo = 0 THEN 'NO'
			END) AS activo
        FROM IGV;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idIgv,
            anio,
            porcentaje,
            activo
        FROM IGV
        WHERE activo = 1;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idIgv,
            anio,
            porcentaje,
            activo
        FROM IGV
        WHERE activo = 1 and anio = p_anio;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarMenu` (IN `p_idUsuario` INT, IN `p_idGrupo` INT, IN `p_tipoOperacion` INT)  BEGIN
		IF p_tipoOperacion = 1 THEN   
		SELECT 
			DISTINCT GRUPO.idGrupo, 
			GRUPO.nombre,
            GRUPO.icono
		FROM GRUPO 
        INNER JOIN TAREA ON TAREA.idGrupo = GRUPO.idGrupo 
        INNER JOIN ROL_TAREA ON ROL_TAREA.idTarea = TAREA.idTarea 
        INNER JOIN ROL ON ROL.idRol = ROL_TAREA.idRol 
        INNER JOIN USUARIO ON USUARIO.idRol = ROL.idRol 
        WHERE USUARIO.idUsuario = p_idUsuario and USUARIO.activo = 1
		AND ROL_TAREA.activo = 1 AND TAREA.activo = 1 AND ROL.activo = 1
        ORDER BY GRUPO.Orden ASC;            
    END	IF;
    
        IF p_tipoOperacion = 2 THEN   
		SELECT 
			DISTINCT TAREA.idTarea, 
			TAREA.nombre, 
			TAREA.url  
		FROM TAREA 
		INNER JOIN ROL_TAREA ON ROL_TAREA.idTarea = TAREA.idTarea 
		INNER JOIN ROL ON ROL.idRol = ROL_TAREA.idRol 
        INNER JOIN USUARIO ON USUARIO.idRol = ROL.idRol 
        WHERE USUARIO.idUsuario = p_idUsuario and USUARIO.activo = 1
		AND ROL_TAREA.activo = 1 AND TAREA.activo = 1 AND ROL.activo = 1
        AND TAREA.idGrupo = p_idGrupo
        ORDER BY TAREA.orden ASC;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarMultitablas` (IN `p_idMultitabla` INT, IN `p_valor` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idMultitabla,
            valor,
            dep_id,
            descripcion,
            abrev,
            (CASE WHEN activo = 1 THEN 'SI'
				WHEN activo = 0 THEN 'NO' 
			END) AS activo
        FROM MULTITABLA
        WHERE dep_id is null
        ORDER BY descripcion ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idMultitabla,
            valor,
            dep_id,
            descripcion,
            abrev,
            activo
        FROM MULTITABLA
        WHERE dep_id is null AND activo = 1
        ORDER BY descripcion ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 
		SELECT 
			idMultitabla,
            valor,
            dep_id,
            descripcion,
            abrev,
            activo
        FROM MULTITABLA
        WHERE idMultitabla = p_idMultitabla;
	END IF;  
    
    IF p_tipoOperacion = 4 THEN 
		SELECT 
			idMultitabla,
            valor,
            dep_id,
            descripcion,
            abrev,
            (CASE WHEN activo = 1 THEN 'SI'
				WHEN activo = 0 THEN 'NO'
			END) AS activo
        FROM MULTITABLA
        WHERE dep_id = p_valor;
	END IF;
    
    IF p_tipoOperacion = 5 THEN 
		SELECT 
			idMultitabla,
            valor,
            dep_id,
            descripcion,
            abrev,
            activo
        FROM MULTITABLA
        WHERE dep_id = p_valor and activo = 1 ORDER BY valor;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarNotaAlmacen` (IN `p_idNotaAlmacen` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN 
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN  		
		SELECT
			C.idCotizacion,            
            CONCAT('NA-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
		ORDER BY C.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  
		SELECT
			C.idCotizacion,            
            CONCAT('NA-', C.correlativo) as correlativo,
            C.idProveedor,
            P.nombreEmpresa,
            C.subTotal,
            C.igv,
            C.total,
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(C.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            C.estado,
            M.descripcion
		FROM COTIZACION C
        INNER JOIN PROVEEDOR P ON P.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = C.estado and M.dep_id = 5)
        WHERE C.activo = 1
		ORDER BY C.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN  		
		SELECT 
			NA.idNotaAlmacen,
			CONCAT('NA-', NA.correlativo) as correlativo,
			T.idTrabajador,
			CASE WHEN T.idTrabajador is null then '-'
				ELSE CONCAT(T.nombre, ' ', T.apePaterno)
			END as 'trabajador',
			NA.idAlmacen, 
			'-' AS 'almacen',
			NA.idCompra,    
			CASE WHEN NA.idCompra is null then '-'
				ELSE C.correlativo
			END as 'compra',
			NA.idOrdenMantenimiento,  
			CASE WHEN NA.idOrdenMantenimiento is null then '-'
				ELSE OM.idOrdenMantenimiento
			END as 'ordenMantenimiento',
			NA.idOrdenServicio,      
			CASE WHEN NA.idOrdenServicio is null then '-'
				ELSE OS.idOrdenServicio
			END as 'ordenServicio',
			NA.subTotal,
			NA.igv2,
			NA.total,
			CASE WHEN NA.fechaEmision is null THEN '-'
				ELSE date(NA.fechaEmision)
			END as 'fechaEmision',
            CASE WHEN NA.fechaEmision is null THEN '-'
				ELSE DATE_FORMAT(NA.fechaEmision, '%d/%m/%Y')
			END as 'fechaEmisionFormato',
			M.descripcion as 'motivo',
			NA.tipoNota,
			M1.descripcion as 'tipo',
            			NA.estado as 'estadoNA',
			M2.descripcion as 'estado'
		FROM NOTA_ALMACEN NA
		LEFT JOIN COMPRA C ON C.idCompra = NA.idCompra
		LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento
		LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen
		LEFT JOIN PRODUCTO PR ON PR.idProducto = DNA.idProducto
		LEFT JOIN MULTITABLA M ON M.valor = NA.motivo and M.dep_id = 13
		LEFT JOIN MULTITABLA M1 ON M1.abrev = NA.tipoNota and M1.dep_id = 12
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.estado and M2.dep_id = 11
		
        INNER JOIN USUARIO U ON U.login = NA.registro_user_add
		LEFT JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
		WHERE (NA.correlativo LIKE CONCAT('%', p_busqueda, '%')
						OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
						OR PR.nombre LIKE concat('%', p_busqueda, '%')
						)
					AND (NA.estado = p_estado or p_estado = '0') 
                   		GROUP BY NA.idNotaAlmacen
		ORDER BY NA.correlativo DESC;
	END IF;
    
	IF p_tipoOperacion = 4 THEN  		
		SELECT 
			ifnull(NA.correlativo, '') as correlativo,
			ifnull(NA.idTrabajador, '') as idTrabajador, 
			ifnull(NA.motivo, '') as motivo, 
			ifnull(NA.fechaEmision, now() ) as fechaEmision, 
			ifnull(NA.idUnidad, '0') as idUnidad, 
			ifnull(NA.tipoOperacion, '') as tipoOperacion, 
            NA.observaciones, NA.estado,            
			ifnull(NA.idDestino, '') as idDestino 
		FROM NOTA_ALMACEN NA
		WHERE NA.idNotaAlmacen = p_idNotaAlmacen;
    END	IF;
    
	IF p_tipoOperacion = 5 THEN
		SELECT 
			ifnull(NA.correlativo, '') as correlativo,
			ifnull(NA.idTrabajador, '') as idTrabajador, 
            ifnull( concat(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno), '-' ) as 'trabajador',
			date_format( ifnull( NA.fechaEmision, now() ), '%d/%m/%Y' ) as fechaEmision, 
			ifnull(NA.idUnidad, '0') as idUnidad, 
            CASE WHEN NA.idDestino = 2 THEN ifnull(U.placa, '-') 
				ELSE '-' 
			END as placa,
            NA.observaciones as descripcion, 
            NA.estado,            
			ifnull(NA.idDestino, '') as idDestino ,
            ifnull(M2.descripcion, '') as destino,
			ifnull(NA.motivo, '') as idMotivo,
            ifnull(NA.tipoOperacion, '') as idTipoOperacion,
            ifnull(M1.descripcion, '') as tipoOperacion,
                        ifnull(concat('OTM-', OTM.correlativo), '-') AS 'correlativoOTM',
            ifnull(concat('OTM-', OS.correlativo), '-') AS 'correlativoOS'
		FROM NOTA_ALMACEN NA
        LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = NA.idOrdenMantenimiento
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
        LEFT JOIN TRABAJADOR T ON T.idTrabajador = NA.idTrabajador
        LEFT JOIN UNIDAD_MOVIL U ON U.idUnidad = NA.idUnidad
        LEFT JOIN MULTITABLA M1 ON M1.abrev = NA.tipoOperacion and M1.dep_id = 22
                LEFT JOIN MULTITABLA M2 ON M2.valor = NA.idDestino and M2.dep_id = 21
		WHERE NA.idNotaAlmacen = p_idNotaAlmacen;
    END	IF;
    
    IF p_tipoOperacion = 6 THEN
		SELECT 
			ifnull(NA.correlativo, '') as correlativo,
			ifnull(NA.idTrabajador, '') as idTrabajador, 
            ifnull( concat(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno), '-' ) as 'trabajador',
			date_format( ifnull( NA.fechaEmision, now() ), '%d/%m/%Y' ) as fechaEmision, 
			ifnull(NA.idUnidad, '0') as idUnidad, 
            ifnull(U.placa, '') as placa,
            NA.observaciones as descripcion, 
            NA.estado,            
			ifnull(NA.idDestino, '') as idDestino ,
            ifnull(M2.descripcion, '') as destino,
			ifnull(NA.motivo, '') as idMotivo,
                        ifnull(NA.tipoOperacion, '') as idTipoOperacion,
            ifnull(M1.descripcion, '') as tipoOperacion,
            ifnull(concat('CM-', CM.correlativo), '-') AS 'correlativoCM',
            ifnull(concat('OC-', OC.correlativo), '-') AS 'correlativoOC'
		FROM NOTA_ALMACEN NA
        LEFT JOIN COMPRA CM ON CM.idCompra = NA.idCompra
        LEFT JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = CM.idOrdenCompra
        LEFT JOIN TRABAJADOR T ON T.idTrabajador = NA.idTrabajador
        LEFT JOIN UNIDAD_MOVIL U ON U.idUnidad = NA.idUnidad
                LEFT JOIN MULTITABLA M1 ON M1.abrev = NA.tipoOperacion and M1.dep_id = 18
        LEFT JOIN MULTITABLA M2 ON M2.valor = NA.idDestino and M2.dep_id = 21
		WHERE NA.idNotaAlmacen = p_idNotaAlmacen;
    END	IF;
    
    IF p_tipoOperacion = 7 THEN  		
		SELECT 
			NA.idNotaAlmacen,
			CONCAT('NA-', NA.correlativo) as correlativo,
			T.idTrabajador,
			CASE WHEN T.idTrabajador is null then '-'
				ELSE CONCAT(T.nombre, ' ', T.apePaterno)
			END as 'trabajador',
			NA.idAlmacen, 
			'-' AS 'almacen',
			NA.idCompra, 
            NA.idOrdenMantenimiento, 
			NA.idOrdenServicio,
			NA.subTotal,
			NA.igv2,
			NA.total,
			CASE WHEN NA.fechaEmision is null THEN '-'
				ELSE date(NA.fechaEmision)
			END as 'fechaEmision',
            CASE WHEN NA.fechaEmision is null THEN '-'
				ELSE DATE_FORMAT(NA.fechaEmision, '%d/%m/%Y')
			END as 'fechaEmisionFormato',
			-- M.descripcion as 'motivo',
			NA.tipoNota,
			M1.descripcion as 'tipo',
            			NA.estado as 'estadoNA',
			M2.descripcion as 'estado'
		FROM NOTA_ALMACEN NA
        INNER JOIN USUARIO U ON U.login = NA.registro_user_add
		INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen
		INNER JOIN PRODUCTO PR ON PR.idProducto = DNA.idProducto
		INNER JOIN MULTITABLA M1 ON M1.abrev = NA.tipoNota and M1.dep_id = 12
		INNER JOIN MULTITABLA M2 ON M2.abrev = NA.estado and M2.dep_id = 11
		-- LEFT JOIN MULTITABLA M ON M.valor = NA.motivo and M.dep_id = 13
		WHERE 
            NA.fechaEmision BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
			and (NA.correlativo LIKE CONCAT('%', p_busqueda, '%')
						OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
						OR PR.nombre LIKE concat('%', p_busqueda, '%')
						)
					AND (NA.estado = p_estado or p_estado = '0') 
		GROUP BY NA.idNotaAlmacen
		ORDER BY NA.correlativo DESC;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarOficina` (IN `p_idOficina` INT, IN `p_tipoOperacion` INT)  BEGIN  
	IF p_tipoOperacion = 1 THEN 
		SELECT idOficina, nombre, direccion, 
			CASE WHEN principal = 1 THEN 'SI'
				ELSE 'NO' END AS principal, 
			CASE WHEN activo = 1 THEN 'SI'
				ELSE 'NO' END AS activo 
		FROM OFICINA;
    END	IF; 
	IF p_tipoOperacion = 2 THEN 
		SELECT idOficina, nombre, direccion, 
			CASE WHEN principal = 1 THEN 'SI'
				ELSE 'NO' END AS principal, 
			CASE WHEN activo = 1 THEN 'SI'
				ELSE 'NO' END AS activo 
		FROM OFICINA
        WHERE activo = 1;
    END	IF;  
	IF p_tipoOperacion = 3 THEN 
		SELECT idOficina, nombre, direccion, principal, activo
		FROM OFICINA
        WHERE idOficina = p_idOficina;
    END	IF;   
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarOrdenCompra` (IN `p_idOrdenCompra` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN   
	DECLARE cor char(7);
    DECLARE id int;
    DECLARE v_subTotal decimal(18,2);
    DECLARE v_descuento decimal(18,2);
    DECLARE v_igv decimal(18,2);
    DECLARE v_total decimal(18,2);
    
	IF p_tipoOperacion = 1 THEN  		
		SELECT
			OC.idOrdenCompra,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
            P.nombreEmpresa,
            OC.subTotal,
            OC.igv,
            OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') as 'fechaAceptada',
            OC.estadoRecepcion,
            M.descripcion
		FROM ORDEN_COMPRA OC
        INNER JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
		ORDER BY OC.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  		
		SELECT
			OC.idOrdenCompra,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
            P.nombreEmpresa,
            OC.subTotal,
            OC.igv,
            OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%m/%d/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaAceptada, '%m/%d/%Y') as 'fechaAceptada',
            OC.estadoRecepcion,
            M.descripcion
		FROM ORDEN_COMPRA OC
        INNER JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        WHERE OC.activo = 1
		ORDER BY OC.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN  		
		SELECT
			OC.idOrdenCompra,  
            PV.nombreEmpresa,         
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.subTotal,
            OC.igv2,
            OC.total,
            OC.fechaEnvio,
            (CASE WHEN OC.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvioFormato',
            (CASE WHEN OC.fechaEntrega IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') 
			END )as 'fechaAceptada',
            OC.estadoRecepcion as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
        LEFT JOIN DETALLE_ORDEN OD ON OD.idOrdenCompra = OC.idOrdenCompra
        LEFT JOIN PRODUCTO PR ON PR.idProducto = OD.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = OC.estadoRecepcion
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = OC.idProveedor
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 17 AND OC.estadoRecepcion IN ('A', 'AN', 'EN', 'P', 'SE') 
			AND (OC.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%')
                OR PV.nombreEmpresa LIKE concat('%', p_busqueda, '%'))
			AND (OC.estadoRecepcion = p_estado or p_estado = '0') 
            AND OC.fechaEnvio BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
           		GROUP BY OC.idOrdenCompra
        ORDER BY FIELD(OC.estadoRecepcion, 'AN') ASC, OC.estadoRecepcion DESC, OC.correlativo DESC;
	END IF;
    
	IF p_tipoOperacion = 4 THEN  
		SET @v_subTotal = (SELECT SUM(valorVentaA) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
		SET @v_descuento = (SELECT SUM(descuentoTotalA) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
		SET @v_total = (SELECT SUM(montoA) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
        
						                
		SELECT
			OC.idOrdenCompra,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
            P.nombreEmpresa,
            OC.codCotizacion,
            OC.tipoDocumento,
            OC.serieDocumento,
            OC.numeroDocumento,
            OC.formaPago,
            OC.idOficina,
            OC.idTipoMoneda,
            ifnull(OC.idDestino, 0) as idDestino,
            ifnull(OC.idUnidad, '') as idUnidad,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEmision',  			
            DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') as 'fechaEntrega',
            @v_subTotal as subTotal, 
            @v_descuento as descuento,
            OC.igv,
            ROUND(@v_total - @v_subTotal + @v_descuento, 2) as igv2, 
            @v_total as total, 
            OC.estadoRecepcion,
            M.descripcion
		FROM ORDEN_COMPRA OC
        LEFT JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        LEFT JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        WHERE OC.idOrdenCompra = p_idOrdenCompra;
	END IF;
    
	IF p_tipoOperacion = 5 THEN
		SELECT
			OC.idOrdenCompra,       
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
            P.nombreEmpresa,
            OC.codCotizacion,
            ifnull(OC.serieDocumento, '') as serieDocumento,
            ifnull(OC.numeroDocumento, '') as numeroDocumento,
            OC.tipoDocumento,
            OC.formaPago,
            OC.idOficina,
            OC.lugarAtencion,
            OC.idTipoMoneda,
            ifnull(OC.idDestino, 0) as idDestino,
            ifnull(OC.idUnidad, '') as idUnidad,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEmision',
			DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') as 'fechaEntrega',
                        			OC.subTotal,
            OC.descuento,
            OC.igv,
            OC.igv2,
            OC.total,
            OC.estadoRecepcion,
            M.descripcion
		FROM ORDEN_COMPRA OC
        LEFT JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        LEFT JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        WHERE OC.idOrdenCompra = p_idOrdenCompra; 
	END IF;
    
    IF p_tipoOperacion = 6 THEN
		SELECT
			OC.idOrdenCompra,
			CASE WHEN OC.correlativo = '' THEN '' 
				ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.correlativo as correlativo2,
            OC.idOrdenMantenimiento,
            CASE WHEN OTM.correlativo is null THEN '-'
				ELSE CONCAT('OTM-', OTM.correlativo)
			END as correlativoOTM,
            OC.idOrdenServicio,
            CASE WHEN OS.correlativo is null THEN '-'
				ELSE CONCAT('OS-', OS.correlativo)
			END as correlativoOS,
            CASE WHEN OTM.idUnidad is not null then UM1.placa
				WHEN OS.idUnidad is not null then UM2.placa
				ELSE '-' 
            END as placa,
            CASE WHEN OC.idDestino is null THEN  CASE WHEN OTM.idUnidad is not null then UM1.placa
														WHEN OS.idUnidad is not null then UM2.placa
														ELSE '-'
													END
				WHEN OC.idDestino = 2 THEN UM3.placa ELSE M5.descripcion END as destino,
            OC.codCotizacion,
            OC.idProveedor,
			OC.nombreProveedor,
            OC.rucProveedor,
            OC.direccionProveedor,
            OC.telefonoProveedor,
            OC.emailProveedor,
            OC.lugarAtencion,
            M4.descripcion as desTipoDocumento,
            ifnull(OC.serieDocumento, '') as serieDocumento,
            ifnull(OC.numeroDocumento, '') as numeroDocumento,
            ifnull( CONCAT(C.serieDocumento, '-', C.numeroDocumento ) , '') as documento,
            OC.subTotal,
            OC.descuento,
            OC.igv,
            OC.igv2,
            OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') as 'fechaEntrega',
            OC.estadoRecepcion,
            M.descripcion,
            M2.descripcion as 'formaPago',
            M3.descripcion as 'moneda',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
        LEFT JOIN UNIDAD_MOVIL UM3 ON UM3.idUnidad = OC.idUnidad
        LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = OC.idOrdenMantenimiento
        LEFT JOIN UNIDAD_MOVIL UM1 ON UM1.idUnidad = OTM.idUnidad
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = OC.idOrdenServicio
        LEFT JOIN UNIDAD_MOVIL UM2 ON UM2.idUnidad = OS.idUnidad     
        LEFT JOIN COMPRA C ON C.idOrdenCompra = OC.idOrdenCompra
        INNER JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        INNER JOIN MULTITABLA M2 ON (M2.abrev = OC.formaPago AND M2.dep_id = 8)
        INNER JOIN MULTITABLA M3 ON (M3.valor = OC.idTipoMoneda AND M3.dep_id = 20)
        INNER JOIN MULTITABLA M4 ON (M4.abrev = OC.tipoDocumento AND M4.dep_id = 15)
        LEFT JOIN MULTITABLA M5 ON (M5.valor = OC.idDestino AND M5.dep_id = 21)
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE OC.idOrdenCompra = p_idOrdenCompra;
	END IF;
    
    IF p_tipoOperacion = 7 THEN           		
		SELECT
			OC.idOrdenCompra,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
			P.nombreEmpresa,
            P.direccion,
            P.email,
            OC.subTotal,
            OC.igv,
            OC.igv2,
            OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            OC.estadoRecepcion,
            M.descripcion,
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
        INNER JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        INNER JOIN MULTITABLA M ON (M.abrev = OC.estadoRecepcion AND M.dep_id = 17)
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE OC.idGrupoOrden = p_idOrdenCompra;
	END IF;
		
	IF p_tipoOperacion = 8 THEN
		SELECT
			OC.idOrdenCompra,  
			OC.idGrupoOrden, 
            PV.nombreEmpresa,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.subTotal,
            OC.igv2,
            OC.total,
            (CASE WHEN OC.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvio',
            (CASE WHEN OC.fechaAceptada IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaAceptada, '%d/%m/%Y') 
			END )as 'fechaAceptada',
            OC.estado as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
        INNER JOIN MULTITABLA M ON M.abrev = OC.estadoRecepcion
        INNER JOIN PROVEEDOR PV ON PV.idProveedor = OC.idProveedor
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 17 
			AND ( (OC.correlativo LIKE concat('%', p_busqueda, '%'))
					OR (PV.nombreEmpresa LIKE concat('%', p_busqueda, '%')) 
                    OR (CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')) 
			)
            AND OC.estadoRecepcion = 'EN'            
		ORDER BY OC.correlativo DESC;
	END IF;
    
    IF p_tipoOperacion = 9 THEN           		
		SELECT
			OC.idOrdenCompra,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.idProveedor,
			P.nombreEmpresa,
            P.direccion,
            P.email,
            OC.subTotal,
            OC.igv,
            OC.igv2,
            OC.total,
            DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') as 'fechaEnvio',
            DATE_FORMAT(OC.fechaAceptada, '%d/%m/%Y') as 'fechaAceptada',
            OC.estadoRecepcion,
            M.descripcion,
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
		INNER JOIN PROVEEDOR P ON P.idProveedor = OC.idProveedor
        INNER JOIN MULTITABLA M ON ( M.abrev = OC.estado and M.dep_id = 17)
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE OC.idCotizacion = p_idOrdenCompra;
	END IF;
    
    IF p_tipoOperacion = 10 THEN
		SELECT
			OC.idOrdenCompra,  
            PV.nombreEmpresa,
            CASE WHEN OC.correlativo = '' THEN '' 
					ELSE CONCAT('OC-', OC.correlativo)
			END AS correlativo,
            OC.subTotal,
            OC.igv2,
            OC.total,
            OC.fechaEnvio,
            (CASE WHEN OC.fechaEnvio IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaEnvio, '%d/%m/%Y') 
			END )as 'fechaEnvioFormato',
            (CASE WHEN OC.fechaEntrega IS NULL THEN ' - ' 
				ELSE DATE_FORMAT(OC.fechaEntrega, '%d/%m/%Y') 
			END )as 'fechaAceptada',
            OC.estadoRecepcion as 'idEstado',
            M.descripcion as 'estado',
            CONCAT(T.nombre, ' ', T.apePaterno) as 'empleado'
		FROM ORDEN_COMPRA OC
        LEFT JOIN DETALLE_ORDEN OD ON OD.idOrdenCompra = OC.idOrdenCompra
        LEFT JOIN PRODUCTO PR ON PR.idProducto = OD.idProducto
        INNER JOIN MULTITABLA M ON M.abrev = OC.estadoRecepcion
        LEFT JOIN PROVEEDOR PV ON PV.idProveedor = OC.idProveedor
        INNER JOIN USUARIO U ON U.login = OC.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 17 AND OC.estadoRecepcion IN ('SN') 
			AND (OC.correlativo LIKE CONCAT('%', p_busqueda, '%')
				OR CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
                OR PR.nombre LIKE concat('%', p_busqueda, '%')
                OR PV.nombreEmpresa LIKE concat('%', p_busqueda, '%'))
			AND (OC.estadoRecepcion = p_estado or p_estado = '0') 
            AND OC.registro_fecha_add BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
            		GROUP BY OC.idOrdenCompra
        ORDER BY FIELD(OC.estadoRecepcion, 'AN') ASC, OC.estadoRecepcion DESC, OC.correlativo DESC;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarOrdenMantenimiento` (IN `p_idOrdenMantenimiento` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATE, IN `p_fechaFin` DATE, IN `p_tipoOperacion` INT)  BEGIN  
    
    DECLARE cor char(7);
    DECLARE id int;
            
    IF p_tipoOperacion = 1 THEN  		
		SELECT
			OM.idOrdenMantenimiento, concat('OTM-', OM.correlativo) as correlativo,
            CONCAT(ifnull(T.nombre, '-'), ' ', ifnull(T.apePaterno, '')) as 'responsable',
            ifnull(UM.placa, '-') as unidad,
            IFNULL( DATE_FORMAT(OM.fechaEmision, '%d/%m/%Y'), '-' ) as fechaEmision,
            IFNULL( DATE_FORMAT(OM.fechaInicio, '%d/%m/%Y'), '-' ) as fechaInicio,
            IFNULL( DATE_FORMAT(OM.fechaFin, '%d/%m/%Y'), '-' ) as fechaFin,
            OM.estado as 'idEstado',
            M.descripcion as 'estado'
		FROM ORDEN_MANTENIMIENTO OM
        INNER JOIN MULTITABLA M ON M.abrev = OM.estado        
        LEFT JOIN TRABAJADOR T ON T.idTrabajador = OM.idTrabajador
        LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OM.idUnidad
        WHERE M.dep_id = 10 AND (OM.estado = p_estado or p_estado = '0') 
            -- AND OM.fechaEmision BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
            AND cast(OM.fechaEmision as date) BETWEEN p_fechaInicio AND p_fechaFin
            AND ( CONCAT(ifnull(T.nombre, '-'), ' ', ifnull(T.apePaterno, '')) like concat('%', p_busqueda, '%')
				OR concat('OTM-', OM.correlativo) LIKE concat('%', p_busqueda, '%')
            )
        ORDER BY OM.estado ASC, OM.correlativo desc;        
	END IF;
    
   IF p_tipoOperacion = 2 THEN  				
		SELECT OM.idOrdenMantenimiento, ifnull(OM.idTrabajador, '') as idTrabajador, 
			ifnull(OM.idUnidad, '') as idUnidad, 
			ifnull(OM.correlativo, '') as correlativo, 
			ifnull(OM.kilometraje, '') as kilometraje, OM.componente, 
            OM.descripcion,  
            OM.estado,
            IFNULL( DATE_FORMAT(OM.fechaEmision, '%Y-%m-%d'), now() ) as fechaEmision,
            IFNULL( DATE_FORMAT(OM.fechaInicio, '%Y-%m-%d'), now() ) as fechaInicio,
            IFNULL( DATE_FORMAT(OM.fechaFin, '%Y-%m-%d'), now() ) as fechaFin ,  
            ifnull(OM.observaciones, '') as observaciones      
                     		FROM ORDEN_MANTENIMIENTO OM
        WHERE OM.idOrdenMantenimiento = p_idOrdenMantenimiento;        
	END IF;
    
   IF p_tipoOperacion = 3 THEN  	 		SELECT OM.idOrdenMantenimiento, 
			IFNULL(OM.idTrabajador, '') as idTrabajador, 
			CONCAT(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno) as responsable,
			IFNULL(OM.idUnidad, '') as idUnidad, UM.placa,
			IFNULL(OM.correlativo, '') as correlativo, 
			IFNULL(OM.kilometraje, '') as kilometraje,
         IFNULL( DATE_FORMAT(OM.fechaEmision, '%d/%m/%Y'), now() ) as fechaEmision,
         IFNULL( DATE_FORMAT(OM.fechaInicio, '%d/%m/%Y'), now() ) as fechaInicio,
         IFNULL( DATE_FORMAT(OM.fechaFin, '%d/%m/%Y'), now() ) as fechaFin,
         OM.componente, OM.descripcion, OM.estado, 
		ifnull(OM.observaciones, '') as observaciones
		FROM ORDEN_MANTENIMIENTO OM
		INNER JOIN TRABAJADOR T ON T.idTrabajador = OM.idTrabajador
		INNER JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OM.idUnidad
      WHERE OM.idOrdenMantenimiento = p_idOrdenMantenimiento;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarOrdenServicio` (IN `p_idOrdenServicio` INT, IN `p_idOrdenMantenimiento` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATE, IN `p_fechaFin` DATE, IN `p_tipoOperacion` INT)  BEGIN  
    
    DECLARE cor char(7);
    DECLARE id int;
        
    IF p_tipoOperacion = 1 THEN  		
		SELECT
			OS.idOrdenServicio,
            CONCAT('OS-', OS.correlativo) as correlativo,
            OS.idProveedor,
            IFNULL(P.nombreEmpresa, '-') as 'proveedor',
            OS.idUnidad,
            IFNULL(UM.placa, '-') as placa,
            IFNULL( DATE_FORMAT(OS.fechaEmision, '%d/%m/%Y'), '-') as fechaEmision,            
            IFNULL( DATE_FORMAT(OS.fechaInicio, '%d/%m/%Y'), '-') as fechaInicio,            
            IFNULL( DATE_FORMAT(OS.fechaFin, '%d/%m/%Y'), '-') as fechaFin,
            OS.estado as 'idEstado', M.descripcion as 'estado'
		FROM ORDEN_SERVICIO OS
        LEFT JOIN PROVEEDOR P ON P.idProveedor = OS.idProveedor	
        LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = OS.idUnidad
        INNER JOIN MULTITABLA M ON M.abrev = OS.estado
        INNER JOIN USUARIO U ON U.login = OS.registro_user_add
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        WHERE M.dep_id = 10 
			AND ( CONCAT(T.nombre, ' ', T.apePaterno) LIKE concat('%', p_busqueda, '%')
				OR concat('OS-', OS.correlativo) LIKE concat('%', p_busqueda, '%')
				OR P.nombreEmpresa LIKE concat('%', p_busqueda, '%')
            )
			AND (OS.estado = p_estado or p_estado = '0') 
            -- AND cast(OS.fechaEmision as date) BETWEEN p_fechaInicio AND ADDDATE(p_fechaFin, INTERVAL 1 DAY)
            AND cast(OS.fechaEmision as date) BETWEEN p_fechaInicio AND p_fechaFin	
        ORDER BY OS.estado ASC, OS.correlativo desc;  
	END IF;
    
    IF p_tipoOperacion = 2 THEN  		
		SELECT
			OS.idOrdenServicio,
            IFNULL(OS.correlativo, '-') as correlativo,
            OS.idProveedor,
            IFNULL(P.nombreEmpresa, '-') as 'proveedor',
            OS.descripcion,
            OS.estado as 'idEstado'
		FROM ORDEN_SERVICIO OS
        LEFT JOIN PROVEEDOR P ON P.idProveedor = OS.idProveedor	
        WHERE OS.idOrdenMantenimiento = p_idOrdenMantenimiento
        ORDER BY OS.correlativo ASC;      
	END IF;
    
    IF p_tipoOperacion = 3 THEN  				
		SELECT OS.idOrdenServicio, ifnull(OS.idProveedor, '') as idProveedor, ifnull(OS.idUnidad, '') as idUnidad, 
			ifnull(OS.correlativo, '') as correlativo, 
			ifnull(OS.kilometraje, '') as kilometraje,  OS.descripcion, OS.estado,
            IFNULL( DATE_FORMAT(OS.fechaEmision, '%Y-%m-%d'), now() )as fechaEmision,
            IFNULL(DATE_FORMAT(OS.fechaInicio, '%Y-%m-%d'), now() ) as fechaInicio,
            IFNULL(DATE_FORMAT(OS.fechaFin, '%Y-%m-%d'), now() )as fechaFin,            
            OS.tipoDocumento, OS.serieDocumento, OS.numeroDocumento,
            IFNULL(OS.idTipoMoneda, '') as idTipoMoneda,
            ifnull(OS.observaciones, '') as observaciones 
		FROM ORDEN_SERVICIO OS
        WHERE OS.idOrdenServicio = p_idOrdenServicio;
	END IF;
	
	IF p_tipoOperacion = 4 THEN  				
		SELECT OS.idOrdenServicio, ifnull(OS.idProveedor, '') as idProveedor, 
			P.nombreEmpresa as nombreProveedor,
            P.ruc as rucProveedor,
			ifnull(OS.idUnidad, '') as idUnidad, UM.placa,
			ifnull(OS.correlativo, '') as correlativo, 
			ifnull(OS.kilometraje, '') as kilometraje,  OS.descripcion, OS.estado,
            IFNULL(OS.idTipoMoneda ,0) as idTipoMoneda,
			IFNULL( DATE_FORMAT(OS.fechaEmision, '%d/%m/%Y'), now() )as fechaEmision,
			IFNULL(DATE_FORMAT(OS.fechaInicio, '%d/%m/%Y'), now() ) as fechaInicio,
			IFNULL(DATE_FORMAT(OS.fechaFin, '%d/%m/%Y'), now() )as fechaFin,
			M.descripcion as 'tipoDocumentoDescrip', OS.tipoDocumento, OS.serieDocumento, OS.numeroDocumento,
			(SELECT SUM(costoTotal) FROM SUBSERVICIO WHERE idOrdenServicio = p_idOrdenServicio GROUP BY idOrdenServicio) as montoTotal,          
			ifnull(OS.observaciones, '') as observaciones
		FROM ORDEN_SERVICIO OS
		INNER JOIN PROVEEDOR P ON P.idProveedor = OS.idProveedor
		INNER JOIN UNIDAD_MOVIL UM ON OS.idUnidad = UM.idUnidad
        INNER JOIN MULTITABLA M ON M.abrev = OS.tipoDocumento and M.dep_id = 15
      WHERE OS.idOrdenServicio = p_idOrdenServicio;        
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarPaises` (IN `p_idPais` VARCHAR(2), IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idPais,
            pais
        FROM PAIS
        ORDER BY pais ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idCiudades, 
			Paises_Codigo, 
			Ciudad 
		FROM CIUDADES 
		WHERE Paises_Codigo = p_idPais
		ORDER BY ciudad ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idCiudades, 
			Paises_Codigo, 
			Ciudad 
		FROM CIUDADES 
		ORDER BY ciudad ASC;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarPeriodos` (IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idPeriodo,
            periodo
        FROM PERIODO
        ORDER BY periodo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idPeriodo,
            periodo
        FROM PERIODO
        WHERE activo = 1
        ORDER BY periodo DESC;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarPresentacion` (IN `p_idPresentacion` INT, IN `p_idClase` INT, IN `p_idProducto` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN  			SELECT 
			P.idPresentacion,            
			P.idClase,
            C.nombre as 'clase',
            P.idUnidad,
            M1.descripcion as 'unidad',            
            P.cantidad,
            P.idEmpaque as 'idEmpaque',
            M2.descripcion as 'empaque',
            P.nombre,
            P.activo
		FROM PRESENTACION P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idUnidad
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idUnidad
        WHERE M1.dep_id = 3 and M2.dep_id = 4
		ORDER BY P.cantidad;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 			SELECT 
			P.idPresentacion,            
			P.idClase,
            C.nombre as 'clase',
            P.idUnidad,
            M.descripcion as 'unidad',
            P.cantidad,
            P.activo
		FROM PRESENTACION P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN MULTITABLA M ON M.valor = P.idUnidad
        WHERE P.activo = 1
		ORDER BY P.cantidad;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 			SELECT 
			P.idPresentacion,            
			P.idClase,
            C.nombre as 'clase',
            P.idUnidad,
            M1.descripcion as 'unidad',
            P.cantidad,
            P.idEmpaque,
            M2.descripcion as 'empaque',
            P.activo
		FROM PRESENTACION P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idUnidad
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEmpaque
        WHERE P.idPresentacion = p_idPresentacion and M1.dep_id = 3 and M2.dep_id = 4;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 			SELECT 
			P.idPresentacion,            			P.idClase,
            C.nombre as 'clase',
            P.idUnidad,
            M1.descripcion as 'unidad',            
            P.cantidad,
            P.idEmpaque,
            M2.descripcion as 'empaque',
            P.nombre,
            (CASE WHEN P.activo = 1 THEN 'SI'
				WHEN P.activo = 0 THEN 'NO'
			END) AS activo
		FROM PRESENTACION P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idUnidad
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEmpaque
        WHERE P.idClase = p_idClase AND M1.dep_id = 3 AND M2.dep_id = 4
		ORDER BY P.cantidad;
	END IF;
    
    IF p_tipoOperacion = 5 THEN 			SELECT 
			P.idPresentacion,            
			P.idClase,
            C.nombre as 'clase',
            P.idUnidad,
            M1.descripcion as 'unidad',            
            P.cantidad,
            P.idEmpaque,
            M2.descripcion as 'empaque',
            P.nombre,
            P.activo
		FROM PRESENTACION P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idUnidad
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idUnidad 
        WHERE P.activo = 1 AND P.idClase = p_idClase AND M1.dep_id = 3 AND M2.dep_id = 4       
		ORDER BY P.cantidad;
	END IF;
    
    IF p_tipoOperacion = 6 THEN 			 SELECT 
            PR.idPresentacion,
            PR.nombre
        FROM PRODUCTO P
        INNER JOIN CLASE C ON (C.idClase = P.idClase and C.activo = 1)
        INNER JOIN PRESENTACION PR ON (PR.idClase = C.idClase and PR.activo = 1)
        WHERE P.idProducto = p_idClase;
	END IF;
    
    IF p_tipoOperacion = 7 THEN 	 		SELECT 
			idPresentacion, idProducto, nombre, cantidad, idUnidadMedida, M.descripcion as 'unidadMedida'
		FROM PRESENTACION P
        INNER JOIN MULTITABLA M ON M.abrev = P.idUnidadMedida and M.dep_id = 3
		WHERE idProducto = p_idProducto
        ORDER BY idPresentacion;
	END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarProductos` (IN `p_idProducto` INT, IN `p_idClase` INT, IN `p_idSubcategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN     		
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            (CASE WHEN P.activo = 1 THEN 'SI' 
				WHEN P.activo = 0 THEN 'NO' 
			END) AS activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria 
        WHERE P.anulado = 0
		ORDER BY P.nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.codigoContable,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria   
        WHERE P.activo = 1 and P.anulado = 0
		ORDER BY P.idProducto;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 			
		SELECT       
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.codigoContable,
            P.marca,
            P.modelo, P.medida, P.codigoContable, P.cod_fab, P.stockMin, P.stockActual, P.unidad_medida, P.tipo_existencia,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
        WHERE P.idProducto = p_idProducto and P.anulado = 0;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria       
        WHERE P.idClase = p_idClase and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre;
	END IF;       
    
    IF p_tipoOperacion = 5 THEN 	
		SELECT CP.idCatalogo, CP.idProveedor, CP.nombre, CP.codigo, P.nombreEmpresa        
        FROM CATALOGO_PROVEEDOR CP
        INNER JOIN PROVEEDOR P ON P.idProveedor = CP.idProveedor
        WHERE idProducto = p_idProducto and P.anulado = 0
        ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 6 THEN   		
		SELECT 
			P.idProducto,
            CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.codigoContable,
            P.nombre
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        WHERE P.activo = 1 and P.anulado = 0
		ORDER BY P.codigoContable;
	END IF;
    
    IF p_tipoOperacion = 7 THEN     		
		SELECT 
			P.idProducto,            
            CONCAT(C.abreviatura, '-', P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.medida,
            P.cod_fab,
			P.stockMin, P.stockActual, 
            P.unidad_medida, M.descripcion as unidadMedida, P.tipo_existencia, M2.descripcion as tipoExistencia,
    
            (CASE WHEN P.activo = 1 THEN 'SI' 
				WHEN P.activo = 0 THEN 'NO' 
			END) AS activo,
            CASE 
				WHEN P.stockMin = 0 and P.stockActual < P.stockMin then 'BAJO' 
                WHEN P.stockMin = 0 and P.stockActual >= P.stockMin and P.stockActual <= 5 then 'MEDIO' 
                WHEN P.stockMin = 0 and P.stockActual > 5 then 'ALTO' 
				WHEN P.stockMin > 0 and P.stockActual <= P.stockMin then 'BAJO' 
				WHEN P.stockMin > 0 and P.stockActual > P.stockMin and P.stockActual <= 1.5*P.stockMin THEN 'MEDIO'
				WHEN P.stockMin > 0 and P.stockActual >= 1.5*P.stockMin THEN 'ALTO'                
			END AS 'estado'
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
		INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
		INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
        WHERE P.anulado = 0
		ORDER BY P.nombre;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarProveedores` (IN `p_idProveedor` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		select 
			P.idProveedor,
            P.nombreEmpresa,
			(SELECT CONCAT(C.nombre, ' ', C.apePaterno) FROM CONTACTO C WHERE C.idProveedor = p_idProveedor LIMIT 1) as nombre,
            M1.descripcion as rubro,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email   ,
            (CASE WHEN P.activo = 1 THEN 'SI'
				WHEN P.activo = 0 THEN 'NO'
			END) AS activo
		FROM PROVEEDOR P
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        LEFT JOIN MULTITABLA M2 ON M2.valor = P.idEstado AND M2.dep_id = 2
        WHERE M1.dep_id = 1
		ORDER BY P.nombreEmpresa;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		select 
			P.idProveedor, 
			P.idContacto,
            P.nombreEmpresa,
			CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		from PROVEEDOR P
		INNER JOIN CONTACTO C ON C.idContacto = P.idContacto
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEstado 
        WHERE M1.dep_id = 1 AND M2.dep_id = 2 AND P.activo = 1 and C.activo = 1
		ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT
			P.idProveedor, P.idRubro, P.idEstado,
            P.idPais, P.idCiudad, P.nombreEmpresa, P.nombreComercial,
            P.ruc, P.email, P.telefono1, P.telefono2, P.telefono3, 
            P.direccion, P.referencia, P.cuentaInstagram, P.cuentaFacebook, P.activo as activoProveedor,
			C.idContacto, C.dni, C.nombre, C.apePaterno, C.apeMaterno,
            C.cargo, C.telefono, C.comentario, C.calificacion, C.email as emailContacto, C.activo as activoContacto
		FROM PROVEEDOR P
		LEFT JOIN CONTACTO C ON C.idProveedor = P.idProveedor and C.activo = 1
        WHERE P.idProveedor = p_idProveedor;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		select 
			P.idProveedor, 
			P.idContacto,
            P.nombreEmpresa,
			CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		from PROVEEDOR P
		INNER JOIN CONTACTO C ON C.idContacto = P.idContacto
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEstado 
        WHERE M1.dep_id = 1 AND M2.dep_id = 2 AND P.activo = 1 and C.activo = 1 and P.idRubro in (2,3)
		ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 5 THEN 	
		select 
			P.idProveedor, 			
            P.nombreEmpresa,
			-- CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		FROM PROVEEDOR P
		-- INNER JOIN CONTACTO C ON C.idProveedor = P.idProveedor
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        LEFT JOIN MULTITABLA M2 ON M2.valor = P.idEstado AND M2.dep_id = 2
        WHERE M1.dep_id = 1 AND P.activo = 1 -- and C.activo = 1 
			and P.idRubro in (1,3)
		ORDER BY P.nombreEmpresa;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarRoles` (IN `p_idRol` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			idRol,
            nombre,
            descripcion,
            CASE WHEN activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM ROL
        WHERE idRol > 1
        ORDER BY nombre ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			idRol,
            nombre,
            descripcion,
            CASE WHEN activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM ROL
        WHERE idRol > 1 and activo = 1
        ORDER BY nombre ASC;
	END IF;
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idRol,
            nombre,
            descripcion,
            activo
        FROM ROL
        WHERE idRol = p_idRol;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarRolTarea` (IN `p_idRolTarea` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			RT.idRolTarea,
            R.idRol,
            T.idTarea,
            R.nombre AS rol,
            T.nombre AS tarea,
            CASE WHEN RT.activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM ROL_TAREA RT
        INNER JOIN ROL R ON R.idRol = RT.idRol and R.idRol > 1
        INNER JOIN TAREA T ON T.idTarea = RT.idTarea
        ORDER BY R.nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			RT.idRolTarea,
            R.idRol,
            T.idTarea,
            R.nombre AS rol,
            T.nombre AS tarea,
            CASE WHEN RT.activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM ROL_TAREA RT
        INNER JOIN ROL R ON R.idRol = RT.idRol and R.idRol > 1
        INNER JOIN TAREA T ON T.idTarea = RT.idTarea
        WHERE activo = 1
        ORDER BY R.nombre;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idRolTarea,
            idRol,
            idTarea,
            activo
        FROM ROL_TAREA
        WHERE idRolTarea = p_idRolTarea and idRol > 1;
	END IF;    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarStockProductos` (IN `p_idProducto` INT, IN `p_idClase` INT, IN `p_idSubcategoria` INT, IN `p_indicador` VARCHAR(100), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN 		
        CREATE TEMPORARY TABLE STOCK_TEMP as (
			SELECT idProducto, nombreProducto,DNA.cantidadTotal,
				SUM( CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal 
					ELSE 0.00 END) AS cantidadEntrada,
				SUM( CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal 
				ELSE 0.00 END) AS cantidadSalida,
				DNA.unidadMedida
			FROM DETALLE_NOTA_ALMACEN DNA
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen 
			WHERE date(NA.fechaEmision) BETWEEN p_fechaInicio AND p_fechaFin
			GROUP BY DNA.idProducto  -- , DNA.nombreProducto, DNA.unidadMedida
		);
    
    
		CREATE TEMPORARY TABLE REPORTE_TEMP as (
			SELECT 
				P.idProducto,
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase',
				P.marca,
				P.modelo,
				P.medida,
				P.cod_fab,
				P.stockMin, ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) as stockActual, 
				P.unidad_medida, M.descripcion as unidadMedida, P.tipo_existencia, M2.descripcion as tipoExistencia,
		
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
				CASE 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) < P.stockMin then 'BAJO' 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) >= P.stockMin and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= 5 then 'MEDIO' 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) > 5 then 'ALTO' 
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= P.stockMin then 'BAJO' 
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) > P.stockMin and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= 1.5*P.stockMin THEN 'MEDIO'
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) >= 1.5*P.stockMin THEN 'ALTO'                
				END AS 'indicador'
			FROM PRODUCTO P
            LEFT JOIN STOCK_TEMP ST ON ST.idProducto = P.idProducto
			INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
			INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
			INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
		);
        
        SELECT * FROM REPORTE_TEMP WHERE (indicador = p_indicador or p_indicador = '0') ORDER BY nombre;
        
        drop temporary table STOCK_TEMP;
        drop temporary table REPORTE_TEMP;
	END IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarSubcategorias` (IN `p_idSubcategoria` INT, IN `p_idCategoria` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			S.idSubcategoria,            
			S.idCategoria,
            C.nombre as 'categoria',
            S.nombre,
            S.descripcion,
            S.abreviatura,
            S.codigo,
            (CASE WHEN S.activo = 1 THEN 'SI'
				WHEN S.activo = 0 THEN 'NO'
			END) AS activo
		FROM SUBCATEGORIA S
        INNER JOIN CATEGORIA C ON C.idCategoria = S.idCategoria
		ORDER BY S.nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			S.idSubcategoria,            
			S.idCategoria,
            C.nombre as 'categoria',
            S.nombre,
            S.descripcion,
            S.abreviatura,
            S.codigo,
            S.activo
		FROM SUBCATEGORIA S
        INNER JOIN CATEGORIA C ON C.idCategoria = S.idCategoria
        WHERE S.activo = 1
		ORDER BY S.nombre;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			S.idSubcategoria,            
			S.idCategoria,
            C.nombre as 'categoria',
            S.nombre,
            S.descripcion,
            S.abreviatura,
            S.codigo,
            S.activo
		FROM SUBCATEGORIA S
        INNER JOIN CATEGORIA C ON C.idCategoria = S.idCategoria
        WHERE S.idSubcategoria = p_idSubcategoria;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		SELECT 
			S.idSubcategoria,            
			S.idCategoria,
            C.nombre as 'categoria',
            S.nombre,
            S.descripcion,
            S.abreviatura,
            S.codigo,
            S.activo
		FROM SUBCATEGORIA S
        INNER JOIN CATEGORIA C ON C.idCategoria = S.idCategoria
        WHERE S.idCategoria = p_idCategoria and S.activo = 1;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarTareas` (IN `p_idTarea` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			T.idTarea,
            G.idGrupo,
            G.nombre AS grupo,
            T.nombre AS tarea,
            T.url,
            T.descripcion,
            T.activo
        FROM TAREA T
        INNER JOIN GRUPO G ON G.idGrupo = T.idGrupo
        ORDER BY T.nombre ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			T.idTarea,
            G.idGrupo,
            G.nombre AS grupo,
            T.nombre AS tarea,
            T.url,
            T.descripcion,
            T.activo
        FROM TAREA T
        INNER JOIN GRUPO G ON G.idGrupo = T.idGrupo
        WHERE T.activo = 1
        ORDER BY T.nombre ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			idTarea,
            idGrupo,
            nombre,
            descripcion,
            url,
            activo
        FROM TAREA 
        WHERE idTarea = p_idTarea;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarTasaCambio` (IN `p_idTasaCambio` INT, IN `p_tipoOperacion` INT)  BEGIN
	IF p_tipoOperacion = 1 THEN
        SELECT idTasaCambio, fecha, date_format(fecha, '%d/%m/%Y') as fechaFormato, 
			tipoMoneda, M.descripcion as 'moneda',
			precioCompra, precioVenta, 
			case when TS.activo = 1 then 'SI'
				else 'NO' end as activo
		FROM TASA_CAMBIO TS
        INNER JOIN MULTITABLA M ON M.valor = TS.tipoMoneda and M.dep_id = 20;
    END	IF;
    
    IF p_tipoOperacion = 2 THEN
        SELECT idTasaCambio, fecha, date_format(fecha, '%d/%m/%Y') as fechaFormato, 
        tipoMoneda, M.descripcion as 'moneda',
			precioCompra, precioVenta, 
			case when TS.activo = 1 then 'SI'
				else 'NO' end as activo
		FROM TASA_CAMBIO TS
        INNER JOIN MULTITABLA M ON M.valor = TS.tipoMoneda and M.dep_id = 20
        WHERE TS.activo = 1;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN
        SELECT idTasaCambio, fecha, date_format(fecha, '%d/%m/%Y') as fechaFormato, tipoMoneda,
			precioCompra, precioVenta, activo
		FROM TASA_CAMBIO
        WHERE idTasaCambio = p_idTasaCambio;
    END	IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarTrabajador` (IN `p_idTrabajador` INT, IN `p_tipoOperacion` INT)  BEGIN
    IF p_tipoOperacion = 1 THEN          
		SELECT 
            idTrabajador,
            CONCAT(nombre , ' ' , apePaterno , ' ' , apeMaterno) as 'Nombre Completo',
            dni,
            direccion,
            telefono,
            celular,
            email,
            activo
        FROM TRABAJADOR where t.idTrabajador  > 1
        ORDER BY nombre;
    END IF; 
    IF p_tipoOperacion = 2 THEN         SELECT 
            t.idTrabajador,
            CONCAT(t.nombre , ' ' , t.apePaterno , ' ' , t.apeMaterno) as 'Nombre Completo',
            t.dni,
            t.direccion,
            t.telefono,
            t.celular,
            t.email,
            m.descripcion,
            (CASE WHEN t.activo = 1 THEN 'SI'
				WHEN t.activo = 0 THEN 'NO' 
			END) AS activo
        FROM TRABAJADOR t
        INNER JOIN MULTITABLA m on t.idTipo = m.valor and dep_id = 9 and t.idTrabajador  > 1
        ORDER BY t.nombre;
    END IF; 
    IF p_tipoOperacion = 3 THEN         
		SELECT 
            idTrabajador,
            nombre, 
            apePaterno , 
            apeMaterno,
            dni,
            direccion,
            fechaNacimiento,
            sexo,
            celular,
            email,
            telefono,
            idTipo,
            activo
        FROM TRABAJADOR
        WHERE idTrabajador = p_idTrabajador and idTrabajador  > 1;
    END IF;
    IF p_tipoOperacion = 4 THEN         
		SELECT 
            valor,
            descripcion
        FROM MULTITABLA
        WHERE dep_id = 9;     
	END IF; 
    IF p_tipoOperacion = 5 THEN         
		create temporary table usuario_temp
        as
        (
        
        SELECT 
            T.idTrabajador,
            CONCAT(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno) as nombreCompleto,
            U.idUsuario
        FROM TRABAJADOR T
        left join USUARIO U ON ( U.idTrabajador = T.idTrabajador and U.activo = 1)
        WHERE T.activo = 1   and T.idTrabajador  > 1
        );
        
        select * from usuario_temp where idUsuario is null;
        
        drop table usuario_temp;
    END IF;
    IF p_tipoOperacion = 6 THEN         SELECT 
            T.idTrabajador,
            CONCAT(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno) as nombreCompleto
        FROM TRABAJADOR T      
        WHERE T.activo = 1  and T.idTrabajador  > 1;
    END IF;    
    IF p_tipoOperacion = 7 THEN         SELECT 
            T.idTrabajador,
            CONCAT(T.nombre, ' ', T.apePaterno, ' ', T.apeMaterno) as nombreCompleto
        FROM TRABAJADOR T  		      
        WHERE T.activo = 1 AND (T.idTipo = 5 OR T.idTipo = 8)  and T.idTrabajador  > 1
		  ORDER BY T.nombre ASC;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarTrazabilidad` (IN `p_idCotizacion` INT, IN `p_estado` CHAR(2), IN `p_busqueda` VARCHAR(50), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)  BEGIN 
	DECLARE cor char(7);
    DECLARE id int;
    
	IF p_tipoOperacion = 1 THEN  	
		SELECT 
			GC.idGrupoCotizacion, 
						            (CASE WHEN GC.correlativo is null THEN '-'
				ELSE CONCAT('GC-', GC.correlativo)
			end) as 'GCcorrelativo',
			CT.idCotizacion, 			(CASE WHEN CT.correlativo is null THEN '-'
				ELSE CONCAT('CT-',CT.correlativo)
			end) as 'CTcorrelativo',
            CT.codCotizacion, 			(CASE WHEN CT.codCotizacion is null THEN '-'
				ELSE CT.codCotizacion
			end) as 'CTPcorrelativo',
			OC.idOrdenCompra, 
						(CASE WHEN OC.correlativo is null THEN '-'
				ELSE CONCAT('OC-', OC.correlativo)
			end) as 'OCcorrelativo',
			CM.idCompra, 			(CASE WHEN CM.correlativo is null THEN '-'
				ELSE CONCAT('CM-', CM.correlativo)
			end) as 'CMcorrelativo',
            NA.idNotaAlmacen,
            (CASE WHEN NA.correlativo is null THEN '-'
				ELSE  CONCAT('NA-', NA.correlativo)
			end) as 'NAcorrelativo',
			'prueba' as prueba
		FROM GRUPO_COTIZACION GC
		LEFT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
		LEFT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
		LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
		LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
		WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
				OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
				OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
				OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
				)
				AND (GC.estado = p_estado or p_estado = '0')
						UNION
        SELECT GC.idGrupoCotizacion, 
			            (CASE WHEN GC.correlativo is null THEN '-'
				ELSE CONCAT('GC-', GC.correlativo)
			end) as 'GCcorrelativo',
			CT.idCotizacion, 			(CASE WHEN CT.correlativo is null THEN '-'
				ELSE CONCAT('CT-', CT.correlativo)
			end) as 'CTcorrelativo',
            CT.codCotizacion, 			(CASE WHEN CT.codCotizacion is null THEN '-'
				ELSE CT.codCotizacion
			end) as 'CTPcorrelativo',
			OC.idOrdenCompra, 
						(CASE WHEN OC.correlativo is null THEN '-'
				ELSE CONCAT('OC-', OC.correlativo)
			end) as 'OCcorrelativo',
			CM.idCompra, 			(CASE WHEN CM.correlativo is null THEN '-'
				ELSE CONCAT('CM-', CM.correlativo)
			end) as 'CMcorrelativo',
            NA.idNotaAlmacen,
            (CASE WHEN NA.correlativo is null THEN '-'
				ELSE CONCAT('NA-', NA.correlativo)
			end) as 'NAcorrelativo',
			'prueba' as prueba
		FROM GRUPO_COTIZACION GC
		RIGHT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
		RIGHT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
		LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
		LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
		WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
				OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
				OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
				OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
				)
				AND (GC.estado = p_estado or p_estado = '0');
			           
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN  	
		CREATE TEMPORARY TABLE TRAZA_COMPRAS_TEMP AS (
		SELECT * FROM (
			SELECT 
				GC.idGrupoCotizacion, 
												(CASE WHEN GC.correlativo is null THEN '-'
					ELSE CONCAT('GC-', GC.correlativo)
				end) as 'GCcorrelativo',
				CT.idCotizacion, 				(CASE WHEN CT.correlativo is null THEN '-'
					ELSE CONCAT('CT-',CT.correlativo)
				end) as 'CTcorrelativo',
				CT.codCotizacion, 				(CASE WHEN CT.codCotizacion is null THEN '-'
					ELSE CT.codCotizacion
				end) as 'CTPcorrelativo',
				OC.idOrdenCompra, 
								(CASE WHEN OC.correlativo is null THEN '-'
					ELSE CONCAT('OC-', OC.correlativo)
				end) as 'OCcorrelativo',
				CM.idCompra, 				(CASE WHEN CM.correlativo is null THEN '-'
					ELSE CONCAT('CM-', CM.correlativo)
				end) as 'CMcorrelativo',
				NA.idNotaAlmacen,
				(CASE WHEN NA.correlativo is null THEN '-'
					ELSE  CONCAT('NA-', NA.correlativo)
				end) as 'NAcorrelativo',
				'prueba' as prueba
			FROM GRUPO_COTIZACION GC
			LEFT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
			LEFT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
			LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
			LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
			WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
					OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
					OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
					OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
					)
					AND (GC.estado = p_estado or p_estado = '0')
								UNION
			SELECT GC.idGrupoCotizacion, 
								(CASE WHEN GC.correlativo is null THEN '-'
					ELSE CONCAT('GC-', GC.correlativo)
				end) as 'GCcorrelativo',
				CT.idCotizacion, 				(CASE WHEN CT.correlativo is null THEN '-'
					ELSE CONCAT('CT-', CT.correlativo)
				end) as 'CTcorrelativo',
				CT.codCotizacion, 				(CASE WHEN CT.codCotizacion is null THEN '-'
					ELSE CT.codCotizacion
				end) as 'CTPcorrelativo',
				OC.idOrdenCompra, 
								(CASE WHEN OC.correlativo is null THEN '-'
					ELSE CONCAT('OC-', OC.correlativo)
				end) as 'OCcorrelativo',
				CM.idCompra, 				(CASE WHEN CM.correlativo is null THEN '-'
					ELSE CONCAT('CM-', CM.correlativo)
				end) as 'CMcorrelativo',
				NA.idNotaAlmacen,
				(CASE WHEN NA.correlativo is null THEN '-'
					ELSE CONCAT('NA-', NA.correlativo)
				end) as 'NAcorrelativo',
				'prueba' as prueba
			FROM GRUPO_COTIZACION GC
			RIGHT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
			RIGHT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
			LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
			LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
			WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
					OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
					OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
					OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
					)
					AND (GC.estado = p_estado or p_estado = '0')
				   		) X );
            
        
        CREATE TEMPORARY TABLE TRAZA_ORDENES_TEMP AS (
			SELECT * FROM (
				SELECT OTM.idOrdenMantenimiento,
                (CASE WHEN OTM.correlativo is null THEN '-'
					ELSE CONCAT('OTM-', OTM.correlativo)
				end) as 'OTMcorrelativo',
                null as idOrdenServicio, '-' as OScorrelativo, DOM.idCompra
				FROM ORDEN_MANTENIMIENTO OTM 
				LEFT JOIN DETALLE_ORDEN_MANTENIMIENTO DOM ON DOM.idOrdenMantenimiento = OTM.idOrdenMantenimiento AND idCompra is not null
				LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenMantenimiento = OTM.idOrdenMantenimiento and OS.idOrdenServicio is not null 
				UNION
				SELECT OTM.idOrdenMantenimiento,
                (CASE WHEN OTM.correlativo is null THEN '-'
					ELSE CONCAT('OTM-', OTM.correlativo)
				end) as 'OTMcorrelativo',
				OS.idOrdenServicio, 
				(CASE WHEN OS.correlativo is null THEN '-'
					ELSE CONCAT('OS-', OS.correlativo)
				end) as 'OScorrelativo', DOS.idCompra
				FROM ORDEN_MANTENIMIENTO OTM 
				INNER JOIN ORDEN_SERVICIO OS ON OS.idOrdenMantenimiento = OTM.idOrdenMantenimiento and OS.idOrdenServicio is not null
				LEFT JOIN DETALLE_ORDEN_SERVICIO DOS ON DOS.idOrdenServicio = OS.idOrdenServicio AND DOS.idCompra is not null
			) X order by idOrdenMantenimiento, idOrdenServicio
		);
		
		SELECT TOP.idOrdenMantenimiento, TOP.OTMcorrelativo, TOP.idOrdenServicio, TOP.OScorrelativo, 
			TCT.idGrupoCotizacion, ifnull(TCT.GCcorrelativo, '-') as GCcorrelativo,
            TCT.idCotizacion, ifnull(TCT.CTcorrelativo, '-') as CTcorrelativo,
            ifnull(TCT.codCotizacion, '-') as codCotizacion, ifnull(TCT.codCotizacion, '-') as CTPcorrelativo,
            TCT.idOrdenCompra, ifnull(TCT.OCcorrelativo, '-') as OCcorrelativo,
            TCT.idCompra, ifnull(TCT.CMcorrelativo, '-') as CMcorrelativo,
            TCT.idNotaAlmacen, ifnull(TCT.NAcorrelativo, '-') as NAcorrelativo
		FROM TRAZA_ORDENES_TEMP TOP
		LEFT JOIN TRAZA_COMPRAS_TEMP TCT ON TCT.idCompra = TOP.idCompra
		ORDER BY TOP.OTMcorrelativo asc, TOP.OScorrelativo asc, TCT.CMcorrelativo asc; 
		DROP TEMPORARY TABLE TRAZA_ORDENES_TEMP;
		DROP TEMPORARY TABLE TRAZA_COMPRAS_TEMP;
    END	IF; 
    
    IF p_tipoOperacion = 3 THEN  	
		CREATE TEMPORARY TABLE TRAZA_COMPRAS_TEMP AS (
			SELECT * FROM (
				SELECT 
					GC.idGrupoCotizacion, 
															(CASE WHEN GC.correlativo is null THEN '-'
						ELSE CONCAT('GC-', GC.correlativo)
					end) as 'GCcorrelativo',
					CT.idCotizacion, 					(CASE WHEN CT.correlativo is null THEN '-'
						ELSE CONCAT('CT-',CT.correlativo)
					end) as 'CTcorrelativo',
					CT.codCotizacion, 					(CASE WHEN CT.codCotizacion is null THEN '-'
						ELSE CT.codCotizacion
					end) as 'CTPcorrelativo',
					OC.idOrdenCompra, 
										(CASE WHEN OC.correlativo is null THEN '-'
						ELSE CONCAT('OC-', OC.correlativo)
					end) as 'OCcorrelativo',
					CM.idCompra, 					(CASE WHEN CM.correlativo is null THEN '-'
						ELSE CONCAT('CM-', CM.correlativo)
					end) as 'CMcorrelativo',
                    NA.idNotaAlmacen,
					(CASE WHEN NA.correlativo is null THEN '-'
						ELSE  CONCAT('NA-', NA.correlativo)
					end) as 'NAcorrelativo',
					'prueba' as prueba
				FROM GRUPO_COTIZACION GC
				LEFT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
				LEFT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
				LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
				LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
				WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
						OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
						OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
						OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
						)
						AND (GC.estado = p_estado or p_estado = '0')
										UNION
				SELECT GC.idGrupoCotizacion, 
										(CASE WHEN GC.correlativo is null THEN '-'
						ELSE CONCAT('GC-', GC.correlativo)
					end) as 'GCcorrelativo',
					CT.idCotizacion, 					(CASE WHEN CT.correlativo is null THEN '-'
						ELSE CONCAT('CT-', CT.correlativo)
					end) as 'CTcorrelativo',
					CT.codCotizacion, 					(CASE WHEN CT.codCotizacion is null THEN '-'
						ELSE CT.codCotizacion
					end) as 'CTPcorrelativo',
					OC.idOrdenCompra, 
										(CASE WHEN OC.correlativo is null THEN '-'
						ELSE CONCAT('OC-', OC.correlativo)
					end) as 'OCcorrelativo',
					CM.idCompra, 					(CASE WHEN CM.correlativo is null THEN '-'
						ELSE CONCAT('CM-', CM.correlativo)
					end) as 'CMcorrelativo',
                    NA.idNotaAlmacen,
					(CASE WHEN NA.correlativo is null THEN '-'
						ELSE CONCAT('NA-', NA.correlativo)
					end) as 'NAcorrelativo',
					'prueba' as prueba
				FROM GRUPO_COTIZACION GC
				RIGHT JOIN COTIZACION CT ON CT.idGrupoCotizacion = GC.idGrupoCotizacion
				RIGHT JOIN ORDEN_COMPRA OC ON OC.idCotizacion = CT.idCotizacion
				LEFT JOIN COMPRA CM ON CM.idOrdenCompra = OC.idOrdenCompra
				LEFT JOIN NOTA_ALMACEN NA ON NA.idCompra = CM.idCompra
				WHERE (   (   CONCAT('CT-', CT.correlativo)   LIKE CONCAT('%', p_busqueda, '%'))
						OR (   CONCAT('GC-', GC.correlativo)  LIKE CONCAT('%', p_busqueda, '%'))
						OR (   CONCAT('OC-', OC.correlativo)  LIKE CONCAT('%', p_busqueda, '%')  )      
						OR (   CONCAT('CM-', CM.correlativo)  LIKE CONCAT('%', p_busqueda, '%') )
						)
						AND (GC.estado = p_estado or p_estado = '0')
					   			) X 
        );
            
        
        CREATE TEMPORARY TABLE TRAZA_ORDENES_TEMP AS (
			SELECT * FROM (
				SELECT  OS.idOrdenServicio, 
					(CASE WHEN OS.correlativo is null THEN '-'
						ELSE CONCAT('OS-', OS.correlativo)
					end) as 'OScorrelativo',
					NULL AS idOrdenMantenimiento, '-' OTMcorrelativo,
					DOS.idCompra
				FROM ORDEN_SERVICIO OS  
				LEFT JOIN DETALLE_ORDEN_SERVICIO DOS ON DOS.idOrdenServicio = OS.idOrdenServicio AND DOS.idCompra is not null
								UNION
				
				SELECT  OS.idOrdenServicio, 
					(CASE WHEN OS.correlativo is null THEN '-'
						ELSE CONCAT('OS-', OS.correlativo)
					end) as 'OScorrelativo',
					OTM.idOrdenMantenimiento,
					(CASE WHEN OTM.correlativo is null THEN '-'
						ELSE CONCAT('OTM-', OTM.correlativo)
					end) as 'OTMcorrelativo',
					DOM.idCompra
				FROM ORDEN_SERVICIO OS  
				INNER JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = OS.idOrdenMantenimiento
				LEFT JOIN DETALLE_ORDEN_MANTENIMIENTO DOM ON DOM.idOrdenMantenimiento = OTM.idOrdenMantenimiento AND idCompra is not null
				GROUP BY OS.idOrdenServicio , OTM.idOrdenMantenimiento, DOM.idCompra
			) X order by idOrdenMantenimiento, idOrdenServicio
		);
		
		SELECT  TOP.idOrdenServicio, TOP.OScorrelativo, TOP.idOrdenMantenimiento, TOP.OTMcorrelativo,
			TCT.idGrupoCotizacion, ifnull(TCT.GCcorrelativo, '-') as GCcorrelativo,
            TCT.idCotizacion, ifnull(TCT.CTcorrelativo, '-') as CTcorrelativo,
            ifnull(TCT.codCotizacion, '-') as codCotizacion, ifnull(TCT.codCotizacion, '-') as CTPcorrelativo,
            TCT.idOrdenCompra, ifnull(TCT.OCcorrelativo, '-') as OCcorrelativo,
            TCT.idCompra, ifnull(TCT.CMcorrelativo, '-') as CMcorrelativo,
            TCT.idNotaAlmacen, ifnull(TCT.NAcorrelativo, '-') as NAcorrelativo
		FROM TRAZA_ORDENES_TEMP TOP
		LEFT JOIN TRAZA_COMPRAS_TEMP TCT ON TCT.idCompra = TOP.idCompra
		ORDER BY TOP.OScorrelativo asc, TOP.OTMcorrelativo asc, TCT.CMcorrelativo asc; 
		DROP TEMPORARY TABLE TRAZA_ORDENES_TEMP;
		DROP TEMPORARY TABLE TRAZA_COMPRAS_TEMP;
    END	IF; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarUsuarios` (IN `p_idUsuario` INT, IN `p_tipoOperacion` INT)  BEGIN    
	IF p_tipoOperacion = 1 THEN 
		SELECT 
			U.idUsuario,
            CONCAT(T.nombre, ' ', T.apePaterno) As 'nombre',
            T.dni,
            R.nombre as 'rol',
            U.login,
            T.sexo,
            CASE WHEN U.activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM USUARIO U 
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        INNER JOIN ROL R ON R.idRol = U.idRol and R.idRol > 1
        ORDER BY CONCAT(T.nombre, ' ', T.apePaterno) ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			U.idUsuario,
            CONCAT(T.nombre, ' ', T.apePaterno) As 'nombre',
            T.dni,
            R.nombre as 'rol',
            U.login,
            T.sexo,
            CASE WHEN U.activo = 1 THEN 'SI' ELSE 'NO' END AS 'activo'
        FROM USUARIO U 
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        INNER JOIN ROL R ON R.idRol = U.idRol and R.idRol > 1
        WHERE U.activo = 1
        ORDER BY CONCAT(T.nombre, ' ', T.apePaterno) ASC;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT 
			U.idUsuario,
            U.idTrabajador,
            U.idRol,
            U.login,
            U.activo
        FROM USUARIO U 
        INNER JOIN TRABAJADOR T ON T.idTrabajador = U.idTrabajador
        INNER JOIN ROL R ON R.idRol = U.idRol and R.idRol >  1
        WHERE U.idUsuario = p_idUsuario;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarVehiculo` (IN `p_idUnidad` INT, IN `p_tipoOperacion` INT)  BEGIN  
            
	IF p_tipoOperacion = 1 THEN
        SELECT UM.idUnidad, UM.placa, UM.descripcion, UM.tipo, 
        M.descripcion as 'tipoVehiculo',
          CASE WHEN UM.activo = 1 THEN 'SI'
                ELSE 'NO'
            END AS activo
        FROM UNIDAD_MOVIL UM
        INNER JOIN MULTITABLA M ON M.valor = UM.tipo and M.dep_id = 19
        ORDER BY UM.placa ASC;
    END IF; 

    IF p_tipoOperacion = 2 THEN        
        SELECT UM.idUnidad, UM.placa, UM.descripcion, UM.tipo, 
        M.descripcion as 'tipoVehiculo',
          CASE WHEN UM.activo = 1 THEN 'SI'
                ELSE 'NO'
            END AS activo
        FROM UNIDAD_MOVIL UM
        INNER JOIN MULTITABLA M ON M.valor = UM.tipo and M.dep_id = 19
        WHERE UM.activo = 1
        ORDER BY UM.placa ASC;
    END IF;
    
    IF p_tipoOperacion = 3 THEN
        SELECT idUnidad, placa, descripcion, tipo, activo
        FROM UNIDAD_MOVIL
        WHERE idUnidad = p_idUnidad;
    END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_obtenerIgv` (IN `p_anioActual` INT)  BEGIN
	
    SELECT
			idIGV,
			porcentaje AS porcentaje_igv
	FROM	IGV
    WHERE	anio = p_anioActual
			AND activo = 1;
	
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_obtenerTipoCambio` (IN `p_fecha` DATE)  BEGIN
	IF EXISTS (SELECT	precioVenta
				FROM 	TASA_CAMBIO 
                WHERE 	fecha = p_fecha 
						AND activo = 1) 
		THEN
            SELECT 	precioVenta AS tipo_cambio,
					1 AS respuesta
			FROM 	TASA_CAMBIO 
			WHERE 	fecha = p_fecha 
					AND activo = 1;
        ELSE
			
            SELECT 	0 AS respuesta,
					'No se ha ingresado Tasa de Cambio el día de hoy.' AS mensaje;
            
        END IF;
	
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_reporteKardexProducto` (IN `p_idProducto` INT, IN `p_anio` INT, IN `tipoOperacion` INT)  BEGIN      
    DECLARE nFilas int;
    DECLARE v_idProducto int;    
    DECLARE v_idDetaNota int;
    DECLARE v_fechaEmision datetime;
    DECLARE v_fechaContable datetime;
    
    -- DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_precioUnitarioSalida decimal(18,2);
    
    DECLARE v_cantidadEntrada decimal(18,2);
    DECLARE v_costoUnitarioEntrada decimal(18,2);
    DECLARE v_costoTotalEntrada decimal(18,2);
    
    DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_costoUnitarioSalida decimal(18,2);
    DECLARE v_costoTotalSalida decimal(18,2);
    
    DECLARE v_cantidadSaldo decimal(18,2);
    DECLARE v_costoUnitarioSaldo decimal(18,2);
    DECLARE v_costoTotalSaldo decimal(18,2);
    
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
    
    DECLARE v_tipoNota char(5);
    DECLARE v_contador int;
    
    IF tipoOperacion = 1 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,				
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioIngresado',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioIngresado',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoIngresado',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSalida',
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.monto ELSE '' END AS 'montoSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSaldo',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc );
		
        
        -- select * from kardex_temp;
        
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
			
			(SELECT ifnull( sum(case when cantidadSaldo = '' then 0.00 else ifnull(cantidadSaldo, 0.00) end), 0.00 ) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1);
			
			-- select @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_cantidadSaldo;
			UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
			-- select * from kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1;
			
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN ''
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
		-- SELECT * FROM kardex_temp;
		-- SELECT * FROM kardex_temp2;
        
        SELECT idDetaNota, idProducto, fechaEmision, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			
            cantidadIngresada as cantidadEntrada, 
            precioUnitarioIngresado as costoUnitarioEntrada, 
            montoIngresado as costoTotalEntrada, 
            
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, 
            precioUnitarioSalida as costoUnitarioSalida, 
            montoSalida as costoTotalSalida,
			
            case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else precioUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else montoSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 2 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	NA.fechaEmision,	
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' THEN NA.tipoDocumento ELSE '' END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.serieDocumento ELSE '' END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.numeroDocumento ELSE '' END AS numeroDocumento,
				CASE WHEN NA.tipoNota = 'S' THEN UM.placa ELSE '' END AS placa,
				NA.tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
				CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioIngresado',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSalida',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.monto ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSaldo',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		WHERE year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc);
		
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, idProducto, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @v_idProducto, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
             
			(SELECT ifnull(sum(case when cantidadSaldo = ''  then 0.00
							when cantidadSaldo is null then 0.00 
							else cantidadSaldo end), 0.00) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and idProducto = @v_idProducto
									and precioUnitarioSaldo = @v_precioUnitarioSalida  and activo = 1);
			-- select * from kardex_temp2;
            -- select * from kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and idProducto = @v_idProducto
		    -- and precioUnitarioSaldo = @v_precioUnitarioSalida  and activo = 1;
            
			-- select @v_idDetaNota, @v_cantidadSalida, @v_cantidadSaldo, @v_idProducto;
			UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
			-- select * from kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1;
			
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
								and idProducto = @v_idProducto and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
		-- SELECT * FROM kardex_temp;
		SELECT * FROM kardex_temp2;
	END IF;
    
    IF tipoOperacion = 3 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioIngresado',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoIngresado',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.monto ELSE '' END AS 'montoSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
        GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @fechaEmision, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        -- select k.*, k.tipoOperacion from kardex_temp2 k;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaEmision, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' THEN NA.tipoDocumento ELSE '' END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.serieDocumento ELSE '' END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.numeroDocumento ELSE '' END AS numeroDocumento,
				(CASE WHEN NA.tipoNota = 'S' and NA.idOrdenMantenimiento is not null THEN UM1.placa
					  WHEN NA.tipoNota = 'S' and NA.idOrdenServicio is not null THEN UM2.placa 
				ELSE '' END) AS placa,
				-- NA.tipoOperacion,
                M2.descripcion as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioIngresado',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioIngresado',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoIngresado',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSalida',
				-- CASE WHEN NA.tipoNota = 'S' THEN DNA.monto ELSE '' END AS 'montoSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSaldo',
				-- CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM1 ON UM1.idUnidad = OM.idUnidad
		LEFT JOIN UNIDAD_MOVIL UM2 ON UM2.idUnidad = OS.idUnidad
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc );
		
        -- select * from kardex_temp;
        
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
			
			(SELECT ifnull( sum(case when cantidadSaldo = '' then 0.00 else ifnull(cantidadSaldo, 0.00) end), 0.00 ) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1);
			
			-- select @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_cantidadSaldo;
			UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
			-- select * from kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1;
			
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN ''
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
		-- SELECT * FROM kardex_temp;
		SELECT * FROM kardex_temp2;
	END IF;
    
	IF tipoOperacion = 5 THEN
		SELECT P.idProducto, P.nombre, P.unidad_medida, M1.descripcion as 'unidadMedida', 
			P.tipo_existencia, CONCAT(P.tipo_existencia, ' ', M2.descripcion) as 'tipoExistencia',
            (SELECT direccion FROM OFICINA WHERE principal = 1 limit 1) as establecimiento,
			(SELECT ruc FROM EMPRESA WHERE idEmpresa = 1) as ruc,
            (SELECT razonSocial FROM EMPRESA WHERE idEmpresa = 1) as razonSocial         
		FROM PRODUCTO P 
		INNER JOIN MULTITABLA M1 ON M1.abrev = P.unidad_medida and M1.dep_id = 3
		INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
		WHERE P.idProducto = p_idProducto;
    END IF;
    
	IF tipoOperacion = 6 THEN
		SELECT NA.idNotaAlmacen, NA.fechaEmision, DNA.idProducto
		FROM NOTA_ALMACEN NA
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen and year(NA.fechaEmision) = p_anio and NA.estado = 'C'
		GROUP BY DNA.idProducto;
    END IF;
    
    IF tipoOperacion = 7 THEN
		SELECT NA.idNotaAlmacen, NA.fechaEmision, DNA.idProducto
		FROM NOTA_ALMACEN NA
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
			and year(NA.fechaContable) = p_anio and NA.estado = 'C' and DNA.idProducto = p_idProducto
		GROUP BY DNA.idProducto;
    END IF;
    
    IF tipoOperacion = 8 THEN  -- METODO PEPS
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				-- CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 1 as activo, 0 cantidadUsada
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        -- GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
        
		CREATE TEMPORARY TABLE kardex_temp2(SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		delete from kardex_temp2;
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        set @contador = 1;
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
				@v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
                
			IF(@contador = 1) THEN
				INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
					tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
					cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
					cantidadSalida, costoUnitarioSalida, costoTotalSalida,
					cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
				SELECT * 
				FROM kardex_temp LIMIT 1;
                
                set @contador = 2;
			ELSE
				DROP TEMPORARY TABLE IF EXISTS temp_entradas;
				
				CREATE TEMPORARY TABLE temp_entradas (
					SELECT * FROM kardex_temp2 
					WHERE fechaContable <= @v_fechaContable AND activo = 1 AND tipoNota = 'E'
				);
                SET @nFilas2 = (SELECT count(*) FROM temp_entradas);
				-- select * from temp_entradas ;
                
				IF ( @v_tipoNota = 'E') THEN
                        
					INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
						tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
						cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
						cantidadSalida, costoUnitarioSalida, costoTotalSalida,
						cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
					SELECT *
					FROM kardex_temp WHERE idDetaNota = @v_idDetaNota;
                    
                    WHILE @nFilas2 > 0 DO
						SET @v_idDetaNota2 = 0;
						SET @v_cantidadSaldo = 0;
                        
						SELECT idDetaNota, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1 and costoUnitarioEntrada =  @v_costoUnitarioEntrada
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        UPDATE kardex_temp2 
                        SET cantidadSaldo = cast( round(cantidadSaldo + @v_cantidadSaldo, 2)  as decimal(18,2)),
							costoTotalSaldo = cast( round( cantidadSaldo * costoUnitarioSaldo, 2)  as decimal(18,2))
                        WHERE idDetaNota = @v_idDetaNota;
                        
						UPDATE kardex_temp2
                        SET cantidadUsada = cast( round(cantidadSaldo, 2)  as decimal(18,2)),
							activo = 0
                        WHERE idDetaNota = @v_idDetaNota2;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				ELSE 
					WHILE @nFilas2 > 0 and @v_cantidadSalida > 0 DO
						set @v_idDetaNota2 = 0;
						set @v_cantidadSaldo = 0;
                        set @v_costoUnitarioEntrada = 0;
                        
						SELECT idDetaNota, costoUnitarioEntrada, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_costoUnitarioEntrada, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        IF @v_cantidadSalida <= @v_cantidadSaldo THEN
                        
							UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSalida, 
								activo = ( CASE WHEN  @v_cantidadSalida = @v_cantidadSaldo THEN 0 ELSE 1 END)
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round(cantidadSalida * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								cast( round(@v_cantidadSaldo - @v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( (@v_cantidadSaldo - @v_cantidadSalida)  * @v_costoUnitarioEntrada, 2)  as decimal(18,2)), 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;
                            
                            SET @v_cantidadSalida = 0;
						ELSE                            
                            UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
							UPDATE temp_entradas 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSaldo, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( @v_cantidadSaldo * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								0, @v_costoUnitarioEntrada, 0, 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;                           
                            
                            SET @v_cantidadSalida = @v_cantidadSalida - @v_cantidadSaldo;
						END IF;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				END IF;
            END IF;
            
            DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;	
			SET @nFilas = @nFilas - 1;
		END WHILE;
		
        UPDATE KARDEX_TEMP2 set cantidadSaldo = '', costoUnitarioSaldo = '', costoTotalSaldo = '' 
        WHERE cantidadSaldo = 0;
        
        UPDATE KARDEX_TEMP2 set activo = 0
        WHERE cantidadUsada > 0;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM KARDEX_TEMP2 k;
	END IF;
    
    IF tipoOperacion = 9 THEN  -- PROMEDIO
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				-- CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE 0 END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        -- GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_reporteProductosEntregados` (IN `p_idResponsable` INT, IN `p_tipoOperacion` INT)  BEGIN     
    IF p_tipoOperacion = 1 THEN
            SELECT NA.idNotaAlmacen, NA.idAlmacen, NA.idOrdenMantenimiento, NA.idOrdenServicio, NA.idUnidad, NA.idTrabajador,
				CONCAT ('NA-', NA.correlativo) AS correlativoNA, 
				NA.fechaEmision, date_format(NA.fechaEmision, '%d/%m/%Y') as fechaEmisionFormato,
				DNA.idProducto, DNA.nombreProducto, DNA.cantidadTotal, DNA.unidadMedida,
				ifnull ( concat('OTM-', OTM.correlativo) , '-') as correlativoOTM,
				ifnull ( concat('OS-', OS.correlativo) , '-') as correlativoOS
			FROM NOTA_ALMACEN NA
			INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen and NA.tipoNota = 'S' and NA.idTrabajador = p_idResponsable
			LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = NA.idOrdenMantenimiento
			LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio;
	END IF; 
    IF p_tipoOperacion = 2 THEN
		SELECT NA.idNotaAlmacen, NA.idAlmacen, NA.idOrdenMantenimiento, NA.idOrdenServicio, NA.idUnidad, NA.idTrabajador,
			CONCAT ('NA-', NA.correlativo) AS correlativoNA, 
			NA.fechaEmision, date_format(NA.fechaEmision, '%d/%m/%Y') as fechaEmisionFormato,
			DNA.idProducto, DNA.nombreProducto, DNA.cantidadTotal, DNA.unidadMedida,
			ifnull ( concat('OTM-', OTM.correlativo) , '-') as correlativoOTM,
			ifnull ( concat('OS-', OS.correlativo) , '-') as correlativoOS
		FROM NOTA_ALMACEN NA
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen and NA.tipoNota = 'S' and NA.idUnidad = p_idResponsable
		LEFT JOIN ORDEN_MANTENIMIENTO OTM ON OTM.idOrdenMantenimiento = NA.idOrdenMantenimiento
		LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio;
	END IF;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_verDatosPersona` (IN `p_idUsuario` INT)  BEGIN
	SELECT T.dni, T.nombre, T.apePaterno, T.apeMaterno,
		T.telefono, T.email, T.direccion, U.login, U.pass
	FROM TRABAJADOR T 
    INNER JOIN USUARIO U ON U.idTrabajador = T.idTrabajador
	WHERE U.idUsuario = p_idUsuario;
END$$

--
-- Funciones
--
CREATE DEFINER=`root`@`localhost` FUNCTION `fnGetCostoTotal` (`p_idProducto` INT, `p_fechaCorte` DATE) RETURNS DECIMAL(18,2) BEGIN
    DECLARE costoTotal DECIMAL(18,2);    
    
    DECLARE nFilas int;
    DECLARE v_idProducto int;    
    DECLARE v_idDetaNota int;
    DECLARE v_fechaEmision datetime;
    DECLARE v_fechaContable datetime;
    
    -- DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_precioUnitarioSalida decimal(18,2);
    
    DECLARE v_cantidadEntrada decimal(18,2);
    DECLARE v_costoUnitarioEntrada decimal(18,2);
    DECLARE v_costoTotalEntrada decimal(18,2);
    
    DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_costoUnitarioSalida decimal(18,2);
    DECLARE v_costoTotalSalida decimal(18,2);
    
    DECLARE v_cantidadSaldo decimal(18,2);
    DECLARE v_costoUnitarioSaldo decimal(18,2);
    DECLARE v_costoTotalSaldo decimal(18,2);
    
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
    
    DECLARE v_tipoNota char(5);
    DECLARE v_contador int;
    
    DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				-- CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE 0 END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and cast(NA.fechaContable as date) <= p_fechaCorte
        -- GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        SET @costoTotal = (        
			SELECT 
				(case when cantidadSaldo = 0 then 0
				else costoTotalSaldo end) as costoTotalSaldo
			FROM kardex_temp2 k WHERE activo = 1
			ORDER BY k.fechaContable DESC LIMIT 1);
    
    -- set @costoTotal = 55.5;
    RETURN @costoTotal;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `almacen`
--

CREATE TABLE `almacen` (
  `idAlmacen` int(11) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `descripcion` varchar(300) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `almacen`
--

INSERT INTO `almacen` (`idAlmacen`, `nombre`, `descripcion`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 'Principal', 'Principal', '2018-07-01 22:24:05', 'admin', '-', '2018-07-01 22:24:05', 'admin', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `catalogo_proveedor`
--

CREATE TABLE `catalogo_proveedor` (
  `idCatalogo` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `idProveedor` int(11) NOT NULL,
  `nombre` varchar(150) NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categoria`
--

CREATE TABLE `categoria` (
  `idCategoria` int(11) NOT NULL,
  `codigo` varchar(45) DEFAULT NULL,
  `nombre` varchar(150) NOT NULL,
  `descripcion` varchar(250) DEFAULT NULL,
  `abreviatura` char(5) DEFAULT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `categoria`
--

INSERT INTO `categoria` (`idCategoria`, `codigo`, `nombre`, `descripcion`, `abreviatura`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, '25', 'MATERIALES AUXILIARES,SUMINISTROS Y REPUESTOS', NULL, NULL, '2018-08-06 01:39:44', 'admin', '-', '2018-08-06 01:39:44', 'admin', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ciudades`
--

CREATE TABLE `ciudades` (
  `idCiudades` int(11) NOT NULL,
  `Paises_Codigo` varchar(2) NOT NULL,
  `Ciudad` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `ciudades`
--

INSERT INTO `ciudades` (`idCiudades`, `Paises_Codigo`, `Ciudad`) VALUES
(1, 'PE', 'Amazonas'),
(2, 'PE', 'Áncash'),
(3, 'PE', 'Apurímac'),
(4, 'PE', 'Arequipa'),
(5, 'PE', 'Ayacucho'),
(6, 'PE', 'Cajamarca'),
(7, 'PE', 'Callao'),
(8, 'PE', 'Cuzco'),
(9, 'PE', 'Huancavelica'),
(10, 'PE', 'Huánuco'),
(11, 'PE', 'Ica'),
(12, 'PE', 'Junín'),
(13, 'PE', 'La Libertad'),
(14, 'PE', 'Lambayeque'),
(15, 'PE', 'Lima'),
(16, 'PE', 'Loreto'),
(17, 'PE', 'Madre de Dios'),
(18, 'PE', 'Moquegua'),
(19, 'PE', 'Pasco'),
(20, 'PE', 'Piura'),
(21, 'PE', 'Puno'),
(22, 'PE', 'San Martín'),
(23, 'PE', 'Tacna'),
(24, 'PE', 'Ucayali'),
(25, 'PE', 'Tumbes');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `clase`
--

CREATE TABLE `clase` (
  `idClase` int(11) NOT NULL,
  `idSubcategoria` int(11) NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(150) NOT NULL,
  `descripcion` varchar(250) DEFAULT NULL,
  `abreviatura` char(3) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `clasecol` varchar(45) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `clase`
--

INSERT INTO `clase` (`idClase`, `idSubcategoria`, `codigo`, `nombre`, `descripcion`, `abreviatura`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `clasecol`) VALUES
(1, 1, '25101', 'LLANTAS ', 'LLANTAS ', 'LLA', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(2, 1, '25102', 'REENCAUCHE', 'REENCAUCHE', 'REE', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(3, 2, '25201', 'COMBUSTIBLE', 'COMBUSTIBLE', 'COM', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(4, 2, '25202', ' ACEITE ,GRASA Y ADITIVOS', ' ACEITE ,GRASA Y ADITIVOS', 'ACE', '2018-08-06 01:40:13', 'admin', '-', '2018-10-25 00:36:19', 'admin', '-', 1, NULL),
(5, 2, '25203', 'HERRAMIENTAS', 'HERRAMIENTAS', 'HER', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(6, 2, '25204', 'OXIGENO  Y SOLDADURA ', 'OXIGENO  Y SOLDADURA ', 'OXI', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(7, 2, '25205', 'AGUA ', 'AGUA ', 'AGU', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(8, 2, '25206', 'WAIPE', 'WAIPE', 'WAI', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(9, 2, '25207', 'PINTURA Y ADITIVOS', 'PINTURA Y ADITIVOS', 'PIN', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(10, 2, '25208', 'FILTROS ', 'FILTROS ', 'FIL', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(11, 2, '25209', 'ZAPATAS', 'ZAPATAS', 'ZAP', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(12, 2, '25210', 'AROS', 'AROS', 'ARO', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(13, 2, '25211', 'BATERIA', 'BATERIA', 'BAT', '2018-08-06 01:40:13', 'admin', '-', '2018-09-21 12:50:40', 'admin', '-', 1, NULL),
(14, 3, '25301', 'SISTEMA DE AIRE ', 'SISTEMA DE AIRE ', 'AIR', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:36:25', 'admin', '-', 1, NULL),
(15, 3, '25302', 'ARANDELA', 'ARANDELA', 'ARA', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(16, 3, '25303', 'CABINA', 'CABINA', 'CAB', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(17, 3, '25304', 'SISTEMA CARDAN', 'SISTEMA CARDAN', 'CAR', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:36:01', 'admin', '-', 1, NULL),
(18, 3, '25305', 'SISTEMA DIFERENCIAL', 'SISTEMA DIFERENCIAL', 'DIF', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:35:51', 'admin', '-', 1, NULL),
(19, 3, '25306', 'SISTEMA TRANSMISION ', 'SISTEMA TRANSMISION ', 'TRA', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:35:37', 'admin', '-', 1, NULL),
(20, 3, '25307', 'SISTEMA ELECTRICO', 'SISTEMA ELECTRICO', 'ELE', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:35:21', 'admin', '-', 1, NULL),
(21, 3, '25308', 'SISTEMA DE SUSPENSION ', 'SISTEMA DE SUSPENSION ', 'SUS', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:35:09', 'admin', '-', 1, NULL),
(22, 3, '25309', 'SISTEMA  DE DIRECCION ', 'SISTEMA  DE DIRECCION ', 'DIR', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:34:57', 'admin', '-', 1, NULL),
(23, 3, '25310', 'SISTEMA DE RUEDAS', 'SISTEMA DE RUEDAS', 'RUE', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:34:47', 'admin', '-', 1, NULL),
(24, 3, '25311', 'SISTEMA DE TUERCA ', 'SISTEMA DE TUERCA ', 'TUE', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:23:08', 'admin', '-', 1, NULL),
(25, 3, '25312', 'STOBOLT', 'STOBOLT', 'STO', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(26, 3, '25313', 'SISTEMA DE MOTOR ', 'SISTEMA DE MOTOR ', 'MOT', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:34:32', 'admin', '-', 1, NULL),
(27, 3, '25314', 'SISTEMA DE PERNOS ', 'SISTEMA DE PERNOS ', 'PER', '2018-08-06 01:40:13', 'admin', '-', '2018-10-13 08:34:08', 'admin', '-', 1, NULL),
(28, 3, '25315', 'OTROS SUMINISTROS ', 'OTROS SUMINISTROS ', 'OTR', '2018-08-06 01:40:13', 'admin', '-', '2018-08-06 01:40:13', 'admin', '-', 1, NULL),
(31, 2, '25212', 'ACCESORIOS', 'ACCESORIOS', 'ACC', '2018-09-21 12:51:04', 'admin', '-', '2018-09-21 12:51:04', '-', '-', 1, NULL),
(32, 2, '25213', 'PLANCHAS', 'PLANCHAS  NEGRA 3/32 DE 2.5x1200x2400', 'PLA', '2018-12-03 10:58:32', 'admin', '-', '2018-12-03 10:58:32', '-', '-', 1, NULL),
(33, 2, '25214', 'SODA CAUSTICA', 'SODA CAUSTICA', 'SD', '2018-12-05 11:44:10', 'admin', '-', '2018-12-05 11:44:10', '-', '-', 1, NULL),
(34, 3, '25316', 'SISTEMA DE FRENO', 'SISTEMA DE FRENO', 'SF', '2018-12-06 11:24:28', 'admin', '-', '2018-12-06 11:24:28', '-', '-', 1, NULL),
(35, 2, '25215', 'PRECINTOS ', 'PRECINTO', 'PRE', '2018-12-10 10:09:39', 'admin', '-', '2018-12-10 10:09:39', '-', '-', 1, NULL),
(36, 3, '25317', 'SISTEMA DE REMACHES', 'REMACHES', 'RE', '2018-12-15 12:36:29', 'admin', '-', '2018-12-15 12:36:29', '-', '-', 1, NULL),
(37, 2, '25216', 'DISCO FLOTT ', 'DISCO FLOTT X 40', 'DFL', '2018-12-15 12:40:09', 'admin', '-', '2018-12-15 12:40:09', '-', '-', 1, NULL),
(38, 2, '25217', 'PLASTICO', 'PLASTICO', 'PAS', '2018-12-29 11:52:10', 'admin', '-', '2018-12-29 11:52:10', '-', '-', 1, NULL),
(39, 3, '25318', 'SISTEMA DE ESTRUCTURA', 'SISTEMA DE ESTRUCTURA', 'EST', '2019-01-03 18:03:55', 'admin', '-', '2019-01-03 18:03:55', '-', '-', 1, NULL),
(40, 3, '25319', 'SISTEMA DE CHASIS', 'SISTEMA DE CHASIS', 'SCH', '2019-08-06 12:45:59', 'angelica_chuquilin', '-', '2019-08-06 12:45:59', '-', '-', 1, NULL),
(41, 5, '00001', 'OTROS', 'OTROS', 'OT', '2019-09-26 15:30:37', 'angelica_chuquilin', '-', '2019-09-26 15:30:37', '-', '-', 1, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cliente`
--

CREATE TABLE `cliente` (
  `idCliente` int(11) NOT NULL,
  `idCategoria` int(11) NOT NULL,
  `idTipoCliente` int(11) DEFAULT NULL,
  `idPais` varchar(5) COLLATE utf8mb4_spanish_ci DEFAULT NULL,
  `idCiudad` int(11) DEFAULT NULL,
  `codigoCliente` varchar(9) COLLATE utf8mb4_spanish_ci NOT NULL,
  `razonSocial` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `nombreComercial` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `nombres` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `apellidoPaterno` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `apellidoMaterno` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `idTipoDocumento` int(11) NOT NULL,
  `documento` varchar(20) CHARACTER SET utf8 NOT NULL,
  `direccion` varchar(300) CHARACTER SET utf8 NOT NULL,
  `fechaNacimiento` date DEFAULT NULL,
  `telefono1` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `telefono2` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `telefono3` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `referencia` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `cuentaFacebook` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `cuentaInstagram` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `ocupacion` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `lugarOcupacion` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `comentario` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `calificacion` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `fechaRegistro` datetime NOT NULL,
  `usuarioRegistro` varchar(50) CHARACTER SET utf8 NOT NULL,
  `pcRegistro` varchar(50) CHARACTER SET utf8 NOT NULL,
  `fechaEdicion` datetime NOT NULL,
  `usuarioEdicion` varchar(50) CHARACTER SET utf8 NOT NULL,
  `pcEdicion` varchar(50) CHARACTER SET utf8 NOT NULL,
  `activo` smallint(6) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_spanish_ci;

--
-- Volcado de datos para la tabla `cliente`
--

INSERT INTO `cliente` (`idCliente`, `idCategoria`, `idTipoCliente`, `idPais`, `idCiudad`, `codigoCliente`, `razonSocial`, `nombreComercial`, `nombres`, `apellidoPaterno`, `apellidoMaterno`, `idTipoDocumento`, `documento`, `direccion`, `fechaNacimiento`, `telefono1`, `telefono2`, `telefono3`, `email`, `referencia`, `cuentaFacebook`, `cuentaInstagram`, `ocupacion`, `lugarOcupacion`, `comentario`, `calificacion`, `fechaRegistro`, `usuarioRegistro`, `pcRegistro`, `fechaEdicion`, `usuarioEdicion`, `pcEdicion`, `activo`) VALUES
(1, 2, 1, 'PE', 5, 'CL-000001', NULL, NULL, 'sdfghjk', 'dggfhjgfds', 'fghjkl,ñ.', 2, '5643212312', 'sddddddddddddddddd', '0000-00-00', '213123', '12321312', NULL, 'sadasd@gmai.com', 'ddddddddddddddd', 'ddddd', 'sssss', 'wwwww', 'eeeee', NULL, '123123', '2020-04-14 01:15:43', 'admin', 'KevinEA', '2020-04-14 01:15:43', 'admin', 'KevinEA', 1),
(2, 2, 1, 'PE', 11, 'CL-000002', NULL, NULL, 'eeeeeeeee', 'rrrrrrrrrrr', 'tttttttttt', 2, '45435435', 'qqqqqqqqq', '0000-00-00', '34324324', '12321312', NULL, 'sjskskks@gamail.com', 'wwwwwwwwww', 'eeeee', 'wwwww', 'wwwww', 'eeeee', NULL, '123123', '2020-04-14 01:16:39', 'admin', 'KevinEA', '2020-04-14 01:16:39', 'admin', 'KevinEA', 1),
(3, 1, 2, 'PE', 13, 'CL-000003', 'EMPRESA A', 'EMPRESA AA', '', '', '', 4, '78541258963', 'AAA', '0000-00-00', '147852', '365423', NULL, 'jajajaja@hmaicl.com', 'sadasd', '', '', '', '', NULL, '', '2020-04-14 03:07:41', 'admin', 'KevinEA', '2020-04-14 03:07:41', 'admin', 'KevinEA', 3),
(6, 2, 2, 'YE', 0, 'CL-000006', 'dsdddd', 'dddddd', '', '', '', 2, '4234324', 'ffff', '0000-00-00', '213123', '21321321', NULL, 'fvfffff@had.com', 'fff', '', '', '', '', NULL, '', '2020-04-14 03:27:23', 'admin', 'KevinEA', '2020-04-14 03:27:23', 'admin', 'KevinEA', 1),
(7, 2, 2, 'PE', 8, 'CL-000007', 'bbbbbbbbbb', 'bbbbbbbbbbbbb', '', '', '', 3, '334324324', 'bbbbbbbbbbbbbbb', '0000-00-00', '12564', '3213215', NULL, 'jjj@gamad.com', 'bbbbbbbbbbbbbbbb', '', '', '', '', NULL, '', '2020-04-14 04:07:55', 'admin', 'KevinEA', '2020-04-14 04:07:55', 'admin', 'KevinEA', 3),
(8, 1, 2, 'PE', 3, 'CL-000008', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:12:01', 'admin', 'KevinEA', '2020-04-14 04:12:01', 'admin', 'KevinEA', 3),
(9, 1, 2, 'PE', 3, 'CL-000009', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:14:05', 'admin', 'KevinEA', '2020-04-14 04:14:05', 'admin', 'KevinEA', 1),
(10, 1, 2, 'PE', 3, 'CL-000010', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:15:08', 'admin', 'KevinEA', '2020-04-14 04:15:08', 'admin', 'KevinEA', 0),
(11, 1, 2, 'PE', 3, 'CL-000011', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:16:46', 'admin', 'KevinEA', '2020-04-14 04:16:46', 'admin', 'KevinEA', 1),
(12, 1, 2, 'PE', 3, 'CL-000012', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:18:05', 'admin', 'KevinEA', '2020-04-14 04:18:05', 'admin', 'KevinEA', 1),
(13, 1, 2, 'PE', 3, 'CL-000013', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:18:34', 'admin', 'KevinEA', '2020-04-14 04:18:34', 'admin', 'KevinEA', 1),
(14, 1, 2, 'PE', 3, 'CL-000014', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:19:44', 'admin', 'KevinEA', '2020-04-14 04:19:44', 'admin', 'KevinEA', 1),
(15, 1, 2, 'PE', 3, 'CL-000015', 'dfdsfdsfeee', 'eeee', '', '', '', 3, '3232324', 'eeee', '0000-00-00', '3232323', '323232', NULL, 'kdsfk@hdsjd.com', 'rererere', '', '', '', '', NULL, '', '2020-04-14 04:20:21', 'admin', 'KevinEA', '2020-04-14 04:20:21', 'admin', 'KevinEA', 3),
(18, 2, 2, 'PE', 3, 'CL-000018', 'sadasdsa', 'sadasd', '', '', '', 2, '322423', 'asdasdsad', '0000-00-00', '32823', '38923', NULL, 'dsfsd@hasd.com', 'asdsadas', '', '', '', '', NULL, '', '2020-04-14 04:28:34', 'admin', 'KevinEA', '2020-04-14 04:28:34', 'admin', 'KevinEA', 0),
(19, 2, 2, 'PE', 5, 'CL-000019', 'fdffff', 'ffff', '', '', '', 2, '33333', 'ffff', '0000-00-00', '233232', '389233232', NULL, '3ddd@hjd.cj', 'fff', '', '', '', '', NULL, '', '2020-04-14 04:30:24', 'admin', 'KevinEA', '2020-04-14 04:30:24', 'admin', 'KevinEA', 1),
(20, 1, 2, 'PE', 3, 'CL-000020', 'sadasdas', 'dsss', '', '', '', 1, '32323333', 'sss', '0000-00-00', '3444455', '55555', NULL, 'ssss@gaslk.c', 'ssssss', '', '', '', '', NULL, '', '2020-04-14 04:32:29', 'admin', 'KevinEA', '2020-04-17 17:19:50', 'admin', 'KevinEA', 1),
(21, 1, 2, 'PE', 5, 'CL-000021', 'qqqqqq', 'sdfsdf', '', '', '', 3, '3232332', 'dsfdsf', '0000-00-00', '3277632', '55555', NULL, 'dsfds@hsdjkf.com', 'dsfdsf', '', '', '', '', NULL, '', '2020-04-14 04:33:49', 'admin', 'KevinEA', '2020-04-14 23:06:32', 'admin', 'KevinEA', 1),
(22, 1, 1, 'NI', 0, 'CL-000022', '', '', 'wwwwwww', 'wwwwwwwwww', 'wwwwwwwwww', 2, '211131', 'wwwwwwwwwww', '2020-01-20', '213213', '12312312', NULL, 'ksks@gg.c', 'wwwwwwww', 'dssss', 'sassada', 'adsad', 'asdsadasd', NULL, 'aaaaaa', '2020-04-14 13:40:03', 'admin', 'KevinEA', '2020-04-14 13:40:03', 'admin', 'KevinEA', 1),
(24, 2, 1, 'PE', 1, 'CL-000024', '', '', 'cccccc', 'aaaaaaaaa', 'aaaaaaaaa', 2, '444444', 'aaaaaaaa', '2020-02-25', '22222', '22222222', NULL, 'jjjjj@h.c', 'aaaaaaaaaaa', 'sssssss', 'dddddddd', 'mmmm', 'mmmmm', NULL, 'dddddd', '2020-04-14 13:45:44', 'admin', 'KevinEA', '2020-04-14 18:39:58', 'admin', 'KevinEA', 3),
(26, 2, 1, 'PE', 0, 'CL-000026', '', '', 'nnnnnnnn', 'nnnnnnnnn', 'nnnnnnnnnn', 5, '55554564564', 'nnnnnn', '2019-12-02', '', '', NULL, '', '', '', '', '', '', NULL, '', '2020-04-15 01:15:48', 'admin', 'KevinEA', '2020-04-15 01:15:48', 'admin', 'KevinEA', 3),
(27, 1, 2, 'PE', 0, 'CL-000027', 'wwwww', 'wwwww', '', '', '', 3, '345435435', 'wwwww', '0000-00-00', '', '', NULL, '', '', '', '', '', '', NULL, '', '2020-04-15 01:16:31', 'admin', 'KevinEA', '2020-04-15 01:16:31', 'admin', 'KevinEA', 3),
(28, 1, 2, 'PE', 4, 'CL-000028', 'wwww', 'weeee', '', '', '', 2, '23324234234', 'wewewew', '0000-00-00', '', '', NULL, '', 'ewewe', '', '', '', '', NULL, '', '2020-04-16 22:15:47', 'admin', 'KevinEA', '2020-04-16 22:15:47', 'admin', 'KevinEA', 1),
(29, 2, 2, 'MC', 0, 'CL-000029', 'aaaaaa', 'aaaaaaaaaa', '', '', '', 2, '334333', 'aaaaaaaaaa', '0000-00-00', '', '', NULL, '', 'aaaaaaaaaaa', '', '', '', '', NULL, '', '2020-04-16 22:17:30', 'admin', 'KevinEA', '2020-04-16 22:17:30', 'admin', 'KevinEA', 1),
(30, 2, 2, 'NI', 0, 'CL-000030', 'eeeeee', 'eeeee', '', '', '', 2, '3333333333', 'rrrrrrrrr', '0000-00-00', '', '', NULL, '', 'rrrrrrrrrrrrr', '', '', '', '', NULL, '', '2020-04-16 22:20:50', 'admin', 'KevinEA', '2020-04-16 22:20:50', 'admin', 'KevinEA', 1),
(31, 2, 2, 'PE', 0, 'CL-000031', 'bbbbbb', 'qqq', '', '', '', 5, '23233223', 'qqq', '0000-00-00', '', '', NULL, '', 'qqqq', '', '', '', '', NULL, '', '2020-04-16 23:14:30', 'admin', 'KevinEA', '2020-04-16 23:14:30', 'admin', 'KevinEA', 1),
(32, 1, 1, 'PE', 18, 'CL-000032', '', '', 'bbbbbbb', 'bbbbbbbbbb', 'bbbbbbbbbb', 3, '23233223232', 'bbbbbbbbb', '2020-04-17', '', '', NULL, '', 'bbbbbbb', '', '', '', '', NULL, '', '2020-04-17 17:00:22', 'admin', 'KevinEA', '2020-04-17 17:00:22', 'admin', 'KevinEA', 1),
(33, 2, 2, 'NI', 0, 'CL-000033', 'wwwwww', 'wwwwwww', '', '', '', 2, '23322323545', 'rrrrrrr', '0000-00-00', '', '', NULL, '', 'rrrrrrrr', '', '', '', '', NULL, '', '2020-04-17 17:01:05', 'admin', 'KevinEA', '2020-04-17 17:01:05', 'admin', 'KevinEA', 1),
(34, 2, 2, 'NL', 0, 'CL-000034', 'qqqqq', 'qqqq', '', '', '', 3, '22222', 'qqqq', '0000-00-00', '', '', NULL, '', 'qqqqq', '', '', '', '', NULL, '', '2020-04-17 17:02:25', 'admin', 'KevinEA', '2020-04-17 17:02:25', 'admin', 'KevinEA', 3),
(35, 2, 2, 'PE', 7, 'CL-000035', 'rfdfdfdfd', 'fdfdfd', '', '', '', 2, '43434343', 'fdfdfd', '0000-00-00', '', '', NULL, '', 'fdfdfdfd', '', '', '', '', NULL, '', '2020-04-17 17:04:33', 'admin', 'KevinEA', '2020-04-17 17:04:33', 'admin', 'KevinEA', 1),
(36, 1, 1, 'PE', 5, 'CL-000036', '', '', 'iuytref', 'ghgfdfghj', 'hgfdfghj', 2, '4532456654', 'hgfdsfghjhg', '2020-04-17', '43434343', '', NULL, '', 'ghjkjhgfddfghj', 'ffffdfdf', 'fdfdff', '', '', NULL, '', '2020-04-17 17:05:10', 'admin', 'KevinEA', '2020-04-17 17:16:52', 'admin', 'KevinEA', 1),
(37, 1, 1, 'PE', 3, 'CL-000037', '', '', 'fff', 'fff', 'fff', 3, '344343', 'fff', '2020-04-13', '', '', NULL, '', 'fff', '', '', '', '', NULL, '', '2020-04-18 01:23:45', 'admin', 'KevinEA', '2020-04-18 01:23:45', 'admin', 'KevinEA', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cliente_contacto`
--

CREATE TABLE `cliente_contacto` (
  `idClienteContacto` int(11) NOT NULL,
  `idCliente` int(11) NOT NULL,
  `nombre` varchar(300) CHARACTER SET utf8 NOT NULL,
  `apePaterno` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `apeMaterno` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `cargo` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `dni` char(8) CHARACTER SET utf8 NOT NULL,
  `telefono` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `email` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `fechaRegistro` datetime NOT NULL,
  `usuarioRegistro` varchar(50) CHARACTER SET utf8 NOT NULL,
  `pcRegistro` varchar(50) CHARACTER SET utf8 NOT NULL,
  `fechaEdicion` datetime NOT NULL,
  `usuarioEdicion` varchar(50) CHARACTER SET utf8 NOT NULL,
  `pcEdicion` varchar(50) CHARACTER SET utf8 NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_spanish_ci;

--
-- Volcado de datos para la tabla `cliente_contacto`
--

INSERT INTO `cliente_contacto` (`idClienteContacto`, `idCliente`, `nombre`, `apePaterno`, `apeMaterno`, `cargo`, `dni`, `telefono`, `email`, `fechaRegistro`, `usuarioRegistro`, `pcRegistro`, `fechaEdicion`, `usuarioEdicion`, `pcEdicion`, `activo`) VALUES
(1, 15, 'dddd', 'fff', 'ddd', 'eddd', '324324', '22112', 'djjdd@jdj', '2020-04-14 04:20:52', 'admin', 'KevinEA', '2020-04-14 04:20:52', 'admin', 'KevinEA', 1),
(2, 17, 'dsfsdf', 'sdfsd', 'fsdf', 'sdf', '32332', '113312', 'dsfsdfsd', '2020-04-14 04:27:01', 'admin', 'KevinEA', '2020-04-14 04:27:01', 'admin', 'KevinEA', 1),
(3, 17, 'dsfsdf', 'sdf', 'dsfs', 'dfsd', '323244', '3232', 'fdsfsdf', '2020-04-14 04:27:01', 'admin', 'KevinEA', '2020-04-14 04:27:01', 'admin', 'KevinEA', 1),
(4, 18, 'dasdas', 'eee', 'eeee', 'eeee', '221212', '3333', 'ssssss', '2020-04-14 04:28:34', 'admin', 'KevinEA', '2020-04-14 04:28:34', 'admin', 'KevinEA', 1),
(5, 19, 'aaaaaaa', 'aaaaa', 'aaaa', 'aaaa', '323323', '2222', '23dsad', '2020-04-14 04:30:24', 'admin', 'KevinEA', '2020-04-14 04:30:24', 'admin', 'KevinEA', 1),
(6, 20, 'aaaa', 'aaaa', 'aaa', 'aaaa', '33333', '66666', 'rrrr', '2020-04-14 04:32:29', 'admin', 'KevinEA', '2020-04-17 17:19:50', 'admin', 'KevinEA', 0),
(7, 20, 'aaa', 'aaa', 'aaaa', 'aaaa', '5666', '4445', 'rrr', '2020-04-14 04:32:29', 'admin', 'KevinEA', '2020-04-17 17:19:50', 'admin', 'KevinEA', 1),
(8, 21, 'yyyy', 'yyyy', 'yyy', 'yyyyyE', '2222', '5555', 'yyyy', '2020-04-14 04:33:49', 'admin', 'KevinEA', '2020-04-14 23:06:32', 'admin', 'KevinEA', 1),
(9, 21, 'gggg', 'gggg', 'gggg', 'gggg', '3333', '2222', 'tgggg', '2020-04-14 04:33:49', 'admin', 'KevinEA', '2020-04-14 23:06:32', 'admin', 'KevinEA', 1),
(10, 21, 'xxxx', 'xxxxx', 'xxxxx', 'xxx', '44', '11111', 'bbbbbbb', '2020-04-14 22:42:31', 'admin', 'KevinEA', '2020-04-14 23:06:32', 'admin', 'KevinEA', 0),
(11, 27, 'dfffsddf', 'sdffdfsdsfd', 'sdffdsfds', 'sdffds', '234324', '21312', 'sdfdsfdsf', '2020-04-15 01:16:31', 'admin', 'KevinEA', '2020-04-15 01:16:31', 'admin', 'KevinEA', 1),
(12, 28, 'dfsdfsd', 'fsdfsd', 'fsdf', 'dsfsd', '324324', '444443', 'fsdfdsfds', '2020-04-16 22:15:47', 'admin', 'KevinEA', '2020-04-16 22:15:47', 'admin', 'KevinEA', 1),
(13, 29, 'fffff', 'ffff', 'fffff', 'fffff', '223344', '5556', 'dfffggf', '2020-04-16 22:17:30', 'admin', 'KevinEA', '2020-04-16 22:17:30', 'admin', 'KevinEA', 1),
(14, 30, 'gggg', 'gggg', 'ggg', 'ggg', '4444', '66666', 'kevi', '2020-04-16 22:20:50', 'admin', 'KevinEA', '2020-04-16 22:20:50', 'admin', 'KevinEA', 1),
(15, 31, 'dd', 'ddd', 'dd', 'fff', '2321', '333', 'ffff', '2020-04-16 23:14:30', 'admin', 'KevinEA', '2020-04-16 23:14:30', 'admin', 'KevinEA', 1),
(16, 33, 'tytytyty', 'tttttt', 'yyuiu', 'iiiiii', '44343443', '67777676', 'jjhjjjh', '2020-04-17 17:01:05', 'admin', 'KevinEA', '2020-04-17 17:01:05', 'admin', 'KevinEA', 1),
(17, 34, 'weee', 'eeee', 'ee', 'eeee', '2222', '33233', 'eeeee', '2020-04-17 17:02:25', 'admin', 'KevinEA', '2020-04-17 17:02:25', 'admin', 'KevinEA', 1),
(18, 35, 'rfdfdfd', 'fdfdfd', 'fdfd', 'fdfdfd', '3444343', '434343', 'ffgfgf', '2020-04-17 17:04:33', 'admin', 'KevinEA', '2020-04-17 17:04:33', 'admin', 'KevinEA', 1),
(19, 20, 'ddddd', 'dddd', 'ddd', 'ddd', 'ccc', '66778', 'fffff', '2020-04-17 17:19:50', 'admin', 'KevinEA', '2020-04-17 17:19:50', 'admin', 'KevinEA', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `compra`
--

CREATE TABLE `compra` (
  `idCompra` int(11) NOT NULL,
  `idOrdenCompra` int(11) NOT NULL,
  `idOrdenMantenimiento` int(11) DEFAULT NULL,
  `idOrdenServicio` int(11) DEFAULT NULL,
  `idProveedor` int(11) NOT NULL,
  `nombreProveedor` varchar(300) NOT NULL,
  `rucProveedor` char(11) NOT NULL,
  `direccionProveedor` varchar(250) NOT NULL,
  `telefonoProveedor` varchar(12) NOT NULL,
  `emailProveedor` varchar(50) NOT NULL,
  `correlativo` char(8) NOT NULL,
  `codCotizacion` varchar(50) NOT NULL,
  `serieDocumento` varchar(50) NOT NULL,
  `numeroDocumento` varchar(50) NOT NULL,
  `tipoDocumento` char(5) NOT NULL,
  `formaPago` char(5) NOT NULL,
  `idOficina` int(11) NOT NULL,
  `lugarAtencion` varchar(400) NOT NULL,
  `idTipoMoneda` int(11) NOT NULL DEFAULT '1',
  `tasaCambio` decimal(18,3) NOT NULL DEFAULT '1.000',
  `subTotal` decimal(18,2) NOT NULL,
  `descuento` decimal(18,2) NOT NULL DEFAULT '0.00',
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEnvio` datetime NOT NULL,
  `fechaEntrega` datetime NOT NULL,
  `fechaAceptada` datetime DEFAULT NULL,
  `estado` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `idDestino` int(11) DEFAULT NULL,
  `idUnidad` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `contacto`
--

CREATE TABLE `contacto` (
  `idContacto` int(11) NOT NULL,
  `idProveedor` int(11) DEFAULT NULL,
  `nombre` varchar(300) NOT NULL,
  `apePaterno` varchar(300) NOT NULL,
  `apeMaterno` varchar(300) NOT NULL,
  `cargo` varchar(50) NOT NULL,
  `dni` char(8) NOT NULL,
  `telefono` varchar(12) NOT NULL,
  `comentario` varchar(300) DEFAULT NULL,
  `calificacion` varchar(300) DEFAULT NULL,
  `email` varchar(300) DEFAULT NULL,
  `fechaRegistro` datetime NOT NULL,
  `usuarioRegistro` varchar(50) NOT NULL,
  `pcRegistro` varchar(50) NOT NULL,
  `fechaEdicion` datetime DEFAULT NULL,
  `usuarioEdicion` varchar(50) DEFAULT NULL,
  `pcEdicion` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `contacto`
--

INSERT INTO `contacto` (`idContacto`, `idProveedor`, `nombre`, `apePaterno`, `apeMaterno`, `cargo`, `dni`, `telefono`, `comentario`, `calificacion`, `email`, `fechaRegistro`, `usuarioRegistro`, `pcRegistro`, `fechaEdicion`, `usuarioEdicion`, `pcEdicion`, `activo`) VALUES
(188, 190, 'KEVIN', 'JUANCA', 'dsa', '', '', '', '', '', '', '2020-02-24 04:24:43', 'admin', '', '2020-02-25 03:16:10', 'admin', '-', 1),
(189, 190, 'REICARDO', 'bbbb', 'bbb', '', '', '', '', '', '', '2020-02-24 04:24:43', 'admin', '', '2020-02-25 03:16:00', 'admin', '-', 0),
(190, 191, 'eqwe', 'wqe', 'wq', '', '', '', '', '', '', '2020-02-24 21:03:49', 'admin', '', NULL, NULL, NULL, 1),
(191, 191, 'aaa', 'aaa', 'aa', 'a', '', 'aa', 'a', 'a', '', '2020-02-24 21:03:49', 'admin', '', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cotizacion`
--

CREATE TABLE `cotizacion` (
  `idCotizacion` int(11) NOT NULL,
  `idGrupoCotizacion` int(11) NOT NULL,
  `idOrdenMantenimiento` int(11) DEFAULT NULL,
  `idOrdenServicio` int(11) DEFAULT NULL,
  `idProveedor` int(11) NOT NULL,
  `nombreProveedor` varchar(300) NOT NULL,
  `rucProveedor` char(11) NOT NULL,
  `direccionProveedor` varchar(250) NOT NULL,
  `telefonoProveedor` varchar(12) NOT NULL,
  `emailProveedor` varchar(50) NOT NULL,
  `correlativo` char(8) NOT NULL,
  `codCotizacion` varchar(50) NOT NULL,
  `subTotal` decimal(18,2) NOT NULL,
  `descuento` decimal(18,2) NOT NULL DEFAULT '0.00',
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEnvio` datetime NOT NULL,
  `fechaAceptada` datetime DEFAULT NULL,
  `estado` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cronograma_pago_venta`
--

CREATE TABLE `cronograma_pago_venta` (
  `id` int(11) NOT NULL,
  `documento_venta_id` int(11) NOT NULL,
  `cuota` int(11) NOT NULL,
  `capital_cuota` decimal(18,6) NOT NULL,
  `interes_cuota` decimal(18,6) NOT NULL,
  `importe_cuota` decimal(18,6) NOT NULL,
  `fecha_pago_cuota` timestamp NOT NULL,
  `fecha_registro` timestamp NOT NULL,
  `usuario_registro` varchar(50) NOT NULL,
  `pc_registro` varchar(50) NOT NULL,
  `fecha_edicion` timestamp NOT NULL,
  `usuario_edicion` varchar(50) NOT NULL,
  `pc_edicion` varchar(50) NOT NULL,
  `activo` smallint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `cronograma_pago_venta`
--

INSERT INTO `cronograma_pago_venta` (`id`, `documento_venta_id`, `cuota`, `capital_cuota`, `interes_cuota`, `importe_cuota`, `fecha_pago_cuota`, `fecha_registro`, `usuario_registro`, `pc_registro`, `fecha_edicion`, `usuario_edicion`, `pc_edicion`, `activo`) VALUES
(1, 12, 1, '256.690000', '25.669000', '282.359000', '2020-06-21 05:00:00', '2020-04-21 21:32:19', 'admin', 'KevinEA', '2020-04-21 21:32:19', 'admin', 'KevinEA', 1),
(2, 12, 2, '256.690000', '25.669000', '282.359000', '2020-08-21 05:00:00', '2020-04-21 21:32:19', 'admin', 'KevinEA', '2020-04-21 21:32:19', 'admin', 'KevinEA', 1),
(3, 13, 1, '76.607500', '3.830375', '80.437875', '2020-04-23 05:00:00', '2020-04-21 23:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(4, 13, 2, '76.607500', '3.830375', '80.437875', '2020-04-25 05:00:00', '2020-04-21 23:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(5, 13, 3, '76.607500', '3.830375', '80.437875', '2020-04-27 05:00:00', '2020-04-21 23:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(6, 13, 4, '76.607500', '3.830375', '80.437875', '2020-04-29 05:00:00', '2020-04-21 23:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(7, 14, 1, '166.320000', '49.896000', '216.216000', '2020-07-21 05:00:00', '2020-04-21 23:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(8, 14, 2, '166.320000', '49.896000', '216.216000', '2020-10-21 05:00:00', '2020-04-21 23:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(9, 14, 3, '166.320000', '49.896000', '216.216000', '2021-01-21 05:00:00', '2020-04-21 23:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(10, 15, 1, '105.127500', '5.256375', '110.383875', '2020-04-23 05:00:00', '2020-04-22 08:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(11, 15, 2, '105.127500', '5.256375', '110.383875', '2020-04-25 05:00:00', '2020-04-22 08:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(12, 15, 3, '105.127500', '5.256375', '110.383875', '2020-04-27 05:00:00', '2020-04-22 08:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(13, 15, 4, '105.127500', '5.256375', '110.383875', '2020-04-29 05:00:00', '2020-04-22 08:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(14, 16, 1, '12.700000', '1.270000', '13.970000', '2020-06-22 05:00:00', '2020-04-22 09:29:55', 'admin', 'KevinEA', '2020-04-22 09:29:55', 'admin', 'KevinEA', 0),
(15, 16, 2, '12.700000', '1.270000', '13.970000', '2020-08-22 05:00:00', '2020-04-22 09:29:55', 'admin', 'KevinEA', '2020-04-22 09:29:55', 'admin', 'KevinEA', 0),
(16, 16, 1, '38.565000', '3.856500', '42.421500', '2020-06-22 05:00:00', '2020-04-22 10:03:24', 'admin', 'KevinEA', '2020-04-22 10:03:24', 'admin', 'KevinEA', 0),
(17, 16, 2, '38.565000', '3.856500', '42.421500', '2020-08-22 05:00:00', '2020-04-22 10:03:24', 'admin', 'KevinEA', '2020-04-22 10:03:24', 'admin', 'KevinEA', 0),
(18, 16, 1, '57.615000', '5.761500', '63.376500', '2020-06-22 05:00:00', '2020-04-22 10:04:42', 'admin', 'KevinEA', '2020-04-22 10:04:42', 'admin', 'KevinEA', 0),
(19, 16, 2, '57.615000', '5.761500', '63.376500', '2020-08-22 05:00:00', '2020-04-22 10:04:42', 'admin', 'KevinEA', '2020-04-22 10:04:42', 'admin', 'KevinEA', 0),
(20, 16, 1, '103.895000', '10.389500', '114.284500', '2020-06-22 05:00:00', '2020-04-22 10:17:32', 'admin', 'KevinEA', '2020-04-22 10:17:32', 'admin', 'KevinEA', 0),
(21, 16, 2, '103.895000', '10.389500', '114.284500', '2020-08-23 05:00:00', '2020-04-22 10:17:32', 'admin', 'KevinEA', '2020-04-22 10:17:32', 'admin', 'KevinEA', 0),
(22, 16, 1, '91.110000', '9.111000', '100.221000', '2020-06-23 05:00:00', '2020-04-22 10:59:55', 'admin', 'KevinEA', '2020-04-22 10:59:55', 'admin', 'KevinEA', 0),
(23, 16, 2, '91.110000', '9.111000', '100.221000', '2020-08-23 05:00:00', '2020-04-22 10:59:55', 'admin', 'KevinEA', '2020-04-22 10:59:55', 'admin', 'KevinEA', 0),
(24, 16, 1, '91.110000', '9.111000', '100.221000', '2020-06-23 05:00:00', '2020-04-24 00:03:16', 'admin', 'KevinEA', '2020-04-24 00:03:16', 'admin', 'KevinEA', 1),
(25, 16, 2, '91.110000', '9.111000', '100.221000', '2020-08-23 05:00:00', '2020-04-24 00:03:16', 'admin', 'KevinEA', '2020-04-24 00:03:16', 'admin', 'KevinEA', 1),
(26, 15, 1, '52.500000', '5.250000', '57.750000', '2020-06-21 05:00:00', '2020-04-24 00:59:58', 'admin', 'KevinEA', '2020-04-24 00:59:58', 'admin', 'KevinEA', 1),
(27, 15, 2, '52.500000', '5.250000', '57.750000', '2020-08-21 05:00:00', '2020-04-24 00:59:59', 'admin', 'KevinEA', '2020-04-24 00:59:59', 'admin', 'KevinEA', 1),
(28, 17, 1, '38.927500', '1.946375', '40.873875', '2020-04-25 05:00:00', '2020-04-24 01:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1),
(29, 17, 2, '38.927500', '1.946375', '40.873875', '2020-04-27 05:00:00', '2020-04-24 01:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1),
(30, 17, 3, '38.927500', '1.946375', '40.873875', '2020-04-29 05:00:00', '2020-04-24 01:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1),
(31, 17, 4, '38.927500', '1.946375', '40.873875', '2020-05-01 05:00:00', '2020-04-24 01:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_compra`
--

CREATE TABLE `detalle_compra` (
  `idDetalleCompra` int(11) NOT NULL,
  `idCompra` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `nombreProducto` varchar(300) NOT NULL,
  `idPresentacion` int(11) NOT NULL,
  `nombrePresentacion` varchar(300) NOT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `valorUnitarioA` decimal(18,2) NOT NULL,
  `descuentoUnitario` decimal(18,2) NOT NULL,
  `descuentoUnitarioA` decimal(18,2) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `precioUnitarioA` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `cantidadAceptada` decimal(18,2) NOT NULL,
  `cantidadRechazada` decimal(18,2) NOT NULL,
  `cantidadReenviada` decimal(18,2) NOT NULL,
  `valorVenta` decimal(18,2) NOT NULL,
  `valorVentaA` decimal(18,2) NOT NULL,
  `descuentoTotal` decimal(18,2) NOT NULL,
  `descuentoTotalA` decimal(18,2) NOT NULL,
  `monto` decimal(18,2) NOT NULL,
  `montoA` decimal(18,2) NOT NULL,
  `cantidadTotal` decimal(18,2) NOT NULL,
  `cantidadTotalA` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `estado` char(2) NOT NULL,
  `urgencia` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_cotizacion`
--

CREATE TABLE `detalle_cotizacion` (
  `idDetalleCotizacion` int(11) NOT NULL,
  `idCotizacion` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `nombreProducto` varchar(300) DEFAULT NULL,
  `idPresentacion` int(11) NOT NULL,
  `nombrePresentacion` varchar(300) DEFAULT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `valorUnitarioA` decimal(18,2) NOT NULL,
  `descuentoUnitario` decimal(18,2) NOT NULL DEFAULT '0.00',
  `descuentoUnitarioA` decimal(18,2) NOT NULL DEFAULT '0.00',
  `precioUnitario` decimal(18,2) NOT NULL,
  `precioUnitarioA` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `cantidadAceptada` decimal(18,2) NOT NULL DEFAULT '0.00',
  `cantidadRechazada` decimal(18,2) NOT NULL DEFAULT '0.00',
  `cantidadReenviada` decimal(18,2) NOT NULL DEFAULT '0.00',
  `valorVenta` decimal(18,2) NOT NULL,
  `valorVentaA` decimal(18,2) NOT NULL,
  `descuentoTotal` decimal(18,2) NOT NULL DEFAULT '0.00',
  `descuentoTotalA` decimal(18,2) NOT NULL DEFAULT '0.00',
  `monto` decimal(18,2) NOT NULL,
  `montoA` decimal(18,2) NOT NULL,
  `montoR` decimal(18,2) NOT NULL DEFAULT '0.00',
  `cantidadTotal` decimal(18,2) NOT NULL,
  `cantidadTotalA` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `estado` char(5) NOT NULL,
  `urgencia` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_documento_venta`
--

CREATE TABLE `detalle_documento_venta` (
  `id` int(11) NOT NULL,
  `documento_venta_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `valor_unitario` decimal(18,6) NOT NULL,
  `precio_unitario` decimal(18,6) NOT NULL,
  `igv_unitario` decimal(18,6) NOT NULL,
  `valor_total` decimal(18,6) NOT NULL,
  `precio_total` decimal(18,6) NOT NULL,
  `fecha_registro` datetime NOT NULL,
  `usuario_registro` varchar(50) NOT NULL,
  `pc_registro` varchar(50) NOT NULL,
  `fecha_edicion` timestamp NOT NULL,
  `usuario_edicion` varchar(50) NOT NULL,
  `pc_edicion` varchar(50) NOT NULL,
  `activo` smallint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `detalle_documento_venta`
--

INSERT INTO `detalle_documento_venta` (`id`, `documento_venta_id`, `producto_id`, `cantidad`, `descuento`, `valor_unitario`, `precio_unitario`, `igv_unitario`, `valor_total`, `precio_total`, `fecha_registro`, `usuario_registro`, `pc_registro`, `fecha_edicion`, `usuario_edicion`, `pc_edicion`, `activo`) VALUES
(3, 12, 1517, '3.000000', '3.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 16:32:19', 'admin', 'KevinEA', '2020-04-21 21:32:19', 'admin', 'KevinEA', 1),
(4, 12, 1521, '4.000000', '10.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 16:32:19', 'admin', 'KevinEA', '2020-04-21 21:32:19', 'admin', 'KevinEA', 1),
(5, 13, 1517, '5.000000', '5.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(6, 13, 1519, '4.000000', '2.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(7, 14, 1521, '2.000000', '5.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:24:59', 'admin', 'KevinEA', '2020-04-21 23:24:59', 'admin', 'KevinEA', 1),
(8, 14, 1517, '4.000000', '2.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(9, 14, 1518, '3.000000', '4.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(10, 14, 1519, '6.000000', '10.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-21 18:25:00', 'admin', 'KevinEA', '2020-04-21 23:25:00', 'admin', 'KevinEA', 1),
(11, 15, 1517, '5.000000', '4.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-22 03:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(12, 15, 1518, '4.000000', '3.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-22 03:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(13, 15, 1519, '6.000000', '2.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-22 03:28:11', 'admin', 'KevinEA', '2020-04-22 08:28:11', 'admin', 'KevinEA', 0),
(14, 16, 1519, '5.000000', '5.000000', '15.000000', '17.700000', '2.700000', '0.000000', '88.500000', '2020-04-22 04:29:55', 'admin', 'KevinEA', '2020-04-24 00:03:15', 'admin', 'KevinEA', 1),
(15, 16, 1517, '2.000000', '2.000000', '0.000000', '0.000000', '0.000000', '0.000000', '0.000000', '2020-04-22 05:03:23', 'admin', 'KevinEA', '2020-04-22 10:17:32', 'admin', 'KevinEA', 0),
(16, 16, 1518, '1.000000', '2.000000', '19.000000', '22.420000', '3.420000', '0.000000', '22.420000', '2020-04-22 05:17:32', 'admin', 'KevinEA', '2020-04-24 00:03:15', 'admin', 'KevinEA', 1),
(17, 16, 1521, '1.000000', '2.000000', '85.000000', '100.300000', '15.300000', '0.000000', '100.300000', '2020-04-22 05:59:55', 'admin', 'KevinEA', '2020-04-24 00:03:16', 'admin', 'KevinEA', 1),
(18, 15, 1519, '3.000000', '5.000000', '15.000000', '17.700000', '2.700000', '30.000000', '38.100000', '2020-04-23 19:59:58', 'admin', 'KevinEA', '2020-04-24 00:59:58', 'admin', 'KevinEA', 1),
(19, 15, 1521, '1.000000', '10.000000', '85.000000', '100.300000', '15.300000', '85.000000', '90.300000', '2020-04-23 19:59:58', 'admin', 'KevinEA', '2020-04-24 00:59:58', 'admin', 'KevinEA', 1),
(20, 17, 1517, '2.000000', '2.000000', '45.530000', '53.720000', '8.200000', '91.060000', '103.440000', '2020-04-23 20:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1),
(21, 17, 1518, '3.000000', '5.000000', '19.000000', '22.420000', '3.420000', '57.000000', '52.260000', '2020-04-23 20:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_grupo`
--

CREATE TABLE `detalle_grupo` (
  `idDetalleGrupo` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `idGrupoOrden` int(11) NOT NULL,
  `idPresentacion` int(11) NOT NULL,
  `idProveedorR` int(11) NOT NULL,
  `idProveedorC` int(11) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `monto` decimal(18,2) NOT NULL,
  `cantidadTotal` decimal(18,2) NOT NULL,
  `urgencia` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_grupocotizacion`
--

CREATE TABLE `detalle_grupocotizacion` (
  `idDetalleGrupo` int(11) NOT NULL,
  `idGrupoCotizacion` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `nombreProducto` varchar(300) NOT NULL,
  `idPresentacion` int(11) NOT NULL,
  `nombrePresentacion` varchar(300) NOT NULL,
  `idProveedorR` int(11) NOT NULL,
  `nombreProveedorR` varchar(45) NOT NULL,
  `idProveedorC` int(11) NOT NULL,
  `nombreProveedorC` varchar(45) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `monto` decimal(18,2) NOT NULL,
  `cantidadTotal` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `urgencia` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_nota_almacen`
--

CREATE TABLE `detalle_nota_almacen` (
  `idDetaNota` int(11) NOT NULL,
  `idNotaAlmacen` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `nombreProducto` varchar(300) NOT NULL,
  `idPresentacion` int(11) DEFAULT NULL,
  `nombrePresentacion` varchar(300) DEFAULT NULL,
  `valorPresentacion` decimal(18,2) NOT NULL,
  `precioPresentacion` decimal(18,2) NOT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `valorVenta` decimal(18,2) NOT NULL,
  `monto` decimal(18,2) NOT NULL,
  `cantidadTotal` decimal(18,2) NOT NULL,
  `cantidadUsada` decimal(18,2) NOT NULL,
  `cantidadSaldo` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `observacion` varchar(400) DEFAULT NULL,
  `estado` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL DEFAULT '1',
  `anulado` bit(1) DEFAULT b'0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Volcado de datos para la tabla `detalle_nota_almacen`
--

INSERT INTO `detalle_nota_almacen` (`idDetaNota`, `idNotaAlmacen`, `idProducto`, `nombreProducto`, `idPresentacion`, `nombrePresentacion`, `valorPresentacion`, `precioPresentacion`, `valorUnitario`, `precioUnitario`, `cantidad`, `valorVenta`, `monto`, `cantidadTotal`, `cantidadUsada`, `cantidadSaldo`, `idUnidadMedida`, `unidadMedida`, `observacion`, `estado`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `anulado`) VALUES
(5892, 2977, 1517, 'producto prueba', 1687, '-', '5.00', '5.90', '5.00', '5.90', '4.00', '20.00', '23.60', '4.00', '0.00', '4.00', '4A', 'BOBINAS', NULL, 'C', '2020-02-25 02:29:59', 'ADMIN', '-', NULL, NULL, NULL, 1, b'0'),
(5893, 2978, 1517, 'producto prueba', 1687, '-', '65.00', '76.70', '65.00', '76.70', '45.00', '2925.00', '3451.50', '45.00', '0.00', '45.00', '4A', 'BOBINAS', NULL, 'C', '2020-02-25 02:46:37', 'ADMIN', '-', NULL, NULL, NULL, 1, b'0');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_orden`
--

CREATE TABLE `detalle_orden` (
  `idDetalleOrden` int(11) NOT NULL,
  `idOrdenCompra` int(11) DEFAULT NULL,
  `idProducto` int(11) NOT NULL,
  `nombreProducto` varchar(300) NOT NULL,
  `idPresentacion` int(11) NOT NULL,
  `nombrePresentacion` varchar(300) NOT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `valorUnitarioA` decimal(18,2) NOT NULL,
  `descuentoUnitario` decimal(18,2) NOT NULL DEFAULT '0.00',
  `descuentoUnitarioA` decimal(18,2) NOT NULL DEFAULT '0.00',
  `precioUnitario` decimal(18,2) NOT NULL,
  `precioUnitarioA` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `cantidadAceptada` decimal(18,2) NOT NULL,
  `cantidadRechazada` decimal(18,2) NOT NULL,
  `cantidadReenviada` decimal(18,2) NOT NULL,
  `valorVenta` decimal(18,2) NOT NULL,
  `valorVentaA` decimal(18,2) NOT NULL,
  `descuentoTotal` decimal(18,2) NOT NULL DEFAULT '0.00',
  `descuentoTotalA` decimal(18,2) NOT NULL DEFAULT '0.00',
  `monto` decimal(18,2) NOT NULL,
  `montoA` decimal(18,2) NOT NULL,
  `cantidadTotal` decimal(18,2) NOT NULL,
  `cantidadTotalA` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `estado` char(5) NOT NULL,
  `urgencia` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `detalle_orden`
--

INSERT INTO `detalle_orden` (`idDetalleOrden`, `idOrdenCompra`, `idProducto`, `nombreProducto`, `idPresentacion`, `nombrePresentacion`, `valorUnitario`, `valorUnitarioA`, `descuentoUnitario`, `descuentoUnitarioA`, `precioUnitario`, `precioUnitarioA`, `cantidad`, `cantidadAceptada`, `cantidadRechazada`, `cantidadReenviada`, `valorVenta`, `valorVentaA`, `descuentoTotal`, `descuentoTotalA`, `monto`, `montoA`, `cantidadTotal`, `cantidadTotalA`, `idUnidadMedida`, `unidadMedida`, `estado`, `urgencia`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(2540, 1473, 1517, 'producto prueba', 1687, '-', '5.00', '0.00', '1.00', '0.00', '4.72', '0.00', '5.00', '0.00', '0.00', '0.00', '25.00', '0.00', '5.00', '0.00', '23.60', '0.00', '5.00', '0.00', '4A', 'BOBINAS', 'EN', 'B', '2020-02-25 00:30:47', 'innovateperu', '-', '2020-02-25 00:30:47', '-', '-', 1),
(2541, 1480, 1517, 'producto prueba', 1687, '-', '5.00', '0.00', '0.00', '0.00', '5.90', '0.00', '4.00', '0.00', '0.00', '0.00', '20.00', '0.00', '0.00', '0.00', '23.60', '0.00', '4.00', '0.00', '4A', 'BOBINAS', 'EN', 'B', '2020-02-25 01:28:29', 'admin', '-', '2020-02-25 01:28:29', '-', '-', 1),
(2542, 1481, 1517, 'producto prueba', 1687, '-', '65.00', '0.00', '0.00', '0.00', '76.70', '0.00', '45.00', '0.00', '0.00', '0.00', '2925.00', '0.00', '0.00', '0.00', '3451.50', '0.00', '45.00', '0.00', '4A', 'BOBINAS', 'EN', 'B', '2020-02-25 02:46:27', 'admin', '-', '2020-02-25 02:46:27', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_orden_mantenimiento`
--

CREATE TABLE `detalle_orden_mantenimiento` (
  `idDetaOrden` int(11) NOT NULL,
  `idOrdenMantenimiento` int(11) NOT NULL,
  `idOrdenCompra` int(11) DEFAULT NULL,
  `idCompra` int(11) DEFAULT NULL,
  `idNotaAlmacen` int(11) DEFAULT NULL,
  `idProveedor` int(11) DEFAULT NULL,
  `idProducto` int(11) NOT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `fechaSalida` datetime DEFAULT NULL,
  `observacion` varchar(500) NOT NULL,
  `estado` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `cantidadConsumida` decimal(18,2) DEFAULT '0.00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `detalle_orden_servicio`
--

CREATE TABLE `detalle_orden_servicio` (
  `idDetaOrden` int(11) NOT NULL,
  `idOrdenServicio` int(11) NOT NULL,
  `idOrdenCompra` int(11) DEFAULT NULL,
  `idCompra` int(11) DEFAULT NULL,
  `idNotaAlmacen` int(11) DEFAULT NULL,
  `idProveedor` int(11) DEFAULT NULL,
  `idProducto` int(11) NOT NULL,
  `valorUnitario` decimal(18,2) NOT NULL,
  `precioUnitario` decimal(18,2) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `unidadMedida` varchar(300) NOT NULL,
  `fechaSalida` datetime DEFAULT NULL,
  `observacion` varchar(500) NOT NULL,
  `estado` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `cantidadConsumida` decimal(18,2) DEFAULT '0.00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `documento_venta`
--

CREATE TABLE `documento_venta` (
  `id` int(11) NOT NULL,
  `idCliente` int(11) NOT NULL,
  `idTipoDocumento` int(11) NOT NULL,
  `idMoneda` int(11) NOT NULL,
  `idFormaPago` int(11) NOT NULL,
  `idMedioPago` int(11) NOT NULL,
  `idCanal` int(11) NOT NULL,
  `correlativo` varchar(9) NOT NULL,
  `fecha_emision` timestamp NOT NULL,
  `serie` varchar(50) NOT NULL,
  `numero` varchar(50) NOT NULL,
  `tasa_cambio` decimal(18,3) NOT NULL,
  `igv` decimal(18,3) NOT NULL,
  `monto_subtotal` decimal(18,6) NOT NULL,
  `monto_descuento_total` decimal(18,6) NOT NULL,
  `monto_igv_total` decimal(18,6) NOT NULL,
  `monto_total` decimal(18,6) NOT NULL,
  `monto_interes` decimal(18,6) NOT NULL,
  `monto_total_interes` decimal(18,6) NOT NULL,
  `estado` varchar(2) NOT NULL,
  `fecha_registro` timestamp NOT NULL,
  `usuario_registro` varchar(50) NOT NULL,
  `pc_registro` varchar(50) NOT NULL,
  `fecha_edicion` timestamp NOT NULL,
  `usuario_edicion` varchar(50) NOT NULL,
  `pc_edicion` varchar(50) NOT NULL,
  `activo` smallint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `documento_venta`
--

INSERT INTO `documento_venta` (`id`, `idCliente`, `idTipoDocumento`, `idMoneda`, `idFormaPago`, `idMedioPago`, `idCanal`, `correlativo`, `fecha_emision`, `serie`, `numero`, `tasa_cambio`, `igv`, `monto_subtotal`, `monto_descuento_total`, `monto_igv_total`, `monto_total`, `monto_interes`, `monto_total_interes`, `estado`, `fecha_registro`, `usuario_registro`, `pc_registro`, `fecha_edicion`, `usuario_edicion`, `pc_edicion`, `activo`) VALUES
(12, 1, 4, 1, 1, 1, 1, 'DV-000001', '2020-04-20 05:00:00', '223323', '5656565', '0.000', '0.000', '476.590000', '41.530000', '78.310000', '513.380000', '51.340000', '564.720000', 'A', '2020-04-21 21:32:19', 'admin', 'KevinEA', '2020-04-21 21:32:19', 'admin', 'KevinEA', 1),
(13, 2, 2, 2, 5, 1, 1, 'DV-000002', '2020-04-18 05:00:00', 'fb331', '12212', '0.000', '0.000', '287.650000', '27.970000', '46.740000', '306.430000', '15.320000', '321.760000', 'A', '2020-04-21 23:22:10', 'admin', 'KevinEA', '2020-04-21 23:22:10', 'admin', 'KevinEA', 1),
(14, 22, 3, 1, 10, 2, 1, 'DV-000003', '2020-04-21 05:00:00', '212', 'ewd12', '0.000', '0.000', '499.120000', '76.270000', '76.110000', '498.960000', '149.700000', '648.660000', 'A', '2020-04-21 23:24:59', 'admin', 'KevinEA', '2020-04-21 23:24:59', 'admin', 'KevinEA', 1),
(15, 32, 2, 1, 1, 2, 3, 'DV-000004', '2020-04-21 05:00:00', '22222', '33333', '0.000', '0.000', '130.000000', '25.000000', '0.000000', '105.000000', '10.500000', '115.500000', 'A', '2020-04-22 08:28:11', 'admin', 'KevinEA', '2020-04-24 00:59:58', 'admin', 'KevinEA', 1),
(16, 2, 2, 1, 1, 2, 2, 'DV-000005', '2020-04-22 05:00:00', '555', '55555', '1.000', '0.000', '179.000000', '29.000000', '0.000000', '150.000000', '18.220000', '200.440000', 'A', '2020-04-22 09:29:55', 'admin', 'KevinEA', '2020-04-24 00:03:15', 'admin', 'KevinEA', 1),
(17, 9, 4, 2, 5, 2, 2, 'DV-000006', '2020-04-23 05:00:00', '323232', '32322332', '3.880', '18.000', '148.060000', '16.100000', '23.750000', '155.710000', '7.800000', '163.480000', 'A', '2020-04-24 01:05:52', 'admin', 'KevinEA', '2020-04-24 01:05:52', 'admin', 'KevinEA', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `empaque`
--

CREATE TABLE `empaque` (
  `idEmpaque` int(11) NOT NULL,
  `idClase` int(11) NOT NULL,
  `idEmpaqueM` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `empresa`
--

CREATE TABLE `empresa` (
  `idEmpresa` int(11) NOT NULL,
  `ruc` char(11) NOT NULL,
  `razonSocial` varchar(400) NOT NULL,
  `nombreComercial` varchar(400) NOT NULL,
  `domicilioFiscal` varchar(400) NOT NULL,
  `correo` varchar(400) DEFAULT NULL,
  `telefono` varchar(30) DEFAULT NULL,
  `correoEnvio` varchar(100) DEFAULT NULL,
  `passCorreo` varchar(100) DEFAULT NULL,
  `cuerpoCT` varchar(2000) DEFAULT NULL,
  `cuerpoOC` varchar(2000) DEFAULT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `empresa`
--

INSERT INTO `empresa` (`idEmpresa`, `ruc`, `razonSocial`, `nombreComercial`, `domicilioFiscal`, `correo`, `telefono`, `correoEnvio`, `passCorreo`, `cuerpoCT`, `cuerpoOC`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, '20132171573', 'TARGOX', 'TARGOX', '-', 'contacto@targox.pe', '-', 'fabio.peralta20@gmail.com', 'fabioperalta260304', 'Se solicita que se envié la siguiente cotización.', 'Se solicita la siguiente Orden de compra.', '2018-09-06 00:00:00', 'admin', '-', '2020-02-25 01:20:09', 'admin', NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `forma_pago`
--

CREATE TABLE `forma_pago` (
  `id` int(11) NOT NULL,
  `tipo_frecuencia_id` int(11) NOT NULL,
  `nombre` varchar(200) NOT NULL,
  `numero_cuotas` int(11) NOT NULL,
  `frecuencia` int(11) NOT NULL,
  `interes` int(11) NOT NULL,
  `activo` smallint(6) NOT NULL,
  `registro_fecha_add` timestamp NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` timestamp NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `forma_pago`
--

INSERT INTO `forma_pago` (`id`, `tipo_frecuencia_id`, `nombre`, `numero_cuotas`, `frecuencia`, `interes`, `activo`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`) VALUES
(1, 3, 'Prueba 1', 2, 2, 10, 1, '2020-04-10 04:52:14', 'admin', 'KevinEA', '2020-04-10 06:19:13', 'admin', 'KevinEA'),
(2, 2, 'Prueba 2', 4, 2, 10, 1, '2020-04-10 05:21:15', 'admin', 'KevinEA', '2020-04-10 05:21:15', 'admin', 'KevinEA'),
(3, 4, 'aaaa', 2, 2, 10, 2, '2020-04-10 05:22:52', 'admin', 'KevinEA', '2020-04-10 05:22:52', 'admin', 'KevinEA'),
(4, 2, 'Prueba 3', 4, 2, 5, 2, '2020-04-10 05:25:44', 'admin', 'KevinEA', '2020-04-10 05:25:44', 'admin', 'KevinEA'),
(5, 1, 'Prueba 4', 4, 2, 5, 1, '2020-04-10 06:11:22', 'admin', 'KevinEA', '2020-04-10 06:18:43', 'admin', 'KevinEA'),
(6, 2, 'Prueba 5', 4, 2, 5, 0, '2020-04-10 06:16:19', 'admin', 'KevinEA', '2020-04-10 06:18:12', 'admin', 'KevinEA'),
(7, 0, 'wwwww', 2, 2, 10, 1, '2020-04-15 06:19:54', 'admin', 'KevinEA', '2020-04-15 06:19:54', 'admin', 'KevinEA'),
(8, 1, 'sssss', 2, 2, 10, 1, '2020-04-15 06:21:20', 'admin', 'KevinEA', '2020-04-17 08:33:25', 'admin', 'KevinEA'),
(9, 2, 'yyyy', 3, 2, 11, 1, '2020-04-17 08:34:04', 'admin', 'KevinEA', '2020-04-17 08:34:04', 'admin', 'KevinEA'),
(10, 3, 'mmmmm', 3, 3, 30, 1, '2020-04-17 08:34:31', 'admin', 'KevinEA', '2020-04-17 21:54:21', 'admin', 'KevinEA'),
(11, 3, 'sdfghjk', 1, 1, 10, 2, '2020-04-17 08:57:52', 'admin', 'KevinEA', '2020-04-17 08:57:52', 'admin', 'KevinEA'),
(12, 4, 'cccc', 3, 1, 20, 1, '2020-04-17 21:54:53', 'admin', 'KevinEA', '2020-04-17 21:54:53', 'admin', 'KevinEA');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `grupo`
--

CREATE TABLE `grupo` (
  `idGrupo` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(250) NOT NULL,
  `icono` varchar(50) NOT NULL,
  `orden` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `grupo`
--

INSERT INTO `grupo` (`idGrupo`, `nombre`, `descripcion`, `icono`, `orden`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 'Accesos', 'Define usuarios y accesos al sistema, solo usado por el administrado.', 'fa fa-home', 2, '2017-04-15 11:06:35', 'admin', '-', '2018-10-18 14:37:07', 'admin', '-', 1),
(2, 'Registros', 'Plataforma para editar los accesos del personal, \n	asignar sus roles y diversas tareas.', 'fa fa-table', 3, '2017-04-15 11:06:35', 'admin', '-', '2017-04-18 19:12:45', 'admin', '-', 1),
(3, 'Procesos', 'Plataforma para editar los accesos del personal, \n	asignar sus roles y diversas tareas.', 'fa fa-desktop', 4, '2017-04-15 11:06:35', 'admin', '-', '2017-04-15 11:06:35', '-', '-', 1),
(4, 'Reportes', 'Reportes', 'fa fa-bar-chart-o', 5, '2017-08-06 09:13:24', 'admin', '-', '2018-06-05 23:03:33', 'admin', '-', 1),
(5, 'Configuración', 'Plataforma para configurar los datos generales del sistema.', 'fa fa-cog', 6, '2018-10-22 10:30:50', 'admin', '-', '2018-10-22 10:32:39', 'admin', '-', 1),
(6, 'Dashboard', 'Dashboard', 'fa fa-bar-chart-o', 1, '2020-04-19 16:56:47', 'admin', '-', '2020-04-19 16:56:47', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `grupo_cotizacion`
--

CREATE TABLE `grupo_cotizacion` (
  `idGrupoCotizacion` int(11) NOT NULL,
  `idOrdenMantenimiento` int(11) DEFAULT NULL,
  `idOrdenServicio` int(11) DEFAULT NULL,
  `correlativo` char(8) DEFAULT NULL,
  `subTotal` decimal(18,2) NOT NULL,
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEnvio` datetime DEFAULT NULL,
  `estado` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `grupo_ordencompra`
--

CREATE TABLE `grupo_ordencompra` (
  `idGrupoOrden` int(11) NOT NULL,
  `correlativo` char(8) DEFAULT NULL,
  `subTotal` decimal(18,2) NOT NULL,
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEnvio` datetime DEFAULT NULL,
  `estado` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `igv`
--

CREATE TABLE `igv` (
  `idIGV` int(11) NOT NULL,
  `anio` int(11) NOT NULL,
  `porcentaje` decimal(18,2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `igv`
--

INSERT INTO `igv` (`idIGV`, `anio`, `porcentaje`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 2017, '18.00', '2017-02-26 10:04:14', 'admin', '-', '2018-04-22 17:20:50', 'admin', '-', 1),
(2, 2015, '45.56', '2017-10-13 21:27:01', 'admin', '-', '2017-10-13 21:27:01', '-', '-', 1),
(3, 2018, '18.00', '2018-01-31 18:41:57', 'admin', '-', '2018-01-31 18:41:57', '-', '-', 1),
(4, 2019, '18.00', '2019-01-02 19:47:37', 'admin', '-', '2019-01-02 19:47:37', '-', '-', 1),
(5, 2020, '18.00', '2020-01-02 11:32:51', 'admin', '-', '2020-01-02 11:32:51', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `multitabla`
--

CREATE TABLE `multitabla` (
  `idMultitabla` int(11) NOT NULL,
  `valor` int(11) NOT NULL,
  `dep_id` int(11) DEFAULT NULL,
  `descripcion` varchar(300) NOT NULL,
  `abrev` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `multitabla`
--

INSERT INTO `multitabla` (`idMultitabla`, `valor`, `dep_id`, `descripcion`, `abrev`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, NULL, 'Subcategoria de Proveedor', 'SP', '2017-03-01 19:43:13', 'admin', '-', '2018-05-20 16:14:22', 'admin', '-', 1),
(28, 1, 1, 'BIENES', 'B', '2017-05-08 19:53:46', 'admin', '-', '2018-07-24 02:34:41', 'admin', '-', 1),
(3, 2, NULL, 'Calificación de Proveedor', 'CP', '2017-03-01 19:43:37', 'admin', '-', '2018-06-16 21:55:28', 'admin', '-', 1),
(4, 1, 2, 'Bueno', 'B', '2017-03-01 19:43:44', 'admin', '-', '2018-04-22 17:04:30', 'admin', '-', 1),
(5, 2, 2, 'Regular', 'R', '2017-03-01 19:43:48', 'admin', '-', '2017-03-01 19:43:48', '-', '-', 1),
(6, 3, 2, 'Malor', 'M', '2017-03-01 19:43:53', 'admin', '-', '2017-03-01 19:43:53', '-', '-', 1),
(7, 3, NULL, 'Unidad de Medida (TABLA 6 - SUNAT)', 'T6', '2017-03-01 19:44:06', 'admin', '-', '2018-07-01 22:13:10', 'admin', '-', 1),
(141, 11, 3, 'CIENTO DE UNIDADES', 'CEN', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(140, 10, 3, 'CENTIMETRO LINEAL', 'CMT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(139, 9, 3, 'CENTIMETRO CUBICO', 'CMQ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(13, 4, NULL, 'Empaque de Presentación', 'EP', '2017-03-01 19:45:10', 'admin', '-', '2018-06-12 22:03:08', 'admin', '-', 1),
(14, 1, 4, 'Saco', 'S', '2017-03-01 19:45:20', 'admin', '-', '2017-03-01 19:45:20', '-', '-', 1),
(15, 2, 4, 'Granel', 'G', '2017-03-01 19:45:25', 'admin', '-', '2017-03-01 19:45:25', '-', '-', 1),
(16, 3, 4, 'Bolsa', 'B', '2017-03-01 19:45:29', 'admin', '-', '2017-03-01 19:45:29', '-', '-', 1),
(17, 4, 4, 'Botella', 'BT', '2017-03-01 19:45:43', 'admin', '-', '2017-03-01 19:46:08', 'admin', '-', 1),
(18, 5, NULL, 'Estado  de Grupo de Cotización', 'EGC', '2017-03-01 19:46:22', 'admin', '-', '2018-06-23 20:33:26', 'admin', '-', 1),
(19, 1, 5, 'Aceptada', 'A', '2017-03-01 19:46:30', 'admin', '-', '2017-03-19 23:08:46', 'admin', '-', 1),
(20, 2, 5, 'Anulada', 'AN', '2017-03-01 19:46:35', 'admin', '-', '2017-03-01 19:46:35', '-', '-', 1),
(21, 3, 5, 'Archivada', 'AR', '2017-03-01 19:46:39', 'admin', '-', '2018-06-17 20:50:27', 'admin', '-', 1),
(22, 4, 5, 'Enviada', 'EN', '2017-03-01 19:46:44', 'admin', '-', '2018-06-17 20:50:35', 'admin', '-', 1),
(23, 6, NULL, 'Urgencia', 'U', '2017-03-19 22:59:31', 'admin', '-', '2018-05-20 16:33:32', 'admin', '-', 1),
(24, 1, 6, 'Alta', 'A', '2017-03-19 22:59:41', 'admin', '-', '2017-03-19 22:59:41', '-', '-', 1),
(25, 2, 6, 'Medio', 'M', '2017-03-19 22:59:45', 'admin', '-', '2017-03-19 23:00:06', 'admin', '-', 1),
(26, 3, 6, 'Baja', 'B', '2017-03-19 22:59:53', 'admin', '-', '2017-03-19 23:00:22', 'admin', '-', 1),
(27, 5, 5, 'Procesando', 'P', '2017-03-19 23:08:55', 'admin', '-', '2018-06-17 20:50:43', 'admin', '-', 1),
(29, 2, 1, 'SERVICIOS', 'S', '2017-05-08 20:18:47', 'Anghelo', '-', '2018-07-24 02:34:50', 'admin', '-', 1),
(30, 3, 1, 'BIENES Y SERVICIOS', 'BS', '2017-05-08 20:19:26', 'Anghelo', '-', '2018-07-24 02:35:14', 'admin', '-', 1),
(130, 3, 11, 'Cerrada', 'C', '2018-08-05 13:31:09', 'admin', '-', '2018-08-05 13:31:09', '-', '-', 1),
(34, 7, NULL, 'Estado Detalle Cotización', 'ED', '2017-06-30 01:39:00', 'admin', '-', '2018-06-12 22:03:23', 'admin', '-', 1),
(35, 1, 7, 'Cerrado', 'C', '2017-07-12 08:10:05', 'admin', '-', '2017-07-12 08:10:05', '-', '-', 1),
(36, 2, 7, 'Procesando', 'P', '2017-07-12 08:10:17', 'admin', '-', '2017-07-12 08:10:17', '-', '-', 1),
(37, 3, 7, 'Enviado', 'EN', '2017-07-12 08:10:28', 'admin', '-', '2017-07-12 08:10:28', '-', '-', 1),
(39, 8, NULL, 'Forma de Pago', 'FP', '2018-02-06 01:02:19', 'admin', '-', '2018-02-06 01:02:19', '-', '-', 1),
(40, 1, 8, '001 - Contado', 'F1', '2018-02-06 01:02:45', 'admin', '-', '2018-02-06 01:03:36', 'admin', '-', 1),
(41, 2, 8, '002 - Transf. Ctas', 'F2', '2018-02-06 01:02:56', 'admin', '-', '2018-02-06 01:03:47', 'admin', '-', 1),
(42, 3, 8, '003 - Letra 30 dí­as', 'F3', '2018-02-06 01:04:01', 'admin', '-', '2018-06-16 23:59:56', 'admin', '-', 1),
(43, 9, NULL, 'Tipo de Trabajador', 'TT', '2018-03-14 00:06:14', 'admin', '-', '2018-03-14 00:06:14', '-', '-', 1),
(44, 1, 9, 'Gerente', 'G', '2018-03-14 00:06:35', 'admin', '-', '2018-03-14 00:06:35', '-', '-', 1),
(45, 2, 9, 'Administrador', 'ADMIN', '2018-03-14 00:06:44', 'admin', '-', '2018-06-21 00:47:58', 'admin', '-', 1),
(46, 3, 9, 'Jefe de Almacen', 'JA', '2018-03-14 00:06:53', 'admin', '-', '2018-03-14 00:07:18', 'admin', '-', 1),
(47, 4, 9, 'Jefe de Compras', 'JC', '2018-03-14 00:07:31', 'admin', '-', '2018-03-14 00:07:31', '-', '-', 1),
(48, 5, 9, 'Conductor', 'COND', '2018-03-14 00:07:37', 'admin', '-', '2018-06-21 00:46:29', 'admin', '-', 1),
(49, 10, NULL, 'Estado de OTM', 'EO', '2018-03-14 00:49:02', 'admin', '-', '2018-03-14 00:49:02', '-', '-', 1),
(50, 1, 10, 'Abierto', 'A', '2018-03-14 00:49:10', 'admin', '-', '2018-03-14 00:49:10', '-', '-', 1),
(51, 2, 10, 'Anulado', 'AN', '2018-03-14 00:49:15', 'admin', '-', '2018-07-15 12:34:06', 'admin', '-', 1),
(138, 8, 3, 'CENTIMETRO CUADRADO', 'CMK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(53, 11, NULL, 'Estado de Nota de Almacen', 'EN', '2018-04-22 20:01:29', 'admin', '-', '2018-04-22 20:01:29', '-', '-', 1),
(54, 1, 11, 'Abierta', 'A', '2018-04-22 20:01:44', 'admin', '-', '2018-04-22 20:01:58', 'admin', '-', 1),
(55, 2, 11, 'Anulada', 'AN', '2018-04-22 20:01:51', 'admin', '-', '2018-08-05 13:31:04', 'admin', '-', 1),
(56, 12, NULL, 'Tipo de Nota de Almacen', 'TN', '2018-04-22 20:37:06', 'admin', '-', '2018-04-22 20:37:06', '-', '-', 1),
(57, 1, 12, 'ENTRADA', 'E', '2018-04-22 20:37:17', 'admin', '-', '2018-10-30 09:29:08', 'admin', '-', 1),
(58, 2, 12, 'SALIDA', 'S', '2018-04-22 20:37:22', 'admin', '-', '2018-10-30 09:22:56', 'admin', '-', 1),
(59, 13, NULL, 'Motivo de Nota Almacen', 'MNA', '2018-04-22 20:37:40', 'admin', '-', '2018-10-17 07:22:09', 'admin', '-', 1),
(60, 1, 13, 'USO DE TRABAJO', 'UT', '2018-04-22 20:37:54', 'admin', '-', '2018-10-17 07:22:26', 'admin', '-', 1),
(61, 2, 13, 'PRESTAMO', 'P', '2018-04-22 20:38:02', 'admin', '-', '2018-10-17 07:22:34', 'admin', '-', 1),
(62, 14, NULL, 'Tipo de Existencia (TABLA 5 - SUNAT)', 'T5', '2018-05-19 16:04:18', 'admin', '-', '2018-05-27 07:40:51', 'admin', '-', 1),
(63, 1, 14, 'MERCADERÍA', '01', '2018-05-19 16:05:46', 'admin', '-', '2018-05-27 07:41:13', 'admin', '-', 1),
(64, 2, 14, 'PRODUCTO TERMINADOS', '02', '2018-05-19 16:06:16', 'admin', '-', '2018-05-27 07:42:11', 'admin', '-', 1),
(65, 3, 14, 'MATERIAS PRIMAS', '03', '2018-05-19 16:06:28', 'admin', '-', '2018-05-27 07:42:22', 'admin', '-', 1),
(66, 4, 14, 'ENVASES', '04', '2018-05-19 16:06:39', 'admin', '-', '2018-05-27 07:42:35', 'admin', '-', 1),
(67, 5, 14, 'MATERIALES AUXILIARES', '05', '2018-05-19 16:06:45', 'admin', '-', '2018-05-27 07:42:53', 'admin', '-', 1),
(68, 5, 4, 'Caja', 'C', '2018-05-20 16:58:40', 'admin', '-', '2018-05-20 16:58:40', '-', '-', 1),
(137, 7, 3, 'CARTONES', 'CT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(136, 6, 3, 'CAJA', 'BX', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(135, 5, 3, 'BOTELLAS', 'BO', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(134, 4, 3, 'BOLSA', 'BG', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(133, 3, 3, 'BARRILES', 'BLL', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(132, 2, 3, 'BALDE', 'BJ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(131, 1, 3, 'BOBINAS', '4A', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(79, 6, 14, 'SUMINISTROS', '06', '2018-05-27 07:43:02', 'admin', '-', '2018-05-27 07:43:02', '-', '-', 1),
(80, 7, 14, 'REPUESTOS', '07', '2018-05-27 07:43:12', 'admin', '-', '2018-05-27 07:43:12', '-', '-', 1),
(81, 8, 14, 'EMBALAJES', '08', '2018-05-27 07:43:21', 'admin', '-', '2018-05-27 07:43:21', '-', '-', 1),
(82, 9, 14, 'SUBPRODUCTOS', '09', '2018-05-27 07:43:30', 'admin', '-', '2018-05-27 07:43:30', '-', '-', 1),
(83, 10, 14, 'DESECHOS Y DESPERDICIOS', '10', '2018-05-27 07:43:47', 'admin', '-', '2018-05-27 07:43:47', '-', '-', 1),
(84, 11, 14, 'OTROS', '99', '2018-05-27 07:44:01', 'admin', '-', '2018-05-27 07:44:01', '-', '-', 1),
(85, 15, NULL, 'Tipo de Documento (TABLA 10 - SUNAT)', 'T10', '2018-05-27 07:45:57', 'admin', '-', '2018-07-01 22:12:48', 'admin', '-', 1),
(86, 1, 15, 'OTROS', '00', '2018-05-27 12:07:24', 'admin', '-', '2019-10-17 10:33:43', 'admin', '-', 1),
(87, 2, 15, 'FACTURA', '01', '2018-05-27 12:07:36', 'admin', '-', '2019-10-17 10:33:51', 'admin', '-', 1),
(88, 3, 15, 'RECIBO POR HONORARIOS', '02', '2018-05-27 12:07:50', 'admin', '-', '2019-10-17 10:34:03', 'admin', '-', 1),
(89, 4, 15, 'BOLETA DE VENTA', '03', '2018-06-07 00:07:15', 'admin', '-', '2019-10-17 10:34:12', 'admin', '-', 1),
(90, 6, 5, 'Sin Guardar', 'SN', '2018-06-17 13:31:52', 'admin', '-', '2018-06-17 13:33:41', 'admin', '-', 1),
(91, 6, 9, 'Asistente', 'ASIST', '2018-06-21 00:48:09', 'admin', '-', '2018-06-21 00:48:09', '-', '-', 1),
(92, 7, 9, 'Auxiliar', 'AUX', '2018-06-21 00:48:26', 'admin', '-', '2018-06-21 00:48:26', '-', '-', 1),
(93, 8, 9, 'Mecánico', 'MECAN', '2018-06-21 00:48:40', 'admin', '-', '2018-06-21 00:48:40', '-', '-', 1),
(94, 16, NULL, 'Estado de Cotización', 'EC', '2018-06-23 20:33:44', 'admin', '-', '2018-06-23 20:33:44', '-', '-', 1),
(95, 17, NULL, 'Estado de Orden de Compra', 'EOC', '2018-06-23 20:34:09', 'admin', '-', '2018-06-23 20:34:09', '-', '-', 1),
(96, 1, 16, 'Aceptada', 'A', '2018-06-23 20:35:11', 'admin', '-', '2018-06-23 20:35:11', '-', '-', 1),
(97, 2, 16, 'Anulada', 'AN', '2018-06-23 20:36:16', 'admin', '-', '2018-06-23 20:36:16', '-', '-', 1),
(98, 3, 16, 'Archivada', 'AR', '2018-06-23 20:36:27', 'admin', '-', '2018-06-23 20:36:27', '-', '-', 1),
(99, 4, 16, 'Enviada', 'EN', '2018-06-23 20:36:38', 'admin', '-', '2018-06-23 20:36:38', '-', '-', 1),
(100, 5, 16, 'Procesando', 'P', '2018-06-23 20:36:51', 'admin', '-', '2018-06-23 20:36:51', '-', '-', 1),
(101, 1, 17, 'Aceptada', 'A', '2018-06-23 20:38:49', 'admin', '-', '2018-06-23 20:38:49', '-', '-', 1),
(102, 2, 17, 'Anulada', 'AN', '2018-06-23 20:39:06', 'admin', '-', '2018-06-23 20:39:06', '-', '-', 1),
(103, 3, 17, 'Enviada', 'EN', '2018-06-23 20:39:40', 'admin', '-', '2018-06-23 20:39:40', '-', '-', 1),
(104, 4, 17, 'Procesando', 'P', '2018-06-23 20:40:02', 'admin', '-', '2018-06-23 20:40:02', '-', '-', 1),
(105, 5, 17, 'Sin Enviar', 'SE', '2018-06-23 20:40:12', 'admin', '-', '2018-06-23 20:40:12', '-', '-', 1),
(106, 6, 17, 'Sin Guardar', 'SN', '2018-06-23 20:40:20', 'admin', '-', '2018-06-24 03:15:44', 'admin', '-', 1),
(107, 18, NULL, 'Tipo de Operación Entrada (TABLA 12 - SUNAT)', 'T12E', '2018-07-01 22:05:20', 'admin', '-', '2018-11-08 17:04:13', 'admin', '-', 1),
(108, 1, 22, 'VENTA NACIONAL', '01', '2018-07-01 22:06:22', 'admin', '-', '2018-07-01 22:06:22', '-', '-', 1),
(109, 1, 18, 'COMPRA', '02', '2018-07-01 22:06:30', 'admin', '-', '2018-11-08 17:33:58', 'admin', '-', 1),
(110, 2, 18, 'CONSIGNACION RECIBIDA', '03', '2018-07-01 22:06:39', 'admin', '-', '2018-11-07 10:24:08', 'admin', '-', 1),
(111, 2, 22, 'CONSIGNACION ENTREGADA', '04', '2018-07-01 22:06:48', 'admin', '-', '2018-11-07 10:24:14', 'admin', '-', 1),
(112, 3, 18, 'DEVOLUCION RECIBIDA', '05', '2018-07-01 22:11:30', 'admin', '-', '2018-11-07 10:23:50', 'admin', '-', 1),
(113, 3, 22, 'DEVOLUCION ENTREGADA', '06', '2018-07-01 22:11:39', 'admin', '-', '2018-11-07 10:23:55', 'admin', '-', 1),
(114, 4, 18, 'BONIFICACION', '07', '2018-07-01 22:11:48', 'admin', '-', '2018-11-07 10:24:02', 'admin', '-', 1),
(115, 4, 22, 'PREMIO', '08', '2018-07-01 22:11:56', 'admin', '-', '2018-07-01 22:11:56', '-', '-', 1),
(116, 5, 22, 'DONACION', '09', '2018-07-01 22:12:05', 'admin', '-', '2018-11-07 10:31:37', 'admin', '-', 1),
(117, 6, 22, 'SALIDA', '10', '2018-07-01 22:12:12', 'admin', '-', '2018-11-11 19:57:01', 'admin', '-', 1),
(118, 7, 22, 'SALIDA POR TRANSFERENCIA ENTRE ALMACENES ', '11', '2018-07-01 22:12:20', 'admin', '-', '2018-07-01 22:12:20', '-', '-', 1),
(204, 8, 22, 'RETIRO', '12', '2018-11-06 11:27:17', 'admin', '-', '2018-11-06 11:27:24', 'admin', '-', 1),
(122, 9, 9, 'Tornero', 'TOR', '2018-03-14 00:07:37', 'admin', '-', '2018-12-18 12:07:08', 'admin', '-', 1),
(123, 10, 9, 'Contador', 'CONT', '2018-03-14 00:07:37', 'admin', '-', '2018-03-14 00:07:37', '-', '-', 1),
(124, 19, NULL, 'Tipo de Vehículo', 'TV', '2018-07-13 21:19:11', 'admin', '-', '2018-07-13 21:19:11', '-', '-', 1),
(125, 1, 19, 'TRACTO', 'TR', '2018-07-13 21:19:35', 'admin', '-', '2018-07-13 21:19:35', '-', '-', 1),
(126, 2, 19, 'PLATAFORMA', 'PL', '2018-07-13 21:19:44', 'admin', '-', '2018-07-13 21:19:44', '-', '-', 1),
(127, 3, 19, 'CISTERNA', 'CIS', '2018-07-13 21:19:54', 'admin', '-', '2018-07-13 21:19:54', '-', '-', 1),
(128, 3, 10, 'Cerrado', 'C', '2018-07-15 12:32:20', 'admin', '-', '2018-07-15 12:34:12', 'admin', '-', 1),
(129, 4, 10, 'Sin Guardar', 'SN', '2018-07-15 12:34:18', 'admin', '-', '2018-07-15 12:34:18', '-', '-', 1),
(142, 12, 3, 'CILINDRO', 'CY', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(143, 13, 3, 'CONOS', 'CJ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(144, 14, 3, 'DOCENA', 'DZN', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(145, 15, 3, 'DOCENA POR 10**6', 'DZP', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(146, 16, 3, 'FARDO', 'BE', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(147, 17, 3, 'GALON INGLES (4,545956L)', 'GLI', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(148, 18, 3, 'GRAMO', 'GRM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(149, 19, 3, 'GRUESA', 'GRO', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(150, 20, 3, 'HECTOLITRO', 'HLT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(151, 21, 3, 'HOJA', 'LEF', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(152, 22, 3, 'JUEGO', 'SET', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(153, 23, 3, 'KILOGRAMO', 'KGM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(154, 24, 3, 'KILOMETRO', 'KTM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(155, 25, 3, 'KILOVATIO HORA', 'KWH', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(156, 26, 3, 'KIT', 'KT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(157, 27, 3, 'LATAS', 'CA', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(158, 28, 3, 'LIBRAS', 'LBR', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(159, 29, 3, 'LITRO', 'LTR', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(160, 30, 3, 'MEGAWATT HORA', 'MWH', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(161, 31, 3, 'METRO', 'MTR', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(162, 32, 3, 'METRO CUADRADO', 'MTK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(163, 33, 3, 'METRO CUBICO', 'MTQ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(164, 34, 3, 'MILIGRAMOS', 'MGM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(165, 35, 3, 'MILILITRO', 'MLT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(166, 36, 3, 'MILIMETRO', 'MMT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(167, 37, 3, 'MILIMETRO CUADRADO', 'MMK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(168, 38, 3, 'MILIMETRO CUBICO', 'MMQ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(169, 39, 3, 'MILLARES', 'MLL', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(170, 40, 3, 'MILLON DE UNIDADES', 'UM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(171, 41, 3, 'ONZAS', 'ONZ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(172, 42, 3, 'PALETAS', 'PF', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(173, 43, 3, 'PAQUETE', 'PK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(174, 44, 3, 'PAR', 'PR', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(175, 45, 3, 'PIES', 'FOT', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(176, 46, 3, 'PIES CUADRADOS', 'FTK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(177, 47, 3, 'PIES CUBICOS', 'FTQ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(178, 48, 3, 'PIEZAS', 'C62', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(179, 49, 3, 'PLACAS', 'PG', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(180, 50, 3, 'PLIEGO', 'ST', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(181, 51, 3, 'PULGADAS', 'INH', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(182, 52, 3, 'RESMA', 'RM', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(183, 53, 3, 'TAMBOR', 'DR', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(184, 54, 3, 'TONELADA CORTA', 'STN', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(185, 55, 3, 'TONELADA LARGA', 'LTN', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(186, 56, 3, 'TONELADAS', 'TNE', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(187, 57, 3, 'TUBOS', 'TU', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(188, 58, 3, 'UNIDAD (BIENES)', 'NIU', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(189, 59, 3, 'UNIDAD (SERVICIOS)', 'ZZ', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(190, 60, 3, 'US GALON (3,7843 L)', 'GLL', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(191, 61, 3, 'YARDA', 'YRD', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(192, 62, 3, 'YARDA CUADRADA', 'YDK', '2018-08-06 01:58:26', 'admin', '-', '2018-08-06 01:58:26', 'admin', '-', 1),
(193, 11, 9, 'Practicante', 'PT', '2018-09-01 12:08:23', 'Ana', '-', '2018-09-01 12:08:23', '-', '-', 1),
(194, 12, 9, 'Jefe de Seguridad', 'JS', '2018-09-25 17:29:21', 'admin', '-', '2018-09-25 17:29:21', '-', '-', 1),
(195, 20, NULL, 'Tipo de Moneda', 'TM', '2018-10-03 08:29:34', 'admin', '-', '2018-10-03 08:29:34', '-', '-', 1),
(196, 1, 20, 'Soles', 'S/', '2018-10-03 08:29:54', 'admin', '-', '2018-10-03 08:29:54', '-', '-', 1),
(197, 2, 20, 'Dolares Americanos', 'USD', '2018-10-03 08:30:09', 'admin', '-', '2018-10-10 22:52:05', 'admin', '-', 1),
(198, 3, 13, 'DEVOLUCION', 'D', '2018-10-17 07:22:39', 'admin', '-', '2018-10-17 07:22:39', '-', '-', 1),
(199, 4, 13, 'REPOSICION', 'R', '2018-10-17 07:22:45', 'admin', '-', '2018-10-17 07:22:45', '-', '-', 1),
(200, 21, NULL, 'Destino Almacen', 'DA', '2018-10-17 08:13:37', 'admin', '-', '2018-10-17 08:13:37', '-', '-', 1),
(201, 1, 21, 'OFICINA', 'O', '2018-10-17 08:13:49', 'admin', '-', '2018-10-17 08:14:34', 'admin', '-', 1),
(202, 2, 21, 'PLACA', 'P', '2018-10-17 08:13:54', 'admin', '-', '2018-10-17 08:14:30', 'admin', '-', 1),
(203, 3, 21, 'TALLER', 'T', '2018-10-17 08:14:26', 'admin', '-', '2018-10-17 08:14:26', '-', '-', 1),
(205, 9, 22, 'MERMAS', '13', '2018-11-06 11:27:36', 'admin', '-', '2018-11-06 11:27:36', '-', '-', 1),
(206, 10, 22, 'DESMEDROS', '14', '2018-11-06 11:28:57', 'admin', '-', '2018-11-06 11:28:57', '-', '-', 1),
(207, 11, 22, 'DESTRUCCION', '15', '2018-11-06 11:29:06', 'admin', '-', '2018-11-07 10:31:52', 'admin', '-', 1),
(208, 5, 18, 'SALDO INICIAL', '16', '2018-11-06 11:29:16', 'admin', '-', '2018-11-06 11:29:16', '-', '-', 1),
(209, 12, 22, 'EXPORTACION', '17', '2018-11-06 11:29:55', 'admin', '-', '2018-11-07 10:31:59', 'admin', '-', 1),
(210, 6, 18, 'IMPORTACION', '18', '2018-11-06 11:32:04', 'admin', '-', '2018-11-07 10:32:05', 'admin', '-', 1),
(211, 7, 18, 'ENTRADA DE PRODUCCION', '19', '2018-11-06 11:32:12', 'admin', '-', '2018-11-07 10:32:14', 'admin', '-', 1),
(212, 8, 18, 'ENTRADA POR DEVOLUCION DE PRODUCCION', '20', '2018-11-06 11:32:22', 'admin', '-', '2018-11-07 10:32:23', 'admin', '-', 1),
(213, 9, 18, 'ENTRADA POR TRANSFERENCIA ENTRE ALMACENES ', '21', '2018-11-06 11:33:17', 'admin', '-', '2018-11-06 11:33:17', '-', '-', 1),
(214, 10, 18, 'ENTRADA POR IDENTIFICACION ERRONEA', '22', '2018-11-06 11:33:23', 'admin', '-', '2018-11-06 11:33:23', '-', '-', 1),
(215, 13, 22, 'SALIDA POR IDENTIFICACION ERRONEA', '23', '2018-11-06 11:33:30', 'admin', '-', '2018-11-06 11:33:30', '-', '-', 1),
(216, 11, 18, 'ENTRADA POR DEVOLUCION DEL CLIENTE', '24', '2018-11-06 11:33:39', 'admin', '-', '2018-11-06 11:33:39', '-', '-', 1),
(217, 14, 22, 'SALIDA POR DEVOLUCION AL PROVEEDOR', '25', '2018-11-06 11:33:44', 'admin', '-', '2018-11-06 11:33:44', '-', '-', 1),
(218, 12, 18, 'ENTRADA PARA SERVICIO DE PRODUCCION', '26', '2018-11-06 11:36:38', 'admin', '-', '2018-11-06 11:36:38', '-', '-', 1),
(219, 15, 22, 'SALIDA POR SERVICIO DE PRODUCCION', '27', '2018-11-06 11:36:57', 'admin', '-', '2018-11-06 11:36:57', '-', '-', 1),
(220, 13, 18, 'AJUSTE POR DIFERENCIA DE INVENTARIO', '28', '2018-11-06 11:37:03', 'admin', '-', '2018-11-06 11:37:03', '-', '-', 1),
(221, 14, 18, 'ENTRADA DE BIENES EN PRESTAMO', '29', '2018-11-06 11:37:08', 'admin', '-', '2018-11-06 11:37:08', '-', '-', 1),
(222, 17, 22, 'SALIDA DE BIENES EN PRESTAMO', '30', '2018-11-06 11:37:15', 'admin', '-', '2018-11-06 11:37:15', '-', '-', 1),
(223, 15, 18, 'ENTRADA DE BIENES EN CUSTODIA', '31', '2018-11-06 11:37:21', 'admin', '-', '2018-11-06 11:37:21', '-', '-', 1),
(224, 18, 22, 'SALIDA DE BIENES EN CUSTODIA', '32', '2018-11-06 11:37:28', 'admin', '-', '2018-11-06 11:37:28', '-', '-', 1),
(225, 16, 18, 'MUESTRAS MEDICAS', '33', '2018-11-06 11:37:39', 'admin', '-', '2018-11-06 11:37:39', '-', '-', 1),
(226, 17, 18, 'PUBLICIDAD', '34', '2018-11-06 11:37:44', 'admin', '-', '2018-11-06 11:37:44', '-', '-', 1),
(227, 19, 22, 'GASTOS DE REPRESENTACION', '35', '2018-11-06 11:37:51', 'admin', '-', '2018-11-06 11:37:51', '-', '-', 1),
(228, 20, 22, 'RETIRO PARA ENTREGA A TRABAJADORES', '36', '2018-11-06 11:37:57', 'admin', '-', '2018-11-06 11:37:57', '-', '-', 1),
(229, 21, 22, 'RETIRO POR CONVENIO COLECTIVO', '37', '2018-11-06 11:38:04', 'admin', '-', '2018-11-06 11:38:04', '-', '-', 1),
(230, 22, 22, 'RETIRO POR SUSTITUCION DE BIEN SINIESTRADO', '38', '2018-11-06 11:38:11', 'admin', '-', '2018-11-06 11:38:11', '-', '-', 1),
(231, 18, 18, 'OTROS ', '99', '2018-11-06 11:38:30', 'admin', '-', '2018-11-06 11:38:30', '-', '-', 1),
(232, 22, NULL, 'Tipo de Operación Salida (Tabla 12 SUNAT)', 'T12S', '2018-11-08 17:04:08', 'admin', '-', '2018-11-08 17:04:21', 'admin', '-', 1),
(233, 16, 22, 'AJUSTE POR DIFERENCIA DE INVENTARIO', '28', '2018-11-06 11:37:03', 'admin', '-', '2018-11-06 11:37:03', '-', '-', 1),
(234, 22, 22, 'OTROS ', '99', '2018-11-06 11:38:30', 'admin', '-', '2018-11-06 11:38:30', '-', '-', 1),
(235, 4, 8, '004 - Crédito 60 días', 'F4', '2018-12-05 12:01:42', 'admin', '-', '2018-12-05 12:01:55', 'admin', '-', 1),
(236, 5, 8, '005- Crédito 120 días', 'F5', '2018-12-05 17:55:39', 'admin', '-', '2018-12-05 17:55:39', '-', '-', 1),
(237, 6, 8, '006-Crédito 45 días', 'f6', '2018-12-11 11:55:44', 'admin', '-', '2018-12-11 11:55:44', '-', '-', 1),
(238, 63, 3, 'BIDÓN', 'BI', '2018-12-11 13:07:21', 'admin', '-', '2018-12-11 13:07:21', '-', '-', 1),
(239, 19, 18, 'LLANTAS REENCAUCHADAS', '100', '2018-12-17 16:51:35', 'admin', '-', '2018-12-17 16:57:32', 'admin', '-', 1),
(240, 4, 19, 'CAMIONETA', 'CA', '2018-12-17 18:21:29', 'admin', '-', '2018-12-17 18:21:29', '-', '-', 1),
(241, 7, 8, '007- CREDITO 30 DIAS', 'F7', '2018-12-18 12:22:16', 'admin', '-', '2018-12-18 12:22:31', 'admin', '-', 1),
(242, 64, 3, 'PLANCHA', 'PLA', '2019-01-04 19:04:28', 'admin', '-', '2019-01-04 19:04:28', '-', '-', 1),
(243, 8, 8, '008.-Letra a 45 dias', 'f8', '2019-01-14 12:56:33', 'angelica_chuquilin', '-', '2019-01-14 12:56:51', 'angelica_chuquilin', '-', 1),
(244, 65, 3, 'CENTIMETROS', 'CM', '2019-03-27 11:21:30', 'angelica_chuquilin', '-', '2019-03-27 11:21:30', '-', '-', 1),
(245, 5, 19, 'TALLER', 'TA', '2019-04-27 10:57:00', 'angelica_chuquilin', '-', '2019-04-27 10:57:00', '-', '-', 1),
(246, 9, 8, '009.-LETRA  60-90 DIAS', '09', '2019-06-10 10:02:30', 'angelica_chuquilin', '-', '2019-06-10 10:02:30', '-', '-', 1),
(247, 10, 8, '010.-LETRA 90 DIAS', 'F10', '2019-06-21 10:41:41', 'angelica_chuquilin', '-', '2019-06-21 10:41:41', '-', '-', 1),
(248, 6, 19, 'OFICINA', 'OF', '2019-07-02 17:24:47', 'angelica_chuquilin', '-', '2019-07-02 17:24:47', '-', '-', 1),
(249, 11, 8, '11.- LETRA 60 DIAS', 'F11', '2019-08-02 11:14:49', 'angelica_chuquilin', '-', '2019-08-02 11:14:49', '-', '-', 1),
(250, 12, 8, '012-LETRA 120 DIAS', 'F012', '2019-10-01 11:58:09', 'angelica_chuquilin', '-', '2019-10-01 11:59:25', 'angelica_chuquilin', '-', 1),
(251, 4, 21, 'ALMACEN', 'ALM', '2019-12-02 10:53:29', 'julissa_vargas', '-', '2019-12-02 10:53:29', '-', '-', 1),
(252, 23, NULL, 'Tipo de Documento', 'TD', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(253, 1, 23, 'ORDEN DE COMPRA', '01', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(254, 2, 23, 'ORDEN DE TRABAJO DE MANTENIMIENTO', '02', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(255, 3, 23, 'ORDEN DE SERVICIO', '03', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(256, 4, 23, 'NOTA DE ALMACEN', '04', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(257, 5, 23, 'OTROS', '99', '2020-01-04 09:36:02', 'admin', '-', NULL, NULL, NULL, 1),
(258, 24, NULL, 'Tipo de frecuencia', 'TF', '2020-04-09 12:38:14', 'admin', '-', '2020-04-09 12:38:14', '-', '-', 1),
(259, 1, 24, 'Días', 'dd', '2020-04-09 12:39:36', 'admin', '-', '2020-04-09 12:39:36', '-', '-', 1),
(260, 2, 24, 'Semanas', 'ss', '2020-04-09 12:39:53', 'admin', '-', '2020-04-09 12:39:53', '-', '-', 1),
(261, 3, 24, 'Meses', 'mm', '2020-04-09 12:40:00', 'admin', '-', '2020-04-09 12:40:00', '-', '-', 1),
(262, 4, 24, 'Año', 'aa', '2020-04-09 12:40:08', 'admin', '-', '2020-04-09 12:40:08', '-', '-', 1),
(263, 25, NULL, 'Estado de Documento de Venta', 'EDV', '2020-04-10 16:38:40', 'admin', '-', '2020-04-10 16:38:40', '-', '-', 1),
(264, 1, 25, 'Abierto', 'A', '2020-04-10 16:39:28', 'admin', '-', '2020-04-10 16:39:28', '-', '-', 1),
(265, 2, 25, 'Pendiente de pago', 'PP', '2020-04-10 16:39:42', 'admin', '-', '2020-04-10 16:39:42', '-', '-', 1),
(266, 3, 25, 'Pagado', 'P', '2020-04-10 16:39:52', 'admin', '-', '2020-04-10 16:39:52', '-', '-', 1),
(267, 4, 25, 'Anulado', 'AN', '2020-04-10 16:40:13', 'admin', '-', '2020-04-10 16:40:13', '-', '-', 1),
(268, 26, NULL, 'Medio de pago', 'MP', '2020-04-12 01:29:23', 'admin', '-', '2020-04-12 01:29:23', '-', '-', 1),
(269, 1, 26, 'Efectivo', 'Efvo', '2020-04-12 01:30:49', 'admin', '-', '2020-04-12 01:30:49', '-', '-', 1),
(270, 2, 26, 'Tarjeta', 'Tjt', '2020-04-12 01:31:23', 'admin', '-', '2020-04-12 01:31:23', '-', '-', 1),
(271, 27, NULL, 'Canal', 'C', '2020-04-12 01:32:18', 'admin', '-', '2020-04-12 01:32:18', '-', '-', 1),
(272, 1, 27, 'Tienda', 'T', '2020-04-12 01:32:33', 'admin', '-', '2020-04-12 01:32:33', '-', '-', 1),
(273, 2, 27, 'Facebook', 'FB', '2020-04-12 01:32:44', 'admin', '-', '2020-04-12 01:32:44', '-', '-', 1),
(274, 3, 27, 'Instagram', 'IG', '2020-04-12 01:32:55', 'admin', '-', '2020-04-12 01:32:55', '-', '-', 1),
(275, 28, NULL, 'Tipo de Cliente', 'TC', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(276, 1, 28, 'Persona', 'P', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(277, 2, 28, 'Empresa', 'E', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(278, 29, NULL, 'Tipo de Documento de Identidad', 'TDI', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(279, 1, 29, 'OTROS', '0', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(280, 2, 29, 'DOCUMENTO NACIONAL DE IDENTIDAD', '1', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(281, 3, 29, 'CARNET DE EXTRANJERÍA', '4', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(282, 4, 29, 'REGISTRO ÚNICO DE CONTRIBUYENTES', '6', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(283, 5, 29, 'PASAPORTE', '7', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(284, 6, 29, 'CÉDULA DIPLOMÁTICA DE IDENTIDAD', 'A', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(285, 30, NULL, 'Categoría de Cliente', 'TC', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(286, 1, 30, 'Categoría 01', 'C01', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1),
(287, 2, 30, 'Categoría 02', 'C02', '2020-04-13 02:18:33', 'admin', '-', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `multitabla_load`
--

CREATE TABLE `multitabla_load` (
  `id` int(11) NOT NULL,
  `codigo` varchar(10) NOT NULL,
  `nombre` varchar(150) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `multitabla_load`
--

INSERT INTO `multitabla_load` (`id`, `codigo`, `nombre`) VALUES
(1, '4A', 'BOBINAS'),
(2, 'BJ', 'BALDE'),
(3, 'BLL', 'BARRILES'),
(4, 'BG', 'BOLSA'),
(5, 'BO', 'BOTELLAS'),
(6, 'BX', 'CAJA'),
(7, 'CT', 'CARTONES'),
(8, 'CMK', 'CENTIMETRO CUADRADO'),
(9, 'CMQ', 'CENTIMETRO CUBICO'),
(10, 'CMT', 'CENTIMETRO LINEAL'),
(11, 'CEN', 'CIENTO DE UNIDADES'),
(12, 'CY', 'CILINDRO'),
(13, 'CJ', 'CONOS'),
(14, 'DZN', 'DOCENA'),
(15, 'DZP', 'DOCENA POR 10**6'),
(16, 'BE', 'FARDO'),
(17, 'GLI', 'GALON INGLES (4,545956L)'),
(18, 'GRM', 'GRAMO'),
(19, 'GRO', 'GRUESA'),
(20, 'HLT', 'HECTOLITRO'),
(21, 'LEF', 'HOJA'),
(22, 'SET', 'JUEGO'),
(23, 'KGM', 'KILOGRAMO'),
(24, 'KTM', 'KILOMETRO'),
(25, 'KWH', 'KILOVATIO HORA'),
(26, 'KT', 'KIT'),
(27, 'CA', 'LATAS'),
(28, 'LBR', 'LIBRAS'),
(29, 'LTR', 'LITRO'),
(30, 'MWH', 'MEGAWATT HORA'),
(31, 'MTR', 'METRO'),
(32, 'MTK', 'METRO CUADRADO'),
(33, 'MTQ', 'METRO CUBICO'),
(34, 'MGM', 'MILIGRAMOS'),
(35, 'MLT', 'MILILITRO'),
(36, 'MMT', 'MILIMETRO'),
(37, 'MMK', 'MILIMETRO CUADRADO'),
(38, 'MMQ', 'MILIMETRO CUBICO'),
(39, 'MLL', 'MILLARES'),
(40, 'UM', 'MILLON DE UNIDADES'),
(41, 'ONZ', 'ONZAS'),
(42, 'PF', 'PALETAS'),
(43, 'PK', 'PAQUETE'),
(44, 'PR', 'PAR'),
(45, 'FOT', 'PIES'),
(46, 'FTK', 'PIES CUADRADOS'),
(47, 'FTQ', 'PIES CUBICOS'),
(48, 'C62', 'PIEZAS'),
(49, 'PG', 'PLACAS'),
(50, 'ST', 'PLIEGO'),
(51, 'INH', 'PULGADAS'),
(52, 'RM', 'RESMA'),
(53, 'DR', 'TAMBOR'),
(54, 'STN', 'TONELADA CORTA'),
(55, 'LTN', 'TONELADA LARGA'),
(56, 'TNE', 'TONELADAS'),
(57, 'TU', 'TUBOS'),
(58, 'NIU', 'UNIDAD (BIENES)'),
(59, 'ZZ', 'UNIDAD (SERVICIOS)'),
(60, 'GLL', 'US GALON (3,7843 L)'),
(61, 'YRD', 'YARDA'),
(62, 'YDK', 'YARDA CUADRADA');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `nota_almacen`
--

CREATE TABLE `nota_almacen` (
  `idNotaAlmacen` int(11) NOT NULL,
  `idAlmacen` int(11) NOT NULL,
  `idCompra` int(11) DEFAULT NULL,
  `idOrdenMantenimiento` int(11) DEFAULT NULL,
  `idOrdenServicio` int(11) DEFAULT NULL,
  `idTrabajador` int(11) DEFAULT NULL,
  `idUnidad` int(11) DEFAULT NULL,
  `idDestino` int(11) DEFAULT NULL,
  `correlativo` varchar(50) DEFAULT NULL,
  `tipoDocumento` char(5) DEFAULT NULL,
  `serieDocumento` varchar(50) DEFAULT NULL,
  `numeroDocumento` varchar(50) DEFAULT NULL,
  `tipoOperacion` char(5) DEFAULT NULL,
  `tasaCambio` decimal(18,3) DEFAULT NULL,
  `subTotal` decimal(18,2) NOT NULL,
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEmision` datetime DEFAULT NULL,
  `observaciones` varchar(500) DEFAULT NULL,
  `motivo` int(11) DEFAULT NULL,
  `tipoNota` char(5) NOT NULL,
  `estado` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL DEFAULT '1',
  `fechaEmisionReal` datetime DEFAULT NULL,
  `anulado` bit(1) DEFAULT b'0',
  `idOrdenCompra` int(11) DEFAULT NULL,
  `idTipoDocumento` char(5) DEFAULT NULL,
  `fechaContable` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Volcado de datos para la tabla `nota_almacen`
--

INSERT INTO `nota_almacen` (`idNotaAlmacen`, `idAlmacen`, `idCompra`, `idOrdenMantenimiento`, `idOrdenServicio`, `idTrabajador`, `idUnidad`, `idDestino`, `correlativo`, `tipoDocumento`, `serieDocumento`, `numeroDocumento`, `tipoOperacion`, `tasaCambio`, `subTotal`, `igv`, `igv2`, `total`, `fechaEmision`, `observaciones`, `motivo`, `tipoNota`, `estado`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `fechaEmisionReal`, `anulado`, `idOrdenCompra`, `idTipoDocumento`, `fechaContable`) VALUES
(2975, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '', '', '02', NULL, '20.00', '18.00', '3.60', '23.60', '2020-02-25 02:28:55', '', NULL, 'E', 'C', '2020-02-25 02:28:55', 'admin', '-', NULL, NULL, NULL, 1, NULL, b'0', 1480, '01', '2020-02-25 02:28:55'),
(2976, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '', '', '02', NULL, '20.00', '18.00', '3.60', '23.60', '2020-02-25 02:29:34', '', NULL, 'E', 'C', '2020-02-25 02:29:34', 'admin', '-', NULL, NULL, NULL, 1, NULL, b'0', 1480, '01', '2020-02-25 02:29:34'),
(2977, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '01', '', '', '02', NULL, '20.00', '18.00', '3.60', '23.60', '2020-02-25 02:29:59', '', NULL, 'E', 'C', '2020-02-25 02:29:59', 'admin', '-', NULL, NULL, NULL, 1, NULL, b'0', 1480, '01', '2020-02-25 02:29:59'),
(2978, 1, NULL, NULL, NULL, NULL, NULL, NULL, '000001', '01', '4545', '45', '02', NULL, '2925.00', '18.00', '526.50', '3451.50', '2020-02-25 02:46:37', '', NULL, 'E', 'C', '2020-02-25 02:46:37', 'admin', '-', NULL, NULL, NULL, 1, NULL, b'0', 1481, '01', '2020-02-25 02:46:37');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `oficina`
--

CREATE TABLE `oficina` (
  `idOficina` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `direccion` varchar(400) NOT NULL,
  `principal` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `oficina`
--

INSERT INTO `oficina` (`idOficina`, `nombre`, `direccion`, `principal`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 'Oficina Principal', 'Av. Juan Pablo II 451 Urb. San Andrés - Trujillo', 1, '2018-10-05 10:20:07', 'admin', '-', '2020-02-25 01:20:16', 'admin', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orden_compra`
--

CREATE TABLE `orden_compra` (
  `idOrdenCompra` int(11) NOT NULL,
  `idCotizacion` int(11) DEFAULT NULL,
  `idOrdenMantenimiento` int(11) DEFAULT NULL,
  `idOrdenServicio` int(11) DEFAULT NULL,
  `idProveedor` int(11) NOT NULL,
  `nombreProveedor` varchar(300) NOT NULL,
  `rucProveedor` char(11) NOT NULL,
  `direccionProveedor` varchar(250) NOT NULL,
  `telefonoProveedor` varchar(12) NOT NULL,
  `emailProveedor` varchar(50) NOT NULL,
  `correlativo` char(8) NOT NULL,
  `codCotizacion` varchar(50) NOT NULL,
  `serieDocumento` varchar(50) DEFAULT NULL,
  `numeroDocumento` varchar(50) DEFAULT NULL,
  `tipoDocumento` char(5) NOT NULL,
  `formaPago` char(5) NOT NULL,
  `idOficina` int(11) NOT NULL,
  `lugarAtencion` varchar(400) NOT NULL,
  `idTipoMoneda` int(11) NOT NULL DEFAULT '1',
  `tasaCambio` decimal(18,3) NOT NULL DEFAULT '1.000',
  `subTotal` decimal(18,2) NOT NULL,
  `descuento` decimal(18,2) NOT NULL DEFAULT '0.00',
  `igv` decimal(18,2) NOT NULL,
  `igv2` decimal(18,2) NOT NULL,
  `total` decimal(18,2) NOT NULL,
  `fechaEnvio` datetime NOT NULL,
  `fechaEntrega` datetime NOT NULL,
  `estadoEmision` char(5) NOT NULL,
  `estadoRecepcion` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL,
  `idDestino` int(11) DEFAULT NULL,
  `idUnidad` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `orden_compra`
--

INSERT INTO `orden_compra` (`idOrdenCompra`, `idCotizacion`, `idOrdenMantenimiento`, `idOrdenServicio`, `idProveedor`, `nombreProveedor`, `rucProveedor`, `direccionProveedor`, `telefonoProveedor`, `emailProveedor`, `correlativo`, `codCotizacion`, `serieDocumento`, `numeroDocumento`, `tipoDocumento`, `formaPago`, `idOficina`, `lugarAtencion`, `idTipoMoneda`, `tasaCambio`, `subTotal`, `descuento`, `igv`, `igv2`, `total`, `fechaEnvio`, `fechaEntrega`, `estadoEmision`, `estadoRecepcion`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `idDestino`, `idUnidad`) VALUES
(1473, NULL, NULL, NULL, 0, '', '', '', '', '', '', '', NULL, NULL, '', '', 0, '', 1, '1.000', '25.00', '5.00', '18.00', '3.60', '23.60', '2020-02-25 00:27:30', '2020-02-25 00:27:30', 'A', 'SN', '2020-02-25 00:27:30', 'innovateperu', '-', NULL, NULL, NULL, 1, NULL, NULL),
(1480, NULL, NULL, NULL, 190, 'aaaaaaaaaaaa', '54465454645', 'dsa', '789', 'dsadsa@gmail.com', '000001', '', '', '', '01', 'F1', 1, 'Av. Juan Pablo II 451 Urb. San Andrés - Trujillo', 1, '1.000', '20.00', '0.00', '18.00', '3.60', '23.60', '2020-02-25 00:00:00', '2020-02-25 00:00:00', 'A', 'EN', '2020-02-25 01:26:20', 'admin', '-', '2020-02-25 02:29:59', 'admin', '-', 1, NULL, NULL),
(1481, NULL, NULL, NULL, 190, 'aaaaaaaaaaaa', '54465454645', 'dsa', '789', 'dsadsa@gmail.com', '000002', '', '4545', '45', '01', 'F1', 1, 'Av. Juan Pablo II 451 Urb. San Andrés - Trujillo', 1, '1.000', '2925.00', '0.00', '18.00', '526.50', '3451.50', '2020-02-25 00:00:00', '2020-02-25 00:00:00', 'A', 'EN', '2020-02-25 02:46:20', 'admin', '-', '2020-02-25 02:46:37', 'admin', '-', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orden_mantenimiento`
--

CREATE TABLE `orden_mantenimiento` (
  `idOrdenMantenimiento` int(11) NOT NULL,
  `idTrabajador` int(11) DEFAULT NULL,
  `idUnidad` int(11) DEFAULT NULL,
  `correlativo` char(8) DEFAULT NULL,
  `kilometraje` decimal(18,2) DEFAULT NULL,
  `componente` varchar(100) DEFAULT NULL,
  `descripcion` varchar(500) DEFAULT NULL,
  `observaciones` varchar(300) DEFAULT NULL,
  `fechaEmision` datetime DEFAULT NULL,
  `fechaInicio` datetime DEFAULT NULL,
  `fechaFin` datetime DEFAULT NULL,
  `estado` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orden_servicio`
--

CREATE TABLE `orden_servicio` (
  `idOrdenServicio` int(11) NOT NULL,
  `idOrdenMantenimiento` varchar(45) DEFAULT NULL,
  `idProveedor` int(11) DEFAULT NULL,
  `idUnidad` int(11) DEFAULT NULL,
  `correlativo` char(8) DEFAULT NULL,
  `kilometraje` decimal(18,2) DEFAULT NULL,
  `tipoDocumento` char(5) NOT NULL,
  `serieDocumento` varchar(50) NOT NULL,
  `numeroDocumento` varchar(50) NOT NULL,
  `descripcion` varchar(500) DEFAULT NULL,
  `observaciones` varchar(500) DEFAULT NULL,
  `fechaEmision` datetime DEFAULT NULL,
  `fechaInicio` datetime DEFAULT NULL,
  `fechaFin` datetime DEFAULT NULL,
  `estado` char(2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `idTipoMoneda` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pais`
--

CREATE TABLE `pais` (
  `idPais` varchar(2) NOT NULL,
  `pais` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `pais`
--

INSERT INTO `pais` (`idPais`, `pais`) VALUES
('AU', 'Australia'),
('CN', 'China'),
('JP', 'Japan'),
('TH', 'Thailand'),
('IN', 'India'),
('MY', 'Malaysia'),
('KR', 'Kore'),
('HK', 'Hong Kong'),
('TW', 'Taiwan'),
('PH', 'Philippines'),
('VN', 'Vietnam'),
('FR', 'France'),
('EU', 'Europe'),
('DE', 'Germany'),
('SE', 'Sweden'),
('IT', 'Italy'),
('GR', 'Greece'),
('ES', 'Spain'),
('AT', 'Austria'),
('GB', 'United Kingdom'),
('NL', 'Netherlands'),
('BE', 'Belgium'),
('CH', 'Switzerland'),
('AE', 'United Arab Emirates'),
('IL', 'Israel'),
('UA', 'Ukraine'),
('RU', 'Russian Federation'),
('KZ', 'Kazakhstan'),
('PT', 'Portugal'),
('SA', 'Saudi Arabia'),
('DK', 'Denmark'),
('IR', 'Ira'),
('NO', 'Norway'),
('US', 'United States'),
('MX', 'Mexico'),
('CA', 'Canada'),
('A1', 'Anonymous Proxy'),
('SY', 'Syrian Arab Republic'),
('CY', 'Cyprus'),
('CZ', 'Czech Republic'),
('IQ', 'Iraq'),
('TR', 'Turkey'),
('RO', 'Romania'),
('LB', 'Lebanon'),
('HU', 'Hungary'),
('GE', 'Georgia'),
('BR', 'Brazil'),
('AZ', 'Azerbaijan'),
('A2', 'Satellite Provider'),
('PS', 'Palestinian Territory'),
('LT', 'Lithuania'),
('OM', 'Oman'),
('SK', 'Slovakia'),
('RS', 'Serbia'),
('FI', 'Finland'),
('IS', 'Iceland'),
('BG', 'Bulgaria'),
('SI', 'Slovenia'),
('MD', 'Moldov'),
('MK', 'Macedonia'),
('LI', 'Liechtenstein'),
('JE', 'Jersey'),
('PL', 'Poland'),
('HR', 'Croatia'),
('BA', 'Bosnia and Herzegovina'),
('EE', 'Estonia'),
('LV', 'Latvia'),
('JO', 'Jordan'),
('KG', 'Kyrgyzstan'),
('RE', 'Reunion'),
('IE', 'Ireland'),
('LY', 'Libya'),
('LU', 'Luxembourg'),
('AM', 'Armenia'),
('VG', 'Virgin Island'),
('YE', 'Yemen'),
('BY', 'Belarus'),
('GI', 'Gibraltar'),
('MQ', 'Martinique'),
('PA', 'Panama'),
('DO', 'Dominican Republic'),
('GU', 'Guam'),
('PR', 'Puerto Rico'),
('VI', 'Virgin Island'),
('MN', 'Mongolia'),
('NZ', 'New Zealand'),
('SG', 'Singapore'),
('ID', 'Indonesia'),
('NP', 'Nepal'),
('PG', 'Papua New Guinea'),
('PK', 'Pakistan'),
('AP', 'Asia/Pacific Region'),
('BS', 'Bahamas'),
('LC', 'Saint Lucia'),
('AR', 'Argentina'),
('BD', 'Bangladesh'),
('TK', 'Tokelau'),
('KH', 'Cambodia'),
('MO', 'Macau'),
('MV', 'Maldives'),
('AF', 'Afghanistan'),
('NC', 'New Caledonia'),
('FJ', 'Fiji'),
('WF', 'Wallis and Futuna'),
('QA', 'Qatar'),
('AL', 'Albania'),
('BZ', 'Belize'),
('UZ', 'Uzbekistan'),
('KW', 'Kuwait'),
('ME', 'Montenegro'),
('PE', 'Perú'),
('BM', 'Bermuda'),
('CW', 'Curacao'),
('CO', 'Colombia'),
('VE', 'Venezuela'),
('CL', 'Chile'),
('EC', 'Ecuador'),
('ZA', 'South Africa'),
('IM', 'Isle of Man'),
('BO', 'Bolivia'),
('GG', 'Guernsey'),
('MT', 'Malta'),
('TJ', 'Tajikistan'),
('SC', 'Seychelles'),
('BH', 'Bahrain'),
('EG', 'Egypt'),
('ZW', 'Zimbabwe'),
('LR', 'Liberia'),
('KE', 'Kenya'),
('GH', 'Ghana'),
('NG', 'Nigeria'),
('TZ', 'Tanzani'),
('ZM', 'Zambia'),
('MG', 'Madagascar'),
('AO', 'Angola'),
('NA', 'Namibia'),
('CI', 'Cote D\'Ivoire'),
('SD', 'Sudan'),
('CM', 'Cameroon'),
('MW', 'Malawi'),
('GA', 'Gabon'),
('ML', 'Mali'),
('BJ', 'Benin'),
('TD', 'Chad'),
('BW', 'Botswana'),
('CV', 'Cape Verde'),
('RW', 'Rwanda'),
('CG', 'Congo'),
('UG', 'Uganda'),
('MZ', 'Mozambique'),
('GM', 'Gambia'),
('LS', 'Lesotho'),
('MU', 'Mauritius'),
('MA', 'Morocco'),
('DZ', 'Algeria'),
('GN', 'Guinea'),
('CD', 'Cong'),
('SZ', 'Swaziland'),
('BF', 'Burkina Faso'),
('SL', 'Sierra Leone'),
('SO', 'Somalia'),
('NE', 'Niger'),
('CF', 'Central African Republic'),
('TG', 'Togo'),
('BI', 'Burundi'),
('GQ', 'Equatorial Guinea'),
('SS', 'South Sudan'),
('SN', 'Senegal'),
('MR', 'Mauritania'),
('DJ', 'Djibouti'),
('KM', 'Comoros'),
('IO', 'British Indian Ocean Territory'),
('TN', 'Tunisia'),
('GL', 'Greenland'),
('VA', 'Holy See (Vatican City State)'),
('CR', 'Costa Rica'),
('KY', 'Cayman Islands'),
('JM', 'Jamaica'),
('GT', 'Guatemala'),
('MH', 'Marshall Islands'),
('AQ', 'Antarctica'),
('BB', 'Barbados'),
('AW', 'Aruba'),
('MC', 'Monaco'),
('AI', 'Anguilla'),
('KN', 'Saint Kitts and Nevis'),
('GD', 'Grenada'),
('PY', 'Paraguay'),
('MS', 'Montserrat'),
('TC', 'Turks and Caicos Islands'),
('AG', 'Antigua and Barbuda'),
('TV', 'Tuvalu'),
('PF', 'French Polynesia'),
('SB', 'Solomon Islands'),
('VU', 'Vanuatu'),
('ER', 'Eritrea'),
('TT', 'Trinidad and Tobago'),
('AD', 'Andorra'),
('HT', 'Haiti'),
('SH', 'Saint Helena'),
('FM', 'Micronesi'),
('SV', 'El Salvador'),
('HN', 'Honduras'),
('UY', 'Uruguay'),
('LK', 'Sri Lanka'),
('EH', 'Western Sahara'),
('CX', 'Christmas Island'),
('WS', 'Samoa'),
('SR', 'Suriname'),
('CK', 'Cook Islands'),
('KI', 'Kiribati'),
('NU', 'Niue'),
('TO', 'Tonga'),
('TF', 'French Southern Territories'),
('YT', 'Mayotte'),
('NF', 'Norfolk Island'),
('BN', 'Brunei Darussalam'),
('TM', 'Turkmenistan'),
('PN', 'Pitcairn Islands'),
('SM', 'San Marino'),
('AX', 'Aland Islands'),
('FO', 'Faroe Islands'),
('SJ', 'Svalbard and Jan Mayen'),
('CC', 'Cocos (Keeling) Islands'),
('NR', 'Nauru'),
('GS', 'South Georgia and the South Sandwich Islands'),
('UM', 'United States Minor Outlying Islands'),
('GW', 'Guinea-Bissau'),
('PW', 'Palau'),
('AS', 'American Samoa'),
('BT', 'Bhutan'),
('GF', 'French Guiana'),
('GP', 'Guadeloupe'),
('MF', 'Saint Martin'),
('VC', 'Saint Vincent and the Grenadines'),
('PM', 'Saint Pierre and Miquelon'),
('BL', 'Saint Barthelemy'),
('DM', 'Dominica'),
('ST', 'Sao Tome and Principe'),
('KP', 'Kore'),
('FK', 'Falkland Islands (Malvinas)'),
('MP', 'Northern Mariana Islands'),
('TL', 'Timor-Leste'),
('BQ', 'Bonair'),
('MM', 'Myanmar'),
('NI', 'Nicaragua'),
('SX', 'Sint Maarten (Dutch part)'),
('GY', 'Guyana'),
('LA', 'Lao People\'s Democratic Republic'),
('CU', 'Cuba'),
('ET', 'Ethiopia');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `periodo`
--

CREATE TABLE `periodo` (
  `idPeriodo` int(11) NOT NULL,
  `periodo` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `periodo`
--

INSERT INTO `periodo` (`idPeriodo`, `periodo`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 2010, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(2, 2011, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(3, 2012, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(4, 2013, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(5, 2014, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(6, 2015, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(7, 2016, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(8, 2017, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(9, 2018, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(10, 2019, '2017-04-15 11:06:35', '-', '-', '2017-04-15 11:06:35', '-', '-', 1),
(11, 2020, '2020-01-02 11:29:54', 'ADMIN', '-', '2020-01-02 11:29:54', 'ADMIN', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `persona`
--

CREATE TABLE `persona` (
  `idPersona` int(11) NOT NULL,
  `idUbigeo` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `apePaterno` varchar(50) NOT NULL,
  `apeMaterno` varchar(50) NOT NULL,
  `dni` char(8) NOT NULL,
  `telefono` varchar(12) NOT NULL,
  `email` varchar(100) NOT NULL,
  `direccion` varchar(250) NOT NULL,
  `sexo` char(1) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` bit(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `persona`
--

INSERT INTO `persona` (`idPersona`, `idUbigeo`, `nombre`, `apePaterno`, `apeMaterno`, `dni`, `telefono`, `email`, `direccion`, `sexo`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, 'Fabio', 'Peralta', 'Medina', '74658829', '044211371', 'fabio.peralta20@gmail.com', 'Av. 9 de Octubre #644', 'M', '2017-04-15 11:06:35', 'admin', '', '2017-04-15 11:06:35', '', '', b'1'),
(2, 1, 'Anghello', 'Anghello', 'Anghello', '74658812', '044211371', 'Anghello@gmail.com', 'av. larco', 'M', '2017-05-08 17:54:39', 'admin', '-', '2017-05-08 20:00:40', 'admin', '-', b'1'),
(3, 1, 'Jorgen', 'Anticona', 'Valdiviezo', '12345678', '044123456', 'janticona@eta.com.pe', 'Av. Larco', 'M', '2017-08-06 09:29:16', 'admin', '-', '2017-08-06 09:29:31', 'admin', '-', b'1');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `plan_contable`
--

CREATE TABLE `plan_contable` (
  `codigo` varchar(50) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `cod_padre` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `presentacion`
--

CREATE TABLE `presentacion` (
  `idPresentacion` int(11) NOT NULL,
  `idProducto` int(11) NOT NULL,
  `nombre` varchar(300) NOT NULL,
  `cantidad` decimal(10,2) NOT NULL,
  `idUnidadMedida` char(5) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `idClase` int(11) DEFAULT NULL,
  `anulado` bit(1) DEFAULT b'0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Volcado de datos para la tabla `presentacion`
--

INSERT INTO `presentacion` (`idPresentacion`, `idProducto`, `nombre`, `cantidad`, `idUnidadMedida`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `idClase`, `anulado`) VALUES
(1687, 1517, '-', '1.00', '4A', '2020-02-23 12:34:59', 'admin', '-', '2020-02-23 12:34:59', '-', '-', 1, NULL, b'0'),
(1688, 1517, 'dsadsa', '2.00', '4A', '2020-02-23 12:35:00', 'admin', '-', '2020-02-23 12:35:00', '-', '-', 1, NULL, b'0'),
(1689, 1518, '-', '1.00', 'BLL', '2020-04-18 02:03:41', 'admin', '-', '2020-04-18 02:03:41', '-', '-', 1, NULL, b'0'),
(1690, 1518, 'fdffddfdfdf', '2.00', 'BLL', '2020-04-18 02:03:41', 'admin', '-', '2020-04-18 02:03:41', '-', '-', 1, NULL, b'0'),
(1691, 1519, '-', '1.00', 'DZN', '2020-04-18 02:04:12', 'admin', '-', '2020-04-18 02:04:12', '-', '-', 1, NULL, b'0'),
(1692, 1519, 'wwwww', '4.00', 'DZN', '2020-04-18 02:04:12', 'admin', '-', '2020-04-18 02:04:12', '-', '-', 1, NULL, b'0'),
(1693, 1520, '-', '1.00', 'DZP', '2020-04-18 02:04:38', 'admin', '-', '2020-04-18 02:04:38', '-', '-', 1, NULL, b'0'),
(1694, 1520, '1', '5.00', 'DZP', '2020-04-18 02:04:38', 'admin', '-', '2020-04-18 02:04:38', '-', '-', 1, NULL, b'0'),
(1695, 1521, '-', '1.00', 'GLI', '2020-04-18 02:05:00', 'admin', '-', '2020-04-18 02:05:00', '-', '-', 1, NULL, b'0');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `producto`
--

CREATE TABLE `producto` (
  `idProducto` int(11) NOT NULL,
  `idClase` int(11) NOT NULL,
  `codigo` varchar(10) CHARACTER SET utf8 NOT NULL,
  `codigoContable` varchar(8) CHARACTER SET utf8 NOT NULL,
  `nombre` varchar(300) CHARACTER SET utf8 NOT NULL,
  `marca` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `modelo` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `medida` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `cod_fab` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `stockMin` decimal(10,2) NOT NULL,
  `stockActual` decimal(10,2) NOT NULL,
  `unidad_medida` char(5) CHARACTER SET utf8 DEFAULT NULL,
  `tipo_existencia` char(5) CHARACTER SET utf8 DEFAULT NULL,
  `valor_unitario` decimal(18,6) DEFAULT NULL,
  `precio_unitario` decimal(18,6) DEFAULT NULL,
  `igv_unitario` decimal(18,6) DEFAULT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) CHARACTER SET utf8 NOT NULL,
  `registro_pc_add` varchar(50) CHARACTER SET utf8 NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) CHARACTER SET utf8 NOT NULL,
  `registro_pc_update` varchar(50) CHARACTER SET utf8 NOT NULL,
  `activo` int(11) NOT NULL,
  `anulado` bit(1) DEFAULT b'0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_spanish_ci ROW_FORMAT=COMPACT;

--
-- Volcado de datos para la tabla `producto`
--

INSERT INTO `producto` (`idProducto`, `idClase`, `codigo`, `codigoContable`, `nombre`, `marca`, `modelo`, `medida`, `cod_fab`, `stockMin`, `stockActual`, `unidad_medida`, `tipo_existencia`, `valor_unitario`, `precio_unitario`, `igv_unitario`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`, `anulado`) VALUES
(1517, 1, '000001', '2510101', 'producto prueba', 'dasdsa', 'ddsadsa', 'dsadsa', 'dsad', '456.00', '10.00', '4A', '01', '45.528800', '53.723984', '8.195184', '2020-02-23 12:34:59', 'admin', '-', '2020-02-23 12:35:10', 'admin', '-', 1, b'0'),
(1518, 5, '000001', '2520301', 'Proucto prueba A', 'Marca oo', 'Modelo kkk', 'sdasdas', '23asdas', '200.00', '15.00', 'BLL', '02', '19.000000', '22.420000', '3.420000', '2020-04-18 02:03:40', 'admin', '-', '2020-04-18 02:03:40', '-', '-', 1, b'0'),
(1519, 5, '000002', '2520302', 'rrrrrwrwwr', 'wweeweee', 'rrrrre', 'rererreree', 'eeeer', '33.00', '30.00', 'DZN', '03', '15.000000', '17.700000', '2.700000', '2020-04-18 02:04:12', 'admin', '-', '2020-04-18 02:04:12', '-', '-', 1, b'0'),
(1520, 2, '000001', '2510201', 'trtertert', 'trrrerere', 'reererreer', 'trttr', 'rerer', '34.00', '0.00', 'DZP', '05', '26.000000', '30.680000', '4.680000', '2020-04-18 02:04:38', 'admin', '-', '2020-04-18 02:04:38', '-', '-', 1, b'0'),
(1521, 24, '000001', '2531101', 'utrewy', 'iuytrew', 'jghfbvdcsx', 'gfbvdsxa', 'fvdcsxa', '55.00', '20.00', 'GLI', '02', '85.000000', '100.300000', '15.300000', '2020-04-18 02:05:00', 'admin', '-', '2020-04-18 02:05:00', '-', '-', 1, b'0');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `producto_load`
--

CREATE TABLE `producto_load` (
  `idCategoria` varchar(45) DEFAULT NULL,
  `idSubcategoria` varchar(45) DEFAULT NULL,
  `idClase` varchar(45) DEFAULT NULL,
  `codigoProducto` varchar(45) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `medida` varchar(45) DEFAULT NULL,
  `cod_fab` varchar(45) DEFAULT NULL,
  `modelo` varchar(45) DEFAULT NULL,
  `marca` varchar(45) DEFAULT NULL,
  `familia` varchar(45) DEFAULT NULL,
  `unidad` varchar(45) DEFAULT NULL,
  `codigo` varchar(45) DEFAULT NULL,
  `stock_min` decimal(10,2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `proveedor`
--

CREATE TABLE `proveedor` (
  `idProveedor` int(11) NOT NULL,
  `idRubro` int(11) NOT NULL,
  `idEstado` int(11) NOT NULL,
  `idPais` varchar(2) NOT NULL,
  `idCiudad` int(11) NOT NULL,
  `nombreEmpresa` varchar(300) NOT NULL,
  `nombreComercial` varchar(45) DEFAULT NULL,
  `ruc` char(11) NOT NULL,
  `direccion` varchar(300) NOT NULL,
  `referencia` varchar(300) DEFAULT NULL,
  `cuentaInstagram` varchar(300) DEFAULT NULL,
  `cuentaFacebook` varchar(300) DEFAULT NULL,
  `telefono1` varchar(50) NOT NULL,
  `telefono2` varchar(12) DEFAULT NULL,
  `telefono3` varchar(12) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `fechaRegistro` datetime NOT NULL,
  `usuarioRegistro` varchar(50) NOT NULL,
  `pcRegistro` varchar(50) NOT NULL,
  `fechaEdicion` datetime DEFAULT NULL,
  `usuarioEdicion` varchar(50) DEFAULT NULL,
  `pcEdicion` varchar(50) DEFAULT NULL,
  `activo` bit(1) NOT NULL DEFAULT b'1',
  `eliminado` bit(1) NOT NULL DEFAULT b'0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `proveedor`
--

INSERT INTO `proveedor` (`idProveedor`, `idRubro`, `idEstado`, `idPais`, `idCiudad`, `nombreEmpresa`, `nombreComercial`, `ruc`, `direccion`, `referencia`, `cuentaInstagram`, `cuentaFacebook`, `telefono1`, `telefono2`, `telefono3`, `email`, `fechaRegistro`, `usuarioRegistro`, `pcRegistro`, `fechaEdicion`, `usuarioEdicion`, `pcEdicion`, `activo`, `eliminado`) VALUES
(188, 1, 0, 'PE', 13, 'dasdas', 'dsa', '10746588297', 'dsa54dadsa', 'dasdas', 'bbbbbbbb', 'aaaaaa', '544', '544', '544', 'lanticona@eta.com.pe', '0000-00-00 00:00:00', '2020-02-23 11:12:05', '', '2020-02-23 12:06:09', 'admin', '-', b'1', b'0'),
(189, 1, 0, 'PE', 1, 'dasdas', 'dasdas', '87897987987', '4dasdas645', '5dasd6as', 'dsa564d5sa', 'das654das5', '4546', '4546', '4546', 'dsad@gmail.com', '0000-00-00 00:00:00', '2020-02-23 12:30:19', '', NULL, NULL, NULL, b'1', b'0'),
(190, 1, 0, 'PE', 1, 'aaaaaaaaaaaa', 'bbbbbbbbbb', '54465454645', 'dsa', 'das', 'dsa', 'dsa', '789', '789', '789', 'dsadsa@gmail.com', '0000-00-00 00:00:00', '2020-02-24 04:24:43', '', '2020-02-25 03:16:10', 'admin', '-', b'1', b'0'),
(191, 1, 0, 'PE', 2, 'bbbbbbbbb', 'asdasdas', '445465', 'dasda', '456', 'dasda', 'dsadas', '54564', '54564', '54564', 'bbb@gmail.com', '0000-00-00 00:00:00', '2020-02-24 21:03:49', '', '2020-02-25 03:12:24', 'admin', '-', b'1', b'0');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `proveedor_load`
--

CREATE TABLE `proveedor_load` (
  `id` int(11) NOT NULL,
  `ruc` char(11) NOT NULL,
  `nombre` varchar(450) NOT NULL,
  `direccion` varchar(500) NOT NULL,
  `ciudad` varchar(500) NOT NULL,
  `contacto` varchar(500) NOT NULL,
  `correo` varchar(500) NOT NULL,
  `telefono` varchar(500) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rol`
--

CREATE TABLE `rol` (
  `idRol` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(250) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `rol`
--

INSERT INTO `rol` (`idRol`, `nombre`, `descripcion`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 'adminweb', 'Administrador del sistema', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(2, 'Rol Principal', 'Acceso a todas las opciones.', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(3, 'Administrador', 'Acceso a registros, procesos y reportes.', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(4, 'Contador', 'Acceso a productos, y reportes.', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(5, 'Evaluador SUP8G', 'Evaluador SUP8G', '2020-02-24 23:53:17', 'admin', '-', '2020-02-24 23:56:45', 'admin', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rol_oficina`
--

CREATE TABLE `rol_oficina` (
  `idRolOficina` int(11) NOT NULL,
  `idRol` int(11) NOT NULL,
  `idOficina` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rol_tarea`
--

CREATE TABLE `rol_tarea` (
  `idRolTarea` int(11) NOT NULL,
  `idRol` int(11) NOT NULL,
  `idTarea` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `rol_tarea`
--

INSERT INTO `rol_tarea` (`idRolTarea`, `idRol`, `idTarea`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, 1, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(2, 1, 2, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(3, 1, 3, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(4, 1, 4, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(5, 1, 5, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(6, 1, 7, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(7, 1, 9, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(8, 1, 10, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(9, 1, 11, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(10, 1, 12, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(11, 1, 13, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(12, 1, 14, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(13, 1, 15, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(14, 1, 16, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(15, 1, 17, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(16, 1, 18, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(17, 1, 19, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(18, 1, 20, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(19, 1, 21, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(20, 1, 23, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(21, 1, 24, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(22, 1, 25, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(23, 1, 26, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(24, 1, 27, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(25, 1, 28, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(26, 1, 29, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(27, 1, 32, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(28, 1, 33, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(29, 1, 34, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(30, 1, 35, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(31, 1, 36, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(32, 2, 1, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(33, 2, 2, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(34, 2, 3, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(35, 2, 4, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(36, 2, 5, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(37, 2, 7, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(38, 2, 9, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(39, 2, 10, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(40, 2, 11, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(41, 2, 12, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(42, 2, 13, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(43, 2, 14, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(44, 2, 15, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(45, 2, 16, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(46, 2, 17, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(47, 2, 18, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(48, 2, 19, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(49, 2, 20, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(50, 2, 21, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(52, 2, 24, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(53, 2, 25, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(54, 2, 26, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(55, 2, 27, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(56, 2, 28, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(57, 2, 29, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(58, 2, 32, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(59, 2, 33, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(60, 2, 34, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(61, 2, 35, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(62, 2, 36, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(63, 3, 1, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(64, 3, 9, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(65, 3, 10, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(66, 3, 11, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(67, 3, 12, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(68, 3, 13, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(69, 3, 14, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(70, 3, 15, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(71, 3, 16, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(72, 3, 17, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(73, 3, 18, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(74, 3, 19, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(75, 3, 20, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(76, 3, 21, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(78, 3, 24, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(79, 3, 25, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(80, 3, 26, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(81, 3, 27, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(82, 3, 29, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(83, 3, 28, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(84, 3, 34, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(85, 3, 35, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(86, 4, 1, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(87, 4, 15, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(88, 4, 19, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(89, 4, 26, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(90, 4, 29, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(91, 4, 28, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(92, 4, 34, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(93, 4, 35, '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', 1),
(94, 1, 37, '2020-02-23 11:16:51', 'admin', '-', '2020-02-23 11:16:51', '-', '-', 1),
(95, 5, 1, '2020-02-24 23:59:00', 'admin', '-', '2020-02-24 23:59:00', 'admin', '-', 1),
(96, 5, 15, '2020-02-24 23:59:00', 'admin', '-', '2020-02-24 23:59:00', 'admin', '-', 1),
(97, 5, 19, '2020-02-24 23:59:00', 'admin', '-', '2020-02-24 23:59:00', 'admin', '-', 1),
(111, 3, 38, '2020-04-03 20:14:24', 'admin', '-', '2020-04-03 20:14:24', '-', '-', 1),
(101, 5, 34, '2020-02-24 23:59:00', 'admin', '-', '2020-02-24 23:59:00', 'admin', '-', 1),
(110, 5, 38, '2020-02-25 00:06:09', 'admin', '-', '2020-02-25 00:06:09', '-', '-', 1),
(103, 5, 14, '2020-02-25 00:02:22', 'admin', '-', '2020-02-25 00:02:22', '-', '-', 1),
(104, 5, 11, '2020-02-25 00:02:37', 'admin', '-', '2020-02-25 00:02:37', '-', '-', 1),
(105, 5, 13, '2020-02-25 00:02:44', 'admin', '-', '2020-02-25 00:02:44', '-', '-', 1),
(106, 5, 37, '2020-02-25 00:02:49', 'admin', '-', '2020-02-25 00:02:49', '-', '-', 1),
(107, 5, 17, '2020-02-25 00:02:57', 'admin', '-', '2020-02-25 00:02:57', '-', '-', 1),
(108, 5, 12, '2020-02-25 00:03:32', 'admin', '-', '2020-02-25 00:03:32', '-', '-', 1),
(109, 5, 10, '2020-02-25 00:03:41', 'admin', '-', '2020-02-25 00:03:41', '-', '-', 1),
(112, 1, 39, '2020-04-08 23:54:12', 'admin', '-', '2020-04-08 23:54:12', '-', '-', 1),
(113, 1, 40, '2020-04-10 15:51:03', 'admin', '-', '2020-04-10 15:51:03', '-', '-', 1),
(114, 1, 41, '2020-04-10 15:51:03', 'admin', '-', '2020-04-10 15:51:03', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `subcategoria`
--

CREATE TABLE `subcategoria` (
  `idSubcategoria` int(11) NOT NULL,
  `idCategoria` int(11) NOT NULL,
  `codigo` varchar(50) DEFAULT NULL,
  `nombre` varchar(150) NOT NULL,
  `descripcion` varchar(250) DEFAULT NULL,
  `abreviatura` char(5) DEFAULT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `subcategoria`
--

INSERT INTO `subcategoria` (`idSubcategoria`, `idCategoria`, `codigo`, `nombre`, `descripcion`, `abreviatura`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, '251', 'MATERIALES AUXILIARES', NULL, NULL, '2018-08-06 01:39:52', 'admin', '-', '2018-08-06 01:39:52', 'admin', '-', 1),
(2, 1, '252', 'SUMINISTROS', NULL, NULL, '2018-08-06 01:39:52', 'admin', '-', '2018-08-06 01:39:52', 'admin', '-', 1),
(3, 1, '253', 'REPUESTO', NULL, NULL, '2018-08-06 01:39:52', 'admin', '-', '2018-08-06 01:39:52', 'admin', '-', 1),
(5, 1, '000', 'OTROS', 'OTROS', 'OT', '2019-09-26 15:24:48', 'angelica_chuquilin', '-', '2019-09-26 15:24:48', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `subservicio`
--

CREATE TABLE `subservicio` (
  `idSubservicio` int(11) NOT NULL,
  `idOrdenServicio` int(11) NOT NULL,
  `trabajo` varchar(300) NOT NULL,
  `descripcion` varchar(400) NOT NULL,
  `cantidad` decimal(18,2) NOT NULL,
  `costoUnitario` decimal(18,2) NOT NULL,
  `costoTotal` decimal(18,2) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tarea`
--

CREATE TABLE `tarea` (
  `idTarea` int(11) NOT NULL,
  `idGrupo` int(11) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(250) NOT NULL,
  `url` varchar(150) NOT NULL,
  `icono` varchar(50) NOT NULL,
  `orden` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `tarea`
--

INSERT INTO `tarea` (`idTarea`, `idGrupo`, `nombre`, `descripcion`, `url`, `icono`, `orden`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, 'Datos Personales', 'Permite crear un usuario para el sistema.', '../Acceso/home.php', '-', 1, '2017-04-15 11:06:35', 'admin', '-', '2018-08-05 19:49:49', 'admin', '-', 1),
(2, 1, 'Grupos', 'Permite crear un grupo para el sistema.', '../Acceso/grupos.php', '-', 2, '2017-04-15 11:06:35', 'admin', '-', '2017-04-15 11:06:35', '-', '-', 1),
(3, 1, 'Tareas', 'Permite crear una tarea para el sistema.', '../Acceso/tareas.php', '-', 3, '2017-04-15 11:06:35', 'admin', '-', '2017-04-15 11:06:35', '-', '-', 1),
(4, 1, 'Roles', 'Permite crear un rol para el sistema.', '../Acceso/roles.php', '-', 4, '2017-04-15 11:06:35', 'admin', '-', '2017-04-15 11:06:35', '-', '-', 1),
(5, 1, 'Usuarios', 'Permite crear un usuario para el sistema.', '../Acceso/usuarios.php', '-', 5, '2017-04-15 11:06:35', 'admin', '-', '2017-04-15 11:06:35', '-', '-', 1),
(7, 1, 'Roles y Tareas', 'Permite crear un rol_tarea para el sistema.', '../Acceso/rolTarea.php', '-', 6, '2017-04-15 11:06:35', 'admin', '-', '2018-10-22 10:40:19', 'admin', '-', 1),
(9, 2, 'Registro de Multitabla', 'Permite crear la multitabla para el sistema.', '../Mantenedores/multitabla.php', '-', 6, '2017-04-15 11:06:35', 'admin', '-', '2017-05-07 11:18:09', 'admin', '-', 1),
(10, 2, 'Registro de Tasas', 'Permite crear un usuario para el sistema.', '../Mantenedores/tasas.php', '-', 7, '2017-04-15 11:06:35', 'admin', '-', '2018-08-14 19:52:54', 'admin', '-', 1),
(11, 2, 'Registro de Categorías', 'Permite crear una categoría para el sistema.', '../Mantenedores/categorias.php', '-', 1, '2017-04-15 11:06:35', 'admin', '-', '2018-06-05 23:04:11', 'admin', '-', 1),
(12, 2, 'Registro de Subcategorias', 'Permite crear un proveedor para el sistema.', '../Mantenedores/subcategorias.php', '-', 2, '2017-04-15 11:06:35', 'admin', '-', '2018-06-13 00:12:58', 'admin', '-', 1),
(13, 2, 'Registro de Clases', 'Permite crear un proveedor para el sistema.', '../Mantenedores/clases.php', '-', 3, '2017-04-15 11:06:35', 'admin', '-', '2018-06-13 00:12:42', 'admin', '-', 1),
(14, 2, 'Registro de Proveedor', 'Permite crear un proveedor para el sistema.', '../Mantenedores/proveedores.php', '-', 5, '2017-04-15 11:06:35', 'admin', '-', '2017-04-18 18:51:25', 'admin', '-', 1),
(15, 2, 'Registro de Productos', 'Permite crear un producto para el sistema.', '../Mantenedores/productos.php', '-', 4, '2017-04-15 11:06:35', 'admin', '-', '2017-05-07 11:17:39', 'admin', '-', 1),
(16, 3, 'Registro de Compras', 'Permite crear un producto para el sistema.', '../Procesos/compras.php', '-', 3, '2017-04-15 11:06:35', 'admin', '-', '2017-05-07 11:17:31', 'admin', '-', 1),
(17, 3, 'Registro de Orden Compra', 'Permite crear un producto para el sistema.', '../Procesos/ordenCompra.php', '-', 2, '2017-04-15 11:06:35', 'admin', '-', '2017-04-18 18:54:31', 'admin', '-', 1),
(18, 3, 'Registro de Cotizaciones', 'Permite crear una cotización en el sistema.', '../Procesos/cotizaciones.php', '-', 1, '2017-06-23 08:22:24', 'admin', '-', '2018-10-22 12:09:08', 'admin', '-', 1),
(19, 4, 'Kardex por producto', 'Kardex por producto', '../Reportes/kardexProducto.php', '-', 1, '2017-08-06 09:13:48', 'admin', '-', '2018-07-20 19:10:30', 'admin', '-', 1),
(20, 3, 'Registro de Orden de Servicios', 'Registro de Orden de Servicios', '../Procesos/ordenServicio.php', '-', 6, '2018-02-28 18:49:47', 'admin', '-', '2018-02-28 18:49:47', '-', '-', 1),
(21, 3, 'Orden de Mantenimiento', 'Orden de Mantenimiento', '../Procesos/ordenMantenimiento.php', '-', 6, '2018-02-28 18:51:05', 'admin', '-', '2018-02-28 18:51:05', '-', '-', 1),
(23, 3, 'Registro de Inventario', 'Registro de Inventario', '../Procesos/inventario.php', '-', 6, '2018-02-28 18:54:37', 'admin', '-', '2018-02-28 18:55:49', 'admin', '-', 1),
(24, 3, 'Registro de Nota de Almacen', 'Registro de Nota de Almacen', '../Procesos/notaAlmacen.php', '-', 6, '2018-02-28 18:54:59', 'admin', '-', '2018-02-28 18:56:11', 'admin', '-', 1),
(25, 2, 'Registro de Trabajadores', 'Trabajador', '../Mantenedores/trabajadores.php', '-', 6, '2018-03-13 23:17:31', 'admin', '-', '2018-03-13 23:18:56', 'admin', '-', 1),
(26, 4, 'Trazabilidad Compras', 'Trazabilidad', '../Reportes/trazabilidad.php', '-', 3, '2018-04-15 13:55:09', 'admin', '-', '2018-10-22 02:29:45', 'admin', '-', 1),
(27, 2, 'Registro de Vehículos', 'Registro de Vehículos', '../Mantenedores/unidades.php', '-', 6, '2018-07-13 21:08:34', 'admin', '-', '2018-07-13 21:08:34', '-', '-', 1),
(29, 4, 'Trazabilidad OS', 'Trazabilidad OS', '../Reportes/trazabilidadOS.php', '-', 5, '2018-10-22 03:00:54', 'admin', '-', '2018-10-22 03:00:54', '-', '-', 1),
(28, 4, 'Trazabilidad OTM', 'Trazabilidad OTM', '../Reportes/trazabilidadOTM.php', '-', 4, '2018-10-22 02:30:14', 'admin', '-', '2018-10-22 02:44:52', 'admin', '-', 1),
(32, 5, 'Empresa', 'Empresa', '../Configuracion/empresa.php', '-', 6, '2018-10-22 11:24:39', 'admin', '-', '2018-10-22 12:10:36', 'admin', '-', 1),
(33, 5, 'Respaldo de Base de Datos', 'Respaldo de Base de Datos', '../Configuracion/respaldo.php', '-', 6, '2018-10-22 12:07:05', 'admin', '-', '2018-10-23 10:07:40', 'admin', '-', 0),
(34, 4, 'Stock de Productos', 'Stock de Productos', '../Reportes/stockProductos.php', '-', 2, '2018-10-24 23:00:04', 'admin', '-', '2018-10-24 23:44:58', 'admin', '-', 1),
(35, 4, 'Productos Entregados', 'Productos Entregados', '../Reportes/productosEntregados.php', '-', 6, '2018-11-09 12:55:46', 'admin', '-', '2018-11-09 12:56:37', 'admin', '-', 1),
(36, 5, 'Envío de correos', 'Envío de correos', '../Configuracion/envioCorreos.php', '-', 6, '2018-11-11 22:33:24', 'admin', '-', '2018-11-11 22:33:24', '-', '-', 1),
(37, 2, 'Registro de Clientes', 'Clientes', '../Mantenedores/clientes.php', '-', 6, '2020-02-23 11:16:42', 'admin', '-', '2020-02-23 11:17:28', 'admin', '-', 1),
(38, 3, 'Registro de Ventas', 'Registro de  Ventas', '../Procesos/ventas.php', '-', 6, '2020-02-25 00:05:34', 'admin', '-', '2020-02-25 00:06:35', 'admin', '-', 1),
(39, 2, 'Registro de Formas de Pago', 'Permite registrar todas las formas de pago', '../Mantenedores/formaPago.php', '-', 6, '2020-04-08 23:52:42', 'admin', '-', '2020-04-08 23:52:42', '-', '-', 1),
(40, 3, 'Registro de Documento de Venta', 'Documento de venta', '../Procesos/documentoVenta.php', '-', 6, '2020-04-10 15:50:35', 'admin', '-', '2020-04-10 15:50:35', '-', '-', 1),
(41, 6, 'Dashboard', 'Dashboard', '../Dashboard/dashboard.php', '-', 6, '2020-04-25 21:30:39', 'admin', '-', '2020-04-25 21:30:39', '-', '-', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tasa_cambio`
--

CREATE TABLE `tasa_cambio` (
  `idTasaCambio` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `tipoMoneda` int(11) NOT NULL,
  `precioCompra` decimal(18,3) NOT NULL,
  `precioVenta` decimal(18,3) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `tasa_cambio`
--

INSERT INTO `tasa_cambio` (`idTasaCambio`, `fecha`, `tipoMoneda`, `precioCompra`, `precioVenta`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(4, '2018-10-09', 2, '5.000', '5.000', '2018-10-10 23:49:53', 'admin', '-', NULL, NULL, NULL, 1),
(3, '2018-10-11', 2, '4.000', '4.000', '2018-10-10 23:49:47', 'admin', '-', '2018-10-11 09:10:16', 'admin', '-', 1),
(5, '2018-10-17', 2, '4.000', '4.000', '2018-10-12 10:13:11', 'admin', '-', '2018-10-17 09:11:22', 'admin', '-', 1),
(6, '2018-11-20', 2, '4.000', '4.000', '2018-10-18 11:07:32', 'admin', '-', '2018-11-20 08:23:16', 'admin', '-', 1),
(7, '2018-12-03', 2, '3.378', '3.382', '2018-12-03 09:12:01', 'admin', '-', NULL, NULL, NULL, 1),
(8, '2018-12-04', 2, '3.374', '3.378', '2018-12-04 08:45:54', 'admin', '-', NULL, NULL, NULL, 1),
(9, '2018-12-05', 2, '3.378', '3.382', '2018-12-05 11:47:36', 'admin', '-', NULL, NULL, NULL, 1),
(10, '2018-12-06', 2, '3.378', '3.381', '2018-12-06 09:00:45', 'admin', '-', NULL, NULL, NULL, 1),
(11, '2018-12-10', 2, '3.367', '3.371', '2018-12-10 08:51:16', 'admin', '-', NULL, NULL, NULL, 1),
(12, '2018-12-11', 2, '3.367', '3.371', '2018-12-11 09:34:59', 'admin', '-', NULL, NULL, NULL, 1),
(13, '2018-12-12', 2, '3.366', '3.370', '2018-12-12 08:54:07', 'admin', '-', NULL, NULL, NULL, 1),
(14, '2018-12-13', 2, '3.355', '3.359', '2018-12-13 09:24:52', 'admin', '-', NULL, NULL, NULL, 1),
(15, '2018-12-14', 2, '3.359', '3.365', '2018-12-14 09:53:04', 'admin', '-', NULL, NULL, NULL, 1),
(16, '2018-12-15', 2, '3.359', '3.365', '2018-12-15 12:20:12', 'admin', '-', NULL, NULL, NULL, 1),
(17, '2018-12-17', 2, '3.351', '3.355', '2018-12-17 09:26:01', 'admin', '-', NULL, NULL, NULL, 1),
(18, '2018-12-18', 2, '3.341', '3.347', '2018-12-18 09:58:49', 'admin', '-', NULL, NULL, NULL, 1),
(19, '2018-12-19', 2, '3.341', '3.347', '2018-12-19 08:50:52', 'admin', '-', NULL, NULL, NULL, 1),
(20, '2018-12-20', 2, '3.347', '3.351', '2018-12-20 18:53:01', 'admin', '-', NULL, NULL, NULL, 1),
(21, '2018-12-22', 2, '3.352', '3.358', '2018-12-21 10:18:12', 'admin', '-', '2018-12-24 10:56:54', 'admin', '-', 1),
(22, '2018-12-24', 2, '3.352', '3.358', '2018-12-24 10:57:41', 'admin', '-', '2018-12-26 12:05:32', 'admin', '-', 1),
(23, '2018-12-21', 2, '3.339', '3.343', '2018-12-24 10:59:39', 'admin', '-', NULL, NULL, NULL, 1),
(24, '2018-12-26', 2, '3.352', '3.358', '2018-12-26 12:03:58', 'admin', '-', NULL, NULL, NULL, 1),
(25, '2018-12-27', 2, '3.366', '3.369', '2018-12-27 16:22:22', 'admin', '-', NULL, NULL, NULL, 1),
(26, '2018-12-28', 2, '3.373', '3.376', '2018-12-28 10:51:25', 'admin', '-', NULL, NULL, NULL, 1),
(27, '2018-12-29', 2, '3.373', '3.376', '2018-12-29 16:14:21', 'admin', '-', NULL, NULL, NULL, 1),
(29, '2019-01-02', 2, '3.369', '3.379', '2019-01-02 18:02:43', 'admin', '-', NULL, NULL, NULL, 1),
(30, '2019-01-03', 2, '3.369', '3.379', '2019-01-03 08:56:22', 'admin', '-', NULL, NULL, NULL, 1),
(31, '2019-01-04', 2, '3.368', '3.371', '2019-01-04 09:14:56', 'admin', '-', NULL, NULL, NULL, 1),
(32, '2019-01-05', 2, '3.368', '3.371', '2019-01-05 08:41:39', 'admin', '-', NULL, NULL, NULL, 1),
(33, '2019-01-07', 2, '3.356', '3.360', '2019-01-07 10:59:48', 'admin', '-', NULL, NULL, NULL, 1),
(34, '2019-01-08', 2, '3.349', '3.353', '2019-01-08 11:32:02', 'admin', '-', NULL, NULL, NULL, 1),
(35, '2019-01-09', 2, '3.347', '3.350', '2019-01-09 10:26:28', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(36, '2019-01-10', 2, '3.333', '3.335', '2019-01-10 16:21:49', 'luis_anticona', '-', NULL, NULL, NULL, 1),
(37, '2019-01-11', 2, '3.333', '3.335', '2019-01-11 09:01:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(38, '2019-01-12', 2, '3.341', '3.343', '2019-01-12 09:38:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(39, '2019-01-14', 2, '3.341', '3.343', '2019-01-14 09:58:18', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(40, '2019-01-15', 2, '3.339', '3.343', '2019-01-15 09:01:15', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(41, '2019-01-16', 2, '3.336', '3.340', '2019-01-16 17:45:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(42, '2019-01-18', 2, '3.331', '3.333', '2019-01-18 09:18:16', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(43, '2019-01-17', 2, '3.331', '3.333', '2019-01-18 09:18:31', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(44, '2019-01-19', 2, '3.331', '3.333', '2019-01-19 16:31:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(45, '2019-01-21', 2, '3.316', '3.319', '2019-01-21 10:38:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(46, '2019-01-22', 2, '3.325', '3.330', '2019-01-22 09:55:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(47, '2019-01-23', 2, '3.335', '3.337', '2019-01-23 17:16:47', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(48, '2019-01-24', 2, '3.336', '3.338', '2019-01-24 09:50:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(49, '2019-01-25', 2, '3.345', '3.346', '2019-01-25 16:20:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(50, '2019-01-28', 2, '3.345', '3.346', '2019-01-28 08:56:14', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(51, '2019-01-29', 2, '3.345', '3.346', '2019-01-29 10:17:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(52, '2019-01-30', 2, '3.357', '3.360', '2019-01-30 10:34:17', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(53, '2019-01-26', 2, '3.337', '3.336', '2019-01-30 12:41:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(54, '2019-01-31', 2, '3.357', '3.360', '2019-01-31 09:05:54', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(55, '2019-02-01', 2, '3.351', '3.355', '2019-02-01 09:00:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(56, '2019-02-02', 2, '3.333', '3.335', '2019-02-02 10:45:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(57, '2019-02-04', 2, '3.326', '3.333', '2019-02-04 09:33:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(58, '2019-02-05', 2, '3.327', '3.331', '2019-02-05 09:26:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(59, '2019-02-06', 2, '3.327', '3.331', '2019-02-06 08:46:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(60, '2019-02-07', 2, '3.328', '3.331', '2019-02-07 08:49:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(61, '2019-02-08', 2, '3.321', '3.324', '2019-02-08 14:22:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(62, '2019-02-09', 2, '3.321', '3.324', '2019-02-09 12:01:05', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(63, '2019-02-13', 2, '3.331', '3.333', '2019-02-13 10:09:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(64, '2019-02-14', 2, '3.336', '3.337', '2019-02-14 10:29:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(65, '2019-02-15', 2, '3.339', '3.341', '2019-02-15 11:07:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(66, '2019-02-16', 2, '3.339', '3.341', '2019-02-16 11:40:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(67, '2019-02-19', 2, '3.318', '3.324', '2019-02-19 09:23:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(68, '2019-02-18', 2, '3.318', '3.324', '2019-02-19 17:37:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(69, '2019-02-21', 2, '3.316', '3.318', '2019-02-21 11:53:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(70, '2019-02-20', 2, '3.316', '3.318', '2019-02-21 12:04:29', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(71, '2019-02-23', 2, '3.319', '3.322', '2019-02-23 12:13:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(72, '2019-02-22', 2, '3.319', '3.322', '2019-02-23 12:21:51', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(73, '2019-02-25', 2, '3.307', '3.310', '2019-02-25 16:21:56', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(74, '2019-02-28', 2, '3.304', '3.306', '2019-02-28 18:50:07', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(75, '2019-02-26', 2, '3.307', '3.310', '2019-02-28 19:30:00', 'angelica_chuquilin', '-', '2019-02-28 19:31:02', 'angelica_chuquilin', '-', 1),
(76, '2019-03-01', 2, '3.304', '3.306', '2019-03-01 09:02:54', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(77, '2019-03-02', 2, '3.300', '3.305', '2019-03-02 09:22:14', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(78, '2019-03-04', 2, '3.303', '3.307', '2019-03-04 09:08:29', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(79, '2019-03-06', 2, '3.310', '3.313', '2019-03-06 09:16:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(80, '2019-03-05', 2, '3.310', '3.313', '2019-03-06 17:27:48', 'angelica_chuquilin', '-', '2019-03-06 17:28:19', 'angelica_chuquilin', '-', 1),
(81, '2019-03-07', 2, '3.310', '3.313', '2019-03-07 08:56:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(82, '2019-03-08', 2, '3.308', '3.311', '2019-03-08 09:34:47', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(83, '2019-03-09', 2, '3.308', '3.311', '2019-03-09 10:01:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(84, '2019-03-12', 2, '3.307', '3.310', '2019-03-12 12:36:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(85, '2019-03-14', 2, '3.290', '3.292', '2019-03-14 10:35:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(86, '2019-03-16', 2, '3.294', '3.297', '2019-03-16 16:46:21', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(87, '2019-03-19', 2, '3.297', '3.301', '2019-03-19 09:34:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(88, '2019-03-11', 2, '3.312', '3.315', '2019-03-19 09:51:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(89, '2019-03-20', 2, '3.297', '3.301', '2019-03-20 08:54:35', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(90, '2019-03-21', 2, '3.300', '3.301', '2019-03-21 08:51:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(91, '2019-03-26', 2, '3.301', '3.304', '2019-03-26 10:08:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(92, '2019-03-25', 2, '3.301', '3.304', '2019-03-26 10:54:37', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(93, '2019-03-27', 2, '3.301', '3.304', '2019-03-27 09:01:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(94, '2019-03-29', 2, '3.315', '3.317', '2019-03-29 11:34:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(95, '2019-03-28', 2, '3.301', '3.304', '2019-03-29 17:45:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(96, '2019-04-01', 2, '3.316', '3.321', '2019-04-01 17:59:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(97, '2019-03-30', 2, '3.315', '3.317', '2019-04-01 18:06:16', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(98, '2019-04-02', 2, '3.306', '3.312', '2019-04-02 10:25:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(99, '2019-04-03', 2, '3.309', '3.312', '2019-04-03 11:33:53', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(100, '2019-04-04', 2, '3.298', '3.300', '2019-04-04 10:49:34', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(101, '2019-04-05', 2, '3.295', '3.299', '2019-04-05 18:11:28', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(102, '2019-04-06', 2, '3.295', '3.299', '2019-04-06 09:38:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(103, '2019-04-08', 2, '3.295', '3.300', '2019-04-08 12:27:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(104, '2019-04-09', 2, '3.289', '3.293', '2019-04-09 17:54:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(105, '2019-04-10', 2, '3.289', '3.293', '2019-04-10 09:02:35', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(106, '2019-04-11', 2, '3.293', '3.295', '2019-04-11 16:39:22', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(107, '2019-04-12', 2, '3.293', '3.295', '2019-04-12 18:01:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(108, '2019-04-13', 2, '3.296', '3.300', '2019-04-13 09:32:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(109, '2019-04-15', 2, '3.296', '3.300', '2019-04-15 09:56:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(110, '2019-04-16', 2, '3.295', '3.299', '2019-04-16 11:17:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(111, '2019-04-17', 2, '3.294', '3.297', '2019-04-17 17:54:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(112, '2019-04-18', 2, '3.294', '3.297', '2019-04-18 10:22:17', 'luis_anticona', '-', NULL, NULL, NULL, 1),
(113, '2019-04-22', 2, '3.294', '3.297', '2019-04-22 11:54:41', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(114, '2019-04-25', 2, '3.308', '3.311', '2019-04-25 09:22:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(115, '2019-04-26', 2, '3.329', '3.332', '2019-04-26 16:50:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(116, '2019-04-27', 2, '3.329', '3.332', '2019-04-27 09:29:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(117, '2019-04-30', 2, '3.329', '3.332', '2019-04-30 09:01:07', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(118, '2019-05-02', 2, '3.306', '3.312', '2019-05-02 11:59:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(119, '2019-05-03', 2, '3.306', '3.312', '2019-05-03 16:41:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(120, '2019-05-08', 2, '3.312', '3.315', '2019-05-08 10:58:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(121, '2019-05-09', 2, '3.313', '3.316', '2019-05-09 10:59:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(122, '2019-05-11', 2, '3.321', '3.322', '2019-05-11 09:36:53', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(123, '2019-05-13', 2, '3.314', '3.318', '2019-05-13 11:08:30', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(124, '2019-05-14', 2, '3.329', '3.332', '2019-05-14 09:12:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(125, '2019-05-15', 2, '3.321', '3.325', '2019-05-15 16:13:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(126, '2019-05-18', 2, '3.314', '3.318', '2019-05-18 11:30:49', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(127, '2019-04-24', 2, '3.308', '3.311', '2019-05-18 12:02:27', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(128, '2019-05-20', 2, '3.321', '3.324', '2019-05-20 11:55:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(129, '2019-05-21', 2, '3.336', '3.340', '2019-05-21 11:27:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(130, '2019-05-23', 2, '3.344', '3.347', '2019-05-23 12:01:55', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(131, '2019-05-24', 2, '3.347', '3.350', '2019-05-24 11:31:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(132, '2019-05-28', 2, '3.344', '3.351', '2019-05-28 10:14:15', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(133, '2019-05-22', 2, '3.344', '3.347', '2019-05-28 12:16:00', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(134, '2019-05-29', 2, '3.353', '3.355', '2019-05-29 10:04:22', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(135, '2019-05-16', 2, '3.320', '3.324', '2019-05-29 10:49:38', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(136, '2019-05-30', 2, '3.354', '3.358', '2019-05-30 09:27:05', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(137, '2019-05-31', 2, '3.358', '3.363', '2019-05-31 11:27:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(138, '2019-05-27', 2, '3.358', '3.363', '2019-05-31 11:46:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(139, '2019-06-01', 2, '3.358', '3.363', '2019-06-01 12:53:26', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(140, '2019-06-03', 2, '3.367', '3.370', '2019-06-03 09:07:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(141, '2019-06-04', 2, '3.372', '3.373', '2019-06-04 09:23:27', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(142, '2019-06-05', 2, '3.348', '3.351', '2019-06-05 11:41:52', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(143, '2019-06-06', 2, '3.351', '3.353', '2019-06-06 09:39:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(144, '2019-06-07', 2, '3.335', '3.338', '2019-06-07 16:15:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(145, '2019-06-10', 2, '3.335', '3.338', '2019-06-10 08:51:52', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(146, '2019-06-11', 2, '3.332', '3.335', '2019-06-11 11:22:18', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(147, '2019-06-13', 2, '3.329', '3.331', '2019-06-13 09:48:38', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(148, '2019-06-17', 2, '3.333', '3.340', '2019-06-17 18:21:56', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(149, '2019-06-19', 2, '3.335', '3.340', '2019-06-19 18:44:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(150, '2019-06-20', 2, '3.333', '3.336', '2019-06-20 16:15:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(151, '2019-06-21', 2, '3.309', '3.313', '2019-06-21 10:34:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(152, '2019-06-22', 2, '3.309', '3.313', '2019-06-22 11:12:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(153, '2019-06-24', 2, '3.302', '3.306', '2019-06-24 12:36:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(154, '2019-06-25', 2, '3.297', '3.302', '2019-06-25 17:15:52', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(155, '2019-06-26', 2, '3.297', '3.302', '2019-06-26 09:49:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(156, '2019-06-27', 2, '3.397', '3.301', '2019-06-27 09:40:00', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(157, '2019-06-28', 2, '3.290', '3.294', '2019-06-28 11:35:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(158, '2019-07-01', 2, '3.285', '3.290', '2019-07-01 09:52:29', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(159, '2019-07-02', 2, '3.288', '3.291', '2019-07-02 09:48:26', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(160, '2019-07-03', 2, '3.288', '3.292', '2019-07-03 11:25:31', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(161, '2019-07-04', 2, '3.294', '3.296', '2019-07-04 09:59:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(162, '2019-07-06', 2, '3.286', '3.294', '2019-07-06 09:49:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(163, '2019-07-08', 2, '3.293', '3.298', '2019-07-08 09:52:53', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(164, '2019-07-09', 2, '3.286', '3.293', '2019-07-09 09:54:22', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(165, '2019-07-10', 2, '3.288', '3.293', '2019-07-10 16:13:12', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(166, '2019-07-11', 2, '3.285', '3.288', '2019-07-11 08:38:49', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(167, '2019-07-12', 2, '3.281', '3.286', '2019-07-12 09:05:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(168, '2019-07-15', 2, '3.281', '3.285', '2019-07-15 17:30:11', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(169, '2019-07-16', 2, '3.284', '3.286', '2019-07-16 09:27:12', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(170, '2019-07-17', 2, '3.285', '3.288', '2019-07-17 09:23:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(171, '2019-07-18', 2, '3.284', '3.287', '2019-07-18 11:50:01', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(172, '2019-07-19', 2, '3.285', '3.288', '2019-07-20 08:52:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(173, '2019-07-20', 2, '3.285', '3.288', '2019-07-20 08:52:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(174, '2019-07-23', 2, '3.286', '3.287', '2019-07-23 09:49:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(175, '2019-07-24', 2, '3.290', '3.292', '2019-07-24 18:26:28', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(176, '2019-07-25', 2, '3.290', '3.292', '2019-07-25 10:09:26', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(177, '2019-07-26', 2, '3.296', '3.300', '2019-07-26 09:37:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(178, '2019-07-30', 2, '3.297', '3.300', '2019-07-30 18:04:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(179, '2019-07-31', 2, '3.297', '3.300', '2019-07-31 09:13:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(180, '2019-08-01', 2, '3.308', '3.310', '2019-08-01 09:06:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(181, '2019-08-02', 2, '3.316', '3.319', '2019-08-02 09:10:28', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(182, '2019-08-03', 2, '3.343', '3.346', '2019-08-03 09:37:20', 'angelica_chuquilin', '-', '2019-08-06 11:08:14', 'angelica_chuquilin', '-', 1),
(183, '2019-08-04', 2, '3.343', '3.346', '2019-08-06 11:08:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(184, '2019-08-05', 2, '3.343', '3.346', '2019-08-06 11:08:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(185, '2019-08-06', 2, '3.375', '3.385', '2019-08-06 11:09:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(186, '2019-08-07', 2, '3.380', '3.384', '2019-08-07 08:53:56', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(187, '2019-08-09', 2, '3.379', '3.382', '2019-08-09 09:54:37', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(188, '2019-08-10', 2, '3.379', '3.382', '2019-08-10 09:33:01', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(189, '2019-07-27', 2, '3.297', '2.300', '2019-08-10 13:00:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(190, '2019-08-12', 2, '3.379', '3.383', '2019-08-12 09:14:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(191, '2019-08-13', 2, '3.386', '3.389', '2019-08-13 16:45:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(192, '2019-08-14', 2, '3.375', '3.377', '2019-08-14 10:22:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(193, '2019-08-15', 2, '3.389', '3.389', '2019-08-15 15:30:34', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(194, '2019-08-16', 2, '3.390', '3.394', '2019-08-16 11:33:37', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(195, '2019-08-19', 2, '3.382', '3.386', '2019-08-19 11:35:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(196, '2019-08-17', 2, '3.382', '3.386', '2019-08-19 11:56:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(197, '2019-08-08', 2, '3.379', '3.382', '2019-08-19 14:38:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(198, '2019-08-20', 2, '3.382', '3.386', '2019-08-20 09:02:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(199, '2019-08-21', 2, '3.379', '3.381', '2019-08-21 12:09:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(200, '2019-08-22', 2, '3.376', '3.379', '2019-08-22 10:20:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(204, '2019-08-23', 2, '3.378', '3.381', '2019-08-26 09:46:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(205, '2019-08-24', 2, '3.374', '3.377', '2019-08-26 09:46:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(206, '2019-08-26', 2, '3.374', '3.377', '2019-08-26 09:47:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(207, '2019-08-27', 2, '3.377', '3.379', '2019-08-27 09:10:22', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(208, '2019-08-28', 2, '3.385', '3.388', '2019-08-28 09:35:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(209, '2019-08-29', 2, '3.392', '3.399', '2019-08-29 08:49:14', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(210, '2019-08-30', 2, '3.392', '3.399', '2019-08-31 09:46:26', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(211, '2019-08-31', 2, '3.392', '3.399', '2019-08-31 09:46:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(212, '2019-09-02', 2, '3.392', '3.399', '2019-09-02 09:11:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(213, '2019-09-03', 2, '3.396', '3.405', '2019-09-03 08:32:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(214, '2019-09-04', 2, '3.403', '3.405', '2019-09-04 08:35:01', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(215, '2019-09-05', 2, '3.389', '3.389', '2019-09-05 09:03:18', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(216, '2019-09-06', 2, '3.366', '3.367', '2019-09-06 08:40:49', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(218, '2019-09-07', 2, '3.344', '3.346', '2019-09-09 09:12:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(219, '2019-09-09', 2, '3.344', '3.346', '2019-09-09 09:12:24', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(220, '2019-09-10', 2, '3.343', '3.347', '2019-09-10 09:12:41', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(221, '2019-09-11', 2, '3.344', '3.348', '2019-09-11 09:56:38', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(222, '2019-09-12', 2, '3.342', '3.344', '2019-09-12 09:22:34', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(223, '2019-09-13', 2, '3.328', '3.331', '2019-09-13 09:10:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(226, '2019-09-14', 2, '3.315', '3.318', '2019-09-16 08:59:22', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(227, '2019-09-16', 2, '3.315', '3.318', '2019-09-16 08:59:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(228, '2019-09-17', 2, '3.322', '3.327', '2019-09-17 08:55:24', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(229, '2019-09-18', 2, '3.341', '3.345', '2019-09-18 08:37:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(230, '2019-09-19', 2, '3.342', '3.345', '2019-09-19 08:55:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(231, '2019-09-20', 2, '3.353', '3.354', '2019-09-20 09:08:55', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(232, '2019-09-21', 2, '3.357', '3.361', '2019-09-23 17:45:10', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(233, '2019-09-23', 2, '3.357', '3.361', '2019-09-23 17:45:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(234, '2019-09-24', 2, '3.362', '3.364', '2019-09-24 09:02:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(235, '2019-09-25', 2, '3.344', '3.346', '2019-09-25 09:01:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(236, '2019-09-26', 2, '3.348', '3.352', '2019-09-26 15:34:58', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(237, '2019-09-27', 2, '3.362', '3.365', '2019-09-27 08:49:35', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(238, '2019-09-28', 2, '3.362', '3.365', '2019-09-28 09:04:06', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(239, '2019-09-30', 2, '3.384', '3.395', '2019-09-30 09:09:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(240, '2019-10-01', 2, '3.382', '3.385', '2019-10-01 09:52:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(241, '2019-10-02', 2, '3.390', '3.393', '2019-10-02 09:15:18', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(242, '2019-10-03', 2, '3.386', '3.388', '2019-10-03 08:48:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(243, '2019-10-04', 2, '3.376', '3.378', '2019-10-04 08:58:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(245, '2019-10-05', 2, '3.375', '3.378', '2019-10-07 09:07:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(246, '2019-10-07', 2, '3.375', '3.378', '2019-10-07 09:07:17', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(247, '2019-10-08', 2, '3.384', '3.388', '2019-10-09 09:02:31', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(248, '2019-10-09', 2, '3.384', '3.388', '2019-10-09 09:02:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(249, '2019-10-10', 2, '3.377', '3.379', '2019-10-10 10:53:16', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(250, '2019-10-11', 2, '3.358', '3.361', '2019-10-11 08:56:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(252, '2019-10-14', 2, '3.356', '3.357', '2019-10-14 09:01:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(253, '2019-10-12', 2, '3.356', '3.357', '2019-10-14 09:01:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(254, '2019-10-15', 2, '3.360', '3.365', '2019-10-15 08:54:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(255, '2019-10-16', 2, '3.367', '3.372', '2019-10-16 08:47:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(256, '2019-10-17', 2, '3.365', '3.370', '2019-10-17 08:51:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(257, '2019-10-18', 2, '3.354', '3.355', '2019-10-18 08:55:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(259, '2019-10-19', 2, '3.343', '3.347', '2019-10-21 13:38:29', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(260, '2019-10-21', 2, '3.343', '3.347', '2019-10-21 13:39:08', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(261, '2019-10-22', 2, '3.343', '3.347', '2019-10-22 10:00:21', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(262, '2019-10-23', 2, '3.337', '3.342', '2019-10-23 10:17:15', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(263, '2019-10-24', 2, '3.344', '3.347', '2019-10-24 08:57:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(264, '2019-10-25', 2, '3.348', '3.350', '2019-10-25 08:44:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(265, '2019-10-26', 2, '3.348', '3.350', '2019-10-26 09:10:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(266, '2019-10-28', 2, '3.346', '3.351', '2019-10-28 09:20:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(268, '2019-10-29', 2, '3.330', '3.335', '2019-10-30 08:47:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(269, '2019-10-30', 2, '3.334', '3.340', '2019-10-30 08:47:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(270, '2019-10-31', 2, '3.345', '3.349', '2019-10-31 09:07:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(271, '2019-11-02', 2, '3.357', '3.360', '2019-11-02 09:00:52', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(272, '2019-11-04', 2, '3.345', '3.349', '2019-11-04 11:50:30', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(273, '2019-11-05', 2, '3.332', '3.336', '2019-11-05 09:15:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(274, '2019-11-06', 2, '3.336', '3.339', '2019-11-06 08:51:37', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(275, '2019-11-07', 2, '3.339', '3.341', '2019-11-07 08:57:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(276, '2019-11-08', 2, '3.342', '3.345', '2019-11-08 08:57:13', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(277, '2019-11-09', 2, '3.342', '3.345', '2019-11-09 08:52:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(278, '2019-11-11', 2, '3.350', '3.350', '2019-11-12 08:44:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(279, '2019-11-12', 2, '3.359', '3.364', '2019-11-12 08:45:06', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(280, '2019-11-13', 2, '3.371', '3.376', '2019-11-13 08:55:31', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(281, '2019-11-14', 2, '3.390', '3.392', '2019-11-14 09:03:51', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(282, '2019-11-15', 2, '3.387', '3.391', '2019-11-15 08:59:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(283, '2019-11-16', 2, '3.387', '3.391', '2019-11-16 11:43:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(284, '2019-11-18', 2, '3.368', '3.373', '2019-11-18 09:12:13', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(285, '2019-11-19', 2, '3.367', '3.372', '2019-11-19 08:57:24', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(286, '2019-11-20', 2, '3.376', '3.381', '2019-11-20 08:53:46', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(287, '2019-11-21', 2, '3.384', '3.387', '2019-11-21 09:16:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(288, '2019-11-22', 2, '3.384', '3.387', '2019-11-22 08:47:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(289, '2019-11-23', 2, '3.375', '3.380', '2019-11-23 08:37:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(290, '2019-11-25', 2, '3.382', '3.385', '2019-11-25 10:28:54', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(291, '2019-11-26', 2, '3.385', '3.391', '2019-11-26 09:45:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(292, '2019-11-27', 2, '3.381', '3.385', '2019-11-27 09:14:27', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(293, '2019-11-28', 2, '3.391', '3.394', '2019-11-28 08:56:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(294, '2019-11-29', 2, '3.385', '3.390', '2019-11-29 08:48:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(295, '2019-11-30', 2, '3.385', '3.390', '2019-11-30 08:48:02', 'julissa_vargas', '-', NULL, NULL, NULL, 1),
(296, '2019-12-02', 2, '3.376', '3.379', '2019-12-02 09:12:40', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(297, '2019-12-03', 2, '3.399', '3.403', '2019-12-03 08:54:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(298, '2019-12-04', 2, '3.389', '3.391', '2019-12-04 08:56:04', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(299, '2019-12-05', 2, '3.383', '3.386', '2019-12-05 08:36:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(300, '2019-12-06', 2, '3.374', '3.380', '2019-12-06 08:22:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(301, '2019-12-07', 2, '3.374', '3.380', '2019-12-07 09:15:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(302, '2019-12-09', 2, '3.375', '3.381', '2019-12-09 09:01:50', 'julissa_vargas', '-', NULL, NULL, NULL, 1),
(303, '2019-12-10', 2, '3.376', '3.380', '2019-12-10 08:37:17', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(304, '2019-12-11', 2, '3.387', '3.391', '2019-12-11 09:05:42', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(305, '2019-12-12', 2, '3.390', '3.393', '2019-12-12 08:51:10', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(306, '2019-12-13', 2, '3.389', '3.393', '2019-12-13 08:50:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(307, '2019-12-14', 2, '3.389', '3.393', '2019-12-14 08:37:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(308, '2019-12-16', 2, '3.389', '3.393', '2019-12-16 10:30:41', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(310, '2019-12-17', 2, '3.355', '3.360', '2019-12-18 11:00:10', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(311, '2019-12-18', 2, '3.345', '3.349', '2019-12-18 11:00:25', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(313, '2019-12-19', 2, '3.336', '3.340', '2019-12-20 09:34:49', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(314, '2019-12-20', 2, '3.336', '3.340', '2019-12-20 09:35:03', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(315, '2019-12-21', 2, '3.335', '3.338', '2019-12-21 08:50:53', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(316, '2019-12-23', 2, '3.335', '3.338', '2019-12-23 08:58:24', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(317, '2019-12-24', 2, '3.321', '3.326', '2019-12-24 10:54:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(318, '2019-12-26', 2, '3.314', '3.320', '2019-12-26 08:43:29', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(319, '2019-12-27', 2, '3.314', '3.319', '2019-12-27 08:49:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(320, '2019-12-28', 2, '3.319', '3.322', '2019-12-28 08:44:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(321, '2019-12-30', 2, '3.320', '3.324', '2019-12-30 15:47:50', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(322, '2020-01-02', 2, '3.311', '3.317', '2020-01-02 10:58:59', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(323, '2020-01-03', 2, '3.301', '3.305', '2020-01-03 09:06:21', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(324, '2020-01-04', 2, '3.301', '3.305', '2020-01-04 08:47:16', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(325, '2020-01-06', 2, '3.308', '3.311', '2020-01-06 08:50:54', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(326, '2020-01-07', 2, '3.320', '3.323', '2020-01-07 11:49:44', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(327, '2020-01-08', 2, '3.325', '3.325', '2020-01-08 08:52:36', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(328, '2020-01-09', 2, '3.318', '3.320', '2020-01-09 08:53:27', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(329, '2020-01-10', 2, '3.319', '3.321', '2020-01-10 08:46:04', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(330, '2020-01-11', 2, '3.319', '3.321', '2020-01-11 08:52:31', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(331, '2020-01-13', 2, '3.321', '3.324', '2020-01-13 09:01:52', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(332, '2020-01-14', 2, '3.334', '3.336', '2020-01-14 10:57:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(333, '2020-01-15', 2, '3.328', '3.330', '2020-01-15 08:50:37', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(334, '2020-01-16', 2, '3.322', '3.327', '2020-01-16 10:13:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(335, '2020-01-17', 2, '3.321', '3.326', '2020-01-17 09:04:39', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(336, '2020-01-18', 2, '3.321', '3.326', '2020-01-18 08:58:43', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(337, '2020-01-20', 2, '3.319', '3.324', '2020-01-20 12:00:00', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(338, '2020-01-21', 2, '3.318', '3.323', '2020-01-21 09:00:21', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(339, '2020-01-22', 2, '3.317', '3.320', '2020-01-22 09:40:33', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(340, '2020-01-23', 2, '3.314', '3.317', '2020-01-23 08:58:38', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(341, '2020-01-24', 2, '3.320', '3.322', '2020-01-24 08:51:28', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(342, '2020-01-27', 2, '3.320', '3.325', '2020-01-27 08:53:01', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(343, '2020-01-25', 2, '3.320', '3.325', '2020-01-27 11:39:10', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(344, '2020-01-28', 2, '3.336', '3.339', '2020-01-28 09:07:15', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(345, '2020-01-29', 2, '3.332', '3.335', '2020-01-29 08:55:54', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(346, '2020-01-30', 2, '3.343', '3.345', '2020-01-30 08:54:45', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(347, '2020-01-31', 2, '3.359', '3.360', '2020-01-31 08:50:00', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(348, '2020-02-01', 2, '3.359', '3.360', '2020-02-01 12:28:02', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(349, '2020-02-03', 2, '3.373', '3.376', '2020-02-03 08:52:32', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(350, '2020-02-04', 2, '3.372', '3.374', '2020-02-04 09:00:35', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(351, '2020-02-05', 2, '3.360', '3.364', '2020-02-05 08:56:41', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(352, '2020-02-06', 2, '3.359', '3.360', '2020-02-06 08:57:20', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(353, '2020-02-07', 2, '3.369', '3.371', '2020-02-07 08:53:04', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(354, '2020-02-08', 2, '3.369', '3.371', '2020-02-08 08:48:38', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(355, '2020-02-10', 2, '3.385', '3.388', '2020-02-10 09:02:13', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(356, '2020-02-11', 2, '3.392', '3.394', '2020-02-11 09:24:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(357, '2020-02-12', 2, '3.387', '3.390', '2020-02-12 08:53:57', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(358, '2020-02-13', 2, '3.381', '3.383', '2020-02-13 08:48:19', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(359, '2020-02-14', 2, '3.383', '3.385', '2020-02-14 09:14:09', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(360, '2020-02-15', 2, '3.383', '3.385', '2020-02-15 08:46:56', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(361, '2020-02-17', 2, '3.380', '3.384', '2020-02-17 09:09:48', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(362, '2020-02-18', 2, '3.378', '3.384', '2020-02-18 09:39:23', 'angelica_chuquilin', '-', NULL, NULL, NULL, 1),
(363, '2020-04-07', 2, '3.383', '3.386', '2020-02-19 09:15:54', 'angelica_chuquilin', '-', '2020-04-07 20:32:52', 'admin', '-', 1),
(364, '2020-04-10', 2, '3.450', '3.850', '2020-04-10 16:19:56', 'admin', '-', NULL, NULL, NULL, 1),
(365, '2020-04-14', 2, '3.388', '3.389', '2020-04-14 13:27:51', 'admin', '-', NULL, NULL, NULL, 1),
(366, '2020-04-18', 2, '3.377', '3.379', '2020-04-18 01:31:01', 'admin', '-', NULL, NULL, NULL, 1),
(367, '2020-04-23', 2, '3.780', '3.880', '2020-04-23 20:04:34', 'admin', '-', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `trabajador`
--

CREATE TABLE `trabajador` (
  `idTrabajador` int(11) NOT NULL,
  `idEmpresa` int(11) NOT NULL,
  `idOficina` int(11) NOT NULL,
  `dni` char(8) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `apePaterno` varchar(50) NOT NULL,
  `apeMaterno` varchar(50) NOT NULL,
  `fechaNacimiento` date NOT NULL,
  `sexo` char(1) NOT NULL,
  `direccion` varchar(250) NOT NULL,
  `telefono` varchar(12) NOT NULL,
  `celular` varchar(9) NOT NULL,
  `email` varchar(100) NOT NULL,
  `idTipo` int(11) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` bit(1) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `trabajador`
--

INSERT INTO `trabajador` (`idTrabajador`, `idEmpresa`, `idOficina`, `dni`, `nombre`, `apePaterno`, `apeMaterno`, `fechaNacimiento`, `sexo`, `direccion`, `telefono`, `celular`, `email`, `idTipo`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, 1, '74658829', 'admin', 'admin', 'admin', '1995-03-10', 'M', '-', '-', '-', '-', 0, '2018-07-12 16:00:03', 'admin', '-', '2018-07-12 16:00:07', 'admin', '-', b'1'),
(2, 1, 1, '17982344', 'JACINTO', 'AGUSTIN', 'BACILIO', '2018-07-12', 'M', '-', '-', '-', '-', 8, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(3, 1, 1, '18903777', 'CÉSAR', 'ANGELES', 'MENDOZA', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(4, 1, 1, '80638700', 'HEBER JACINTO', 'CARDENAS', 'DEZA', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(5, 1, 1, '17816559', 'VICTOR', 'CARRANZA', 'SALAZAR', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(6, 1, 1, '18061605', 'FÉLIX', 'CASTILLO', 'REYES', '2018-07-12', 'M', 'AV TUPAC AMARU SN', '954311277', '954311277', 'felix@hotmail.com', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-12-18 12:09:45', 'admin', '-', b'1'),
(7, 1, 1, '18150929', 'JORGE LUIS', 'CHAVEZ', 'TERRONES', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(8, 1, 1, '40514487', 'GUILLERMO JEMMY', 'CHIGNE', 'PEREZ', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(9, 1, 1, '32107440', 'LUIS ALFONSO', 'CRUZADO', 'MUÑOZ', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(10, 1, 1, '47814819', 'LUIS VICTOR', 'FLORENTINO', 'MIGUEL', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(11, 1, 1, '40957067', 'LUIS NOE', 'HUANCA', 'OTINIANO', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(12, 1, 1, '18164291', 'HARRINSON JACK', 'LECCA', 'LAVADO', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(13, 1, 1, '80289658', 'MARCO ANTONIO', 'LECCA', 'LAVADO', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(14, 1, 1, '41771300', 'MEREGILDO', 'LEYVA', 'JICARO', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(15, 1, 1, '41429054', 'DANGNY ABILIO', 'MANTILLA', 'GONZALES', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(16, 1, 1, '17942146', 'LUIS', 'MARQUINA', 'CABRERA', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(17, 1, 1, '18191674', 'WALTER CESAR', 'MORILLAS', 'CAPAC', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(18, 1, 1, '18864121', 'EDGARDO HUMBERTO', 'NARRO', 'SIPIRAN', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(19, 1, 1, '40236592', 'ROGER AMADOR', 'NARRO', 'SIPIRAN', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(20, 1, 1, '19098636', 'JUAN MANUEL', 'RODRIGUEZ', 'MIGUEL', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(21, 1, 1, '42064129', 'MOISES', 'VALVERDE', 'HILARIO', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(22, 1, 1, '40086481', 'ELOY', 'VASQUEZ', 'ARMAS', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(23, 1, 1, '45651579', 'JHOJAN BADERICH', 'VASQUEZ', 'GUTIERREZ', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(24, 1, 1, '45419445', 'OSWALDO JAVIER', 'VEGA', 'VALENCIA', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(25, 1, 1, '19098372', 'LUCY VIRGINIA', 'ANTICONA', 'VALDIVIEZO', '2018-07-12', 'F', '-', '-', '-', '-', 10, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(26, 1, 1, '19189285', 'ANGELICA', 'CHUQUILIN', 'AZNARAN', '2018-07-12', 'F', '-', '-', '-', '-', 7, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(27, 1, 1, '18069099', 'CARLOS EDUARDO', 'SOLANO', 'YBAÑEZ', '2018-07-12', 'M', '-', '-', '-', '-', 5, '2018-07-12 16:01:10', 'admin', '-', '2018-07-12 16:01:14', 'admin', '-', b'1'),
(28, 1, 1, '18166912', 'LUIS VICENTE', 'ANTICONA', 'QUIROZ', '2018-07-12', 'M', '-', '-00000', '-000000', 'luis@hotmail.com', 5, '2018-07-12 16:01:10', 'admin', '-', '2019-02-06 16:39:15', 'angelica_chuquilin', '-', b'1'),
(29, 1, 1, '76686346', 'HUMBERTO', 'RODRIGUEZ', 'VERDE', '1994-12-05', 'M', 'URB. LOS PORTALES ETAPA II MZ H TRUJILLO', '', '', '', 5, '2018-12-05 12:51:40', 'admin', '-', '2018-12-05 12:51:40', '-', '-', b'1'),
(31, 1, 1, '19598679', 'PAUL ', 'VASQUEZ', 'MIRANDA', '2018-12-21', 'M', 'av tupac amaru 1500', '98975258', '98972515', 'Paul@hotmail.com', 5, '2018-12-26 18:51:17', 'admin', '-', '2018-12-28 11:40:01', 'admin', '-', b'1'),
(32, 1, 1, '18215458', 'ANA MARIA', 'ANTICONA', 'VALDIVIEZO', '1978-04-07', 'F', 'AV- TUPAC AMARU N°1500', '949662860', '949662860', 'aanticona@gmail.com', 2, '2018-12-27 17:16:13', 'admin', '-', '2018-12-27 17:16:13', '-', '-', b'1'),
(33, 1, 1, '00000000', 'JOSE ', 'HOLGUIN ', 'SANCHEZ', '2019-06-04', 'M', '00000000000000000', '000000000000', '000000000', 'jose@gmail.com', 5, '2019-06-27 10:33:53', 'angelica_chuquilin', '-', '2019-06-27 10:35:21', 'angelica_chuquilin', '-', b'1'),
(34, 1, 1, '19587525', 'LARRY', 'PORTAL', 'P', '1998-01-23', 'M', 'AV TUPAC AMARU 1500', '000000', '000000', 'larry@hotmail.com', 5, '2019-07-20 11:05:25', 'angelica_chuquilin', '-', '2019-07-20 11:05:25', '-', '-', b'1'),
(35, 1, 1, '19189287', 'LUIS', 'ANTICONA', 'QUIROZ', '1985-04-23', 'M', 'AV TUPAC AMARU 1500', '0000000', '0000000', 'luis@gmail.com', 3, '2019-07-25 11:04:13', 'angelica_chuquilin', '-', '2019-07-25 11:04:13', '-', '-', b'1'),
(36, 1, 1, '71630232', 'JULISSA EDITH', 'VARGAS', 'RODRIGUEZ', '2019-10-15', 'F', 'TRUJILLO EL PORVENIR MC 13', '978465646', '978465646', '', 7, '2019-11-23 12:08:57', 'admin', '-', '2019-11-23 12:09:11', 'admin', '-', b'1'),
(37, 1, 1, '71896523', 'EDWIN ', 'MANTILLA', 'VASQUES', '2019-01-10', 'M', 'TRUJILLO EL PORVENIR', '985266623', '', '', 5, '2019-11-27 09:46:21', 'angelica_chuquilin', '-', '2019-11-27 09:47:33', 'angelica_chuquilin', '-', b'1'),
(38, 1, 1, '78962362', 'TRICORZO S.A.', '0', '0', '2020-01-14', 'M', 'CAR.CENTRAL KM. 1 INT. 345 Z.I. INDUSTRIAL LIMA - LIMA - SANTA ANITA', '', '963336699', '', 4, '2020-01-20 16:38:12', 'angelica_chuquilin', '-', '2020-01-20 16:39:14', 'angelica_chuquilin', '-', b'1'),
(39, 1, 1, '74655456', 'Innovate', 'Perú', '8G', '2000-01-01', 'M', '-', '0', '0', 'contacto@innovate.pe', 1, '2020-02-25 00:01:20', 'admin', '-', '2020-02-25 00:01:20', '-', '-', b'1');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `unidad_movil`
--

CREATE TABLE `unidad_movil` (
  `idUnidad` int(11) NOT NULL,
  `tipo` int(11) NOT NULL,
  `placa` varchar(200) NOT NULL,
  `descripcion` varchar(300) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime NOT NULL,
  `registro_user_update` varchar(50) NOT NULL,
  `registro_pc_update` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuario`
--

CREATE TABLE `usuario` (
  `idUsuario` int(11) NOT NULL,
  `idTrabajador` int(11) NOT NULL,
  `idRol` int(11) NOT NULL,
  `login` varchar(50) NOT NULL,
  `pass` varchar(400) NOT NULL,
  `registro_fecha_add` datetime NOT NULL,
  `registro_user_add` varchar(50) NOT NULL,
  `registro_pc_add` varchar(50) NOT NULL,
  `registro_fecha_update` datetime DEFAULT NULL,
  `registro_user_update` varchar(50) DEFAULT NULL,
  `registro_pc_update` varchar(50) DEFAULT NULL,
  `activo` bit(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `usuario`
--

INSERT INTO `usuario` (`idUsuario`, `idTrabajador`, `idRol`, `login`, `pass`, `registro_fecha_add`, `registro_user_add`, `registro_pc_add`, `registro_fecha_update`, `registro_user_update`, `registro_pc_update`, `activo`) VALUES
(1, 1, 1, 'admin', '28b9189f77eebff832a359d8aa3e23ae', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', b'1'),
(2, 25, 2, 'lucy_anticona', 'e10adc3949ba59abbe56e057f20f883e', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', b'1'),
(3, 26, 3, 'angelica_chuquilin', 'e10adc3949ba59abbe56e057f20f883e', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', b'1'),
(4, 27, 4, 'carlos_solano', 'e10adc3949ba59abbe56e057f20f883e', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 19:50:29', 'admin', '-', b'1'),
(5, 28, 2, 'luis_anticona', 'e10adc3949ba59abbe56e057f20f883e', '2019-01-08 19:50:29', 'admin', '-', '2019-01-08 20:04:09', 'lucy_anticona', '-', b'1'),
(6, 36, 3, 'julissa_vargas', 'fcea920f7412b5da7be0cf42b8c93759', '2019-11-23 12:09:58', 'admin', '', '2019-11-23 12:10:35', 'julissa_vargas', '-', b'1'),
(7, 39, 5, 'innovateperu', 'f2793efa0a6cc4fcaa5e778baac01916', '2020-02-25 00:01:42', 'admin', '', '2020-02-25 00:01:42', '', '', b'1');

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `almacen`
--
ALTER TABLE `almacen`
  ADD PRIMARY KEY (`idAlmacen`);

--
-- Indices de la tabla `catalogo_proveedor`
--
ALTER TABLE `catalogo_proveedor`
  ADD PRIMARY KEY (`idCatalogo`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idProveedor` (`idProveedor`);

--
-- Indices de la tabla `categoria`
--
ALTER TABLE `categoria`
  ADD PRIMARY KEY (`idCategoria`);

--
-- Indices de la tabla `ciudades`
--
ALTER TABLE `ciudades`
  ADD PRIMARY KEY (`idCiudades`),
  ADD KEY `Paises_Codigo` (`Paises_Codigo`);

--
-- Indices de la tabla `clase`
--
ALTER TABLE `clase`
  ADD PRIMARY KEY (`idClase`),
  ADD KEY `idSubcategoria` (`idSubcategoria`);

--
-- Indices de la tabla `cliente`
--
ALTER TABLE `cliente`
  ADD PRIMARY KEY (`idCliente`);

--
-- Indices de la tabla `cliente_contacto`
--
ALTER TABLE `cliente_contacto`
  ADD PRIMARY KEY (`idClienteContacto`),
  ADD KEY `idCliente` (`idCliente`);

--
-- Indices de la tabla `compra`
--
ALTER TABLE `compra`
  ADD PRIMARY KEY (`idCompra`),
  ADD KEY `idOrdenCompra` (`idOrdenCompra`),
  ADD KEY `idProveedor` (`idProveedor`);

--
-- Indices de la tabla `contacto`
--
ALTER TABLE `contacto`
  ADD PRIMARY KEY (`idContacto`);

--
-- Indices de la tabla `cotizacion`
--
ALTER TABLE `cotizacion`
  ADD PRIMARY KEY (`idCotizacion`),
  ADD KEY `idProveedor` (`idProveedor`),
  ADD KEY `idGrupoCotizacion` (`idGrupoCotizacion`);

--
-- Indices de la tabla `cronograma_pago_venta`
--
ALTER TABLE `cronograma_pago_venta`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_documento_venta_cronograma_idx` (`documento_venta_id`);

--
-- Indices de la tabla `detalle_compra`
--
ALTER TABLE `detalle_compra`
  ADD PRIMARY KEY (`idDetalleCompra`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idCompra` (`idCompra`),
  ADD KEY `idPresentacion` (`idPresentacion`);

--
-- Indices de la tabla `detalle_cotizacion`
--
ALTER TABLE `detalle_cotizacion`
  ADD PRIMARY KEY (`idDetalleCotizacion`,`descuentoUnitarioA`,`valorVenta`,`valorVentaA`,`descuentoTotal`,`descuentoTotalA`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idCotizacion` (`idCotizacion`),
  ADD KEY `idPresentacion` (`idPresentacion`);

--
-- Indices de la tabla `detalle_documento_venta`
--
ALTER TABLE `detalle_documento_venta`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_documento_venta_producto_idx` (`documento_venta_id`),
  ADD KEY `fk_producto_doc_venta_idx` (`producto_id`);

--
-- Indices de la tabla `detalle_grupo`
--
ALTER TABLE `detalle_grupo`
  ADD PRIMARY KEY (`idDetalleGrupo`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idGrupoOrden` (`idGrupoOrden`),
  ADD KEY `idPresentacion` (`idPresentacion`),
  ADD KEY `idProveedorR` (`idProveedorR`),
  ADD KEY `idProveedorC` (`idProveedorC`);

--
-- Indices de la tabla `detalle_grupocotizacion`
--
ALTER TABLE `detalle_grupocotizacion`
  ADD PRIMARY KEY (`idDetalleGrupo`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idGrupoCotizacion` (`idGrupoCotizacion`),
  ADD KEY `idPresentacion` (`idPresentacion`),
  ADD KEY `idProveedorR` (`idProveedorR`),
  ADD KEY `idProveedorC` (`idProveedorC`);

--
-- Indices de la tabla `detalle_nota_almacen`
--
ALTER TABLE `detalle_nota_almacen`
  ADD PRIMARY KEY (`idDetaNota`),
  ADD KEY `idNotaAlmacen` (`idNotaAlmacen`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idPresentacion` (`idPresentacion`);

--
-- Indices de la tabla `detalle_orden`
--
ALTER TABLE `detalle_orden`
  ADD PRIMARY KEY (`idDetalleOrden`),
  ADD KEY `idOrdenCompra` (`idOrdenCompra`),
  ADD KEY `idProducto` (`idProducto`),
  ADD KEY `idPresentacion` (`idPresentacion`);

--
-- Indices de la tabla `detalle_orden_mantenimiento`
--
ALTER TABLE `detalle_orden_mantenimiento`
  ADD PRIMARY KEY (`idDetaOrden`);

--
-- Indices de la tabla `detalle_orden_servicio`
--
ALTER TABLE `detalle_orden_servicio`
  ADD PRIMARY KEY (`idDetaOrden`);

--
-- Indices de la tabla `documento_venta`
--
ALTER TABLE `documento_venta`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `empaque`
--
ALTER TABLE `empaque`
  ADD PRIMARY KEY (`idEmpaque`);

--
-- Indices de la tabla `empresa`
--
ALTER TABLE `empresa`
  ADD PRIMARY KEY (`idEmpresa`);

--
-- Indices de la tabla `forma_pago`
--
ALTER TABLE `forma_pago`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `grupo`
--
ALTER TABLE `grupo`
  ADD PRIMARY KEY (`idGrupo`);

--
-- Indices de la tabla `grupo_cotizacion`
--
ALTER TABLE `grupo_cotizacion`
  ADD PRIMARY KEY (`idGrupoCotizacion`);

--
-- Indices de la tabla `grupo_ordencompra`
--
ALTER TABLE `grupo_ordencompra`
  ADD PRIMARY KEY (`idGrupoOrden`);

--
-- Indices de la tabla `igv`
--
ALTER TABLE `igv`
  ADD PRIMARY KEY (`idIGV`);

--
-- Indices de la tabla `multitabla`
--
ALTER TABLE `multitabla`
  ADD PRIMARY KEY (`idMultitabla`);

--
-- Indices de la tabla `multitabla_load`
--
ALTER TABLE `multitabla_load`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `nota_almacen`
--
ALTER TABLE `nota_almacen`
  ADD PRIMARY KEY (`idNotaAlmacen`),
  ADD KEY `idAlmacen` (`idAlmacen`),
  ADD KEY `idOrdenCompra` (`idCompra`),
  ADD KEY `idOrdenMantenimiento` (`idOrdenMantenimiento`),
  ADD KEY `idOrdenServicio` (`idOrdenServicio`),
  ADD KEY `idUnidad` (`idUnidad`);

--
-- Indices de la tabla `oficina`
--
ALTER TABLE `oficina`
  ADD PRIMARY KEY (`idOficina`);

--
-- Indices de la tabla `orden_compra`
--
ALTER TABLE `orden_compra`
  ADD PRIMARY KEY (`idOrdenCompra`),
  ADD KEY `idCotizacion` (`idCotizacion`),
  ADD KEY `idProveedor` (`idProveedor`);

--
-- Indices de la tabla `orden_mantenimiento`
--
ALTER TABLE `orden_mantenimiento`
  ADD PRIMARY KEY (`idOrdenMantenimiento`),
  ADD KEY `idTrabajador` (`idTrabajador`);

--
-- Indices de la tabla `orden_servicio`
--
ALTER TABLE `orden_servicio`
  ADD PRIMARY KEY (`idOrdenServicio`);

--
-- Indices de la tabla `pais`
--
ALTER TABLE `pais`
  ADD PRIMARY KEY (`idPais`);

--
-- Indices de la tabla `periodo`
--
ALTER TABLE `periodo`
  ADD PRIMARY KEY (`idPeriodo`);

--
-- Indices de la tabla `persona`
--
ALTER TABLE `persona`
  ADD PRIMARY KEY (`idPersona`),
  ADD KEY `idUbigeo` (`idUbigeo`);

--
-- Indices de la tabla `plan_contable`
--
ALTER TABLE `plan_contable`
  ADD PRIMARY KEY (`codigo`);

--
-- Indices de la tabla `presentacion`
--
ALTER TABLE `presentacion`
  ADD PRIMARY KEY (`idPresentacion`),
  ADD KEY `idClase` (`idClase`);

--
-- Indices de la tabla `producto`
--
ALTER TABLE `producto`
  ADD PRIMARY KEY (`idProducto`),
  ADD KEY `idClase` (`idClase`);

--
-- Indices de la tabla `proveedor`
--
ALTER TABLE `proveedor`
  ADD PRIMARY KEY (`idProveedor`);

--
-- Indices de la tabla `proveedor_load`
--
ALTER TABLE `proveedor_load`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `rol`
--
ALTER TABLE `rol`
  ADD PRIMARY KEY (`idRol`);

--
-- Indices de la tabla `rol_oficina`
--
ALTER TABLE `rol_oficina`
  ADD PRIMARY KEY (`idRolOficina`),
  ADD KEY `idRol` (`idRol`),
  ADD KEY `idOficina` (`idOficina`);

--
-- Indices de la tabla `rol_tarea`
--
ALTER TABLE `rol_tarea`
  ADD PRIMARY KEY (`idRolTarea`),
  ADD KEY `idRol` (`idRol`),
  ADD KEY `idTarea` (`idTarea`);

--
-- Indices de la tabla `subcategoria`
--
ALTER TABLE `subcategoria`
  ADD PRIMARY KEY (`idSubcategoria`),
  ADD KEY `idCategoria` (`idCategoria`);

--
-- Indices de la tabla `subservicio`
--
ALTER TABLE `subservicio`
  ADD PRIMARY KEY (`idSubservicio`);

--
-- Indices de la tabla `tarea`
--
ALTER TABLE `tarea`
  ADD PRIMARY KEY (`idTarea`),
  ADD KEY `idGrupo` (`idGrupo`);

--
-- Indices de la tabla `tasa_cambio`
--
ALTER TABLE `tasa_cambio`
  ADD PRIMARY KEY (`idTasaCambio`);

--
-- Indices de la tabla `trabajador`
--
ALTER TABLE `trabajador`
  ADD PRIMARY KEY (`idTrabajador`),
  ADD KEY `idEmpresa` (`idEmpresa`),
  ADD KEY `idOficina` (`idOficina`);

--
-- Indices de la tabla `unidad_movil`
--
ALTER TABLE `unidad_movil`
  ADD PRIMARY KEY (`idUnidad`);

--
-- Indices de la tabla `usuario`
--
ALTER TABLE `usuario`
  ADD PRIMARY KEY (`idUsuario`),
  ADD KEY `idPersona` (`idTrabajador`),
  ADD KEY `idRol` (`idRol`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `almacen`
--
ALTER TABLE `almacen`
  MODIFY `idAlmacen` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT de la tabla `catalogo_proveedor`
--
ALTER TABLE `catalogo_proveedor`
  MODIFY `idCatalogo` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=72;
--
-- AUTO_INCREMENT de la tabla `categoria`
--
ALTER TABLE `categoria`
  MODIFY `idCategoria` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `ciudades`
--
ALTER TABLE `ciudades`
  MODIFY `idCiudades` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;
--
-- AUTO_INCREMENT de la tabla `clase`
--
ALTER TABLE `clase`
  MODIFY `idClase` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=42;
--
-- AUTO_INCREMENT de la tabla `cliente`
--
ALTER TABLE `cliente`
  MODIFY `idCliente` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;
--
-- AUTO_INCREMENT de la tabla `cliente_contacto`
--
ALTER TABLE `cliente_contacto`
  MODIFY `idClienteContacto` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;
--
-- AUTO_INCREMENT de la tabla `compra`
--
ALTER TABLE `compra`
  MODIFY `idCompra` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1023;
--
-- AUTO_INCREMENT de la tabla `contacto`
--
ALTER TABLE `contacto`
  MODIFY `idContacto` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=192;
--
-- AUTO_INCREMENT de la tabla `cotizacion`
--
ALTER TABLE `cotizacion`
  MODIFY `idCotizacion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT de la tabla `cronograma_pago_venta`
--
ALTER TABLE `cronograma_pago_venta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;
--
-- AUTO_INCREMENT de la tabla `detalle_compra`
--
ALTER TABLE `detalle_compra`
  MODIFY `idDetalleCompra` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2086;
--
-- AUTO_INCREMENT de la tabla `detalle_cotizacion`
--
ALTER TABLE `detalle_cotizacion`
  MODIFY `idDetalleCotizacion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;
--
-- AUTO_INCREMENT de la tabla `detalle_documento_venta`
--
ALTER TABLE `detalle_documento_venta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;
--
-- AUTO_INCREMENT de la tabla `detalle_grupo`
--
ALTER TABLE `detalle_grupo`
  MODIFY `idDetalleGrupo` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT de la tabla `detalle_grupocotizacion`
--
ALTER TABLE `detalle_grupocotizacion`
  MODIFY `idDetalleGrupo` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=64;
--
-- AUTO_INCREMENT de la tabla `detalle_nota_almacen`
--
ALTER TABLE `detalle_nota_almacen`
  MODIFY `idDetaNota` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5894;
--
-- AUTO_INCREMENT de la tabla `detalle_orden`
--
ALTER TABLE `detalle_orden`
  MODIFY `idDetalleOrden` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2543;
--
-- AUTO_INCREMENT de la tabla `detalle_orden_mantenimiento`
--
ALTER TABLE `detalle_orden_mantenimiento`
  MODIFY `idDetaOrden` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3491;
--
-- AUTO_INCREMENT de la tabla `detalle_orden_servicio`
--
ALTER TABLE `detalle_orden_servicio`
  MODIFY `idDetaOrden` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2376;
--
-- AUTO_INCREMENT de la tabla `documento_venta`
--
ALTER TABLE `documento_venta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;
--
-- AUTO_INCREMENT de la tabla `empaque`
--
ALTER TABLE `empaque`
  MODIFY `idEmpaque` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `empresa`
--
ALTER TABLE `empresa`
  MODIFY `idEmpresa` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT de la tabla `forma_pago`
--
ALTER TABLE `forma_pago`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;
--
-- AUTO_INCREMENT de la tabla `grupo`
--
ALTER TABLE `grupo`
  MODIFY `idGrupo` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;
--
-- AUTO_INCREMENT de la tabla `grupo_cotizacion`
--
ALTER TABLE `grupo_cotizacion`
  MODIFY `idGrupoCotizacion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;
--
-- AUTO_INCREMENT de la tabla `grupo_ordencompra`
--
ALTER TABLE `grupo_ordencompra`
  MODIFY `idGrupoOrden` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT de la tabla `igv`
--
ALTER TABLE `igv`
  MODIFY `idIGV` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `multitabla`
--
ALTER TABLE `multitabla`
  MODIFY `idMultitabla` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=288;
--
-- AUTO_INCREMENT de la tabla `multitabla_load`
--
ALTER TABLE `multitabla_load`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=63;
--
-- AUTO_INCREMENT de la tabla `nota_almacen`
--
ALTER TABLE `nota_almacen`
  MODIFY `idNotaAlmacen` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2979;
--
-- AUTO_INCREMENT de la tabla `oficina`
--
ALTER TABLE `oficina`
  MODIFY `idOficina` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `orden_compra`
--
ALTER TABLE `orden_compra`
  MODIFY `idOrdenCompra` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1485;
--
-- AUTO_INCREMENT de la tabla `orden_mantenimiento`
--
ALTER TABLE `orden_mantenimiento`
  MODIFY `idOrdenMantenimiento` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=969;
--
-- AUTO_INCREMENT de la tabla `orden_servicio`
--
ALTER TABLE `orden_servicio`
  MODIFY `idOrdenServicio` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=828;
--
-- AUTO_INCREMENT de la tabla `periodo`
--
ALTER TABLE `periodo`
  MODIFY `idPeriodo` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT de la tabla `persona`
--
ALTER TABLE `persona`
  MODIFY `idPersona` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `presentacion`
--
ALTER TABLE `presentacion`
  MODIFY `idPresentacion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1696;
--
-- AUTO_INCREMENT de la tabla `producto`
--
ALTER TABLE `producto`
  MODIFY `idProducto` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1522;
--
-- AUTO_INCREMENT de la tabla `proveedor`
--
ALTER TABLE `proveedor`
  MODIFY `idProveedor` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=192;
--
-- AUTO_INCREMENT de la tabla `proveedor_load`
--
ALTER TABLE `proveedor_load`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=71;
--
-- AUTO_INCREMENT de la tabla `rol`
--
ALTER TABLE `rol`
  MODIFY `idRol` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `rol_oficina`
--
ALTER TABLE `rol_oficina`
  MODIFY `idRolOficina` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT de la tabla `rol_tarea`
--
ALTER TABLE `rol_tarea`
  MODIFY `idRolTarea` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=115;
--
-- AUTO_INCREMENT de la tabla `subcategoria`
--
ALTER TABLE `subcategoria`
  MODIFY `idSubcategoria` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `subservicio`
--
ALTER TABLE `subservicio`
  MODIFY `idSubservicio` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=836;
--
-- AUTO_INCREMENT de la tabla `tarea`
--
ALTER TABLE `tarea`
  MODIFY `idTarea` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=42;
--
-- AUTO_INCREMENT de la tabla `tasa_cambio`
--
ALTER TABLE `tasa_cambio`
  MODIFY `idTasaCambio` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=368;
--
-- AUTO_INCREMENT de la tabla `trabajador`
--
ALTER TABLE `trabajador`
  MODIFY `idTrabajador` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=40;
--
-- AUTO_INCREMENT de la tabla `unidad_movil`
--
ALTER TABLE `unidad_movil`
  MODIFY `idUnidad` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=86;
--
-- AUTO_INCREMENT de la tabla `usuario`
--
ALTER TABLE `usuario`
  MODIFY `idUsuario` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `cronograma_pago_venta`
--
ALTER TABLE `cronograma_pago_venta`
  ADD CONSTRAINT `fk_documento_venta_cronograma` FOREIGN KEY (`documento_venta_id`) REFERENCES `documento_venta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `detalle_documento_venta`
--
ALTER TABLE `detalle_documento_venta`
  ADD CONSTRAINT `fk_documento_venta_producto` FOREIGN KEY (`documento_venta_id`) REFERENCES `documento_venta` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_producto_doc_venta` FOREIGN KEY (`producto_id`) REFERENCES `producto` (`idProducto`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `detalle_nota_almacen`
--
ALTER TABLE `detalle_nota_almacen`
  ADD CONSTRAINT `fk_idNotaAlmacen` FOREIGN KEY (`idNotaAlmacen`) REFERENCES `nota_almacen` (`idNotaAlmacen`),
  ADD CONSTRAINT `fk_idPresentacion` FOREIGN KEY (`idPresentacion`) REFERENCES `presentacion` (`idPresentacion`),
  ADD CONSTRAINT `fk_idProducto` FOREIGN KEY (`idProducto`) REFERENCES `producto` (`idProducto`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
