DROP PROCEDURE IF EXISTS sp_buscarProducto;
delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_buscarProducto`(IN `p_idProducto` INT, IN `p_busqueda` VARCHAR(50), IN `p_tipo` INT, IN `p_tipoOperacion` INT)
BEGIN   
	IF p_tipoOperacion = 1 THEN 	  		
		SELECT 
			P.idProducto,             
            CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria, CA.nombre as 'categoria', S.idSubCategoria, S.nombre as 'subcategoria',
			P.idClase,  C.nombre as 'clase',
            P.marca, P.modelo, P.medida, P.cod_fab, P.stockActual, P.unidad_medida,
            P.tipo_existencia, P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria       
        WHERE (S.idSubCategoria = p_tipo OR p_tipo = 0) 
			AND ( (P.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR ( CONCAT(C.abreviatura, P.codigo) LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.marca LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.modelo LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.cod_fab LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (C.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (S.nombre like concat('%', p_busqueda, '%') OR p_busqueda = ''))
            and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre asc;
	END IF;     
    IF p_tipoOperacion = 2 THEN  				
		SELECT  
			DC.idPresentacion,              
            P.cantidad,
            M.abrev,
			P.nombre, 
			C.idProveedor, 
            PR.nombreEmpresa,
			DC.precioUnitario, 
            DATE_FORMAT(C.fechaEnvio, '%d/%m/%Y') as 'fechaCompra'
		FROM COMPRA C
		INNER JOIN DETALLE_COMPRA DC ON DC.idCompra = C.idCompra
		INNER JOIN PRESENTACION P ON P.idPresentacion = DC.idPresentacion
        INNER JOIN PROVEEDOR PR ON PR.idProveedor = C.idProveedor
        INNER JOIN MULTITABLA M ON M.abrev = P.idUnidadMedida
		WHERE DC.idProducto = p_idProducto and M.dep_id = 3 
        ORDER BY idPresentacion desc;
    END	IF;
    IF p_tipoOperacion = 3 THEN 	  		SELECT 
			P.idProducto,             CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria, CA.nombre as 'categoria', S.idSubCategoria, S.nombre as 'subcategoria',
			P.idClase,  C.nombre as 'clase',
            P.marca, P.modelo, P.medida, P.cod_fab, P.stockActual, 
            P.unidad_medida as idUnidadMedida,  M.descripcion as unidadMedida,
            P.tipo_existencia, P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria     
        INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
        WHERE (S.idSubCategoria = p_tipo OR p_tipo = 0) 
			AND ( (P.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR ( CONCAT(C.abreviatura, P.codigo) LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.marca LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.modelo LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (P.cod_fab LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (C.nombre LIKE concat('%', p_busqueda, '%') OR p_busqueda = '')
            OR (S.nombre like concat('%', p_busqueda, '%') OR p_busqueda = ''))
            and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre asc;
	END IF;     
END
$