DROP PROCEDURE IF EXISTS sp_mostrarDetaOrden;
delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarDetaOrden`(IN `p_idDetalleOrden` INT, IN `p_idOrdenCompra` INT, IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN   				
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
			OD.precioUnitario,
            OD.precioUnitarioA,
			OD.cantidad,
            OD.cantidadAceptada,
            OD.cantidadRechazada,
            OD.cantidadReenviada,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,   
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.urgencia AND M.dep_id = 6)
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND OD.estado in ('P', 'EN')
			AND OD.cantidad>(OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN   		
		SELECT 
			OD.idDetalleOrden,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadOrdenada',
            OD.valorUnitario,
            OD.descuentoUnitario,
            OD.precioUnitario ,
            (OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)) * OD.precioUnitario as precioTotal
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND OD.estado in ('P', 'EN')
			AND OD.cantidad>(OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada)
		ORDER BY OD.idDetalleOrden ASC;
    END	IF;
    
    IF p_tipoOperacion = 3 THEN   		
		SELECT 
			OD.idDetalleOrden,
			OD.idProducto,
            CONCAT(CL.abreviatura, P.codigo) AS 'codigoProducto',
			P.nombre AS 'producto',
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
			OD.precioUnitario,
            OD.precioUnitarioA,
			OD.cantidad,
            OD.cantidadAceptada,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,
            CONCAT( OD.cantidadTotal, ' ', OD.unidadMedida) as cantidadTotalA2,
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadCotizada' ,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.urgencia AND M.dep_id = 6)
		WHERE OD.idOrdenCompra = p_idOrdenCompra and OD.estado in ('P','C')
				AND OD.cantidadAceptada > 0
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 4 THEN   		
		SELECT 
			OD.idDetalleOrden,
            P.codigo AS 'codigoProducto',
			P.nombre AS 'producto',
			PR.nombre AS 'presentacion',
            OD.cantidadAceptada,
            OD.cantidadRechazada,
            OD.cantidadReenviada,
            M.descripcion AS 'descripEstado'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON (M.abrev = OD.estado AND M.dep_id = 7)
		WHERE OD.idOrdenCompra = p_idOrdenCompra and OD.estado in ('P','C')
		ORDER BY OD.idDetalleOrden ASC;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN   		
		SELECT 
			OD.idDetalleOrden,
			OC.idOrdenCompra,
			OC.correlativo,
			OD.idProducto,
			CONCAT(CL.abreviatura, P.codigo) AS 'codigoProducto',
			OD.nombreProducto,
			OD.idPresentacion,
			PR.nombre AS 'presentacion',
            OD.valorUnitario,
            OD.valorUnitarioA,
            OD.descuentoUnitario,
            OD.descuentoUnitarioA,
			OD.precioUnitario,
            OD.precioUnitarioA,
            OD.descuentoUnitario * ( (100 + OC.igv)/100.0) as descuentoUnitarioIGV,
			OD.cantidad,
            OD.cantidadAceptada,
            OD.valorVenta,
            OD.valorVentaA,
            OD.descuentoTotal,
            OD.descuentoTotalA,
			OD.monto,
            OD.montoA,
			OD.cantidadTotal,         
            OD.cantidadTotalA,   
			OD.urgencia,
            OD.cantidad - (OD.cantidadAceptada + OD.cantidadRechazada + OD.cantidadReenviada) as 'cantidadOrdenada' ,
                        CASE WHEN PR.nombre = '-' then OD.unidadMedida
				else PR.nombre end as unidadMedida,
            M.descripcion AS 'descripUrgencia'
		FROM DETALLE_ORDEN OD
		INNER JOIN PRODUCTO P ON P.idProducto = OD.idProducto
        INNER JOIN CLASE CL ON CL.idClase = P.idClase
		INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = OD.idOrdenCompra
		INNER JOIN PRESENTACION PR ON PR.idPresentacion = OD.idPresentacion
        INNER JOIN MULTITABLA M ON M.abrev = OD.urgencia
		WHERE OD.idOrdenCompra = p_idOrdenCompra AND M.dep_id = 6 
		ORDER BY OD.idOrdenCompra ASC;
    END	IF;
    
    IF p_tipoOperacion = 6 THEN   		
		SELECT 
			estadoRecepcion
		FROM ORDEN_COMPRA 
        WHERE idOrdenCompra = p_idOrdenCompra;
    END	IF;
    
    IF p_tipoOperacion = 7 THEN   		
		SELECT 
			DC.idDetalleOrden, DC.idOrdenCompra, DC.idProducto, P.codigo as codigoProducto, DC.nombreProducto, 
            DC.idPresentacion, DC.nombrePresentacion,
            DC.precioUnitario, DC.cantidad, DC.monto, cantidadTotal, CONCAT( DC.cantidadTotal, ' ', DC.unidadMedida) as cantidadTotal2,
            idUnidadMedida, unidadMedida, urgencia
		FROM DETALLE_ORDEN DC
        INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto
        WHERE idOrdenCompra = p_idOrdenCompra;	
    END	IF;
    
    IF p_tipoOperacion = 8 THEN   		
		SELECT 
			DC.idDetalleOrden, DC.idOrdenCompra, DC.idProducto, P.nombre as 'nombreProducto',  
            DC.idPresentacion, PR.nombre as 'nombrePresentacion',             DC.valorUnitario, DC.descuentoUnitario, DC.precioUnitario, DC.cantidad, DC.monto, cantidadTotal,               PR.idUnidadMedida as 'idUnidadMedida', PR.cantidad as 'cantidad_unidades', 
            DC.unidadMedida, DC.urgencia
		FROM DETALLE_ORDEN DC
        INNER JOIN PRODUCTO P ON P.idProducto = DC.idProducto	
        INNER JOIN PRESENTACION PR ON PR.idPresentacion = DC.idPresentacion
        WHERE idDetalleOrden = p_idDetalleOrden;		
    END	IF;
END
$
