var idCliente = 0;
$(document).ready(function () {
    sdx.setGestion("gestionarCliente");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlCliente');
    obtenerConfiguracionesIniciales();
    configurarValidacionFormularioCliente();
    listarClientes();
});

function gestionarCliente(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesIniciales':
                responseObtenerConfiguracionesIniciales(response.data);
                break;
            case 'registrarCliente':
                responseRegistrarCliente(response.data);
                break;
            case 'listarClientes':
                responseListarClientes(response.data);
                break;
            case 'obtenerDatosCliente':
                responseObtenerDatosCliente(response.data);
                break;
            case 'eliminarCliente':
                responseEliminarCliente(response.data);
                break;
        }
    }
}

function obtenerConfiguracionesIniciales() {
    sdx.setControllerFunction('obtenerConfiguracionesIniciales');
    sdx.addParamTmp('depIdTipoCliente', 28);
    sdx.addParamTmp('depIdTipoDocumento', 29);
    sdx.procesar();
}

function responseObtenerConfiguracionesIniciales(data) {
    dibujarSelectForm('cboTipoCliente', 'valor', 'descripcion', data.tipoCliente);
    asignarValorSelectFrom('cboTipoCliente', 2);
    dibujarSelectForm('cboTipoDocumento', 'valor', 'descripcion', data.tipoDocumento);
}

function listarClientes() {
    sdx.setControllerFunction('listarClientes');
    sdx.procesar();
}

function responseListarClientes(data) {
    if (!isEmpty(data)) {
        $('#page-length-option').DataTable().destroy();
        $('#cuerpoTablaCliente').html(data);
        $('#page-length-option').DataTable({
            "language": idioma_espanol,
            "dom": "<'row' <'form-inline' "
                    + "<'col-sm-6 col-md-6 col-lg-6'B>"
                    + "<'col-sm-6 col-md-6 col-lg-6'f>>>"
                    + "<rt>"
                    + "<'row'<'form-inline'"
                    + "<'col-sm-6 col-md-6 col-lg-6'l>"
                    + "<'col-sm-6 col-md-6 col-lg-6'p>>>",
            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "order": [[0, "desc"]]
        });
    } else {
        $('#cuerpoTablaCliente').empty();
    }
}

function registrarCliente() {
    var validarForm = $('#formValidate').valid();
    if (validarForm) {
        var razonSocial = '';
        var nombre = '';
        var apePaterno = '';
        var apeMaterno = '';
        var nroDoc = '';
        var direccion = '';
        var referencia = '';
        var email = '';

        var tipoCliente = $('#cboTipoCliente').val();
        var tipoDoc = $('#cboTipoDocumento').val();
        nroDoc = $('#txtNroDocumento').val();
        direccion = $('#txtDireccion').val();
        referencia = $('#txtReferencia').val();
        email = $('#txtEmail').val();

        if (tipoCliente * 1 == 2) {
            razonSocial = $('#txtRazonSocial').val();
        } else {
            nombre = $('#txtNombre').val();
            apePaterno = $('#txtApePaterno').val();
            apeMaterno = $('#txtApeMaterno').val();
        }

        sdx.setControllerFunction('registrarCliente');
        sdx.addParamTmp('idCliente', idCliente);
        sdx.addParamTmp('tipoCliente', tipoCliente);
        sdx.addParamTmp('razonSocial', razonSocial);
        sdx.addParamTmp('nombre', nombre);
        sdx.addParamTmp('apePaterno', apePaterno);
        sdx.addParamTmp('apePaterno', apePaterno);
        sdx.addParamTmp('apeMaterno', apeMaterno);
        sdx.addParamTmp('tipoDoc', tipoDoc);
        sdx.addParamTmp('nroDoc', nroDoc);
        sdx.addParamTmp('direccion', direccion);
        sdx.addParamTmp('referencia', referencia);
        sdx.addParamTmp('email', email);
        sdx.procesar();
    }
}

function responseRegistrarCliente(data) {
    if (!isEmpty(data.idCliente)) {
        mostrarAlerta(data.mensaje, 'green');
        listarClientes();
        $('#modalCliente').modal('close');
    } else {
        mostrarAlerta(data.mensaje, 'green');
    }
}

function editarCliente(id) {
    sdx.setControllerFunction('obtenerDatosCliente');
    sdx.addParamTmp('idCliente', id);
    sdx.procesar();
}

function responseObtenerDatosCliente(data) {
    if (!isEmpty(data)) {
        abrirModalNuevoCliente();
        idCliente = data[0].idCliente;
        asignarValorSelectFrom('cboTipoCliente', data[0].idTipoCliente);
        asignarValorSelectFrom('cboTipoDocumento', data[0].idTipoDocumento);

        verificarTipoCliente();

        $('#txtNroDocumento').val(data[0].documento);
        $('#txtDireccion').val(data[0].direccion);
        $('#txtReferencia').val(data[0].referencia);
        $('#txtEmail').val(data[0].email);

        if (data[0].idTipoCliente * 1 == 2) {
            $('#txtRazonSocial').val(data[0].razonSocial);
        } else {
            $('#txtNombre').val(data[0].nombre);
            $('#txtApePaterno').val(data[0].apellidoPaterno);
            $('#txtApeMaterno').val(data[0].apellidoMaterno);
        }
        $('#formValidate input').siblings('label').addClass('active');
        $('#tituloModal').html('Editar cliente ' + data[0].codigoCliente);
    }
}

function abrirAlerta(id, codigo) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el cliente " + codigo + " !",
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarCliente');
            sdx.addParamTmp('idCliente', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarCliente(data) {
    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        listarClientes();
    } else {
        swal("Error al eliminar el cliente !", {
            icon: "error"
        });
    }
}

function verificarTipoCliente() {
    var tipo = $('#cboTipoCliente').val();
    if (tipo * 1 == 1) {
        $('.classEmpresa').hide();
        $('.classPersona').show();
    } else {
        $('.classEmpresa').show();
        $('.classPersona').hide();
    }
}

function abrirModalNuevoCliente(v) {
    !isEmpty(v) ? $('#tituloModal').html('Registrar cliente') : '';
    !isEmpty(v) ? $('#formValidate input').siblings('label').removeClass('active') : '';
    limpiarModalCliente();
    $('.modal').modal();
    $('#modalCliente').modal('open');
}

function limpiarModalCliente() {
    idCliente = 0;
    asignarValorSelectFrom('cboTipoCliente', 2);
    $('#txtRazonSocial').val('');
    $('#txtNombre').val('');
    $('#txtApePaterno').val('');
    $('#txtApeMaterno').val('');
    asignarValorSelectFrom('cboTipoDocumento', null);
    $('#txtNroDocumento').val('');
    $('#txtDireccion').val('');
    $('#txtReferencia').val('');
    $('#txtEmail').val('');
    $('#formValidate input').removeClass('valid');
    verificarTipoCliente();
}

function configurarValidacionFormularioCliente() {
    $('select[required]').css({
        position: 'absolute',
        display: 'inline',
        height: 0,
        padding: 0,
        border: '1px solid rgba(255,255,255,0)',
        width: 0
    });

    $("#formValidate").validate({
        rules: {
            cboTipoCliente: {
                required: true
            },
            txtRazonSocial: {
                required: true
//                minlength: 5
            },
            txtNombre: {
                required: true
            },
            txtApePaterno: {
                required: true
            },
            txtApeMaterno: {
                required: true
            },
            cboTipoDocumento: {
                required: true
            },
            txtNroDocumento: {
                required: true
            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            cboTipoCliente: {
                required: "Seleccione el tipo de cliente"
            },
            txtRazonSocial: {
                required: "Ingrese la razón social"
//                minlength: "Enter at least 5 characters"
            },
            txtNombre: {
                required: "Ingrese el nombre"
            },
            txtApePaterno: {
                required: "Ingrese el apellido paterno"
            },
            txtApeMaterno: {
                required: "Ingrese el apellido materno"
            },
            cboTipoDocumento: {
                required: "Seleccione el tipo de documento"
            },
            txtNroDocumento: {
                required: "Ingrese el número de documento"
            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}
