var audio = document.getElementById("alertaAudio");
$(document).ready(function () {
    sdx.setGestion("gestionarCronograma");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlCronogramaPago');
    listarCronogramas();
});

function gestionarCronograma(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'listarCronogramas':
                responseListarCronogramas(response.data);
                break;
            case 'eliminarCronograma':
                responseEliminarCronograma(response.data);
                break;
        }
    }
}

function listarCronogramas() {
    sdx.setControllerFunction('listarCronogramas');
    sdx.procesar();
}

function responseListarCronogramas(data) {
    if (!isEmpty(data.tabla)) {
        $('#page-length-option').DataTable().destroy();
        $('#cuerpoTablaCronograma').html(data.tabla);
        $('#page-length-option').DataTable({
            "language": idioma_espanol,
            "dom": "<'row' <'form-inline' "
                    + "<'col-sm-6 col-md-6 col-lg-6'B>"
                    + "<'col-sm-6 col-md-6 col-lg-6'f>>>"
                    + "<rt>"
                    + "<'row'<'form-inline'"
                    + "<'col-sm-6 col-md-6 col-lg-6'l>"
                    + "<'col-sm-6 col-md-6 col-lg-6'p>>>",
            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "order": [[3, "desc"]]
        });
    } else {
        $('#cuerpoTablaCronograma').empty();
    }
    if (data.activarAlarma == 1) {
        playAlarma();
    }
}

function editarCliente(id, fechaInstalacion, fechaPago, monto) {
    var titulo = 'Editar';
    var url = URL_BASE + "view/Mantenedores/cronogramaPagoForm.php?winTitulo=" + titulo + "&id=" + id + "&fechaInstalacion=" + fechaInstalacion + "&fechaPago=" + fechaPago + "&monto=" + monto;
    cargarDiv(url);
}

function nuevoCronograma() {
    var url = URL_BASE + "view/Mantenedores/cronogramaPagoForm.php";
    cargarDiv(url);
}

function abrirAlerta(id, codigo, mes, anio) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el cronograma del cliente " + codigo + " !",
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarCronograma');
            sdx.addParamTmp('mes', mes);
            sdx.addParamTmp('anio', anio);
            sdx.addParamTmp('idCliente', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarCronograma(data) {
    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        listarCronogramas();
    } else {
        swal("Error al eliminar el cronograma !", {
            icon: "error"
        });
    }
}

function playAlarma() {
    audio.play();
}

function stopAlarma() {
    audio.pause();
}