/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
var id = document.getElementById("id").value;
var title = document.getElementById("winTitulo").value;
var fechaInstalacion = document.getElementById("fechaInstalacion").value;
var fechaPago = document.getElementById("fechaPago").value;
var monto = document.getElementById("monto").value;
$(document).ready(function () {
    if (id != "") {
        $('#tituloFromCronograma').html(title + ' cronograma pago');
    } else {
        id = 0;
    }
    sdx.setGestion("gestionarCronogramaForm");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlCronogramaPago');
    iniciarConfiguraciones();
    obtenerConfiguracionesInicialesForm();
    configurarFormulario();
});

function gestionarCronogramaForm(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesInicialesForm':
                responseObtenerConfiguracionesInicialesForm(response.data);
                break;
            case 'guardarCronograma':
                responseGuardarCronograma(response.data);
                break;
        }
    }
}

function obtenerConfiguracionesInicialesForm() {
    sdx.setControllerFunction('obtenerConfiguracionesInicialesForm');
    sdx.procesar();
}

function responseObtenerConfiguracionesInicialesForm(data) {

    dibujarSelect2Form('cboCliente', 'id', 'descripcion', data.dataClientes);
    if (id != 0) {
        asignarValorSelectFrom('cboCliente', id);
        asignarValorDatepicker('txtFechaInstalacion', fechaInstalacion);
        asignarValorDatepicker('txtFechaPago', fechaPago);
        $('#txtMonto').val(monto);
        $('#formValidateCrono input').siblings('label').addClass('active');
    }
}

function guardarCronograma() {
    var validarForm = $('#formValidateCrono').valid();
    if (validarForm) {
        var arrClientes = $('#cboCliente').val();
        var fechaInstalacion = $('#txtFechaInstalacion').val();
        var fechaPago = $('#txtFechaPago').val();
        var monto = $('#txtMonto').val();
        sdx.setControllerFunction('guardarCronograma');
        sdx.addParamTmp('arrClientes', arrClientes);
        sdx.addParamTmp('fechaInstalacion', fechaInstalacion);
        sdx.addParamTmp('fechaPago', fechaPago);
        sdx.addParamTmp('monto', monto);
        sdx.procesar();
    }
}

function responseGuardarCronograma(data) {
    if (data.success * 1 == 1) {
        mostrarAlerta(data.mensaje, 'green');
        regresar();
    } else {
        mostrarAlerta(data.mensaje, 'red');
    }
}

function regresar() {
    var url = URL_BASE + "view/Mantenedores/cronogramaPago.php";
    cargarDiv(url);
}

function configurarFormulario() {
    $("#formValidateCrono").validate({
        rules: {
            cboCliente: {
                required: true
            },
            txtFechaInstalacion: {
                required: true
            },
            txtFechaPago: {
                required: true
            },
            txtMonto: {
                required: true
            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            cboCliente: {
                required: "Debe seleccionar cliente"
            },
            txtFechaInstalacion: {
                required: "Seleccionar fecha de instalación"
            },
            txtFechaPago: {
                required: "Seleccionar fecha de pago"
            },
            txtMonto: {
                required: "Seleccionar monto"
            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}

function iniciarConfiguraciones() {
    $(".select2").select2({
        dropdownAutoWidth: true,
        width: '100%',
    });

    $('.datepicker').datepicker({
        format: 'dd/mm/yyyy',
        autoClose: true,
    });
}