var divPDF = document.getElementById('divPDF');
var id = document.getElementById("id").value;
var title = document.getElementById("winTitulo").value;

$(document).ready(function () {
    sdx.setGestion("gestionarControlPagoForm");
    sdx.setContainer('controlProcesos');
    sdx.setController('ControlControlPago');

    if (id != "") {
        $('#tituloFromPago').html(title + ' pago');
    } else {
        id = 0;
    }

    iniciarConfiguraciones();
    obtenerConfiguracionesForm();
    configurarValidacionFormularioPago();
});

function gestionarControlPagoForm(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesForm':
                responseObtenerConfiguracionesForm(response.data);
                break;
            case 'guardarPago':
                responseGuardarPago(response.data);
                break;
        }
    }
}

function obtenerConfiguracionesForm() {
    sdx.setControllerFunction('obtenerConfiguracionesForm');
    sdx.addParamTmp('id', id);
    sdx.procesar();
}

function responseObtenerConfiguracionesForm(data) {

    dibujarSelectForm('cboBanco', 'valor', 'descripcion', data.dataBancos);
    if (!isEmpty(data.dataCliente)) {
        $('#nombreCliente').html('Cliente: ' + data.dataCliente.nombre_completo);
        $('#documentoCliente').html('Nro. documento: ' + data.dataCliente.documento);
        $('#txtIdCliente').val(data.dataCliente.idCliente);
        $('#periodoDeudaInicio').html('Desde: <b>' + formatoFechaMostrar(data.dataCliente.fecha_pago_inicio) + '</b>');
        $('#periodoDeudaFin').html('hasta:  <b>' + formatoFechaMostrar(data.dataCliente.fecha_pago_fin) + '</b>');
        $('#hMes').html('Pago : ' + verificarMes(data.dataCliente.periodo) + ' - ' + data.dataCliente.anio);
        $('#txtMes').val(data.dataCliente.periodo);
        $('#txtAnio').val(data.dataCliente.anio);
        $('#txtDeste').val(data.dataCliente.fecha_pago_inicio);
        $('#txtHasta').val(data.dataCliente.fecha_pago_fin);
    }else{
        regresarListaPagos();
        mostrarAlerta('No tiene cronograma de pago !', 'red');
    }
    if (id != 0) {
        asignarValorDatepicker('txtFechaPago', formatoFechaMostrar(data.dataPago[0].fecha_pago));
        $('#txtNroOperacion').val(data.dataPago[0].numero_operacion);
        $('#txtMonto').val(parseFloat(data.dataPago[0].monto).toFixed(2));
        $('#txtComentario').val(data.dataPago[0].comentario);
        $('#formValidatePago input').siblings('label').addClass('active');
        $('#formValidatePago textarea').siblings('label').addClass('active');
    }
}

function guardarPago() {
    var validarForm = $('#formValidatePago').valid();
    if (validarForm) {
        swal({
            title: "Enviando el pago !",
            text: "Cargando...",
            closeOnClickOutside: false,
            buttons: false
        });
        var fechaPago = $('#txtFechaPago').val();
        var nroOperacion = $('#txtNroOperacion').val();
        var monto = $('#txtMonto').val();
        var comentario = $('#txtComentario').val();
        var idCliente = $('#txtIdCliente').val();

        var mes = $('#txtMes').val();
        var anio = $('#txtAnio').val();

        var banco = $('#cboBanco').val();

        var inicio = $('#txtDeste').val();
        var fin = $('#txtHasta').val();

        sdx.setControllerFunction('guardarPago');
        sdx.addParamTmp('id', id);
        sdx.addParamTmp('fechaPago', fechaPago);
        sdx.addParamTmp('nroOperacion', nroOperacion);
        sdx.addParamTmp('monto', monto);
        sdx.addParamTmp('comentario', comentario);
        sdx.addParamTmp('idCliente', idCliente);
        sdx.addParamTmp('mes', mes);
        sdx.addParamTmp('anio', anio);
        sdx.addParamTmp('banco', banco);
        sdx.addParamTmp('inicio', inicio);
        sdx.addParamTmp('fin', fin);
        sdx.procesar();
    }
}

function responseGuardarPago(data) {
    if (data.success * 1 == 1) {
        mostrarAlerta(data.mensaje, 'green');
        $('#tituloFromPago').html('Recibo de pago');
        imprimirReciboPfd(data.idPago);
        $('.classRegistro').hide();
        swal.close();
    } else {
        mostrarAlerta(data.mensaje, 'red');
        regresarListaPagos();
        swal.close();
    }
}

function imprimirReciboPfd(id) {
    divPDF.style.display = "block";
    var url = URL_BASE + 'view/Procesos/imprimirReciboPago.php?id=' + id;
    var pdf = '<embed src="' + url + '" type="application/pdf"  style="width: 100%; height:650px;"></embed>';
    $('#pdfEmbebido').html(pdf);
}

function regresarListaPagos() {
    var url = URL_BASE + "view/Procesos/controlPago.php";
    cargarDiv(url);
}

function iniciarConfiguraciones() {
    $('.datepicker').datepicker({
        format: 'dd/mm/yyyy',
        autoClose: true,
    });

    $('#cboMes').formSelect();
    $('#cboAnio').formSelect();
}

function verificarMes(mes) {
    var descripcionMes = '';
    switch (mes * 1) {
        case 1:
            descripcionMes = 'Enero';
            break;
        case 2:
            descripcionMes = 'Febrero';
            break;
        case 3:
            descripcionMes = 'Marzo';
            break;
        case 4:
            descripcionMes = 'Abril';
            break;
        case 5:
            descripcionMes = 'Mayo';
            break;
        case 6:
            descripcionMes = 'Junio';
            break;
        case 7:
            descripcionMes = 'Julio';
            break;
        case 8:
            descripcionMes = 'Agosto';
            break;
        case 9:
            descripcionMes = 'Septiembre';
            break;
        case 10:
            descripcionMes = 'Octbre';
            break;
        case 11:
            descripcionMes = 'Noviembre';
            break;
        case 12:
            descripcionMes = 'Diciembre';
            break;
    }
    return descripcionMes;
}

function configurarValidacionFormularioPago() {
    $("#formValidatePago").validate({
        rules: {
            txtFechaPago: {
                required: true
            },
            txtMonto: {
                required: true
            },
//            txtComentario: {
//                required: true
//            },
//            cboBanco: {
//                required: true
//            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            txtFechaPago: {
                required: "Seleccione fecha de pago"
            },
            txtMonto: {
                required: "Ingrese el monto"
            },
//            txtComentario: {
//                required: "Ingrese un comentario"
//            },
//            cboBanco: {
//                required: "Seleccionar banco"
//            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}
