var divPDF = document.getElementById('divPDF');
$(document).ready(function () {
    sdx.setGestion("gestionarControlPago");
    sdx.setContainer('controlReportes');
    sdx.setController('ControlReportePagos');
    listarReportePagos();
    iniciarConfiguraciones();
});

function gestionarControlPago(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'listarReportePagos':
                responseListarReportePagos(response.data);
                break;
            case 'exportarPDF':
                responseExportarPDF(response.data);
                break;
        }
    }
}

function listarReportePagos() {
    var fechaInicio = $('#txtFechaInicio').val();
    var fechaFin = $('#txtFechaFin').val();
    sdx.setControllerFunction('listarReportePagos');
    sdx.addParamTmp('fechaInicio', fechaInicio);
    sdx.addParamTmp('fechaFin', fechaFin);
    sdx.procesar();
}

function responseListarReportePagos(data) {
    if (!isEmpty(data)) {
        $('#scroll-vert-hor').DataTable().destroy();
        $('#cuerpoTablaRP').html(data);
        $('#scroll-vert-hor').DataTable({
            "language": idioma_espanol,
            dom: 'Bfrtlp',
//            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "scrollX": true
        });
    } else {
        $('#cuerpoTablaRP').empty();
    }
}

function limpiarFiltros() {
    asignarValorDatepicker('txtFechaInicio', '');
    asignarValorDatepicker('txtFechaFin', '');
    listarReportePagos();
}

function exportarPDF() {
    swal({
        title: "Generando reporte PDF",
        text: "Cargando...",
        closeOnClickOutside: false,
        buttons: false
    });
    var fechaInicio = $('#txtFechaInicio').val();
    var fechaFin = $('#txtFechaFin').val();
    sdx.setControllerFunction('exportarPDF');
    sdx.addParamTmp('fechaInicio', fechaInicio);
    sdx.addParamTmp('fechaFin', fechaFin);
    sdx.procesar();
}

function responseExportarPDF(data) {
    if (!isEmpty(data) && data != 0) {
        var url = data.url;
        window.open(URL_BASE + "view/Reportes/formatosPDF/" + data.nombre);
        setTimeout(function () {
            eliminarArchivo(url);
        }, 5000);
    } else {
        mostrarAlerta('Error al exportar PDF', 'red');
    }
    swal.close();
}

function eliminarArchivo(url) {
    sdx.setControllerFunction('eliminarPdf');
    sdx.addParamTmp('url', url);
    sdx.procesar();
}

function iniciarConfiguraciones() {
    $('.datepicker').datepicker({
        format: 'dd/mm/yyyy',
        autoClose: true,
    });
}
