var id = document.getElementById("id").value;
var title = document.getElementById("winTitulo").value;
$(document).ready(function () {
    sdx.setGestion("gestionarUsuarioForm");
    sdx.setContainer('controlSeguridad');
    sdx.setController('ControlUsuario');
    obtenerConfiguracionesIniciales();
    iniciarConfiguraciones();
    configurarValidacionFormularioUsuario();

    if (id != "") {
        $('#tituloFromUsuario').html(title + ' usuario');
    } else {
        id = 0;
    }
});

function gestionarUsuarioForm(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesIniciales':
                responseObtenerConfiguracionesIniciales(response.data);
                break;
            case 'guardarUsuario':
                responseGuardarUsuario(response.data);
                break;
        }
    }
}

function obtenerConfiguracionesIniciales() {
    sdx.setControllerFunction('obtenerConfiguracionesIniciales');
    sdx.addParamTmp('id', id);
    sdx.procesar();
}

function responseObtenerConfiguracionesIniciales(data) {

    dibujarSelect2('cboCliente', 'id', 'descripcion', data.dataClientes);
    dibujarSelect2('cboRol', 'idRol', 'nombre', data.dataRol);
    if (id != 0) {
        asignarValorSelect2('cboCliente', data.dataUsuario[0].idCliente);
        asignarValorSelect2('cboRol', data.dataUsuario[0].idRol);
        $('#txtUsuario').val(data.dataUsuario[0].login);
        $('#formValidateUsuario input').siblings('label').addClass('active');
    }
}

function guardarUsuario() {
   
    var validarForm = $('#formValidateUsuario').valid();
    if (validarForm) {
        var cliente = $('#cboCliente').val();
        var rol = $('#cboRol').val();
        var usuario = $('#txtUsuario').val();
        var pass = $('#txtPassword').val();

        sdx.setControllerFunction('guardarUsuario');
        sdx.addParamTmp('id', id);
        sdx.addParamTmp('cliente', cliente);
        sdx.addParamTmp('rol', rol);
        sdx.addParamTmp('usuario', usuario);
        sdx.addParamTmp('pass', pass);
        sdx.procesar();
    }
}

function responseGuardarUsuario(data) {
    if (data.success * 1 == 1) {
        mostrarAlerta(data.mensaje, 'green');
        regresarListaUsuarios();
    } else {
        mostrarAlerta(data.mensaje, 'red');
    }
}

function regresarListaUsuarios() {
    var url = URL_BASE + "view/Seguridad/usuario.php";
    cargarDiv(url);
}

function configurarValidacionFormularioUsuario() {
    $("#formValidateUsuario").validate({
        rules: {
            cboCliente: {
                required: true
            },
            txtUsuario: {
                required: true
            },
            cboRol: {
                required: true
            },
            txtPassword: {
                required: true
            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            cboCliente: {
                required: "Seleccione un cliente"
            },
            txtUsuario: {
                required: "Ingrese el usuario"
            },
            cboRol: {
                required: "Seleccione un rol"
            },
            txtPassword: {
                required: "Ingrese el password"
            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}

function iniciarConfiguraciones() {
    $("#cboCliente").select2({
        dropdownAutoWidth: true,
        width: '100%',
        placeholder: "Cliente"
    });
    $("#cboRol").select2({
        dropdownAutoWidth: true,
        width: '100%',
        placeholder: "Rol"
    });
}