<?php

include_once '../../model/conexion.php';

class Usuario_model {

    private $param = array();
    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function gestionar($param) {
        $this->param = $param;
        switch ($this->param['param_opcion']) {
            case 'iniciarSesion':
                echo $this->iniciarSesion();
                break;
            case 'mostrarMenu':
                echo $this->mostrarMenu();
                break;
            case 'mostrarUsuarios':
                echo $this->mostrarUsuarios();
                break;
            case 'insert':
                echo $this->insert();
                break;
            case 'obtener':
                echo $this->obtener();
                break;
            case 'update':
                echo $this->update();
                break;
            case 'resetear':
                echo $this->resetear();
                break;
            case 'eliminar':
                echo $this->eliminar();
                break;
            case 'actualizarUsuario':
                echo $this->actualizarUsuario();
                break;
        }
    }

    private function iniciarSesion() {
        $sql = "CALL sp_controlUsuario(";
        $sql .= "'" . $this->param['param_usuario'] . "', ";
        $sql .= "'" . $this->param['param_pass'] . "', ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila['respuesta'];
        }

        if ($respuesta == '1') {
            $sql = "CALL sp_controlUsuario(";
            $sql .= "'" . $this->param['param_usuario'] . "', ";
            $sql .= "'" . $this->param['param_pass'] . "', ";
            $sql .= "2)";
            $this->con->cerrarAbrir();
            $datos = $this->con->consultaRetorno($sql);
            while ($fila = mysqli_fetch_array($datos)) {
                $_SESSION['idUsuario'] = $fila['idUsuario'];
                $_SESSION['usuario_id_cp'] = $fila['usuario_id_cp'];
//                $_SESSION['nombre'] = $fila['nombre'];
//                $_SESSION['apePaterno'] = $fila['apePaterno'];
//                $_SESSION['nombreCompleto'] = $fila['nombre'] . " " . $fila['apePaterno'];
                $_SESSION['usuario'] = $fila['login'];
            }
            return 1;
        } else {
            return $respuesta;
        }
    }

    private function mostrarMenu() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarMenu(";
        $sql .= "" . $_SESSION['idUsuario'] . ", ";
        $sql .= "1,";
        $sql .= "1)";

        $tabla = '';

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $tabla .= '<li>';
            $tabla .= '<a>';
            $tabla .= '<i class="fa fa-home"></i>';
            $tabla .= $fila['nombre'];
            $tabla .= '<span class="fa fa-chevron-down"></span>';
            $tabla .= '</a>';
            $tabla .= '<ul class = "nav child_menu">';
            $tabla .= '<li><a href="">gege</a></li>';
            $tabla .= '<li><a href="">gege</a></li>';
            $tabla .= '</ul>';
            $tabla .= '</li>';
            /* $tabla .= "<li>";
              $tabla .= "<a>";
              $tabla .= "<i class='fa fa-home'></i>";
              $tabla = "".$fila['nombre']."";
              $tabla .= "<span class='fa fa-chevron-down'></span>";
              $tabla .= "</a>";
              $tabla .= "<ul class = 'nav child_menu'>";

              $idGru = $respGRU[0];
              $consultaTAREAS = "SELECT DISTINCT TAREA.idTarea, Tarea.nombre, TAREA.url  FROM TAREA INNER JOIN ROL_TAREA ON ROL_TAREA.idTarea = TAREA.idTarea INNER JOIN ROL ON ROL.idRol = ROL_TAREA.idRol INNER JOIN ROL_USUARIO ON ROL_USUARIO.idRol = ROL.idRol INNER JOIN USUARIO ON USUARIO.idUsuario = ROL_USUARIO.idUsuario WHERE ROL_USUARIO.idUsuario = $idUsser and USUARIO.activo = 1 and TAREA.idGrupo = $idGru";
              $datos2 = $con->consultaRetorno($consultaTAREAS);

              while ($respTAR = mysqli_fetch_row($datos2)) {
              echo '<li><a href="'.$respTAR[2].'">'.$respTAR[1].'</a></li>';
              }

              $tabla .= "</ul>";
              $tabla .= "</li>"; */
        }

        return $tabla;
    }

    private function mostrarUsuarios() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarUsuarios(";
        $sql .= "1,";
        $sql .= "1)";

        $tabla = "";
        $cont = 0;
        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $cont = $cont + 1;
            $tabla .= "<tr>";
            $tabla .= "<td class='alinearCentro'>" . $cont . "</td>";
            $tabla .= "<td class='alinearIzquierda'>" . $fila["nombre"] . "</td>";
            $tabla .= "<td class='alinearCentro'>" . $fila["dni"] . "</td>";
            $tabla .= "<td class='alinearIzquierda'>" . $fila["rol"] . "</td>";
            $tabla .= "<td class='alinearIzquierda'>" . $fila["login"] . "</td>";
            $tabla .= "<td class='alinearCentro'>" . $fila["activo"] . "</td>";
            $tabla .= "<th class='alinearCentro'>
                    			<a href='#modalUpdate' data-toggle='modal' class='btn btn-success btn-xs' onclick='obtener(" . $fila["idUsuario"] . ")'><i class='fa fa-pencil' title='Editar Usuario.'></i>  </a>

								<a href='#modalResetear' data-toggle='modal' class='btn btn-warning btn-xs' onclick='obtenerId(" . $fila["idUsuario"] . ")' title='Resetear contraseña.'><i class='fa fa-refresh'></i> </a>

                    			<a href='#modalEliminar' data-toggle='modal' class='btn btn-danger btn-xs' onclick='obtenerId(" . $fila["idUsuario"] . ")' title='Eliminar Usuario.'><i class='fa fa-trash-o'></i> </a>
                    			</th>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    private function insert() {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateUsuario(";
        $sql .= "1, ";
        $sql .= "" . $this->param['param_idTrabajador'] . ", ";
        $sql .= "" . $this->param['param_idRol'] . ", ";
        $sql .= "'" . $this->param['param_usuario'] . "', ";
        $sql .= "'" . $this->param['param_pass'] . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "" . $this->param['param_activo'] . ", ";
        $sql .= "1) ";


        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila['respuesta'];
        }

        return $respuesta;
    }

    private function obtener() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarUsuarios(";
        $sql .= "" . $this->param['param_idUsuario'] . ", ";
        $sql .= "3)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            return json_encode($fila);
        }
    }

    private function update() {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateUsuario(";
        $sql .= "" . $this->param['param_idUsuario'] . ", ";
        $sql .= "" . $this->param['param_idTrabajador'] . ", ";
        $sql .= "" . $this->param['param_idRol'] . ", ";
        $sql .= "'" . $this->param['param_usuario'] . "', ";
        $sql .= "'" . $this->param['param_pass'] . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "" . $this->param['param_activo'] . ", ";
        $sql .= "2) ";


        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila['respuesta'];
        }

        return $respuesta;
    }

    private function resetear() {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateUsuario(";
        $sql .= "" . $this->param['param_idUsuario'] . ", ";
        $sql .= "0, ";
        $sql .= "0, ";
        $sql .= "'', ";
        $sql .= "'', ";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "1, ";
        $sql .= "4) ";

        $tipoRespuesta = 0;
        $respuesta = "";
        try {
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $tipoRespuesta = $fila["tipoRespuesta"];
                    $respuesta = $fila["respuesta"];
                }

                $resp = array(
                    'success' => $tipoRespuesta,
                    'mensaje' => $respuesta
                );
            } else {
                $resp = array(
                    'success' => 0,
                    'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql
                );
            }
        } catch (Exception $e) {
            $resp = array(
                'success' => 0,
                'mensaje' => 'ERROR: ' . $e->getMessage()//$this->con->error
            );
        }

        return json_encode($resp);
    }

    private function eliminar() {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarUsuario(";
        $sql .= "" . $this->param['param_idUsuario'] . ", ";
        $sql .= "1)";

        $this->con->consultaSimple($sql);

        return 1;
    }

    private function actualizarUsuario() {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateUsuario(";
        $sql .= "" . $_SESSION["idUsuario"] . ", ";
        $sql .= "0, ";
        $sql .= "0, ";
        $sql .= "'" . $this->param['param_passActual'] . "', ";
        $sql .= "'" . $this->param['param_pass'] . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "'" . $_SESSION['usuario'] . "',";
        $sql .= "1, ";
        $sql .= "3) ";

        $tipoRespuesta = 0;
        $respuesta = "";
        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $tipoRespuesta = $fila["tipoRespuesta"];
            $respuesta = $fila["respuesta"];
        }

        $resp = array(
            'success' => $tipoRespuesta,
            'mensaje' => $respuesta
        );

        return json_encode($resp);
    }

}

?>