<?php

include_once '../../model/modelMantenedores/ModelCliente.php';

class NegocioCliente {

    public function obtenerConfiguracionesIniciales($paramEnviar) {
        $depIdCliente = $paramEnviar['depIdTipoCliente'];
        $depIdDocumento = $paramEnviar['depIdTipoDocumento'];
        $result->tipoCliente = $this->obtenerComboMultitabla($depIdCliente);
        $result->tipoDocumento = $this->obtenerComboMultitabla($depIdDocumento);
        return $result;
    }

    public function obtenerComboMultitabla($depIdCliente) {
        $data = new ModelCliente();
        return $data->obtenerComboMultitabla($depIdCliente);
    }

    public function listarClientes() {
        $data = new ModelCliente();
        $arrDatos = $data->listarClientes();

        $tabla = "";
        foreach ($arrDatos as $key => $value) {
            $tabla .= "<tr>";
            $tabla .= "<td>" . $value["codigoCliente"] . "</td>";
            $tabla .= "<td>" . $value["tipo_cliente_descripcion"] . "</td>";
            $tabla .= "<td>" . $value["razonSocial"] . "</td>";
            $tabla .= "<td>" . $value["tipo_documento_descripcion"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["documento"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["desActivo"] . "</td>";
            $tabla .= "<td style='text-align: center;'><a title='Editar' onclick='editarCliente(" . $value["idCliente"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #ffea00;'>edit</i></a>";
            $tabla .= "<a title='Eliminar' onclick='abrirAlerta(" . $value["idCliente"] . ",\"" . $value["codigoCliente"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a></td>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    public function registrarCliente($paramEnviar) {
        $idCliente = $paramEnviar['idCliente'];
        $tipoCliente = $paramEnviar['tipoCliente'];
        $razonSocial = $paramEnviar['razonSocial'];
        $nombre = $paramEnviar['nombre'];
        $apePaterno = $paramEnviar['apePaterno'];
        $apeMaterno = $paramEnviar['apeMaterno'];
        $tipoDoc = $paramEnviar['tipoDoc'];
        $nroDoc = $paramEnviar['nroDoc'];
        $direccion = $paramEnviar['direccion'];
        $referencia = $paramEnviar['referencia'];
        $email = $paramEnviar['email'];

        $data = new ModelCliente();
        return $data->registrarCliente($idCliente, $tipoCliente, $razonSocial, $nombre, $apePaterno, $apeMaterno, $tipoDoc, $nroDoc, $direccion, $referencia, $email);
    }

    public function obtenerDatosCliente($paramEnviar) {
        $idCliente = $paramEnviar['idCliente'];
        $data = new ModelCliente();
        return $data->obtenerDatosCliente($idCliente);
    }

    public function eliminarCliente($paramEnviar) {
        $idCliente = $paramEnviar['idCliente'];
        $data = new ModelCliente();
        return $data->eliminarCliente($idCliente);
    }

}
