<?php

include_once '../../model/modelMantenedores/ModeloVehiculo.php';
include_once '../../util/ClassUtil.php';

class NegocioVehiculo {

    const MOTOR = 1;
    const CORONA = 2;
    const BUJIAS = 3;
    const FRENOS = 4;
    const ZAPATAS = 5;
    const INYECTORES = 6;

    public function obtenerConfiguracionesMantenimiento() {
        $result->dataTipoMant = $this->obtenerTiposMantenimiento();
        return $result;
    }

    public function obtenerTiposMantenimiento($id) {
        $data = new ModeloVehiculo();
        return $data->obtenerTiposMantenimiento($id);
    }

    public function obtenerConfiguracionesInicialesForm($paramEnviar) {
        $id = $paramEnviar['id'];
        $result->dataVehiculo = $this->obtenerDatosVehiculo($id);
        $result->dataMantenimiento = $this->obtenerDatosTipoMantenimiento($id);
        return $result;
    }

    public function obtenerDatosVehiculo($id) {
        $data = new ModeloVehiculo();
        return $data->obtenerDatosVehiculo($id);
    }

    public function obtenerDatosTipoMantenimiento($id) {
        $data = new ModeloVehiculo();
        return $data->obtenerDatosTipoMantenimiento($id);
    }

    public function guardarVehiculo($paramEnviar) {
        $id = $paramEnviar['id'];
        $placa = $paramEnviar['placa'];
        $marca = $paramEnviar['marca'];
        $modelo = $paramEnviar['modelo'];
        $serie = $paramEnviar['serie'];
        $km = $paramEnviar['km'];
        $motor = $paramEnviar['motor'];
        $corona = $paramEnviar['corona'];
        $bujias = $paramEnviar['bujias'];
        $frenos = $paramEnviar['frenos'];
        $zapatas = $paramEnviar['zapatas'];
        $inyectores = $paramEnviar['inyectores'];
        $cambioMotor = $km + $motor;
        $cambioCorona = $km + $corona;
        $cambioBujias = $km + $bujias;
        $cambioFrenos = $km + $frenos;
        $cambioZapatas = $km + $zapatas;
        $cambioInyectores = $km + $inyectores;
        $data = new ModeloVehiculo();
        $res = $data->guardarVehiculo($id, $placa, $marca, $modelo, $serie, $km, $cambioMotor, $cambioCorona, $cambioBujias, $cambioFrenos, $cambioZapatas, $cambioInyectores);
        if (!ClassUtil::isEmpty($res['id'])) {
            $result = $this->guardarTiposMantenimiento($res['id'], self::MOTOR, $motor);
            $result = $this->guardarTiposMantenimiento($res['id'], self::CORONA, $corona);
            $result = $this->guardarTiposMantenimiento($res['id'], self::BUJIAS, $bujias);
            $result = $this->guardarTiposMantenimiento($res['id'], self::FRENOS, $frenos);
            $result = $this->guardarTiposMantenimiento($res['id'], self::ZAPATAS, $zapatas);
            $result = $this->guardarTiposMantenimiento($res['id'], self::INYECTORES, $inyectores);
        } else {
            $resp = array('success' => 0, 'mensaje' => 'Error al registrar el vehículo');
        }

        return $res;
    }

    public function guardarTiposMantenimiento($id, $tipo, $km) {
        $data = new ModeloVehiculo();
        return $data->guardarTiposMantenimiento($id, $tipo, $km);
    }

    public function listarVehiculos() {
        $data = new ModeloVehiculo();
        $arrVehiculos = $data->listarVehiculos();

        $tabla = "";
        foreach ($arrVehiculos as $key => $value) {

            $menorValor = $this->buscarMenorValor($value["km_motor"], $value["km_corona"], $value["km_bujias"], $value["km_frenos"], $value["km_zapatas"], $value["km_inyectores"]);

            $tabla .= "<tr>";
            $tabla .= "<td style='text-align: center;'>" . $value["codigo_vehiculo"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["placa"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["marca"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["modelo"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["serie"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["km"] . "</td>";
            if ($menorValor == $value["km_motor"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d'>" . $value["km_motor"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_motor"] . "</td>";
            }
            if ($menorValor == $value["km_corona"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d''>" . $value["km_corona"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_corona"] . "</td>";
            }
            if ($menorValor == $value["km_bujias"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d''>" . $value["km_bujias"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_bujias"] . "</td>";
            }
            if ($menorValor == $value["km_frenos"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d''>" . $value["km_frenos"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_frenos"] . "</td>";
            }
            if ($menorValor == $value["km_zapatas"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d''>" . $value["km_zapatas"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_zapatas"] . "</td>";
            }
            if ($menorValor == $value["km_inyectores"]) {
                $tabla .= "<td style='text-align: center; background: #ffb74d''>" . $value["km_inyectores"] . "</td>";
            } else {
                $tabla .= "<td style='text-align: center;'>" . $value["km_inyectores"] . "</td>";
            }
            $tabla .= "<td style='text-align: center;'>";
            $tabla .= "<a title='Dar mantenimiento' onclick='mantenimiento(" . $value["id"] . ",\"" . $value["codigo_vehiculo"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #8e24aa;'>build</i></a>&nbsp;";
            $tabla .= "<a title='Editar' onclick='editarVehiculo(" . $value["id"] . ",\"" . $value["codigo_vehiculo"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #ffea00;'>edit</i></a>&nbsp;";
            $tabla .= "<a title='Eliminar' onclick='abrirAlerta(" . $value["id"] . ",\"" . $value["placa"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a>";
            $tabla .= "</td>";
            $tabla .= "</tr>";
        }

        $respuesta->tabla = $tabla;
        return $respuesta;
    }

    public function buscarMenorValor($km_motor, $km_corona, $km_bujias, $km_frenos, $km_zapatas, $km_inyectores) {
        $arrKm = array($km_motor, $km_corona, $km_bujias, $km_frenos, $km_zapatas, $km_inyectores);
        sort($arrKm);
        return $arrKm[0];
    }

    public function eliminarVehiculo($paramEnviar) {
        $id = $paramEnviar['id'];
        $data = new ModeloVehiculo();
        return $data->eliminarVehiculo($id);
    }

    public function guardarMantenimiento($paramEnviar) {
        $idVehiculo = $paramEnviar['idVehiculo'];
        $taller = $paramEnviar['taller'];
        $direccion = $paramEnviar['direccion'];
        $km = $paramEnviar['km'];
        $piezas = $paramEnviar['piezas'];
        $tiposMantenimiento = $paramEnviar['tiposMantenimiento'];
        $cadenaIdsTM = '';
        foreach ($tiposMantenimiento as $key => $value) {
            if ($key * 1 == 0) {
                $cadenaIdsTM = $value;
            } else {
                $cadenaIdsTM = $cadenaIdsTM . ',' . $value;
            }
        }

        $fecha = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fecha']);
        $costoR = $paramEnviar['costoR'];
        $costoMO = $paramEnviar['costoMO'];
        $data = new ModeloVehiculo();
        $res = $data->guardarMantenimiento($idVehiculo, $taller, $direccion, $km, $piezas, $cadenaIdsTM, $fecha, $costoR, $costoMO);
        if (!ClassUtil::isEmpty($res['id'])) {
            foreach ($tiposMantenimiento as $key => $value) {
                $respuesta = $this->actulizarVehiculo($idVehiculo, $value);
            }
        } else {
            $res = array('success' => 0, 'mensaje' => 'Error al registrar el mantenimiento');
        }
        return $res;
    }

    public function actulizarVehiculo($idVehiculo, $value) {
        $data = new ModeloVehiculo();
        $res = $data->actulizarVehiculo($idVehiculo, $value);
        return $res;
    }

    public function listarMantenimientos($paramEnviar) {
        $idVehiculo = $paramEnviar['idVehiculo'];
        $data = new ModeloVehiculo();
        $arrVehiculos = $data->listarMantenimientos($idVehiculo);

        $tabla = "";
        $cont = 0;
        $totalCR = 0;
        $totalCMO = 0;
        foreach ($arrVehiculos as $key => $value) {

            $tipoMantenimiento = $value['tipo_mantenimiento'];
            $descripcionMantenimiento = $this->obtenerdescripcionMantenimiento($tipoMantenimiento);
            $desc = '';
            foreach ($descripcionMantenimiento as $key => $v) {
                if ($key * 1 == 0) {
                    $desc = $v['descripcion'];
                } else {
                    $desc = $desc . ', ' . $v['descripcion'];
                }
            }

            $fechaActual = Date('Y-m-d');
            $iden = 0;
            if ($fechaActual == $value["fecha_registro"]) {
                $iden = 1;
            }

            $totalCR = $totalCR + $value["costo_repuestos"];
            $totalCMO = $totalCMO + $value["costo_mano_obra"];
            $fechaMantenimiento = ClassUtil::formatearFechaACadenaVw($value["fecha_mantenimiento"]);
            $cont++;
            $tabla .= "<tr>";
            $tabla .= "<td style='text-align: center;'>" . $cont . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["taller"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["direccion"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $desc . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["km"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["piezas"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaMantenimiento . "</td>";
            $tabla .= "<td style='text-align: center;'>" . number_format($value["costo_repuestos"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: center;'>" . number_format($value["costo_mano_obra"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: center;'>" . number_format($value["costo_total"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: center;'>";
            if ($iden == 1) {
                $tabla .= "<a title='Eliminar' onclick='abrirAlerta(" . $value["id"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a>";
            }
            $tabla .= "</td>";
            $tabla .= "</tr>";
        }

        $respuesta->tabla = $tabla;
        $respuesta->totalCR = $totalCR;
        $respuesta->totalCMO = $totalCMO;
        return $respuesta;
    }

    public function obtenerdescripcionMantenimiento($tipoMantenimiento) {
        $data = new ModeloVehiculo();
        return $data->obtenerdescripcionMantenimiento($tipoMantenimiento);
    }

    public function eliminarMantenimiento($paramEnviar) {
        $id = $paramEnviar['id'];
        $data = new ModeloVehiculo();
        $res = $data->eliminarMantenimiento($id);

        if ($res['respuesta']) {
            $arr = explode(",", $res['tipo']);
        }

        foreach ($arr as $key => $value) {
            $r = $this->actualizarEliminarVehiculo($res['idVehiculo'], $value);
        }

        return $res;
    }

    public function actualizarEliminarVehiculo($id, $tipo) {
        $data = new ModeloVehiculo();
        return $data->actualizarEliminarVehiculo($id, $tipo);
    }

}
