<?php

include_once '../../model/modelReportes/ModeloReportePagos.php';
include_once '../../app-assets/mpdf/mpdf.php';
include_once '/NegocioReportePagos.php';
include_once '../../util/ClassUtil.php';

class NegocioReportePagosPDF {

    public function generarReportePagosPdf($url, $dataExportar) {

        $html = '<body>
            <main>
                <h3 class="alinearCentro">REPORTE DE PAGOS</h3>
                <table style="width: 100%">
                    <thead>
                        <tr>
                            <th  class="tamanio10">CÓD. CLIE.</th>
                            <th  class="tamanio25">CLIENTE</th>
                            <th  class="tamanio10">N°. OPERA.</th>
                            <th  class="tamanio10">Monto</th>
                            <th  class="tamanio10">F. PAGO VOUCH.</th>
                            <th  class="tamanio10">PERIODO</th>
                            <th  class="tamanio10">F. LIMITE</th>
                            <th  class="tamanio30">COMENTARIO</th>
                        </tr>
                    </thead>
                <tbody>';

        foreach ($dataExportar as $key => $value) {

            $fechaPagoVoucher = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_voucher"]);
            $fechaPagoCronograma = ClassUtil::formatearFechaACadenaVw($value["fecha_pago_cronograma"]);

            $data = new NegocioReportePagos();
            $descripcionPeriodo = $data->obtenerNombrePeriodo($value["periodo"], $value["anio"]);

            $html .= '	<tr>
                    <td class="alinearCentro">' . $value["codigoCliente"] . '</td>
                    <td class="alinearIzquierda">' . $value["nombre"] . '</td>
                    <td class="alinearIzquierda">' . $value["numero_operacion"] . '</td>
                    <td class="alinearDerecha">' . number_format($value["monto"], 2, ".", ",") . '</td>
                    <td class="alinearCentro">' . $fechaPagoVoucher . '</td>
                    <td class="alinearCentro">' . $descripcionPeriodo . '</td>
                    <td class="alinearCentro">' . $fechaPagoCronograma . '</td>
                    <td class="alinearIzquierda">' . $value["comentario"] . '</td>
                </tr>';
        }
        $html .= '</tbody>
                </table>            
            </main> 
        </body>';

        $mpdf = new mPDF('c', 'A4');

        $css = file_get_contents('../../view/css/Procesos/imprimirOrdenCompra.css');
        $mpdf->writeHTML($css, 1);
        $mpdf->writeHTML($html, 2);
        $mpdf->Output($url, 'F');

        $nombrePdf = 'Reporte pago';

        return $nombrePdf;
    }

}
