<?php

include_once '../../model/modelReportes/ModeloReporteVehiculos.php';
include_once '../../util/ClassUtil.php';
include_once '../../app-assets/mpdf/mpdf.php';

class NegocioReporteVehiculos {

    public function listarReporteVehiculos($paramEnviar) {

        $fechaInicio = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaInicio']);
        $fechaFin = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaFin']);
        $data = new ModeloReporteVehiculos();
        $arrCronogramas = $data->listarReporteVehiculos($fechaInicio, $fechaFin);

        $tabla = "";
        foreach ($arrCronogramas as $key => $value) {
            $fechaMantenimiento = ClassUtil::formatearFechaACadenaVw($value["fecha_mantenimiento"]);

            $tipoMantenimiento = $value['tipo_mantenimiento'];
            $descripcionMantenimiento = $this->obtenerdescripcionMantenimiento($tipoMantenimiento);
            $desc = '';
            foreach ($descripcionMantenimiento as $key => $v) {
                if ($key * 1 == 0) {
                    $desc = $v['descripcion'];
                } else {
                    $desc = $desc . ', ' . $v['descripcion'];
                }
            }

            $tabla .= "<tr>";
            $tabla .= "<td style='text-align: center;'>" . $value["codigo_vehiculo"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["placa"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["marca"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["modelo"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["serie"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["taller"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $desc . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["km"] . "</td>";
            $tabla .= "<td>" . $value["piezas"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $fechaMantenimiento . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["costo_repuestos"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["costo_mano_obra"], 2, ".", ",") . "</td>";
            $tabla .= "<td style='text-align: right;'>" . number_format($value["costo_total"], 2, ".", ",") . "</td>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    public function obtenerdescripcionMantenimiento($tipoMantenimiento) {
        $data = new ModeloReporteVehiculos();
        return $data->obtenerdescripcionMantenimiento($tipoMantenimiento);
    }

    public function exportarPDF($paramEnviar) {

        $fechaInicio = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaInicio']);
        $fechaFin = ClassUtil::formatearCadenaACadenaBD($paramEnviar['fechaFin']);
        $objData = new ModeloReporteVehiculos();
        $arrData = $objData->listarReporteVehiculos($fechaInicio, $fechaFin);

        //PDP PARA MANDAR EN EL CORREO
        $hoy = date("Y_m_d_H_i_s");
        $pdf = 'documento_' . $hoy . '.pdf';
        $url = __DIR__ . '/../../view/Reportes/formatosPDF/' . $pdf;

        $result->nombre = $pdf;
        $result->url = $url;

        $nombreArchivo = $this->generarReporteVehiculosPdf($url, $arrData, $paramEnviar['fechaInicio'], $paramEnviar['fechaFin']);

        if (ClassUtil::isEmpty($nombreArchivo)) {
            $result = 0;
        }

        return $result;
    }

    public function generarReporteVehiculosPdf($url, $dataExportar, $fechaInicio, $fechaFin) {

        $hoy = date("d/m/Y");
        $subtitulo = '';
        if (!ClassUtil::isEmpty($fechaInicio) && !ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Desde ' . $fechaInicio . ' hasta ' . $fechaFin;
        } elseif (!ClassUtil::isEmpty($fechaInicio) && ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Desde ' . $fechaInicio . ' hasta ' . $hoy;
        } elseif (ClassUtil::isEmpty($fechaInicio) && !ClassUtil::isEmpty($fechaFin)) {
            $subtitulo = 'Hasta ' . $fechaFin;
        }


        $html = '<body>
            <main>
                <h3 class="alinearCentro">REPORTE DE MANTENIMIENTOS VEHICULARES</h3>
                <h4 class="alinearIzquierda">' . $subtitulo . '</h4>
                <table style="width: 100%">
                    <thead>
                        <tr>
                            <th class="tamanio10">Codígo vehículo</th>
                            <th class="tamanio10">Placa</th>
                            <th class="tamanio10">Marca</th>
                            <th class="tamanio10">Modelo</th>
                            <th class="tamanio10">Serie</th>
                            <th class="tamanio15">Taller</th>
                            <th class="tamanio20">Mantenimiento</th>
                            <th class="tamanio10">Km</th>
                            <th class="tamanio15">Piezas</th>
                            <th class="tamanio10">Fecha</th>
                            <th class="tamanio10">Costo Repuestos</th>
                            <th class="tamanio10">Costo Mano Obra</th>
                            <th class="tamanio10">Costo Total</th>
                        </tr>
                    </thead>
                <tbody>';
        $montoTotal = 0;
        foreach ($dataExportar as $key => $value) {

            $fechaMantenimiento = ClassUtil::formatearFechaACadenaVw($value["fecha_mantenimiento"]);

            $tipoMantenimiento = $value['tipo_mantenimiento'];
            $descripcionMantenimiento = $this->obtenerdescripcionMantenimiento($tipoMantenimiento);
            $desc = '';
            foreach ($descripcionMantenimiento as $key => $v) {
                if ($key * 1 == 0) {
                    $desc = $v['descripcion'];
                } else {
                    $desc = $desc . ', ' . $v['descripcion'];
                }
            }

            $html .= '	<tr>
                    <td class="alinearCentro">' . $value["codigo_vehiculo"] . '</td>
                    <td class="alinearCentro">' . $value["placa"] . '</td>
                    <td class="alinearCentro">' . $value["marca"] . '</td>
                    <td class="alinearCentro">' . $value["modelo"] . '</td>
                    <td class="alinearCentro">' . $value["serie"] . '</td>
                    <td class="alinearCentro">' . $value["taller"] . '</td>
                    <td class="alinearCentro">' . $desc . '</td>
                    <td class="alinearCentro">' . $value["km"] . '</td>
                    <td class="alinearIzquierda">' . $value["piezas"] . '</td>
                    <td class="alinearCentro">' . $fechaMantenimiento . '</td>
                    <td class="alinearDerecha">' . number_format($value["costo_repuestos"], 2, ".", ",") . '</td>
                    <td class="alinearDerecha">' . number_format($value["costo_mano_obra"], 2, ".", ",") . '</td>
                    <td class="alinearDerecha">' . number_format($value["costo_total"], 2, ".", ",") . '</td>
                </tr>';
            $montoTotal = $montoTotal + ($value["costo_total"] * 1);
        }
        $html .= '</tbody>
                <tfoot>
                    <tr>
                        <td class="alinearCentro" colspan="12">COSTO TOTAL</td>
                        <td class="alinearDerecha">' . number_format($montoTotal, 2, ".", ",") . '</td>
                        </tr>
                    </tfoot>
                </table>            
            </main> 
        </body>';

        $mpdf = new mPDF('c', 'A4-L');

        $css = file_get_contents('../../view/css/Procesos/imprimirOrdenCompra.css');
        $mpdf->writeHTML($css, 1);
        $mpdf->writeHTML($html, 2);
        $mpdf->Output($url, 'F');

        $nombrePdf = 'Reporte pago';

        return $nombrePdf;
    }

    public function eliminarPdf($paramEnviar) {
        $url = $paramEnviar['url'];
        unlink($url);
        return 1;
    }

}
