<?php

include_once '../../model/modelSeguridad/ModelUsuario.php';
include_once '../../util/ClassUtil.php';

class NegocioUsuario {

    public function obtenerConfiguracionesIniciales($paramEnviar) {
        $id = $paramEnviar['id'];
        if (!ClassUtil::isEmpty($id)) {
            $respuesta->dataUsuario = $this->obtenerDatosUsuario($id);
        }
        $respuesta->dataClientes = $this->obtenerClientes();
        $respuesta->dataRol = $this->obtenerRol();
        return $respuesta;
    }

    public function obtenerDatosUsuario($id) {
        $data = new ModelUsuario();
        return $data->obtenerDatosUsuario($id);
    }

    public function obtenerClientes() {
        $data = new ModelUsuario();
        return $data->obtenerClientes();
    }

    public function obtenerRol() {
        $data = new ModelUsuario();
        return $data->obtenerRol();
    }

    public function mostrarUsuarios($paramEnviar) {
        $data = new ModelUsuario();
        $arrDatos = $data->mostrarUsuarios($paramEnviar);

        $tabla = "";
        $cont = 0;
        foreach ($arrDatos as $key => $value) {
            $cont = $cont + 1;
            $tabla .= "<tr>";
            $tabla .= "<td style='text-align: center;'>" . $cont . "</td>";
            $tabla .= "<td>" . $value["nombre"] . "</td>";
            $tabla .= "<td>" . $value["documento"] . "</td>";
            $tabla .= "<td>" . $value["rol"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["login"] . "</td>";
            $tabla .= "<td style='text-align: center;'>" . $value["activo"] . "</td>";
            $tabla .= "<td style='text-align: center;'><a title='Editar' onclick='editarUsuario(" . $value["idUsuario"] . ")' style='cursor: pointer;'><i class='material-icons' style='color: #ffea00;'>edit</i></a>";
            $tabla .= "<a title='Editar' onclick='abrirAlertaEliminar(" . $value["idUsuario"] . ",\"" . $value["login"] . "\")' style='cursor: pointer;'><i class='material-icons' style='color: #e53935;'>delete_forever</i></a></td>";
            $tabla .= "</tr>";
        }
        return $tabla;
    }

    public function guardarUsuario($paramEnviar) {
        $id = $paramEnviar['id'];
        $cliente = $paramEnviar['cliente'];
        $rol = $paramEnviar['rol'];
        $usuario = $paramEnviar['usuario'];
        $pass = $paramEnviar['pass'];
        $data = new ModelUsuario();
        $respuesta = $data->guardarUsuario($id, $cliente, $rol, $usuario, $pass);
        $idUsuario = $respuesta['idUsuario'];
        if (!ClassUtil::isEmpty($idUsuario)) {
            $res = $this->actualizarUsuarioMain($idUsuario);
        }

        if ($res['success'] * 1 != 1) {
            $respuesta = array('success' => 0, 'mensaje' => 'Error al registrar usuario !');
        }
        return $respuesta;
    }

    public function actualizarUsuarioMain($idUsuario) {
        $data = new ModelUsuario();
        $result = $data->actualizarUsuarioMain($idUsuario);
        return $result;
    }

    public function eliminarUsuario($paramEnviar) {
        $id = $paramEnviar['id'];
        $data = new ModelUsuario();
        return $data->eliminarUsuario($id);
    }

}
