<?php

include_once '../../model/conexion.php';

class ModeloVehiculo {

    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function obtenerDatosVehiculo($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarVehiculos(";
        $sql .= "'" . $id . "', ";
        $sql .= "2)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function obtenerDatosTipoMantenimiento($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarVehiculos(";
        $sql .= "'" . $id . "', ";
        $sql .= "3)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function guardarVehiculo($id, $placa, $marca, $modelo, $serie, $km, $motor, $corona, $bujias, $frenos, $zapatas, $inyectores) {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateVehiculo(";
        $sql .= "'" . $id . "', ";
        $sql .= "'" . $placa . "', ";
        $sql .= "'" . $marca . "', ";
        $sql .= "'" . $modelo . "', ";
        $sql .= "'" . $serie . "', ";
        $sql .= "'" . $km . "', ";
        $sql .= "'" . $motor . "', ";
        $sql .= "'" . $corona . "', ";
        $sql .= "'" . $bujias . "', ";
        $sql .= "'" . $frenos . "', ";
        $sql .= "'" . $zapatas . "', ";
        $sql .= "'" . $inyectores . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $mensaje = $fila["mensaje"];
                    $id = $fila["id"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje, 'id' => $id);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function guardarTiposMantenimiento($id, $tipo, $km) {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertTipoMantenimiento(";
        $sql .= "'" . $id . "', ";
        $sql .= "'" . $tipo . "', ";
        $sql .= "'" . $km . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $mensaje = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function listarVehiculos() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarVehiculos(";
        $sql .= "0, ";
        $sql .= "1)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function eliminarVehiculo($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarVehiculo(";
        $sql .= "" . $id . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

    public function guardarMantenimiento($idVehiculo, $taller, $direccion, $km, $piezas, $cadenaIdsTM, $fecha, $costoR, $costoMO) {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateMantenimiento(";
        $sql .= "'" . $idVehiculo . "', ";
        $sql .= "'" . $taller . "', ";
        $sql .= "'" . $direccion . "', ";
        $sql .= "'" . $km . "', ";
        $sql .= "'" . $piezas . "', ";
        $sql .= "'" . $cadenaIdsTM . "', ";
        $sql .= "'" . $fecha . "', ";
        $sql .= "'" . $costoR . "', ";
        $sql .= "'" . $costoMO . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "')";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $mensaje = $fila["mensaje"];
                    $id = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje, 'id' => $id);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function actulizarVehiculo($idVehiculo, $tipo) {
        $this->con->cerrarAbrir();
        $sql = "call sp_updateVehiculoMantenimiento(";
        $sql .= "'" . $idVehiculo . "', ";
        $sql .= "" . $tipo . ")";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function obtenerdescripcionMantenimiento($tipoMantenimiento) {
        $this->con->cerrarAbrir();
        $sql = "call sp_obtenerTipoMantenimientoXM(";
        $sql .= "'" . $tipoMantenimiento . "', ";
        $sql .= "1)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function listarMantenimientos($idVehiculo) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarMantenimientos(";
        $sql .= "'" . $idVehiculo . "', ";
        $sql .= "1)";
        try {
            $arrDatos = array();
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    array_push($arrDatos, $fila);
                }
                $resp = $arrDatos;
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function eliminarMantenimiento($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarMantenimiento(";
        $sql .= "" . $id . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

    public function obtenerTiposMantenimiento() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarMultitablas(";
        $sql .= "0, ";
        $sql .= "32, ";
        $sql .= "5)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function actualizarEliminarVehiculo($idVehiculo, $tipo) {
        $this->con->cerrarAbrir();
        $sql = "call sp_updateVehiculoMantenimientoEliminar(";
        $sql .= "'" . $idVehiculo . "', ";
        $sql .= "" . $tipo . ")";
        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

}
