<?php

include_once '../../model/conexion.php';

class ModelUsuario {

    private $con;

    public function __construct() {
        $this->con = new Conexion();
    }

    public function obtenerClientes() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarClientes(";
        $sql .= "0, ";
        $sql .= "3)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function obtenerRol() {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarRoles(";
        $sql .= "1,";
        $sql .= "2)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function mostrarUsuarios($paramEnviar) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarUsuarios(";
        $sql .= "1,";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        $arrDatos = array();
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function guardarUsuario($id, $cliente, $rol, $usuario, $pass) {
        $this->con->cerrarAbrir();
        $sql = "call sp_insertUpdateUsuario(";
        $sql .= "" . $id . ", ";
        $sql .= "" . $cliente . ", ";
        $sql .= "" . $rol . ", ";
        $sql .= "'" . $usuario . "', ";
        $sql .= "'" . $pass . "', ";
        $sql .= "'" . $_SESSION['usuario'] . "') ";

        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $idUsuario = $fila["idUsuario"];
                    $mensaje = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje, 'idUsuario' => $idUsuario);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function actualizarUsuarioMain($idUsuario) {
        $this->con->cerrarAbrir();
        $sql = "call sp_updateUsuarioMain(";
        $sql .= "" . $idUsuario . ") ";

        try {
            $respuesta = 0;
            $datos = $this->con->consultaRetorno($sql);
            $error = $this->con->error();
            if ($error == "") {
                while ($fila = mysqli_fetch_array($datos)) {
                    $respuesta = $fila["respuesta"];
                    $mensaje = $fila["mensaje"];
                }

                $resp = array('success' => $respuesta, 'mensaje' => $mensaje);
            } else {
                $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $error . '. CONSULTA: ' . $sql);
            }
        } catch (Exception $e) {
            $resp = array('success' => 0, 'mensaje' => 'ERROR: ' . $e->getMessage());
        }
        return $resp;
    }

    public function obtenerDatosUsuario($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_mostrarUsuarios(";
        $sql .= "" . $id . ", ";
        $sql .= "3)";

        $arrDatos = array();
        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            array_push($arrDatos, $fila);
        }
        return $arrDatos;
    }

    public function eliminarUsuario($id) {
        $this->con->cerrarAbrir();
        $sql = "call sp_eliminarUsuario(";
        $sql .= "" . $id . ", ";
        $sql .= "1)";

        $datos = $this->con->consultaRetorno($sql);
        while ($fila = mysqli_fetch_array($datos)) {
            $respuesta = $fila;
        }

        return $respuesta;
    }

}
