USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarDocumentosVenta`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarDocumentosVenta`(
	IN `p_idDocumentoVenta` INT, 
    IN `p_fechaInicio` DATE, 
    IN `p_fechaFin` DATE, 
    IN `p_estado` VARCHAR(2), 
    IN `p_idCliente` INT,
    IN `p_tipoOperacion` INT
) 
BEGIN    
	IF p_tipoOperacion = 1 
		THEN         
			SELECT
					DV.id, 
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda, 
					M2.descripcion AS moneda_descripcion,
					DATE(DV.fecha_registro) AS fecha_registro,
					DATE(DV.fecha_emision) AS fecha_emision,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes, 
					DV.monto_total_interes,
					DV.estado,
					M3.descripcion AS estado_descripcion
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN MULTITABLA M3
						ON M3.abrev = DV.estado 
						AND M3.dep_id = 25
						AND M3.activo = 1
			WHERE	(p_estado = '0' OR p_estado = DV.estado)
					AND (p_fechaInicio IS NULL OR p_fechaInicio <= DATE(DV.fecha_registro))
					AND (p_fechaFin IS NULL OR p_fechaFin >= DATE(DV.fecha_registro))
                    AND DV.activo = 1
			ORDER BY DV.correlativo DESC;
    END	IF; 
    
    IF p_tipoOperacion = 2 
		THEN  
			SELECT
					id,
					idCliente,
					idTipoDocumento,
					idMoneda,
					idFormaPago,
					idMedioPago,
					idCanal,
					correlativo,
					DATE(fecha_emision) AS fecha_emision,
					serie,
					numero,
                    tasa_cambio,
                    igv,
					monto_subtotal,
					monto_igv_total,
					monto_total,
					monto_interes,
					monto_total_interes,
					DATE(fecha_registro) AS fecha_registro,
					estado
			FROM 	DOCUMENTO_VENTA
			WHERE 	id = p_idDocumentoVenta;
    END	IF; 
    
    IF p_tipoOperacion = 3 
		THEN  
			SELECT
					DDV.id,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
    
    IF p_tipoOperacion = 4
		THEN  
			SELECT
					CPV.id,
					CPV.capital_cuota AS capitalCuota,
                    CPV.cuota,
                    DATE(CPV.fecha_pago_cuota) AS fechaPago,
                    CPV.importe_cuota AS importeCuota,
                    CPV.interes_cuota AS interesCuota,
                    FP.interes
			FROM	CRONOGRAMA_PAGO_VENTA CPV
					INNER JOIN DOCUMENTO_VENTA DV
						ON DV.id = CPV.documento_venta_id AND DV.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago AND FP.activo = 1
            WHERE	CPV.documento_venta_id = p_idDocumentoVenta
					AND CPV.activo = 1;
    END	IF;
    
    IF p_tipoOperacion = 5
		THEN  
			SELECT
					DV.id,
					DV.correlativo,
					CASE WHEN C.idTipoCliente = 2
						THEN
							C.razonSocial
						ELSE
							concat(C.nombres, ' ', C.apellidoPaterno, ' ', C.apellidoMaterno) 
					END AS cliente_descripcion,
                    C.documento AS documento_cliente,
                    C.direccion,
                    C.telefono1,
					M.descripcion AS tipo_documento_descripcion,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
					DATE_FORMAT(DV.fecha_registro, '%d/%m/%Y') AS fecha_registro,
                    DATE_FORMAT(DV.fecha_emision, '%d/%m/%Y') AS fecha_emision,
                    DV.tasa_cambio,
                    DV.igv,
					DV.monto_subtotal,
					DV.monto_igv_total,
                    DV.monto_descuento_total,
					DV.monto_total,
					DV.monto_interes,
					DV.monto_total_interes,
					DV.estado,
                    FP.nombre AS forma_pago_descripcion,
                    DV.serie,
                    DV.numero
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN CLIENTE C
						ON C.idCliente = DV.idCliente
						AND C.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20 
						AND M2.activo = 1
					INNER JOIN FORMA_PAGO FP
						ON FP.id = DV.idFormaPago
                        AND FP.activo = 1
			WHERE	DV.id = p_idDocumentoVenta;
    END	IF;
    
    IF p_tipoOperacion = 6
		THEN  
			SELECT
					DDV.id,
                    P.codigo AS codigoProducto,
					DDV.cantidad,
					DDV.descuento,
					DDV.producto_id AS idProducto,
					P.nombre AS nombreProducto,
					DDV.igv_unitario AS igv,
					DDV.precio_unitario AS precioUnitario,
					P.stockActual AS stock,
					M.descripcion AS unidadMedida,
					DDV.valor_unitario AS valorUnitario,
                    DDV.valor_total AS valorTotal,
					DDV.precio_total AS precioTotal
			FROM	DETALLE_DOCUMENTO_VENTA DDV
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id AND P.activo = 1
					INNER JOIN MULTITABLA M 
						ON M.dep_id = 3 AND P.unidad_medida = M.abrev
			WHERE 	DDV.documento_venta_id = p_idDocumentoVenta
					AND DDV.activo = 1;
    END	IF; 
    
    IF p_tipoOperacion = 7
	THEN
		SELECT
					DV.id,
                    DV.correlativo,
                    M.descripcion AS tipo_documento_descripcion,	
                    DV.serie,
                    DV.numero,
					DV.idMoneda,
					M2.descripcion AS moneda_descripcion,
                    DATE(DV.fecha_emision) AS fecha_emision,
					DV.monto_total,
                    P.nombre AS producto_nombre, 
                    DDV.cantidad,
                    DDV.precio_unitario,
                    DDV.descuento,
                    DDV.precio_total,
					DV.estado,
					M3.descripcion AS estado_descripcion
			FROM 	DOCUMENTO_VENTA DV
					INNER JOIN MULTITABLA M 
						ON M.valor = DV.idTipoDocumento 
						AND M.dep_id = 15
						AND M.activo = 1
					INNER JOIN MULTITABLA M2
						ON M2.valor = DV.idMoneda 
						AND M2.dep_id = 20  
						AND M2.activo = 1
					INNER JOIN MULTITABLA M3
						ON M3.abrev = DV.estado 
						AND M3.dep_id = 25
						AND M3.activo = 1
					INNER JOIN DETALLE_DOCUMENTO_VENTA DDV
						ON DDV.documento_venta_id = DV.id
                        AND DDV.activo = 1
					INNER JOIN PRODUCTO P
						ON P.idProducto = DDV.producto_id
			WHERE	DV.idCliente = p_idCliente and DV.id <> p_idDocumentoVenta
			ORDER BY DV.correlativo DESC;
    
    END IF;
   
END$$

DELIMITER ;


USE `erp_targox`;
DROP procedure IF EXISTS `sp_listarProductos`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarProductos`(IN `p_idProducto` INT, IN `p_idCategoria` INT, IN `p_idSubcategoria` INT, IN `p_idClase` INT, IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN    
    
		SELECT  
				P.idProducto,            
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase', 
                P.stockActual as stock,
                P.valor_unitario,
                P.precio_unitario,
                P.igv_unitario,
				P.marca,
				P.modelo,
				P.cod_fab,
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
                M.descripcion AS unidad_medida_descripcion
		FROM 	PRODUCTO P
				INNER JOIN CLASE C 
					ON C.idClase = P.idClase 
                    and (C.idClase = p_idClase or '0' = p_idClase)
				INNER JOIN SUBCATEGORIA S 
					ON S.idSubcategoria = C.idSubcategoria 
                    and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
				INNER JOIN CATEGORIA CA 
					ON CA.idCategoria = S.idCategoria and ( CA.idCategoria = p_idCategoria or'0' = p_idCategoria)
				INNER JOIN MULTITABLA M 
					ON M.dep_id = 3 AND P.unidad_medida = M.abrev
        WHERE 	P.anulado = 0
				and P.activo = 1
		ORDER BY P.nombre;
        
    END	IF; 
    
END$$

DELIMITER ;


USE `erp_targox`;
DROP procedure IF EXISTS `sp_insertUpdateCliente`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateCliente`(IN `p_idCliente` INT, IN `p_idTipoCliente` INT, IN `p_idCategoria` INT, IN `p_idPais` VARCHAR(5), IN `p_idCiudad` INT, IN `p_razonSocial` VARCHAR(300), IN `p_nombreComercial` VARCHAR(300), IN `p_nombres` VARCHAR(300), IN `p_apellidoPaterno` VARCHAR(300), IN `p_apellidoMaterno` VARCHAR(300), IN `p_direccion` VARCHAR(300), IN `p_referencia` VARCHAR(50), IN `p_idTipoDocumento` INT, IN `p_documento` VARCHAR(20), IN `p_fechaNacimiento` DATE, IN `p_email` VARCHAR(50), IN `p_telefono1` VARCHAR(20), IN `p_telefono2` VARCHAR(20), IN `p_cuentaInstagram` VARCHAR(50), IN `p_cuentaFacebook` VARCHAR(50), IN `p_ocupacion` VARCHAR(50), IN `p_lugarOcupacion` VARCHAR(50), IN `p_calificacion` VARCHAR(300), IN `p_usuarioRegistro` VARCHAR(50), IN `p_activo` INT)
BEGIN 

	DECLARE	tam int;
	DECLARE cuerpo varchar(6);
	DECLARE cuerpoFinal varchar(6);
	DECLARE aux varchar(6);
	DECLARE aux1 int; 
	DECLARE aux2 int;
	DECLARE b int default 1;
	DECLARE _codigo varchar(9); 
	
    IF p_idCliente IS NULL OR p_idCliente = 0 OR p_idCliente = ''
		THEN
			IF EXISTS (SELECT idCliente FROM CLIENTE WHERE trim(documento) = trim('66666666666') and activo <> 3) 
				THEN            
					SELECT	0 AS tipoRespuesta,
							0 AS tipoCliente,
							'Ya existe un cliente con este documento !' AS respuesta,
							0 AS idCliente;
			ELSE
				SET cuerpo = (SELECT Max(SUBSTRING(codigoCliente,4,9)) FROM CLIENTE);
					
					SET tam = length(cuerpo);
					
					
					IF (tam = 6) then
						set aux = cuerpo;
						set aux1 = cast(aux as UNSIGNED); 
						set aux2 = aux1 + b;
						
						set aux = cast(aux2 as char(6));
						while(length(aux)<6) DO
							set aux = concat('0',aux);
						end while; 
						
						set cuerpoFinal = aux;
						
					ELSE
						set aux = '0';
						set aux1 = cast(aux as UNSIGNED);
						set aux2 = aux1 + b;
						
						set aux = cast(aux2 as char(6)); 
						while(length(aux)<6) DO
							set aux = concat('0',aux);
						end while;
						
						set cuerpoFinal = aux;         
						 
					END IF;
					
					SET _codigo = concat('CL-',cuerpoFinal);

					INSERT INTO CLIENTE(idCategoria,
										idTipoCliente,
										idPais,
										idCiudad,
										codigoCliente,
										razonSocial,
										nombreComercial,
										nombres,
										apellidoPaterno,
										apellidoMaterno,
										idTipoDocumento,
										documento,
										direccion,
										fechaNacimiento,
										telefono1,
										telefono2,
										-- telefono3,
										email,
										referencia,
										cuentaFacebook ,
										cuentaInstagram,
										ocupacion,
										lugarOcupacion,
										-- comentario,
										calificacion,
										fechaRegistro ,
										usuarioRegistro,
										pcRegistro,
										fechaEdicion,
										usuarioEdicion,
										pcEdicion,
										activo)
								VALUES(	p_idCategoria,
										p_idTipoCliente,
										p_idPais,
										p_idCiudad,
										_codigo,
										p_razonSocial,
										p_nombreComercial,
										p_nombres,
										p_apellidoPaterno,
										p_apellidoMaterno,
										p_idTipoDocumento,
										p_documento,
										p_direccion,
										p_fechaNacimiento,
										p_telefono1,
										p_telefono2,
										p_email,
										p_referencia,
										p_cuentaFacebook,
										p_cuentaInstagram,
										p_ocupacion,
										p_lugarOcupacion,
										p_calificacion,
										NOW(),
										p_usuarioRegistro,
										@@hostname,
										NOW(),
										p_usuarioRegistro,
										@@hostname,
										p_activo);
					SELECT	1 AS tipoRespuesta,
							p_idTipoCliente AS tipoCliente,
							'El cliente de registró correctamente' AS respuesta,
							last_insert_id() AS idCliente;
					
			END IF;
							
	ELSE
		UPDATE 	CLIENTE
        SET		idCategoria = p_idCategoria,
				idTipoCliente = p_idTipoCliente,				
				idPais = p_idPais,	
				idCiudad = p_idCiudad,
				razonSocial = p_razonSocial,								
				nombreComercial = p_nombreComercial,
				nombres = p_nombres,
				apellidoPaterno = p_apellidoPaterno,
				apellidoMaterno = p_apellidoMaterno,
				idTipoDocumento = p_idTipoDocumento,
				documento = p_documento,
				direccion = p_direccion,
				fechaNacimiento = p_fechaNacimiento,
				telefono1 = p_telefono1,
				telefono2 = p_telefono2,
				email = p_email,
				referencia = p_referencia,
				cuentaFacebook = p_cuentaFacebook,
				cuentaInstagram = p_cuentaInstagram,
				ocupacion = p_ocupacion,
				lugarOcupacion = p_lugarOcupacion,
				calificacion = p_calificacion,
				fechaEdicion = 	NOW(),
				usuarioEdicion = p_usuarioRegistro,
				pcEdicion = @@hostname,
				activo = p_activo
		WHERE	idCliente = p_idCliente;
        
        SELECT	1 AS tipoRespuesta,
				p_idCliente AS idCliente,
				p_idTipoCliente AS tipoCliente,
				'El cliente de editó correctamente' AS respuesta;
    
    END IF;
    
    
END$$

DELIMITER ;


USE `erp_targox`;
DROP procedure IF EXISTS `sp_insertUpdateFormaPago`;

DELIMITER $$
USE `erp_targox`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateFormaPago`(IN `p_idFormaPago` INT, IN `p_nombre` VARCHAR(200), IN `p_numero_cuotas` INT, IN `p_frecuencia` INT, IN `p_tipo_frecuencia` INT, IN `p_interes` INT, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_activo` INT)
BEGIN  
    
	IF p_idFormaPago IS NULL OR p_idFormaPago = ''
		THEN       	
			IF EXISTS (SELECT id FROM FORMA_PAGO WHERE trim(nombre) = trim(p_nombre) and activo <> 2) 
				THEN
					SELECT	0 AS 'tipoRespuesta', 
							'Ya existe una forma de pago con este nombre.' AS respuesta;
			ELSE
				INSERT INTO FORMA_PAGO(	tipo_frecuencia_id,
										nombre,
										numero_cuotas,
										frecuencia,
										interes, 
										activo,
										registro_fecha_add,
										registro_user_add,
										registro_pc_add,
										registro_fecha_update,
										registro_user_update,
										registro_pc_update
										)
								VALUES(	p_tipo_frecuencia,
										p_nombre,
										p_numero_cuotas,
										p_frecuencia,
										p_interes,
										p_activo,
										NOW(),
										p_registro_user_add, 
										@@hostname,
										NOW(),
										p_registro_user_update,
										@@hostname                                    
										);
				
				SELECT 	1 AS 'tipoRespuesta', 
						'Se guardó correctamente la forma de pago.' as respuesta;
			END	IF;
	ELSE
			UPDATE 	FORMA_PAGO
			SET		tipo_frecuencia_id = p_tipo_frecuencia,
					nombre = p_nombre,
					numero_cuotas = p_numero_cuotas,
					frecuencia = p_frecuencia,
					interes = p_interes,
					activo = p_activo,
					registro_fecha_update = NOW(),
					registro_user_update = p_registro_user_update,
					registro_pc_update = @@hostname
			WHERE	id = p_idFormaPago;
			
			SELECT 	1 AS 'tipoRespuesta', 
					'Se editó correctamente la forma de pago.' as respuesta;
    END	IF; 
END$$

DELIMITER ;

