<?php

require_once('../../app-assets/mpdf/mpdf.php');
require_once('../../model/conexion2.php');
require_once('../../util/ClassUtil.php');

date_default_timezone_set('America/Lima');
session_start();
$time = time();

class NumeroALetras {

    private static $UNIDADES = [
        '',
        'UN ',
        'DOS ',
        'TRES ',
        'CUATRO ',
        'CINCO ',
        'SEIS ',
        'SIETE ',
        'OCHO ',
        'NUEVE ',
        'DIEZ ',
        'ONCE ',
        'DOCE ',
        'TRECE ',
        'CATORCE ',
        'QUINCE ',
        'DIECISEIS ',
        'DIECISIETE ',
        'DIECIOCHO ',
        'DIECINUEVE ',
        'VEINTE '
    ];
    private static $DECENAS = [
        'VEINTI',
        'TREINTA ',
        'CUARENTA ',
        'CINCUENTA ',
        'SESENTA ',
        'SETENTA ',
        'OCHENTA ',
        'NOVENTA ',
        'CIEN '
    ];
    private static $CENTENAS = [
        'CIENTO ',
        'DOSCIENTOS ',
        'TRESCIENTOS ',
        'CUATROCIENTOS ',
        'QUINIENTOS ',
        'SEISCIENTOS ',
        'SETECIENTOS ',
        'OCHOCIENTOS ',
        'NOVECIENTOS '
    ];

    public static function convertir($number, $moneda = '', $centimos = '', $forzarCentimos = false) {
        $converted = '';
        $decimales = '';
        if (($number < 0) || ($number > 999999999)) {
            return 'No es posible convertir el numero a letras';
        }
        $div_decimales = explode('.', $number);
        if (count($div_decimales) > 1) {
            $number = $div_decimales[0];
            $decNumberStr = (string) $div_decimales[1];
            if (strlen($decNumberStr) == 2) {
                $decNumberStrFill = str_pad($decNumberStr, 9, '0', STR_PAD_LEFT);
                $decCientos = substr($decNumberStrFill, 6);
                $decimales = self::convertGroup($decCientos);
            }
        } else if (count($div_decimales) == 1 && $forzarCentimos) {
            $decimales = 'CERO ';
        }
        $numberStr = (string) $number;
        $numberStrFill = str_pad($numberStr, 9, '0', STR_PAD_LEFT);
        $millones = substr($numberStrFill, 0, 3);
        $miles = substr($numberStrFill, 3, 3);
        $cientos = substr($numberStrFill, 6);
        if (intval($millones) > 0) {
            if ($millones == '001') {
                $converted .= 'UN MILLON ';
            } else if (intval($millones) > 0) {
                $converted .= sprintf('%sMILLONES ', self::convertGroup($millones));
            }
        }
        if (intval($miles) > 0) {
            if ($miles == '001') {
                $converted .= 'MIL ';
            } else if (intval($miles) > 0) {
                $converted .= sprintf('%sMIL ', self::convertGroup($miles));
            }
        }
        if (intval($cientos) > 0) {
            if ($cientos == '001') {
                $converted .= 'UN ';
            } else if (intval($cientos) > 0) {
                $converted .= sprintf('%s ', self::convertGroup($cientos));
            }
        }
        if (empty($decimales)) {
            $valor_convertido = $converted . ' y 00/100 ' . strtoupper($moneda);
            //$valor_convertido = $converted . strtoupper($moneda) . ' CON 00/100 ' . strtoupper($centimos);
            //$valor_convertido = $converted . strtoupper($moneda) . ' y 00/100 ' . strtoupper($centimos);
        } else {
            //$valor_convertido = $converted . 'y '. $div_decimales[1].$div_decimales[2] .'/100 ' . strtoupper($moneda) . ' CON ' . $decimales . ' ' . strtoupper($centimos);
            $valor_convertido = $converted . ' y ' . $div_decimales[1] . $div_decimales[2] . '/100 ' . strtoupper($moneda);
            //$valor_convertido = $converted . 'CON '. $div_decimales[1].$div_decimales[2] .'/100 ' . strtoupper($moneda);
            //$valor_convertido = $converted . strtoupper($moneda) . ' y '. $div_decimales[1].$div_decimales[2] .'/100 ' . strtoupper($centimos);
        }
        return $valor_convertido;
    }

    private static function convertGroup($n) {
        $output = '';
        if ($n == '100') {
            $output = "CIEN ";
        } else if ($n[0] !== '0') {
            $output = self::$CENTENAS[$n[0] - 1];
        }
        $k = intval(substr($n, 1));
        if ($k <= 20) {
            $output .= self::$UNIDADES[$k];
        } else {
            if (($k > 30) && ($n[2] !== '0')) {
                $output .= sprintf('%sY %s', self::$DECENAS[intval($n[1]) - 2], self::$UNIDADES[intval($n[2])]);
            } else {
                $output .= sprintf('%s%s', self::$DECENAS[intval($n[1]) - 2], self::$UNIDADES[intval($n[2])]);
            }
        }
        return $output;
    }

}

if (isset($_GET['id'])) {
    $idPago = $_GET['id'];
}
//DATOS DE LA EMPRESA
//$con = conectar();
//$sql = "SELECT idEmpresa, ruc, razonSocial, nombreComercial, domicilioFiscal, correo, telefono FROM EMPRESA LIMIT 1 ";
//$datos = $con->query($sql);
//while ($fila = mysqli_fetch_array($datos)) {
//    $rucEmpresa = $fila['ruc'];
//    $razonSocialEmpresa = $fila['razonSocial'];
//    $nombreComercialEmpresa = $fila['nombreComercial'];
//    $domicilioFiscalEmpresa = $fila['domicilioFiscal'];
//    $correoEmpresa = $fila['correo'];
//    $telefonoEmpresa = $fila['telefono'];
//}
//mysqli_close($con);
//DATOS DOCUMENTO VENTA
$con = conectar();
$sql = "call sp_mostrarPagos(";
$sql .= "" . $idPago . ", ";
$sql .= "'', ";
$sql .= "3)";
$data = "";
$datos = $con->query($sql);
while ($fila = mysqli_fetch_array($datos, MYSQL_ASSOC)) {
    $codigoCliente = $fila['codigoCliente'];
    $nombreCliente = $fila['nombre'];
    $direccion = $fila['direccion'];
    $nroRecibo = $fila['numero_recibo'];
    $comentario = $fila['comentario'];
    $fechaRegistro = ClassUtil::formatearFechaACadenaVw($fila['fecha_registro']);
    $fechaPago = ClassUtil::formatearFechaACadenaVw($fila['fecha_pago']);
    $fechaInicio = ClassUtil::formatearFechaACadenaVw($fila['fecha_inicio']);
    $fechaFin = ClassUtil::formatearFechaACadenaVw($fila['fecha_fin']);
    $monto = number_format($fila['monto'], 2, '.', '');
    $montoLetras = NumeroALetras::convertir($monto, 'soles', 'centimos');
}

$hoy = date("d/m/Y");
//
//mysqli_close($con);

$html = '<body>
            <header class="clearfix" >
		<table class="tablaHeader" style="width: 100%;">
                    <tr>
                        <td valign="bottom" class="alinearIzquierda tamanio75" style="border-bottom: 3px solid black;">
                            <strong style="font-size: 16px;"></strong> 
                            <strong style="font-size: 11px;"></strong>						
                        </td>
                        <td valign="bottom" class="alinearDerecha tamanio25" style="border-bottom: 3px solid black;">
                            <strong style=" font-size: 16px; font-style: oblique"></strong> <br>
                            <span style=" font-size: 9px; "></span>
                        </td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid white;" valign="bottom" class="alinearIzquierda tamanio70" >
                            <strong style="font-size: 11px;"></strong> 
                            <strong style="font-size: 11px;"></strong>
                        </td>
                        <td rowspan="2" valign="bottom" class="alinearCentro tamanio30">						
                            <span style=" font-size: 20px; color: red;">N°' . $nroRecibo . ' </span>		
                        </td>
                    </tr>				
                    <tr>
                        <td valign="bottom" class="alinearIzquierda tamanio70" >
                            <strong style="font-size: 11px; font-style: oblique;"></strong>
                            <span style="font-size: 11px; font-style: oblique;"></span>
                        </td>
                    </tr>
                </table>
            </header>
            <main>
                <table class="tablaProveedor" style="width: 100%;">
                    <tr>
                        <td valign="bottom" class="alinearIzquierda tamanio40">					
                        </td>
                        <td valign="bottom" class="alinearIzquierda tamanio20">					
                        </td>
                        <td rowspan="4" valign="bottom" class="alinearDerecha tamanio40" >	
                          
                        </td>
                    </tr>
                    <tr>
                        <td valign="bottom" class="alinearIzquierda tamanio40">					
                        </td>
                        <td valign="bottom" class="alinearIzquierda tamanio20">					
                        </td>
                    </tr>
                    <tr>
                        <td valign="bottom" class="alinearIzquierda tamanio40">					
                        </td>
                        <th style="border-left: 1px solid black; border-top: 1px solid black; border-right: 1px solid black; " class="alinearCentro tamanio20" >
                            RECIBO		
                        </th>
                    </tr>
                </table>
                <table style="width: 100%; margin-top: 0px !important;">
                    <tbody>                        
                        <tr>
                            <td class="alinearIzquierda tamanio5">
                                Sr.
                            </td> 
                            <td class="tamanio65">
                               ' . $nombreCliente . '
                            </td> 
                            <td class="alinearIzquierda tamanio10">
                                <b>RECIBO N°</b>
                            </td>
                            <td class="tamanio15">
                               ' . $nroRecibo . '
                            </td> 
                        </tr>
                        <tr>
                            <td class="alinearIzquierda tamanio5">
                                Dir.
                            </td> 
                            <td  class="tamanio65">
                                ' . $direccion . '
                            </td> 
                            <td class="alinearIzquierda tamanio10">
                                <b>F. registro :</b>
                            </td> 
                            <td  class="tamanio15">
                               ' . $fechaRegistro . '
                            </td>
                        </tr> 
                        <tr>
                            <td class="alinearIzquierda tamanio5">
                                F. vouch.
                            </td> 
                            <td  class="tamanio65">
                                ' . $fechaPago . '
                            </td> 
                            <td class="alinearIzquierda tamanio10">
                                <b>Periodo :</b>
                            </td> 
                            <td  class="tamanio15">
                               ' . $fechaInicio . ' - ' . $fechaFin . '
                            </td>
                        </tr> 
                        <tr>
                            <td class="alinearCentro tamanio35" colspan="3">
                                <b>Descripción</b>
                            </td> 
                            <td class="alinearCentro tamanio15">
                                <b>Precio</b>
                            </td>
                        </tr>
                        <tr>
                            <td class="tamanio35" colspan="3">
                                Servicio de WIFI
                            </td> 
                            <td class="alinearDerecha tamanio15">
                               S/ ' . $monto . '
                            </td>
                        </tr>
                        <tr>
                            <td class="alinearIzquierda tamanio35" colspan="3">
                                Son: ' . $montoLetras . '
                            </td> 
                            <td class="alinearDerecha tamanio15">
                               S/ ' . $monto . '
                            </td>
                        </tr>
                    </tbody>
                </table>            
    </main> 
</body>';


//echo $html;

$mpdf = new mPDF('c', 'A4');

$css = file_get_contents('../css/Procesos/imprimirOrdenCompra.css');
$mpdf->writeHTML($css, 1);
$mpdf->writeHTML($html, 2);
$mpdf->Output(date('d-m-Y') . '_RP-' . $correlativo . '.pdf', 'I');
