//var audio = document.getElementById("alertaAudio");
$(document).ready(function () {
    sdx.setGestion("gestionarVehiculo");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlVehiculo');
    listarVehiculos();
});

function gestionarVehiculo(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'listarVehiculos':
                responseListarVehiculos(response.data);
                break;
            case 'eliminarVehiculo':
                responseEliminarVehiculo(response.data);
                break;
        }
    }
}

function listarVehiculos() {
    sdx.setControllerFunction('listarVehiculos');
    sdx.procesar();
}

function responseListarVehiculos(data) {
    if (!isEmpty(data.tabla)) {
        $('#scroll-vert-hor').DataTable().destroy();
        $('#cuerpoTablaVehiculos').html(data.tabla);
        $('#scroll-vert-hor').DataTable({
            "language": idioma_espanol,
            dom: 'Bfrtlp',
//            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "scrollX": true,
            "order": [[0, "desc"]]
        });
    } else {
        $('#cuerpoTablaVehiculos').empty();
    }
}

function editarVehiculo(id, codigo) {
    var titulo = 'Editar';
    var url = URL_BASE + "view/Mantenedores/vehiculoForm.php?winTitulo=" + titulo + "&id=" + id + "&codigo=" + codigo;
    cargarDiv(url);
}

function mantenimiento(id, codigo) {
    var titulo = 'Mantenimiento';
    var url = URL_BASE + "view/Mantenedores/vehiculoMantenimiento.php?winTitulo=" + titulo + "&id=" + id + "&codigo=" + codigo;
    cargarDiv(url);
}

function nuevoVehiculo() {
    var url = URL_BASE + "view/Mantenedores/vehiculoForm.php";
    cargarDiv(url);
}

function abrirAlerta(id, codigo) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el vehiculo " + codigo + " !",
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarVehiculo');
            sdx.addParamTmp('id', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarVehiculo(data) {
    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        listarVehiculos();
    } else {
        swal("Error al eliminar el vehículo !", {
            icon: "error"
        });
    }
}