/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
var id = document.getElementById("id").value;
var title = document.getElementById("winTitulo").value;
var codigo = document.getElementById("codigo").value;
$(document).ready(function () {
    sdx.setGestion("gestionarVehiculoForm");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlVehiculo');
    if (id != "") {
        $('#tituloFrom').html(title + ' vehículo ' + codigo);
        obtenerConfiguracionesInicialesForm();
    }
    configurarFormulario();
});

function gestionarVehiculoForm(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesInicialesForm':
                responseObtenerConfiguracionesInicialesForm(response.data);
                loaderClose();
                break;
            case 'guardarVehiculo':
                responseGuardarVehiculo(response.data);
                loaderClose();
                break;
        }
    }
}

function obtenerConfiguracionesInicialesForm() {
    loaderShow('cargar');
    sdx.setControllerFunction('obtenerConfiguracionesInicialesForm');
    sdx.addParamTmp('id', id);
    sdx.procesar();
}

function responseObtenerConfiguracionesInicialesForm(data) {

    if (!isEmpty(id) && !isEmpty(data.dataVehiculo)) {
        asignarValorInput('txtPlaca', data.dataVehiculo[0]['placa']);
        asignarValorInput('txtMarca', data.dataVehiculo[0]['marca']);
        asignarValorInput('txtModelo', data.dataVehiculo[0]['modelo']);
        asignarValorInput('txtSerie', data.dataVehiculo[0]['serie']);
        asignarValorInput('txtKM', data.dataVehiculo[0]['km']);
    }
    if (!isEmpty(id) && !isEmpty(data.dataMantenimiento)) {

        asignarValorInput('txtKmAceiteMotor', data.dataMantenimiento[0]['km']);
        asignarValorInput('txtKmAceiteCorona', data.dataMantenimiento[1]['km']);
        asignarValorInput('txtKmBujias', data.dataMantenimiento[2]['km']);
        asignarValorInput('txtKmFrenos', data.dataMantenimiento[3]['km']);
        asignarValorInput('txtKmZapatas', data.dataMantenimiento[4]['km']);
        asignarValorInput('txtKmInyectores', data.dataMantenimiento[5]['km']);
    }
}

function guardarVehiculo() {
    var validarForm = $('#formValidate').valid();
    if (validarForm) {
        var placa = $('#txtPlaca').val();
        var marca = $('#txtMarca').val();
        var modelo = $('#txtModelo').val();
        var serie = $('#txtSerie').val();
        var km = $('#txtKM').val();

        var motor = $('#txtKmAceiteMotor').val();
        var corona = $('#txtKmAceiteCorona').val();
        var bujias = $('#txtKmBujias').val();
        var frenos = $('#txtKmFrenos').val();
        var zapatas = $('#txtKmZapatas').val();
        var inyectores = $('#txtKmInyectores').val();

        loaderShow('guardar');
        sdx.setControllerFunction('guardarVehiculo');
        sdx.addParamTmp('id', id);
        sdx.addParamTmp('placa', placa);
        sdx.addParamTmp('marca', marca);
        sdx.addParamTmp('modelo', modelo);
        sdx.addParamTmp('serie', serie);
        sdx.addParamTmp('km', km);
        sdx.addParamTmp('motor', motor);
        sdx.addParamTmp('corona', corona);
        sdx.addParamTmp('bujias', bujias);
        sdx.addParamTmp('frenos', frenos);
        sdx.addParamTmp('zapatas', zapatas);
        sdx.addParamTmp('inyectores', inyectores);
        sdx.procesar();
    }
}

function responseGuardarVehiculo(data) {
    if (data.success * 1 == 1) {
        mostrarAlerta(data.mensaje, 'green');
        regresar();
    } else {
        mostrarAlerta(data.mensaje, 'red');
    }
}

function regresar() {
    var url = URL_BASE + "view/Mantenedores/vehiculo.php";
    cargarDiv(url);
}

function configurarFormulario() {
    $("#formValidate").validate({
        rules: {
            txtPlaca: {
                required: true
            },
            txtMarca: {
                required: true
            },
            txtModelo: {
                required: true
            },
            txtKM: {
                required: true
            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            txtPlaca: {
                required: "Debe ingresar la placa"
            },
            txtMarca: {
                required: "Debe ingresar la marca"
            },
            txtModelo: {
                required: "Debe ingresar el modelo"
            },
            txtKM: {
                required: "Debe ingresar el kilometraje"
            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}

//function iniciarConfiguraciones() {
//    $(".select2").select2({
//        dropdownAutoWidth: true,
//        width: '100%',
//    });
//
//    $('.datepicker').datepicker({
//        format: 'dd/mm/yyyy',
//        autoClose: true,
//    });
//}