/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
var id = document.getElementById("id").value;
var title = document.getElementById("winTitulo").value;
var codigo = document.getElementById("codigo").value;
$(document).ready(function () {
    sdx.setGestion("gestionarVehiculoMantenimiento");
    sdx.setContainer('controlMantenedores');
    sdx.setController('ControlVehiculo');
    if (id != "") {
        $('#tituloFrom').html(title + ' - vehículo ' + codigo);
    }
    obtenerConfiguracionesMantenimiento();
    listarMantenimientos();
    configurarFormulario();
    iniciarConfiguraciones();
});

function gestionarVehiculoMantenimiento(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'obtenerConfiguracionesMantenimiento':
                responseObtenerConfiguracionesMantenimiento(response.data);
                break;
            case 'guardarMantenimiento':
                responseGuardarMantenimiento(response.data);
                loaderClose();
                break;
            case 'listarMantenimientos':
                responseListarMantenimientos(response.data);
                break;
            case 'eliminarMantenimiento':
                responseEliminarMantenimiento(response.data);
                break;
        }
    }
}

function obtenerConfiguracionesMantenimiento() {
    sdx.setControllerFunction('obtenerConfiguracionesMantenimiento');
    sdx.procesar();
}

function responseObtenerConfiguracionesMantenimiento(data) {
    if (!isEmpty(data.dataTipoMant)) {
        dibujarSelect2Form('cboTipoMantenimiento', 'valor', 'descripcion', data.dataTipoMant);
    }
}

function guardarMantenimiento() {
    var validarForm = $('#formValidate').valid();
    if (validarForm) {
        var taller = $('#txtTaller').val();
        var direccion = $('#txtDireccion').val();
        var km = $('#txtKm').val();
        var piezas = $('#txtPiezas').val();
        var tiposMantenimiento = $('#cboTipoMantenimiento').val();
        var fecha = $('#txtFechaM').val();
        var costoR = $('#txtCostoRepuestos').val();
        var costoMO = $('#txtCostoMO').val();
        loaderShow('guardar');
        sdx.setControllerFunction('guardarMantenimiento');
        sdx.addParamTmp('idVehiculo', id);
        sdx.addParamTmp('taller', taller);
        sdx.addParamTmp('direccion', direccion);
        sdx.addParamTmp('km', km);
        sdx.addParamTmp('piezas', piezas);
        sdx.addParamTmp('tiposMantenimiento', tiposMantenimiento);
        sdx.addParamTmp('fecha', fecha);
        sdx.addParamTmp('costoR', costoR);
        sdx.addParamTmp('costoMO', costoMO);
        sdx.procesar();
    }
}

function responseGuardarMantenimiento(data) {
    if (data.success * 1 == 1) {
        mostrarAlerta(data.mensaje, 'green');
        listarMantenimientos();
        limpiarFormulario();
    } else {
        mostrarAlerta(data.mensaje, 'red');
    }
}

function listarMantenimientos() {
    sdx.setControllerFunction('listarMantenimientos');
    sdx.addParamTmp('idVehiculo', id);
    sdx.procesar();
}

function responseListarMantenimientos(data) {
    if (!isEmpty(data)) {
        $('#scroll-vert-hor').DataTable().destroy();
        $('#cuerpoTablaMant').html(data.tabla);
        $('#scroll-vert-hor').DataTable({
            "language": idioma_espanol,
            dom: 'Bfrtlp',
//            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "scrollX": true
        });

        $('#totalCMO').html(parseFloat(data.totalCR).toFixed(2));
        $('#totalCR').html(parseFloat(data.totalCMO).toFixed(2));
        $('#totalVehiculo').html(parseFloat((data.totalCR * 1) + (data.totalCMO * 1)).toFixed(2));
    } else {
        $('#cuerpoTablaMant').empty();
    }
}

function abrirAlerta(id) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el registro !",
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarMantenimiento');
            sdx.addParamTmp('id', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarMantenimiento(data) {

    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        listarMantenimientos();
    } else {
        swal("Error al eliminar el vehículo !", {
            icon: "error"
        });
    }
}

function limpiarFormulario() {
    asignarValorInput('txtTaller', '');
    asignarValorInput('txtDireccion', '');
    asignarValorInput('txtKm', '');
    asignarValorInput('txtPiezas', '');
    asignarValorDatepicker('txtFechaM', '');
    asignarValorInput('txtCostoRepuestos', '');
    asignarValorInput('txtCostoMO', '');
    asignarValorSelect2('cboTipoMantenimiento', null);
}

function regresar() {
    var url = URL_BASE + "view/Mantenedores/vehiculo.php";
    cargarDiv(url);
}

function configurarFormulario() {
    $("#formValidate").validate({
        rules: {
            txtTaller: {
                required: true
            },
            txtDireccion: {
                required: true
            },
            txtKm: {
                required: true
            },
            txtPiezas: {
                required: true
            },
            txtFechaM: {
                required: true
            },
            txtCostoRepuestos: {
                required: true
            },
            txtCostoMO: {
                required: true
            },
            cboTipoMantenimiento: {
                required: true
            },
            tnc_select: "required",
        },
        //For custom messages
        messages: {
            txtTaller: {
                required: "Debe ingresar el taller"
            },
            txtDireccion: {
                required: "Debe ingresar la dirección"
            },
            txtKm: {
                required: "Debe ingresar el kilometraje"
            },
            txtPiezas: {
                required: "Debe ingresar las piezas"
            },
            txtFechaM: {
                required: "Debe ingresar la fecha"
            },
            txtCostoRepuestos: {
                required: "Debe ingresar el costo de repuestos"
            },
            txtCostoMO: {
                required: "Debe ingresar el costo de la mano de obra"
            },
            cboTipoMantenimiento: {
                required: "Seleccionar el tipo de mantenimiento"
            },
            curl: "Enter your website",
        },
        errorElement: 'div',
        errorPlacement: function (error, element) {
            var placement = $(element).data('error');
            if (placement) {
                $(placement).append(error);
            } else {
                error.insertAfter(element);
            }
        }
    });
}

function iniciarConfiguraciones() {
    $('.select2-size-sm').select2({
        dropdownAutoWidth: true,
        width: '100%',
        containerCssClass: 'select-sm'
    });

    $('.datepicker').datepicker({
        format: 'dd/mm/yyyy',
        autoClose: true,
    });
}