var divPDF = document.getElementById('divPDF');
$(document).ready(function () {
    sdx.setGestion("gestionarControlPago");
    sdx.setContainer('controlProcesos');
    sdx.setController('ControlControlPago');
    listarPagos();
});

function gestionarControlPago(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'listarPagos':
                responseListarPagos(response.data);
                break;
            case 'eliminarPago':
                responseEliminarPago(response.data);
                break;
        }
    }
}

function listarPagos() {
    sdx.setControllerFunction('listarPagos');
    sdx.procesar();
}

function responseListarPagos(data) {
    if (!isEmpty(data)) {
        $('#page-length-option').DataTable().destroy();
        $('#cuerpoTablaPago').html(data);
        $('#page-length-option').DataTable({
            "language": idioma_espanol,
            "dom": "<'row' <'form-inline' "
                    + "<'col-sm-6 col-md-6 col-lg-6'B>"
                    + "<'col-sm-6 col-md-6 col-lg-6'f>>>"
                    + "<rt>"
                    + "<'row'<'form-inline'"
                    + "<'col-sm-6 col-md-6 col-lg-6'l>"
                    + "<'col-sm-6 col-md-6 col-lg-6'p>>>",
            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
        });
    } else {
        $('#cuerpoTablaPago').empty();
    }
}

function abrirAlertaEliminar(id) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el pago !",
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarPago');
            sdx.addParamTmp('idPago', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarPago(data) {
    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        listarPagos();
    } else {
        swal("Error al eliminar pago !", {
            icon: "error"
        });
    }
}

function imprimirRecibo(id) {

    swal({
        title: "Generando recibo !",
        text: "Cargando...",
        timer: 4000,
        closeOnClickOutside: false,
        buttons: false
    });
    divPDF.style.display = "block";
    var url = URL_BASE + 'view/Procesos/imprimirReciboPago.php?id=' + id;
    var pdf = '<embed src="' + url + '" type="application/pdf"  style="width: 100%; height:650px;"></embed>';
    $('#pdfEmbebido').html(pdf);
}

function cerrarPdf() {
    divPDF.style.display = "none";
}

function irNuevoPago() {
    var url = URL_BASE + "view/Procesos/controlPagoForm.php";
    cargarDiv(url);
}

function editarPago(id) {
    var titulo = 'Editar';
    var url = URL_BASE + "view/Procesos/controlPagoForm.php?winTitulo=" + titulo + "&id=" + id;
    cargarDiv(url);
}