
$(document).ready(function () {
    sdx.setGestion("gestionarUsuario");
    sdx.setContainer('controlSeguridad');
    sdx.setController('ControlUsuario');
    mostrarUsuarios();
});

function gestionarUsuario(response) {
    if (response.status === 'ok') {
        switch (response[PARAM_ACCION_NAME]) {
            case 'mostrarUsuarios':
                responseMostrarUsuarios(response.data);
                break;
            case 'eliminarUsuario':
                responseEliminarUsuario(response.data);
                break;
        }
    }
}

function mostrarUsuarios() {
    sdx.setControllerFunction('mostrarUsuarios');
    sdx.procesar();
}

function responseMostrarUsuarios(data) {
    if (!isEmpty(data)) {
        $('#page-length-option').DataTable().destroy();
        $('#cuerpoTablaUsuario').html(data);
        $('#page-length-option').DataTable({
            "language": idioma_espanol,
            "dom": "<'row' <'form-inline' "
                    + "<'col-sm-6 col-md-6 col-lg-6'B>"
                    + "<'col-sm-6 col-md-6 col-lg-6'f>>>"
                    + "<rt>"
                    + "<'row'<'form-inline'"
                    + "<'col-sm-6 col-md-6 col-lg-6'l>"
                    + "<'col-sm-6 col-md-6 col-lg-6'p>>>",
            "responsive": true,
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ]
        });
    } else {
        $('#cuerpoTablaUsuario').empty();
    }
}

function abrirAlertaEliminar(id, usuario) {
    swal({
        title: "¿Estás seguro?",
        text: "Se eliminara el usuario " + usuario,
        icon: 'warning',
        buttons: {
            cancel: true,
            delete: 'Si, eliminar'
        }
    }).then(function (willDelete) {
        if (willDelete) {
            sdx.setControllerFunction('eliminarUsuario');
            sdx.addParamTmp('id', id);
            sdx.procesar();
        } else {
            swal.close();
        }
    });
}

function responseEliminarUsuario(data) {
    if (data.respuesta == 1) {
        swal(data.mensaje, {
            icon: "success"
        });
        mostrarUsuarios();
    } else {
        swal("Error al eliminar el cronograma !", {
            icon: "error"
        });
    }
}

function abrirNuevoUsuario() {
    var url = URL_BASE + "view/Seguridad/usuarioForm.php";
    cargarDiv(url);
}

function editarUsuario(id) {
    var titulo = 'Editar';
    var url = URL_BASE + "view/Seguridad/usuarioForm.php?winTitulo=" + titulo + "&id=" + id;
    cargarDiv(url);
}

